/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.app;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteshrtrain.InteSchemeCollection;
import com.kingdee.shr.inteshrtrain.InteSchemeConfigInfo;
import com.kingdee.shr.inteshrtrain.InteSchemeFactory;
import com.kingdee.shr.inteshrtrain.InteSchemeInfo;
import com.kingdee.shr.inteshrtrain.InteShrTrainException;
import com.kingdee.shr.inteshrtrain.InteTrainCourseCollection;
import com.kingdee.shr.inteshrtrain.InteTrainCourseFactory;
import com.kingdee.shr.inteshrtrain.InteTrainCourseInfo;
import com.kingdee.shr.inteshrtrain.InteTrainModelMappingCollection;
import com.kingdee.shr.inteshrtrain.InteTrainModelMappingFactory;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelCollection;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelFactory;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelInfo;
import com.kingdee.shr.inteshrtrain.app.AbstractInteTrainFacadeControllerBean;
import com.kingdee.shr.inteshrtrain.app.IntePattern;
import com.kingdee.shr.inteshrtrain.app.RequestArea;
import com.kingdee.shr.inteshrtrain.app.RequestKey;
import com.kingdee.shr.inteshrtrain.app.RequestType;
import com.kingdee.shr.inteshrtrain.app.TrainContentType;
import com.kingdee.shr.inteshrtrain.app.TrainLearningStatus;
import com.kingdee.shr.inteshrtrain.service.InteShrTrainService;
import com.kingdee.shr.inteshrtrain.service.SyncAdminOrgModelFactory;
import com.kingdee.shr.inteshrtrain.service.SyncPersonModelFactory;
import com.kingdee.shr.inteshrtrain.service.SyncPositionModelFactory;
import com.kingdee.shr.inteshrtrain.util.HttpClientUtils;
import com.kingdee.shr.inteshrtrain.util.InteShrUtil;
import com.kingdee.shr.inteshrtrain.util.JSONHelper;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class InteTrainFacadeControllerBean
extends AbstractInteTrainFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.inteshrtrain.app.InteTrainFacadeControllerBean");
    private static ThreadLocal<Integer> coursePageCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };

    @Override
    protected void _scheduleDealInteTrainData(Context ctx) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"InteTrainFacadeControllerBean._scheduleDealInteTrainData: start ");
        }
        try {
            this.getInteTrainCourse(ctx);
            this.sendInteDefeatBefore(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void getInteTrainCourse(Context ctx) throws EASBizException, BOSException, SQLException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"InteTrainFacadeControllerBean.getInteTrainCourse: start ");
        }
        InteSchemeInfo schemeInfo = null;
        String oql = "where isUsing = 1";
        InteSchemeCollection schemeInfoColl = InteSchemeFactory.getLocalInstance(ctx).getInteSchemeCollection(oql);
        if (schemeInfoColl != null && schemeInfoColl.size() > 0) {
            schemeInfo = schemeInfoColl.get(0);
            InteSchemeConfigInfo configInfo = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), RequestArea.EMPLOYEE, RequestKey.GETTRAINDETAIL);
            if (configInfo != null && configInfo.isIsStart() && !schemeInfo.getIntePattern().equals((Object)IntePattern.PUSHONLY)) {
                String userOql = "where isSealOrDelete = 0 and reqArea = '1' and inteScheme = '" + schemeInfo.getId() + "'";
                InteTrainModelMappingCollection mappingColl = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(userOql);
                for (int m = 0; m < mappingColl.size(); ++m) {
                    coursePageCount.set(1);
                    String userid = mappingColl.get(m).getMappingId();
                    String personId = mappingColl.get(m).getDataId().toString();
                    for (int i = 1; i <= coursePageCount.get(); ++i) {
                        boolean result = this.startGetInteTrainCourse(ctx, schemeInfo, configInfo, userid, personId, i);
                        if (result || !logger.isInfoEnabled()) continue;
                        logger.info((Object)"InteTrainFacadeControllerBean.getInteTrainCourse-sync course defeat");
                    }
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)"InteTrainFacadeControllerBean.getInteTrainCourse-The synchronization interface is not configured or enabled");
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)"InteTrainFacadeControllerBean.getInteTrainCourse-The integration scheme is not enabled");
        }
    }

    protected boolean startGetInteTrainCourse(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, String userid, String personId, int page) throws EASBizException, BOSException, SQLException {
        boolean result = false;
        String url = configInfo.getInterfaceUrl();
        String token = InteShrTrainService.getInstance().getToken(ctx, schemeInfo);
        if (StringUtils.isEmpty((String)token)) {
            return false;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("access_token", token);
        param.put("userid", userid);
        param.put("page", String.valueOf(page));
        param.put("pageSize", "50");
        Map<String, String> dataStrMap = HttpClientUtils.doGet(url, param);
        String dataStr = dataStrMap.get("resultString");
        if ("401".equals(dataStrMap.get("statusCode"))) {
            InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
            InteShrTrainService.getInstance().getToken(ctx, schemeInfo);
            this.startGetInteTrainCourse(ctx, schemeInfo, configInfo, userid, personId, page);
        } else {
            if ("500".equals(dataStrMap.get("statusCode"))) {
                InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
                throw new InteShrTrainException(InteShrTrainException.SERVER_NOT_AVAILABLE);
            }
            if (!StringUtils.isEmpty((String)dataStr)) {
                boolean isSuccess;
                String targetCode = configInfo.getSuccessKey();
                String code = JSONHelper.getTargetString(dataStr, targetCode);
                boolean bl = isSuccess = "0".equals(code);
                if (isSuccess) {
                    JsonObject jo = new JsonParser().parse(dataStr).getAsJsonObject();
                    if (page == 1) {
                        int totalPages = jo.get("pageCount").getAsInt();
                        coursePageCount.set(totalPages);
                    }
                    JsonArray arry = jo.get("results").getAsJsonArray();
                    for (JsonElement je : arry) {
                        JsonArray trainContentArray = je.getAsJsonObject().get("trainContent").getAsJsonArray();
                        for (JsonElement je2 : trainContentArray) {
                            JsonObject courseJo = je2.getAsJsonObject();
                            if (courseJo == null || courseJo.get("courseid") == null || courseJo.get("courseid").isJsonNull()) continue;
                            InteTrainCourseInfo courseInfo = new InteTrainCourseInfo();
                            String courseid = courseJo.get("courseid") == null || courseJo.get("courseid").isJsonNull() ? "" : courseJo.get("courseid").getAsString();
                            String contentName = courseJo.get("contentName") == null || courseJo.get("contentName").isJsonNull() ? "" : courseJo.get("contentName").getAsString();
                            String learningStatus = courseJo.get("learningStatus") == null || courseJo.get("learningStatus").isJsonNull() ? "" : courseJo.get("learningStatus").getAsString();
                            String contentType = courseJo.get("contentType") == null || courseJo.get("contentType").isJsonNull() ? "" : courseJo.get("contentType").getAsString();
                            courseInfo.setCourseid(courseid);
                            courseInfo.setContentName(contentName);
                            JsonObject detailJson = null;
                            if (courseJo.get("detail").isJsonObject()) {
                                detailJson = courseJo.getAsJsonObject("detail");
                            }
                            if (detailJson != null) {
                                String courseName = detailJson.get("courseName") == null || detailJson.get("courseName").isJsonNull() ? "" : detailJson.get("courseName").getAsString();
                                String startLearningTime = detailJson.get("startLearningTime") == null || detailJson.get("startLearningTime").isJsonNull() ? "" : detailJson.get("startLearningTime").getAsString();
                                String completionTime = detailJson.get("completionTime") == null || detailJson.get("completionTime").isJsonNull() ? "" : detailJson.get("completionTime").getAsString();
                                String learningTime = detailJson.get("learningTime") == null || detailJson.get("learningTime").isJsonNull() ? "" : detailJson.get("learningTime").getAsString();
                                String chapterNumber = detailJson.get("chapterNumber") == null || detailJson.get("chapterNumber").isJsonNull() ? "" : detailJson.get("chapterNumber").getAsString();
                                String score = detailJson.get("score") == null || detailJson.get("score").isJsonNull() ? "" : detailJson.get("score").getAsString();
                                String getPoint = detailJson.get("getPoint") == null || detailJson.get("getPoint").isJsonNull() ? "" : detailJson.get("getPoint").getAsString();
                                String courseGrade = detailJson.get("courseGrade") == null || detailJson.get("courseGrade").isJsonNull() ? "" : detailJson.get("courseGrade").getAsString();
                                String lecturerGrade = detailJson.get("lecturerGrade") == null || detailJson.get("lecturerGrade").isJsonNull() ? "" : detailJson.get("lecturerGrade").getAsString();
                                String relationExamId = detailJson.get("relationExamId") == null || detailJson.get("relationExamId").isJsonNull() ? "" : detailJson.get("relationExamId").getAsString();
                                String relationExam = detailJson.get("relationExam") == null || detailJson.get("relationExam").isJsonNull() ? "" : detailJson.get("relationExam").getAsString();
                                String relationExamScore = detailJson.get("relationExamScore") == null || detailJson.get("relationExamScore").isJsonNull() ? "" : detailJson.get("relationExamScore").getAsString();
                                courseInfo.setCourseName(courseName);
                                courseInfo.setStartLearningTime(startLearningTime);
                                courseInfo.setCompletionTime(completionTime);
                                courseInfo.setLearningTime(learningTime);
                                courseInfo.setChapterNumber(chapterNumber);
                                courseInfo.setScore(score);
                                courseInfo.setGetPoint(getPoint);
                                courseInfo.setCourseGrade(courseGrade);
                                courseInfo.setLecturerGrade(lecturerGrade);
                                courseInfo.setRelationExamId(relationExamId);
                                courseInfo.setRelationExam(relationExam);
                                courseInfo.setRelationExamScore(relationExamScore);
                            }
                            if (courseInfo == null || !contentType.equals("course") || !learningStatus.equals("2")) continue;
                            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                            courseInfo.setPerson(person);
                            courseInfo.setContentType(TrainContentType.COURSE);
                            courseInfo.setLearningStatus(TrainLearningStatus.FINISHED);
                            String oql = "where courseid = '" + courseInfo.getCourseid() + "' and person = '" + personId + "'";
                            InteTrainCourseCollection courseOldColl = InteTrainCourseFactory.getLocalInstance(ctx).getInteTrainCourseCollection(oql);
                            if (courseOldColl != null && courseOldColl.size() > 0) {
                                courseInfo.setId(courseOldColl.get(0).getId());
                            }
                            InteTrainCourseFactory.getLocalInstance(ctx).save((CoreBaseInfo)courseInfo);
                        }
                    }
                    result = true;
                }
            }
        }
        return result;
    }

    protected void sendInteDefeatBefore(Context ctx) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"InteTrainFacadeControllerBean.sendInteDefeatBefore: start ");
        }
        InteTrainWaitModelCollection coll = InteTrainWaitModelFactory.getLocalInstance(ctx).getInteTrainWaitModelCollection();
        for (int i = 0; i < coll.size(); ++i) {
            InteTrainWaitModelInfo info = coll.get(i);
            InteSchemeInfo schemeInfo = info.getScheme();
            if (schemeInfo == null || !schemeInfo.isIsUsing()) continue;
            if (info.getSyncNum() < 3) {
                if (info.getDataOperate() == RequestType.DELETE) {
                    HashSet<String> deleteSet = new HashSet<String>();
                    deleteSet.add(info.getDataId().toString());
                    InteShrTrainService.getInstance().syncTrainDataForDelete(ctx, schemeInfo, info.getReqArea(), deleteSet, false);
                    continue;
                }
                if (info.getDataOperate() != RequestType.OTHER && info.getDataOperate() != RequestType.ADD) continue;
                RequestArea ra = info.getReqArea();
                InteSchemeConfigInfo configInfoForUpdate = null;
                IRowSet resultSet = null;
                if (RequestArea.ADMINORG.equals((Object)ra)) {
                    configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEADMINORG);
                    resultSet = this.beforeScheduleSyncData(ctx, info, configInfoForUpdate);
                    if (resultSet == null) continue;
                    SyncAdminOrgModelFactory syncAdminModelFactory = new SyncAdminOrgModelFactory();
                    syncAdminModelFactory.getSyncModelDataInstance().syncTrainDataForOther(ctx, schemeInfo, ra, resultSet);
                    continue;
                }
                if (RequestArea.POSITION.equals((Object)ra)) {
                    configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEPOSITION);
                    resultSet = this.beforeScheduleSyncData(ctx, info, configInfoForUpdate);
                    if (resultSet == null) continue;
                    SyncPositionModelFactory syncPositionModelFactory = new SyncPositionModelFactory();
                    syncPositionModelFactory.getSyncModelDataInstance().syncTrainDataForOther(ctx, schemeInfo, ra, resultSet);
                    continue;
                }
                if (!RequestArea.EMPLOYEE.equals((Object)ra) || (resultSet = this.beforeScheduleSyncData(ctx, info, configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEPERSON))) == null) continue;
                SyncPersonModelFactory syncPersonModelFactory = new SyncPersonModelFactory();
                syncPersonModelFactory.getSyncModelDataInstance().syncTrainDataForOther(ctx, schemeInfo, ra, resultSet);
                continue;
            }
            InteTrainWaitModelFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    protected IRowSet beforeScheduleSyncData(Context ctx, InteTrainWaitModelInfo info, InteSchemeConfigInfo configInfoForUpdate) throws BOSException {
        MetaDataPK query = MetaDataPK.create((String)configInfoForUpdate.getQueryName());
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        IRowSet resultSet = null;
        if (info != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getDataId(), CompareType.EQUALS));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            resultSet = exec.executeQuery();
        }
        return resultSet;
    }
}

