/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.inteshrtrain.InitSyncTaskFactory;
import com.kingdee.shr.inteshrtrain.InitSyncTaskInfo;
import com.kingdee.shr.inteshrtrain.InteSchemeCollection;
import com.kingdee.shr.inteshrtrain.InteSchemeFactory;
import com.kingdee.shr.inteshrtrain.InteSchemeInfo;
import com.kingdee.shr.inteshrtrain.InteShrTrainException;
import com.kingdee.shr.inteshrtrain.app.InitSyncEnum;
import com.kingdee.shr.inteshrtrain.service.InitSyncExecutorPool;
import com.kingdee.shr.inteshrtrain.service.InitSyncModelTaskExecutor;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InitSyncTaskManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.inteshrtrain.service.InitSyncTaskManager");
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private InitSyncExecutorPool excutorPool = new InitSyncExecutorPool();
    private static InitSyncTaskManager instance = new InitSyncTaskManager();

    private InitSyncTaskManager() {
    }

    public static InitSyncTaskManager getInstance() {
        return instance;
    }

    public InitSyncExecutorPool getExcutorPool() {
        return this.excutorPool;
    }

    public boolean startNewInitSyncTask(Context ctx, String schemeId) throws EASBizException, BOSException {
        boolean result = false;
        BlockingQueue<Runnable> waitThreadQueue = this.excutorPool.getQueue();
        InitSyncModelTaskExecutor executor = this.createExecutor(ctx, schemeId);
        int waitSize = waitThreadQueue.size();
        if (waitSize <= 50) {
            this.excutorPool.execute(executor);
            this.excutorPool.addTaskNumberToList(executor.getTask().getNumber());
            result = true;
        }
        return result;
    }

    public InitSyncModelTaskExecutor createExecutor(Context ctx, String schemeId) throws EASBizException, BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InitSyncTaskManager.createExecutor-schemeId: " + schemeId));
        }
        try {
            String lbTrainTask3;
            String taskName = lbTrainTask3 = SHRServerResource.getString((String)"com.kingdee.shr.inteshrtrain.properties.inteShrTrainResource", (String)"lbTrainTask3", (Context)ctx);
            String oql = "where isUsing = 1 and id = '" + schemeId + "'";
            InteSchemeCollection schemeInfoColl = null;
            InteSchemeInfo schemeInfo = null;
            try {
                schemeInfoColl = InteSchemeFactory.getLocalInstance(ctx).getInteSchemeCollection(oql);
                if (schemeInfoColl == null || schemeInfoColl.size() <= 0) {
                    throw new InteShrTrainException(InteShrTrainException.SCHEME_NOT_START);
                }
                schemeInfo = schemeInfoColl.get(0);
                taskName = taskName + ": " + schemeInfo.getName();
            }
            catch (BOSException e) {
                throw new InteShrTrainException(InteShrTrainException.SCHEME_FAILED);
            }
            String mark = System.currentTimeMillis() + (long)new SecureRandom().nextInt(100) + "";
            String taskId = "InitSync" + mark;
            InitSyncTaskInfo task = new InitSyncTaskInfo();
            task.setScheme(schemeInfo);
            task.setName(taskName + mark);
            task.setNumber(taskId);
            task.setState(InitSyncEnum.SAVE);
            InitSyncTaskFactory.getLocalInstance(ctx).save((CoreBaseInfo)task);
            InitSyncModelTaskExecutor excutor = new InitSyncModelTaskExecutor(ctx, schemeId, task);
            return excutor;
        }
        catch (EASBizException e) {
            throw new InteShrTrainException(InteShrTrainException.INTETASK_FAILED);
        }
    }

    public void removeWaitTask() {
    }

    public void shutdownCus() {
        if (this.excutorPool != null && !this.excutorPool.isShutdown()) {
            this.excutorPool.shutdown();
            try {
                if (!this.excutorPool.awaitTermination(120L, TimeUnit.SECONDS)) {
                    this.excutorPool.shutdownNow();
                    if (!this.excutorPool.awaitTermination(120L, TimeUnit.SECONDS)) {
                        logger.info((Object)"Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.excutorPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

