/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.util;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.inteshrtrain.util.MyX509TrustManager;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String ENCRYPTMORE = "WXYAQKD";

    public static Map<String, String> doGet(String url) throws BOSException {
        return HttpClientUtils.doGet(url, null);
    }

    public static Map<String, String> doGet(String url, Map<String, String> param) throws BOSException {
        String paramStr = param == null ? "" : param.toString();
        byte[] paramByte = paramStr.getBytes();
        String baseParam = ENCRYPTMORE + Base64.encodeBase64String((byte[])paramByte);
        logger.error("HttpClientUtils.doGet-param: " + baseParam);
        HashMap<String, String> resultMap = new HashMap();
        CloseableHttpClient httpclient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpclient.execute((HttpUriRequest)httpGet);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> doPost(String url) throws BOSException {
        return HttpClientUtils.doPost(url, null);
    }

    public static Map<String, String> doPost(String url, Map<String, String> param) throws BOSException {
        String paramStr = param == null ? "" : param.toString();
        byte[] paramByte = paramStr.getBytes();
        String baseParam = ENCRYPTMORE + Base64.encodeBase64String((byte[])paramByte);
        logger.error("HttpClientUtils.doPost-param: " + baseParam);
        HashMap<String, String> resultMap = new HashMap();
        CloseableHttpClient httpClient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, Charset.forName("UTF-8"));
                httpPost.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> doPost(String url, String json, Map<String, String> token_header) throws BOSException {
        String paramStr = json == null ? "" : json.toString();
        byte[] paramByte = paramStr.getBytes();
        String baseParam = ENCRYPTMORE + Base64.encodeBase64String((byte[])paramByte);
        logger.error("HttpClientUtils.doPost-json: " + baseParam);
        HashMap<String, String> resultMap = new HashMap();
        CloseableHttpClient httpClient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        URI uri = null;
        String token = "";
        try {
            if (token_header != null) {
                URIBuilder builder = new URIBuilder(url);
                if (token_header != null) {
                    for (String key : token_header.keySet()) {
                        builder.addParameter(key, token_header.get(key));
                    }
                }
                uri = builder.build();
            }
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader("HTTP Method", "POST");
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
            httpPost.setHeader("x-authentication-token", token);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(json, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json;charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> doPut(String url) {
        return HttpClientUtils.doPut(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> doPut(String url, Map<String, String> param) {
        if (logger.isInfoEnabled()) {
            logger.info("HttpClientUtils.doPut-param: " + param == null ? "" : param.toString());
        }
        Map<String, String> resultMap = new HashMap<String, String>();
        CloseableHttpClient httpClient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, Charset.forName("UTF-8"));
                httpPut.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPut);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> doPut(String url, String json, Map<String, String> token_header) throws BOSException {
        if (logger.isInfoEnabled()) {
            logger.info("HttpClientUtils.doPut-json: " + json);
        }
        HashMap<String, String> resultMap = new HashMap();
        CloseableHttpClient httpClient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        URI uri = null;
        String token = "";
        try {
            if (token_header != null) {
                URIBuilder builder = new URIBuilder(url);
                if (token_header != null) {
                    for (String key : token_header.keySet()) {
                        builder.addParameter(key, token_header.get(key));
                    }
                }
                uri = builder.build();
            }
            HttpPut httpPut = new HttpPut(uri);
            httpPut.setHeader("Content-type", "application/json");
            httpPut.setHeader("HTTP Method", "PUT");
            httpPut.setHeader("Connection", "Keep-Alive");
            httpPut.setHeader("Content-Type", "application/json;charset=utf-8");
            httpPut.setHeader("x-authentication-token", token);
            StringEntity stringEntity = new StringEntity(json, Charset.forName("UTF-8"));
            httpPut.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPut);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> doDelete(String url, Map<String, String> param) throws BOSException {
        if (logger.isInfoEnabled()) {
            logger.info("HttpClientUtils.doDelete-param: " + param.toString());
        }
        HashMap<String, String> resultMap = new HashMap();
        CloseableHttpClient httpClient = HttpClientUtils.createClientDefault(url);
        CloseableHttpResponse response = null;
        URI uri = null;
        try {
            HttpDelete httpDelete = new HttpDelete(uri);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    httpDelete.setHeader(entry.getKey(), entry.getValue());
                }
            }
            response = httpClient.execute((HttpUriRequest)httpDelete);
            resultMap = HttpClientUtils.generateReturn(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> generateReturn(CloseableHttpResponse response) throws ParseException, IOException {
        String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        byte[] paramByte = resultStr.getBytes();
        String baseParam = ENCRYPTMORE + Base64.encodeBase64String((byte[])paramByte);
        logger.error("HttpClientUtils.generateReturn-resultStr" + baseParam);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int statcusCode = response.getStatusLine().getStatusCode();
        resultMap.put("statusCode", String.valueOf(statcusCode));
        resultMap.put("resultString", "");
        if (response.getStatusLine().getStatusCode() == 200) {
            resultMap.put("resultString", resultStr);
        }
        return resultMap;
    }

    public static CloseableHttpClient createClientDefault(String url) {
        SSLContext sslcontext;
        CloseableHttpClient client = HttpClients.createDefault();
        if (url.startsWith("https") && (sslcontext = HttpClientUtils.createEasySSLContext()) != null) {
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        }
        return client;
    }

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, new TrustManager[]{new MyX509TrustManager()}, null);
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum HttpMethod {
        POST,
        DELETE,
        GET,
        PUT,
        HEAD;

    }
}

