/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.ml.CodeCheckCollection;
import com.kingdee.shr.ml.CodeCheckExcludeCollection;
import com.kingdee.shr.ml.CodeCheckExcludeInfo;
import com.kingdee.shr.ml.CodeCheckFactory;
import com.kingdee.shr.ml.CodeCheckInfo;
import com.kingdee.shr.ml.app.AbstractCodeCheckExcludeControllerBean;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class CodeCheckExcludeControllerBean
extends AbstractCodeCheckExcludeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.CodeCheckExcludeControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK[] codeCheckPks) throws BOSException, EASBizException {
        CodeCheckCollection codeCheckCollection = this.getCodeCheckCollection(ctx, codeCheckPks);
        CodeCheckExcludeCollection collection = new CodeCheckExcludeCollection();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < codeCheckCollection.size(); ++i) {
            CodeCheckInfo codeCheckInfo = codeCheckCollection.get(i);
            String path = codeCheckInfo.getFileFullPath().replace("\\", "/");
            CodeCheckExcludeInfo info = new CodeCheckExcludeInfo();
            info.setProjectName(codeCheckInfo.getProjectName());
            info.setFileFullPath(path);
            info.setType(codeCheckInfo.getType());
            info.setContext(codeCheckInfo.getContext());
            info.setKey(codeCheckInfo.getKey());
            info.setSqlContainMulti(codeCheckInfo.isSqlContainMulti());
            String strHashCode = String.valueOf((path + codeCheckInfo.getKey()).hashCode());
            info.setUniqueKey(strHashCode);
            info.setCreateTime(timestamp);
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            collection.add(info);
        }
        this._addnewBatchData(ctx, (IObjectCollection)collection);
        CodeCheckFactory.getLocalInstance(ctx).deleteBatchData(codeCheckPks);
    }

    private CodeCheckCollection getCodeCheckCollection(Context ctx, IObjectPK[] codeCheckPks) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("projectName"));
        sic.add(new SelectorItemInfo("fileFullPath"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("context"));
        sic.add(new SelectorItemInfo("key"));
        sic.add(new SelectorItemInfo("sqlContainMulti"));
        StringBuilder idStr = new StringBuilder();
        for (IObjectPK pks : codeCheckPks) {
            idStr.append(",").append(pks.toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr.substring(1), CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(sic);
        return CodeCheckFactory.getLocalInstance(ctx).getCodeCheckCollection(entityViewInfo);
    }
}

