/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.ShrSubSystemUtil;
import com.kingdee.shr.ml.MlFieldCheckInfo;
import com.kingdee.shr.ml.app.AbstractMlFieldCheckControllerBean;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class MlFieldCheckControllerBean
extends AbstractMlFieldCheckControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.MlFieldCheckControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _scan(Context ctx) throws BOSException, EASBizException {
        DefaultKingdeeTreeNode node = ShrSubSystemUtil.getSubSystem((String)"com_kingdee_eas_base_subsystemEntity", (String)"com.kingdee.eas.hr");
        if (null == node) {
            return;
        }
        String truncateSql = "truncate table T_HR_MlFieldCheck";
        DbUtil.execute((Context)ctx, (String)truncateSql);
        StringBuffer sb = new StringBuffer();
        sb.append("TableName|En|Zh|Tw|SubSystem|EntityFullName|TableExists|FieldExists|BigObject\n");
        this.initData(ctx, node, sb);
        if (!StringUtils.isEmpty((String)sb.toString())) {
            File f = new File(SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"multiLan.txt"));
            if (f.exists()) {
                f.delete();
            }
            FileOutputStream out = null;
            try {
                f.createNewFile();
                out = new FileOutputStream(f);
                out.write(sb.toString().getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void initData(Context ctx, DefaultKingdeeTreeNode node, StringBuffer sb) throws EASBizException, BOSException {
        if (DefaultMutableTreeNode.EMPTY_ENUMERATION.equals(node.children())) {
            MetaDataBriefInfo cm = (MetaDataBriefInfo)node.getUserObject();
            DefaultKingdeeTreeNode pd = (DefaultKingdeeTreeNode)node.getParent();
            EntityObjectInfo bo = BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)cm.getBOType());
            if (bo.isAbstract()) {
                return;
            }
            DataTableInfo dt = bo.getTable();
            if (null == dt) {
                return;
            }
            boolean tabExistsInDB = this.isTabExistsInDB(ctx, dt.getName());
            boolean fieldExistsInDB = true;
            boolean isBigObject = false;
            MetaDataBriefInfo ppp = (MetaDataBriefInfo)pd.getUserObject();
            int total = bo.getPropertiesRuntime().size();
            for (int i = 0; i < total; ++i) {
                DataType type;
                OwnPropertyInfo op;
                ColumnInfo ci;
                PropertyInfo p = bo.getPropertiesRuntime().get(i);
                if (!(p instanceof OwnPropertyInfo) || null == (ci = (op = (OwnPropertyInfo)p).getMappingField()) || DataType.BOSUUID.equals((Object)(type = op.getDataType())) || DataType.ENUM.equals((Object)type) || "number".equalsIgnoreCase(op.getName()) || "id".endsWith(op.getName()) || "ID".endsWith(op.getName()) || "iD".endsWith(op.getName()) || "Id".endsWith(op.getName())) continue;
                if (!ci.isMultilingual() && (SQLType.NVARCHAR.equals((Object)ci.getTypeName()) || SQLType.VARCHAR.equals((Object)ci.getTypeName()) || SQLType.CLOB.equals((Object)ci.getTypeName()) || SQLType.NCLOB.equals((Object)ci.getTypeName()))) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("entityFullName", (Object)cm.getFullName()));
                    filter.getFilterItems().add(new FilterItemInfo("propertyName", (Object)op.getName()));
                    filter.getFilterItems().add(new FilterItemInfo("fieldName", (Object)ci.getName()));
                    MlFieldCheckInfo obj = new MlFieldCheckInfo();
                    obj.setSubSystem(ppp.getPackgeName());
                    obj.setEntityName(cm.getAlias());
                    obj.setEntityFullName(cm.getFullName());
                    obj.setIsDynamic(bo.isDynamic());
                    obj.setTableName(dt.getAlias());
                    obj.setTableFullName(dt.getFullName());
                    obj.setPropertyAlias(op.getAlias());
                    obj.setPropertyName(op.getName());
                    obj.setPropertyType(op.getDataType().getAlias());
                    obj.setIsConfigured(op.isConfigured());
                    obj.setFieldAlias(ci.getAlias());
                    obj.setFieldName(ci.getName());
                    obj.setFieldType(ci.getTypeName().getAlias());
                    if (!tabExistsInDB) {
                        obj.setMessage("table not exists in DB.");
                    } else {
                        this.scanContainZh(ctx, dt.getName(), ci.getName(), obj, ci.getTypeName());
                    }
                    this._save(ctx, (IObjectValue)obj);
                    continue;
                }
                if (!ci.isMultilingual()) continue;
                fieldExistsInDB = this.isFieldExistsInDB(ctx, dt.getName(), ci.getName());
                isBigObject = SQLType.CLOB.equals((Object)ci.getTypeName()) || SQLType.NCLOB.equals((Object)ci.getTypeName());
                sb.append(dt.getName()).append("|").append(ci.getName()).append("_L1|").append(ci.getName()).append("_L2|").append(ci.getName()).append("_L3|").append(ppp.getPackgeName()).append("|").append(cm.getFullName()).append("|").append(tabExistsInDB).append("|").append(fieldExistsInDB).append("|").append(isBigObject).append("\n");
            }
            return;
        }
        Enumeration es = node.children();
        while (es.hasMoreElements()) {
            this.initData(ctx, (DefaultKingdeeTreeNode)es.nextElement(), sb);
        }
    }

    private boolean isTabExistsInDB(Context ctx, String tabName) throws BOSException {
        String sql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tabName + "'";
        return this.isExists(ctx, sql);
    }

    private boolean isFieldExistsInDB(Context ctx, String tabName, String fieldName) throws BOSException {
        String sql = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + fieldName + "_L1' and KSQL_COL_TABNAME='" + tabName + "'";
        return this.isExists(ctx, sql);
    }

    private boolean isExists(Context ctx, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void scanContainZh(Context ctx, String tableName, String fieldName, MlFieldCheckInfo obj, SQLType sqlType) {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(fieldName).append(" from ").append(tableName);
        boolean isContainZh = false;
        String message = "\u8be5\u5b57\u6bb5\u53ef\u80fd\u5b58\u653e\u4e2d\u6587\uff0c\u9700\u786e\u8ba4\u3002";
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                Clob c;
                String rs0 = "";
                if (SQLType.VARCHAR.equals((Object)sqlType)) {
                    rs0 = rs.getString(fieldName);
                } else if (SQLType.NVARCHAR.equals((Object)sqlType)) {
                    rs0 = rs.getNString(fieldName);
                } else if (SQLType.CLOB.equals((Object)sqlType)) {
                    c = rs.getClob(fieldName);
                    rs0 = null != c ? c.toString() : "";
                } else if (SQLType.NCLOB.equals((Object)sqlType)) {
                    c = rs.getNClob(fieldName);
                    rs0 = null != c ? c.toString() : "";
                }
                isContainZh = MLUtils.containChinese((String)rs0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            message = e.getMessage();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            message = e.getMessage();
        }
        if (isContainZh) {
            message = "this field store Zh_CN, please make sure modify.";
            obj.setIsContainZh(true);
            obj.setMessage(message);
        } else {
            obj.setIsContainZh(false);
            obj.setMessage(message);
        }
    }
}

