/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.service.impl.AbstractSHRWebPageResourceParser;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.output.XMLOutputter;

public class UIViewSHRWebPageResourceParser
extends AbstractSHRWebPageResourceParser {
    private static Logger logger = Logger.getLogger(UIViewSHRWebPageResourceParser.class);
    IUIView iUIView;
    private Set<String> zhAttributes;

    public UIViewSHRWebPageResourceParser(Context ctx, Map params, ResourceType resourceType) throws BOSException {
        super(ctx, params, resourceType);
        this.iUIView = UIViewFactory.getLocalInstance((Context)ctx);
        this.zhAttributes = new HashSet<String>();
        try {
            String excludes;
            Properties p = SHRSyssettingUtil.getPropertiesFileByPath((String)SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"MultiLan_Config.properties"));
            if (null != p && null != p.get("EXCLUDE_ATTRIBUTES") && !StringUtils.isEmpty((String)(excludes = (String)p.get("EXCLUDE_ATTRIBUTES")))) {
                for (String str : excludes.split(",")) {
                    if (StringUtils.isEmpty((String)str)) continue;
                    this.zhAttributes.add(str.trim());
                }
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void parseEachElement(Map existWords, String uipk, Element parentElement, List<ResourceInfo> list0, boolean isConvert, int j) throws BOSException {
        List list = parentElement.getContent();
        if (list.size() <= 0) {
            return;
        }
        Object object = null;
        Element currentElement = null;
        Text text = null;
        int total = list.size();
        for (int i = 0; i < total; ++i) {
            object = list.get(i);
            if (object instanceof Text) {
                text = object;
                if (StringUtils.isEmpty((String)text.getTextTrim())) continue;
                this.parseTextElementMultiLanguage(text, parentElement, existWords, uipk, list0, isConvert, j);
                continue;
            }
            if (!(object instanceof Element)) continue;
            currentElement = object;
            this.parseAttributeElementMultiLanguage(currentElement, parentElement, existWords, uipk, list0, isConvert);
            this.parseEachElement(existWords, uipk, currentElement, list0, isConvert, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseTextElementMultiLanguage(Text text, Element parentElement, Map existWords, String uipk, List<ResourceInfo> list0, boolean isConvert, int j) {
        if (text instanceof CDATA) {
            if (!parentElement.getName().equals("tips")) return;
            String textStr = text.getTextTrim();
            String regEx = "<|>";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(textStr);
            String[] words = p.split(textStr);
            if (words.length <= 0) return;
            StringBuilder textSb = new StringBuilder();
            int wordIndex = 0;
            for (int count = 0; count < words.length; ++count) {
                if (MLUtils.containChinese((String)words[count])) {
                    String realKey = this.getShrHtmlTextXPath(parentElement, j) + "_" + wordIndex;
                    String key = this.getMD5Key(realKey);
                    if (isConvert) {
                        String transValue = (String)existWords.get(key);
                        if (!StringUtils.isEmpty((String)transValue)) {
                            textSb.append(transValue.replace("'", "\\\\''"));
                        } else {
                            textSb.append(words[count]);
                        }
                    } else {
                        ResourceInfo ri = this.generateResourceInfo(key, uipk, parentElement.getName(), existWords, words[count]);
                        if (ri != null) {
                            list0.add(ri);
                        }
                    }
                    ++wordIndex;
                } else {
                    textSb.append(words[count]);
                }
                if (!m.find()) continue;
                textSb.append(m.group());
            }
            if (!isConvert) return;
            text.setText(textSb.toString());
            return;
        } else {
            boolean isZh = MLUtils.containChinese((String)text.getTextTrim());
            if (!isZh) return;
            String realKey = this.getShrHtmlTextXPath(parentElement, j);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("uipk:{0},realKey:{1},value:{2}", uipk, realKey, text.getTextTrim()));
            }
            String key = this.getMD5Key(realKey);
            if (isConvert) {
                String transValue = (String)existWords.get(key);
                if (StringUtils.isEmpty((String)transValue)) return;
                text.setText(transValue);
                return;
            } else {
                ResourceInfo ri = this.generateResourceInfo(key, uipk, parentElement.getName(), existWords, text.getTextTrim());
                if (ri == null) return;
                list0.add(ri);
            }
        }
    }

    private void parseAttributeElementMultiLanguage(Element currentElement, Element parentElement, Map existWords, String uipk, List<ResourceInfo> list0, boolean isConvert) {
        List<Attribute> attributesZh = this.getAttributeContainZh(currentElement);
        if (attributesZh == null || attributesZh.size() <= 0) {
            return;
        }
        String xPath = this.getXPath(currentElement);
        String key = null;
        String realKey = null;
        String comm = "'";
        for (Attribute attr : attributesZh) {
            String v0;
            realKey = this.getAttributeXPath(xPath, attr);
            String value = attr.getValue().trim();
            JSONObject json = null;
            JSONArray jsonArray = null;
            if (value.indexOf("\"") > -1) {
                comm = "\"";
            }
            try {
                json = JSONObject.fromObject((Object)value);
            }
            catch (Exception e) {
                json = null;
                try {
                    jsonArray = JSONArray.fromObject((Object)value);
                }
                catch (Exception e1) {
                    jsonArray = null;
                }
            }
            if (json != null && json.size() > 0) {
                this.uiviewJsonObjectConfigParse(currentElement, uipk, json, realKey, list0, isConvert, existWords);
                if (!isConvert) continue;
                v0 = json.toString();
                if (!"\"".equals(comm)) {
                    v0 = v0.replace("\"", "'");
                }
                attr.setValue(v0);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)MessageFormat.format("realKey:{0},value_before:{1},value_after:{2}", realKey, value, v0));
                continue;
            }
            if (jsonArray != null && jsonArray.size() > 0) {
                this.uiviewJsonArrayConfigParse(currentElement, uipk, jsonArray, realKey, list0, isConvert, existWords);
                if (!isConvert) continue;
                v0 = jsonArray.toString();
                if (!"\"".equals(comm)) {
                    v0 = v0.replace("\"", "'");
                }
                attr.setValue(v0);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)MessageFormat.format("realKey:{0},value_before:{1},value_after:{2}", realKey, value, v0));
                continue;
            }
            key = this.getMD5Key(realKey);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("key:{0},uipk:{1},realKey:{2},value:{3}", key, uipk, realKey, value));
            }
            if (isConvert) {
                String transValue = (String)existWords.get(key);
                if (StringUtils.isEmpty((String)transValue)) continue;
                attr.setValue(transValue);
                continue;
            }
            ResourceInfo ri = this.generateResourceInfo(key, uipk, parentElement.getName(), existWords, attr.getValue());
            if (ri == null) continue;
            list0.add(ri);
        }
    }

    private void uiviewJsonObjectConfigParse(Element e, String uipk, JSONObject json, String xpath, List<ResourceInfo> list0, boolean isConvert, Map existWords) {
        Set jsonSet = json.keySet();
        String realXPath = null;
        for (String key0 : jsonSet) {
            realXPath = MessageFormat.format("{0}.{1}", xpath, key0);
            if (json.get(key0) instanceof String) {
                this.uiviewJsonConfigStringParse(e, uipk, (String)json.get(key0), key0, json, realXPath, list0, isConvert, existWords);
                continue;
            }
            if (json.get(key0) instanceof JSONObject) {
                this.uiviewJsonObjectConfigParse(e, uipk, (JSONObject)json.get(key0), realXPath, list0, isConvert, existWords);
                continue;
            }
            if (!(json.get(key0) instanceof JSONArray)) continue;
            this.uiviewJsonArrayConfigParse(e, uipk, (JSONArray)json.get(key0), realXPath, list0, isConvert, existWords);
        }
    }

    private void uiviewJsonConfigStringParse(Element e, String uipk, String jsonEachValue, String key0, JSONObject json, String xpath, List<ResourceInfo> list0, boolean isConvert, Map existWords) {
        if (!StringUtils.isEmpty((String)jsonEachValue) && MLUtils.containChinese((String)jsonEachValue)) {
            String key = this.getMD5Key(xpath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("uiview json trans key:{0},uipk:{1},xpath:{2}", key, uipk, xpath));
            }
            if (isConvert) {
                String transValue = (String)existWords.get(key);
                if (!StringUtils.isEmpty((String)transValue)) {
                    json.put((Object)key0, (Object)transValue);
                }
            } else {
                ResourceInfo ri = this.generateResourceInfo(key, uipk, e.getName(), existWords, jsonEachValue);
                if (ri != null) {
                    list0.add(ri);
                }
            }
        }
    }

    private void uiviewJsonArrayConfigParse(Element e, String uipk, JSONArray jsonArray, String xpath, List<ResourceInfo> list0, boolean isConvert, Map existWords) {
        if (null == jsonArray || jsonArray.size() <= 0) {
            return;
        }
        String realXPath = null;
        int total = jsonArray.size();
        for (int i = 0; i < total; ++i) {
            realXPath = MessageFormat.format("{0}.[{1}]", xpath, i);
            if (jsonArray.get(i) instanceof JSONObject) {
                this.uiviewJsonObjectConfigParse(e, uipk, (JSONObject)jsonArray.get(i), realXPath, list0, isConvert, existWords);
                continue;
            }
            if (!(jsonArray.get(i) instanceof JSONArray)) continue;
            this.uiviewJsonArrayConfigParse(e, uipk, (JSONArray)jsonArray.get(i), realXPath, list0, isConvert, existWords);
        }
    }

    private String getAttributeXPath(String xPath, Attribute attr) {
        StringBuffer sb = new StringBuffer();
        sb.append(xPath).append(".").append(attr.getName());
        return sb.toString();
    }

    private String getShrHtmlTextXPath(Element ele, int i) {
        String xPath = this.getXPath(ele);
        StringBuffer sb = new StringBuffer();
        sb.append(xPath).append(".").append("shrHtmlText[").append(i).append("]");
        return sb.toString();
    }

    private String getXPath(Element ele) {
        Element elee = ele;
        ArrayList<String> xpathList = new ArrayList<String>();
        while (elee.getParentElement() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(elee.getName());
            List attributes0 = elee.getAttributes();
            if (null == attributes0 || attributes0.size() <= 0) {
                xpathList.add(sb.toString());
                elee = elee.getParentElement();
                continue;
            }
            for (Attribute attr0 : attributes0) {
                if (this.zhAttributes.contains(attr0.getName())) continue;
                if (MLUtils.containChinese((String)attr0.getValue())) {
                    if (this.getZHAttributesOthers().contains(attr0.getName())) continue;
                    this.getZHAttributesOthers().add(attr0.getName());
                    continue;
                }
                sb.append("[@").append(attr0.getName()).append("='").append(attr0.getValue()).append("']");
            }
            xpathList.add(sb.toString());
            elee = elee.getParentElement();
        }
        StringBuffer xPath = new StringBuffer();
        xPath.append("\\").append(ele.getDocument().getRootElement().getName());
        for (int j = xpathList.size() - 1; j >= 0; --j) {
            xPath.append("\\").append((String)xpathList.get(j));
        }
        return xPath.toString();
    }

    private List<Attribute> getAttributeContainZh(Element ele) {
        List attributes = ele.getAttributes();
        if (null == attributes || attributes.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Attribute> attributesZh = new ArrayList<Attribute>();
        for (Attribute attr : attributes) {
            boolean isZh = MLUtils.containChinese((String)attr.getValue());
            if (!isZh) continue;
            attributesZh.add(attr);
        }
        return attributesZh;
    }

    @Override
    protected List<ResourceInfo> dealResorces(String fileName, Map existWords) throws EASBizException, BOSException {
        UIViewInfo uiViewInfo = this.iUIView.getValueByUipk(fileName, SysSettingUIViewUtil.getUIViewSelector());
        if (uiViewInfo == null) {
            logger.error((Object)MessageFormat.format(" can not find uipk : {0}", fileName));
            return null;
        }
        String text = null;
        text = !StringUtils.isEmpty((String)uiViewInfo.getExtend()) ? uiViewInfo.getExtend() : uiViewInfo.getContent();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        ArrayList<ResourceInfo> list0 = new ArrayList<ResourceInfo>();
        try {
            Document doc = XMLUtil.parseXML((String)text);
            Element rootElement = doc.getRootElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("---------------------------------------------begin parseEachElement dealResorces uipk:{0}---------------------------------------------", fileName));
            }
            this.parseEachElement(existWords, fileName, rootElement, list0, false, 0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("---------------------------------------------end parseEachElement dealResorces uipk:{0}---------------------------------------------", fileName));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list0;
    }

    @Override
    protected List<String> getFileNames() throws BOSException {
        List<Object> uipks = null;
        Object p = this.getParams().get("uipks");
        Object p0 = this.getParams().get("isConvert");
        if (null != p0 && ((Boolean)p0).booleanValue()) {
            uipks = new ArrayList<String>();
            uipks.add((String)p);
            return uipks;
        }
        if (null != p) {
            if (p instanceof List) {
                uipks = (List)p;
            } else if (p instanceof String) {
                uipks = Arrays.asList(p.toString().split(","));
            }
        }
        if (null == uipks || uipks.size() <= 0) {
            uipks = new ArrayList();
            String sql = "SELECT T0.FUIPK FROM S_BS_UIVIEW T0";
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
            try {
                while (rs.next()) {
                    uipks.add(rs.getString("FUIPK"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return uipks;
    }

    @Override
    protected Object dealMulConvert(String fileName, Map mlWords) throws EASBizException, BOSException {
        UIViewInfo uiViewInfo = this.iUIView.getValueByUipk(fileName, SysSettingUIViewUtil.getUIViewSelector());
        if (uiViewInfo == null) {
            return uiViewInfo;
        }
        String text = null;
        text = !StringUtils.isEmpty((String)uiViewInfo.getExtend()) ? uiViewInfo.getExtend() : uiViewInfo.getContent();
        if (StringUtils.isEmpty((String)text)) {
            return uiViewInfo;
        }
        try {
            XMLOutputter output = XMLUtil.getXMLOutputter();
            Document doc = XMLUtil.parseXML((String)text);
            Element rootElement = doc.getRootElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("---------------------------------------------begin parseEachElement dealMulConvert uipk:{0}---------------------------------------------", fileName));
            }
            this.parseEachElement(mlWords, fileName, rootElement, null, true, 0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("---------------------------------------------end parseEachElement dealMulConvert uipk:{0}---------------------------------------------", fileName));
            }
            if (!StringUtils.isEmpty((String)uiViewInfo.getExtend())) {
                uiViewInfo.setExtend(output.outputString(doc));
            } else {
                uiViewInfo.setContent(output.outputString(doc));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return uiViewInfo;
    }
}

