/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.ShrSubSystemUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class TableAndFieldTools {
    private Context ctx;

    public TableAndFieldTools(Context ctx) {
        this.ctx = ctx;
    }

    public void doCheck() throws BOSException {
        DefaultKingdeeTreeNode node = ShrSubSystemUtil.getSubSystem((String)"com_kingdee_eas_base_subsystemEntity", (String)"com.kingdee.eas.hr");
        HashSet<String> shrTables = new HashSet<String>();
        TableAndFieldTools.getShrTables(this.ctx, node, shrTables);
        String sql = "SELECT FTABLENAME, FFIELDNAME_L1, FFIELDNAME_L3 FROM T_RES_MULTIFIELDMETA";
        IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)sql);
        StringBuilder en_US = new StringBuilder();
        StringBuilder zh_TW = new StringBuilder();
        StringBuilder tableNE = new StringBuilder();
        StringBuilder tableFieldNE_en = new StringBuilder();
        StringBuilder tableFieldNE_zh = new StringBuilder();
        boolean en = false;
        boolean zh = false;
        try {
            while (rs.next()) {
                String tableName = rs.getString("FTABLENAME");
                String field1 = rs.getString("FFIELDNAME_L1");
                String field3 = rs.getString("FFIELDNAME_L3");
                if (!shrTables.contains(tableName.toLowerCase())) continue;
                String tableSql = "select count(*) from " + tableName;
                String fieldSql_en = "select top 1 " + field1 + " from " + tableName;
                String fieldSql_zh = "select top 1 " + field3 + " from " + tableName;
                try {
                    DBUtil.executeQuery((Context)this.ctx, (String)tableSql);
                }
                catch (BOSException e) {
                    tableNE.append(tableName).append("\n");
                    continue;
                }
                try {
                    DBUtil.executeQuery((Context)this.ctx, (String)fieldSql_en);
                    en = true;
                }
                catch (BOSException e) {
                    tableFieldNE_en.append(tableName).append(".").append(field1).append("\n");
                    en = false;
                }
                try {
                    DBUtil.executeQuery((Context)this.ctx, (String)fieldSql_zh);
                    zh = true;
                }
                catch (BOSException e) {
                    tableFieldNE_zh.append(tableName).append(".").append(field3).append("\n");
                    zh = false;
                }
                if (en) {
                    en_US.append("UPDATE ").append(tableName).append(" SET ").append(field1).append(" = null;\n");
                }
                if (!zh) continue;
                zh_TW.append("UPDATE ").append(tableName).append(" SET ").append(field3).append(" = null;\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_en_US", en_US, "en_US");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_tableFieldNE_en", tableFieldNE_en, "en_US");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_tableNE", tableNE, "en_US");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_zh_TW", zh_TW, "zh_TW");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_tableFieldNE_zh", tableFieldNE_zh, "zh_TW");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), "clear_tableNE", tableNE, "zh_TW");
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Set<String> getShrTablesBySubSystemEntity(Context ctx) {
        DefaultKingdeeTreeNode node = ShrSubSystemUtil.getSubSystem((String)"com_kingdee_eas_base_subsystemEntity", (String)"com.kingdee.eas.hr");
        HashSet<String> shrTables = new HashSet<String>();
        TableAndFieldTools.getShrTables(ctx, node, shrTables);
        return shrTables;
    }

    private static void getShrTables(Context ctx, DefaultKingdeeTreeNode node, Set<String> shrTables) {
        if (!node.isLeaf()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode nextElement = (DefaultKingdeeTreeNode)children.nextElement();
                TableAndFieldTools.getShrTables(ctx, nextElement, shrTables);
            }
        } else {
            MetaDataBriefInfo userObject = (MetaDataBriefInfo)node.getUserObject();
            TableAndFieldTools.addSqlContent(ctx, shrTables, userObject);
        }
    }

    private static void addSqlContent(Context ctx, Set<String> shrTables, MetaDataBriefInfo userObject) {
        EntityObjectInfo eo = BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)userObject.getBOType());
        if (eo.getBOSType() == null) {
            return;
        }
        if (eo.isAbstract()) {
            return;
        }
        DataTableInfo dt = eo.getTable();
        if (dt == null) {
            return;
        }
        shrTables.add(dt.getName().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genFile(String iotmpdir, String tableName, StringBuilder content, String displayName) throws IOException {
        File f;
        String file = iotmpdir + File.separator + displayName + File.separator + tableName + ".sql";
        File dir = new File(iotmpdir + File.separator + displayName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(file)).exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        FilterOutputStream bo = null;
        try {
            f.createNewFile();
            fo = new FileOutputStream(f);
            bo = new BufferedOutputStream(fo);
            bo.write(content.toString().getBytes());
            ((BufferedOutputStream)bo).flush();
        }
        finally {
            try {
                if (bo != null) {
                    bo.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fo != null) {
                    fo.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

