/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.monitor.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.MSFServiceUtil;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.shr.monitor.SHRWebAccessLogFactory;
import com.kingdee.shr.monitor.service.SHRWebAccessLogManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class AccessLogConsumerThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(AccessLogConsumerThread.class);
    private long interval = -1L;
    private boolean stopped = false;
    private boolean daemon = true;
    private Map<String, Context> datacenterMap = new ConcurrentHashMap<String, Context>();

    public AccessLogConsumerThread(SHRWebAccessLogManager logManager, long interval) {
        this.interval = interval;
        this.parseDC();
    }

    protected final void scan() {
        Map<String, ConcurrentLinkedQueue<Map<String, String>>> udpateQueue = SHRWebAccessLogManager.getLogMap();
        Iterator<Map.Entry<String, ConcurrentLinkedQueue<Map<String, String>>>> iter = udpateQueue.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                Map.Entry<String, ConcurrentLinkedQueue<Map<String, String>>> entry = iter.next();
                Context ctx = this.datacenterMap.get(entry.getKey());
                ConcurrentLinkedQueue<Map<String, String>> queue = entry.getValue();
                for (Map<String, String> item : queue) {
                    SHRWebAccessLogFactory.getLocalInstance(ctx).writeLog(item);
                    queue.poll();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseDC() {
        ArrayList dcList = new ArrayList();
        try {
            dcList = DCManager.getInstance().getDCList();
        }
        catch (Exception e) {
            logger.error((Object)("FaRebuildViewService.newList = " + e.getMessage()));
        }
        for (int i = 0; i < dcList.size(); ++i) {
            try {
                DCInfo info = (DCInfo)dcList.get(i);
                Context ctx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                ctx.setUserName(info.getUserName());
                ctx.put((Object)"dbType", (Object)MSFServiceUtil.getDBType((int)info.getDBType()));
                this.datacenterMap.put(ctx.getAIS(), ctx);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("init service config  lose = " + e.getMessage()));
            }
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "SHR-WEB-AccessLog");
        t.setDaemon(this.daemon);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"SHR Accesslog thread start watching ");
        AccessLogConsumerThread accessLogConsumerThread = this;
        synchronized (accessLogConsumerThread) {
            while (!this.stopped) {
                long now;
                long until = System.currentTimeMillis() + this.interval;
                while (!this.stopped && until > (now = System.currentTimeMillis())) {
                    try {
                        this.wait(until - now);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopped) continue;
                this.scan();
            }
        }
    }
}

