/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.monitor.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.monitor.service.AccessLogConsumerThread;
import com.kingdee.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SHRWebAccessLogManager {
    static SHRWebAccessLogManager instance = null;
    private static Map<String, ConcurrentLinkedQueue<Map<String, String>>> dcMap = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Map<String, String>>>();

    private SHRWebAccessLogManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SHRWebAccessLogManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SHRWebAccessLogManager> clazz = SHRWebAccessLogManager.class;
        synchronized (SHRWebAccessLogManager.class) {
            instance = new SHRWebAccessLogManager();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        AccessLogConsumerThread consumer = new AccessLogConsumerThread(this, 5000L);
        consumer.start();
    }

    public static Map<String, ConcurrentLinkedQueue<Map<String, String>>> getLogMap() {
        Map<String, ConcurrentLinkedQueue<Map<String, String>>> tempMap = dcMap;
        dcMap = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Map<String, String>>>();
        return tempMap;
    }

    public static void addLog(Context ctx, String remoteAddr, String uri, String method, Long startTime) {
        long endTime = System.currentTimeMillis();
        ConcurrentLinkedQueue<Map<String, String>> serviceLog = dcMap.get(ctx.getAIS());
        if (serviceLog == null) {
            serviceLog = new ConcurrentLinkedQueue();
            dcMap.put(ctx.getAIS(), serviceLog);
        } else {
            if (serviceLog.size() > 5000) {
                serviceLog.clear();
            }
            ConcurrentHashMap<String, String> accessItem = new ConcurrentHashMap<String, String>();
            if (StringUtils.isEmpty((String)remoteAddr)) {
                remoteAddr = "";
            }
            if (StringUtils.isEmpty((String)uri)) {
                uri = "";
            }
            if (StringUtils.isEmpty((String)method)) {
                method = "initalize";
            }
            if (!StringUtils.isEmpty((String)remoteAddr)) {
                accessItem.put("remoteAddr", remoteAddr);
            }
            accessItem.put("uri", uri);
            accessItem.put("method", method);
            accessItem.put("startTime", String.valueOf(startTime));
            accessItem.put("endTime", String.valueOf(endTime));
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (null != userInfo && userInfo.getId() != null) {
                accessItem.put("userId", userInfo.getId().toString());
            }
            serviceLog.add(accessItem);
        }
    }
}

