/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.formula.evaluator.aviator;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.formula.evaluator.FunctionAttribute;
import com.kingdee.shr.base.formula.evaluator.IShrFormulaEvaluator;
import com.kingdee.shr.base.formula.evaluator.aviator.LoadShrFunctions;
import com.kingdee.shr.base.formula.evaluator.aviator.ShrAbstractFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.IsNullFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.LeftFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.PickStrFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.RightFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.SubLeftFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.SubRightFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisJobGradeIndexFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisJobGradeNameFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisJobLevelIndexFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisJobLevelNameFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisPersonNumberFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.HisPositionNameFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.IsDownHierarchyFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.IsMyRoleFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.IsPersonRoleFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.IsUpHierarchyFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyJobGradeIndexFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyJobGradeNameFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyJobLevelIndexFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyJobLevelNameFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyPersonNumberFunction;
import com.kingdee.shr.base.formula.evaluator.aviator.function.person.MyPositionNameFunction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShrAviatorEvaluator
implements IShrFormulaEvaluator {
    protected Context ctx;
    protected LoadShrFunctions loadShrFunctions;
    private static volatile ShrAviatorEvaluator instance = null;

    private ShrAviatorEvaluator(Context ctx) {
        this.ctx = ctx;
        this.loadShrFunctions = new LoadShrFunctions(ctx);
        this.loadFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShrAviatorEvaluator getInstance(Context ctx) {
        if (null != instance) return instance;
        Class<ShrAviatorEvaluator> clazz = ShrAviatorEvaluator.class;
        synchronized (ShrAviatorEvaluator.class) {
            if (null != instance) return instance;
            instance = new ShrAviatorEvaluator(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Map getFunData() {
        LinkedHashMap<String, List<FunctionAttribute>> resultMap = new LinkedHashMap<String, List<FunctionAttribute>>();
        resultMap.put("fun", this.loadShrFunctions.shrGroupFunList);
        return resultMap;
    }

    @Override
    public void verify(String expression) {
        AviatorEvaluator.getInstance().validate(expression);
    }

    @Override
    public Object execute(String expression) {
        return AviatorEvaluator.getInstance().execute(expression);
    }

    protected void loadFunction() {
        this.addFunction(new LeftFunction());
        this.addFunction(new RightFunction());
        this.addFunction(new SubLeftFunction());
        this.addFunction(new SubRightFunction());
        this.addFunction(new IsNullFunction());
        this.addFunction(new PickStrFunction());
        this.addFunction(new MyPersonNumberFunction());
        this.addFunction(new MyJobGradeNameFunction());
        this.addFunction(new MyJobLevelNameFunction());
        this.addFunction(new MyPositionNameFunction());
        this.addFunction(new HisPersonNumberFunction());
        this.addFunction(new HisJobGradeNameFunction());
        this.addFunction(new HisJobLevelNameFunction());
        this.addFunction(new HisPositionNameFunction());
        this.addFunction(new IsUpHierarchyFunction());
        this.addFunction(new IsDownHierarchyFunction());
        this.addFunction(new IsMyRoleFunction());
        this.addFunction(new IsPersonRoleFunction());
        this.addFunction(new HisJobGradeIndexFunction());
        this.addFunction(new HisJobLevelIndexFunction());
        this.addFunction(new MyJobGradeIndexFunction());
        this.addFunction(new MyJobLevelIndexFunction());
    }

    @Override
    public Object execute(String expression, Map<String, Object> env) {
        return AviatorEvaluator.getInstance().execute(expression, env);
    }

    @Override
    public Object execute(String expression, Map<String, Object> env, boolean cached) {
        return AviatorEvaluator.getInstance().execute(expression, env, cached);
    }

    @Override
    public Expression getCompileExperssion(String expression) {
        return AviatorEvaluator.getInstance().compile(expression);
    }

    public void addFunction(ShrAbstractFunction function) {
        AviatorEvaluator.addFunction((AviatorFunction)function);
        FunctionAttribute functionAttribute = new FunctionAttribute(function.getName(), function.getTitle(), function.getLongTitle(), function.getParam(), function.getDescr(), function.getType());
        functionAttribute.setHideParam(function.getHideParam());
        this.loadShrFunctions.addFunction(this.ctx, functionAttribute);
    }

    @Override
    public String transforTextToExpression(String text) {
        List<FunctionAttribute> funList = this.loadShrFunctions.shrGroupFunList;
        for (FunctionAttribute shrGroupFunList : funList) {
            for (FunctionAttribute function : shrGroupFunList.getChildren()) {
                String title = null != function.getLongTitle() ? function.getLongTitle() : function.getTitle();
                text = text.replaceAll(title + "(\\s+)?\\(", function.getName() + "(" + (null != function.getHideParam() ? function.getHideParam() : ""));
            }
        }
        text = text.replace("\u5e76\u4e14", "&&");
        text = text.replace("\u6216\u8005", "||");
        text = text.replace("\u5982\u679c", "if");
        text = text.replace("\u5426\u5219", "else");
        text = text.replace("\u8fd4\u56de", "return");
        text = text.replace("\u662f", "true");
        text = text.replace("\u5426", "false");
        return text;
    }
}

