/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.api.service.rule;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.permission.api.service.SHRDataPermissionModel;
import com.kingdee.shr.base.permission.api.service.rule.AbstractDataPermissionCheckRule;
import com.kingdee.shr.base.permission.api.service.rule.BUDataPermCheckRule;
import com.kingdee.shr.base.permission.api.service.rule.IDataPermissionCheckRule;
import com.kingdee.shr.base.permission.api.service.rule.OUAndBUOrBUAndDUDataPermCheckRule;
import com.kingdee.shr.base.permission.api.service.rule.OUDataPermCheckRule;
import com.kingdee.shr.base.permission.api.service.rule.OUOrDUDataPermCheckRule;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataPermCheckRuleHelper {
    public static List<SHRDataPermissionModel> getHaveDataPermList(Context ctx, String userId, String permItemId, List<SHRDataPermissionModel> model) {
        Set<String> orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        Set<String> hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemId);
        return DataPermCheckRuleHelper.getDataPermCheckRuleInstance(model).getHaveDataPermList(orgSet, hrOrgSet, model);
    }

    public static List<SHRDataPermissionModel> getNoDataPermList(Context ctx, String userId, String permItemId, List<SHRDataPermissionModel> model) {
        Set<String> orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        Set<String> hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemId);
        return DataPermCheckRuleHelper.getDataPermCheckRuleInstance(model).getNoDataPermList(orgSet, hrOrgSet, model);
    }

    public static Map<String, List<SHRDataPermissionModel>> check(Context ctx, String userId, String permItemId, List<SHRDataPermissionModel> model) {
        Set<String> orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        Set<String> hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemId);
        return DataPermCheckRuleHelper.getDataPermCheckRuleInstance(model).check(orgSet, hrOrgSet, model);
    }

    public static IDataPermissionCheckRule getDataPermCheckRuleInstance(List<SHRDataPermissionModel> model) {
        AbstractDataPermissionCheckRule checkRuleInstance = new OUAndBUOrBUAndDUDataPermCheckRule();
        if (null == model || model.isEmpty()) {
            return checkRuleInstance;
        }
        SHRDataPermissionModel model0 = model.get(0);
        String checkRule = model0.getCheckRule();
        if ("OU".equalsIgnoreCase(checkRule)) {
            checkRuleInstance = new OUDataPermCheckRule();
        } else if ("BU".equalsIgnoreCase(checkRule)) {
            checkRuleInstance = new BUDataPermCheckRule();
        } else if ("OUORDU".equalsIgnoreCase(checkRule)) {
            checkRuleInstance = new OUOrDUDataPermCheckRule();
        }
        return checkRuleInstance;
    }

    private DataPermCheckRuleHelper() {
    }
}

