/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ExpFilterConfigInfo;
import com.kingdee.shr.base.permission.ExpFilterStateEnum;
import com.kingdee.shr.base.permission.ExpTypeEnum;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.app.AbstractExpFilterConfigControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class ExpFilterConfigControllerBean
extends AbstractExpFilterConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.ExpFilterConfigControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.doState(ctx, id, ExpFilterStateEnum.Enable);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.doState(ctx, id, ExpFilterStateEnum.disable);
    }

    private void doState(Context ctx, String id, ExpFilterStateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            throw new ShrPermissionException(ShrPermissionException.PARAM_ID_NOTALLOW_NULL);
        }
        ExpFilterConfigInfo model = this.getExpFilterConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (ExpFilterStateEnum.Enable.equals((Object)state)) {
            if (ExpFilterStateEnum.Enable.equals((Object)model.getState())) {
                throw new ShrPermissionException(ShrPermissionException.NOT_RE_ENABLE);
            }
        } else {
            if (ExpFilterStateEnum.disable.equals((Object)model.getState())) {
                throw new ShrPermissionException(ShrPermissionException.NOT_RE_DISABLE);
            }
            if (ExpFilterStateEnum.UnEnable.equals((Object)model.getState())) {
                throw new ShrPermissionException(ShrPermissionException.NOT_ALLOW_ENABLE);
            }
        }
        ExpFilterConfigInfo info = new ExpFilterConfigInfo();
        info.setId(model.getId());
        info.setState(state);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this._updatePartial(ctx, (IObjectValue)info, selector);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.checkData(ctx, model);
        return super._save(ctx, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ExpFilterConfigInfo info = (ExpFilterConfigInfo)model;
        if (!ExpTypeEnum.AdvanceFilterExp.equals((Object)info.getExpType())) {
            String expHandler = info.getExpHandler();
            if (StringUtils.isEmpty((String)expHandler)) {
                throw new ShrPermissionException(ShrPermissionException.EXP_HANDLER_IS_NULL);
            }
            if ("com.kingdee.shr.base.syssetting.permission.expfilter.impl.PermissionExpFilterService".equals(expHandler)) {
                throw new ShrPermissionException(ShrPermissionException.EXP_HANDLER_ERROR);
            }
            if (!this.isExtendIPermissionExpFilterService(expHandler)) {
                throw new ShrPermissionException(ShrPermissionException.MUST_IMPL_INTERFACE);
            }
        }
        if (null == info.getUiview() || null == info.getUiview().getId()) {
            throw new ShrPermissionException(ShrPermissionException.UIVIEW_NOT_ALLOW_NULL);
        }
    }

    private boolean isExtendIPermissionExpFilterService(String expHandler) {
        Boolean isExtendIPerm = false;
        try {
            Class bizImplClassType = MsfClassLoaderFactory.forName((String)expHandler);
            Class<?>[] interfaces = bizImplClassType.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i].getName();
                if (!interfaceName.equals("com.kingdee.shr.base.syssetting.permission.expfilter.IPermissionExpFilterService")) continue;
                isExtendIPerm = true;
                break;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            isExtendIPerm = false;
        }
        return isExtendIPerm;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExpFilterConfigInfo model = this.getExpFilterConfigInfo(ctx, pk);
        if (!ExpFilterStateEnum.UnEnable.equals((Object)model.getState())) {
            throw new ShrPermissionException(ShrPermissionException.NOT_ALLOW_DELETE);
        }
        super._delete(ctx, pk);
    }
}

