/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.base.permission.FieldPermFactory;
import com.kingdee.shr.base.permission.FieldPermInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.app.AbstractFieldPermControllerBean;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FieldPermControllerBean
extends AbstractFieldPermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.FieldPermControllerBean");

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.EQUALS));
        String existsSql = "SELECT field.fid FROM T_HR_FieldPermConfigEntry entry JOIN T_HR_FieldPermConfig config on entry.FFIELDPERMCONFIGID = config.FID\nJOIN T_HR_FieldPerm field on entry.FFIELDFLAG = field.FFIELD and config.fmodel = field.FMODEL\nWHERE config.FmodelType = 100 and field.fid = '" + pk + "'";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)existsSql, CompareType.NOTEXISTS));
        super.delete(ctx, filterInfo);
    }

    @Override
    protected void _addFields(Context ctx, String data) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)data)) {
            HashMap dataMap = JSONUtils.convertJsonToObject((Context)ctx, (String)data);
            if (null != dataMap && null != dataMap.get("dataArr")) {
                List dataList = (List)dataMap.get("dataArr");
                CoreBaseCollection fieldPermCollection = new CoreBaseCollection();
                this.addFieldPermToCollection(ctx, dataList, fieldPermCollection);
                FieldPermFactory.getLocalInstance(ctx).saveBatchData(fieldPermCollection);
            } else {
                throw new ShrPermissionException(ShrPermissionException.PARAM_ERROR);
            }
        }
    }

    private void addFieldPermToCollection(Context ctx, List dataList, CoreBaseCollection fieldPermCollection) throws EASBizException, BOSException {
        if (null != dataList) {
            this.checkExists(ctx, dataList);
            this.checkData(ctx, dataList, fieldPermCollection);
        }
    }

    private void checkExists(Context ctx, List dataList) throws BOSException, EASBizException {
        StringBuffer msgSb = new StringBuffer(50);
        for (int i = 0; i < dataList.size(); ++i) {
            String[] fieldArry;
            String fields;
            LinkedTreeMap map = (LinkedTreeMap)dataList.get(i);
            String model = null == map.get((Object)"model") ? null : (String)map.get((Object)"model");
            String string = fields = null == map.get((Object)"field") ? null : (String)map.get((Object)"field");
            if (null == fields) continue;
            for (String field : fieldArry = fields.split(",")) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("model", (Object)model, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("field", (Object)field, CompareType.EQUALS));
                boolean exists = FieldPermFactory.getLocalInstance(ctx).exists(filterInfo);
                if (!exists) continue;
                msgSb.append(model).append(":").append(field).append(",");
            }
        }
        if (msgSb.length() > 0) {
            throw new ShrPermissionException(ShrPermissionException.CHECK_EXISTS, new Object[]{msgSb.toString()});
        }
    }

    private void checkData(Context ctx, List dataList, CoreBaseCollection fieldPermCollection) throws ShrPermissionException {
        HashMap<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>(50);
        HashSet<String> errorModelSet = new HashSet<String>();
        HashMap<String, HashSet<String>> errorFieldMap = new HashMap<String, HashSet<String>>(50);
        for (int i = 0; i < dataList.size(); ++i) {
            String[] fieldArry;
            String fields;
            LinkedTreeMap map = (LinkedTreeMap)dataList.get(i);
            String model = null == map.get((Object)"model") ? null : (String)map.get((Object)"model");
            String string = fields = null == map.get((Object)"field") ? null : (String)map.get((Object)"field");
            if (null == fields) continue;
            for (String field : fieldArry = fields.split(",")) {
                EntityObjectInfo entityObjectInfo = this.getEntityObjectInfo(entityMap, model);
                if (null != entityObjectInfo) {
                    FieldPermInfo fieldPermInfo = this.createFieldPermInfo(ctx, field, entityObjectInfo);
                    if (null != fieldPermInfo) {
                        fieldPermCollection.add((CoreBaseInfo)fieldPermInfo);
                        continue;
                    }
                    HashSet fieldSet = null;
                    fieldSet = errorFieldMap.containsKey(model) ? (HashSet)errorFieldMap.get(model) : new HashSet();
                    fieldSet.add(field);
                    errorFieldMap.put(model, fieldSet);
                    continue;
                }
                errorModelSet.add(model);
            }
        }
        this.contactErrorMsg(errorModelSet, errorFieldMap);
    }

    private void contactErrorMsg(Set<String> errorModelSet, Map<String, HashSet<String>> errorFieldMap) throws ShrPermissionException {
        if (!errorModelSet.isEmpty() || !errorFieldMap.isEmpty()) {
            StringBuffer modelSb = new StringBuffer(100);
            StringBuffer fieldSb = new StringBuffer(100);
            for (String model : errorModelSet) {
                modelSb.append(model).append(",");
            }
            Set<Map.Entry<String, HashSet<String>>> entries = errorFieldMap.entrySet();
            for (Map.Entry<String, HashSet<String>> next : entries) {
                String model = next.getKey();
                fieldSb.append(model).append(":");
                HashSet<String> fields = next.getValue();
                for (String field : fields) {
                    fieldSb.append(field).append(",");
                }
            }
            StringBuffer errorMsgSb = new StringBuffer(200);
            if (modelSb.length() > 0) {
                String modelStr = modelSb.toString();
                modelStr = modelStr.substring(0, modelSb.length() - 1);
                modelStr = EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"model_check", (Object[])new Object[]{modelStr});
                errorMsgSb.append(modelStr);
            }
            if (fieldSb.length() > 0) {
                String fieldStr = fieldSb.toString();
                fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
                fieldStr = EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"field_check", (Object[])new Object[]{fieldStr});
                errorMsgSb.append(fieldStr);
            }
            if (errorMsgSb.length() > 0) {
                throw new ShrPermissionException(ShrPermissionException.CHECK_MODEL_FIELD, new Object[]{errorMsgSb.toString()});
            }
        }
    }

    private FieldPermInfo createFieldPermInfo(Context ctx, String field, EntityObjectInfo entityObjectInfo) {
        PropertyInfo propertyByNameRuntime = entityObjectInfo.getPropertyByNameRuntime(field);
        if (null != propertyByNameRuntime) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            FieldPermInfo fieldPermInfo = new FieldPermInfo();
            fieldPermInfo.setCreateTime(timestamp);
            fieldPermInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            fieldPermInfo.setLastUpdateTime(timestamp);
            fieldPermInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            fieldPermInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
            fieldPermInfo.setModel(entityObjectInfo.getFullName());
            fieldPermInfo.setField(propertyByNameRuntime.getName());
            fieldPermInfo.setModelName(entityObjectInfo.getAlias(Locale.CHINA), Locale.CHINA);
            fieldPermInfo.setModelName(entityObjectInfo.getAlias(Locale.ENGLISH), Locale.ENGLISH);
            fieldPermInfo.setModelName(entityObjectInfo.getAlias(Locale.TAIWAN), Locale.TAIWAN);
            fieldPermInfo.setName(propertyByNameRuntime.getAlias(Locale.CHINA), Locale.CHINA);
            fieldPermInfo.setName(propertyByNameRuntime.getAlias(Locale.ENGLISH), Locale.ENGLISH);
            fieldPermInfo.setName(propertyByNameRuntime.getAlias(Locale.TAIWAN), Locale.TAIWAN);
            return fieldPermInfo;
        }
        return null;
    }

    private EntityObjectInfo getEntityObjectInfo(Map<String, EntityObjectInfo> entityMap, String model) {
        EntityObjectInfo entityObjectInfo = null;
        if (entityMap.containsKey(model)) {
            entityObjectInfo = entityMap.get(model);
        } else {
            entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)model));
            entityMap.put(model, entityObjectInfo);
        }
        return entityObjectInfo;
    }
}

