/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.FieldPermConfigInfo;
import com.kingdee.shr.base.permission.FieldPermRoleFactory;
import com.kingdee.shr.base.permission.FieldPermRoleInfo;
import com.kingdee.shr.base.permission.FieldPermUserFactory;
import com.kingdee.shr.base.permission.FieldPermUserInfo;
import com.kingdee.shr.base.permission.IFieldPermRole;
import com.kingdee.shr.base.permission.IFieldPermUser;
import com.kingdee.shr.base.permission.app.AbstractFieldPermFacadeControllerBean;
import com.kingdee.shr.base.permission.cache.ShrPermissionCacheHelper;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FieldPermFacadeControllerBean
extends AbstractFieldPermFacadeControllerBean {
    private static final int COUNT = 500;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.FieldPermFacadeControllerBean");

    @Override
    protected void _distributeFieldPerm2User(Context ctx, String[] fieldPermIds, String[] userIds) throws BOSException, EASBizException {
        if (null == fieldPermIds || null == userIds) {
            return;
        }
        if (fieldPermIds.length * userIds.length > 500) {
            this.distributeFieldPerm2UserByTempTable(ctx, fieldPermIds, userIds);
        } else {
            this.distributeFieldPerm2UserByExists(ctx, fieldPermIds, userIds);
        }
        ShrPermissionCacheHelper.removeCacheByType(1);
    }

    private void distributeFieldPerm2UserByTempTable(Context ctx, String[] fieldPermIds, String[] userIds) throws BOSException {
        String tempTableName = null;
        try {
            List params = this.createParams(fieldPermIds, userIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FUserID VARCHAR(44),FFieldPermConfigId VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FUserID,FFieldPermConfigId) values(?,?)"), (List)params);
            StringBuffer insertSql = new StringBuffer(200);
            insertSql.append("INSERT INTO T_HR_FieldPermUser (FID,FUserID,FFieldPermConfigId,FCreateTime,FLastUpdateTime,FCreatorID,FLastUpdateUserID,FControlUnitID)").append(" SELECT newbosid('ED0979A7'),FUserID,FFieldPermConfigId,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_HR_FieldPermUser t2 where t1.FUserID = t2.FUserID and t1.FFieldPermConfigId = t2.FFieldPermConfigId)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void distributeFieldPerm2UserByExists(Context ctx, String[] fieldPermIds, String[] userIds) throws BOSException, EASBizException {
        CoreBaseCollection fieldPermUserCollection = new CoreBaseCollection();
        IFieldPermUser iFieldPermUser = FieldPermUserFactory.getLocalInstance(ctx);
        for (int i = 0; i < fieldPermIds.length; ++i) {
            String fieldPermId = fieldPermIds[i];
            for (int j = 0; j < userIds.length; ++j) {
                String userId = userIds[j];
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("fieldPermConfigId", (Object)fieldPermId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId, CompareType.EQUALS));
                if (iFieldPermUser.exists(filterInfo)) continue;
                fieldPermUserCollection.add((CoreBaseInfo)this.getFieldPermUserInfo(ctx, fieldPermId, userId));
            }
        }
        FieldPermUserFactory.getLocalInstance(ctx).saveBatchData(fieldPermUserCollection);
    }

    private FieldPermUserInfo getFieldPermUserInfo(Context ctx, String fieldPermId, String userId) {
        FieldPermConfigInfo fieldPermConfigInfo = new FieldPermConfigInfo();
        fieldPermConfigInfo.setId(BOSUuid.read((String)fieldPermId));
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        Timestamp timestamp = new Timestamp(new Date().getTime());
        FieldPermUserInfo fieldPermUserInfo = new FieldPermUserInfo();
        fieldPermUserInfo.setFieldPermConfigId(fieldPermConfigInfo);
        fieldPermUserInfo.setUserId(userInfo);
        fieldPermUserInfo.setCreateTime(timestamp);
        fieldPermUserInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        fieldPermUserInfo.setLastUpdateTime(timestamp);
        fieldPermUserInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        fieldPermUserInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
        return fieldPermUserInfo;
    }

    @Override
    protected void _distributeFieldPerm2Role(Context ctx, String[] fieldPermIds, String[] roleIds) throws BOSException, EASBizException {
        if (null == fieldPermIds || null == roleIds) {
            return;
        }
        if (fieldPermIds.length * roleIds.length > 500) {
            this.distributeFieldPerm2RoleByTempTable(ctx, fieldPermIds, roleIds);
        } else {
            this.distributeFieldPerm2RoleByExists(ctx, fieldPermIds, roleIds);
        }
        ShrPermissionCacheHelper.removeCacheByType(1);
    }

    private void distributeFieldPerm2RoleByTempTable(Context ctx, String[] fieldPermIds, String[] roleIds) throws BOSException {
        String tempTableName = null;
        try {
            List params = this.createParams(fieldPermIds, roleIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FRoleID VARCHAR(44),FFieldPermConfigId VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FRoleID,FFieldPermConfigId) values(?,?)"), (List)params);
            StringBuffer insertSql = new StringBuffer(200);
            insertSql.append("INSERT INTO T_HR_FieldPermRole (FID,FRoleID,FFieldPermConfigId,FCreateTime,FLastUpdateTime,FCreatorID,FLastUpdateUserID,FControlUnitID)").append(" SELECT newbosid('ED080E52'),FRoleID,FFieldPermConfigId,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_HR_FieldPermRole t2 where t1.FRoleID = t2.FRoleID and t1.FFieldPermConfigId = t2.FFieldPermConfigId)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void distributeFieldPerm2RoleByExists(Context ctx, String[] fieldPermIds, String[] roleIds) throws BOSException, EASBizException {
        CoreBaseCollection fieldPermRoleCollection = new CoreBaseCollection();
        IFieldPermRole iFieldPermRole = FieldPermRoleFactory.getLocalInstance(ctx);
        for (int i = 0; i < fieldPermIds.length; ++i) {
            String fieldPermConfigId = fieldPermIds[i];
            for (int j = 0; j < roleIds.length; ++j) {
                String roleId = roleIds[j];
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("fieldPermConfigId", (Object)fieldPermConfigId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("roleId", (Object)roleId, CompareType.EQUALS));
                if (iFieldPermRole.exists(filterInfo)) continue;
                fieldPermRoleCollection.add((CoreBaseInfo)this.getFieldPermRoleInfo(ctx, fieldPermConfigId, roleId));
            }
        }
        FieldPermRoleFactory.getLocalInstance(ctx).saveBatchData(fieldPermRoleCollection);
    }

    private FieldPermRoleInfo getFieldPermRoleInfo(Context ctx, String fieldPermConfigId, String roleId) {
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)roleId));
        FieldPermConfigInfo fieldPermConfigInfo = new FieldPermConfigInfo();
        fieldPermConfigInfo.setId(BOSUuid.read((String)fieldPermConfigId));
        Timestamp timestamp = new Timestamp(new Date().getTime());
        FieldPermRoleInfo fieldPermRoleInfo = new FieldPermRoleInfo();
        fieldPermRoleInfo.setFieldPermConfigId(fieldPermConfigInfo);
        fieldPermRoleInfo.setRoleId(roleInfo);
        fieldPermRoleInfo.setCreateTime(timestamp);
        fieldPermRoleInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        fieldPermRoleInfo.setLastUpdateTime(timestamp);
        fieldPermRoleInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        fieldPermRoleInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
        return fieldPermRoleInfo;
    }

    @Override
    protected void _unDistributeFieldPerm2User(Context ctx, String[] billIds) throws BOSException, EASBizException {
        IObjectPK[] objectPKArr = this.getIObjectPkArr(billIds);
        FieldPermUserFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
        ShrPermissionCacheHelper.removeCacheByType(1);
    }

    @Override
    protected void _unDistributeFieldPerm2Role(Context ctx, String[] billIds) throws BOSException, EASBizException {
        IObjectPK[] objectPKArr = this.getIObjectPkArr(billIds);
        FieldPermRoleFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
        ShrPermissionCacheHelper.removeCacheByType(1);
    }

    private IObjectPK[] getIObjectPkArr(String[] billIds) {
        IObjectPK[] objectPKArr = new IObjectPK[billIds.length];
        for (int i = 0; i < billIds.length; ++i) {
            objectPKArr[i] = new ObjectUuidPK(BOSUuid.read((String)billIds[i]));
        }
        return objectPKArr;
    }

    private List createParams(String[] fieldPermIds, String[] ids) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < fieldPermIds.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                Object[] objArr = new Object[]{ids[j], fieldPermIds[i]};
                params.add(objArr);
            }
        }
        return params;
    }

    private void dropTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempTableName));
        }
    }
}

