/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.PermissionRuleConfigInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.app.AbstractPermissionRuleConfigControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PermissionRuleConfigControllerBean
extends AbstractPermissionRuleConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.PermissionRuleConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        PermissionRuleConfigInfo oldInfo;
        PermissionRuleConfigInfo info = (PermissionRuleConfigInfo)model;
        boolean isProductionMode = (Boolean)info.get("productionMode");
        if (null != info.getId() && (oldInfo = this.getPermissionRuleConfigInfo(ctx, (IObjectPK)(pk = new ObjectUuidPK(info.getId())))).isIsPreset() && isProductionMode) {
            return pk;
        }
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        if (MLUtils.containChinese((String)info.getNumber())) {
            throw new ShrPermissionException(ShrPermissionException.NUMBER_CAN_NOT_CONTAIN_ZH);
        }
        if (!info.isIsPreset()) {
            if (info.getNumber().length() <= 7) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_NUMBER_FORMAT_ERROR);
            }
            String endSub = info.getNumber().substring(info.getNumber().length() - 7);
            if (!"_custom".equals(endSub)) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_NUMBER_FORMAT_ERROR);
            }
        }
        if (StringUtils.isEmpty((String)info.getChecker())) {
            throw new ShrPermissionException(ShrPermissionException.PERMISSION_CHECKER_NOT_NULL);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checker", (Object)info.getChecker()));
        if (null != info.getId()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new ShrPermissionException(ShrPermissionException.PERMISSION_CHECKER_NOT_DUMP);
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)true));
        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        if (this._exists(ctx, newFilter)) {
            throw new ShrPermissionException(ShrPermissionException.PRESET_CONFIG_NOT_DELETE);
        }
        super._delete(ctx, pk);
    }
}

