/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.SHROrgRangeParam;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermCollection;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermInfo;
import com.kingdee.shr.base.permission.app.AbstractSHRUserAdminOrgPermControllerBean;
import com.kingdee.shr.base.permission.cache.ShrPermissionCacheHelper;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHRUserAdminOrgPermControllerBean
extends AbstractSHRUserAdminOrgPermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.SHRUserAdminOrgPermControllerBean");

    @Override
    protected Set _getOrgIdsByUserAndPerm(Context ctx, IObjectPK targetUserPK, String permID) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        String oql = "select adminOrg.id where user.id='" + targetUserPK.toString() + "' and permItem.id='" + permID + "'";
        SHRUserAdminOrgPermCollection orgRangeCol = this.getSHRUserAdminOrgPermCollection(ctx, oql);
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            set.add(orgRangeCol.get(i).getAdminOrg().getId().toString());
        }
        return set;
    }

    @Override
    protected void _saveSHROrgRange(Context ctx, SHROrgRangeParam orgRangeParam) throws BOSException, EASBizException {
        SHRUserAdminOrgPermInfo changedOrgRange = orgRangeParam.getChangedUserAdminOrgPermInfo();
        IObjectPK userPK = orgRangeParam.getUserPK();
        if (changedOrgRange != null) {
            try {
                this.handleChangeIncludeSubOrg(ctx, changedOrgRange, userPK);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleChangeIncludeSubOrg(Context ctx, SHRUserAdminOrgPermInfo changedOrgRange, IObjectPK userPK) throws EASBizException, BOSException, SQLException {
        this.updateIsIncludeSubOrg(ctx, changedOrgRange);
        String permId = changedOrgRange.getPermItem().getId().toString();
        String longNumber = changedOrgRange.getAdminOrg().getLongNumber();
        if (changedOrgRange.isIsIncludeSubOrg()) {
            this.deleteSubOrgSHRUserAdminOrgPerm(ctx, userPK, permId, longNumber, changedOrgRange.isIsForbidden());
        } else {
            this.deleteSubOrgFromSHRUserAdminOrgPerm(ctx, userPK, permId, changedOrgRange);
        }
    }

    private void deleteSubOrgFromSHRUserAdminOrgPerm(Context ctx, IObjectPK userPK, String permId, SHRUserAdminOrgPermInfo changedOrgRange) throws BOSException, SQLException {
        ShrPermissionCacheHelper.removePermCache(0, userPK.toString());
    }

    private void deleteSubOrgSHRUserAdminOrgPerm(Context ctx, IObjectPK userPK, String permId, String longNumber, boolean isForbidden) throws BOSException, SQLException {
        HashSet<String> orgSet = new HashSet<String>();
        Object[] params = new Object[]{userPK.toString(), permId, longNumber + "!%"};
        String sql = "DELETE FROM T_HR_SHRUSERADMINORGPERM WHERE FUSERID=? AND FPERMITEMID = ?  AND FADMINORGID IN (SELECT FID FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE ? )";
        if (isForbidden) {
            String orgs = "SELECT FADMINORGID FROM T_HR_SHRUSERADMINORGPERM WHERE FUSERID=? AND FPERMITEMID = ?  AND FADMINORGID IN (SELECT FID FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE ? )";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)orgs, (Object[])params);
            while (null != rowset && rowset.next()) {
                String orgId = rowset.getString("FADMINORGID");
                orgSet.add(orgId);
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        } else {
            String orgs = "SELECT FID FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE '" + longNumber + "!%'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)orgs);
            while (null != rowset && rowset.next()) {
                String orgId = rowset.getString("FID");
                orgSet.add(orgId);
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        ShrPermissionCacheHelper.removePermCache(0, userPK.toString());
    }

    private void updateIsIncludeSubOrg(Context ctx, SHRUserAdminOrgPermInfo changedOrgRange) throws EASBizException, BOSException {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("isIncludeSubOrg"));
        selectorCol.add(new SelectorItemInfo("isForbidden"));
        this.updatePartial(ctx, changedOrgRange, selectorCol);
    }
}

