/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.ISHRUserOrgPermFacade;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermInfo;
import com.kingdee.shr.base.permission.SHRUserOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.app.AbstractSHRUserAdminOrgPermFacadeControllerBean;
import com.kingdee.shr.base.permission.cache.ShrPermissionCacheHelper;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class SHRUserAdminOrgPermFacadeControllerBean
extends AbstractSHRUserAdminOrgPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.SHRUserAdminOrgPermFacadeControllerBean");

    @Override
    protected void _saveUserAdminOrgPerm(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, PermItemCollection permItemCollection, List addedOrgs, FullOrgUnitCollection orgCol, List isSelectedSubOrg) throws BOSException, EASBizException {
        block16: {
            long end;
            long begin;
            String userId;
            block18: {
                Map<String, Map<String, String>> adminOrgUnit;
                PermItemCollection targetPermItemCollection;
                block17: {
                    userId = targetUserPK.toString();
                    ISHRUserOrgPermFacade iSHRUserOrgPermFacade = SHRUserOrgPermFacadeFactory.getLocalInstance(ctx);
                    begin = System.currentTimeMillis();
                    targetPermItemCollection = this.getTargetPermItemCollection(ctx, permItemCollection, orgCol, sourceUserPK, targetUserPK, iSHRUserOrgPermFacade);
                    end = System.currentTimeMillis();
                    logger.error((Object)(" getTargetPermItemCollection " + (end - begin)));
                    if (targetPermItemCollection == null || targetPermItemCollection.size() <= 0) break block16;
                    int totalCount = targetPermItemCollection.size() * addedOrgs.size();
                    if (totalCount > 500000) {
                        throw new BOSException("500000");
                    }
                    begin = System.currentTimeMillis();
                    adminOrgUnit = this.getAdminOrgUnit(ctx);
                    if (totalCount <= 10000) break block17;
                    String permTemp = null;
                    String orgTemp = null;
                    end = System.currentTimeMillis();
                    logger.error((Object)(" getAdminOrgUnit  getUserAdminOrgUnit " + (end - begin)));
                    TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
                    try {
                        begin = System.currentTimeMillis();
                        StringBuffer permInsertSql = new StringBuffer();
                        ArrayList<Object[]> pids = new ArrayList<Object[]>();
                        permTemp = tablePool.createTempTable("create table T_HR_PERMTMPTBL (FID varchar(44))");
                        permInsertSql.append("insert into ").append(permTemp).append(" (FID) ").append(" VALUES (?)");
                        int total = targetPermItemCollection.size();
                        for (int i = 0; i < total; ++i) {
                            String permItemId = targetPermItemCollection.get(i).getId().toString();
                            Object[] pid = new Object[]{permItemId};
                            pids.add(pid);
                        }
                        DbUtil.executeBatch((Context)ctx, (String)permInsertSql.toString(), pids);
                        end = System.currentTimeMillis();
                        logger.error((Object)(" create table T_HR_PERMTMPTBL " + (end - begin)));
                        begin = System.currentTimeMillis();
                        StringBuffer adOrgInsertSql = new StringBuffer();
                        ArrayList<Object[]> aids = new ArrayList<Object[]>();
                        if (addedOrgs != null && addedOrgs.size() > 0) {
                            for (String adminOrgId : addedOrgs) {
                                String newLongNumber = adminOrgUnit.get(adminOrgId).get("FLongNumber");
                                String ctrlUnitId = adminOrgUnit.get(adminOrgId).get("FControlUnitID");
                                Boolean newIncludeSubOrg = (Boolean)isSelectedSubOrg.get(addedOrgs.indexOf(adminOrgId));
                                Object[] aid = new Object[]{adminOrgId, newLongNumber, ctrlUnitId, newIncludeSubOrg != false ? 1 : 0, userId};
                                aids.add(aid);
                            }
                        }
                        IRowSet rsLn = DbUtil.executeQuery((Context)ctx, (String)"SELECT max(len(FLONGNUMBER)) mlongnumber FROM t_org_admin");
                        int mlongnumber = 80;
                        while (rsLn.next()) {
                            mlongnumber = rsLn.getInt("mlongnumber");
                        }
                        orgTemp = tablePool.createTempTable("create table T_HR_ADMINORGTMPTBL (FID varchar(44),FLongNumber nvarchar(" + mlongnumber + "),FCtrlUnitId varchar(44),FIsIncludeSubOrg INT,FuserId varchar(44))");
                        adOrgInsertSql.append("insert into ").append(orgTemp).append(" (FID,FLongNumber,FCtrlUnitId,FIsIncludeSubOrg,FuserId) ").append(" VALUES (?,?,?,?,?)");
                        DbUtil.executeBatch((Context)ctx, (String)adOrgInsertSql.toString(), aids);
                        end = System.currentTimeMillis();
                        logger.error((Object)(" create table T_HR_ADMINORGTMPTBL " + (end - begin)));
                        begin = System.currentTimeMillis();
                        StringBuffer insertSql = new StringBuffer();
                        insertSql.append("INSERT INTO T_HR_SHRUserAdminOrgPerm (FID,FPermItemId,FCtrlUnitId,FUserId,FPermType,FAdminOrgID,FIsIncludeSubOrg,FIsForbidden)").append(" SELECT newbosid('F347821F'),perm.FID,org.FCtrlUnitId,'").append(userId).append("',").append(20).append(",org.FID,org.FIsIncludeSubOrg,").append(0).append(" FROM ").append(orgTemp).append(" org").append(" inner join ").append(permTemp).append(" perm on 1=1").append(" WHERE NOT EXISTS (SELECT 1 FROM T_HR_SHRUserAdminOrgPerm orgperm WHERE orgperm.FuserId='").append(userId).append("'").append(" and orgperm.FAdminOrgID=org.FID AND orgperm.FPermItemId=perm.FID)");
                        DbUtil.execute((Context)ctx, (String)insertSql.toString());
                        end = System.currentTimeMillis();
                        logger.error((Object)(" INSERT INTO T_HR_SHRUserAdminOrgPerm " + (end - begin)));
                        begin = System.currentTimeMillis();
                        StringBuffer updateSql = new StringBuffer();
                        updateSql.append("UPDATE T_HR_SHRUserAdminOrgPerm SET FIsIncludeSubOrg=1 WHERE FUserId='").append(userId).append("'").append(" and FIsIncludeSubOrg=0 AND EXISTS (SELECT 1 FROM ").append(orgTemp).append(" org").append(" inner join ").append(permTemp).append(" perm on 1=1 WHERE org.FID=T_HR_SHRUserAdminOrgPerm.FAdminOrgID AND perm.FID=T_HR_SHRUserAdminOrgPerm.FPermItemId AND org.FIsIncludeSubOrg=1)");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString());
                        end = System.currentTimeMillis();
                        logger.error((Object)(" UPDATE T_HR_SHRUserAdminOrgPerm " + (end - begin)));
                        begin = System.currentTimeMillis();
                        StringBuffer idSql = new StringBuffer();
                        idSql.append("select distinct orgperm.FID from T_HR_SHRUserAdminOrgPerm orgperm INNER JOIN ").append(permTemp).append(" perm on perm.FID=orgperm.FPermItemId where orgperm.FUserId = '").append(userId).append("' and orgperm.FIsIncludeSubOrg=1");
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)idSql.toString());
                        ArrayList<String> ids = new ArrayList<String>();
                        while (rs.next()) {
                            ids.add(rs.getString("FID"));
                        }
                        if (ids.size() > 0) {
                            this._updateIsIncludeSubOrg(ctx, targetUserPK, true, ids);
                        }
                        end = System.currentTimeMillis();
                        logger.error((Object)("Do include subordinate operations " + (end - begin)));
                    }
                    catch (Exception e) {
                        try {
                            throw new BOSException(e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (!StringUtils.isEmpty(orgTemp)) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(orgTemp);
                            }
                            if (!StringUtils.isEmpty(permTemp)) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(permTemp);
                            }
                            throw throwable;
                        }
                    }
                    if (!StringUtils.isEmpty((String)orgTemp)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(orgTemp);
                    }
                    if (!StringUtils.isEmpty((String)permTemp)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(permTemp);
                    }
                    break block18;
                }
                Map<String, List<Map<String, Object>>> userAdminOrgUnit = this.getUserAdminOrgUnit(ctx, userId);
                LinkedList<Object[]> paramList = new LinkedList<Object[]>();
                LinkedList<Object[]> needDeleteParamList = new LinkedList<Object[]>();
                int total = targetPermItemCollection.size();
                for (int i = 0; i < total; ++i) {
                    String permItemId = targetPermItemCollection.get(i).getId().toString();
                    if (addedOrgs == null || addedOrgs.size() <= 0) continue;
                    this.getParamList(ctx, paramList, addedOrgs, permItemId, userId, 20, adminOrgUnit, userAdminOrgUnit, isSelectedSubOrg, needDeleteParamList);
                }
                end = System.currentTimeMillis();
                logger.error((Object)(" getParamList " + (end - begin)));
                begin = System.currentTimeMillis();
                String deleteSql = SHRPermissionSQL.assembleSHRUserAdminOrgPermDelSql();
                DbUtil.executeBatch((Context)ctx, (String)deleteSql, needDeleteParamList);
                String sql = SHRPermissionSQL.assembleSHRUserAdminOrgPermInsertSql(ctx);
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                end = System.currentTimeMillis();
                logger.error((Object)(" executeBatch " + (end - begin)));
            }
            begin = System.currentTimeMillis();
            ShrPermissionCacheHelper.removePermCache(0, userId);
            end = System.currentTimeMillis();
            logger.error((Object)(" userAdminOrgPermWriteCache " + (end - begin)));
        }
    }

    private Map<String, Map<String, String>> getAdminOrgUnit(Context ctx) throws BOSException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FID, FLongNumber, FControlUnitID from t_org_admin where FISSTARTSHR = 1");
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("FLongNumber", rs.getString("FLongNumber"));
                map.put("FControlUnitID", rs.getString("FControlUnitID"));
                result.put(rs.getString("FID"), map);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> getUserAdminOrgUnit(Context ctx, String userId) throws BOSException {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SHRPermissionSQL.getExistsOrIncludeSubOrgSql(userId, null));
        try {
            while (rs.next()) {
                String permItemId = rs.getString("FPermItemId");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("FID", rs.getString("FID"));
                map.put("FLongNumber", rs.getString("FLongNumber"));
                map.put("FIsIncludeSubOrg", rs.getBoolean("FIsIncludeSubOrg"));
                ArrayList<HashMap<String, Object>> list = null;
                if (result.containsKey(permItemId)) {
                    ((List)result.get(permItemId)).add(map);
                    continue;
                }
                list = new ArrayList<HashMap<String, Object>>();
                list.add(map);
                result.put(permItemId, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getParamList(Context ctx, List<Object[]> paramList, List<String> addedOrgs, String permItemId, String userId, int permType, Map<String, Map<String, String>> adminOrgUnit, Map<String, List<Map<String, Object>>> userAdminOrgUnit, List isSelectedSubOrg, List<Object[]> needDeleteParamList) throws EASBizException, BOSException {
        for (String adminOrgId : addedOrgs) {
            if (!adminOrgUnit.containsKey(adminOrgId)) continue;
            String newLongNumber = adminOrgUnit.get(adminOrgId).get("FLongNumber");
            String ctrlUnitId = adminOrgUnit.get(adminOrgId).get("FControlUnitID");
            Boolean newIncludeSubOrg = (Boolean)isSelectedSubOrg.get(addedOrgs.indexOf(adminOrgId));
            boolean isNeedAddNew = true;
            if (null != userAdminOrgUnit.get(permItemId) && userAdminOrgUnit.get(permItemId).size() > 0) {
                for (Map<String, Object> map : userAdminOrgUnit.get(permItemId)) {
                    String oldAdminOrgId = (String)map.get("FID");
                    String oldLongNumber = (String)map.get("FLongNumber");
                    boolean isIncludeSubOrg = (Boolean)map.get("FIsIncludeSubOrg");
                    if (oldLongNumber.equals(newLongNumber) && isIncludeSubOrg == newIncludeSubOrg) {
                        isNeedAddNew = false;
                        break;
                    }
                    if (newIncludeSubOrg.booleanValue() && oldLongNumber.indexOf(newLongNumber) == 0) {
                        Object[] params = new Object[]{userId, permItemId, oldAdminOrgId};
                        needDeleteParamList.add(params);
                    }
                    if (!isIncludeSubOrg || newLongNumber.indexOf(oldLongNumber) != 0) continue;
                    isNeedAddNew = false;
                    break;
                }
            }
            if (!isNeedAddNew) continue;
            Object[] params = new Object[]{permItemId, ctrlUnitId, userId, permType, adminOrgId, isSelectedSubOrg.get(addedOrgs.indexOf(adminOrgId)), Boolean.FALSE};
            paramList.add(params);
        }
    }

    private String getCtrlUnitId(Context ctx, String orgId) throws EASBizException, BOSException {
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String ctrlUnitId = orgInfo.getCU().getId().toString();
        return ctrlUnitId;
    }

    @Override
    protected void _updatePermFromUserAdminOrgChange(Context ctx, String userId, Collection deletedOrgs, Collection addedOrgs, OrgRangeIncludeSubOrgInfo changedOrgRangeIncludeSubOrg) throws BOSException, EASBizException {
    }

    @Override
    protected void _updatePermFromUserAdminOrgChange(Context ctx, String userId, Collection delOrgs, Collection addedOrgs, SHRUserAdminOrgPermInfo changedUserAdminOrgPermInfo) throws BOSException, EASBizException {
        String permItemsSql = SHRPermissionSQL.getUserPermItems();
        Object[] permParams = new Object[]{userId, userId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permItemsSql, (Object[])permParams);
        if (addedOrgs != null && addedOrgs.size() > 0) {
            this.deletePermFromAdminOrgChange(ctx, userId, addedOrgs, (RowSet)rs);
        }
        if (addedOrgs != null && addedOrgs.size() > 0) {
            this.addPermFromAdminOrgChange(ctx, userId, addedOrgs, (RowSet)rs);
        }
        if (changedUserAdminOrgPermInfo != null) {
            String orgId = changedUserAdminOrgPermInfo.getAdminOrg().getId().toString();
            String longNumber = changedUserAdminOrgPermInfo.getAdminOrg().getLongNumber();
            if (changedUserAdminOrgPermInfo.isIsIncludeSubOrg()) {
                String updateInSub = " update T_HR_SHRUserAdminOrgPerm set FIsIncludeSubOrg = 1 where FUserID = '" + userId + "' and FAdminOrgID ='" + orgId + "'";
                DbUtil.execute((Context)ctx, (String)updateInSub);
                this.deleteSubOrgSHRUserAdminOrgPerm(ctx, userId, longNumber);
            } else {
                this.deleteSubOrgFromSHRUserAdminOrgPerm(ctx, (RowSet)rs, userId, orgId, longNumber);
            }
        }
        ShrPermissionCacheHelper.removePermCache(0, userId);
    }

    private void addPermFromAdminOrgChange(Context ctx, String userId, Collection addedOrgs, RowSet rs) throws EASBizException, BOSException {
        LinkedList<Object[]> paramSubList = new LinkedList<Object[]>();
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        HashSet<String> orgs = new HashSet<String>();
        try {
            while (rs.next()) {
                String permItemId = rs.getString("FPERMITEMID");
                int permType = rs.getInt("FPERMTYPE");
                Iterator itr = addedOrgs.iterator();
                while (itr.hasNext()) {
                    String orgId = itr.next().toString();
                    FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                    String ctrlUnitId = orgInfo.getCU().getId().toString();
                    Object[] inSubParams = new Object[]{userId, orgId, 0, permItemId};
                    Object[] params = new Object[]{permItemId, ctrlUnitId, userId, permType, orgId, 0, 0};
                    paramSubList.add(inSubParams);
                    paramList.add(params);
                    orgs.add(orgId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String insertAdminOrgPermSql = SHRPermissionSQL.assembleSHRUserAdminOrgPermInsertSql(ctx);
        DbUtil.executeBatch((Context)ctx, (String)insertAdminOrgPermSql, paramList);
        ShrPermissionCacheHelper.removePermCache(0, userId);
    }

    private void deletePermFromAdminOrgChange(Context ctx, String userId, Collection deletedOrgs, RowSet rs) throws BOSException {
        Iterator itr = deletedOrgs.iterator();
        StringBuffer ids = new StringBuffer();
        HashSet<String> delOrgs = new HashSet<String>();
        while (itr.hasNext()) {
            String orgId = itr.next().toString();
            ids.append("'").append(orgId).append("'").append(",");
            delOrgs.add(orgId);
        }
        String idsRange = ids.substring(0, ids.length() - 1);
        String delUserAdminOrgPermSql = "delete from T_HR_SHRUserAdminOrgPerm where FUserID ='" + userId + "' and FAdminOrgID in ( " + idsRange + " )";
        DbUtil.execute((Context)ctx, (String)delUserAdminOrgPermSql);
    }

    private void deleteSubOrgFromSHRUserAdminOrgPerm(Context ctx, RowSet rs, String userId, String orgId, String longNumber) throws BOSException {
        String updateInSub = " update T_HR_SHRUserAdminOrgPerm set FIsIncludeSubOrg = 0 where FUserID = '" + userId + "' and FAdminOrgID ='" + orgId + "'";
        DbUtil.execute((Context)ctx, (String)updateInSub);
    }

    private void deleteSubOrgSHRUserAdminOrgPerm(Context ctx, String userId, String longNumber) throws BOSException {
        String sql = "delete from T_HR_SHRUserAdminOrgPerm where fuserid=? and FAdminOrgID in (select fid from t_org_admin where FLongNumber like ? )";
        Object[] params = new Object[]{userId, longNumber + "!%"};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _updatePermFromParamChange(Context ctx) throws BOSException, EASBizException {
        String delSql = SHRPermissionSQL.deleteSHRUserAdminOrgPerm();
        DbUtil.execute((Context)ctx, (String)delSql);
        String userIdsSql = SHRPermissionSQL.getUserPermInfo();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)userIdsSql);
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        String insertSql = SHRPermissionSQL.assembleSHRUserAdminOrgPermInsertSql(ctx);
        try {
            while (rs.next()) {
                String userId = rs.getString("USERID");
                String permItemId = rs.getString("PERMITEMID");
                String permType = rs.getString("PERMTYPE");
                String controlUnitID = rs.getString("CTRLUNITID");
                String orgId = rs.getString("ORGID");
                Object[] params = new Object[]{permItemId, controlUnitID, userId, permType, orgId, 0, 0};
                paramList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        ShrPermissionCacheHelper.removeCacheByType(0);
    }

    @Override
    protected void _updatePermFromRolePermChange(Context ctx, String roleId, Collection delPermItems, Collection addPermItems) throws BOSException, EASBizException {
        if (null != delPermItems && delPermItems.size() > 0) {
            this.updatePermFromRolePermDel(ctx, roleId, delPermItems);
        }
    }

    private void updatePermFromRolePermDel(Context ctx, String roleId, Collection delPermItems) throws BOSException, EASBizException {
        IRowSet rowSet = this.getUserPermItemsByRoleId(ctx, roleId);
        Map<Object, Object> userPerm = new HashMap();
        userPerm = this.assembleUserPermInfo(rowSet);
        Iterator itr = delPermItems.iterator();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        while (itr.hasNext()) {
            String permItemId = itr.next().toString();
            for (String string : userPerm.keySet()) {
                if (((Set)userPerm.get(string)).contains(permItemId)) continue;
                Object[] params = new Object[]{string, permItemId};
                paramsList.add(params);
            }
            String delSql = SHRPermissionSQL.delSHRUserAdminOrgPermByRolePermChange();
            DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
        }
        ShrPermissionCacheHelper.removeCacheByType(0);
    }

    private Map<String, Set<String>> assembleUserPermInfo(IRowSet rowSet) throws BOSException {
        HashMap<String, Set<String>> userPerm = new HashMap<String, Set<String>>();
        HashSet<String> permIds = null;
        try {
            while (rowSet.next()) {
                String userId = rowSet.getString("FUSERID");
                String permItemId = rowSet.getString("FPERMITEMID");
                if (userPerm.containsKey(userId)) {
                    ((Set)userPerm.get(userId)).add(permItemId);
                    continue;
                }
                permIds = new HashSet<String>();
                permIds.add(permItemId);
                userPerm.put(userId, permIds);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return userPerm;
    }

    private IRowSet getUserPermItemsByRoleId(Context ctx, String roleId) throws BOSException {
        String sql = SHRPermissionSQL.getUserPermItemsByRoleId();
        Object[] params = new Object[]{roleId};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _updatePermFromRoleUserChange(Context ctx, String roleId, Collection delUsers, Collection addUsers) throws BOSException, EASBizException {
        IRowSet rowSet = this.getUserPermItemsByRoleId(ctx, roleId);
        HashMap<String, Set<String>> userPerm = new HashMap();
        userPerm = this.assembleUserPermInfo(rowSet);
        if (null != delUsers && delUsers.size() > 0) {
            this.updatePermFromRoleUserDelete(ctx, delUsers, userPerm);
        }
        if (null != addUsers && addUsers.size() > 0) {
            this.updatePermFromRoleUserAdd(ctx, addUsers, userPerm);
        }
    }

    private void updatePermFromRoleUserAdd(Context ctx, Collection addUsers, Map<String, Set<String>> userPerm) throws BOSException {
        Iterator itr = addUsers.iterator();
        StringBuffer sb = new StringBuffer();
        while (itr.hasNext()) {
            String userId = itr.next().toString();
            sb.append("'").append(userId).append("',");
        }
        IRowSet rowSet = this.getUserAdminOrgsByUserId(ctx, sb);
    }

    private IRowSet getUserAdminOrgsByUserId(Context ctx, StringBuffer sb) throws BOSException {
        String filter = sb.substring(0, sb.length() - 1);
        String sql = SHRPermissionSQL.getUserAdminOrgsByUsers(filter);
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    private void updatePermFromRoleUserDelete(Context ctx, Collection delUsers, Map<String, Set<String>> userPerm) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        StringBuffer sb = new StringBuffer();
        Iterator itr = delUsers.iterator();
        while (itr.hasNext()) {
            String userId = itr.next().toString();
            sb.append("'").append(userId).append("',");
        }
        IRowSet usersPermItems = this.getUserPermsByUsers(ctx, sb);
        try {
            block3: while (usersPermItems.next()) {
                String userId = usersPermItems.getString("FOWNER");
                String permId = usersPermItems.getString("FPERMITEMID");
                for (String key : userPerm.keySet()) {
                    if (!key.equals(userId)) continue;
                    if (userPerm.get(key).contains(permId)) continue block3;
                    Object[] params = new Object[]{userId, permId};
                    paramsList.add(params);
                    continue block3;
                }
            }
            String delSql = SHRPermissionSQL.delSHRUserAdminOrgPermByRolePermChange();
            DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private IRowSet getUserPermsByUsers(Context ctx, StringBuffer sb) throws BOSException {
        String filter = sb.substring(0, sb.length() - 1);
        String sql = SHRPermissionSQL.getUserPermItemsByUsers(filter);
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    @Override
    protected void _updatePermFromUserAdd(Context ctx, String userId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId)) {
            return;
        }
        IRowSet rowSet = this.getUserRoleOrgPermByUserId(ctx, userId);
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        try {
            while (rowSet.next()) {
                String permItemId = rowSet.getString("FUSERID");
                String orgId = rowSet.getString("FORGID");
                String ctrlUnitId = this.getCtrlUnitId(ctx, orgId);
                Object[] params = new Object[]{permItemId, ctrlUnitId, userId, "", orgId, 0, 0};
                paramsList.add(params);
            }
            String sql = SHRPermissionSQL.assembleSHRUserAdminOrgPermInsertSql(ctx);
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private IRowSet getUserRoleOrgPermByUserId(Context ctx, String userId) throws BOSException {
        String sql = SHRPermissionSQL.getUserRoleOrgPermByUserId();
        Object[] params = new Object[]{userId};
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    @Override
    protected void _updatePermFromAdminOrgStartOrStop(Context ctx, Collection adminOrgColls, int operateType) throws BOSException, EASBizException {
        if (operateType == 0) {
            String sql = SHRPermissionSQL.getAllUserPermInfo();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
            HashSet<String> keySet = new HashSet<String>();
            try {
                while (rowSet.next()) {
                    String userId = rowSet.getString("FUSERID");
                    String permItemId = rowSet.getString("FPERMITEMID");
                    String permType = rowSet.getString("FPERMTYPE");
                    String key = userId + ":" + permItemId;
                    keySet.add(key);
                    Iterator itr = adminOrgColls.iterator();
                    while (itr.hasNext()) {
                        String orgId = itr.next().toString();
                        String ctrlUnitId = this.getCtrlUnitId(ctx, orgId);
                        Object[] params = new Object[]{permItemId, ctrlUnitId, userId, permType, orgId, 0, 0};
                        paramsList.add(params);
                    }
                }
                String insertSql = SHRPermissionSQL.assembleSHRUserAdminOrgPermInsertSql(ctx);
                DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (operateType == 1) {
            HashSet<String> orgSet = new HashSet<String>();
            Iterator itr = adminOrgColls.iterator();
            StringBuffer sb = new StringBuffer();
            while (itr.hasNext()) {
                String orgId = itr.next().toString();
                orgSet.add(orgId);
                sb.append("'").append(orgId).append("',");
            }
            String filter = sb.substring(0, sb.length() - 1);
            String delSql = SHRPermissionSQL.deleteSHRUserAdminOrgPermByOrgs(filter);
            String delSubSql = SHRPermissionSQL.deleteSHRUserAdminOrgPermInSubByOrgs(filter);
            DbUtil.execute((Context)ctx, (String)delSubSql);
            DbUtil.execute((Context)ctx, (String)delSql);
        }
        ShrPermissionCacheHelper.removeCacheByType(0);
    }

    private PermItemCollection getTargetPermItemCollection(Context ctx, PermItemCollection permItemCollection, FullOrgUnitCollection orgCol, IObjectPK sourceUserPK, IObjectPK targetUserPK, ISHRUserOrgPermFacade iSHRUserOrgPermFacade) throws EASBizException, BOSException {
        PermItemCollection coll = new PermItemCollection();
        if (permItemCollection.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            StringBuffer maskString = new StringBuffer();
            int index = 0;
            int total = permItemCollection.size();
            for (int i = 0; i < total; ++i) {
                PermItemInfo permItemInfo = permItemCollection.get(i);
                if (permItemInfo.isIsLeaf()) {
                    coll.add(permItemInfo);
                    continue;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(permItemInfo.getLongNumber() + "%"), CompareType.LIKE));
                if (index > 0) {
                    maskString.append(" or #").append(index);
                } else {
                    maskString.append("#").append(index);
                }
                ++index;
            }
            if (!StringUtils.isEmpty((String)maskString.toString())) {
                IPermissionManager permissionManager = PermissionManagerFactory.getLocalInstance((Context)ctx);
                Map map = permissionManager.getUserOrgs(null, targetUserPK, OrgRangeType.BIZ_ORG_TYPE);
                UserOrgPermCollection collPermItemAll = new UserOrgPermCollection();
                for (Object key : map.keySet()) {
                    UserOrgPermCollection collPermItem = (UserOrgPermCollection)PermissionManagerFactory.getLocalInstance((Context)ctx).getAllPerms(targetUserPK, (IObjectPK)new ObjectUuidPK((String)key));
                    collPermItemAll.addCollection(collPermItem);
                }
                if (collPermItemAll != null && collPermItemAll.size() > 0) {
                    int totalCount = collPermItemAll.size();
                    String querySql = null;
                    if (totalCount > 300) {
                        StringBuffer permInsertSql = new StringBuffer();
                        ArrayList<Object[]> pids = new ArrayList<Object[]>();
                        TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
                        String permTemp = null;
                        try {
                            permTemp = tablePool.createTempTable("create table T_HR_COLLPERMITEMTEMP (FID varchar(44))");
                        }
                        catch (Exception e) {
                            throw new BOSException(e.getMessage(), (Throwable)e);
                        }
                        permInsertSql.append("insert into ").append(permTemp).append(" (FID) ").append(" VALUES (?)");
                        int total2 = collPermItemAll.size();
                        for (int i = 0; i < total2; ++i) {
                            UserOrgPermInfo userOrgPerm = collPermItemAll.get(i);
                            String permItemId = userOrgPerm.getPermItemId();
                            Object[] pid = new Object[]{permItemId};
                            pids.add(pid);
                        }
                        DbUtil.executeBatch((Context)ctx, (String)permInsertSql.toString(), pids);
                        logger.error((Object)"create table T_HR_COLLPERMITEMTEMP");
                        querySql = "select fid from " + permTemp;
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)querySql, CompareType.INNER));
                    } else {
                        StringBuffer permInsertIds = new StringBuffer();
                        int total3 = collPermItemAll.size();
                        for (int i = 0; i < total3; ++i) {
                            UserOrgPermInfo userOrgPerm = collPermItemAll.get(i);
                            String permItemId = userOrgPerm.getPermItemId();
                            permInsertIds.append(permItemId);
                            if (i == total3 - 1) continue;
                            permInsertIds.append(",");
                        }
                        querySql = permInsertIds.toString();
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)querySql, CompareType.INCLUDE));
                    }
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
                filterInfo.setMaskString("(" + maskString.toString() + ") and #" + index + " and #" + (index + 1));
                viewInfo.setFilter(filterInfo);
                coll.addCollection(PermItemFactory.getLocalInstance((Context)ctx).getPermItemCollection(viewInfo));
            }
        }
        return coll;
    }

    @Override
    protected void _updatePermFromRecordDelete(Context ctx, List list, PermItemCollection permItemCollection, PermItemInfo permItem, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String userId = targetUserPK.toString();
        int total = list.size();
        for (int i = 0; i < total; ++i) {
            Map map = (Map)list.get(i);
            String orgId = (String)map.get("orgId");
            Object[] delParams = new Object[]{userId, permItem.getId().toString(), orgId};
            paramsList.add(delParams);
        }
        String del = SHRPermissionSQL.assembleSHRUserAdminOrgPermDelSql();
        DbUtil.executeBatch((Context)ctx, (String)del, paramsList);
        ShrPermissionCacheHelper.removePermCache(0, userId);
    }

    @Override
    protected void _deleteUserAdminOrgPermById(Context ctx, List listIds) throws BOSException {
        StringBuffer suffix = new StringBuffer();
        Iterator itr = listIds.iterator();
        while (itr.hasNext()) {
            String id = itr.next().toString();
            suffix.append("'").append(id).append("',");
        }
        suffix.deleteCharAt(suffix.length() - 1).append(")");
        StringBuffer sql = new StringBuffer();
        if (listIds.size() <= 300) {
            sql.append("delete from T_HR_SHRUserAdminOrgPerm where FID in (");
            sql.append(suffix);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else {
            String tempTblName = null;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (Object object : listIds) {
                params.add(new Object[]{object});
            }
            try {
                tempTblName = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_HR_USERADMINORGPERMIDTMPTBL (FID varchar(44))");
                StringBuffer insertSqlBuf = new StringBuffer();
                insertSqlBuf.append("insert into ").append(tempTblName).append(" (FID) ").append(" VALUES (?)");
                DbUtil.executeBatch((Context)ctx, (String)insertSqlBuf.toString(), params);
                sql.append("delete from T_HR_SHRUserAdminOrgPerm where FID in (select fid from ").append(tempTblName).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty(tempTblName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTblName);
                }
            }
        }
        ShrPermissionCacheHelper.removeCacheByType(0);
    }

    @Override
    protected void _deleteUserAdminOrgPermByUserId(Context ctx, IObjectPK targetUserPK) throws BOSException {
        String userId = targetUserPK.toString();
        long begin = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm where fuserid = '").append(userId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        long end = System.currentTimeMillis();
        logger.error((Object)("Delete data : " + (end - begin)));
        ShrPermissionCacheHelper.removePermCache(0, userId);
    }

    @Override
    protected void _updateIsIncludeSubOrg(Context ctx, IObjectPK targetUserPK, boolean isIncludeSubOrg, List listIds) throws BOSException {
        String userId = targetUserPK.toString();
        StringBuffer sql = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        String tempTblName = null;
        try {
            this.getUpdateIsIncludeSubOrgFilter(ctx, listIds, filter, tempTblName);
            Map<String, List<Map<String, Object>>> allUserAdminOrgUnit = this.getIdAndLongNumber(ctx, userId, null);
            Map<String, List<Map<String, Object>>> selectedUserAdminOrgUnit = this.getIdAndLongNumber(ctx, userId, filter.toString());
            if (isIncludeSubOrg) {
                ArrayList<String> subOrgPermIds = new ArrayList<String>();
                this.getIsSurOrgPermIds(allUserAdminOrgUnit, selectedUserAdminOrgUnit, subOrgPermIds);
                if (subOrgPermIds.size() > 0) {
                    this._deleteUserAdminOrgPermById(ctx, subOrgPermIds);
                }
                sql.append(" update T_HR_SHRUserAdminOrgPerm set FIsIncludeSubOrg=1 where FIsIncludeSubOrg=0 and FID IN ").append(filter);
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else {
                sql.append(" update T_HR_SHRUserAdminOrgPerm set FIsIncludeSubOrg=0 where FIsIncludeSubOrg=1 and FID IN ").append(filter);
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            ShrPermissionCacheHelper.removePermCache(0, userId);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(tempTblName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTblName);
            }
        }
    }

    private void getIsSurOrgPermIds(Map<String, List<Map<String, Object>>> allUserAdminOrgUnit, Map<String, List<Map<String, Object>>> selectedUserAdminOrgUnit, List<String> subOrgPermIds) {
        Set<String> keySet = selectedUserAdminOrgUnit.keySet();
        for (String permItemId : keySet) {
            List<Map<String, Object>> allList = allUserAdminOrgUnit.get(permItemId);
            List<Map<String, Object>> selectedList = selectedUserAdminOrgUnit.get(permItemId);
            for (int i = 0; i < selectedList.size(); ++i) {
                String selectedLongNumber = (String)selectedList.get(i).get("FLongNumber");
                for (int j = 0; j < allList.size(); ++j) {
                    String orgPermId;
                    String allLongNumber = (String)allList.get(j).get("FLongNumber");
                    if (selectedLongNumber.equals(allLongNumber) || allLongNumber.indexOf(selectedLongNumber) != 0 || subOrgPermIds.contains(orgPermId = (String)allList.get(j).get("FID"))) continue;
                    subOrgPermIds.add(orgPermId);
                }
            }
        }
    }

    private void getUpdateIsIncludeSubOrgFilter(Context ctx, List<String> listIds, StringBuffer filter, String tempTblName) throws Exception {
        if (listIds.size() < 300) {
            Iterator<String> itr = listIds.iterator();
            filter.append(" (");
            while (itr.hasNext()) {
                String id = itr.next().toString();
                filter.append("'").append(id).append("',");
            }
            filter.deleteCharAt(filter.length() - 1).append(")");
        } else {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String object : listIds) {
                params.add(new Object[]{object});
            }
            tempTblName = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_HR_USERADMINORGPERMIDTEMPTABLE (FID varchar(44))");
            StringBuffer insertSqlBuf = new StringBuffer();
            insertSqlBuf.append("insert into ").append(tempTblName).append(" (FID) ").append(" VALUES (?)");
            DbUtil.executeBatch((Context)ctx, (String)insertSqlBuf.toString(), params);
            filter.append(" (select fid from ").append(tempTblName).append(")");
        }
    }

    private Map<String, List<Map<String, Object>>> getIdAndLongNumber(Context ctx, String userId, String filter) throws BOSException {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct aop.FID, org.FLongNumber, org.FID FAdminOrgID, aop.FPermItemId").append(" FROM T_HR_SHRUserAdminOrgPerm aop").append(" INNER JOIN T_ORG_Admin org ON aop.FAdminOrgID = org.FID").append(" where aop.FUserId = '").append(userId).append("'");
        if (filter != null) {
            sql.append(" and aop.FID IN ").append(filter);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String permItemId = rs.getString("FPermItemId");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("FID", rs.getString("FID"));
                map.put("FAdminOrgID", rs.getString("FAdminOrgID"));
                map.put("FLongNumber", rs.getString("FLongNumber"));
                ArrayList<HashMap<String, String>> list = null;
                if (result.containsKey(permItemId)) {
                    ((List)result.get(permItemId)).add(map);
                    continue;
                }
                list = new ArrayList<HashMap<String, String>>();
                list.add(map);
                result.put(permItemId, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected List _getUserAdminSubOrgPerm(Context ctx, IObjectPK targetUserPK, List listIds, List userAdminSubOrgPerm) throws BOSException {
        StringBuffer notIncludeSql = new StringBuffer();
        StringBuffer isIncludeSql = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        Iterator itr = listIds.iterator();
        filter.append(" (");
        while (itr.hasNext()) {
            String id = itr.next().toString();
            filter.append("'").append(id).append("',");
        }
        filter.deleteCharAt(filter.length() - 1).append(")");
        String l = LocaleUtils.getShortCode((Context)ctx);
        isIncludeSql.append("select parent.FName as 'parent.name',").append(" permItem.FNumber as 'permItem.number',").append(" permItem.FAlias_").append(l).append(" as 'permItem.alias',").append(" sub.FNumber as 'org.number',").append(" sub.FName_").append(l).append(" as 'org.name',").append(" shr.FIsIncludeSubOrg as 'isIncludeSubOrg',").append(" sub.FLongNumber as 'org.longnumber'").append(" from T_HR_SHRUserAdminOrgPerm as shr").append(" inner join T_PM_PermItem as permItem on shr.FPermItemId=permItem.FID").append(" inner join T_PM_PermItem as parent on permItem.FParentID=parent.FID").append(" inner join T_ORG_ADMIN as org on shr.FAdminOrgID=org.FID").append(" inner join T_ORG_ADMIN as sub on sub.FLongNumber like (SELECT T_ORG_ADMIN.FLongNumber||'%' FROM T_ORG_ADMIN WHERE T_ORG_ADMIN.FID=shr.FAdminOrgID) ").append(" where shr.FUserId='").append(targetUserPK.toString()).append("' and shr.FIsIncludeSubOrg=1 and shr.FID in ").append(filter);
        notIncludeSql.append("select parent.FName as 'parent.name',").append(" permItem.FNumber as 'permItem.number',").append(" permItem.FAlias_").append(l).append(" as 'permItem.alias',").append(" org.FNumber as 'org.number',").append(" org.FName_").append(l).append(" as 'org.name',").append(" shr.FIsIncludeSubOrg as 'isIncludeSubOrg',").append(" org.FLongNumber as 'org.longnumber'").append(" from T_HR_SHRUserAdminOrgPerm as shr").append(" inner join T_PM_PermItem as permItem on shr.FPermItemId=permItem.FID").append(" inner join T_PM_PermItem as parent on permItem.FParentID=parent.FID").append(" inner join T_ORG_ADMIN as org on shr.FAdminOrgID=org.FID").append(" where shr.FUserId='").append(targetUserPK.toString()).append("' and shr.FIsIncludeSubOrg=0 and shr.FID in ").append(filter);
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)isIncludeSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)notIncludeSql.toString());
        try {
            HashMap<String, String> map;
            while (rs1.next()) {
                map = new HashMap<String, String>();
                map.put("parentName", rs1.getString("parent.name"));
                map.put("permItemNumber", rs1.getString("permItem.number"));
                map.put("permItemAlias", rs1.getString("permItem.alias"));
                map.put("orgNumber", rs1.getString("org.number"));
                map.put("orgName", rs1.getString("org.name"));
                map.put("isIncludeSubOrg", rs1.getString("isIncludeSubOrg"));
                map.put("orgLongNumber", rs1.getString("org.longnumber"));
                userAdminSubOrgPerm.add(map);
            }
            while (rs.next()) {
                map = new HashMap();
                map.put("parentName", rs.getString("parent.name"));
                map.put("permItemNumber", rs.getString("permItem.number"));
                map.put("permItemAlias", rs.getString("permItem.alias"));
                map.put("orgNumber", rs.getString("org.number"));
                map.put("orgName", rs.getString("org.name"));
                map.put("isIncludeSubOrg", rs.getString("isIncludeSubOrg"));
                map.put("orgLongNumber", rs.getString("org.longnumber"));
                userAdminSubOrgPerm.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return userAdminSubOrgPerm;
    }
}

