/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.SHRAdminOrgRangeInSubOrgCollection;
import com.kingdee.shr.base.permission.SHRAdminOrgRangeInSubOrgFactory;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermCollection;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermFactory;
import com.kingdee.shr.base.permission.app.AbstractSHRUserOrgPermFacadeControllerBean;
import com.kingdee.shr.base.permission.helper.DataOperateHelper;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHRUserOrgPermFacadeControllerBean
extends AbstractSHRUserOrgPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.SHRUserOrgPermFacadeControllerBean");
    private PermItemInfo rootPermItem = null;

    @Override
    protected Map _getUserInfo(Context ctx, String userId) throws BOSException, EASBizException {
        return DataOperateHelper.getUserInfo(ctx, userId);
    }

    @Override
    protected UserOrgPermCollection _getHRPerms(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (orgCol.size() < 1) {
            return result;
        }
        try {
            if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)sourceUserPK)) {
                result = this.getTopSourceUOPs4CUAdmin(ctx, sourceUserPK, targetUserPK, orgCol, permType);
                return result;
            }
            result = UserOrgPermFacadeFactory.getLocalInstance((Context)ctx).getLevelViewUOPs(targetUserPK, orgCol, null, 10);
            return this.handResultUserOrgPermCollection(ctx, null, result);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, (Throwable)e);
        }
    }

    private UserOrgPermCollection getTopSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, int permType) throws EASBizException, BOSException {
        return this.getSourceUOPs4CUAdmin(ctx, sourceUserPK, targetUserPK, orgCol, null, permType);
    }

    @Override
    protected Set _getHasAccreditedPermSet(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, List permIdList, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        return UserOrgPermFacadeFactory.getLocalInstance((Context)ctx).getHasAccreditedPermSet(sourceUserPK, targetUserPK, permIdList, orgCol, permType);
    }

    @Override
    protected UserOrgPermCollection _getLevelSourceUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        try {
            if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)sourceUserPK)) {
                return this.getLevelSourceUOPs4CUAdmin(ctx, sourceUserPK, targetUserPK, orgCol, parentPerm, permType);
            }
            return this.getLevelSourceUOPs4Normal(ctx, sourceUserPK, targetUserPK, orgCol, parentPerm, isBatch, permType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, (Throwable)e);
        }
    }

    private UserOrgPermCollection getLevelSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws EASBizException, BOSException {
        return this.getSourceUOPs4Normal(ctx, sourceUserPK, targetUserPK, orgCol, parentPerm, isBatch, permType);
    }

    private UserOrgPermCollection getSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws EASBizException, BOSException {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (sourceUserPK == null || orgCol == null) {
            return result;
        }
        result = UserOrgPermFacadeFactory.getLocalInstance((Context)ctx).getLevelViewUOPs(targetUserPK, orgCol, parentPerm, 10);
        return this.handResultUserOrgPermCollection(ctx, parentPerm, result);
    }

    private UserOrgPermCollection getLevelSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws EASBizException, BOSException {
        return this.getSourceUOPs4CUAdmin(ctx, sourceUserPK, targetUserPK, orgCol, parentPerm, permType);
    }

    @Override
    protected UserOrgPermCollection _getLevelTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        return this.getTargetUOPs(ctx, sourceUserPK, targetUserPK, orgCol, parentPerm, permType);
    }

    private UserOrgPermCollection getTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (targetUserPK == null || orgCol == null) {
            return result;
        }
        if (!Administrator.isCUAdmin((Context)ctx, (IObjectPK)sourceUserPK) && permType == 30) {
            return result;
        }
        result = UserOrgPermFacadeFactory.getLocalInstance((Context)ctx).getLevelTargetUOPs(sourceUserPK, targetUserPK, orgCol, parentPerm, 10);
        return this.handResultUserOrgPermCollection(ctx, parentPerm, result);
    }

    @Override
    protected UserOrgPermCollection _getTopTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        return this.getTargetUOPs(ctx, sourceUserPK, targetUserPK, orgCol, null, permType);
    }

    private UserOrgPermCollection getSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (userPK == null || orgCol == null) {
            return result;
        }
        if (!Administrator.isCUAdmin((Context)ctx, (IObjectPK)sourceUserPK)) {
            return result;
        }
        result = UserOrgPermFacadeFactory.getLocalInstance((Context)ctx).getLevelViewUOPs(userPK, orgCol, parentPerm, 10);
        return this.handResultUserOrgPermCollection(ctx, parentPerm, result);
    }

    private UserOrgPermCollection handResultUserOrgPermCollection(Context ctx, PermItemInfo parentPerm, UserOrgPermCollection result) throws EASBizException, BOSException {
        String parentPermLongNumber = null;
        String rootPermLongNumber = this.getRootPermItem(ctx).getLongNumber();
        parentPermLongNumber = parentPerm == null ? rootPermLongNumber + "!" + "SHR_WEB" : parentPerm.getLongNumber();
        String perf070 = parentPermLongNumber + "!" + "070\u7ee9\u6548\u7ba1\u7406";
        String base105 = parentPermLongNumber + "!" + "105\u57fa\u7840\u8bbe\u7f6e";
        String org080 = parentPermLongNumber + "!" + "080\u7ec4\u7ec7\u7ba1\u7406";
        UserOrgPermCollection newResult = new UserOrgPermCollection();
        HashSet<String> set = new HashSet<String>();
        if (null != result && result.size() > 0) {
            int total = result.size();
            for (int i = 0; i < total; ++i) {
                UserOrgPermInfo item = result.get(i);
                if (set.contains(item.getPermItemId())) continue;
                set.add(item.getPermItemId());
                if (!StringUtils.isEmpty((String)item.getPermItemLongNumber()) && rootPermLongNumber.equals(item.getPermItemLongNumber())) {
                    newResult.add(item);
                }
                if (StringUtils.isEmpty((String)item.getPermItemLongNumber()) || !item.getPermItemLongNumber().startsWith(parentPermLongNumber) || item.getPermItemLongNumber().startsWith(perf070) || item.getPermItemLongNumber().startsWith(base105) || item.getPermItemLongNumber().startsWith(org080)) continue;
                newResult.add(item);
            }
        }
        return newResult;
    }

    private PermItemInfo getRootPermItem(Context ctx) throws BOSException, EASBizException {
        if (this.rootPermItem != null) {
            return this.rootPermItem;
        }
        String oql = "select id,longNumber where parent is null ";
        this.rootPermItem = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo(oql);
        return this.rootPermItem;
    }

    @Override
    protected SHRAdminOrgRangeInSubOrgCollection _getAdminOrgRangeInSubOrgCollection(Context ctx, String userId, String permItemId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("permItem.id", (Object)permItemId, CompareType.EQUALS));
        EntityViewInfo view = this.getSHRAdminOrgRangeInSubOrgEntityViewInfo();
        view.setFilter(filter);
        SHRAdminOrgRangeInSubOrgCollection collection = SHRAdminOrgRangeInSubOrgFactory.getLocalInstance(ctx).getSHRAdminOrgRangeInSubOrgCollection(view);
        return collection;
    }

    @Override
    protected UserOrgPermCollection _assembleTempUserOrgPermColl(Context ctx, String userId) throws BOSException {
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        String sql = "select distinct FPermItemID from T_PM_RolePerm where froleId in (select FRoleID from T_PM_UserRoleOrg where fuserID ='" + userId + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String permItemId = rs.getString("FPERMITEMID");
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userId));
                PermItemInfo permInfo = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(permItemId));
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.AUTHORIZATION);
                uopInfo.setOwner(userInfo);
                userOrgPerms.add(uopInfo);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return userOrgPerms;
    }

    @Override
    protected boolean _getHRVerifyingPermParam(Context ctx) throws BOSException, EASBizException {
        boolean isFromHR = false;
        String returnValue = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"HR_VerifyingPermissions", null, (boolean)true);
        if (returnValue.equalsIgnoreCase("true")) {
            isFromHR = true;
        }
        return isFromHR;
    }

    @Override
    protected SHRUserAdminOrgPermCollection _getUserAdminOrgPermCollection(Context ctx, String userId, String permItemId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("permItem.id", (Object)permItemId, CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("adminOrg.longNumber"));
        EntityViewInfo view = this.getSHRUserAdminOrgPermEntityViewInfo();
        view.setFilter(filter);
        view.setSorter(sorter);
        SHRUserAdminOrgPermCollection collection = SHRUserAdminOrgPermFactory.getLocalInstance(ctx).getSHRUserAdminOrgPermCollection(view);
        return collection;
    }

    private EntityViewInfo getSHRUserAdminOrgPermEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("adminOrg.longNumber"));
        selector.add(new SelectorItemInfo("isIncludeSubOrg"));
        selector.add(new SelectorItemInfo("isForbidden"));
        view.setSelector(selector);
        return view;
    }

    private EntityViewInfo getSHRAdminOrgRangeInSubOrgEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("adminOrg.longNumber"));
        selector.add(new SelectorItemInfo("isIncludeSubOrg"));
        view.setSelector(selector);
        return view;
    }
}

