/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemURLCollection;
import com.kingdee.eas.base.permission.PermItemURLInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public abstract class SHRMenuServiceHelper {
    private static Logger logger = Logger.getLogger(SHRMenuServiceHelper.class);
    private static final String CACHE_TYPE = "shr.serviceMenu";

    public static ServiceInfo getServiceMenuInfoFromCache(String key) {
        return (ServiceInfo)CacheService.getInstance().get(CACHE_TYPE, key);
    }

    public static void addServiceMenuInfo(String key, ServiceInfo serviceInfo) {
        CacheService.getInstance().put(CACHE_TYPE, key, (Object)serviceInfo);
    }

    public static void clearServiceInfo(String key) {
        CacheService.getInstance().remove(CACHE_TYPE, key);
    }

    public static ServiceInfo getServiceMenuInfoFromDb(String key) {
        return SHRMenuServiceHelper.getServiceMenuInfoFromDb(null, key);
    }

    public static ServiceInfo getServiceMenuInfoFromDb(Context ctx, String key) {
        ServiceInfo serviceInfo = new ServiceInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("alias"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("permission.id"));
        selector.add(new SelectorItemInfo("permission.name"));
        selector.add(new SelectorItemInfo("permission.number"));
        selector.add(new SelectorItemInfo("permission.alias"));
        selector.add(new SelectorItemInfo("permission.orgRelation"));
        selector.add(new SelectorItemInfo("permission.type"));
        selector.add(new SelectorItemInfo("permission.urls"));
        selector.add(new SelectorItemInfo("permission.urls.url"));
        try {
            logger.info((Object)(" [ getServiceMenuInfoFromDb , + key is " + key + " ]"));
            serviceInfo = null == ctx ? ServiceFactory.getRemoteInstance().getServiceInfo((IObjectPK)new ObjectUuidPK(key), selector) : ServiceFactory.getLocalInstance((Context)ctx).getServiceInfo((IObjectPK)new ObjectUuidPK(key), selector);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)(" [ getServiceMenuInfoFromDb , + key is " + key + " ]"));
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)(" [ getServiceMenuInfoFromDb , + key is " + key + " ]"));
        }
        return serviceInfo;
    }

    public static String getServicePermissionUrl0(String serviceId) {
        return SHRMenuServiceHelper.getServicePermissionUrl0(null, serviceId);
    }

    public static String getServicePermissionUrl0(Context ctx, String serviceId) {
        PermItemURLInfo permItemUrlInfo;
        PermItemURLCollection urlColl;
        PermItemInfo permissionInfo;
        ServiceInfo serviceInfo = SHRMenuServiceHelper.getServiceMenuInfo(ctx, serviceId);
        String url0 = "";
        if (serviceInfo != null && (permissionInfo = serviceInfo.getPermission()) != null && (urlColl = permissionInfo.getUrls()) != null && !urlColl.isEmpty() && (permItemUrlInfo = urlColl.get(0)) != null) {
            url0 = permItemUrlInfo.getUrl();
        }
        return url0;
    }

    public static ServiceInfo getServiceMenuInfo(Context ctx, String serviceId) {
        ServiceInfo serviceInfo = SHRMenuServiceHelper.getServiceMenuInfoFromCache(serviceId);
        if (null == serviceInfo) {
            logger.info((Object)(" [ getServicePermissionId serviceInfo is null , + key is " + serviceId + " ]"));
            serviceInfo = SHRMenuServiceHelper.getServiceMenuInfoFromDb(ctx, serviceId);
            if (serviceInfo != null) {
                SHRMenuServiceHelper.addServiceMenuInfo(serviceId, serviceInfo);
            }
        }
        return serviceInfo;
    }

    public static PermItemInfo getPermItemInfoByServiceId(String serviceId) {
        return SHRMenuServiceHelper.getPermItemInfoByServiceId(null, serviceId);
    }

    public static PermItemInfo getPermItemInfoByServiceId(Context ctx, String serviceId) {
        ServiceInfo serviceInfo = SHRMenuServiceHelper.getServiceInfo(ctx, serviceId);
        PermItemInfo permissionInfo = null;
        if (serviceInfo != null) {
            permissionInfo = serviceInfo.getPermission();
        }
        return permissionInfo;
    }

    public static ServiceInfo getServiceInfo(Context ctx, String serviceId) {
        if (StringUtils.isEmpty((String)serviceId)) {
            return null;
        }
        String realServiceId = serviceId;
        try {
            realServiceId = URLDecoder.decode(serviceId, "UTF-8");
            realServiceId = realServiceId.replace(" ", "+");
        }
        catch (Exception e) {
            realServiceId = serviceId;
        }
        ServiceInfo serviceInfo = SHRMenuServiceHelper.getServiceMenuInfoFromCache(realServiceId);
        if (null == serviceInfo) {
            logger.info((Object)(" [ getServicePermissionId serviceInfo is null , + key is " + realServiceId + " ]"));
            serviceInfo = SHRMenuServiceHelper.getServiceMenuInfoFromDb(ctx, realServiceId);
            if (serviceInfo != null) {
                SHRMenuServiceHelper.addServiceMenuInfo(realServiceId, serviceInfo);
            }
        }
        return serviceInfo;
    }

    public static String getFunctionPermissionsByMenu(Context ctx) throws EASBizException, BOSException {
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        boolean isCertifyAdminEnabled = PermissionCommonUtil.isAuthenticateAdminEnabled((Context)ctx);
        boolean isIDAuthorizeEnabled = PermissionCommonUtil.isIDAuthorizeEnabled((Context)ctx);
        boolean isAuditAdminEnabled = PermissionCommonUtil.isAuditAdminEnabled((Context)ctx);
        StringBuffer sql = new StringBuffer();
        if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)ctx.getCaller())) {
            String excludePermItem = "'bs_certify_authenticateAdmin','bs_permission_authenrecord_deal'";
            if (isCertifyAdminEnabled) {
                excludePermItem = excludePermItem + "," + "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'" + ",'bs_permission_IDSecondAuthenticate'";
            } else if (!isIDAuthorizeEnabled) {
                excludePermItem = excludePermItem + "," + "'bs_permission_IDSecondAuthenticate'";
            }
            excludePermItem = excludePermItem + ",'bs_permission_auditAdmin'";
            sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND ( FType = ").append(10).append(" AND FName NOT IN  (").append(excludePermItem).append(")").append(" OR FType = ").append(15).append(" OR FType = ").append(30).append(" ) ");
        } else if (isAuditAdminEnabled && Administrator.isAuditAdmin((Context)ctx, (IObjectPK)ctx.getCaller())) {
            sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN (").append("'bs_permission_auditAdmin','bs_log_config'").append(")");
        } else if (Administrator.isBizAdmin((Context)ctx, (IObjectPK)ctx.getCaller())) {
            sql.append(SHRPermissionSQL.getUserPermItemIdRangeSQL(userID)).append(" UNION all ").append(" SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(15);
        } else {
            sql.append(SHRPermissionSQL.getUserPermItemIdRangeSQL(userID));
        }
        if (Administrator.isCertifyAdmin((Context)ctx, (IObjectPK)ctx.getCaller())) {
            sql.append(" UNION All ");
            if (isCertifyAdminEnabled) {
                String includePermItem = "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'";
                if (isIDAuthorizeEnabled) {
                    includePermItem = includePermItem + ",'bs_permission_IDSecondAuthenticate'";
                }
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN (").append(includePermItem).append(")");
                if (!"00000000-0000-0000-0000-00000000000113B7DE7F".equals(ctx.getCaller().toString())) {
                    sql.append(" AND FName NOT IN ('").append("bs_certify_authenticateAdmin").append("')");
                }
            } else if ("00000000-0000-0000-0000-00000000000113B7DE7F".equals(ctx.getCaller().toString())) {
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN ('").append("bs_certify_authenticateAdmin").append("')");
            } else {
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN ('')");
            }
        }
        return sql.toString();
    }
}

