/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.util.HrPermissionTools;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class SHRPermissionSQL {
    public static Logger logger = Logger.getLogger(SHRPermissionSQL.class);

    public static String assembleAssignedPermItemSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select userOrgperm.* from t_pm_userorgperm userOrgperm ");
        sql.append(" inner join T_PM_PermItem permItem on permItem.FID  = userOrgperm.FPERMITEMID ");
        sql.append(" where  permItem.FLONGINDEX LIKE '1000%' ");
        sql.append(" and userOrgperm.FOWNER = ?");
        return sql.toString();
    }

    public static String assembleUserBaseInfoSQL(Context ctx) {
        String LocaleString = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select u.fname_").append(LocaleString).append(" userName ");
        sql.append(" ,u.fnumber userNumber ");
        sql.append(" ,person.fname_").append(LocaleString).append(" personName ");
        sql.append(" ,t0.fName_").append(LocaleString).append(" adminOrgName ");
        sql.append(" ,t0.fdisplayName_").append(LocaleString).append(" adminOrgLongName ");
        sql.append(" ,position.fname_").append(LocaleString).append(" postionName ");
        sql.append(" from t_pm_user u ");
        sql.append(" inner join  t_bd_person person on u.fpersonid = person.fid ");
        sql.append(" left join  t_org_positionmember member on  member.fpersonid =  person.fid and member.fisprimary = 1");
        sql.append(" left join T_ORG_POSITION position on position.fid = member.FPositionID ");
        sql.append(" left join  t_org_admin t0 on t0.fid = position.fadminorgunitid ");
        sql.append(" where 1=1 ");
        sql.append(" and u.fid = ? ");
        return sql.toString();
    }

    public static String assembleSHRUserAdminOrgPermInsertSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_HR_SHRUserAdminOrgPerm (FID,FPermItemId,FCtrlUnitId,FUserId,FPermType,FAdminOrgID,FIsIncludeSubOrg,FIsForbidden) ");
        sql.append(" VALUES ( newbosid('F347821F'),?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getUserAdminOrgRangeSQL(Context ctx, String userId, String permItemId) {
        if (SHRPermissionSQL.hasHRUserAdminOrgRange(ctx, userId, permItemId)) {
            return SHRPermissionSQL.getHRUserAdminOrgRangeSql(userId, permItemId);
        }
        return SHRPermissionSQL.getEASUserAdminOrgRangeSql(userId);
    }

    public static boolean hasHRUserAdminOrgRange(Context ctx, String userId, String permItemId) {
        StringBuffer where0 = new StringBuffer();
        where0.append("SELECT count(FAdminOrgID) t0 FROM T_HR_SHRUserAdminOrgPerm  ");
        where0.append(" where FUserId = ?");
        where0.append(" and FPermItemId = ?");
        where0.append(" and FIsForbidden = 0");
        StringBuffer where1 = new StringBuffer();
        where1.append("SELECT count(t0.FAdminOrgID) pcount FROM T_HR_SHRRoleAdminOrgPerm t0 ");
        where1.append("inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID ");
        where1.append("where t0.FUserId = ? and t2.FPermItemId = ? and t0.FIsForbidden = 0 ");
        where1.append("and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = ?)");
        Object[] params = new Object[]{userId, permItemId};
        Object[] params2 = new Object[]{userId, permItemId, userId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)where0.toString(), (Object[])params);
            if (rs.next() && rs.getInt("t0") > 0) {
                return true;
            }
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)where1.toString(), (Object[])params2);
            if (rs2.next() && rs2.getInt("pcount") > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getHRUserAdminOrgRangeSql(String userId, String permItemId, Integer isStartShr, Integer isSealUp) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FAdminOrgID FROM T_HR_SHRUserAdminOrgPerm  ");
        sql.append(" where FUserId = '").append(userId).append("'");
        sql.append(" and FPermItemId = '").append(permItemId).append("'");
        sql.append(" and FIsForbidden = 0 ");
        sql.append(" and FIsIncludeSubOrg = 0 ");
        sql.append(" union ");
        sql.append(" SELECT org.FID FAdminOrgID FROM  (");
        sql.append(" SELECT perm.FAdminOrgID,t0.FLONGNUMBER  FROM T_HR_SHRUserAdminOrgPerm perm ");
        sql.append(" inner join T_ORG_Admin t0 ");
        sql.append(" on perm.FAdminOrgID = t0.FID ");
        sql.append(" where perm.fuserid = '").append(userId).append("'");
        sql.append(" and perm.fpermItemId = '").append(permItemId).append("'");
        sql.append(" and perm.FIsIncludeSubOrg = 1 and perm.FIsForbidden = 0 ");
        sql.append(" ) detail ");
        sql.append(" inner join T_ORG_Admin org ");
        sql.append(" on ( CHARINDEX( concat(detail.flongnumber,'!'),org.flongnumber )=1 ");
        sql.append(" or detail.flongnumber = org.flongnumber)");
        if (null != isStartShr) {
            sql.append(" and org.FISSTARTSHR = " + isStartShr);
        }
        if (null != isSealUp) {
            sql.append(" and org.FIsSealUp = " + isSealUp);
        }
        sql.append(" union  ");
        sql.append("SELECT t0.FAdminOrgID FROM T_HR_SHRRoleAdminOrgPerm t0 ");
        sql.append("inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID ");
        sql.append("where t0.FUserId = '").append(userId).append("' and t2.FPermItemId = '").append(permItemId).append("' and t0.FIsForbidden = 0 and t0.FIsIncludeSubOrg = 0 ");
        sql.append("and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = '").append(userId).append("') ");
        sql.append("union  ");
        sql.append("SELECT org.FID FAdminOrgID FROM  ( ");
        sql.append("SELECT perm.FAdminOrgID,t0.FLONGNUMBER  FROM T_HR_SHRRoleAdminOrgPerm perm ");
        sql.append("inner join T_PM_RolePerm t2 on t2.FROLEID=perm.FROLEID ");
        sql.append("inner join T_ORG_Admin t0 on perm.FAdminOrgID = t0.FID   ");
        sql.append("where perm.fuserid = '").append(userId).append("' and t2.FPermItemId = '").append(permItemId).append("' ");
        sql.append("and perm.FIsIncludeSubOrg = 1 and perm.FIsForbidden = 0  ");
        sql.append("and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=perm.FRoleID and t1.FUserId = '").append(userId).append("') ");
        sql.append(") detail   ");
        sql.append("inner join T_ORG_Admin org ");
        sql.append("on ( CHARINDEX( concat(detail.flongnumber,'!'),org.flongnumber )=1 ");
        sql.append("or detail.flongnumber = org.flongnumber)  ");
        if (null != isStartShr) {
            sql.append(" and org.FISSTARTSHR = " + isStartShr);
        }
        if (null != isSealUp) {
            sql.append(" and org.FIsSealUp = " + isSealUp);
        }
        return sql.toString();
    }

    public static String getHRUserAdminOrgRangeSql(String userId, String permItemId) {
        return SHRPermissionSQL.getHRUserAdminOrgRangeSql(userId, permItemId, null, null);
    }

    public static String getEASUserAdminOrgRangeSql(String userId) {
        return HrPermissionTools.getUserAdaminOrgRangeSql((String)userId);
    }

    public static String getUserPermItemIdRangeSQL(String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT USERORGPERM.FPermItemID FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = '").append(userId).append("'").append(" AND UserOrgPerm.FPermType = ").append(10).append(" AND EXISTS (SELECT 1 from t_org_hro where fid = USERORGPERM.Forgid and FISSEALUP = 0) ").append(" UNION ALL ").append(" SELECT RolePerm.FPermItemID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userId).append("'").append(" AND RolePerm.FPermType = ").append(10).append(" AND EXISTS (SELECT 1 from t_org_hro where fid = UserRoleOrg.Forgid and FISSEALUP = 0)");
        return sql.toString();
    }

    public static String assembleSHRAdminOrgRangeInSubOrgInsertSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_HR_AdminOrgRangeInSubOrg (FID,FPermItemId,FUserId,FAdminOrgID) ");
        sql.append(" VALUES ( newbosid('A06F8FA2'),?,?,? )");
        return sql.toString();
    }

    public static String assembleSHRUserAdminOrgPermDelSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm ");
        sql.append(" where FUserId = ? and FPermItemId = ? and FAdminOrgID = ? ");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPermFromDelRecord(String userId, String permItemId, String orgIds) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm ");
        sql.append(" where FUserId = ? and FPermItemId = ? and FAdminOrgID in ( ").append(orgIds).append(")");
        return sql.toString();
    }

    public static String delSHRUserAdminOrgPermByRolePermChange() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm ");
        sql.append(" where FUserId = ? and FPermItemId = ? ");
        return sql.toString();
    }

    public static String assembleAdminOrgRangeInSubOrgDelSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_AdminOrgRangeInSubOrg ");
        sql.append(" where FUserId = ? and FPermItemId = ? and FAdminOrgID = ? ");
        return sql.toString();
    }

    public static String delAdminOrgRangeInSubOrgByRolePermChange() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_AdminOrgRangeInSubOrg ");
        sql.append(" where FUserId = ? and FPermItemId = ? ");
        return sql.toString();
    }

    public static String delAdminOrgRangeInSubOrgByRolePermChange(String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_AdminOrgRangeInSubOrg where FUserId = '").append(userId).append("'");
        return sql.toString();
    }

    public static String getUserPermItems() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  FPermItemID FROM t_pm_userorgperm  where FOwner =?");
        sql.append(" union ");
        sql.append(" SELECT FPERMITEMID  FROM T_PM_RolePerm where FROLEID = (SELECT FROLEID  FROM T_PM_UserRoleOrg where FUSERID =? )");
        return sql.toString();
    }

    public static String assembleAdminOrgRangeInSubOrgInsertSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_HR_AdminOrgRangeInSubOrg (FID,FUserId,FAdminOrgID,FIsIncludeSubOrg,FPermItemId) VALUES ( newbosid('A06F8FA2'),?,?,?,?)");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPerm() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm ");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPerm(String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm where FUserId = '").append(userId).append("'");
        return sql.toString();
    }

    public static String deleteAdminOrgPermByUserAndPerms(String userId, String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm where FUserId = ? And FPermItemId in (").append(filter).append(")");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPermByOrgs(String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm where FAdminOrgID in (").append(filter).append(")");
        return sql.toString();
    }

    public static String deleteAdminOrgPermByUserAndPerms() {
        return " delete from T_HR_SHRUserAdminOrgPerm where FUserId = ? And FPermItemId = ? ";
    }

    public static String deleteSHRUserAdminOrgPermByOrgs() {
        return " delete from T_HR_SHRUserAdminOrgPerm where FAdminOrgID = ? ";
    }

    public static String deleteSHRUserAdminOrgPermByOrg() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_SHRUserAdminOrgPerm where FAdminOrgID = ? ");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPermInSubByOrgs(String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_AdminOrgRangeInSubOrg where FAdminOrgID in (").append(filter).append(")");
        return sql.toString();
    }

    public static String deleteSHRUserAdminOrgPermInSubByOrg() {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_AdminOrgRangeInSubOrg where FAdminOrgID = ? ");
        return sql.toString();
    }

    public static String getUserPermInfo() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT u.FID as userId ,userPerm.FPermItemID as permItemID,userPerm.FPermType as PermType,userPerm.FCTRLUNITID as CTRLUNITID,orgRange.FORGID as orgId ");
        sql.append(" FROM t_pm_userorgperm userPerm ");
        sql.append(" inner join t_pm_user u ");
        sql.append(" on userPerm.FOwner = u.FID  ");
        sql.append(" INNER JOIN T_PM_PermItem PermItem ");
        sql.append(" on userPerm.FPERMITEMID = PermItem.FID");
        sql.append(" and PermItem.FLONGNUMBER LIKE 'EAS\u7cfb\u7edf!SHR_WEB%' ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ");
        sql.append(" on userPerm.FORGID = orgRange.FORGID  ");
        return sql.toString();
    }

    public static String getUserAllHrAdnAdminRangeSQL(String userId, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT adminOrg.fadminorgId FROM  T_HR_SHRUserAdminOrgPerm adminOrg ,T_HR_AdminOrgRangeInSubOrg hrOrg ");
        sql.append(" where adminOrg.FUserId= ").append("'").append(userId).append("'").append(" AND adminOrg.FPermItemId = ").append("'").append(permItemId).append("'");
        sql.append(" AND hrOrg.FUserId= ").append("'").append(userId).append("'").append(" AND hrOrg.FPermItemId = ").append("'").append(permItemId).append("'");
        return sql.toString();
    }

    public static String getRoleIdByUser(String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  DISTINCT FROLEID  FROM T_PM_UserRoleOrg WHERE FUSERID = ").append("'").append(userId).append("'");
        return sql.toString();
    }

    public static String getManagerOrg() {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateStr = format.format(new Date());
        sql.append("select top 1 e.fpersonid , e.FADMINORGID, org.FLONGNUMBER").append(" from T_HR_EmpOrgRelation e").append(" INNER JOIN  t_org_admin org ").append(" on org.FID  = e.FADMINORGID ").append(" inner join t_org_position p1 on p1.fid = e.fpositionid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and e.fpersonid = ?").append(" and (").append(" p1.fisrespposition = 1").append(" or p1.fid in (select fparentid from t_org_position) ").append(")");
        return sql.toString();
    }

    public static String getManagerOrgIncluSub(String longNumber) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_org_admin ");
        sql.append(" where FLONGNUMBER like '").append(longNumber).append("%").append("'");
        return sql.toString();
    }

    public static String getManageHrOrg(String adminOrgId, String bizManageTypeID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FManageHrOrgID from T_HR_AdminOrgBURelation ");
        sql.append(" where FAdminOrgID = '").append(adminOrgId).append("'");
        sql.append(" AND FBizManageTypeID = '").append(bizManageTypeID).append("'");
        return sql.toString();
    }

    public static String getUserPermItemsByRoleId() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  a.fuserid, b.fpermitemID FROM T_PM_USERROLEORG a ");
        sql.append(" INNER JOIN T_PM_USERORGPERM  b ");
        sql.append(" ON a.FUSERID = b.FOWNER ");
        sql.append(" WHERE FROLEID = ?");
        return sql.toString();
    }

    public static String getUserAdminOrgsByRoleId() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FUSERID ,b.FORGID  FROM T_PM_UserRoleOrg a ");
        sql.append(" INNER JOIN T_PM_OrgRange b ");
        sql.append(" ON a.FUSERID = b.FUSERID ");
        sql.append(" where a.FROLEID = ?");
        return sql.toString();
    }

    public static String getUserPermItemsByUsers(String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FOWNER , FPERMITEMID FROM t_pm_userorgperm");
        sql.append(" WHERE FOWNER in (").append(filter).append(")");
        return sql.toString();
    }

    public static String getUserAdminOrgsByUsers(String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT fuserId, forgId FROM T_PM_OrgRange ");
        sql.append(" WHERE fuserId in (").append(filter).append(")");
        return sql.toString();
    }

    public static String getUserRoleOrgPermByUserId() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FUSERID,a.FORGID,b.FPERMITEMID FROM T_PM_UserRoleOrg a ");
        sql.append(" INNER JOIN T_PM_RolePerm b ");
        sql.append(" ON a.FROLEID = b.FROLEID ");
        sql.append(" where a.FUSERID = ? ");
        return sql.toString();
    }

    public static String getAllUserPermInfo() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT fuserid, fpermItemId,FpermType FROM T_HR_SHRUserAdminOrgPerm ");
        return sql.toString();
    }

    public static String checkIsInSub() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FUserID, FPermItemID FROM T_HR_AdminOrgRangeInSubOrg ");
        sql.append(" WHERE FAdminOrgID = ? ");
        sql.append(" AND FIsIncludeSubOrg = 1 ");
        return sql.toString();
    }

    public static String getUserPermItemsByOrgId() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FUserID, FPermItemID FROM T_HR_SHRUserAdminOrgPerm ");
        sql.append(" WHERE FAdminOrgID = ? ");
        return sql.toString();
    }

    public static String getSHRUserAdminOrgPermByOrgs(String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FUserID, FPermItemID FROM T_HR_SHRUserAdminOrgPerm ");
        sql.append(" WHERE FAdminOrgID in (").append(filter).append(")");
        return sql.toString();
    }

    public static String getExistsOrIncludeSubOrgSql(String userId, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct org.FID, org.FLongNumber, aop.FIsIncludeSubOrg, aop.FPermItemId").append(" FROM T_HR_SHRUserAdminOrgPerm aop").append(" INNER JOIN T_ORG_Admin org ON aop.FAdminOrgID = org.FID");
        sql.append(" where 1=1");
        sql.append(" AND aop.FUserId = '").append(userId).append("'");
        if (!StringUtils.isEmpty((String)permItemId)) {
            sql.append(" AND aop.FPermItemId = '").append(permItemId).append("'");
        }
        return sql.toString();
    }

    public static String getUserHeadOfDepartmentAdminOrgRangeSQL(Context ctx, String userId, String permItemId) {
        return SHRPermissionSQL.getUserHeadOfDepartmentAdminOrgRangeSQL(ctx, userId, permItemId, true);
    }

    public static String getUserHeadOfDepartmentAdminOrgRangeSQL(Context ctx, String userId, String permItemId, boolean isUnionAll) {
        StringBuilder result = new StringBuilder();
        result.append(SHRPermissionSQL.getUserAdminOrgRangeSQL(ctx, userId, permItemId));
        if (isUnionAll) {
            result.append(" UNION ALL ");
        } else {
            result.append(" UNION ");
        }
        result.append("SELECT CHILD.FID AS FAdminOrgID ");
        result.append("FROM T_HR_EMPORGRELATION EMPRELATION ");
        result.append("INNER JOIN T_PM_USER PMUSER ON PMUSER.FPERSONID = EMPRELATION.FPERSONID ");
        result.append("INNER JOIN T_ORG_POSITION POSITION ON POSITION.FID= EMPRELATION.FPOSITIONID ");
        result.append("INNER JOIN T_ORG_ADMIN ADCOUNT ON POSITION.FADMINORGUNITID = ADCOUNT.FID ");
        result.append("LEFT JOIN T_ORG_ADMIN CHILD ON (CHARINDEX(CONCAT(ADCOUNT.FLONGNUMBER,'!'),CHILD.FLONGNUMBER) = 1 OR ADCOUNT.FLONGNUMBER = CHILD.FLONGNUMBER) ");
        result.append("WHERE PMUSER.FID = '").append(userId).append("' ");
        result.append("AND EMPRELATION.FISSYSTEM = 1 ");
        result.append("AND EMPRELATION.FLEFFDT =  {ts '2199-12-31'} ");
        result.append("AND EMPRELATION.FISLATESTINADAY = 1 ");
        result.append("AND POSITION.FISRESPPOSITION = 1 ");
        result.append("AND CHILD.FISSEALUP = 0 ");
        result.append("AND CHILD.FISSTARTSHR = 1 ");
        return result.toString();
    }
}

