/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.recuritment.ApplyRecordCollection;
import com.kingdee.shr.recuritment.ApplyRecordFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecInfoFacadeFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationCollection;
import com.kingdee.shr.recuritment.ResumeClipRelationFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationInfo;
import com.kingdee.shr.recuritment.ResumeFocusOnCollection;
import com.kingdee.shr.recuritment.ResumeFocusOnFactory;
import com.kingdee.shr.recuritment.app.AbstractArchivesQueryFacadeControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ArchivesQueryFacadeControllerBean
extends AbstractArchivesQueryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.ArchivesQueryFacadeControllerBean");

    @Override
    protected Map _getArchivesInfo(Context ctx, String archivesId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        EnterpriseArchivesInfo archivesInfo = null;
        try {
            archivesInfo = EnterpriseArchivesFactory.getLocalInstance(ctx).getEnterpriseArchivesInfo("select name,number,recuritPosition.name,gender,age,wed.name,hDegree.name,workSeniority,graduteSchool,major,lastCompany,lastJob,email,mobilePhone,warehouseEntry,uniqId,resSource.name,isBlackList,candidateType where id='" + archivesId + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (archivesInfo != null) {
            map.put("personName", archivesInfo.getName());
            map.put("number", archivesInfo.getNumber());
            map.put("recuritPosition", archivesInfo.getRecuritPosition() != null ? archivesInfo.getRecuritPosition().getName() : "");
            if (archivesInfo.getGender() != null) {
                if (1 == archivesInfo.getGender().getValue()) {
                    map.put("gender", "\u7537");
                } else {
                    map.put("gender", "\u5973");
                }
                map.put("genderValue", archivesInfo.getGender().getValue());
            }
            map.put("age", archivesInfo.getAge());
            map.put("wed", archivesInfo.getWed() == null ? "\u5a5a\u59fb\u72b6\u51b5\u672a\u77e5" : archivesInfo.getWed().getName());
            map.put("workSeniority", archivesInfo.getWorkSeniority());
            map.put("hDegree", archivesInfo.getHDegree() == null ? "" : archivesInfo.getHDegree().getName());
            map.put("school", StringUtils.isEmpty((CharSequence)archivesInfo.getGraduteSchool()) ? "\u672a\u77e5\u5b66\u6821" : archivesInfo.getGraduteSchool());
            map.put("major", StringUtils.isEmpty((CharSequence)archivesInfo.getMajor()) ? "" : archivesInfo.getMajor());
            map.put("lastCompany", StringUtils.isEmpty((CharSequence)archivesInfo.getLastCompany()) ? "" : archivesInfo.getLastCompany());
            map.put("lastJob", StringUtils.isEmpty((CharSequence)archivesInfo.getLastJob()) ? "" : archivesInfo.getLastJob());
            map.put("email", StringUtils.isEmpty((CharSequence)archivesInfo.getEmail()) ? "" : archivesInfo.getEmail());
            map.put("mobilePhone", StringUtils.isEmpty((CharSequence)archivesInfo.getMobilePhone()) ? "" : archivesInfo.getMobilePhone());
            map.put("warehouseEntry", archivesInfo.getWarehouseEntry() == null ? "" : sdf.format(archivesInfo.getWarehouseEntry()));
            map.put("resumeState", "");
            map.put("resumeStateNumber", "");
            String uuid = archivesInfo.getUniqId();
            map.put("recuritmentDemand", "");
            if (!StringUtils.isEmpty((CharSequence)uuid)) {
                map.put("uuid", uuid);
                ResumeBaseRecCollection resumeBaseRecCollection = ResumeBaseRecFactory.getLocalInstance(ctx).getResumeBaseRecCollection("select recuritmentDemand.id,recuritmentDemand.recuritmentType,recuritmentDemand.department.displayName,resumeState.name,resumeState.number,resumeFilePath,outerId where ifSimplePerson ='" + uuid + "' order by createTime desc");
                if (resumeBaseRecCollection.size() > 0) {
                    ResumeBaseRecInfo resume = resumeBaseRecCollection.get(0);
                    RecuritmentDemandInfo recDemandInfo = resume.getRecuritmentDemand();
                    map.put("resumeTab", resume.getResumeFilePath());
                    map.put("outerId", resume.getOuterId());
                    map.put("resumeState", resume.getResumeState() != null ? resume.getResumeState().getName() : "");
                    map.put("resumeStateNumber", resume.getResumeState() != null ? resume.getResumeState().getNumber() : "");
                    map.put("recuritmentType", recDemandInfo != null ? recDemandInfo.getRecuritmentType() : "");
                    if (recDemandInfo.getDepartment() != null && !StringUtils.isEmpty((CharSequence)recDemandInfo.getDepartment().getDisplayName())) {
                        map.put("department", recDemandInfo.getDepartment().getDisplayName());
                    } else {
                        map.put("department", "");
                    }
                    map.put("recuritmentDemand", recDemandInfo != null && recDemandInfo.getId() != null ? recDemandInfo.getId().toString() : "");
                }
                ApplyRecordCollection applyRecordCollection = ApplyRecordFactory.getLocalInstance(ctx).getResumeApplyRecords(uuid);
                int size = applyRecordCollection.size();
                if (applyRecordCollection.size() > 0) {
                    ArrayList resumeIds = Lists.newArrayList();
                    for (int i = 0; i < applyRecordCollection.size(); ++i) {
                        String resumeId;
                        ResumeBaseRecInfo resumeBaseRec = applyRecordCollection.get(i).getResumeBaseRec();
                        if (resumeBaseRec == null || resumeIds.contains(resumeId = resumeBaseRec.getId().toString())) continue;
                        resumeIds.add(resumeId);
                    }
                    size = resumeIds.size();
                }
                map.put("applyRecord", size);
            }
            if (archivesInfo.getResSource() != null) {
                map.put("resSource", archivesInfo.getResSource().getName());
            }
            if (archivesInfo.getIsBlackList() != null) {
                map.put("isBlackList", archivesInfo.getIsBlackList().getValue());
            }
            if (archivesInfo.getCandidateType() != null) {
                map.put("candidateType", archivesInfo.getCandidateType().getAlias());
            }
            map.put("hrOrgUnitId", archivesInfo.getHrOrgUnit() != null ? archivesInfo.getHrOrgUnit().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4");
            ResumeClipRelationCollection coll = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationCollection("select resumeClip.name,resumeClip.hrOrgUnit.name,enterpriseArchives.warehouseEntry,enterpriseArchives.lastUpdateTime,enterpriseArchives.name,enterpriseArchives.number where enterpriseArchives.id ='" + archivesId + "' order by enterpriseArchives.warehouseEntry desc");
            if (RecDBUtils.isEmpty((IObjectCollection)coll)) {
                map.put("allResumeRecord", "");
            } else {
                map.put("allResumeRecord", (Object)coll);
            }
        }
        return map;
    }

    @Override
    protected Map _getRelaInfo(Context ctx, String realId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)realId)) {
            return map;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("enterpriseArchives.*");
        selector.add("enterpriseArchives.resSource.*");
        ResumeClipRelationInfo relaInfo = null;
        try {
            relaInfo = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationInfo((IObjectPK)new ObjectUuidPK(realId), selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        EnterpriseArchivesInfo archivesInfo = null;
        if (relaInfo != null && relaInfo.getEnterpriseArchives() != null) {
            archivesInfo = relaInfo.getEnterpriseArchives();
        }
        if (archivesInfo != null) {
            ResumeFocusOnCollection coll;
            map.put("personName", archivesInfo.getName());
            String uuid = archivesInfo.getUniqId();
            if (!StringUtils.isEmpty((CharSequence)uuid)) {
                map.put("uuid", uuid);
                map.put("applyRecord", ResumeBaseRecInfoFacadeFactory.getLocalInstance(ctx).getResumeApplyRecords(uuid));
            }
            if (archivesInfo.getResSource() != null && archivesInfo.getResSource().getName() != null) {
                map.put("resSource", archivesInfo.getResSource().getName());
            }
            if (relaInfo.getTalentLable() != null) {
                map.put("talentLable", relaInfo.getTalentLable().getValue());
            }
            if ((coll = ResumeFocusOnFactory.getLocalInstance(ctx).getResumeFocusOnCollection("where resumeClipRelation = '" + relaInfo.getId().toString() + "' and focusOnOper = " + 100)) != null && coll.size() > 0) {
                map.put("talentLableDesc", coll.get(0).getDescription());
            }
            if (archivesInfo.getIsBlackList() != null) {
                map.put("isBlackList", archivesInfo.getIsBlackList().getValue());
            }
            map.put("repeated", archivesInfo.getRepeated().getValue());
        }
        return map;
    }
}

