/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.EmailSendObjectEnum;
import com.kingdee.shr.recuritment.EmailTemplateDetailCollection;
import com.kingdee.shr.recuritment.EmailTemplateDetailFactory;
import com.kingdee.shr.recuritment.EmailTemplateDetailInfo;
import com.kingdee.shr.recuritment.EmailTemplateFactory;
import com.kingdee.shr.recuritment.IEmailTemplate;
import com.kingdee.shr.recuritment.IEmailTemplateDetail;
import com.kingdee.shr.recuritment.app.AbstractEmailTemplateDetailControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class EmailTemplateDetailControllerBean
extends AbstractEmailTemplateDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.EmailTemplateDetailControllerBean");

    @Override
    protected String _addTemplate(Context ctx, IObjectValue argMap) throws BOSException {
        EmailTemplateDetailInfo info = (EmailTemplateDetailInfo)argMap;
        String id = null;
        try {
            IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
            info.setNumber(EmailTemplateDetailControllerBean.generateNumber(ctx));
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            Date date = c.getTime();
            info.setCreateTime(new Timestamp(date.getTime()));
            info.setLastUpdateTime(new Timestamp(date.getTime()));
            UserInfo creator = info.getCreator();
            if (creator == null) {
                creator = ContextUtil.getCurrentUserInfo((Context)ctx);
                info.setCreator(creator);
            }
            info.setLastUpdateUser(creator);
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            BOSUuid fid = BOSUuid.create((BOSObjectType)info.getBOSType());
            info.setId(fid);
            iEmailTemplateDetail.save((CoreBaseInfo)info);
            id = fid.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "error";
        }
        return id;
    }

    @Override
    protected String _updateTemplate(Context ctx, IObjectValue argMap) throws BOSException {
        EmailTemplateDetailInfo info = (EmailTemplateDetailInfo)argMap;
        try {
            IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            Date date = c.getTime();
            info.setLastUpdateTime(new Timestamp(date.getTime()));
            UserInfo creator = ContextUtil.getCurrentUserInfo((Context)ctx);
            info.setLastUpdateUser(creator);
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            iEmailTemplateDetail.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "error";
        }
        return info.getId().toString();
    }

    @Override
    protected String _deleteTemplate(Context ctx, String ids) throws BOSException {
        try {
            IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
            IEmailTemplate iEmailTemplate = EmailTemplateFactory.getLocalInstance(ctx);
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where id = '" + id + "'");
                    if (emailTemplateDetailColl == null || emailTemplateDetailColl.size() <= 0) continue;
                    EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
                    emailTemplateDetailInfo.setExistState(0);
                    iEmailTemplateDetail.save((CoreBaseInfo)emailTemplateDetailInfo);
                }
            } else {
                EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where id = '" + ids + "'");
                if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
                    EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
                    emailTemplateDetailInfo.setExistState(0);
                    iEmailTemplateDetail.save((CoreBaseInfo)emailTemplateDetailInfo);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "error";
        }
        return "ok";
    }

    @Override
    protected IObjectValue _getCandidateSendSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 2 and emailBusiness = '\u9762\u8bd5\u9080\u7ea6' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getInterviewerSendSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 1 and emailBusiness = '\u9762\u8bd5\u9080\u7ea6' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getCandidateCancelSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 2 and emailBusiness = '\u53d6\u6d88\u9080\u7ea6' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getInterviewerCancelSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 1 and emailBusiness = '\u53d6\u6d88\u9080\u7ea6' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getDelInterviewerSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 1 and emailBusiness = '\u5220\u9664\u9762\u8bd5\u5b98' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getInterviewerFBResSystemEmailTem(Context ctx) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where sendObject = 1 and emailBusiness = '\u9080\u8bf7\u9762\u8bd5\u5b98\u8bc4\u4ef7' and isDefault = 1");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectValue _getEmailTemplateDetailById(Context ctx, String templateDetailId) throws BOSException {
        IEmailTemplateDetail iEmailTemplateDetail = EmailTemplateDetailFactory.getLocalInstance(ctx);
        EmailTemplateDetailCollection emailTemplateDetailColl = iEmailTemplateDetail.getEmailTemplateDetailCollection("where id = '" + templateDetailId + "'");
        if (emailTemplateDetailColl != null && emailTemplateDetailColl.size() > 0) {
            EmailTemplateDetailInfo emailTemplateDetailInfo = emailTemplateDetailColl.get(0);
            return emailTemplateDetailInfo;
        }
        return null;
    }

    @Override
    protected IObjectCollection _getTemplateDetailByUser(Context ctx, String userId, int sendObject, String emailBusiness) throws BOSException {
        EmailTemplateDetailCollection emailTemplateDetailColl = new EmailTemplateDetailCollection();
        EmailTemplateDetailInfo info = null;
        Object[] params = null;
        String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
        StringBuilder sb = new StringBuilder("select FID,FNumber,").append(nameField).append(",FSendObject,FCreatorName,FCreateTime from T_REC_EmailTemplateDetail where FcreatorId = ? ");
        if (sendObject != 0 && emailBusiness != null) {
            sb.append(" and FSendObject = ? and FEmailBusiness = ?");
            params = new Object[]{userId, sendObject, emailBusiness};
        } else if (sendObject != 0 && emailBusiness == null) {
            sb.append(" and FSendObject = ? ");
            params = new Object[]{userId, sendObject};
        } else if (sendObject == 0 && emailBusiness != null) {
            sb.append(" and FEmailBusiness = ?");
            params = new Object[]{userId, emailBusiness};
        } else {
            params = new Object[]{userId};
        }
        sb.append(" and FExistState=1  ORDER BY FCreateTime DESC");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            while (rs.next()) {
                info = new EmailTemplateDetailInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString(nameField));
                info.setSendObject(EmailSendObjectEnum.getEnum(rs.getInt("FSendObject")));
                info.setCreatorName(rs.getString("FCreatorName"));
                info.setCreateTime(rs.getTimestamp("FCreateTime"));
                emailTemplateDetailColl.add(info);
            }
        }
        catch (SQLException e) {
            info.setName("SQLException: " + e.toString());
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return emailTemplateDetailColl;
    }

    @Override
    protected IObjectValue _getSubContByTemId(Context ctx, String templateDetailId) throws BOSException {
        EmailTemplateDetailInfo info = new EmailTemplateDetailInfo();
        String sql = "select FEmailSubject,FTemplateContent from T_REC_EmailTemplateDetail where fid = ?";
        Object[] params = new Object[]{templateDetailId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                info.setEmailSubject(rs.getString("FEmailSubject"));
                info.setTemplateContent(rs.getString("FTemplateContent"));
            }
        }
        catch (SQLException e) {
            info.setEmailSubject("SQLException: " + e.toString());
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public static synchronized String generateNumber(Context ctx) throws BOSException {
        try {
            String sql = "SELECT FNumber FROM T_REC_EmailTemplateDetail";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, null);
            if (!RecDBUtils.isEmpty(datas)) {
                int maxNumber = -1;
                for (Object[] data : datas) {
                    int num = Integer.parseInt((String)data[0]);
                    if (num <= maxNumber) continue;
                    maxNumber = num;
                }
                if (++maxNumber / 10 < 1) {
                    return "00" + maxNumber;
                }
                if (maxNumber / 10 < 10) {
                    return "0" + maxNumber;
                }
                return "" + maxNumber;
            }
            throw new BOSException("\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u90ae\u4ef6\u6a21\u677f\u4e3a\u7a7a\uff01");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _hasSameName(Context ctx, String name) throws BOSException {
        String[] fields = RecDBUtils.parseFieldByLanguage(ctx, "name");
        String sql = "select FID from T_REC_EmailTemplateDetail where " + fields[0] + " = ? and FExistState = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{name});
        return rs.size() > 0;
    }
}

