/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.TagLibraryCollection;
import com.kingdee.eas.basedata.hraux.TagLibraryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ITagInfo;
import com.kingdee.eas.hr.base.TagInfoFactory;
import com.kingdee.eas.hr.base.TagInfoInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.BillStateEnum;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.ResumeClipBaseInfo;
import com.kingdee.shr.recuritment.ResumeClipRelationFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationInfo;
import com.kingdee.shr.recuritment.YesOrNoEnum;
import com.kingdee.shr.recuritment.app.AbstractEnterpriseArchivesControllerBean;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EnterpriseArchivesControllerBean
extends AbstractEnterpriseArchivesControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.EnterpriseArchivesControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EnterpriseArchivesInfo info = (EnterpriseArchivesInfo)model;
        info.setResumePositionState(YesOrNoEnum.NO);
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EnterpriseArchivesInfo info = (EnterpriseArchivesInfo)model;
        info.setResumePositionState(YesOrNoEnum.NO);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EnterpriseArchivesInfo info = (EnterpriseArchivesInfo)model;
        info.setResumePositionState(YesOrNoEnum.NO);
        return super._save(ctx, model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _syncTags(Context ctx, String recResumeId, String tagIds) throws BOSException {
        String querySql = "SELECT t.FID FROM T_REC_EnterpriseArchives t LEFT JOIN T_REC_ResumeBaseRec p ON t.FUniqId = p.FIfSimplePerson WHERE p.FID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{recResumeId});
        if (rs == null) return;
        String insertItems = "FTagLibraryID,FTagObjectId,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FID,FEFFDT,FLEFFDT";
        String insertSql = "INSERT INTO T_HR_TagInfo(" + insertItems + ") VALUES (" + RecDBUtils.getParamPlaceholder(insertItems) + ")";
        try {
            while (rs.next()) {
                String eafid = rs.getString("FID");
                ITagInfo it = TagInfoFactory.getLocalInstance((Context)ctx);
                try {
                    it.delete("where tagObjectId = '" + eafid + "'");
                    String[] tagArys = tagIds.split(",");
                    Date now = new Date(System.currentTimeMillis());
                    String creatorId = BOSUuid.read((String)ctx.getCaller().toString()).toString();
                    String cu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    for (String tagId : tagArys) {
                        TagInfoInfo tagInfo = new TagInfoInfo();
                        String fid = BOSUuid.create((BOSObjectType)tagInfo.getBOSType()).toString();
                        Object[] params = new Object[]{tagId, eafid, creatorId, now, now, cu, fid, now, new Date(HRUtil.getMaxEndDate().getTime())};
                        paramsList.add(params);
                    }
                    RecDBUtils.executeBatch(ctx, insertSql, paramsList);
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                    return;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectPK _updateEnterpriseArhcives(Context ctx, IObjectValue archiveInfo) throws BOSException {
        EnterpriseArchivesInfo archive = (EnterpriseArchivesInfo)archiveInfo;
        String uid = archive.getUniqId();
        if (RecDBUtils.isEmpty(uid)) {
            throw new BOSException("\u7b80\u5386\u5e93\u57fa\u672c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u7f3a\u5931uniqId\uff01");
        }
        String sql = "SELECT FID FROM T_REC_EnterpriseArchives WHERE FUniqId = ? AND FState = '1'";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{uid});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u901a\u8fc7uniqId\uff1a" + uid + "\u67e5\u8be2\u7b80\u5386\u5e93\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
        }
        if (RecDBUtils.isEmpty(datas)) {
            throw new BOSException("\u7b80\u5386\u5e93uniqId\uff1a" + uid + "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01");
        }
        String replacedArchiveId = (String)datas.get(0)[0];
        if (RecDBUtils.isEmpty(replacedArchiveId)) {
            throw new BOSException("\u7b80\u5386\u5e93uniqId\uff1a" + uid + "\u5bf9\u5e94\u6570\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u975e\u6cd5FID\uff1a" + replacedArchiveId + "\uff01");
        }
        this._updateEnterpriseArhcives(ctx, (IObjectValue)archive, replacedArchiveId);
        return new ObjectUuidPK(replacedArchiveId.toString());
    }

    @Override
    protected void _updateEnterpriseArhcives(Context ctx, IObjectValue archiveInfo, String replacedArchiveId) throws BOSException {
        EnterpriseArchivesInfo archive = (EnterpriseArchivesInfo)archiveInfo;
        try {
            archive.setState(BillStateEnum.USE);
            IObjectPK pk = EnterpriseArchivesFactory.getLocalInstance(ctx).save((CoreBaseInfo)archive);
            archive.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*******************\u66f4\u65b0\u7b80\u5386\u5e93\uff0c\u4ea4\u6362\u6570\u636e******************");
            logger.debug((Object)("*********************old_FEnterpriseArchivesID\uff1a" + replacedArchiveId + "\uff0cnew_FEnterpriseArchivesID\uff1a" + archive.getId().toString() + "*********************"));
        }
        String sql = "SELECT FNumber,FWarehouseEntry, FLastUpdateDate, FCreatorID,FCreateTime,FControlUnitID FROM T_REC_EnterpriseArchives WHERE FID = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{replacedArchiveId});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (RecDBUtils.isEmpty(datas)) {
            throw new BOSException("\u7b80\u5386\u5e93ID\u4e3a(" + replacedArchiveId + ")\u7684\u5355\u636e\u4e22\u5931\uff01");
        }
        Object[] data = datas.get(0);
        String number = (String)data[0];
        java.util.Date entryDate = (java.util.Date)data[1];
        java.util.Date lastUpdateDate = (java.util.Date)data[2];
        String creator = (String)data[3];
        Timestamp createTime = (Timestamp)data[4];
        String cu = (String)data[5];
        sql = "UPDATE T_REC_EnterpriseArchives SET FNumber=?,FWarehouseEntry=?,FLastUpdateDate=?,FCreatorID=?,FCreateTime=?,FControlUnitID=? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{number, entryDate, archive.getWarehouseEntry(), creator, createTime, cu, archive.getId().toString()});
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{archive.getNumber(), entryDate, lastUpdateDate, creator, createTime, cu, replacedArchiveId});
        this._deleteArchiveInfo(ctx, (IObjectPK)new ObjectUuidPK(replacedArchiveId), (IObjectPK)new ObjectUuidPK(archive.getId()));
        if (archive.getId() != null) {
            String updateSql = "UPDATE T_REC_RESUMECLIPRELATION set FEnterpriseArchivesID = ? where FEnterpriseArchivesID = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{archive.getId().toString(), replacedArchiveId});
        }
    }

    @Override
    protected void _deleteArchiveInfo(Context ctx, IObjectPK deletedId, IObjectPK replaceId) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*********************\u5e9f\u9664\u7b80\u5386\u6570\u636e,FID\uff1a" + deletedId + "\uff0cFReplacedId\uff1a" + replaceId + "*********************"));
        }
        String sql = "UPDATE T_REC_EnterpriseArchives SET FState = ?,FReplacedId = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"2", replaceId != null ? replaceId.toString() : null, deletedId.toString()});
    }

    @Override
    protected void _batchDeleteArchives(Context ctx, Map param) throws BOSException {
        if (param == null || param.size() <= 0) {
            return;
        }
        String sql = "UPDATE T_REC_EnterpriseArchives SET FState = ?,FReplacedId = ? WHERE FID = ?";
        Set entrys = param.entrySet();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(param.size());
        for (Map.Entry entry : entrys) {
            paramsList.add(new Object[]{"2", entry.getValue(), entry.getKey()});
        }
        RecDBUtils.executeBatch(ctx, sql, paramsList);
    }

    @Override
    protected boolean _copyArchives(Context ctx, IObjectValue relaInfo, String resumeClipId) throws BOSException {
        ResumeClipRelationInfo oldInfo = (ResumeClipRelationInfo)relaInfo;
        EnterpriseArchivesInfo enterpriseArchives = oldInfo.getEnterpriseArchives();
        String resumeId = oldInfo.getEnterpriseArchives().getId().toString();
        String resumeClipBaseName = oldInfo.getResumeClip().getName();
        ResumeClipBaseInfo clipInfo = new ResumeClipBaseInfo();
        clipInfo.setId(new ObjectUuidPK(resumeClipId).getKeyValue());
        boolean isExists = false;
        try {
            isExists = ResumeClipRelationFactory.getLocalInstance(ctx).exists("where resumeClip = '" + resumeClipId + "' and enterpriseArchives='" + resumeId + "'");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isExists) {
            ResumeClipRelationInfo info = new ResumeClipRelationInfo();
            info.setResumeClip(clipInfo);
            info.setEnterpriseArchives(enterpriseArchives);
            IObjectPK relationPk = ResumeClipRelationFactory.getLocalInstance(ctx).addNewRelation(resumeClipId, resumeId);
            if (relationPk != null) {
                ResumeOperRecordService.getInstance().addEnterpriseArchivesOperRecord(ctx, "\u4ece\u7b80\u5386\u5939\u3010" + resumeClipBaseName + "\u3011\u590d\u5236\u5230\u8be5\u7b80\u5386\u5939", "", relationPk.toString());
            }
        } else {
            throw new BOSException("\u7b80\u5386\u5939\u4e2d\u5df2\u5b58\u5728\u8be5\u7b80\u5386\u3002");
        }
        return true;
    }

    @Override
    protected boolean _moveArchives(Context ctx, IObjectValue relaInfo, String resumeClipId) throws BOSException {
        ResumeClipRelationInfo oldInfo = (ResumeClipRelationInfo)relaInfo;
        EnterpriseArchivesInfo enterpriseArchives = oldInfo.getEnterpriseArchives();
        String resumeId = oldInfo.getEnterpriseArchives().getId().toString();
        String relaId = oldInfo.getId().toString();
        String resumeClipBaseName = oldInfo.getResumeClip().getName();
        ResumeClipBaseInfo clipInfo = new ResumeClipBaseInfo();
        clipInfo.setId(new ObjectUuidPK(resumeClipId).getKeyValue());
        boolean isExists = false;
        try {
            isExists = ResumeClipRelationFactory.getLocalInstance(ctx).exists("where resumeClip = '" + resumeClipId + "' and enterpriseArchives='" + resumeId + "'");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isExists) {
            ResumeClipRelationInfo info = new ResumeClipRelationInfo();
            info.setResumeClip(clipInfo);
            info.setEnterpriseArchives(enterpriseArchives);
            info.setTalentLable(oldInfo.getTalentLable());
            info.setJoinFocusPerson(oldInfo.getJoinFocusPerson());
            IObjectPK pk = null;
            try {
                pk = ResumeClipRelationFactory.getLocalInstance(ctx).addnew(info);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            String sql = "update T_REC_ResumeFocusOn set FResumeClipRelationID = ? where FResumeClipRelationID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), relaId});
            String sql01 = "update T_REC_ResumeFocusOnHis set FResumeClipRelationID = ? where FResumeClipRelationID = ?";
            DbUtil.execute((Context)ctx, (String)sql01, (Object[])new Object[]{pk.toString(), relaId});
            try {
                TagLibraryCollection tags = TagInfoFactory.getLocalInstance((Context)ctx).getObjectTag(relaId, new java.util.Date());
                int size02 = tags.size();
                for (int k = 0; k < size02; ++k) {
                    TagLibraryInfo tagInfo = tags.get(k);
                    if (tagInfo == null || tagInfo.getId() == null) continue;
                    TagInfoFactory.getLocalInstance((Context)ctx).addTag(tagInfo.getId().toString(), pk.toString(), new java.util.Date());
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("", (Throwable)e);
            }
            try {
                ResumeClipRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(relaId));
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (pk != null) {
                ResumeOperRecordService.getInstance().addEnterpriseArchivesOperRecord(ctx, "\u4ece\u7b80\u5386\u5939\u3010" + resumeClipBaseName + "\u3011\u79fb\u52a8\u5230\u8be5\u7b80\u5386\u5939", "", pk.toString());
            }
        } else {
            throw new BOSException("\u7b80\u5386\u5939\u4e2d\u5df2\u5b58\u5728\u8be5\u7b80\u5386\u3002");
        }
        return true;
    }
}

