/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.shr.recuritment.app.AbstractHRRecFacadeControllerBean;
import com.kingdee.shr.recuritment.app.util.DateUtil;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HRRecFacadeControllerBean
extends AbstractHRRecFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.HRRecFacadeControllerBean");

    @Override
    protected Map _getRecCompleteRate(Context ctx, String orgId) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        Map param = this.getRecCompleteRate(ctx, orgId, curYear, 0);
        String completeRate = (String)param.get("completeRate");
        if (!StringUtils.isEmpty((CharSequence)completeRate)) {
            completeRate = String.valueOf(Double.valueOf(completeRate).intValue());
        }
        map.put("completeRate", completeRate + "%");
        return map;
    }

    @Override
    protected Map _getRecDataAnalysis(Context ctx, String orgId, int talentsDimension) throws BOSException {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        String userId = HRManagerUtil.getUserId((Context)ctx);
        StringBuilder sql_01 = new StringBuilder("SELECT count(RESUME.FID) count FROM T_REC_RESUMEBASEREC RESUME ").append(" LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where year(RESUME.FWAREHOUSEENTRY) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_01.append(" AND ((DEMAND.FIsKeyTalents = 1 AND (RECAR.FIsKeyTalents IS NULL OR RECAR.FIsKeyTalents = 1))").append(" OR (RECAR.FIsKeyTalents = 1 ))");
        }
        int resumeNum = this.getCountBySql(ctx, sql_01);
        StringBuilder sql_02 = new StringBuilder("SELECT COUNT(INTER.FID) count FROM T_REC_INTERVIEWRESULT INTER ").append(" LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = INTER.FRESUMEBASERECID ").append(" LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where YEAR(INTER.FCREATETIME) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_02.append(" AND ((DEMAND.FIsKeyTalents = 1 AND (RECAR.FIsKeyTalents IS NULL OR RECAR.FIsKeyTalents = 1))").append(" OR (RECAR.FIsKeyTalents = 1 ))");
        }
        int interviewNum = this.getCountBySql(ctx, sql_02);
        StringBuilder sql_03 = new StringBuilder("SELECT COUNT(RECAR.FID) count FROM T_REC_RECAPPROVAL RECAR ").append(" LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = RECAR.FRESUMEBASERECID ").append(" LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("where YEAR(RECAR.FCREATETIME) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_03.append(" AND RECAR.FIsKeyTalents = 1  ");
        }
        int recApprovalNum = this.getCountBySql(ctx, sql_03);
        StringBuilder sql_04 = new StringBuilder("SELECT COUNT(OFFER.FID) count FROM T_REC_OFFER OFFER ").append(" LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append(" LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where YEAR(OFFER.FCREATETIME) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_04.append(" AND RECAR.FIsKeyTalents = 1  ");
        }
        int recOfferNum = this.getCountBySql(ctx, sql_04);
        StringBuilder sql_05 = new StringBuilder("SELECT COUNT(OFFER.FID) count FROM T_REC_OFFER OFFER ").append(" LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append(" LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where YEAR(OFFER.FENTRYDATE) = ").append(year).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_05.append(" AND RECAR.FIsKeyTalents = 1 ");
        }
        int entryNum = this.getCountBySql(ctx, sql_05);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String resumeRate = "0";
        if (resumeNum != 0) {
            resumeRate = numberFormat.format((double)interviewNum / (double)resumeNum * 100.0);
        }
        String interviewRate = "0";
        if (interviewNum != 0) {
            interviewRate = numberFormat.format((double)recApprovalNum / (double)interviewNum * 100.0);
        }
        String recApprovalRate = "0";
        if (recApprovalNum != 0) {
            recApprovalRate = numberFormat.format((double)recOfferNum / (double)recApprovalNum * 100.0);
        }
        String entryRate = "0";
        if (recOfferNum != 0) {
            entryRate = numberFormat.format((double)entryNum / (double)recOfferNum * 100.0);
        }
        int[] recData = new int[]{resumeNum, interviewNum, recApprovalNum, recOfferNum, entryNum};
        String[] recRate = new String[]{resumeRate, interviewRate, recApprovalRate, entryRate};
        map.put("recData", recData);
        map.put("recRate", recRate);
        return map;
    }

    @Override
    protected Map _getOrgReachedData(Context ctx, String orgId, int dimension, int talentsDimension) throws BOSException {
        Map<String, Object[]> map = new HashMap();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        String startDate = curYear + "-01-01";
        String endDate = curYear + "-12-31";
        String userId = HRManagerUtil.getUserId((Context)ctx);
        if (dimension == 1) {
            ArrayList recDemandNum = new ArrayList();
            ArrayList recEntryNum = new ArrayList();
            ArrayList completeRate = new ArrayList();
            Map param = this.getRecCompleteRate(ctx, orgId, curYear - 1, talentsDimension);
            recDemandNum.add(param.get("recuritNumber"));
            recEntryNum.add(param.get("entryNum"));
            completeRate.add(param.get("completeRate"));
            param = this.getRecCompleteRate(ctx, orgId, curYear, talentsDimension);
            recDemandNum.add(param.get("recuritNumber"));
            recEntryNum.add(param.get("entryNum"));
            completeRate.add(param.get("completeRate"));
            map.put("recDemandNum", recDemandNum.toArray());
            map.put("recEntryNum", recEntryNum.toArray());
            map.put("completeRate", completeRate.toArray());
        } else if (dimension == 2) {
            map = this.getOrgCompareData(ctx, orgId, curYear, startDate, endDate, talentsDimension);
        }
        return map;
    }

    private Map getOrgCompareData(Context ctx, String orgId, int curYear, String startDate, String endDate, int talentsDimension) throws BOSException {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        ArrayList orgLable = new ArrayList();
        ArrayList<Integer> recDemandNum = new ArrayList<Integer>();
        ArrayList<Integer> recEntryNum = new ArrayList<Integer>();
        ArrayList<String> completeRate = new ArrayList<String>();
        HashMap<String, String> map_01 = new HashMap<String, String>();
        Object[] params_01 = new Object[]{orgId, orgId};
        StringBuilder sql_01 = new StringBuilder("SELECT FID id ,FNAME_l2 name FROM T_ORG_Admin where (FPARENTID = ? or FID = ?) and FISSEALUP = 0 ");
        IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString(), (Object[])params_01);
        try {
            while (rowSet_01.next()) {
                map_01.put(rowSet_01.getString("id"), rowSet_01.getString("name"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> map_02 = new HashMap<String, Integer>();
        Object[] params_02 = new Object[]{curYear, orgId, orgId};
        StringBuilder sql_02 = new StringBuilder("select  t1.FID   ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT  dep.FLONGNUMBER ,COUNT(OFFER.FID ) count FROM T_REC_OFFER AS OFFER   ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID  ").append("where year(OFFER.FENTRYDATE) = ? ").append(" AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ");
        if (talentsDimension == 1) {
            sql_02.append(" AND RECAR.FIsKeyTalents = 1 ");
        }
        sql_02.append("group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("where t1.FISSEALUP = 0 and (t1.FPARENTID = ? or t1.fid = ?) ").append("group by t1.fid order by count  desc ");
        IRowSet rowSet_02 = DbUtil.executeQuery((Context)ctx, (String)sql_02.toString(), (Object[])params_02);
        try {
            while (rowSet_02.next()) {
                map_02.put(rowSet_02.getString("FID"), rowSet_02.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Map<String, Integer> recDemadMap = this.getOrgRecNum(ctx, orgId, startDate, endDate, talentsDimension);
        recDemadMap = this.sortMapByValue(recDemadMap);
        int recuritNumber = 0;
        int entryNum = 0;
        double rate = 0.0;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        Set<String> recDemandSet = recDemadMap.keySet();
        if (!recDemandSet.isEmpty()) {
            int allRecuritNumber = 0;
            int allEntryNum = 0;
            for (String id : recDemandSet) {
                recuritNumber = recDemadMap.get(id);
                entryNum = (Integer)map_02.get(id);
                if (orgId.equals(id)) continue;
                allRecuritNumber += recuritNumber;
                allEntryNum += entryNum;
            }
            recDemadMap.put(orgId, recDemadMap.get(orgId) - allRecuritNumber);
            map_02.put(orgId, (Integer)map_02.get(orgId) - allEntryNum);
            map_01.put(orgId, (String)map_01.get(orgId) + "(\u76f4\u5c5e)");
        }
        for (String id : recDemandSet) {
            recuritNumber = recDemadMap.get(id);
            entryNum = (Integer)map_02.get(id);
            if (orgId.equals(id) && recuritNumber == 0 && entryNum == 0) continue;
            orgLable.add(map_01.get(id));
            recDemandNum.add(recuritNumber);
            recEntryNum.add(entryNum);
            if (recuritNumber != 0) {
                rate = (double)entryNum / (double)recuritNumber;
                completeRate.add(numberFormat.format(rate * 100.0));
                continue;
            }
            completeRate.add("100");
        }
        map.put("orgLable", orgLable.toArray());
        map.put("recDemandNum", recDemandNum.toArray());
        map.put("recEntryNum", recEntryNum.toArray());
        map.put("completeRate", completeRate.toArray());
        return map;
    }

    private Map<String, Integer> getOrgRecNum(Context ctx, String orgId, String startDate, String endDate, int talentsDimension) throws BOSException {
        HashMap<String, Integer> map_01 = new HashMap<String, Integer>();
        if (talentsDimension == 0) {
            Object[] params_03 = new Object[]{orgId, orgId};
            StringBuilder sql_03 = new StringBuilder("SELECT t3.FID ,t4.count FROM T_ORG_Admin t3 INNER JOIN  ( ").append("select  t1.FID FID  ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT dep.FLONGNUMBER ,SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID ").append("WHERE DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0 group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("  group by t1.fid  ").append(") t4 on (t4.FID = t3.FID) where t3.FISSEALUP = 0 and  (t3.FPARENTID = ? or t3.FID = ?) ");
            IRowSet rowSet_03 = DbUtil.executeQuery((Context)ctx, (String)sql_03.toString(), (Object[])params_03);
            try {
                while (rowSet_03.next()) {
                    map_01.put(rowSet_03.getString("FID"), rowSet_03.getInt("count"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        HashMap<String, Integer> map_04 = new HashMap<String, Integer>();
        Object[] params_04 = new Object[]{orgId, orgId};
        StringBuilder sql_01 = new StringBuilder("SELECT t3.FID ,t4.count FROM T_ORG_Admin t3 INNER JOIN  ( ").append("select  t1.FID FID  ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT dep.FLONGNUMBER ,SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID ").append("WHERE DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0 ").append(" AND DEMAND.FIsKeyTalents = 1  group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("  group by t1.fid  ").append(") t4 on (t4.FID = t3.FID) where t3.FISSEALUP = 0 and  (t3.FPARENTID = ? or t3.FID = ?)  ");
        IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString(), (Object[])params_04);
        try {
            while (rowSet_01.next()) {
                map_04.put(rowSet_01.getString("FID"), rowSet_01.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> map_05 = new HashMap<String, Integer>();
        Object[] params_05 = new Object[]{orgId, orgId};
        StringBuilder sql_02 = new StringBuilder("SELECT t3.FID ,t4.count FROM T_ORG_Admin t3 INNER JOIN  ( ").append("select  t1.FID FID  ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT dep.FLONGNUMBER ,count(RESUME.FID) AS count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("WHERE DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0 ").append(" AND DEMAND.FIsKeyTalents = 1 AND RECAR.FIsKeyTalents = 0 group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("  group by t1.fid  ").append(") t4 on (t4.FID = t3.FID) where  t3.FISSEALUP = 0 and  (t3.FPARENTID = ? or t3.FID = ?)  ");
        IRowSet rowSet_02 = DbUtil.executeQuery((Context)ctx, (String)sql_02.toString(), (Object[])params_05);
        try {
            while (rowSet_02.next()) {
                map_05.put(rowSet_02.getString("FID"), rowSet_02.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> map_06 = new HashMap<String, Integer>();
        Object[] params_06 = new Object[]{orgId, orgId};
        StringBuilder sql_03 = new StringBuilder("SELECT t3.FID ,t4.count FROM T_ORG_Admin t3 INNER JOIN  ( ").append("select  t1.FID FID  ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT dep.FLONGNUMBER ,count(RESUME.FID) AS count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("WHERE DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0  ").append(" AND DEMAND.FIsKeyTalents = 0 AND RECAR.FIsKeyTalents = 1 group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("  group by t1.fid  ").append(") t4 on (t4.FID = t3.FID) where  t3.FISSEALUP = 0 and  (t3.FPARENTID = ? or t3.FID = ?)  ");
        IRowSet rowSet_03 = DbUtil.executeQuery((Context)ctx, (String)sql_03.toString(), (Object[])params_06);
        try {
            while (rowSet_03.next()) {
                map_06.put(rowSet_03.getString("FID"), rowSet_03.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        for (String id : map_04.keySet()) {
            map_01.put(id, (Integer)map_04.get(id) - (Integer)map_05.get(id) + (Integer)map_06.get(id));
        }
        HashMap<String, Integer> map_02 = new HashMap<String, Integer>();
        Object[] params_02 = new Object[]{orgId, orgId};
        StringBuilder sql_04 = new StringBuilder("select  t1.FID   ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT  dep.FLONGNUMBER ,COUNT(OFFER.FID ) count FROM T_REC_OFFER AS OFFER   ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID  ").append("where FEntryDate < {d'" + startDate + "'}").append(" AND DEMAND.FLOWSTATE = 0  AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ");
        if (talentsDimension == 1) {
            sql_04.append(" AND RECAR.FIsKeyTalents = 1 ");
        }
        sql_04.append("group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("where t1.FISSEALUP = 0 and  (t1.FPARENTID = ? or t1.FID = ?)   ").append("group by t1.fid  ");
        IRowSet rowSet_04 = DbUtil.executeQuery((Context)ctx, (String)sql_04.toString(), (Object[])params_02);
        try {
            while (rowSet_04.next()) {
                map_02.put(rowSet_04.getString("FID"), rowSet_04.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> map_03 = new HashMap<String, Integer>();
        Object[] params_03 = new Object[]{orgId, orgId};
        StringBuilder sql_05 = new StringBuilder("select  t1.FID   ,sum(t2.count) count  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT  dep.FLONGNUMBER ,COUNT(OFFER.FID ) count FROM T_REC_OFFER AS OFFER   ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID  ").append("where FEntryDate >= {d'" + startDate + "'} AND FEntryDate <= {d'" + endDate + "'} ").append(" AND DEMAND.FLOWSTATE  in (1,2)  AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ");
        if (talentsDimension == 1) {
            sql_05.append(" AND RECAR.FIsKeyTalents = 1 ");
        }
        sql_05.append("group by dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append("where  t1.FISSEALUP = 0 and  (t1.FPARENTID = ? or t1.FID = ?)  ").append("group by t1.fid  ");
        IRowSet rowSet_05 = DbUtil.executeQuery((Context)ctx, (String)sql_05.toString(), (Object[])params_03);
        try {
            while (rowSet_05.next()) {
                map_03.put(rowSet_05.getString("FID"), rowSet_05.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> recDemadMap = new HashMap<String, Integer>();
        for (String id : map_01.keySet()) {
            recDemadMap.put(id, (Integer)map_01.get(id) - (Integer)map_02.get(id) + (Integer)map_03.get(id));
        }
        return recDemadMap;
    }

    @Override
    protected Map _getHireCycleAnalysis(Context ctx, String orgId, int dimension) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        int curMonth = calendar.get(2) + 1;
        String userId = HRManagerUtil.getUserId((Context)ctx);
        if (dimension == 1) {
            double avgHireCycle = 0.0;
            StringBuilder sql_01 = new StringBuilder("SELECT round(AVG(to_number(DATEDIFF(day,DEMAND.FAPPLYDATE,OFFER.FENTRYDATE))*1.0),1) avg FROM T_REC_OFFER AS OFFER   ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("where YEAR(OFFER.FEntryDate)= ").append(curYear).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString());
            try {
                while (rowSet_01.next()) {
                    avgHireCycle = rowSet_01.getDouble("avg");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            map.put("avgHireCycle", avgHireCycle);
        } else if (dimension == 2) {
            HashMap<Integer, Double> hireCycle = new HashMap<Integer, Double>();
            ArrayList<Double> param = new ArrayList<Double>();
            StringBuilder sql_02 = new StringBuilder("SELECT t1.month month,round(avg(t1.day*1.0),1) avg FROM ( ").append(" SELECT  month(OFFER.FEntryDate) month,DATEDIFF(day,DEMAND.FAPPLYDATE,Offer.FENTRYDATE) day FROM T_REC_OFFER AS OFFER  ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("where YEAR(OFFER.FEntryDate)= ").append(curYear).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(") t1 group by t1.month ");
            IRowSet rowSet_02 = DbUtil.executeQuery((Context)ctx, (String)sql_02.toString());
            try {
                while (rowSet_02.next()) {
                    hireCycle.put(rowSet_02.getInt("month"), rowSet_02.getDouble("avg"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            for (int i = 1; i <= curMonth; ++i) {
                Double avg = (Double)hireCycle.get(i);
                if (avg == null) {
                    param.add(0.0);
                    continue;
                }
                param.add(avg);
            }
            map.put("monthHireCycle", param.toArray());
        }
        return map;
    }

    @Override
    protected Map _getHireCycleCompare(Context ctx, String orgId, int compareDimension, int timeDimension) throws BOSException {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        String startDate = DateUtil.getCurTimeOfFirstDay();
        String userId = HRManagerUtil.getUserId((Context)ctx);
        String timeSql = "";
        timeSql = timeDimension == 1 ? "YEAR(OFFER.FEntryDate)= " + curYear : "OFFER.FEntryDate >= {d'" + startDate + "'} ";
        if (compareDimension == 1) {
            Map hireCycle = new HashMap<String, Double>();
            ArrayList<String> param_01 = new ArrayList<String>();
            ArrayList param_02 = new ArrayList();
            StringBuilder sql_01 = new StringBuilder("SELECT TOP 10 POS.FNAME_l2 name,ROUND(AVG(DATEDIFF(hour,DEMAND.FAPPLYDATE,Offer.FENTRYDATE)*1.0/24.0),1) avg FROM T_REC_OFFER AS OFFER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_ORG_Position POS ON POS.FID = DEMAND.FRECURITPOSITIONID ").append("where " + timeSql).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append("AND POS.FID IS NOT NULL ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" GROUP BY POS.FNAME_l2 ORDER BY avg DESC");
            IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString());
            try {
                while (rowSet_01.next()) {
                    hireCycle.put(rowSet_01.getString("name"), rowSet_01.getDouble("avg"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            StringBuilder sql_02 = new StringBuilder("SELECT TOP 10 JOB.FNAME_l2 name,ROUND(AVG(DATEDIFF(hour,DEMAND.FAPPLYDATE,Offer.FENTRYDATE)*1.0/24.0),1) avg FROM T_REC_OFFER AS OFFER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_HR_HRJob JOB ON JOB.FID = DEMAND.FHRJOBID ").append("where " + timeSql).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append("AND JOB.FID IS NOT NULL ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" GROUP BY JOB.FNAME_l2 ORDER BY avg DESC");
            IRowSet rowSet_02 = DbUtil.executeQuery((Context)ctx, (String)sql_02.toString());
            try {
                while (rowSet_02.next()) {
                    hireCycle.put(rowSet_02.getString("name"), rowSet_02.getDouble("avg"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            hireCycle = this.sortMapByValue(hireCycle);
            Set set = hireCycle.keySet();
            Iterator itr = set.iterator();
            for (int i = 0; i < 10 && itr.hasNext(); ++i) {
                String name = (String)itr.next();
                param_01.add(name);
                param_02.add(hireCycle.get(name));
            }
            map.put("lable", param_01.toArray());
            map.put("hireCycle", param_02.toArray());
        } else if (compareDimension == 2) {
            ArrayList<String> param_01 = new ArrayList<String>();
            ArrayList<Double> param_02 = new ArrayList<Double>();
            StringBuilder sql_01 = new StringBuilder("select  t1.FNAME_l2 name  ,round(avg(t2.avg),1) avg  from T_ORG_Admin t1 ").append("left join ( ").append("SELECT  dep.FLONGNUMBER  ,ROUND(AVG(DATEDIFF(hour,DEMAND.FAPPLYDATE,Offer.FENTRYDATE)*1.0/24.0),1) avg FROM T_REC_OFFER AS OFFER   ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_ORG_Admin DEP ON DEP.FID = DEMAND.FDEPARTMENTID ").append("where " + timeSql).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append("GROUP BY dep.FLONGNUMBER ").append(") as t2 on (charindex(concat(t1.FLONGNUMBER,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber) ").append(" where  t1.FPARENTID = '").append(orgId).append("'").append("group by t1.fname_l2 order by avg  desc");
            IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString());
            try {
                String name = "";
                double avg = 0.0;
                while (rowSet_01.next()) {
                    name = rowSet_01.getString("name");
                    avg = rowSet_01.getDouble("avg");
                    param_01.add(name);
                    param_02.add(avg);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            map.put("lable", param_01.toArray());
            map.put("hireCycle", param_02.toArray());
        }
        return map;
    }

    @Override
    protected Map _getRecSourceAnalysis(Context ctx, String orgId, int dimension) throws BOSException {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        String userId = HRManagerUtil.getUserId((Context)ctx);
        HashMap<String, Integer> map_01 = new HashMap<String, Integer>();
        ArrayList<String> recSource = new ArrayList<String>();
        ArrayList recResumeNum = new ArrayList();
        StringBuilder sql_01 = new StringBuilder();
        if (dimension == 1) {
            sql_01.append("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_RESUMEBASEREC RESUME ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where year(RESUME.FWAREHOUSEENTRY) = ").append(curYear).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        } else if (dimension == 2) {
            sql_01.append("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_INTERVIEWRESULT INTER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = INTER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where year(INTER.FCREATETIME) = ").append(curYear).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        } else if (dimension == 3) {
            sql_01.append("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_RECAPPROVAL APPROVAL ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = APPROVAL.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where year(APPROVAL.FCREATETIME) = ").append(curYear).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        } else if (dimension == 4) {
            sql_01.append("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_OFFER OFFER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where year(OFFER.FCREATETIME) = ").append(curYear).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        } else if (dimension == 5) {
            sql_01.append("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_OFFER OFFER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where YEAR(OFFER.FENTRYDATE) = ").append(curYear).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        }
        IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString());
        try {
            while (rowSet_01.next()) {
                map_01.put(rowSet_01.getString("name"), rowSet_01.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!map_01.isEmpty()) {
            if (map_01.get(null) != null) {
                if (map_01.get("\u5176\u5b83") != null) {
                    map_01.put("\u5176\u5b83", (Integer)map_01.get("\u5176\u5b83") + (Integer)map_01.get(null));
                } else {
                    map_01.put("\u5176\u5b83", (Integer)map_01.get(null));
                }
            }
            for (String name : map_01.keySet()) {
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                recSource.add(name);
                if (map_01.get(name) == null) continue;
                recResumeNum.add(map_01.get(name));
            }
        }
        map.put("recSource", recSource.toArray());
        map.put("recResumeNum", recResumeNum.toArray());
        return map;
    }

    @Override
    protected Map _getRecSourceCompare(Context ctx, String orgId) throws BOSException {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        String userId = HRManagerUtil.getUserId((Context)ctx);
        ArrayList<String> recSource = new ArrayList<String>();
        ArrayList<Integer> recResumeNum = new ArrayList<Integer>();
        ArrayList<Integer> entryNum = new ArrayList<Integer>();
        ArrayList<String> completeRate = new ArrayList<String>();
        Map<String, Integer> map_01 = new HashMap<String, Integer>();
        StringBuilder sql_01 = new StringBuilder("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_RESUMEBASEREC RESUME ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where year(RESUME.FWAREHOUSEENTRY) = ").append(curYear).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        IRowSet rowSet_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01.toString());
        try {
            while (rowSet_01.next()) {
                map_01.put(rowSet_01.getString("name"), rowSet_01.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> map_02 = new HashMap<String, Integer>();
        StringBuilder sql_02 = new StringBuilder("SELECT SOURCE.FNAME_l2 name,count(RESUME.FID) count  FROM T_REC_OFFER OFFER ").append("LEFT JOIN T_REC_RESUMEBASEREC RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append("LEFT JOIN T_REC_ResumeSource SOURCE ON SOURCE.FID = RESUME.FRESSOURCEID ").append("where YEAR(OFFER.FENTRYDATE) = ").append(curYear).append(" AND RESUME.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )").append(" group by SOURCE.FNAME_l2 ");
        IRowSet rowSet_02 = DbUtil.executeQuery((Context)ctx, (String)sql_02.toString());
        try {
            while (rowSet_02.next()) {
                map_02.put(rowSet_02.getString("name"), rowSet_02.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!map_01.isEmpty()) {
            if (map_01.get(null) != null) {
                if (map_01.get("\u5176\u5b83") != null && map_01.get(null) != null) {
                    map_01.put("\u5176\u5b83", (Integer)map_01.get("\u5176\u5b83") + (Integer)map_01.get(null));
                } else {
                    map_01.put("\u5176\u5b83", (Integer)map_01.get(null));
                }
            }
            map_01 = this.sortMapByValue(map_01);
            int resumeNum = 0;
            int entryNumber = 0;
            double rate = 0.0;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            Set keySet = map_01.keySet();
            for (String name : keySet) {
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                resumeNum = (Integer)map_01.get(name);
                entryNumber = map_02.get(name) != null ? (Integer)map_02.get(name) : 0;
                rate = (double)entryNumber / (double)resumeNum;
                recSource.add(name);
                recResumeNum.add(resumeNum);
                entryNum.add(entryNumber);
                completeRate.add(numberFormat.format(rate * 100.0));
            }
        }
        map.put("recSource", recSource.toArray());
        map.put("recResumeNum", recResumeNum.toArray());
        map.put("entryNum", entryNum.toArray());
        map.put("completeRate", completeRate.toArray());
        return map;
    }

    private <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        LinkedHashMap<K, V> sortMap = new LinkedHashMap<K, V>();
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> param1, Map.Entry<K, V> param2) {
                return ((Comparable)param2.getValue()).compareTo(param1.getValue());
            }
        });
        for (Map.Entry<K, V> entry : list) {
            sortMap.put(entry.getKey(), entry.getValue());
        }
        return sortMap;
    }

    private Map getRecCompleteRate(Context ctx, String orgId, int year, int talentsDimension) throws BOSException {
        String userId = HRManagerUtil.getUserId((Context)ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        String startDate = curYear + "-01-01";
        int recuritNumber = 0;
        int entryNum = 0;
        double completeRate = 0.0;
        entryNum = this.getEntryNum(ctx, orgId, year, talentsDimension, userId);
        if (year == curYear) {
            int num_01 = this.getRecNum(ctx, orgId, talentsDimension, userId);
            int num_02 = 0;
            StringBuilder sql_02 = new StringBuilder("SELECT COUNT(OFFER.FID ) as count FROM T_REC_OFFER AS OFFER  ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where OFFER.FEntryDate < {d'" + startDate + "'} ").append(" AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            if (talentsDimension == 1) {
                sql_02.append(" AND RECAR.FIsKeyTalents = 1 ");
            }
            num_02 = this.getCountBySql(ctx, sql_02);
            int num_03 = 0;
            StringBuilder sql_03 = new StringBuilder("SELECT COUNT(OFFER.FID ) as count FROM T_REC_OFFER AS OFFER  ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where YEAR(OFFER.FENTRYDATE) = " + curYear).append(" AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FLOWSTATE  in (1,2) ").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            if (talentsDimension == 1) {
                sql_03.append(" AND RECAR.FIsKeyTalents = 1 ");
            }
            num_03 = this.getCountBySql(ctx, sql_03);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u62db\u8058\u5b8c\u6210\u7387 : \u62db\u8058\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u7684\u62db\u8058\u9700\u6c42\u4eba\u6570 = " + num_01 + " \u62db\u8058\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\uff0c\u5e76\u4e14\u5728\u5f53\u6708\u4ee5\u524d\u5165\u804c\u7684\u4eba\u6570" + num_02 + " \u62db\u8058\u72b6\u6001\u4e3a\u5b8c\u6210\u6216\u8005\u7ec8\u6b62\uff0c\u5f53\u6708\u5165\u804c\u7684\u4eba\u6570=" + num_03 + " \u5f53\u6708\u5df2\u5165\u804c\u548c\u5165\u804c\u5728\u9014\u7684\u4eba\u6570=" + entryNum));
            }
            recuritNumber = num_01 - num_02 + num_03;
        } else {
            recuritNumber = this.getLastRecNum(ctx, orgId, year, talentsDimension, userId);
            int lastEntryNum = 0;
            StringBuilder sql_02 = new StringBuilder("SELECT COUNT(OFFER.FID ) as count FROM T_REC_OFFER AS OFFER  ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where (YEAR(OFFER.FENTRYDATE) = " + curYear + " or YEAR(OFFER.FPREENTRYDATE) = " + curYear + ") ").append(" AND YEAR(DEMAND.FAPPLYDATE) = ").append(year - 1).append(" AND RESUME.FRESUMESTATEID in ('At3hDE4xRiSQ5VsoAhavkwhd7oA=','5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            if (talentsDimension == 1) {
                sql_02.append(" AND RECAR.FIsKeyTalents = 1 ");
            }
            lastEntryNum = this.getCountBySql(ctx, sql_02);
            recuritNumber += lastEntryNum;
        }
        map.put("recuritNumber", String.valueOf(recuritNumber));
        map.put("entryNum", String.valueOf(entryNum));
        if (recuritNumber != 0) {
            completeRate = (double)entryNum / (double)recuritNumber;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            String result = numberFormat.format(completeRate * 100.0);
            map.put("completeRate", result);
        } else {
            map.put("completeRate", "100");
        }
        return map;
    }

    private int getLastRecNum(Context ctx, String orgId, int year, int talentsDimension, String userId) throws BOSException {
        int num = 0;
        if (talentsDimension == 1) {
            StringBuilder sql_01 = new StringBuilder();
            sql_01.append("SELECT SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND ").append(" where DEMAND.FLOWSTATE <> 3 ").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND YEAR(DEMAND.FAPPLYDATE) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 1 ");
            int num_01 = this.getCountBySql(ctx, sql_01);
            StringBuilder sql_02 = new StringBuilder("SELECT COUNT(RESUME.FID ) as count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append(" WHERE RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FLOWSTATE <> 3 ").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND YEAR(DEMAND.FAPPLYDATE) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 1 AND RECAR.FIsKeyTalents = 0");
            int num_02 = this.getCountBySql(ctx, sql_02);
            StringBuilder sql_03 = new StringBuilder("SELECT COUNT(RESUME.FID ) as count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append(" WHERE RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FLOWSTATE <> 3 ").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND YEAR(DEMAND.FAPPLYDATE) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 0 AND RECAR.FIsKeyTalents = 1");
            int num_03 = this.getCountBySql(ctx, sql_03);
            num = num_01 - num_02 + num_03;
        } else {
            StringBuilder sql_01 = new StringBuilder("SELECT SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND ").append(" where DEMAND.FLOWSTATE <> 3 ").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND YEAR(DEMAND.FAPPLYDATE) = ").append(year).append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            num = this.getCountBySql(ctx, sql_01);
        }
        return num;
    }

    private int getRecNum(Context ctx, String orgId, int talentsDimension, String userId) throws BOSException {
        int num = 0;
        if (talentsDimension == 1) {
            StringBuilder sql_01 = new StringBuilder();
            sql_01.append("SELECT SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND where ").append(" DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 1 ");
            int num_01 = this.getCountBySql(ctx, sql_01);
            StringBuilder sql_02 = new StringBuilder("SELECT COUNT(RESUME.FID ) as count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append(" WHERE RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 1 AND RECAR.FIsKeyTalents = 0");
            int num_02 = this.getCountBySql(ctx, sql_02);
            StringBuilder sql_03 = new StringBuilder("SELECT COUNT(RESUME.FID ) as count FROM T_REC_RESUMEBASEREC AS RESUME  ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append(" WHERE RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append(" AND DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" ) AND DEMAND.FIsKeyTalents = 0 AND RECAR.FIsKeyTalents = 1");
            int num_03 = this.getCountBySql(ctx, sql_03);
            num = num_01 - num_02 + num_03;
        } else {
            StringBuilder sql_01 = new StringBuilder();
            sql_01.append("SELECT SUM(DEMAND.FRECURITNUMBER) AS count  FROM T_REC_RECURITMENTDEMAND DEMAND where ").append(" DEMAND.FlowState=0 AND DEMAND.FBillState = 3").append(" AND DEMAND.FRecuritmentType <> '\u5185\u90e8\u7ade\u8058' AND DEMAND.FIsTemplate = 0").append(" AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
            num = this.getCountBySql(ctx, sql_01);
        }
        return num;
    }

    private int getEntryNum(Context ctx, String orgId, int year, int talentsDimension, String userId) throws BOSException {
        StringBuilder sql_04 = new StringBuilder("SELECT COUNT(OFFER.FID ) as count FROM T_REC_OFFER AS OFFER  ").append("LEFT JOIN T_REC_RESUMEBASEREC AS RESUME ON RESUME.FID = OFFER.FRESUMEBASERECID ").append("LEFT JOIN T_REC_RECURITMENTDEMAND DEMAND ON DEMAND.FID = RESUME.FRECURITMENTDEMANDID ").append(" LEFT JOIN T_REC_RECAPPROVAL RECAR ON RECAR.FRESUMEBASERECID = RESUME.FID  ").append("where YEAR(OFFER.FENTRYDATE) = " + year + " ").append("AND RESUME.FRESUMESTATEID in ('5LLB5TwtSAaxBn7MZvEtyQhd7oA=') ").append("AND DEMAND.FDEPARTMENTID in ( ").append(this.getDepartmentRangeSql(ctx, orgId, userId)).append(" )");
        if (talentsDimension == 1) {
            sql_04.append(" AND RECAR.FIsKeyTalents = 1 ");
        }
        return this.getCountBySql(ctx, sql_04);
    }

    private int getCountBySql(Context ctx, StringBuilder sql) throws BOSException {
        int entryNum = 0;
        IRowSet rowSet_04 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet_04.next()) {
                entryNum = rowSet_04.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return entryNum;
    }

    private String getDepartmentRangeSql(Context ctx, String orgId, String userId) throws BOSException {
        String includeSubSql = null;
        includeSubSql = HRManagerUtil.isUserOrgIncludeSub((Context)ctx, (String)userId, (String)orgId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        StringBuilder sql = new StringBuilder(" select child.FID from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(HRRecFacadeControllerBean.getPersonPositionResponseAdminSql(userId)).append(" union ").append("select adminOrg.fid as forgId from t_org_admin adminOrg where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-8e9a-0000024851f0PERMITEM") + ")").append(" ) range on child.fid = range.forgid").append(includeSubSql).append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1 ");
        return sql.toString();
    }

    public static String getPersonPositionResponseAdminSql(String userId) {
        StringBuffer sql = new StringBuffer("select orgAdmin.fid as forgId").append(" from T_ORG_PositionMember pm").append(" inner join T_PM_User pmuser on pmuser.fpersonid = pm.fpersonid").append(" inner join T_ORG_Position position on position.fid= pm.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin orgAdmin on (charindex(concat(adcount.flongnumber,'!'),orgAdmin.flongnumber) = 1 or adcount.flongnumber = orgAdmin.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and position.fisrespposition = 1").append(" and orgAdmin.fisstartshr = 1");
        return sql.toString();
    }
}

