/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.recuritment.IPInterviewersCollection;
import com.kingdee.shr.recuritment.IPInterviewersInfo;
import com.kingdee.shr.recuritment.app.AbstractIPInterviewersControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IPInterviewersControllerBean
extends AbstractIPInterviewersControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.IPInterviewersControllerBean");

    @Override
    protected void _updateInterviewersMesg(Context ctx, IObjectCollection interviewers) throws BOSException {
        IPInterviewersCollection coll = (IPInterviewersCollection)interviewers;
        String sql = "UPDATE T_REC_IPInterviewers SET FInterviewerEmail=?,FInterviewerCell=? WHERE FInterviewerId = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            IPInterviewersInfo info = (IPInterviewersInfo)iter.next();
            Object[] params = new Object[]{info.getInterviewerEmail(), info.getInterviewerCell(), info.getInterviewerId()};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    @Override
    protected Map<String, String> _getInterviewersEmailByIpId(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FInterviewerName,FInterviewerEmail FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ?";
        Object[] params = new Object[]{interviewPlanId.toString()};
        HashMap<String, String> emails = null;
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
            if (datas != null && !datas.isEmpty()) {
                emails = new HashMap<String, String>();
                for (int i = 0; i < datas.size(); ++i) {
                    Object[] data = datas.get(i);
                    emails.put((String)data[0], (String)data[1]);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return emails;
    }

    @Override
    protected String[] _getInterviewerNameByEmail(Context ctx, String[] emails) throws BOSException {
        String[] interNames = null;
        int len = emails.length;
        if (len > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    sb.append("?");
                    continue;
                }
                sb.append(",?");
            }
            String sql = "SELECT DISTINCT FInterviewerName FROM T_REC_IPInterviewers WHERE FInterviewerEmail IN (" + sb.toString() + ")";
            try {
                List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, emails);
                interNames = new String[datas.size()];
                for (int i = 0; i < interNames.length; ++i) {
                    interNames[i] = (String)datas.get(i)[0];
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return interNames;
    }

    @Override
    protected String _getInterviewerNameByInterviewerId(Context ctx, IObjectPK interviewerId) throws BOSException {
        String interName = null;
        try {
            String sql = "SELECT FInterviewerName FROM T_REC_IPInterviewers WHERE FInterviewerId = ?";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewerId.toString()});
            if (datas != null && !datas.isEmpty()) {
                interName = (String)datas.get(0)[0];
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return interName;
    }

    @Override
    protected String[] _getInterviewerNamesByInterviewerIds(Context ctx, String[] interivewers) throws BOSException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < interivewers.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        String[] names = null;
        try {
            String sql = "SELECT FInterviewerName FROM T_REC_IPInterviewers WHERE FInterviewerId in (" + sb.toString() + ")";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, interivewers);
            if (datas != null && !datas.isEmpty()) {
                int dataSize = datas.size();
                names = new String[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    names[i] = (String)datas.get(i)[0];
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return names;
    }

    @Override
    protected Map<String, String> _getInterviewersEmailByInterviewerIds(Context ctx, String[] interviewerIds) throws BOSException {
        HashMap<String, String> emails = new HashMap<String, String>();
        StringBuilder fillParam = new StringBuilder();
        for (int i = 0; i < interviewerIds.length; ++i) {
            if (i == 0) {
                fillParam.append("?");
                continue;
            }
            fillParam.append(",?");
        }
        String sql = "SELECT FInterviewerName,FInterviewerEmail FROM T_REC_IPInterviewers WHERE FInterviewerId in (" + fillParam.toString() + ")";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, interviewerIds);
            if (datas != null && !datas.isEmpty()) {
                for (Object[] data : datas) {
                    emails.put((String)data[0], (String)data[1]);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return emails;
    }

    @Override
    protected Map<String, String> _getInterviewersCallByInterviewerIds(Context ctx, String[] interviewerIds) throws BOSException {
        HashMap<String, String> calls = new HashMap<String, String>();
        StringBuilder fillParam = new StringBuilder();
        for (int i = 0; i < interviewerIds.length; ++i) {
            if (i == 0) {
                fillParam.append("?");
                continue;
            }
            fillParam.append(",?");
        }
        String sql = "SELECT FInterviewerName,FInterviewerCell FROM T_REC_IPInterviewers WHERE FInterviewerId in (" + fillParam.toString() + ")";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, interviewerIds);
            if (datas != null && !datas.isEmpty()) {
                for (Object[] data : datas) {
                    calls.put((String)data[0], (String)data[1]);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return calls;
    }

    @Override
    protected Map _getInterviewersCallByIpId(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FInterviewerName,FInterviewerCell FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ?";
        Object[] params = new Object[]{interviewPlanId.toString()};
        HashMap<String, String> calls = null;
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
            if (datas != null && !datas.isEmpty()) {
                calls = new HashMap<String, String>();
                for (int i = 0; i < datas.size(); ++i) {
                    Object[] data = datas.get(i);
                    calls.put((String)data[0], (String)data[1]);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return calls;
    }
}

