/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentManagerFacade;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.recuritment.EducationExpRECCollection;
import com.kingdee.shr.recuritment.EducationExpRECFactory;
import com.kingdee.shr.recuritment.EducationExpRECInfo;
import com.kingdee.shr.recuritment.ElementOperator;
import com.kingdee.shr.recuritment.FilterCriteriaInfo;
import com.kingdee.shr.recuritment.IIPInterviewStructure;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailDiathesis;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailEvaluate;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailResult;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailWrite;
import com.kingdee.shr.recuritment.IPInterviewStructureCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureInfo;
import com.kingdee.shr.recuritment.IPInterviewersFactory;
import com.kingdee.shr.recuritment.IPInterviewersInfo;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.InterviewPlanResultCollection;
import com.kingdee.shr.recuritment.InterviewPlanResultFactory;
import com.kingdee.shr.recuritment.InterviewPlanResultInfo;
import com.kingdee.shr.recuritment.InterviewResultStatusEnum;
import com.kingdee.shr.recuritment.InterviewResultStructureInfo;
import com.kingdee.shr.recuritment.ProjectExpCollection;
import com.kingdee.shr.recuritment.ProjectExpFactory;
import com.kingdee.shr.recuritment.ProjectExpInfo;
import com.kingdee.shr.recuritment.RecRegisterCollection;
import com.kingdee.shr.recuritment.RecRegisterFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumePhotoCollection;
import com.kingdee.shr.recuritment.ResumePhotoFactory;
import com.kingdee.shr.recuritment.ResumePhotoInfo;
import com.kingdee.shr.recuritment.SelfEvaluationRecCollection;
import com.kingdee.shr.recuritment.SelfEvaluationRecFactory;
import com.kingdee.shr.recuritment.SelfEvaluationRecInfo;
import com.kingdee.shr.recuritment.WorkAgeEnum;
import com.kingdee.shr.recuritment.WorkYearEnum;
import com.kingdee.shr.recuritment.WorkingExpCollection;
import com.kingdee.shr.recuritment.WorkingExpFactory;
import com.kingdee.shr.recuritment.WorkingExpInfo;
import com.kingdee.shr.recuritment.app.AbstractInterviewGoFacadeControllerBean;
import com.kingdee.shr.recuritment.app.bo.interviewGo.File;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterAnalysisData;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewInfo;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewJudgeResult;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewJudgeResultInfo;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewProcess;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewProcessResult;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureData;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureElement;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureGroupData;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewTask;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewTaskItem;
import com.kingdee.shr.recuritment.app.bo.interviewGo.Seeker;
import com.kingdee.shr.recuritment.app.bo.interviewGo.TargetPosition;
import com.kingdee.shr.recuritment.app.bo.interviewGo.User;
import com.kingdee.shr.recuritment.app.bo.interviewGo.UserInterviewData;
import com.kingdee.shr.recuritment.app.bo.interviewGo.UserInterviewTaskBean;
import com.kingdee.shr.recuritment.app.bo.interviewGo.resume.EduExp;
import com.kingdee.shr.recuritment.app.bo.interviewGo.resume.ProExp;
import com.kingdee.shr.recuritment.app.bo.interviewGo.resume.ResumeInfo;
import com.kingdee.shr.recuritment.app.bo.interviewGo.resume.TargetJob;
import com.kingdee.shr.recuritment.app.bo.interviewGo.resume.WorkExp;
import com.kingdee.shr.recuritment.app.service.interviewGo.SendInterviewMsgService;
import com.kingdee.shr.recuritment.app.service.interviewGo.TimeHelperService;
import com.kingdee.shr.recuritment.app.service.videoInterview.VideoInterviewRunnable;
import com.kingdee.shr.recuritment.app.util.AttachmentUtil;
import com.kingdee.shr.recuritment.app.util.EvaluateHttpUtil;
import com.kingdee.shr.recuritment.app.util.RecOsfUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.app.util.job.RecSyncTaskThreadPool;
import com.kingdee.shr.recuritment.utils.InterGOUtil;
import com.kingdee.shr.recuritment.utils.RecMetaUtil;
import com.kingdee.shr.recuritment.utils.RecUIViewUtil;
import com.kingdee.shr.recuritment.vo.FieldInfo;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.util.CollectionUtils;
import sun.misc.BASE64Encoder;

public class InterviewGoFacadeControllerBean
extends AbstractInterviewGoFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Pattern number = Pattern.compile("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+(.[0-9]+)?$");
    private int seqNo = 0;
    private Map<String, Object> evaluateData;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewGoFacadeControllerBean");

    @Override
    protected UserInterviewData _getUserInterviewData(Context ctx, IObjectPK interviewerId) throws BOSException {
        if (interviewerId == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        String sql = "SELECT COUNT(DISTINCT IR.FRESUMEBASERECID) AS COUNT FROM T_REC_InterviewResult IR LEFT JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID) WHERE DR.FInterviewerId = ? AND year(IP.FInterviewTime) = ? AND DR.FSAVESTATE = 0 ";
        int totalInterCount = this.getExecuteCount(ctx, sql, new Object[]{interviewerId.toString(), year});
        sql = "SELECT ER.FInterviewerId FROM T_REC_InterviewPlan IP JOIN T_REC_IPInterviewers ER ON (IP.FID = ER.FInterviewPlanId) JOIN T_REC_IPISDetailResult DR ON (IP.FID = DR.FINTERVIEWPLANID) WHERE year(IP.FInterviewTime) = ? AND DR.FSAVESTATE = 0 GROUP BY ER.FInterviewerId HAVING COUNT(distinct IP.FInterviewID) < ?";
        int count = 0;
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{year, totalInterCount});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!RecDBUtils.isEmpty(datas)) {
            count = datas.size();
        }
        int beyond = 0;
        if (count > 0) {
            sql = "SELECT COUNT(DISTINCT  ER.FInterviewerId) AS COUNT FROM T_REC_InterviewPlan IP JOIN T_REC_IPInterviewers ER ON (IP.FID = ER.FInterviewPlanId) LEFT OUTER JOIN T_REC_IPISDetailResult DR ON (IP.FID = DR.FINTERVIEWPLANID ) WHERE year(IP.FInterviewTime) = ? AND DR.FSAVESTATE = 0  ";
            double interviewerCount = this.getExecuteCount(ctx, sql, new Object[]{year});
            beyond = (int)((double)count / interviewerCount * 100.0);
        }
        return new UserInterviewData(totalInterCount, beyond);
    }

    @Override
    protected Object _getUserTaskCount(Context ctx, IObjectPK interviewerId) throws BOSException {
        if (interviewerId == null) {
            return null;
        }
        UserInterviewTaskBean userLatestTask = new UserInterviewTaskBean();
        String interSql = "SELECT COUNT(IP.FInterviewID) AS COUNT FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID) WHERE IP.FInterviewTime > now() AND DR.FResult = '-1' AND DR.FSaveState = 0 AND (IR.FResult <> 1 or IR.FResult is null) AND DR.FInterviewerId = ?";
        int interCount = this.getExecuteCount(ctx, interSql, new Object[]{interviewerId.toString()});
        userLatestTask.setTotalInterCount(interCount);
        String judgeSql = "SELECT COUNT(IP.FInterviewID) AS COUNT FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID) WHERE IP.FInterviewTime <= now() AND DR.FResult = '-1' AND DR.FSaveState = 0 AND (IR.FResult <> 1 or IR.FResult is null) AND DR.FInterviewerId = ?";
        int judgeCount = this.getExecuteCount(ctx, judgeSql, new Object[]{interviewerId.toString()});
        userLatestTask.setTotalJudgeCount(judgeCount);
        return userLatestTask;
    }

    @Override
    protected UserInterviewTaskBean _getUserLatestTask(Context ctx, IObjectPK interviewerId, int daysCount) throws BOSException {
        if (interviewerId == null) {
            return null;
        }
        UserInterviewTaskBean userLatestTask = new UserInterviewTaskBean();
        InterviewTask[] userLatestTasks = this.getUserLatestTasks(ctx, interviewerId, daysCount);
        InterviewTask[] res = new InterviewTask[]{userLatestTasks[1], userLatestTasks[0]};
        userLatestTask.setTaskList(res);
        return userLatestTask;
    }

    @Override
    protected UserInterviewTaskBean _getUserAllTasks(Context ctx, IObjectPK interviewerId, String searchKey, int pageNo, int dataCount) throws BOSException {
        HashMap result = new HashMap();
        InterviewTask[] tasks = null;
        StringBuilder sql = new StringBuilder("SELECT ").append("IP.FID AS recordId,IP.FInterviewStageName AS interStatus,DR.FResult AS state,IR.FResult AS interviewResult, ").append("RB.FID AS resumeId, RB.FName AS seekerName, RB.FGender seekerSex, ").append("IP.FInterviewTime AS interviewInfoTime, IP.FInterviewAddress AS interviewInfoPlace, ").append("IP.FInterviewCompany AS interviewInfoInterviewCompany,").append("VIR.FID AS videoInterview,").append("VIR.FVideoType AS videoType,").append("RB.FRecuritmentDemandID AS demandId ").append("FROM ").append("T_REC_InterviewPlan IP ").append("Left JOIN ").append("T_REC_InterviewResult IR ").append("ON (IP.FInterviewID = IR.FID) ").append("LEFT JOIN ").append("T_REC_ResumeBaseRec RB ").append("ON (IR.FResumeBaseRecID = RB.FID) ").append("LEFT JOIN ").append("T_REC_RecuritmentDemand RD ").append("ON (RB.FRecuritmentDemandID = RD.FID) ").append("LEFT JOIN ").append("T_ORG_Position RP ").append("ON (RD.FRecuritPositionID = RP.FID) ").append("LEFT JOIN ").append("T_HR_HRJob JOB ").append("ON (RB.FHrJobID = JOB.FID) ").append("LEFT JOIN ").append("T_REC_IPISDetailResult DR ").append("ON (DR.FInterviewPlanId = IP.FID) ").append("LEFT JOIN ").append("T_REC_VideoInterviewRecord VIR ").append("ON (IP.FVideoInterRecordID = VIR.FID) ").append("where  DR.FInterviewerId = '" + interviewerId.toString() + "' AND DR.FSaveState = 0 and RB.FRecuritmentDemandID is not null ");
        String searchFilterSql = "";
        if (!StringUtils.isEmpty((CharSequence)searchKey)) {
            searchFilterSql = this.getSearchFilterSql(sql.toString(), searchKey);
            searchFilterSql = searchFilterSql + "ORDER BY interviewInfoTime DESC,state ASC";
        } else {
            sql.append("ORDER BY interviewInfoTime DESC,state ASC");
            searchFilterSql = sql.toString();
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)searchFilterSql, (int)((pageNo - 1) * dataCount), (int)dataCount);
            tasks = this.getUserAllTasks(ctx, rs);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        UserInterviewTaskBean taskBean = new UserInterviewTaskBean();
        if (tasks != null && tasks.length > 0) {
            for (InterviewTask task : tasks) {
                taskBean.setTotalJudgeCount(taskBean.getTotalJudgeCount() + task.getCountNum());
            }
        }
        taskBean.setTaskList(tasks);
        return taskBean;
    }

    private InterviewTask[] getUserAllTasks(Context ctx, IRowSet rs) throws BOSException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Date now = new Date();
        InterviewTaskItem taskItem = null;
        Seeker seeker = null;
        InterviewInfo interviewInfo = null;
        TargetPosition position = null;
        Date infoTime = null;
        InterviewTask task = null;
        HashMap<String, InterviewTask> taskMap = new HashMap<String, InterviewTask>();
        try {
            while (rs != null && rs.next()) {
                String state;
                taskItem = new InterviewTaskItem();
                String recordId = rs.getString("recordId");
                taskItem.setRecordId(recordId);
                taskItem.setInterStatus(rs.getString("interStatus"));
                if (rs.getDate("interviewInfoTime") != null) {
                    infoTime = new Date(rs.getDate("interviewInfoTime").getTime());
                }
                if (StringUtils.isEmpty((CharSequence)(state = rs.getString("state"))) || "-1".equals(state) || "2".equals(state)) {
                    if (rs.getInt("interviewResult") == 1) {
                        taskItem.setState("\u5f55\u5165\u8fc7\u671f");
                    } else if (infoTime == null) {
                        taskItem.setState("\u5f85\u8bc4\u4ef7");
                    } else if (now.after(infoTime)) {
                        taskItem.setState("\u5f85\u8bc4\u4ef7");
                    } else {
                        taskItem.setState("\u5f85\u9762\u8bd5");
                    }
                } else if ("3".equals(state)) {
                    taskItem.setState("\u901a\u8fc7");
                } else if ("4".equals(state)) {
                    taskItem.setState("\u4e0d\u901a\u8fc7");
                } else if ("5".equals(state)) {
                    taskItem.setState("\u653e\u5f03\u9762\u8bd5");
                } else if ("6".equals(state)) {
                    taskItem.setState("\u7ec8\u6b62\u9762\u8bd5");
                } else {
                    taskItem.setState("\u5f85\u5b9a");
                }
                seeker = new Seeker();
                seeker.setResumeId(rs.getString("resumeId"));
                seeker.setName(rs.getString("seekerName"));
                seeker.setSex(rs.getInt("seekerSex"));
                taskItem.setSeeker(seeker);
                interviewInfo = new InterviewInfo();
                if (infoTime != null) {
                    interviewInfo.setTime(timeFormat.format(infoTime));
                }
                interviewInfo.setPlace(rs.getString("interviewInfoPlace"));
                interviewInfo.setInterviewCompany(rs.getString("interviewInfoInterviewCompany"));
                if (!StringUtils.isEmpty((CharSequence)rs.getString("videoInterview"))) {
                    interviewInfo.setVideoInterview(true);
                }
                interviewInfo.setVideoType(rs.getString("videoType"));
                taskItem.setInterviewInfo(interviewInfo);
                if (infoTime != null) {
                    String infoDate = dateFormat.format(infoTime);
                    task = (InterviewTask)taskMap.get(infoDate);
                    if (task == null) {
                        task = new InterviewTask(infoDate);
                        taskMap.put(infoDate, task);
                    }
                    task.addItem(taskItem);
                }
                String demandId = rs.getString("demandId");
                logger.error((Object)("demandId\uff1a" + demandId + ",recordId:" + recordId));
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{demandId, recordId}) || "null".equalsIgnoreCase(demandId) || "null".equalsIgnoreCase(recordId)) continue;
                position = this._getTargrtPositionDetail(ctx, (IObjectPK)new ObjectUuidPK(demandId), (IObjectPK)new ObjectUuidPK(recordId));
                taskItem.setTargetPosition(position);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        TreeSet<InterviewTask> taskSets = new TreeSet<InterviewTask>(new Comparator<InterviewTask>(){
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

            @Override
            public int compare(InterviewTask o1, InterviewTask o2) {
                int num = 0;
                try {
                    Date taskDate1 = this.dateFormat.parse(o1.getDate());
                    Date taskDate2 = this.dateFormat.parse(o2.getDate());
                    if (taskDate1.after(taskDate2)) {
                        num = -1;
                    } else if (taskDate1.before(taskDate2)) {
                        num = 1;
                    }
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                return num;
            }
        });
        for (Map.Entry entry : taskMap.entrySet()) {
            InterviewTask t = (InterviewTask)entry.getValue();
            Collections.reverse(t.getTaskItemList());
            t.build();
            taskSets.add(t);
        }
        return taskSets.toArray(new InterviewTask[0]);
    }

    @Override
    protected UserInterviewTaskBean _getUserInterviewTask(Context ctx, IObjectPK interviewerId, String searchKey, int pageNo, int dataCount) throws BOSException {
        String sql = "SELECT IP.FID AS recordId,IP.FInterviewStageName AS interStatus,DR.FResult AS state, RB.FID AS resumeId, RB.FName AS seekerName, RB.FGender seekerSex, IP.FInterviewTime AS interviewInfoTime, IP.FInterviewAddress AS interviewInfoPlace,  IP.FInterviewCompany AS interviewInfoInterviewCompany, VIR.FID AS videoInterview,VIR.FVideoType AS videoType, RB.FRecuritmentDemandID AS demandId FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) JOIN T_REC_ResumeBaseRec RB ON (IR.FResumeBaseRecID = RB.FID) left JOIN T_REC_RecuritmentDemand RD ON (RB.FRecuritmentDemandID = RD.FID) LEFT JOIN T_ORG_Position RP ON (RD.FRecuritPositionID = RP.FID) LEFT JOIN T_HR_HRJob JOB  ON (RB.FHrJobID = JOB.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID ) LEFT JOIN T_REC_VideoInterviewRecord VIR ON (IP.FVideoInterRecordID = VIR.FID) where DR.FInterviewerId = '" + interviewerId.toString() + "' AND IP.FInterviewTime > now()  AND DR.FResult = '-1' AND DR.FSaveState = 0 AND (IR.FResult <> 1 or IR.FResult is null)";
        if (!StringUtils.isEmpty((CharSequence)searchKey)) {
            sql = this.getSearchFilterSql(sql, searchKey);
        }
        sql = sql + "ORDER BY interviewInfoTime ASC,resumeId ASC";
        InterviewTask[] tasks = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)((pageNo - 1) * dataCount), (int)dataCount);
            tasks = this.getUserTasks(ctx, rs);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        UserInterviewTaskBean taskBean = new UserInterviewTaskBean();
        if (tasks != null && tasks.length > 0) {
            for (InterviewTask task : tasks) {
                taskBean.setTotalInterCount(taskBean.getTotalInterCount() + task.getCountNum());
            }
        }
        taskBean.setTaskList(tasks);
        return taskBean;
    }

    private String getSearchFilterSql(String sql, String searchKey) {
        String type = "";
        String name = "";
        String position = "";
        String interviewLink = "";
        String phone = "";
        String interviewTime = "";
        String age = "";
        String minAge = "";
        String maxAge = "";
        String gender = "";
        try {
            String[] ageRange;
            JSONObject searchJson = new JSONObject(searchKey);
            type = searchJson.getString("type");
            name = searchJson.getString("name");
            position = searchJson.getString("position");
            interviewLink = searchJson.getString("interviewLink");
            interviewTime = searchJson.getString("interviewTime");
            phone = searchJson.getString("phone");
            age = searchJson.getString("age");
            gender = searchJson.getString("gender");
            minAge = "";
            maxAge = "";
            if (StringUtils.isNotEmpty((CharSequence)age) && (ageRange = age.split("-")).length == 2) {
                minAge = ageRange[0];
                maxAge = ageRange[1];
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage());
        }
        if ("fast".equals(type)) {
            if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)position)) {
                sql = sql + " AND ( RB.FName  LIKE '%" + name + "%' OR RP.FName_l2 LIKE '%" + position + "%' OR JOB.FName_l2 LIKE '%" + position + "%' ) ";
            }
        } else if ("advanced".equals(type)) {
            String advancedSqlPre = " AND ( ";
            String advancedSqlSuf = " ) ";
            String advancedSql = "";
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                advancedSql = advancedSql + "RB.FName  LIKE '%" + name + "%' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)position)) {
                advancedSql = advancedSql + "AND RP.FName_l2 LIKE '%" + position + "%' OR JOB.FName_l2 LIKE '%" + position + "%' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)interviewLink)) {
                advancedSql = advancedSql + "AND IP.FInterviewStageName like '%" + interviewLink + "%' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)interviewTime)) {
                advancedSql = advancedSql + "AND IP.FInterviewTime = '" + interviewTime + "' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                advancedSql = advancedSql + "AND RB.FMobilePhone like '%" + phone + "%' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)minAge) && StringUtils.isNotEmpty((CharSequence)maxAge)) {
                advancedSql = advancedSql + "AND RB.FAge >= '" + minAge + "'  AND RB.FAge <= '" + maxAge + "' ";
            } else if (StringUtils.isNotEmpty((CharSequence)age)) {
                advancedSql = advancedSql + "AND RB.FAge = '" + age + "' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)gender)) {
                advancedSql = advancedSql + "AND RB.FGender = '" + gender + "' ";
            }
            if (StringUtils.isNotEmpty((CharSequence)advancedSql)) {
                if (advancedSql.startsWith("AND")) {
                    int index = advancedSql.indexOf("AND");
                    advancedSql = advancedSql.substring(index + 3);
                }
                sql = sql + advancedSqlPre + advancedSql + advancedSqlSuf;
            }
        }
        return sql;
    }

    @Override
    protected UserInterviewTaskBean _getUserJudgeTask(Context ctx, IObjectPK interviewerId, String searchKey, int pageNo, int dataCount) throws BOSException {
        String sql = "SELECT IP.FID AS recordId,IP.FInterviewStageName AS interStatus,DR.FResult AS state, RB.FID AS resumeId, RB.FName AS seekerName, RB.FGender seekerSex, IP.FInterviewTime AS interviewInfoTime, IP.FInterviewAddress AS interviewInfoPlace,  IP.FInterviewCompany AS interviewInfoInterviewCompany, VIR.FID AS videoInterview,VIR.FVideoType AS videoType,  RB.FRecuritmentDemandID AS demandId FROM T_REC_InterviewPlan IP left JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID) JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) JOIN T_REC_ResumeBaseRec RB ON (IR.FResumeBaseRecID = RB.FID) left JOIN T_REC_RecuritmentDemand RD ON (RB.FRecuritmentDemandID = RD.FID) LEFT JOIN T_ORG_Position RP ON (RD.FRecuritPositionID = RP.FID) LEFT JOIN T_HR_HRJob JOB  ON (RB.FHrJobID = JOB.FID) LEFT JOIN T_REC_VideoInterviewRecord VIR ON (IP.FVideoInterRecordID = VIR.FID) where DR.FInterviewerId = '" + interviewerId.toString() + "' AND IP.FInterviewTime <= now() AND DR.FResult = '-1' AND DR.FSaveState = 0 AND (IR.FResult <> 1 or IR.FResult is null)";
        if (!StringUtils.isEmpty((CharSequence)searchKey)) {
            sql = this.getSearchFilterSql(sql, searchKey);
        }
        sql = sql + "ORDER BY interviewInfoTime ASC,resumeId ASC";
        InterviewTask[] tasks = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)((pageNo - 1) * dataCount), (int)dataCount);
            tasks = this.getUserTasks(ctx, rs);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        UserInterviewTaskBean taskBean = new UserInterviewTaskBean();
        if (tasks != null && tasks.length > 0) {
            for (InterviewTask task : tasks) {
                taskBean.setTotalJudgeCount(taskBean.getTotalJudgeCount() + task.getCountNum());
            }
        }
        taskBean.setTaskList(tasks);
        return taskBean;
    }

    private InterviewTask[] getUserLatestTasks(Context ctx, IObjectPK interviewerId, int daysCount) throws BOSException {
        InterviewTask[] tasks = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        java.sql.Date nowDate = new java.sql.Date(calendar.getTime().getTime());
        calendar.add(6, daysCount);
        java.sql.Date twoDaysLater = new java.sql.Date(calendar.getTime().getTime());
        HashMap<String, InterviewTask> taskMap = new HashMap<String, InterviewTask>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date toDay = new Date();
        String infoDate = dateFormat.format(toDay);
        taskMap.put(infoDate, new InterviewTask(infoDate, 0));
        calendar.setTime(toDay);
        calendar.add(6, 1);
        String tomorrow = dateFormat.format(calendar.getTime());
        taskMap.put(tomorrow, new InterviewTask(tomorrow, 0));
        String sql = "SELECT IP.FID AS recordId,IP.FInterviewStageName AS interStatus,DR.FResult AS state, RB.FID AS resumeId, RB.FName AS seekerName, RB.FGender seekerSex, IP.FInterviewTime AS interviewInfoTime, IP.FInterviewAddress AS interviewInfoPlace,  IP.FInterviewCompany AS interviewInfoInterviewCompany, VIR.FID AS videoInterview,VIR.FVideoType AS videoType,  RB.FRecuritmentDemandID AS demandId FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID ) JOIN T_REC_ResumeBaseRec RB ON (IR.FResumeBaseRecID = RB.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID) LEFT JOIN T_REC_VideoInterviewRecord VIR ON (IP.FVideoInterRecordID = VIR.FID) where DR.FInterviewerId = ? AND IP.FInterviewTime >= ? AND IP.FInterviewTime < ? AND DR.FResult = '-1' AND DR.FSaveState = 0 AND (IR.FResult <> 1 or IR.FResult is null) ORDER BY state ASC ,interviewInfoTime ASC";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewerId.toString(), nowDate, twoDaysLater});
            tasks = this.getUserLatestTasks(ctx, rs, taskMap);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return tasks;
    }

    private InterviewTask[] getUserLatestTasks(Context ctx, IRowSet rs, Map<String, InterviewTask> taskMap) throws BOSException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Date now = new Date();
        InterviewTaskItem taskItem = null;
        Seeker seeker = null;
        InterviewInfo interviewInfo = null;
        TargetPosition position = null;
        InterviewTask task = null;
        Date infoTime = null;
        HashMap positionMap = Maps.newHashMap();
        try {
            while (rs != null && rs.next()) {
                String state;
                taskItem = new InterviewTaskItem();
                String recordId = rs.getString("recordId");
                taskItem.setRecordId(recordId);
                taskItem.setInterStatus(rs.getString("interStatus"));
                if (rs.getDate("interviewInfoTime") != null) {
                    infoTime = new Date(rs.getDate("interviewInfoTime").getTime());
                }
                if (StringUtils.isEmpty((CharSequence)(state = rs.getString("state"))) || "-1".equals(state) || "2".equals(state)) {
                    if (now.after(infoTime)) {
                        taskItem.setState("\u5f85\u8bc4\u4ef7");
                    } else {
                        taskItem.setState("\u5f85\u9762\u8bd5");
                    }
                } else if ("3".equals(state)) {
                    taskItem.setState("\u901a\u8fc7");
                } else if ("4".equals(state)) {
                    taskItem.setState("\u4e0d\u901a\u8fc7");
                } else if ("5".equals(state)) {
                    taskItem.setState("\u653e\u5f03\u9762\u8bd5");
                } else if ("6".equals(state)) {
                    taskItem.setState("\u7ec8\u6b62\u9762\u8bd5");
                } else {
                    taskItem.setState("\u5f85\u5b9a");
                }
                seeker = new Seeker();
                seeker.setResumeId(rs.getString("resumeId"));
                seeker.setName(rs.getString("seekerName"));
                seeker.setSex(rs.getInt("seekerSex"));
                taskItem.setSeeker(seeker);
                interviewInfo = new InterviewInfo();
                if (infoTime != null) {
                    interviewInfo.setTime(timeFormat.format(infoTime));
                }
                interviewInfo.setPlace(rs.getString("interviewInfoPlace"));
                interviewInfo.setInterviewCompany(rs.getString("interviewInfoInterviewCompany"));
                if (!StringUtils.isEmpty((CharSequence)rs.getString("videoInterview"))) {
                    interviewInfo.setVideoInterview(true);
                }
                interviewInfo.setVideoType(rs.getString("videoType"));
                taskItem.setInterviewInfo(interviewInfo);
                String infoDate = dateFormat.format(infoTime);
                task = taskMap.get(infoDate);
                if (task == null) {
                    task = new InterviewTask(infoDate);
                    taskMap.put(infoDate, task);
                }
                task.addItem(taskItem);
                String demandId = rs.getString("demandId");
                if (positionMap.containsKey(demandId)) {
                    position = (TargetPosition)positionMap.get(demandId);
                } else {
                    position = this._getTargrtPositionDetail(ctx, (IObjectPK)new ObjectUuidPK(demandId), (IObjectPK)new ObjectUuidPK(recordId));
                    positionMap.put(demandId, position);
                }
                taskItem.setTargetPosition(position);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        TreeSet<InterviewTask> taskSets = new TreeSet<InterviewTask>(new Comparator<InterviewTask>(){
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

            @Override
            public int compare(InterviewTask o1, InterviewTask o2) {
                int num = 0;
                try {
                    Date taskDate1 = this.dateFormat.parse(o1.getDate());
                    Date taskDate2 = this.dateFormat.parse(o2.getDate());
                    if (taskDate1.after(taskDate2)) {
                        num = -1;
                    } else if (taskDate1.before(taskDate2)) {
                        num = 1;
                    }
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                return num;
            }
        });
        for (Map.Entry<String, InterviewTask> entry : taskMap.entrySet()) {
            InterviewTask t = entry.getValue();
            t.build();
            taskSets.add(t);
        }
        return taskSets.toArray(new InterviewTask[0]);
    }

    private InterviewTask[] getUserTasks(Context ctx, IRowSet rs) throws BOSException {
        LinkedHashMap taskMap = Maps.newLinkedHashMap();
        return this.getUserLatestTasks(ctx, rs, taskMap);
    }

    @Override
    protected TargetPosition _getTargrtPositionDetail(Context ctx, IObjectPK demandId, IObjectPK interviewPlanId) throws BOSException {
        TargetPosition position = new TargetPosition();
        RecuritmentDemandCollection demandColl = null;
        try {
            demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select *,hrJob.name,recuritPosition.name,filterCriteria.* where id = '" + demandId + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (RecDBUtils.isEmpty((IObjectCollection)demandColl)) {
            throw new BOSException("\u83b7\u53d6\u5019\u9009\u4eba\u6240\u5c5e\u62db\u8058\u9700\u6c42\u4fe1\u606f\u5931\u8d25!");
        }
        RecuritmentDemandInfo demandInfo = demandColl.get(0);
        position.setId(demandInfo.getId().toString());
        PositionInfo positionInfo = demandInfo.getRecuritPosition();
        HRJobInfo hrJob = demandInfo.getHrJob();
        if (positionInfo != null && positionInfo.getId() != null) {
            position.setName(positionInfo.getName());
            position.setPositionId(positionInfo.getId().toString());
            position.setPositionName(positionInfo.getName());
        } else if (hrJob != null && hrJob.getId() != null) {
            position.setName(hrJob.getName());
            position.setPositionId(hrJob.toString());
            position.setPositionName(hrJob.getName());
        }
        AdminOrgUnitCollection departmentColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id = '" + demandInfo.getDepartment().getId() + "'");
        if (RecDBUtils.isEmpty((IObjectCollection)departmentColl)) {
            throw new BOSException("\u83b7\u53d6\u5019\u9009\u4eba\u6240\u5c5e\u62db\u8058\u9700\u6c42\u4fe1\u606f\u5bf9\u5e94\u90e8\u95e8\u5931\u8d25!");
        }
        AdminOrgUnitInfo departmentInfo = departmentColl.get(0);
        OrgUnitLayerTypeInfo layerInfo = departmentInfo.getUnitLayerType();
        if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000162824988".equals(layerInfo.getId().toString())) {
            position.setGroup(departmentInfo.getDisplayName());
            position.setDepartment(departmentInfo.getName());
        } else if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000262824988".equals(layerInfo.getId().toString())) {
            String displayName = departmentInfo.getDisplayName();
            position.setGroup(displayName.substring(0, displayName.indexOf("_")));
            position.setCompany(displayName.substring(displayName.indexOf("_") + 1));
            position.setDepartment(departmentInfo.getName());
        } else if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000362824988".equals(layerInfo.getId().toString())) {
            String displayName = departmentInfo.getDisplayName();
            position.setGroup(displayName.substring(0, displayName.indexOf("_")));
            if (displayName.indexOf("_") < displayName.lastIndexOf("_")) {
                position.setCompany(displayName.substring(displayName.indexOf("_") + 1, displayName.lastIndexOf("_")));
            }
            position.setDepartment(departmentInfo.getName());
        }
        position.setAddress(demandInfo.getAddress());
        position.setReleaseOrgName(demandInfo.getReleaseOrgName());
        position.setQualification(demandInfo.getQualification());
        position.setResponsibilities(demandInfo.getResponsibilities());
        this.setPositionFilterCriteria(ctx, position, demandInfo, interviewPlanId);
        return position;
    }

    private void setPositionFilterCriteria(Context ctx, TargetPosition position, RecuritmentDemandInfo demandInfo, IObjectPK interviewPlanId) throws BOSException {
        WorkAgeEnum highAge;
        WorkYearEnum highWorkYear;
        InterviewPlanCollection ipColl = null;
        try {
            ipColl = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select interview.resumeBaseRec.hDegree.LevelCode,interview.resumeBaseRec.gender,interview.resumeBaseRec.workSeniority,interview.resumeBaseRec.age where id ='" + interviewPlanId + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (ipColl == null) {
            throw new BOSException("\u83b7\u53d6\u9762\u8bd5\u5b89\u6392\u6570\u636e'" + interviewPlanId + "'\u5931\u8d25\uff01");
        }
        FilterCriteriaInfo fcInfo = demandInfo.getFilterCriteria();
        ResumeBaseRecInfo resume = ipColl.get(0).getInterview().getResumeBaseRec();
        DiplomaInfo resumeDipInfo = resume.getHDegree();
        if (fcInfo != null && fcInfo.isDegreeNoLimit()) {
            position.setDegree("\u5b66\u5386\u4e0d\u9650");
            position.setDegreeOk("true");
        } else {
            DiplomaInfo dipInfo = demandInfo.getHDegree();
            if (dipInfo == null) {
                position.setDegree("\u5b66\u5386\u4e0d\u9650");
                position.setDegreeOk("true");
            } else {
                try {
                    dipInfo = DiplomaFactory.getLocalInstance((Context)ctx).getDiplomaInfo((IObjectPK)new ObjectUuidPK(dipInfo.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                position.setDegree(dipInfo.getName());
                if (resumeDipInfo != null) {
                    if (resumeDipInfo.getLevelCode() >= dipInfo.getLevelCode()) {
                        position.setDegreeOk("true");
                    } else {
                        position.setDegreeOk("false");
                    }
                } else {
                    position.setDegreeOk("");
                }
            }
        }
        Genders gender = resume.getGender();
        if (fcInfo != null && fcInfo.getSex() != null) {
            position.setSex("\u6027\u522b" + fcInfo.getSex().getAlias());
            if (fcInfo.getSex().getValue() == 0) {
                position.setSexOk("true");
            } else if (gender != null && gender.getValue() == fcInfo.getSex().getValue()) {
                position.setSexOk("true");
            } else {
                position.setSexOk("false");
            }
        } else {
            position.setSex("\u6027\u522b\u4e0d\u9650");
            position.setSexOk("true");
        }
        if (gender == null) {
            position.setSexOk("");
        }
        String workSeniority = resume.getWorkSeniority();
        double workExp = -2.0;
        if (!StringUtils.isEmpty((CharSequence)workSeniority)) {
            workExp = Double.parseDouble(workSeniority);
        }
        WorkYearEnum lowWorkYear = fcInfo != null ? fcInfo.getLowWorkYears() : null;
        WorkYearEnum workYearEnum = highWorkYear = fcInfo != null ? fcInfo.getHighWorkYears() : null;
        if (lowWorkYear == null || highWorkYear == null || WorkYearEnum.NOLIMIT.equals((Object)lowWorkYear) && WorkYearEnum.NOLIMIT.equals((Object)highWorkYear)) {
            position.setWorkExp("\u7ecf\u9a8c\u4e0d\u9650");
            position.setWorkExpOk("true");
        } else if (WorkYearEnum.NOLIMIT.equals((Object)lowWorkYear)) {
            position.setWorkExp(highWorkYear.getAlias() + "\u5e74\u4ee5\u4e0b");
            if (workExp > (double)highWorkYear.getValue()) {
                position.setWorkExpOk("false");
            } else {
                position.setWorkExpOk("true");
            }
        } else if (WorkYearEnum.NOLIMIT.equals((Object)highWorkYear)) {
            position.setWorkExp(lowWorkYear.getAlias() + "\u5e74\u4ee5\u4e0a");
            if (workExp < (double)lowWorkYear.getValue()) {
                position.setWorkExpOk("false");
            } else {
                position.setWorkExpOk("true");
            }
        } else {
            position.setWorkExp(lowWorkYear.getAlias() + "-" + highWorkYear.getAlias() + "\u5e74");
            if (workExp >= (double)lowWorkYear.getValue() && workExp <= (double)highWorkYear.getValue()) {
                position.setWorkExpOk("true");
            } else {
                position.setWorkExpOk("false");
            }
        }
        if (StringUtils.isEmpty((CharSequence)workSeniority)) {
            position.setWorkExpOk("");
        }
        int age = resume.getAge();
        WorkAgeEnum lowAge = fcInfo != null ? fcInfo.getLowAge() : null;
        WorkAgeEnum workAgeEnum = highAge = fcInfo != null ? fcInfo.getHighAge() : null;
        if (lowAge == null || highAge == null || WorkAgeEnum.NOLIMIT.equals((Object)highAge) && WorkAgeEnum.NOLIMIT.equals((Object)lowAge)) {
            position.setAge("\u5e74\u9f84\u4e0d\u9650");
            position.setAgeOk("true");
        } else if (WorkAgeEnum.NOLIMIT.equals((Object)lowAge)) {
            position.setAge(highAge.getAlias() + "\u5c81\u4ee5\u4e0b");
            if (age > highAge.getValue()) {
                position.setAgeOk("false");
            } else {
                position.setAgeOk("true");
            }
        } else if (WorkAgeEnum.NOLIMIT.equals((Object)highAge)) {
            position.setAge(lowAge.getAlias() + "\u5c81\u4ee5\u4e0a");
            if (age < lowAge.getValue()) {
                position.setAgeOk("false");
            } else {
                position.setAgeOk("true");
            }
        } else {
            position.setAge(lowAge.getAlias() + "-" + highAge.getAlias() + "\u5c81");
            if (age >= lowAge.getValue() && age <= highAge.getValue()) {
                position.setAgeOk("true");
            } else {
                position.setAgeOk("false");
            }
        }
        if (age == 0) {
            position.setAgeOk("");
        }
    }

    private AdminOrgUnitInfo getDepartmentBelongCompany(Context ctx, String depId) throws BOSException {
        String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
        String sql = "SELECT FID," + nameField + ",FLayerTypeID,FCompanyID FROM T_ORG_Admin WHERE FID = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{depId});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        AdminOrgUnitInfo admin = null;
        if (!RecDBUtils.isEmpty(datas)) {
            Object[] data = datas.get(0);
            String fid = (String)data[0];
            String name = (String)data[1];
            String typeId = (String)data[2];
            String companyId = (String)data[3];
            if ("00000000-0000-0000-0000-00000000000262824988".equals(typeId)) {
                admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)fid));
                admin.setName(name);
                return admin;
            }
            if (StringUtils.isBlank((CharSequence)companyId)) {
                return this.getDepartmentBelongCompany(ctx, companyId);
            }
        }
        return admin;
    }

    @Override
    protected InterviewTaskItem _getInterviewInfoDetail(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        InterviewTaskItem taskItem = new InterviewTaskItem();
        Date now = new Date();
        String sql = "SELECT IP.FID AS recordId,IP.FInterviewStageName AS interStatus,IPR.FResult AS state,IR.FResult AS interviewResult, IP.FInterviewTime AS interviewInfoTime,IP.FInterviewAddress AS interviewInfoAddress, IP.FContacterId AS interviewInfoFContacterId,IP.FContacterName AS interviewInfoFContacterName, VIR.FID AS videoInterview,VIR.FVideoType AS videoType, BPERSON.FID AS creatorID,BPERSON.FName_l2  AS creatorName, IR.FResumeBaseRecID AS resumeId, RB.FRecuritmentDemandID AS demandId, RD.FDepartmentID AS departmentId FROM T_REC_InterviewPlan IP LEFT JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) LEFT JOIN T_REC_ResumeBaseRec RB ON (IR.FResumeBaseRecID = RB.FID) LEFT JOIN T_REC_RecuritmentDemand RD ON (RB.FRecuritmentDemandID = RD.FID) LEFT JOIN  T_REC_INTERVIEWPLANRESULT IPR ON (IPR.FINTERVIEWPLANID  = IP.FID) LEFT JOIN  T_PM_User PUSER ON (PUSER.FID  = IP.FLastUpdateUserID) LEFT JOIN  T_BD_Person BPERSON ON (BPERSON.FID  = PUSER.FPersonId) LEFT JOIN T_REC_VideoInterviewRecord VIR ON (IP.FVideoInterRecordID = VIR.FID) where IP.FID = ? ";
        String resumeId = null;
        IRowSet rs = null;
        Date infoTime = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            if (rs != null && rs.next()) {
                String openId;
                taskItem.setRecordId(rs.getString("recordId"));
                taskItem.setInterStatus(rs.getString("interStatus"));
                if (rs.getDate("interviewInfoTime") != null) {
                    infoTime = new Date(rs.getDate("interviewInfoTime").getTime());
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                String state = rs.getString("state");
                String sql_01 = "SELECT DR.FResult AS state FROM T_REC_InterviewPlan IP JOIN T_REC_IPISDetailResult DR ON (DR.FInterviewPlanId = IP.FID) where IP.FID = ? AND DR.FInterviewerId = ? AND DR.FSaveState = 0 ";
                IRowSet rs_01 = DbUtil.executeQuery((Context)ctx, (String)sql_01, (Object[])new Object[]{interviewPlanId.toString(), interviewerId.toString()});
                if (rs_01 != null && rs_01.next()) {
                    String interviewerState = rs_01.getString("state");
                    if (StringUtils.isEmpty((CharSequence)interviewerState) || "-1".equals(interviewerState) || "2".equals(interviewerState)) {
                        if (rs.getInt("interviewResult") == 1) {
                            taskItem.setState("\u5f55\u5165\u8fc7\u671f");
                        } else if (now.after(infoTime)) {
                            taskItem.setState("\u5f85\u8bc4\u4ef7");
                        } else {
                            taskItem.setState("\u5f85\u9762\u8bd5");
                        }
                    } else if ("3".equals(interviewerState)) {
                        taskItem.setState("\u901a\u8fc7");
                    } else if ("4".equals(interviewerState)) {
                        taskItem.setState("\u4e0d\u901a\u8fc7");
                    } else if ("5".equals(interviewerState)) {
                        taskItem.setState("\u653e\u5f03\u9762\u8bd5");
                    } else if ("6".equals(interviewerState)) {
                        taskItem.setState("\u7ec8\u6b62\u9762\u8bd5");
                    } else {
                        taskItem.setState("\u5f85\u5b9a");
                    }
                } else if (StringUtils.isEmpty((CharSequence)state) || "-1".equals(state)) {
                    if (rs.getInt("interviewResult") == 1) {
                        taskItem.setState("\u5f55\u5165\u8fc7\u671f");
                    } else if (now.after(infoTime)) {
                        taskItem.setState("\u5f85\u8bc4\u4ef7");
                    } else {
                        taskItem.setState("\u5f85\u9762\u8bd5");
                    }
                } else if ("3".equals(state)) {
                    taskItem.setState("\u901a\u8fc7");
                } else if ("4".equals(state)) {
                    taskItem.setState("\u4e0d\u901a\u8fc7");
                } else if ("5".equals(state)) {
                    taskItem.setState("\u653e\u5f03\u9762\u8bd5");
                } else if ("6".equals(state)) {
                    taskItem.setState("\u7ec8\u6b62\u9762\u8bd5");
                } else {
                    taskItem.setState("\u5f85\u5b9a");
                }
                InterviewInfo interviewInfo = new InterviewInfo();
                if (infoTime != null) {
                    interviewInfo.setTime(dateFormat.format(infoTime));
                }
                interviewInfo.setPlace(rs.getString("interviewInfoAddress"));
                String interviewInfoFContacterId = rs.getString("interviewInfoFContacterId");
                if (!StringUtil.isEmpty((String)interviewInfoFContacterId)) {
                    openId = RecOsfUtil.getOpenIDByPersonID(ctx, interviewInfoFContacterId);
                    User[] arranger = new User[]{new User(interviewInfoFContacterId, openId, rs.getString("interviewInfoFContacterName"))};
                    interviewInfo.setArranger(arranger);
                } else {
                    openId = RecOsfUtil.getOpenIDByPersonID(ctx, rs.getString("creatorID"));
                    User[] arranger = new User[]{new User(rs.getString("creatorID"), openId, rs.getString("creatorName"))};
                    interviewInfo.setArranger(arranger);
                }
                if (!StringUtils.isEmpty((CharSequence)rs.getString("videoInterview"))) {
                    interviewInfo.setVideoInterview(true);
                }
                interviewInfo.setVideoType(rs.getString("videoType"));
                TargetPosition targetPosition = this._getTargrtPositionDetail(ctx, (IObjectPK)new ObjectUuidPK(rs.getString("demandId")), interviewPlanId);
                interviewInfo.setPosition(targetPosition);
                interviewInfo.setDepartHead(this.getDeparmentPrincipal(ctx, rs.getString("departmentId")));
                interviewInfo.setInterviewer(this.getInterviewDetailInterviewers(ctx, taskItem, interviewPlanId.toString()));
                interviewInfo.setFile(this.getInterviewDetailFile(ctx, interviewPlanId));
                taskItem.setInterviewInfo(interviewInfo);
                taskItem.setTargetPosition(targetPosition);
                resumeId = rs.getString("resumeId");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.setInterviewDetailResumeInfo(ctx, taskItem, resumeId);
        taskItem = this.checkPhoneHiding(ctx, interviewPlanId.toString(), taskItem);
        return taskItem;
    }

    private InterviewTaskItem checkPhoneHiding(Context ctx, String interviewPlanId, InterviewTaskItem taskItem) {
        taskItem.setPhoneHiding(0);
        taskItem.setAttachmentHiding(0);
        if (null != interviewPlanId) {
            try {
                InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select phoneHiding,attachmentHiding where id='" + interviewPlanId + "'");
                if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
                    String phoneHiding = coll.get(0).getPhoneHiding();
                    String attachmentHiding = coll.get(0).getAttachmentHiding();
                    if (!StringUtils.isEmpty((CharSequence)phoneHiding) && phoneHiding.equals("1")) {
                        taskItem.setPhoneHiding(1);
                    }
                    if (!StringUtils.isEmpty((CharSequence)attachmentHiding) && attachmentHiding.equals("1")) {
                        taskItem.setAttachmentHiding(1);
                    }
                    return taskItem;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return taskItem;
    }

    private User[] getInterviewDetailInterviewers(Context ctx, InterviewTaskItem taskItem, String interviewPlanId) throws BOSException {
        IPInterviewStructureDetailResultCollection coll = null;
        try {
            coll = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId + "' and saveState = 0");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        ArrayList<User> users = new ArrayList<User>();
        if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
            IPInterviewStructureDetailResultInfo info = null;
            User user = null;
            String personId = null;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                info = (IPInterviewStructureDetailResultInfo)iter.next();
                user = new User();
                personId = info.getInterviewerId();
                user.setId(personId);
                user.setName(info.getInterviewerName());
                user.setOpenId(RecOsfUtil.getOpenIDByPersonID(ctx, personId));
                users.add(user);
            }
        }
        return users.toArray(new User[0]);
    }

    private void setInterviewDetailResumeInfo(Context ctx, InterviewTaskItem taskItem, String resumeId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)resumeId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("age"));
        evi.getSelector().add(new SelectorItemInfo("gender"));
        evi.getSelector().add(new SelectorItemInfo("workSeniority"));
        evi.getSelector().add(new SelectorItemInfo("mobilePhone"));
        evi.getSelector().add(new SelectorItemInfo("nowResidence"));
        evi.getSelector().add(new SelectorItemInfo("hDegree.name"));
        evi.getSelector().add(new SelectorItemInfo("school"));
        evi.getSelector().add(new SelectorItemInfo("major"));
        evi.getSelector().add(new SelectorItemInfo("lastCompany"));
        evi.getSelector().add(new SelectorItemInfo("expectantPosition"));
        evi.getSelector().add(new SelectorItemInfo("currentWorkingStatus"));
        evi.getSelector().add(new SelectorItemInfo("jobNature"));
        evi.getSelector().add(new SelectorItemInfo("targetPlace"));
        evi.getSelector().add(new SelectorItemInfo("expectantIndustry"));
        evi.getSelector().add(new SelectorItemInfo("expectantPayStr"));
        ResumeBaseRecCollection resumeColl = ResumeBaseRecFactory.getLocalInstance(ctx).getResumeBaseRecCollection(evi);
        if (resumeColl == null || resumeColl.size() <= 0) {
            return;
        }
        ResumeBaseRecInfo resumeInfo = resumeColl.get(0);
        ResumeInfo resume = new ResumeInfo();
        resume.setUserId(resumeInfo.getId().toString());
        resume.setName(resumeInfo.getName() == null ? "" : resumeInfo.getName());
        resume.setAge(resumeInfo.getAge());
        resume.setSex(resumeInfo.getGender() == null ? 0 : resumeInfo.getGender().getValue());
        resume.setWorkYears(StringUtils.isEmpty((CharSequence)resumeInfo.getWorkSeniority()) ? "\u65e0\u7ecf\u9a8c" : resumeInfo.getWorkSeniority());
        resume.setPhoneNumber(StringUtils.isEmpty((CharSequence)resumeInfo.getMobilePhone()) ? "" : resumeInfo.getMobilePhone());
        resume.setLiveCity(StringUtils.isEmpty((CharSequence)resumeInfo.getNowResidence()) ? "\u672a\u77e5" : resumeInfo.getNowResidence());
        resume.setDgree(resumeInfo.getHDegree() == null ? "\u672a\u77e5" : resumeInfo.getHDegree().getName());
        resume.setSchool(StringUtils.isEmpty((CharSequence)resumeInfo.getSchool()) ? "\u672a\u77e5" : resumeInfo.getSchool());
        resume.setMajor(StringUtils.isEmpty((CharSequence)resumeInfo.getMajor()) ? "\u672a\u77e5" : resumeInfo.getMajor());
        resume.setExCompany(StringUtils.isEmpty((CharSequence)resumeInfo.getLastCompany()) ? "\u672a\u77e5" : resumeInfo.getLastCompany());
        if (!StringUtils.isEmpty((CharSequence)resumeId)) {
            RecRegisterCollection recRegisterCollection;
            ResumePhotoInfo resumePhotoInfo;
            byte[] imageData;
            ResumePhotoCollection photocoll = ResumePhotoFactory.getLocalInstance(ctx).getResumePhotoCollection(" where resumeBaseRec='" + resumeId + "'");
            if (photocoll != null && photocoll.size() > 0 && (imageData = (resumePhotoInfo = photocoll.get(0)).getImageData()) != null && imageData.length > 0) {
                BASE64Encoder encoder = new BASE64Encoder();
                String photo = encoder.encode(imageData);
                resume.setPhoto(photo);
            }
            if ((recRegisterCollection = RecRegisterFactory.getLocalInstance(ctx).getRecRegisterCollection("select url where resumeBaseRec.id = '" + resumeId + "'and recRegisterState =3 ")) != null && recRegisterCollection.size() > 0) {
                String url = recRegisterCollection.get(0).getUrl();
                String result = "";
                if (url != null) {
                    int count = url.lastIndexOf("/");
                    String preUrl = url.substring(0, count);
                    String code = url.substring(count + 1);
                    String getUrl = preUrl + "/tsp/cloud/transformurl/" + code;
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)("\u5e94\u8058\u767b\u8bb0\u8868\u83b7\u53d6\u957f\u94fe\u5730\u5740\u63a5\u53e3\uff1a" + getUrl));
                    }
                    result = EvaluateHttpUtil.get(ctx, getUrl);
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)("\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c=\uff1a" + result));
                    }
                }
                taskItem.setRecRegisterLongUrl(result);
            }
        }
        TargetJob targetJob = new TargetJob();
        targetJob.setPosition(resumeInfo.getExpectantPosition() == null ? "\u672a\u77e5" : resumeInfo.getExpectantPosition());
        targetJob.setWorkState(resumeInfo.getCurrentWorkingStatus() == null ? "\u672a\u77e5" : resumeInfo.getCurrentWorkingStatus().getAlias());
        targetJob.setWorkType(resumeInfo.getJobNature() == null ? "\u672a\u77e5" : resumeInfo.getJobNature().getAlias());
        targetJob.setWorkPlace(resumeInfo.getTargetPlace() == null ? "\u672a\u77e5" : resumeInfo.getTargetPlace());
        targetJob.setIndustry(resumeInfo.getExpectantIndustry() == null ? "\u672a\u77e5" : resumeInfo.getExpectantIndustry());
        targetJob.setSalary(resumeInfo.getExpectantPayStr() == null ? "\u672a\u77e5" : resumeInfo.getExpectantPayStr());
        resume.setTargetJob(targetJob);
        resume.setAttachments(AttachmentUtil.getAttachments(ctx, resumeId));
        this.setInterviewDetailResumeSelfDescribeInfo(ctx, resume, resumeId);
        this.setInterviewDetailResumeWorkExpInfo(ctx, resume, resumeId);
        this.setInterviewDetailResumeProExpInfo(ctx, resume, resumeId);
        this.setInterviewDetailResumeEduExpInfo(ctx, resume, resumeId);
        taskItem.setResumeInfo(resume);
    }

    private void setInterviewDetailResumeSelfDescribeInfo(Context ctx, ResumeInfo resume, String resumeId) throws BOSException {
        SelfEvaluationRecInfo selfInfo = null;
        SelfEvaluationRecCollection coll = SelfEvaluationRecFactory.getLocalInstance(ctx).getSelfEvaluationRecCollection("where resumeBaseRec = '" + resumeId + "'");
        if (coll.size() > 0) {
            selfInfo = coll.get(0);
        }
        if (selfInfo != null) {
            resume.setSelfDescribe(selfInfo.getSelfDescription() == null ? "" : selfInfo.getSelfDescription());
        }
    }

    private void setInterviewDetailResumeWorkExpInfo(Context ctx, ResumeInfo resume, String resumeId) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("resumeBase", (Object)resumeId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("company"));
        evi.getSelector().add(new SelectorItemInfo("industry"));
        evi.getSelector().add(new SelectorItemInfo("enterpriseNature.id"));
        evi.getSelector().add(new SelectorItemInfo("enterpriseNature.name"));
        evi.getSelector().add(new SelectorItemInfo("totalStaffStr"));
        evi.getSelector().add(new SelectorItemInfo("dateStart"));
        evi.getSelector().add(new SelectorItemInfo("dateEnd"));
        evi.getSelector().add(new SelectorItemInfo("position"));
        evi.getSelector().add(new SelectorItemInfo("monthPayStr"));
        evi.getSelector().add(new SelectorItemInfo("jobDescription"));
        SorterItemInfo sortInfo = new SorterItemInfo("dateStart");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        WorkingExpCollection workColl = WorkingExpFactory.getLocalInstance(ctx).getWorkingExpCollection(evi);
        ArrayList<WorkExp> workExps = new ArrayList<WorkExp>();
        if (!RecDBUtils.isEmpty((IObjectCollection)workColl)) {
            WorkingExpInfo workExpInfo = null;
            WorkExp work = null;
            Iterator iter = workColl.iterator();
            while (iter.hasNext()) {
                workExpInfo = (WorkingExpInfo)iter.next();
                work = new WorkExp();
                work.setCompany(workExpInfo.getCompany() == null ? "" : workExpInfo.getCompany());
                work.setIndustry(workExpInfo.getIndustry() == null ? "" : workExpInfo.getIndustry());
                work.setNature(workExpInfo.getEnterpriseNature() == null ? "" : workExpInfo.getEnterpriseNature().getName());
                work.setScale(workExpInfo.getTotalStaffStr() == null ? "" : workExpInfo.getTotalStaffStr());
                if (workExpInfo.getDateStart() != null) {
                    work.setStartTime(sdf.format(workExpInfo.getDateStart()));
                } else {
                    work.setStartTime("");
                }
                if (workExpInfo.getDateEnd() != null) {
                    work.setEndTime(sdf.format(workExpInfo.getDateEnd()));
                } else {
                    work.setEndTime("\u81f3\u4eca");
                }
                work.setPosition(workExpInfo.getPosition() == null ? "" : workExpInfo.getPosition());
                work.setSalary(workExpInfo.getMonthPayStr() == null ? "" : workExpInfo.getMonthPayStr());
                work.setJobDuty(workExpInfo.getJobDescription() == null ? "" : workExpInfo.getJobDescription());
                workExps.add(work);
            }
        }
        resume.setWorkExp(workExps);
    }

    private void setInterviewDetailResumeProExpInfo(Context ctx, ResumeInfo resume, String resumeId) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ProjectExpCollection proColl = ProjectExpFactory.getLocalInstance(ctx).getProjectExpCollection("where resumeBase = '" + resumeId + "' order by dateStart desc");
        ArrayList<ProExp> workExps = new ArrayList<ProExp>();
        if (!RecDBUtils.isEmpty((IObjectCollection)proColl)) {
            ProjectExpInfo proInfo = null;
            ProExp proExp = null;
            Iterator iter = proColl.iterator();
            while (iter.hasNext()) {
                proInfo = (ProjectExpInfo)iter.next();
                proExp = new ProExp();
                proExp.setProName(proInfo.getCustomer() == null ? "" : proInfo.getCustomer());
                if (proInfo.getDateStart() != null) {
                    proExp.setStartTime(sdf.format(proInfo.getDateStart()));
                } else {
                    proExp.setStartTime("");
                }
                if (proInfo.getDateEnd() != null) {
                    proExp.setEndTime(sdf.format(proInfo.getDateEnd()));
                } else {
                    proExp.setEndTime("\u81f3\u4eca");
                }
                proExp.setMainDuty(proInfo.getMainDuty() == null ? "" : proInfo.getMainDuty());
                proExp.setProDescribe(proInfo.getPdescription() == null ? "" : proInfo.getPdescription());
                workExps.add(proExp);
            }
        }
        resume.setProExp(workExps);
    }

    private void setInterviewDetailResumeEduExpInfo(Context ctx, ResumeInfo resume, String resumeId) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("resumeBase", (Object)resumeId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("school"));
        evi.getSelector().add(new SelectorItemInfo("degreeF7.id"));
        evi.getSelector().add(new SelectorItemInfo("degreeF7.name"));
        evi.getSelector().add(new SelectorItemInfo("major"));
        evi.getSelector().add(new SelectorItemInfo("majorDescription"));
        evi.getSelector().add(new SelectorItemInfo("dateStart"));
        evi.getSelector().add(new SelectorItemInfo("dateEnd"));
        SorterItemInfo sortInfo = new SorterItemInfo("dateStart");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        EducationExpRECCollection eduColl = EducationExpRECFactory.getLocalInstance(ctx).getEducationExpRECCollection(evi);
        ArrayList<EduExp> eduExps = new ArrayList<EduExp>();
        if (!RecDBUtils.isEmpty((IObjectCollection)eduColl)) {
            EducationExpRECInfo expInfo = null;
            EduExp eduExp = null;
            Iterator iter = eduColl.iterator();
            while (iter.hasNext()) {
                expInfo = (EducationExpRECInfo)iter.next();
                eduExp = new EduExp();
                eduExp.setSchool(expInfo.getSchool() == null ? "" : expInfo.getSchool());
                eduExp.setDgree(expInfo.getDegreeF7() == null ? "" : expInfo.getDegreeF7().getName());
                eduExp.setMajor(expInfo.getMajor() == null ? "" : expInfo.getMajor());
                eduExp.setMajorDescribe(expInfo.getMajorDescription() == null ? "" : expInfo.getMajorDescription());
                if (expInfo.getDateStart() != null) {
                    eduExp.setStartTime(sdf.format(expInfo.getDateStart()));
                }
                if (expInfo.getDateEnd() != null) {
                    eduExp.setEndTime(sdf.format(expInfo.getDateEnd()));
                } else {
                    eduExp.setEndTime("\u81f3\u4eca");
                }
                eduExps.add(eduExp);
            }
        }
        resume.setEduExp(eduExps);
    }

    private User[] getDeparmentPrincipal(Context ctx, String departmentId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)departmentId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("parent"));
        evi.getSelector().add(new SelectorItemInfo("responPosition"));
        AdminOrgUnitCollection aouColl = null;
        try {
            aouColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        ArrayList<User> users = new ArrayList<User>();
        if (!RecDBUtils.isEmpty((IObjectCollection)aouColl)) {
            AdminOrgUnitInfo admin = aouColl.get(0);
            if (admin.getResponPosition() != null) {
                String currentDate = HRUtilExtend.getCurrentDate();
                StringBuffer sql = new StringBuffer("select org.FAdminOrgID,org.fpersonid,person.fname_l2 from T_HR_EmpOrgRelation org left join T_BD_Person person on person.fid = org.fpersonid ").append("left JOIN T_HR_EmpLaborRelation ER ON (person.FID = ER.FPERSONID ) ").append("left JOIN T_HR_BDEmployeeType BT ON (ER.FLABORRELATIONSTATEID = BT.FID) ").append(" where (BT.FIsInCount = 1  or BT.FIsOnTheStrength = 1) ").append(" and org.fisInner=1").append(" and org.feffdt<=").append(currentDate).append(" and org.fleffdt>=").append(currentDate).append(" and org.fAssignType=1 ").append(" and org.FPositionID ='").append(admin.getResponPosition().getId().toString()).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (rs.next()) {
                        if (StringUtils.isEmpty((CharSequence)rs.getString(1))) continue;
                        String personId = rs.getString(2);
                        users.add(new User(personId, RecOsfUtil.getOpenIDByPersonID(ctx, personId), rs.getString(3)));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else if (admin.getParent() != null) {
                return this.getDeparmentPrincipal(ctx, admin.getParent().getId().toString());
            }
        }
        return users.toArray(new User[0]);
    }

    private File getInterviewDetailFile(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewStructureDetailFileInfo detailFile;
        byte[] data;
        File file = null;
        IPInterviewStructureDetailFileCollection coll = IPInterviewStructureDetailFileFactory.getLocalInstance(ctx).getIPInterviewStructureDetailFileCollection("where interviewPlanId = '" + interviewPlanId.toString() + "'");
        if (coll != null && coll.size() > 0 && (data = (detailFile = coll.get(0)).getFileCode()) != null && data.length > 0) {
            file = new File();
            BASE64Encoder encoder = new BASE64Encoder();
            file.setFileLink(encoder.encode(data));
            file.setName(detailFile.getFileName());
        }
        return file;
    }

    @Override
    protected InterviewJudgeResult _getInterviewJudgeResult(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        InterviewJudgeResult judgeResult = new InterviewJudgeResult();
        judgeResult.setResumeInfo(this.getInterviewJudgeResumeInfo(ctx, interviewPlanId.toString(), interviewerId.toString()));
        judgeResult.setJudgeInfo(this.getInterviewJudgeInfo(ctx, interviewPlanId.toString(), interviewerId.toString()));
        return judgeResult;
    }

    private ResumeInfo getInterviewJudgeResumeInfo(Context ctx, String interviewPlanId, String interviewerId) throws BOSException {
        ResumeInfo resume = null;
        String sql = "SELECT RB.FID userId, RB.FName name, RB.FGender gender, RB.FRecuritmentDemandID demandId, RB.FID resumeID FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) JOIN T_REC_ResumeBaseRec RB ON (IR.FResumeBaseRecID = RB.FID)where IP.FID = ? ";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            if (rs != null && rs.next()) {
                ResumePhotoInfo resumePhotoInfo;
                byte[] imageData;
                ResumePhotoCollection photocoll;
                resume = new ResumeInfo();
                resume.setUserId(rs.getString("userId"));
                resume.setName(rs.getString("name"));
                resume.setSex(rs.getInt("gender"));
                String demandId = rs.getString("demandId");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)demandId, CompareType.EQUALS));
                evi.setFilter(filter);
                evi.getSelector().add(new SelectorItemInfo("department.id"));
                evi.getSelector().add(new SelectorItemInfo("department.displayName"));
                evi.getSelector().add(new SelectorItemInfo("department.name"));
                evi.getSelector().add(new SelectorItemInfo("recuritPosition.id"));
                evi.getSelector().add(new SelectorItemInfo("recuritPosition.name"));
                evi.getSelector().add(new SelectorItemInfo("hrJob.id"));
                evi.getSelector().add(new SelectorItemInfo("hrJob.name"));
                RecuritmentDemandCollection coll = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
                if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
                    RecuritmentDemandInfo demandInfo = coll.get(0);
                    AdminOrgUnitInfo depInfo = demandInfo.getDepartment();
                    resume.setCompany(depInfo.getDisplayName());
                    resume.setDepartment(depInfo.getName());
                    if (demandInfo.getRecuritPosition() != null && demandInfo.getRecuritPosition().getId() != null) {
                        resume.setPosition(demandInfo.getRecuritPosition().getName());
                    } else {
                        resume.setPosition(demandInfo.getHrJob().getName());
                    }
                } else {
                    throw new BOSException("\u83b7\u53d6\u62db\u8058\u9700\u6c42\u5931\u8d25\uff01ipId:" + interviewPlanId + ",interviewerId" + interviewerId);
                }
                String resumeID = rs.getString("resumeID");
                if (!StringUtils.isEmpty((CharSequence)resumeID) && (photocoll = ResumePhotoFactory.getLocalInstance(ctx).getResumePhotoCollection(" where resumeBaseRec='" + resumeID + "'")) != null && photocoll.size() > 0 && (imageData = (resumePhotoInfo = photocoll.get(0)).getImageData()) != null && imageData.length > 0) {
                    BASE64Encoder encoder = new BASE64Encoder();
                    String photo = encoder.encode(imageData);
                    resume.setPhoto(photo);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return resume;
    }

    private InterviewJudgeResultInfo getInterviewJudgeInfo(Context ctx, String interviewPlanId, String interviewerId) throws BOSException {
        InterviewJudgeResultInfo judgeInfo = new InterviewJudgeResultInfo();
        try {
            IPInterviewStructureDetailDiathesisCollection ddColl;
            IPInterviewStructureDetailWriteCollection dwColl;
            IPInterviewStructureDetailEvaluateCollection deColl;
            ObjectBaseInfo info;
            int i;
            IPInterviewStructureDetailResultCollection drColl;
            Map<String, String> map = this.checkElementOperator(ctx, interviewPlanId);
            ArrayList<InterviewStructureData> interviewStructureData = new ArrayList<InterviewStructureData>();
            if (!StringUtils.equals((CharSequence)map.get("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form"), (CharSequence)"0") && !RecDBUtils.isEmpty((IObjectCollection)(drColl = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection(" where interviewPlanId = '" + interviewPlanId + "' and interviewerId='" + interviewerId + "'")))) {
                for (i = 0; i < drColl.size(); ++i) {
                    if (drColl.get(i).getSaveState() != 0) continue;
                    info = drColl.get(i);
                    interviewStructureData.add(this.doSetInterResult(ctx, (IPInterviewStructureDetailResultInfo)info));
                    judgeInfo.setBillId(info.getId().toString());
                    judgeInfo.setAttachs(this.getBoAttachments(ctx, drColl.get(i).getId().toString(), judgeInfo));
                }
            }
            if (!StringUtils.equals((CharSequence)map.get("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate.form"), (CharSequence)"0") && !RecDBUtils.isEmpty((IObjectCollection)(deColl = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).getIPInterviewStructureDetailEvaluateCollection("where interviewPlanId = '" + interviewPlanId + "' and interviewerId = '" + interviewerId + "'")))) {
                for (i = 0; i < deColl.size(); ++i) {
                    if (deColl.get(i).getSaveState() != 0) continue;
                    info = deColl.get(i);
                    interviewStructureData.add(this.doSetInterForm((IPInterviewStructureDetailEvaluateInfo)info));
                    judgeInfo.setAttachs(this.getBoAttachments(ctx, deColl.get(i).getId().toString(), judgeInfo));
                }
            }
            if (!StringUtils.equals((CharSequence)map.get("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite.form"), (CharSequence)"0") && !RecDBUtils.isEmpty((IObjectCollection)(dwColl = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx).getIPInterviewStructureDetailWriteCollection("where interviewPlanId = '" + interviewPlanId + "'")))) {
                IPInterviewStructureDetailWriteInfo info2 = dwColl.get(0);
                interviewStructureData.add(this.doSetWriteExam(info2));
            }
            if (!StringUtils.equals((CharSequence)map.get("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis.form"), (CharSequence)"0") && !RecDBUtils.isEmpty((IObjectCollection)(ddColl = IPInterviewStructureDetailDiathesisFactory.getLocalInstance(ctx).getIPInterviewStructureDetailDiathesisCollection("where interviewPlanId = '" + interviewPlanId + "'")))) {
                IPInterviewStructureDetailDiathesisInfo info3 = ddColl.get(0);
                interviewStructureData.add(this.doSetQualityEvaluation(info3));
            }
            judgeInfo.setInterviewStructureData(interviewStructureData);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return judgeInfo;
    }

    private File[] getBoAttachments(Context ctx, String billId, InterviewJudgeResultInfo judgeInfo) {
        ArrayList<File> files = new ArrayList<File>();
        if (null != judgeInfo.getAttachs()) {
            files.addAll(Arrays.asList(judgeInfo.getAttachs()));
        }
        try {
            StringBuilder querySql = new StringBuilder();
            querySql.append("SELECT ATTACH.FID attachId,ATTACH.FNAME_l2 attachName,ATTACH.FSIMPLENAME attachType,ATTACH.FSizeInByte attachSize ").append(" FROM T_BAS_BoAttchAsso AS BOATTCH ").append(" LEFT JOIN T_BAS_Attachment AS ATTACH ON ATTACH.FID  = BOATTCH.FATTACHMENTID ").append(" where BOATTCH.FBOID = '").append(billId).append("' and ATTACH.FID is not null ").append(" order by ATTACH.FCREATETIME ASC ");
            ArrayList attachmentList = new ArrayList();
            HashMap<String, String> tmpMap = null;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                if (rs != null) {
                    while (rs.next()) {
                        String extname = rs.getString("attachType");
                        if (StringUtils.isEmpty((CharSequence)extname)) continue;
                        tmpMap = new HashMap<String, String>();
                        tmpMap.put("attachId", rs.getString("attachId"));
                        tmpMap.put("attachSize", rs.getString("attachSize"));
                        tmpMap.put("attachName", rs.getString("attachName") + "." + extname);
                        tmpMap.put("attachType", extname);
                        attachmentList.add(tmpMap);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)("--------------->get attachment error\uff1a" + e.getMessage()));
            }
            BASE64Encoder encoder = new BASE64Encoder();
            IAttachmentManagerFacade iAttachmentFtpFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            for (Map map : attachmentList) {
                File file = new File();
                file.setName((String)map.get("attachName"));
                file.setFileExt((String)map.get("attachType"));
                String attachId = (String)map.get("attachId");
                byte[] content = iAttachmentFtpFacade.downLoad(attachId);
                if (content.length < 1) {
                    content = iAttachmentFtpFacade.downLoad(attachId);
                }
                if (content.length < 1) continue;
                file.setFileId(attachId);
                file.setFileLink(encoder.encode(content));
                file.setFileSize((String)map.get("attachSize"));
                file.setFileDownLoadUrl(AttachmentUtil.downImage(ctx, attachId, MD5Util.getMD5String((String)file.getName()) + "." + file.getFileExt()));
                files.add(file);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return files.toArray(new File[0]);
    }

    private File[] getAttachments(Context ctx, String billId, InterviewJudgeResultInfo judgeInfo) {
        ArrayList<File> files = new ArrayList<File>();
        if (null != judgeInfo.getAttachs()) {
            files.addAll(Arrays.asList(judgeInfo.getAttachs()));
        }
        try {
            StringBuilder querySql = new StringBuilder();
            querySql.append("SELECT ATTACH.FID attachId,ATTACH.FNAME_l2 attachName,ATTACH.FSIMPLENAME attachType ").append(" FROM T_HR_SHRAttachmentExt AS BOATTCH ").append(" LEFT JOIN T_BAS_Attachment AS ATTACH ON ATTACH.FID  = BOATTCH.FATTACHMENT ").append(" where BOATTCH.FBOID = '").append(billId).append("' and ATTACH.FID is not null ").append(" order by ATTACH.FCREATETIME ASC ");
            ArrayList attachmentList = new ArrayList();
            HashMap<String, String> tmpMap = null;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                if (rs != null) {
                    while (rs.next()) {
                        String extname = rs.getString("attachType");
                        if (StringUtils.isEmpty((CharSequence)extname)) continue;
                        tmpMap = new HashMap<String, String>();
                        tmpMap.put("attachId", rs.getString("attachId"));
                        tmpMap.put("attachName", rs.getString("attachName") + "." + extname);
                        attachmentList.add(tmpMap);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)("--------------->get attachment error\uff1a" + e.getMessage()));
            }
            BASE64Encoder encoder = new BASE64Encoder();
            IAttachmentManagerFacade iAttachmentFtpFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            for (Map map : attachmentList) {
                File file = new File();
                file.setName((String)map.get("attachName"));
                String attachId = (String)map.get("attachId");
                byte[] content = iAttachmentFtpFacade.downLoad(attachId);
                if (content.length < 1) {
                    content = iAttachmentFtpFacade.downLoad(attachId);
                }
                if (content.length < 1) continue;
                file.setFileLink(encoder.encode(content));
                files.add(file);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return files.toArray(new File[0]);
    }

    @Override
    protected InterviewJudgeResult _getToBeJudgedRecordInfo(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        InterviewJudgeResult judgeResult = new InterviewJudgeResult();
        ArrayList<InterviewStructureData> interviewStructureData = new ArrayList<InterviewStructureData>();
        InterviewPlanCollection ipColl = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select *,lastUpdateUser.person.name,interview.currInterviewStage.interviewStageName,interview.currInterviewStage.order,interview.currInterviewStage.inviteStatus where id = '" + interviewPlanId + "'");
        if (!RecDBUtils.isEmpty((IObjectCollection)ipColl)) {
            InterviewPlanInfo ipInfo = ipColl.get(0);
            judgeResult.setRecordId(ipInfo.getId().toString());
            judgeResult.setInterStatus(ipInfo.getInterviewStageName());
            InterviewPlanInfo curIpInfo = ipInfo.getInterview().getCurrInterviewStage();
            if (curIpInfo != null && curIpInfo.getOrder() < ipInfo.getOrder() && (curIpInfo.getInviteStatus().getValue() == "4" || curIpInfo.getInviteStatus().getValue() == "7" || curIpInfo.getInviteStatus().getValue() == "8")) {
                judgeResult.setState("error");
                judgeResult.setInterStatus("\u5f53\u524d\u5019\u9009\u4eba\u5df2\u5728" + curIpInfo.getInterviewStageName() + "\u73af\u8282\u9762\u8bd5\u4e2d" + curIpInfo.getInviteStatus().getAlias() + "\uff01");
                return judgeResult;
            }
        } else {
            throw new BOSException("\u83b7\u53d6\u9762\u8bd5\u5b89\u6392\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Map<String, String> map = this.checkElementOperator1(ctx, interviewPlanId.toString());
        logger.error((Object)("\u6240\u6709\u7684\u9762\u8bd5\u5143\u7d20" + map));
        InterviewJudgeResultInfo interviewResult = new InterviewJudgeResultInfo();
        String billId = "";
        UIViewInfo detailResultUiView = RecUIViewUtil.getUIViewFromDB(ctx, "com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form");
        boolean hasAttach = RecUIViewUtil.hasAttch(detailResultUiView);
        List<FieldInfo> detailFields = RecUIViewUtil.getFields(ctx, detailResultUiView);
        if (detailFields.isEmpty()) {
            logger.error((Object)"analysis UIview com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form error ,no field found");
        } else {
            List<String> fieldNames = RecUIViewUtil.getFieldNames(detailFields);
            IPInterviewStructureDetailResultCollection deColl = null;
            if (fieldNames != null) {
                if (!fieldNames.contains("result")) {
                    fieldNames.add("result");
                }
                if (!fieldNames.contains("interviewPlanId")) {
                    fieldNames.add("interviewPlanId");
                }
                if (!fieldNames.contains("saveState")) {
                    fieldNames.add("saveState");
                }
                deColl = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("select " + Joiner.on((String)",").join(fieldNames) + " where interviewPlanId = '" + interviewPlanId + "' and interviewerId = '" + interviewerId + "' ");
            } else {
                deColl = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId + "' and interviewerId = '" + interviewerId + "' ");
            }
            if (!RecDBUtils.isEmpty((IObjectCollection)deColl)) {
                Map<String, ColumnInfo> colLengthMap = RecMetaUtil.getFieldMap(ctx, deColl.get(0).getBOSType());
                for (int i = 0; i < deColl.size(); ++i) {
                    InterviewStructureData structureData;
                    IPInterviewStructureDetailResultInfo info = deColl.get(i);
                    billId = billId + info.getId().toString() + ",";
                    String result = info.getResult();
                    if (info.getSaveState() != 0 || !map.containsKey("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form") || (structureData = InterGOUtil.doSetInterResult(ctx, info, detailFields, colLengthMap, map.get("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form"))) == null) continue;
                    structureData.setHasAttach(hasAttach);
                    if (hasAttach) {
                        structureData.setAttachs(AttachmentUtil.getAttachments(ctx, info.getId().toString()));
                    }
                    interviewStructureData.add(structureData);
                }
            } else {
                judgeResult.setState("error");
                judgeResult.setInterStatus("\u60a8\u5df2\u88ab" + ipColl.get(0).getLastUpdateUser().getPerson().getName() + "\u53d6\u6d88\u9762\u8bd5\uff01");
                return judgeResult;
            }
        }
        if (billId != "") {
            billId = billId.substring(0, billId.length() - 1);
        }
        interviewResult.setBillId(billId);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CoreBaseInfo coreBaseInfo;
            List<InterviewStructureData> structureData;
            List<FieldInfo> groups;
            String uipk = entry.getKey();
            if (uipk.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form")) continue;
            String eleName = entry.getValue();
            UIViewInfo uiViewInfo = RecUIViewUtil.getUIViewFromDB(ctx, entry.getKey());
            if (uiViewInfo == null) {
                logger.error((Object)("_getToBeJudgedRecordInfo analysis UIView " + uipk + " \u65e0\u5bf9\u5e94\u7684\u89c6\u56fe"));
                continue;
            }
            logger.error((Object)("_getToBeJudgedRecordInfo analysis UIView " + uipk));
            boolean hasAttch = RecUIViewUtil.hasAttch(uiViewInfo);
            List<FieldInfo> fields = RecUIViewUtil.getFields(ctx, uiViewInfo);
            if (fields.isEmpty()) {
                logger.error((Object)("_getToBeJudgedRecordInfo analysis UIView " + uipk + "error ,no field found"));
                continue;
            }
            List<String> fieldNames = RecUIViewUtil.getFieldNames(fields);
            String model = uiViewInfo.getModel();
            CoreBaseCollection coreBaseCollection = null;
            ICoreBase iCoreBase = MetaDataUtil.getBizInterface((Context)ctx, (String)model);
            if (!CollectionUtils.isEmpty(fields)) {
                if (!fieldNames.contains("interviewPlanId")) {
                    fieldNames.add("interviewPlanId");
                }
                if (!fieldNames.contains("saveState")) {
                    fieldNames.add("saveState");
                }
                coreBaseCollection = !model.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite") && !model.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis") ? iCoreBase.getCollection("select " + Joiner.on((String)",").join(fieldNames) + " where interviewPlanId = '" + interviewPlanId + "' and interviewerId = '" + interviewerId + "' ") : iCoreBase.getCollection("select " + Joiner.on((String)",").join(fieldNames) + " where interviewPlanId = '" + interviewPlanId + "' ");
            } else {
                coreBaseCollection = iCoreBase.getCollection("where  interviewPlanId = '" + interviewPlanId + "' and interviewerId = '" + interviewerId + "' ");
            }
            if (coreBaseCollection == null || coreBaseCollection.size() == 0) {
                logger.error((Object)"\u65e0\u5bf9\u5e94\u7684\u9762\u8bd5\u7ed3\u679c\u5143\u7d20");
                continue;
            }
            Map<String, ColumnInfo> columnInfoMap = RecMetaUtil.getFieldMap(ctx, coreBaseCollection.get(0).getBOSType());
            if (model.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate") && coreBaseCollection.size() > 0) {
                groups = RecUIViewUtil.getGroups(ctx, uiViewInfo);
                Integer countScoreValue = RecUIViewUtil.getCountScore(uiViewInfo);
                structureData = InterGOUtil.doSetInterForm(ctx, coreBaseCollection, fields, columnInfoMap, groups, countScoreValue);
            } else if (model.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite") && coreBaseCollection.size() > 0) {
                coreBaseInfo = coreBaseCollection.get(0);
                structureData = InterGOUtil.doSetWriteExam(ctx, coreBaseInfo, fields, columnInfoMap);
            } else if (model.equalsIgnoreCase("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis") && coreBaseCollection.size() > 0) {
                coreBaseInfo = coreBaseCollection.get(0);
                structureData = InterGOUtil.doSetQualityEvaluation(ctx, coreBaseInfo, fields, columnInfoMap);
            } else {
                groups = RecUIViewUtil.getGroups(ctx, uiViewInfo);
                structureData = InterGOUtil.doSetOther(ctx, coreBaseCollection, fields, columnInfoMap, groups, uiViewInfo);
            }
            if (CollectionUtils.isEmpty(structureData)) continue;
            interviewStructureData.addAll(structureData);
            for (InterviewStructureData data : structureData) {
                data.setStruName(eleName);
                data.setHasAttach(hasAttch);
                data.setUipk(uipk);
                if (!hasAttch) continue;
                data.setAttachs(AttachmentUtil.getAttachments(ctx, data.getBillid()));
            }
        }
        interviewResult.setInterviewStructureData(interviewStructureData);
        judgeResult.setJudgeInfo(interviewResult);
        judgeResult.setResumeInfo(this.getInterviewJudgeResumeInfo(ctx, interviewPlanId.toString(), interviewerId.toString()));
        return judgeResult;
    }

    @Override
    protected String _saveInterviewResultDetail(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId, Object interviewResultDetail) throws BOSException {
        try {
            Map diathesisData;
            Map writeData;
            String res;
            Map interviewerData;
            com.alibaba.fastjson.JSONObject interviewResultDetailJson = JSON.parseObject((String)((String)interviewResultDetail));
            if (logger.isDebugEnabled()) {
                logger.error((Object)("interviewResultDetailJson:" + interviewResultDetailJson));
            }
            if (!this.isEmpty(interviewerData = (Map)interviewResultDetailJson.get((Object)"interviewer")) && StringUtils.isNotEmpty((CharSequence)(res = this.processInterviewerResult(ctx, interviewPlanId, interviewerId, interviewerData)))) {
                return res;
            }
            this.evaluateData = (Map)interviewResultDetailJson.get((Object)"evaluate");
            if (!this.isEmpty(this.evaluateData)) {
                this.saveEvaluateResult(ctx, this.evaluateData);
            }
            if (!this.isEmpty(writeData = (Map)interviewResultDetailJson.get((Object)"write"))) {
                this.saveWriteResult(ctx, writeData);
            }
            if (!this.isEmpty(diathesisData = (Map)interviewResultDetailJson.get((Object)"diathesis"))) {
                this.saveDiatheasisResult(ctx, diathesisData);
            }
            this.updateInterviewPlanResult(ctx, interviewPlanId);
            for (Map.Entry entry : interviewResultDetailJson.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("diathesis") || key.equalsIgnoreCase("write") || key.equalsIgnoreCase("evaluate") || key.equalsIgnoreCase("interviewer")) continue;
                this.processCustomElement(ctx, entry);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void processCustomElement(Context ctx, Map.Entry<String, Object> entryJson) throws BOSException, EASBizException {
        String model = entryJson.getKey();
        logger.error((Object)("saveCustomElement " + model));
        Map data = (Map)entryJson.getValue();
        String billId = (String)data.get("billid");
        logger.error((Object)("saveCustomElement " + billId));
        MetaDataPK toMetaPk = MetaDataPK.create((String)model);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)toMetaPk);
        CoreBaseCollection collection = iCoreBase.getCollection("where id = '" + billId + "'");
        if (collection.size() > 0) {
            CoreBaseInfo info = collection.get(0);
            Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, info);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                this.processData2Db(entry, propertyMap, info);
            }
            iCoreBase.save(info);
        }
    }

    private void saveDiatheasisResult(Context ctx, Map<String, Object> diathesisData) throws BOSException, EASBizException {
        String billId = (String)diathesisData.get("billid");
        logger.error((Object)("saveDiatheasisResult  " + billId));
        IIPInterviewStructureDetailDiathesis iipInterviewStructureDetailDiathesis = IPInterviewStructureDetailDiathesisFactory.getLocalInstance(ctx);
        IPInterviewStructureDetailDiathesisCollection coll = iipInterviewStructureDetailDiathesis.getIPInterviewStructureDetailDiathesisCollection("where id = '" + billId + "'");
        if (coll.size() > 0) {
            IPInterviewStructureDetailDiathesisInfo info = coll.get(0);
            Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, (CoreBaseInfo)info);
            for (Map.Entry<String, Object> entry : diathesisData.entrySet()) {
                this.processData2Db(entry, propertyMap, (CoreBaseInfo)info);
            }
            iipInterviewStructureDetailDiathesis.save((CoreBaseInfo)info);
        }
    }

    private void saveWriteResult(Context ctx, Map<String, Object> writeData) throws BOSException, EASBizException {
        String billId = (String)writeData.get("billid");
        logger.error((Object)("saveWriteResult " + billId));
        IIPInterviewStructureDetailWrite iipInterviewStructureDetailWrite = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx);
        IPInterviewStructureDetailWriteCollection coll = iipInterviewStructureDetailWrite.getIPInterviewStructureDetailWriteCollection("where id = '" + billId + "'");
        if (coll.size() > 0) {
            IPInterviewStructureDetailWriteInfo info = coll.get(0);
            Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, (CoreBaseInfo)info);
            for (Map.Entry<String, Object> entry : writeData.entrySet()) {
                this.processData2Db(entry, propertyMap, (CoreBaseInfo)info);
            }
            iipInterviewStructureDetailWrite.save((CoreBaseInfo)info);
        }
    }

    private void saveEvaluateResult(Context ctx, Map<String, Object> evaluateData) throws BOSException, EASBizException {
        String billId = (String)evaluateData.get("billid");
        logger.error((Object)("saveEvaluateResult " + billId));
        IIPInterviewStructureDetailEvaluate iipInterviewStructureDetailEvaluate = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx);
        IPInterviewStructureDetailEvaluateCollection coll = iipInterviewStructureDetailEvaluate.getIPInterviewStructureDetailEvaluateCollection("where id='" + billId + "'");
        if (coll.size() > 0) {
            IPInterviewStructureDetailEvaluateInfo info = coll.get(0);
            Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, (CoreBaseInfo)info);
            for (Map.Entry<String, Object> entry : evaluateData.entrySet()) {
                this.processData2Db(entry, propertyMap, (CoreBaseInfo)info);
            }
            iipInterviewStructureDetailEvaluate.save((CoreBaseInfo)info);
        }
    }

    private String processInterviewerResult(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId, Map<String, Object> interviewerData) throws BOSException, EASBizException {
        String billId = (String)interviewerData.get("billid");
        logger.error((Object)("processInterviewerResult " + billId));
        IIPInterviewStructureDetailResult iIPInterviewStructureDetailResult = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx);
        IPInterviewStructureDetailResultCollection coll = iIPInterviewStructureDetailResult.getIPInterviewStructureDetailResultCollection("where id='" + billId + "'");
        if (coll.size() == 0) {
            return "\u65e0\u5bf9\u5e94\u7684\u9762\u8bd5\u7ed3\u679c\u8bb0\u5f55";
        }
        IPInterviewStructureDetailResultInfo info = coll.get(0);
        if (info.getSaveState() == 0 && ("3".equals(info.getResult()) || "4".equals(info.getResult()) || "5".equals(info.getResult()))) {
            return "\u60a8\u5df2\u7ecf\u53cd\u9988\u8fc7\u7ed3\u679c\uff01";
        }
        Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, (CoreBaseInfo)info);
        String result = "-1";
        if (!this.isEmpty(interviewerData.get("sureResult"))) {
            result = String.valueOf(interviewerData.get("sureResult"));
        }
        info.setResult(result);
        info.setEntryResultTime(new Date());
        for (Map.Entry<String, Object> entry : interviewerData.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("sureResult")) continue;
            this.processData2Db(entry, propertyMap, (CoreBaseInfo)info);
        }
        iIPInterviewStructureDetailResult.save((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        if (!"".equals(result) && !"-1".equals(result)) {
            SendInterviewMsgService.getInstance().sendInterviewResult(ctx, interviewPlanId.toString(), interviewerId.toString());
        }
        return "";
    }

    private void processData2Db(Map.Entry<String, Object> entry, Map<String, PropertyInfo> propertyMap, CoreBaseInfo info) {
        Object value = entry.getValue();
        if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
            return;
        }
        String fieldName = entry.getKey();
        PropertyInfo propertyInfo = propertyMap.get(fieldName);
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            DataType dataType = ownPropertyInfo.getDataType();
            String dataTypeName = dataType.getName();
            if ("String".equalsIgnoreCase(dataTypeName)) {
                String valueStr = value.toString();
                if (StringUtils.isEmpty((CharSequence)valueStr)) {
                    return;
                }
            } else if (dataTypeName.equalsIgnoreCase("Date")) {
                String valueStr = value.toString();
                logger.error((Object)fieldName);
                logger.error((Object)valueStr);
                try {
                    SimpleDateFormat sdf = null;
                    sdf = valueStr.length() == 5 ? new SimpleDateFormat("HH:mm") : (valueStr.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : (valueStr.length() == 16 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd")));
                    value = sdf.parse(valueStr);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)"\u8f6c\u5316\u65e5\u671f\u53c2\u6570\u51fa\u9519\uff1a", (Throwable)e);
                    value = null;
                }
                catch (NullPointerException e) {
                    logger.error((Object)"\u8f6c\u5316\u65e5\u671f\u53c2\u6570\u51fa\u9519\uff1a", (Throwable)e);
                    value = null;
                }
                catch (ParseException e) {
                    logger.error((Object)"\u8f6c\u5316\u65e5\u671f\u51fa\u9519\uff1a", (Throwable)e);
                    value = null;
                }
            }
        }
        if (value != null) {
            logger.error((Object)("set " + fieldName + ",value " + value));
            info.put(fieldName, value);
        }
    }

    private double doSetDouble(String name) {
        return Double.parseDouble(this.isEmpty(this.evaluateData.get(name)) ? "0" : (String)this.evaluateData.get(name));
    }

    private void _saveAttachment(Context ctx, String boID, AttachmentCollection attachments) {
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentInfo attachmentInfo = attachments.get(i);
            try {
                IObjectPK attchId = AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachmentInfo);
                attachmentInfo.setId(BOSUuid.read((String)attchId.toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
            attchExt.setAttachment(attachmentInfo);
            attchExt.setName(attachmentInfo.getName());
            attchExt.setPropertyName("null0");
            attchExt.setType(AttachmentTypeEnum.FORM);
            attchExt.setState(AttachmentState.SAVE);
            attchExt.setBoID(boID);
            try {
                SHRAttachmentExtFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)attchExt);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateInterviewPlanResult(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT IPR.FHRWriteResult,IPR.FID,IP.FInterviewID,IP.FLastLink,IP.FOrder FROM T_REC_InterviewPlan IP left join T_REC_InterviewPlanResult IPR on IP.FID = IPR.FInterviewPlanId   WHERE IP.FID = ? ";
        boolean hrWriteResult = false;
        String interviewPlanResultId = "";
        String interviewResultId = "";
        boolean lastLink = false;
        int order = 0;
        IRowSet rs = null;
        try {
            int maxOrder;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            if (rs != null && rs.next()) {
                hrWriteResult = rs.getBoolean("FHRWriteResult");
                interviewPlanResultId = rs.getString("FID");
                interviewResultId = rs.getString("FInterviewID");
                lastLink = rs.getBoolean("FLastLink");
                order = rs.getInt("FOrder");
            }
            if (!lastLink && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT max(FOrder) max FROM T_REC_INTERVIEWPLAN where FINTERVIEWID = ? "), (Object[])new Object[]{interviewResultId})) != null && rs.next() && order == (maxOrder = rs.getInt("max"))) {
                lastLink = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)interviewPlanResultId)) {
            throw new BOSException(interviewPlanId + "\u67e5\u627e\u4e0d\u5230\u9762\u8bd5\u7ed3\u679c\u6570\u636e\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (!lastLink) {
            String interviewResult = "";
            String score = "";
            IIPInterviewStructureDetailResult iIPInterviewStructureDetailResult = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx);
            IPInterviewStructureDetailResultCollection coll = iIPInterviewStructureDetailResult.getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId.toString() + "'");
            int size = coll.size();
            if (size == 0) {
                interviewResult = "-1";
            } else if (size == 1) {
                interviewResult = InterviewResultStatusEnum.getEnum(coll.get(0).getResult()).getValue();
                score = coll.get(0).getScore();
            } else {
                interviewResult = coll.get(0).getResult();
                Pattern pattern = NUMBER_PATTERN;
                double totalScore = 0.0;
                boolean IsNum = true;
                for (int i = 0; i < size; ++i) {
                    IPInterviewStructureDetailResultInfo ipDetail = coll.get(i);
                    if (!interviewResult.equals(ipDetail.getResult())) {
                        interviewResult = "2";
                    }
                    if (null != ipDetail.getScore()) {
                        if (IsNum && pattern.matcher(ipDetail.getScore()).matches()) {
                            totalScore += Double.parseDouble(ipDetail.getScore());
                            continue;
                        }
                        IsNum = false;
                        continue;
                    }
                    IsNum = false;
                }
                if (IsNum) {
                    score = String.valueOf(totalScore / (double)size);
                }
            }
            sql = "UPDATE T_REC_InterviewPlanResult SET FResult=? , FInterviewScore = ? WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewResult, score, interviewPlanResultId});
            SendInterviewMsgService.getInstance().sendInterviewPlanResult(ctx, interviewPlanId.toString(), interviewResult);
            this._changeInterviewInviteStatus(ctx, interviewPlanId, interviewResult);
        } else {
            SendInterviewMsgService.getInstance().sendFinalInterviewPlanResult(ctx, interviewPlanId.toString());
        }
    }

    @Override
    protected String _addInterviewer(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        IPInterviewStructureDetailResultCollection interviewers = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId ='" + interviewPlanId + "' and interviewerId = '" + interviewerId + "'");
        if (interviewers.size() > 0) {
            return "\u60a8\u5df2\u7ecf\u662f\u8be5\u5019\u9009\u4eba\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u52ff\u91cd\u590d\u63a5\u6536\uff01";
        }
        IPInterviewersInfo interviewer = new IPInterviewersInfo();
        PersonInfo person = null;
        try {
            person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(interviewerId);
            if (person == null) {
                throw new BOSException("\u67e5\u627e\u4e0d\u5230ID\u4e3a" + interviewerId + "\u6dfb\u52a0\u7684\u9762\u8bd5\u5b98\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            interviewer.setInterviewerId(person.getId().toString());
            interviewer.setInterviewerName(person.getName());
            interviewer.setInterviewerEmail(person.getEmail());
            interviewer.setInterviewerCell(person.getCell());
            interviewer.setIsInviteAdd(false);
            interviewer.setInterviewPlanId(interviewPlanId.toString());
            IPInterviewersFactory.getLocalInstance(ctx).addnew(interviewer);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (interviewPlanId != null) {
            InterviewPlanResultInfo resultInfo = null;
            InterviewPlanResultCollection planResultColl = InterviewPlanResultFactory.getLocalInstance(ctx).getInterviewPlanResultCollection("where interviewPlanId = '" + interviewPlanId.toString() + "'");
            if (!RecDBUtils.isEmpty((IObjectCollection)planResultColl)) {
                resultInfo = planResultColl.get(0);
            }
            if (resultInfo != null) {
                IIPInterviewStructure iStru = IPInterviewStructureFactory.getLocalInstance(ctx);
                IPInterviewStructureCollection struColl = iStru.getIPInterviewStructureCollection("where basicData.id = 'iQsAAAABa8hLEul5' and interviewPlanId = '" + interviewPlanId + "'");
                if (!RecDBUtils.isEmpty((IObjectCollection)struColl)) {
                    this.doAddInitIPInterviewStructureDetailResult(ctx, interviewer, struColl.get(0));
                }
                if (!RecDBUtils.isEmpty((IObjectCollection)(struColl = iStru.getIPInterviewStructureCollection("where basicData.id = 'iQsAAAABZ4VLEul5' and interviewPlanId = '" + interviewPlanId + "'")))) {
                    this.doAddInitIPInterviewStructureDetailEvaluate(ctx, interviewer, struColl.get(0));
                }
            }
            SendInterviewMsgService.getInstance().sendInterviewPlanByHR(ctx, interviewPlanId.toString(), new String[]{interviewerId.toString()});
            TimeHelperService.getInstance().updateInterviewPlanByHR(ctx, interviewPlanId.toString());
        }
        return null;
    }

    private void doAddInitIPInterviewStructureDetailResult(Context ctx, IPInterviewersInfo interInfo, IPInterviewStructureInfo struInfo) throws BOSException {
        String creatorId = BOSUuid.read((String)ctx.getCaller().toString()).toString();
        java.sql.Date createTime = new java.sql.Date(System.currentTimeMillis());
        String lastUpdateUserId = creatorId;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        if (!this.checkHasThisInterviewer(ctx, "T_REC_IPISDetailResult", struInfo.getInterviewPlanId(), interInfo.getInterviewerId())) {
            paramsList.add(new Object[]{BOSUuid.create((BOSObjectType)new IPInterviewStructureDetailResultInfo().getBOSType()).toString(), struInfo.getId().toString(), interInfo.getInterviewerId(), interInfo.getInterviewerName(), "-1", null, null, struInfo.getFileName(), struInfo.getFileCode(), struInfo.getInterviewPlanId(), creatorId, createTime, lastUpdateUserId, cuId});
        }
        if (!paramsList.isEmpty()) {
            String sql = "INSERT INTO T_REC_IPISDetailResult(FID,FIpIsId,FInterviewerId,FInterviewerName,FResult,FJobGradeId,FRemark,FileName,FileCode,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FControlUnitID) VALUES(" + RecDBUtils.getParamPlaceholder("FID,FIpIsId,FInterviewerId,FInterviewerName,FResult,FJobGradeId,FRemark,FileName,FileCode,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FControlUnitID") + ")";
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
    }

    private boolean checkHasThisInterviewer(Context ctx, String table, String interviewPlanId, String interviewerId) throws BOSException {
        String sql = "SELECT FID FROM " + table + " WHERE FInterviewPlanId = ? AND FInterviewerId = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId, interviewerId});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return datas == null || !datas.isEmpty();
    }

    private void doAddInitIPInterviewStructureDetailEvaluate(Context ctx, IPInterviewersInfo interInfo, IPInterviewStructureInfo struInfo) throws BOSException {
        String creatorId = BOSUuid.read((String)ctx.getCaller().toString()).toString();
        java.sql.Date createTime = new java.sql.Date(System.currentTimeMillis());
        String lastUpdateUserId = creatorId;
        java.sql.Date lastUpdateTime = createTime;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        if (!this.checkHasThisInterviewer(ctx, "T_REC_IPISDetailEvaluate", struInfo.getInterviewPlanId(), interInfo.getInterviewerId())) {
            paramsList.add(new Object[]{BOSUuid.create((BOSObjectType)new IPInterviewStructureDetailEvaluateInfo().getBOSType()).toString(), struInfo.getId().toString(), interInfo.getInterviewerId(), interInfo.getInterviewerName(), null, null, struInfo.getFileName(), struInfo.getFileCode(), struInfo.getInterviewPlanId(), creatorId, createTime, lastUpdateUserId, lastUpdateTime, cuId});
        }
        if (!paramsList.isEmpty()) {
            String sql = "INSERT INTO T_REC_IPISDetailEvaluate(FID,FIpIsId,FInterviewerId,FInterviewerName,FResult,FRemark,FileName,FileCode,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) VALUES (" + RecDBUtils.getParamPlaceholder("FID,FIpIsId,FInterviewerId,FInterviewerName,FResult,FRemark,FileName,FileCode,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID") + ")";
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
    }

    @Override
    protected Object _getUserInterAnalysisData(Context ctx, IObjectPK interviewerId, String InterviewYear) throws BOSException {
        InterAnalysisData interAnalysisData = new InterAnalysisData();
        int totalInterCount = this.getTotalInterCount(ctx, interviewerId, InterviewYear);
        interAnalysisData.setInterviewCount(totalInterCount);
        int interPassCount = this.getInterPassCount(ctx, interviewerId, InterviewYear);
        interAnalysisData.setInterPassCount(interPassCount);
        int entryCount = this.getEntryCount(ctx, interviewerId, InterviewYear);
        interAnalysisData.setEntryCount(entryCount);
        int workingCount = this.getWorkingCount(ctx, interviewerId, InterviewYear);
        interAnalysisData.setWorkingCount(workingCount);
        int leavingCount = this.getLeavingCount(ctx, interviewerId, InterviewYear);
        interAnalysisData.setLeavingCount(leavingCount);
        double averageAge = this.getAverageAge(ctx, interviewerId, InterviewYear);
        interAnalysisData.setAverageAge(averageAge);
        double averageWorkingAge = this.getAverageWorkingAge(ctx, interviewerId, InterviewYear);
        if (entryCount != 0) {
            averageWorkingAge /= (double)entryCount;
        }
        interAnalysisData.setAverageWorkingAge(averageWorkingAge);
        return interAnalysisData;
    }

    private int getTotalInterCount(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql_01 = "SELECT COUNT(DISTINCT IR.FRESUMEBASERECID) AS COUNT FROM T_REC_InterviewResult IR LEFT JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID) WHERE DR.FInterviewerId = ? AND DR.FSAVESTATE = 0 ";
        Object[] param_01 = new Object[]{interviewerId.toString()};
        int totalInterCount = 0;
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            param_01 = new Object[]{interviewerId.toString(), InterviewYear};
            sql_01 = sql_01 + " AND year(FInterviewTime) = ? ";
        }
        try {
            totalInterCount = this.getExecuteCount(ctx, sql_01, param_01);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return totalInterCount;
    }

    private int getInterPassCount(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql = "SELECT COUNT(DISTINCT IR.FRESUMEBASERECID) AS COUNT FROM T_REC_InterviewResult IR LEFT JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) LEFT JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID) WHERE DR.FInterviewerId = ? AND IR.FRESULT = 1";
        Object[] param_01 = new Object[]{interviewerId.toString()};
        int interPassCount = 0;
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            param_01 = new Object[]{interviewerId.toString(), InterviewYear};
            sql = sql + " AND year(FInterviewTime) = ? ";
        }
        try {
            interPassCount = this.getExecuteCount(ctx, sql, param_01);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return interPassCount;
    }

    private int getEntryCount(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql = "SELECT COUNT(DISTINCT RB.FID) AS COUNT FROM T_REC_ResumeBaseRec RB left JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) left JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) left JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID AND DR.FSAVESTATE = 0 ) WHERE DR.FINTERVIEWERID = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA='";
        Object[] param_01 = new Object[]{interviewerId.toString()};
        int entryCount = 0;
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            param_01 = new Object[]{interviewerId.toString(), InterviewYear};
            sql = sql + " AND year(FInterviewTime) = ? ";
        }
        try {
            entryCount = this.getExecuteCount(ctx, sql, param_01);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return entryCount;
    }

    private int getWorkingCount(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql;
        String idcardsql;
        Object[] param_01 = new Object[]{};
        int workingCount = 0;
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            idcardsql = "SELECT DISTINCT RB.FIDENTITYCARDNO  AS IDCARDNO FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND year(FInterviewTime) = ?  AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FIDENTITYCARDNO is not null AND RB.FIDENTITYCARDNO <> ''";
            Object[] idcardparam = new Object[]{interviewerId.toString(), InterviewYear};
            String idcardsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            idcardsql = "SELECT DISTINCT RB.FPASSPORTNO  AS PASSPORTNO  FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND year(FInterviewTime) = ?  AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FPASSPORTNO is not null AND RB.FPASSPORTNO <> ''";
            String passportsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            sql = "SELECT COUNT(DISTINCT P.FID) AS COUNT FROM  T_BD_Person as P JOIN T_HR_EmpLaborRelation ER ON (P.FID = ER.FPERSONID )JOIN T_HR_BDEmployeeType BT ON (ER.FLABORRELATIONSTATEID = BT.FID)WHERE  (BT.FIsInCount = 1  or BT.FIsOnTheStrength = 1) AND (P.FIDCARDNO IN (" + idcardsqlIds + ") OR P.FPASSPORTNO IN (" + passportsqlIds + "))";
        } else {
            idcardsql = "SELECT DISTINCT RB.FIDENTITYCARDNO  AS IDCARDNO FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FIDENTITYCARDNO is not null AND RB.FIDENTITYCARDNO <> ''";
            Object[] idcardparam = new Object[]{interviewerId.toString()};
            String idcardsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            idcardsql = "SELECT DISTINCT RB.FPASSPORTNO  AS PASSPORTNO  FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FPASSPORTNO is not null AND RB.FPASSPORTNO <> ''";
            String passportsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            sql = "SELECT COUNT(DISTINCT P.FID) AS COUNT FROM  T_BD_Person as P JOIN T_HR_EmpLaborRelation ER ON (P.FID = ER.FPERSONID )JOIN T_HR_BDEmployeeType BT ON (ER.FLABORRELATIONSTATEID = BT.FID)WHERE  (BT.FIsInCount = 1 or BT.FIsOnTheStrength = 1) AND (P.FIDCARDNO IN (" + idcardsqlIds + ") OR P.FPASSPORTNO IN (" + passportsqlIds + "))";
        }
        try {
            workingCount = this.getExecuteCount(ctx, sql, param_01);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return workingCount;
    }

    private int getLeavingCount(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql;
        String idcardsql;
        Object[] param_01 = new Object[]{};
        int leavingCount = 0;
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            idcardsql = "SELECT DISTINCT RB.FIDENTITYCARDNO  AS IDCARDNO FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND year(FInterviewTime) = ?  AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FIDENTITYCARDNO is not null AND RB.FIDENTITYCARDNO <> ''";
            Object[] idcardparam = new Object[]{interviewerId.toString(), InterviewYear};
            String idcardsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            idcardsql = "SELECT DISTINCT RB.FPASSPORTNO  AS PASSPORTNO  FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND year(FInterviewTime) = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FPASSPORTNO is not null AND RB.FPASSPORTNO <> ''";
            String passportsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            sql = "SELECT COUNT(DISTINCT P.FID) AS COUNT FROM  T_BD_Person as P JOIN T_HR_EmpLaborRelation ER ON (P.FID = ER.FPERSONID )JOIN T_HR_BDEmployeeType BT ON (ER.FLABORRELATIONSTATEID = BT.FID)WHERE  BT.FIsInCount = 0  and BT.FIsOnTheStrength = 0 AND (P.FIDCARDNO IN (" + idcardsqlIds + ") OR P.FPASSPORTNO IN (" + passportsqlIds + "))";
        } else {
            idcardsql = "SELECT DISTINCT RB.FIDENTITYCARDNO  AS IDCARDNO FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FIDENTITYCARDNO is not null AND RB.FIDENTITYCARDNO <> ''";
            Object[] idcardparam = new Object[]{interviewerId.toString()};
            String idcardsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            idcardsql = "SELECT DISTINCT RB.FPASSPORTNO  AS PASSPORTNO  FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA=' AND RB.FPASSPORTNO is not null AND RB.FPASSPORTNO <> ''";
            String passportsqlIds = this.getSqlIds(ctx, idcardparam, idcardsql);
            sql = "SELECT COUNT(DISTINCT P.FID) AS COUNT FROM  T_BD_Person as P JOIN T_HR_EmpLaborRelation ER ON (P.FID = ER.FPERSONID )JOIN T_HR_BDEmployeeType BT ON (ER.FLABORRELATIONSTATEID = BT.FID)WHERE  BT.FIsInCount = 0  and BT.FIsOnTheStrength = 0 AND (P.FIDCARDNO IN (" + idcardsqlIds + ") OR P.FPASSPORTNO IN (" + passportsqlIds + "))";
        }
        try {
            leavingCount = this.getExecuteCount(ctx, sql, param_01);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return leavingCount;
    }

    public String getSqlIds(Context ctx, Object[] params, String sql) {
        String rowIds = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs != null) {
                StringBuilder ids = new StringBuilder();
                while (rs.next()) {
                    String value = rs.getString(1);
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    ids.append("'").append(value).append("'").append(",");
                }
                if (!StringUtils.isEmpty((CharSequence)ids.toString())) {
                    rowIds = ids.substring(0, ids.length() - 1).toString();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAverageAge(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql = "SELECT AVG(RB.FAGE) AS AGE FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID ) WHERE DR.FINTERVIEWERID = ? AND RB.FAGE is not null AND RB.FAGE  <> ''AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA='";
        Object[] param_01 = new Object[]{interviewerId.toString()};
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            param_01 = new Object[]{interviewerId.toString(), InterviewYear};
            sql = sql + " AND year(FInterviewTime) = ? ";
        }
        double averageAge = 0.0;
        IRowSet rs = null;
        try {
            long current = System.currentTimeMillis();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param_01);
            if (rs != null && rs.next()) {
                averageAge = rs.getDouble("AGE");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u9762\u8bd5\u8fc7\u5165\u804c\u5458\u5de5\u5e73\u5747\u5e74\u9f84\u6267\u884c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - current)));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return averageAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAverageWorkingAge(Context ctx, IObjectPK interviewerId, String InterviewYear) {
        String sql = "SELECT RB.FWORKSENIORITY FROM T_REC_ResumeBaseRec RB JOIN T_REC_InterviewResult IR ON (IR.FResumeBaseRecID = RB.FID) JOIN T_REC_InterviewPlan IP ON (IP.FINTERVIEWID = IR.FID) JOIN T_REC_IPISDetailResult DR ON (DR.FINTERVIEWPLANID = IP.FID )WHERE DR.FINTERVIEWERID = ? AND RB.FWORKSENIORITY is not null AND RB.FWORKSENIORITY  <> '' AND RB.FRESUMESTATEID = '5LLB5TwtSAaxBn7MZvEtyQhd7oA='";
        Object[] param_01 = new Object[]{interviewerId.toString()};
        if (!StringUtils.isEmpty((CharSequence)InterviewYear)) {
            param_01 = new Object[]{interviewerId.toString(), InterviewYear};
            sql = sql + " AND year(FInterviewTime) = ? ";
        }
        double averageWorkingAge = 0.0;
        IRowSet rs = null;
        try {
            String workSeniority;
            long current = System.currentTimeMillis();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param_01);
            if (rs != null && rs.next() && number.matcher(workSeniority = rs.getString("FWORKSENIORITY")).matches()) {
                averageWorkingAge += Double.valueOf(workSeniority).doubleValue();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u9762\u8bd5\u8fc7\u5165\u804c\u5458\u5de5\u5e73\u5747\u5de5\u9f84\u6267\u884c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - current)));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return averageWorkingAge;
    }

    @Override
    protected String _deleteInterviewer(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        if (interviewerId != null && !"".equals(interviewerId)) {
            IPInterviewStructureDetailResultCollection interviewers = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId ='" + interviewPlanId.toString() + "' and interviewerId = '" + interviewerId.toString() + "'");
            if (interviewers.size() == 0) {
                return "\u60a8\u5df2\u7ecf\u53d6\u6d88\u8be5\u9762\u8bd5\u5b98\u7684\u9762\u8bd5\uff0c\u8bf7\u52ff\u91cd\u590d\u53d6\u6d88\uff01";
            }
            String sql = "DELETE FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ? AND FInterviewerId = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString(), interviewerId.toString()});
            if (interviewPlanId != null) {
                InterviewPlanResultInfo interviewPlanResult;
                InterviewPlanResultInfo result = null;
                InterviewPlanResultCollection planResultColl = InterviewPlanResultFactory.getLocalInstance(ctx).getInterviewPlanResultCollection("where interviewPlanId = '" + interviewPlanId.toString() + "'");
                if (!RecDBUtils.isEmpty((IObjectCollection)planResultColl)) {
                    result = planResultColl.get(0);
                }
                String sql_01 = "DELETE FROM T_REC_IPISDetailResult WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
                DbUtil.execute((Context)ctx, (String)sql_01, (Object[])new Object[]{interviewerId.toString(), interviewPlanId.toString()});
                if (result != null && !(interviewPlanResult = result).isHrWriteResult()) {
                    IIPInterviewStructureDetailResult iIPInterviewStructureDetailResult = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx);
                    IPInterviewStructureDetailResultCollection coll = iIPInterviewStructureDetailResult.getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId + "'");
                    int size = coll.size();
                    if (size == 0) {
                        interviewPlanResult.setResult(InterviewResultStatusEnum.NULL);
                        interviewPlanResult.setInterviewScore("");
                    } else if (size == 1) {
                        interviewPlanResult.setResult(InterviewResultStatusEnum.getEnum(coll.get(0).getResult()));
                        interviewPlanResult.setInterviewScore(coll.get(0).getScore());
                    } else {
                        String interviewResult = coll.get(0).getResult();
                        Pattern pattern = NUMBER_PATTERN;
                        double totalScore = 0.0;
                        boolean IsNum = true;
                        for (int i = 0; i < size; ++i) {
                            IPInterviewStructureDetailResultInfo ipDetail = coll.get(i);
                            if (!interviewResult.equals(ipDetail.getResult())) {
                                interviewResult = "2";
                            }
                            if (null != ipDetail.getScore()) {
                                if (IsNum && pattern.matcher(ipDetail.getScore()).matches()) {
                                    totalScore += Double.parseDouble(ipDetail.getScore());
                                    continue;
                                }
                                IsNum = false;
                                continue;
                            }
                            IsNum = false;
                        }
                        if (IsNum) {
                            interviewPlanResult.setInterviewScore(String.valueOf(totalScore / (double)size));
                        }
                        interviewPlanResult.setResult(InterviewResultStatusEnum.getEnum(interviewResult));
                    }
                    try {
                        InterviewPlanResultFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(interviewPlanResult.getId().toString()), interviewPlanResult);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                    this._changeInterviewInviteStatus(ctx, interviewPlanId, interviewPlanResult.getResult().getValue());
                }
                String sql_02 = "DELETE FROM T_REC_IPISDetailEvaluate WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
                DbUtil.execute((Context)ctx, (String)sql_02, (Object[])new Object[]{interviewPlanId.toString(), interviewerId.toString()});
            }
        }
        return null;
    }

    private String analyzeInterviewPlanResultStatus(String resultStatus) {
        if ("2".equals(resultStatus)) {
            return "5";
        }
        if ("3".equals(resultStatus)) {
            return "6";
        }
        if ("4".equals(resultStatus)) {
            return "4";
        }
        if ("5".equals(resultStatus)) {
            return "7";
        }
        if ("6".equals(resultStatus)) {
            return "8";
        }
        return null;
    }

    private void _changeInterviewInviteStatus(Context ctx, IObjectPK interviewPlanId, String interviewResult) throws BOSException {
        String newStatus = this.analyzeInterviewPlanResultStatus(interviewResult);
        String sql = "";
        Object[] params = null;
        if ("2".equals(newStatus) || "4".equals(newStatus)) {
            sql = "UPDATE T_REC_InterviewPlan SET FInviteStatus = ?,FInviteUserID = ?,FInviteTime = ? WHERE FID = ?";
            params = new Object[]{newStatus, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), RecDBUtils.getNowDate(), interviewPlanId.toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        } else if (null != newStatus) {
            sql = "UPDATE T_REC_InterviewPlan SET FInviteStatus = ? WHERE FID = ?";
            params = new Object[]{newStatus, interviewPlanId.toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        this.changeInterviewResultStatus(ctx, interviewPlanId.toString(), interviewResult);
    }

    private void changeInterviewResultStatus(Context ctx, String interviewPlanId, String interviewResult) throws BOSException {
        String resumeState = null;
        int newInterviewResult = 0;
        int TransactionState = 1;
        String sql = "";
        Object[] param = null;
        if ("5".equals(interviewResult)) {
            resumeState = "VU+5LvArSJyl0JxzMmXECghd7oA=";
            newInterviewResult = 2;
            TransactionState = 2;
        } else if ("6".equals(interviewResult)) {
            resumeState = "/pIxPc8hTNGJcfL1aWx2jQhd7oA=";
            newInterviewResult = 2;
            TransactionState = 2;
        } else if ("4".equals(interviewResult)) {
            resumeState = "MO4K2yScT5CDrQEDdKCXUwhd7oA=";
            newInterviewResult = 2;
            TransactionState = 2;
        } else {
            resumeState = "nBqJPlDqTtu5U+jhPfGoWAhd7oA=";
        }
        if (newInterviewResult != 0) {
            sql = "UPDATE T_REC_InterviewResult SET FResult = ? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
            param = new Object[]{newInterviewResult, interviewPlanId};
            try {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        sql = "UPDATE T_REC_ResumeBaseRec SET FResumeStateID = ?,FTransactionState = ? WHERE FID = (SELECT FResumeBaseRecID FROM T_REC_InterviewResult WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?))";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{resumeState, TransactionState, interviewPlanId});
        if (TransactionState == 2) {
            RecSyncTaskThreadPool.getInstance().submitAsyncTask(new VideoInterviewRunnable(ctx, new String[]{interviewPlanId}, "deleteMeeting"));
        }
    }

    private int getExecuteCount(Context ctx, String sql, Object[] param) throws BOSException {
        int totalInterCount = 0;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            if (rs != null && rs.next()) {
                totalInterCount = rs.getInt("COUNT");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return totalInterCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _getInterviewProcess(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        ArrayList<InterviewProcess> interviewProcess = new ArrayList<InterviewProcess>();
        InterviewProcess interProcess = null;
        ArrayList<InterviewProcessResult> interviewerResults = null;
        InterviewProcessResult interviewerResult = null;
        String currInterviewStageId = "";
        String curInterviewplanId = "";
        int curOrder = 0;
        String interviewStagePower = "";
        int interviewOrder = 0;
        try {
            InterviewPlanInfo curInterviewPlan = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanInfo("SELECT order,interviewStagePower,interview.currInterviewStage.order WHERE ID = '" + interviewPlanId.toString() + "'");
            curOrder = curInterviewPlan.getOrder();
            interviewStagePower = curInterviewPlan.getInterviewStagePower();
            curInterviewplanId = curInterviewPlan.getId().toString();
            if (curInterviewPlan.getInterview() != null && curInterviewPlan.getInterview().getCurrInterviewStage() != null) {
                currInterviewStageId = curInterviewPlan.getInterview().getCurrInterviewStage().getId().toString();
                interviewOrder = curInterviewPlan.getInterview().getCurrInterviewStage().getOrder();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sql = "SELECT IP.FID ,IP.FORDER,IP.FINTERVIEWSTAGENAME,IP.FINTERVIEWSTAGEPOWER,IPR.FHRWRITERESULT,IPR.FRESULT ,IPR.FREMARK  FROM T_REC_INTERVIEWPLAN IP LEFT OUTER JOIN T_REC_INTERVIEWPLANRESULT IPR ON IP.FID  = IPR.FINTERVIEWPLANID  WHERE IP.FINTERVIEWID IN (SELECT FINTERVIEWID  FROM T_REC_INTERVIEWPLAN WHERE FID = ? ) ORDER BY IP.FORDER";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            while (rs != null && rs.next()) {
                interProcess = new InterviewProcess();
                interProcess.setRecordId(rs.getString("FID"));
                interProcess.setProcessName(rs.getString("FINTERVIEWSTAGENAME"));
                interProcess.setProcessState(this.analyzeInterviewProcessResultStatus(rs.getString("FRESULT")));
                interProcess.setOrder(rs.getInt("FORDER"));
                interviewerResults = new ArrayList<InterviewProcessResult>();
                interviewerResult = new InterviewProcessResult();
                interviewerResult.setInterviewerName("HR\u786e\u8ba4\u7ed3\u679c");
                interviewerResult.setResult(this.analyzeHrResultStatus(rs.getString("FRESULT")));
                interviewerResult.setRemark(rs.getString("FREMARK"));
                interviewerResults.add(interviewerResult);
                interProcess.setInterviewerResult(interviewerResults);
                interviewProcess.add(interProcess);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!interviewProcess.isEmpty()) {
            for (int i = 0; i < interviewProcess.size(); ++i) {
                InterviewProcess process = (InterviewProcess)interviewProcess.get(i);
                if (currInterviewStageId.equals(process.getRecordId()) && "\u5f85\u9762\u8bd5".equals(process.getProcessState())) {
                    process.setProcessState("\u9762\u8bd5\u4e2d");
                    if (curInterviewplanId.equals(process.getRecordId())) {
                        process.setInterviewerResult(null);
                        continue;
                    }
                }
                if ("1".equals(interviewStagePower)) {
                    if (curOrder >= process.getOrder()) {
                        this.getAllInterviewResult(ctx, process);
                        continue;
                    }
                    process.setInterviewerResult(null);
                    process.setInfo("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5f53\u524d\u9762\u8bd5\u73af\u8282\uff01");
                    continue;
                }
                if ("2".equals(interviewStagePower)) {
                    if (curOrder == process.getOrder()) {
                        this.getAllInterviewResult(ctx, process);
                        continue;
                    }
                    process.setInterviewerResult(null);
                    process.setInfo("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5f53\u524d\u9762\u8bd5\u73af\u8282\uff01");
                    continue;
                }
                this.getAllInterviewResult(ctx, process);
            }
        }
        return interviewProcess.toArray(new InterviewProcess[0]);
    }

    private void getAllInterviewResult(Context ctx, InterviewProcess process) throws BOSException {
        List<InterviewProcessResult> interviewerResults = process.getInterviewerResult();
        if (interviewerResults == null) {
            return;
        }
        IPInterviewStructureDetailResultCollection coll = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("WHERE interviewPlanId = '" + process.getRecordId() + "' and saveState = 1");
        IPInterviewStructureDetailResultInfo iPInterviewStructureDetailResultInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            iPInterviewStructureDetailResultInfo = coll.get(i);
            InterviewProcessResult interviewerResult = new InterviewProcessResult();
            interviewerResult.setInterviewerName(iPInterviewStructureDetailResultInfo.getInterviewerName());
            interviewerResult.setResult(this.analyzeInterviewerResultStatus(iPInterviewStructureDetailResultInfo.getResult()));
            interviewerResult.setRemark(iPInterviewStructureDetailResultInfo.getRemark());
            interviewerResults.add(interviewerResult);
        }
    }

    private String analyzeInterviewProcessResultStatus(String resultStatus) {
        if ("-1".equals(resultStatus)) {
            return InterviewResultStatusEnum.START.getAlias();
        }
        if ("3".equals(resultStatus)) {
            return InterviewResultStatusEnum.PASS.getAlias();
        }
        if ("4".equals(resultStatus)) {
            return InterviewResultStatusEnum.REFUSE.getAlias();
        }
        if ("5".equals(resultStatus)) {
            return InterviewResultStatusEnum.REFUSE.getAlias();
        }
        if ("6".equals(resultStatus)) {
            return InterviewResultStatusEnum.REFUSE.getAlias();
        }
        return "\u9762\u8bd5\u4e2d";
    }

    private String analyzeHrResultStatus(String resultStatus) {
        if ("2".equals(resultStatus)) {
            return InterviewResultStatusEnum.WAIT.getAlias();
        }
        if ("3".equals(resultStatus)) {
            return InterviewResultStatusEnum.PASS.getAlias();
        }
        if ("4".equals(resultStatus)) {
            return InterviewResultStatusEnum.REFUSE.getAlias();
        }
        if ("5".equals(resultStatus)) {
            return InterviewResultStatusEnum.QUIT.getAlias();
        }
        if ("6".equals(resultStatus)) {
            return InterviewResultStatusEnum.END.getAlias();
        }
        return null;
    }

    private String analyzeInterviewerResultStatus(String resultStatus) {
        if ("-1".equals(resultStatus)) {
            return InterviewResultStatusEnum.RESULT.getAlias();
        }
        if ("3".equals(resultStatus)) {
            return InterviewResultStatusEnum.PASS.getAlias();
        }
        if ("4".equals(resultStatus)) {
            return InterviewResultStatusEnum.REFUSE.getAlias();
        }
        if ("5".equals(resultStatus)) {
            return InterviewResultStatusEnum.QUIT.getAlias();
        }
        return null;
    }

    private InterviewStructureData doSetQualityEvaluation(IPInterviewStructureDetailDiathesisInfo info) {
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        HashMap map = new HashMap();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new InterviewStructureElement(info.getResult(), "result", "\u6d4b\u8bc4\u7ed3\u679c", 2000, "LongText", false, false));
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("diathesis");
        interviewStructureData.setStruName("\u7d20\u8d28\u6d4b\u8bc4");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        return interviewStructureData;
    }

    private InterviewStructureData doSetWriteExam(IPInterviewStructureDetailWriteInfo info) {
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new InterviewStructureElement(info.getScore(), "score", "\u7b14\u8bd5\u7ed3\u679c", 255, "Text", false, false));
        list.add(new InterviewStructureElement(info.getResult(), "result", "\u5907\u6ce8", 2000, "LongText", false, false));
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("write");
        interviewStructureData.setStruName("\u7b14\u8bd5");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        return interviewStructureData;
    }

    private InterviewStructureData doSetInterResult(Context ctx, IPInterviewStructureDetailResultInfo info) {
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new InterviewStructureElement(info.getInterviewerName(), "interviewerName", "\u9762\u8bd5\u5b98", 255, "Text", true, false));
        InterviewStructureElement elementResult = new InterviewStructureElement(info.getResult(), "result", "\u786e\u8ba4\u7ed3\u679c", null, "Select", false, true);
        HashMap<String, Object> hashMapResult = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult1 = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult3 = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult4 = new HashMap<String, Object>();
        hashMapResult.put("key", -1);
        hashMapResult.put("value", "");
        hashMapResult1.put("key", 2);
        hashMapResult1.put("value", "\u5f85\u5b9a");
        hashMapResult2.put("key", 3);
        hashMapResult2.put("value", "\u901a\u8fc7");
        hashMapResult3.put("key", 4);
        hashMapResult3.put("value", "\u4e0d\u901a\u8fc7");
        hashMapResult4.put("key", 5);
        hashMapResult4.put("value", "\u653e\u5f03\u9762\u8bd5");
        ArrayList<Object> arrayListResult = new ArrayList<Object>();
        arrayListResult.add(hashMapResult);
        arrayListResult.add(hashMapResult1);
        arrayListResult.add(hashMapResult2);
        arrayListResult.add(hashMapResult3);
        arrayListResult.add(hashMapResult4);
        elementResult.setOptions(arrayListResult);
        list.add(elementResult);
        list.add(new InterviewStructureElement(info.getScore(), "score", "\u9762\u8bd5\u5206\u6570", null, "Number", false, false));
        InterviewStructureElement element = new InterviewStructureElement(info.getJobGrade() == null ? "" : info.getJobGrade().getId(), "jobGrade", "\u804c\u7b49", null, "Select", false, false);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            String hrOrgUnitId;
            String sql = "SELECT FHRORGUNITID  FROM T_rec_resumebaserec a LEFT  JOIN t_rec_interviewResult b on a.FID =b.fresumeBaserecId left join T_REC_InterviewPlan c on b.FID =c.FINTERVIEWID where c.fid ='" + info.getInterviewPlanId() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs != null && rs.next() && !StringUtils.isEmpty((CharSequence)(hrOrgUnitId = rs.getString("FHRORGUNITID")))) {
                JobGradeCollection jobGradeCollection = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection("select id,name where jobGradeModule.hrOrgUnit ='" + hrOrgUnitId + "'and jobGradeModule.state = 1");
                for (int i = 0; i < jobGradeCollection.size(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("key", jobGradeCollection.get(i).getId());
                    hashMap.put("value", jobGradeCollection.get(i).getName());
                    arrayList.add(hashMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        element.setOptions(arrayList);
        element.setId(info.getJobGrade() == null ? "" : String.valueOf(info.getJobGrade().getId()));
        list.add(element);
        list.add(new InterviewStructureElement(info.getRemark(), "remark", "\u9762\u8bd5\u610f\u89c1", 2000, "LongText", false, true));
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("interviewer");
        interviewStructureData.setStruName("\u9762\u8bd5\u7ed3\u679c");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        return interviewStructureData;
    }

    private InterviewStructureData doSetInterForm(IPInterviewStructureDetailEvaluateInfo info) {
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        ArrayList<InterviewStructureGroupData> list = new ArrayList<InterviewStructureGroupData>();
        ArrayList<Object> baseGroup = new ArrayList<Object>();
        baseGroup.add(new InterviewStructureElement(info.getInterviewerName(), "interviewerName", "\u9762\u8bd5\u5b98", 255, "Text", true, false));
        baseGroup.add(new InterviewStructureElement(info.getResult(), "result", "\u8bc4\u4ef7\u7ed3\u679c", 255, "Text", false, false));
        baseGroup.add(new InterviewStructureElement(info.getTotalScore(), "totalScore", "\u5f97\u5206", null, "Number", true, false));
        InterviewStructureElement countScoreElement = new InterviewStructureElement(1, "countScore", "\u5206\u6570\u7edf\u8ba1", null, "Select", true, false);
        HashMap<String, Object> hashMapResult = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult1 = new HashMap<String, Object>();
        hashMapResult.put("key", 0);
        hashMapResult.put("value", "\u8bb0\u603b\u5206");
        hashMapResult1.put("key", 1);
        hashMapResult1.put("value", "\u8bb0\u5e73\u5747\u5206");
        ArrayList<Object> arrayListResult = new ArrayList<Object>();
        arrayListResult.add(hashMapResult);
        arrayListResult.add(hashMapResult1);
        countScoreElement.setOptions(arrayListResult);
        baseGroup.add(countScoreElement);
        baseGroup.add(new InterviewStructureElement(info.getRemark(), "remark", "\u5907\u6ce8", 2000, "LongText", false, false));
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(baseGroup, "base", "");
        ArrayList<Object> skillGroup = new ArrayList<Object>();
        skillGroup.add(new InterviewStructureElement(info.getSkillScore(), "skillScore", "\u603b\u5206", null, "Number", true, false, "totalScore"));
        skillGroup.add(new InterviewStructureElement("30%", "skillPercentage", "\u5360\u6bd4", null, "Text", true, false));
        skillGroup.add(new InterviewStructureElement(info.getSkillproBackground(), "skillproBackground", "\u4e13\u4e1a\u80cc\u666f", null, "Number", false, false, "skillScore"));
        skillGroup.add(new InterviewStructureElement(info.getSkillWorkEx(), "skillWorkEx", "\u5de5\u4f5c\u7ecf\u9a8c", null, "Number", false, false, "skillScore"));
        skillGroup.add(new InterviewStructureElement(info.getSkillLevel(), "skillLevel", "\u4e13\u4e1a\u77e5\u8bc6\u6c34\u5e73", null, "Number", false, false, "skillScore"));
        skillGroup.add(new InterviewStructureElement(info.getSkillPerformance(), "skillPerformance", "\u5de5\u4f5c\u4e1a\u7ee9", null, "Number", false, false, "skillScore"));
        InterviewStructureGroupData skillGroupData = new InterviewStructureGroupData(skillGroup, "skill", "\u4e13\u4e1a\u77e5\u8bc6\u4e0e\u7d20\u517b");
        ArrayList<Object> attainmentGroup = new ArrayList<Object>();
        attainmentGroup.add(new InterviewStructureElement(info.getAttainmentScore(), "attainmentScore", "\u603b\u5206", null, "Number", true, false, "totalScore"));
        attainmentGroup.add(new InterviewStructureElement("30%", "attainmentPercentage", "\u5360\u6bd4", null, "Text", true, false));
        attainmentGroup.add(new InterviewStructureElement(info.getCourtesy(), "courtesy", "\u793c\u8c8c\u793c\u8282", null, "Number", false, false, "attainmentScore"));
        attainmentGroup.add(new InterviewStructureElement(info.getDeportment(), "deportment", "\u4eea\u6001\u4eea\u8868", null, "Number", false, false, "attainmentScore"));
        attainmentGroup.add(new InterviewStructureElement(info.getCommunication(), "communication", "\u6c9f\u901a\u8868\u8fbe", null, "Number", false, false, "attainmentScore"));
        attainmentGroup.add(new InterviewStructureElement(info.getPersonalIntegrity(), "personalIntegrity", "\u4e2a\u4eba\u8bda\u4fe1", null, "Number", false, false, "attainmentScore"));
        InterviewStructureGroupData attainGroupData = new InterviewStructureGroupData(attainmentGroup, "attainment", "\u4e2a\u4eba\u7d20\u517b");
        ArrayList<Object> fullQualityGroup = new ArrayList<Object>();
        fullQualityGroup.add(new InterviewStructureElement(info.getFullQualityScore(), "fullQualityScore", "\u603b\u5206", null, "Number", true, false, "totalScore"));
        fullQualityGroup.add(new InterviewStructureElement("40%", "fullQualityPer", "\u5360\u6bd4", null, "Text", true, false));
        fullQualityGroup.add(new InterviewStructureElement(info.getTeamwork(), "teamwork", "\u56e2\u961f\u610f\u8bc6", null, "Number", false, false, "fullQualityScore"));
        fullQualityGroup.add(new InterviewStructureElement(info.getExecution(), "execution", "\u6267\u884c\u529b", null, "Number", false, false, "fullQualityScore"));
        fullQualityGroup.add(new InterviewStructureElement(info.getLogicalThinking(), "logicalThinking", "\u903b\u8f91\u601d\u7ef4", null, "Number", false, false, "fullQualityScore"));
        fullQualityGroup.add(new InterviewStructureElement(info.getPressureSkill(), "pressureSkill", "\u627f\u538b\u80fd\u529b", null, "Number", false, false, "fullQualityScore"));
        fullQualityGroup.add(new InterviewStructureElement(info.getActive(), "active", "\u79ef\u6781\u4e3b\u52a8", null, "Number", false, false, "fullQualityScore"));
        fullQualityGroup.add(new InterviewStructureElement(info.getCareerPlan(), "careerPlan", "\u804c\u4e1a\u89c4\u5212", null, "Number", false, false, "fullQualityScore"));
        InterviewStructureGroupData fullQualityGroupData = new InterviewStructureGroupData(fullQualityGroup, "fullQuality", "\u7efc\u5408\u7d20\u8d28");
        list.add(baseGroupData);
        list.add(skillGroupData);
        list.add(attainGroupData);
        list.add(fullQualityGroupData);
        interviewStructureData.setGroupData(list);
        interviewStructureData.setStruClass("evaluate");
        interviewStructureData.setStruName("\u9762\u8bd5\u8bc4\u4ef7\u8868");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        return interviewStructureData;
    }

    private Map<String, String> checkElementOperator(Context ctx, String interviewPlanId) {
        HashMap<String, String> map = new HashMap<String, String>();
        IPInterviewStructureCollection coll = null;
        try {
            coll = IPInterviewStructureFactory.getLocalInstance(ctx).getIPInterviewStructureCollection("select name,basicData.elementOperator,basicData.uipk  where basicData.state = 1 and interviewPlanId = '" + interviewPlanId + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null != coll && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                InterviewResultStructureInfo info = coll.get(i).getBasicData();
                String uipk = info.getUipk();
                String name = info.getName();
                ElementOperator elementOperator = info.getElementOperator();
                if (!StringUtils.isNotEmpty((CharSequence)uipk) || null == elementOperator || 1 != info.getState().getValue()) continue;
                map.put(uipk, String.valueOf(elementOperator.getValue()));
            }
        }
        return map;
    }

    private Map<String, String> checkElementOperator1(Context ctx, String interviewPlanId) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        IPInterviewStructureCollection coll = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("interviewPlanId", (Object)interviewPlanId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("basicData.state", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("basicData.elementOperator", (Object)1));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("basicData.uipk"));
            SorterItemCollection sorts = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("order");
            sort.setSortType(SortType.ASCEND);
            sorts.add(sort);
            view.setSorter(sorts);
            coll = IPInterviewStructureFactory.getLocalInstance(ctx).getIPInterviewStructureCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null != coll && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                InterviewResultStructureInfo info = coll.get(i).getBasicData();
                String uipk = info.getUipk();
                String name = coll.get(i).getName();
                map.put(uipk, name);
            }
        }
        return map;
    }

    private boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals("");
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            Object[] object = (Object[])obj;
            if (object.length == 0) {
                return true;
            }
        } else {
            if (obj instanceof Collection) {
                return ((Collection)obj).isEmpty();
            }
            if (obj instanceof CharSequence) {
                return ((CharSequence)obj).length() == 0;
            }
        }
        return false;
    }
}

