/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.IInterviewInviteFile;
import com.kingdee.shr.recuritment.InterviewInviteCollection;
import com.kingdee.shr.recuritment.InterviewInviteEmailFactory;
import com.kingdee.shr.recuritment.InterviewInviteFactory;
import com.kingdee.shr.recuritment.InterviewInviteFileFactory;
import com.kingdee.shr.recuritment.InterviewInviteInfo;
import com.kingdee.shr.recuritment.InterviewInvitePersonEnum;
import com.kingdee.shr.recuritment.InterviewInviteWayEnum;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.InterviewerTypeEnum;
import com.kingdee.shr.recuritment.app.AbstractInterviewInviteControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterviewInviteControllerBean
extends AbstractInterviewInviteControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewInviteControllerBean");
    private static final String FULLFIELD = "FID,FInvitePerson,FInvitePersonName,FInviteWay,FEmail,FEmailModel,FEmailTheme,FEmailContent,FSmsService,FSmsModel,FSmsContent,FCanceled,FInterviewPlanId,FLastUpdateTime,FCreateTime";
    private static final String ALLFIELD = "FID,FInvitePerson,FInvitePersonName,FInviteWay,FEmail,FEmailModel,FEmailTheme,FEmailContent,FSmsService,FSmsModel,FSmsContent,FCanceled,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID";
    private static final String INITFIELD = "FID,FInvitePerson,FCanceled,FInterviewPlanId";
    private static final Object saveLock = new Object();

    @Override
    protected IObjectCollection _getInterviewInviteDatas(Context ctx, String interviewPlanIds) throws BOSException {
        Object[] interviewPlanIdsAry = interviewPlanIds.split(",");
        String sql = "SELECT FID,FInvitePerson,FInvitePersonName,FInviteWay,FEmail,FEmailModel,FEmailTheme,FEmailContent,FSmsService,FSmsModel,FSmsContent,FCanceled,FInterviewPlanId,FLastUpdateTime,FCreateTime FROM T_REC_InterviewInvite WHERE FInterviewPlanId IN (" + RecDBUtils.getParamPlaceholder(interviewPlanIdsAry) + ") ORDER BY FInterviewPlanId,FCreateTime ASC,FInvitePerson ASC";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])interviewPlanIdsAry);
        InterviewInviteCollection coll = null;
        try {
            coll = this.fillInterviewInviteEntity(rs);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    @Override
    protected IObjectCollection _getNormalInterviewInviteDatas(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        InterviewInviteCollection coll = InterviewInviteFactory.getLocalInstance(ctx).getInterviewInviteCollection(" where interviewPlanId='" + interviewPlanId.toString() + "' and (canceled=0 or canceled is null)");
        return coll;
    }

    @Override
    protected IObjectPK _addInitInterviewInvite(Context ctx, IObjectValue interviewInvite) throws BOSException {
        InterviewInviteInfo inviteInfo = (InterviewInviteInfo)interviewInvite;
        String sql = "INSERT INTO T_REC_InterviewInvite(FID,FInvitePerson,FCanceled,FInterviewPlanId) VALUES (" + RecDBUtils.getParamPlaceholder(INITFIELD) + ")";
        String fid = BOSUuid.create((BOSObjectType)inviteInfo.getBOSType()).toString();
        String ipId = inviteInfo.getInterviewPlanId();
        String invitePerson = inviteInfo.getInvitePerson().getValue();
        boolean isCancel = inviteInfo.isCanceled();
        Object[] params = new Object[]{fid, invitePerson, isCancel ? 1 : 0, ipId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        return new ObjectUuidPK(fid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveInterviewInvite(Context ctx, IObjectCollection interviewInvites) throws BOSException {
        String email = null;
        Object object = saveLock;
        synchronized (object) {
            String interviewPlanId = null;
            InterviewInviteCollection invites = (InterviewInviteCollection)interviewInvites;
            CoreBaseCollection dealExistedColls = new CoreBaseCollection();
            String sql = "UPDATE T_REC_InterviewInvite SET FInvitePerson=?,FInvitePersonName=?,FInviteWay=?,FEmail=?,FEmailModel=?,FEmailTheme=?,FEmailContent=?,FSmsService=?,FSmsModel=?,FSmsContent=?,FCanceled=?,FInterviewPlanId=?,FCreateTime=? WHERE FID = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Iterator inviteIter = invites.iterator();
            ArrayList<String> inviteIds = new ArrayList<String>();
            while (inviteIter.hasNext()) {
                InterviewInviteInfo info = (InterviewInviteInfo)inviteIter.next();
                dealExistedColls.addObject((IObjectValue)info);
                String invitePerson = info.getInvitePerson() == null ? null : info.getInvitePerson().getValue();
                String inviteWay = info.getInviteWay() == null ? null : info.getInviteWay().getValue();
                String fid = info.getId() == null ? "" : info.getId().toString();
                interviewPlanId = info.getInterviewPlanId();
                email = info.getEmail();
                Object[] param = new Object[]{invitePerson, info.getInvitePersonName(), inviteWay, email, info.getEmailModel(), info.getEmailTheme(), info.getEmailContent(), info.getSmsService(), info.getSmsModel(), info.getSmsContent(), info.isCanceled(), interviewPlanId, info.getCreateTime(), fid};
                paramsList.add(param);
                if (!this.checkInterviewInviteIsExist(ctx, fid)) {
                    throw new BOSException("*******************************\u9080\u7ea6\u6570\u636e\u4e22\u5931\uff0c\u7591\u4f3c\u64cd\u4f5c\u591a\u4eba\u64cd\u4f5c\u540c\u4e00\u6570\u636e\uff01*****************************");
                }
                inviteIds.add(fid);
            }
            if (this.checkInviteInviteCanSave(ctx, interviewPlanId, inviteIds)) {
                try {
                    InterviewInviteFactory.getLocalInstance(ctx).updateBatchData(dealExistedColls);
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                throw new BOSException("*******************************\u9080\u7ea6\u6570\u636e\u591a\u51fa\uff0c\u7591\u4f3c\u64cd\u4f5c\u591a\u4eba\u64cd\u4f5c\u540c\u4e00\u6570\u636e\uff01*****************************");
            }
            this.saveOperate(ctx, interviewPlanId);
        }
        if (email != null) {
            InterviewInviteEmailFactory.getLocalInstance(ctx).updateCurrentUserEmailSetting(email);
        }
    }

    private boolean checkInviteInviteCanSave(Context ctx, String interviewPlanId, List<String> inviteIds) {
        boolean canSave = false;
        String sql = "SELECT COUNT(1) FROM T_REC_InterviewInvite WHERE FID NOT IN (" + RecDBUtils.getParamPlaceholder(inviteIds.toArray(new String[0])) + ") AND FLastUpdateTime IS NULL AND FCreateTime IS NOT NULL AND FInterviewPlanId = ?";
        String DeleteSql = "DELETE FROM T_REC_InterviewInvite WHERE FID NOT IN (" + RecDBUtils.getParamPlaceholder(inviteIds.toArray(new String[0])) + ") AND FInterviewPlanId = ?";
        inviteIds.add(interviewPlanId);
        try {
            DbUtil.execute((Context)ctx, (String)DeleteSql, (Object[])inviteIds.toArray(new String[0]));
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, inviteIds.toArray(new String[0]));
            if (!RecDBUtils.isEmpty(datas)) {
                int count = -1;
                Object countObj = datas.get(0)[0];
                count = countObj instanceof BigDecimal ? ((BigDecimal)countObj).intValue() : ((Integer)countObj).intValue();
                if (count <= 0) {
                    canSave = true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return canSave;
    }

    private boolean checkInterviewInviteIsExist(Context ctx, String interviewInviteId) {
        String sql = "SELECT COUNT(1) FROM T_REC_InterviewInvite WHERE FID = ?";
        boolean isExist = false;
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewInviteId});
            if (!RecDBUtils.isEmpty(datas)) {
                int count = -1;
                Object countObj = datas.get(0)[0];
                count = countObj instanceof BigDecimal ? ((BigDecimal)countObj).intValue() : ((Integer)countObj).intValue();
                if (count >= 1) {
                    isExist = true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveAndSendInterviewInvite(Context ctx, IObjectCollection interviewInvites, String newStatus) throws BOSException {
        String interviewPlanId = null;
        String email = null;
        Object object = saveLock;
        synchronized (object) {
            InterviewInviteCollection invites = (InterviewInviteCollection)interviewInvites;
            CoreBaseCollection invitesColle = new CoreBaseCollection();
            String sql = "UPDATE T_REC_InterviewInvite SET FInvitePerson=?,FInvitePersonName=?,FInviteWay=?,FEmail=?,FEmailModel=?,FEmailTheme=?,FEmailContent=?,FSmsService=?,FSmsModel=?,FSmsContent=?,FCanceled=?,FInterviewPlanId=?,FCreateTime=?,FLastUpdateTime=?,FsmsId=? WHERE FID = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Iterator inviteIter = invites.iterator();
            ArrayList<String> inviteIds = new ArrayList<String>();
            while (inviteIter.hasNext()) {
                InterviewInviteInfo info = (InterviewInviteInfo)inviteIter.next();
                invitesColle.addObject((IObjectValue)info);
                interviewPlanId = info.getInterviewPlanId();
                String fid = info.getId().toString();
                String invitePerson = info.getInvitePerson() == null ? null : info.getInvitePerson().getValue();
                String inviteWay = info.getInviteWay() == null ? null : info.getInviteWay().getValue();
                email = info.getEmail();
                Object[] param = new Object[]{invitePerson, info.getInvitePersonName(), inviteWay, email, info.getEmailModel(), info.getEmailTheme(), info.getEmailContent(), info.getSmsService(), info.getSmsModel(), info.getSmsContent(), info.isCanceled(), interviewPlanId, info.getCreateTime(), info.getLastUpdateTime(), info.getSmsId(), fid};
                paramsList.add(param);
                if (!this.checkInterviewInviteIsExist(ctx, fid)) {
                    throw new BOSException("*******************************\u9080\u7ea6\u6570\u636e\u4e22\u5931\uff0c\u7591\u4f3c\u64cd\u4f5c\u591a\u4eba\u64cd\u4f5c\u540c\u4e00\u6570\u636e\uff01\uff01*****************************");
                }
                inviteIds.add(fid);
            }
            if (this.checkInviteInviteCanSave(ctx, interviewPlanId, inviteIds)) {
                try {
                    InterviewInviteFactory.getLocalInstance(ctx).updateBatchData(invitesColle);
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                throw new BOSException("*******************************\u9080\u7ea6\u6570\u636e\u591a\u51fa\uff0c\u7591\u4f3c\u64cd\u4f5c\u591a\u4eba\u64cd\u4f5c\u540c\u4e00\u6570\u636e\uff01*****************************");
            }
            InterviewPlanFactory.getLocalInstance(ctx).changeInterviewInviteStatus((IObjectPK)new ObjectUuidPK(interviewPlanId), newStatus);
            this.saveOperate(ctx, interviewPlanId);
        }
        if (email != null) {
            InterviewInviteEmailFactory.getLocalInstance(ctx).updateCurrentUserEmailSetting(email);
        }
    }

    @Override
    protected void _againInvitation(Context ctx, IObjectCollection cancelInterviewInvites, IObjectCollection saveInterviewInvite, String newStatus, IObjectValue interviewInvite) throws BOSException {
        InterviewInviteInfo info = (InterviewInviteInfo)interviewInvite;
        Map changeInviteIdByFile = (Map)info.get("changeInviteIdByFile");
        String sql = "UPDATE T_REC_InterviewInviteFile SET FInterviewInviteId = ? WHERE FInterviewInviteId = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Set set = changeInviteIdByFile.entrySet();
        for (Map.Entry entry : set) {
            String oldId = (String)entry.getKey();
            String newId = (String)entry.getValue();
            paramsList.add(new Object[]{newId, oldId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        this._cancelInterviewInvite(ctx, cancelInterviewInvites);
        this._saveNewInterviewInvite(ctx, saveInterviewInvite, newStatus);
    }

    private void _saveNewInterviewInvite(Context ctx, IObjectCollection interviewInvites, String newStatus) throws BOSException {
        InterviewInviteCollection invites = (InterviewInviteCollection)interviewInvites;
        String sql = "INSERT INTO T_REC_InterviewInvite(FID,FInvitePerson,FInvitePersonName,FInviteWay,FEmail,FEmailModel,FEmailTheme,FEmailContent,FSmsService,FSmsModel,FSmsContent,FCanceled,FInterviewPlanId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) VALUES (" + RecDBUtils.getParamPlaceholder(ALLFIELD) + ")";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator inviteIter = invites.iterator();
        String interviewPlanId = null;
        String email = null;
        while (inviteIter.hasNext()) {
            String creatorId;
            InterviewInviteInfo info = (InterviewInviteInfo)inviteIter.next();
            interviewPlanId = info.getInterviewPlanId();
            String invitePerson = info.getInvitePerson() == null ? null : info.getInvitePerson().getValue();
            String inviteWay = info.getInviteWay() == null ? null : info.getInviteWay().getValue();
            String lastUpdateUserId = creatorId = BOSUuid.read((String)ctx.getCaller().toString()).toString();
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            email = info.getEmail();
            Object[] param = new Object[]{info.getId().toString(), invitePerson, info.getInvitePersonName(), inviteWay, email, info.getEmailModel(), info.getEmailTheme(), info.getEmailContent(), info.getSmsService(), info.getSmsModel(), info.getSmsContent(), 0, interviewPlanId, creatorId, info.getCreateTime(), lastUpdateUserId, info.getLastUpdateTime(), cuId};
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        InterviewPlanFactory.getLocalInstance(ctx).changeInterviewInviteStatus((IObjectPK)new ObjectUuidPK(interviewPlanId), newStatus);
        this.saveOperate(ctx, interviewPlanId);
        if (email != null) {
            InterviewInviteEmailFactory.getLocalInstance(ctx).updateCurrentUserEmailSetting(email);
        }
    }

    @Override
    protected void _sendInterviewInvite(Context ctx, IObjectValue interviewInvite, String newStatus) throws BOSException {
        InterviewInviteInfo invite = (InterviewInviteInfo)interviewInvite;
        InterviewPlanFactory.getLocalInstance(ctx).changeInterviewInviteStatus((IObjectPK)new ObjectUuidPK(invite.getInterviewPlanId()), newStatus);
    }

    @Override
    protected void _deleteAllInviteWithIpIds(Context ctx, IObjectCollection interviewPlanIds) throws BOSException {
        IInterviewInviteFile iFile = InterviewInviteFileFactory.getLocalInstance(ctx);
        InterviewPlanCollection ipIds = (InterviewPlanCollection)interviewPlanIds;
        if (!ipIds.isEmpty()) {
            iFile.deleteFileWithIpIds(ipIds);
            StringBuilder fillParam = new StringBuilder();
            Object[] params = new Object[ipIds.size()];
            Iterator ipIter = ipIds.iterator();
            int index = 0;
            while (ipIter.hasNext()) {
                InterviewPlanInfo ipInfo = (InterviewPlanInfo)ipIter.next();
                params[index] = ipInfo.getId().toString();
                if (index == 0) {
                    fillParam.append("?");
                } else {
                    fillParam.append(",?");
                }
                ++index;
            }
            String sql = "DELETE FROM T_REC_InterviewInvite WHERE FInterviewPlanId IN (" + fillParam.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private InterviewInviteCollection fillInterviewInviteEntity(IRowSet rs) throws SQLException, BOSException {
        InterviewInviteCollection coll = new InterviewInviteCollection();
        HashMap<String, InterviewInviteInfo> map = new HashMap<String, InterviewInviteInfo>();
        ArrayList<String> interviewPlanIdsList = new ArrayList<String>();
        try {
            InterviewInviteInfo info = null;
            while (rs.next()) {
                info = new InterviewInviteInfo();
                BOSUuid fid = BOSUuid.read((String)rs.getString("FID"));
                info.setId(fid);
                info.setInvitePerson(InterviewInvitePersonEnum.getEnum(rs.getString("FInvitePerson")));
                info.setInvitePersonName(rs.getString("FInvitePersonName"));
                info.setInviteWay(InterviewInviteWayEnum.getEnum(rs.getString("FInviteWay")));
                info.setEmail(rs.getString("FEmail"));
                info.setEmailModel(rs.getString("FEmailModel"));
                info.setEmailTheme(rs.getString("FEmailTheme"));
                info.setEmailContent(rs.getString("FEmailContent"));
                info.setSmsService(rs.getString("FSmsService"));
                info.setSmsModel(rs.getString("FSmsModel"));
                info.setSmsContent(rs.getString("FSmsContent"));
                info.setCanceled(rs.getBoolean("FCanceled"));
                String interviewPlanId = rs.getString("FInterviewPlanId");
                info.setInterviewPlanId(interviewPlanId);
                info.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                info.setCreateTime(rs.getTimestamp("FCreateTime"));
                interviewPlanIdsList.add(interviewPlanId);
                map.put(fid.toString(), info);
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return coll;
    }

    @Override
    protected void _clearInitInterviewInviteAndFile(Context ctx, IObjectPK InterviewId) throws BOSException {
        try {
            String sql = "SELECT FID FROM T_REC_InterviewPlan WHERE FInterviewID = ?";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{InterviewId.toString()});
            for (Object[] data : datas) {
                String interviewPlanId = (String)data[0];
                this.saveOperate(ctx, interviewPlanId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private IObjectCollection getInitInterviewInviteIds(Context ctx) throws BOSException {
        String sql = "SELECT FID FROM T_REC_InterviewInvite WHERE FCreateTime is null";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, null);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        InterviewInviteCollection inviteColl = new InterviewInviteCollection();
        for (Object[] data : datas) {
            InterviewInviteInfo info = new InterviewInviteInfo();
            info.setId(BOSUuid.read((String)((String)data[0])));
            inviteColl.add(info);
        }
        return inviteColl;
    }

    private IObjectCollection getInitInterviewInviteIdsByIpId(Context ctx, String interviewPlanId) throws BOSException {
        String sql = "SELECT FID FROM T_REC_InterviewInvite WHERE FInterviewPlanId = ? AND FCreateTime is null";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        InterviewInviteCollection inviteColl = new InterviewInviteCollection();
        for (Object[] data : datas) {
            InterviewInviteInfo info = new InterviewInviteInfo();
            info.setId(BOSUuid.read((String)((String)data[0])));
            inviteColl.add(info);
        }
        return inviteColl;
    }

    @Override
    protected void _cancelInterviewInvite(Context ctx, IObjectCollection invites) throws BOSException {
        String sql = "UPDATE T_REC_InterviewInvite SET FCanceled = ?,FEmailContent=?,FSmsContent=?,FLastUpdateTime=? WHERE FID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String ipId = null;
        InterviewInviteCollection inviteColl = (InterviewInviteCollection)invites;
        Iterator inviteIter = inviteColl.iterator();
        while (inviteIter.hasNext()) {
            InterviewInviteInfo info = (InterviewInviteInfo)inviteIter.next();
            Object[] params = new Object[]{info.isCanceled() ? 1 : 0, info.getEmailContent(), info.getSmsContent(), info.getLastUpdateTime(), info.getId().toString()};
            paramsList.add(params);
            ipId = info.getInterviewPlanId();
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    @Override
    protected void _cancelInvite(Context ctx, String InterviewPlanId, IObjectCollection invites) throws BOSException {
        Date now = new Date();
        String sql = "UPDATE T_REC_InterviewInvite SET FCanceled = ?,FEmailContent=?,FSmsContent=?,FSendDate=?,FSendType=? WHERE FInterviewPlanId = ? and FSendState = 1 ";
        InterviewInviteInfo info = new InterviewInviteInfo();
        info.setCanceled(true);
        info.setEmailContent("");
        info.setSmsContent("");
        info.setSendDate(now);
        info.setSendType(InterviewerTypeEnum.CANCELiNTEVIEW);
        info.setInterviewPlanId(InterviewPlanId);
        Object[] params = new Object[]{info.isCanceled() ? 1 : 0, info.getEmailContent(), info.getSmsContent(), info.getSendDate(), info.getSendType().getValue(), info.getInterviewPlanId()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void deleteInitInviteByIpId(Context ctx, String interviewPlanId) throws BOSException {
        String sql = "DELETE FROM T_REC_InterviewInvite WHERE FInterviewPlanId = ? AND FCreateTime is null";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId});
    }

    @Override
    protected IObjectPK _getInterviewerInviteIdByIpId(Context ctx, IObjectPK interviewPlanId, String person) throws BOSException {
        String sql = "SELECT FID FROM T_REC_InterviewInvite WHERE FInterviewPlanId = ? AND FCanceled = 0 AND FInvitePerson = ?";
        Object[] params = new Object[]{interviewPlanId.toString(), person};
        ObjectUuidPK inviteId = null;
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
            if (datas != null && !datas.isEmpty()) {
                inviteId = new ObjectUuidPK((String)datas.get(0)[0]);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return inviteId;
    }

    @Override
    protected IObjectValue _getInviteEmailMesg(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FEmailTheme,FEmailContent FROM T_REC_InterviewInvite WHERE FInterviewPlanId=? AND FCanceled=0 AND FInvitePerson='2'";
        InterviewInviteInfo info = new InterviewInviteInfo();
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId.toString()});
            if (datas != null && !datas.isEmpty()) {
                Object[] data = datas.get(0);
                info.setEmailTheme((String)data[0]);
                info.setEmailContent((String)data[1]);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    @Override
    protected IObjectValue _getInterviewerSendedInvite(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FID,FEmail,FEmailModel,FEmailTheme,FEmailContent,FSmsService,FSmsModel,FSmsContent FROM T_REC_InterviewInvite WHERE FInterviewPlanId = ? AND FInvitePerson = '2' AND FCanceled = 0";
        Object[] params = new Object[]{interviewPlanId.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        InterviewInviteInfo info = null;
        try {
            if (rs.next()) {
                info = new InterviewInviteInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setEmail(rs.getString("FEmail"));
                info.setEmailModel(rs.getString("FEmailModel"));
                info.setEmailTheme(rs.getString("FEmailTheme"));
                info.setEmailContent(rs.getString("FEmailContent"));
                info.setSmsService(rs.getString("FSmsService"));
                info.setSmsModel(rs.getString("FSmsModel"));
                info.setSmsContent(rs.getString("FSmsContent"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOperate(Context ctx, String interviewPlanId) throws BOSException {
        try {
            Object object = saveLock;
            synchronized (object) {
                InterviewInviteFileFactory.getLocalInstance(ctx).saveOperate((IObjectPK)new ObjectUuidPK(interviewPlanId));
                this.deleteInitInviteByIpId(ctx, interviewPlanId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void _saveInterviewInviteSecond(Context ctx, IObjectValue interviewInviteInfo) throws BOSException {
        InterviewInviteInfo info = (InterviewInviteInfo)interviewInviteInfo;
        try {
            InterviewInviteFactory.getLocalInstance(ctx).addnew(info);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

