/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.InterviewInviteCollection;
import com.kingdee.shr.recuritment.InterviewInviteFileCollection;
import com.kingdee.shr.recuritment.InterviewInviteFileInfo;
import com.kingdee.shr.recuritment.InterviewInviteInfo;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.app.AbstractInterviewInviteFileControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class InterviewInviteFileControllerBean
extends AbstractInterviewInviteFileControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewInviteFileControllerBean");
    private static final String ALL_NAME_MESG = "FID,FName,FInterviewInviteId,FInterviewPlanId";

    @Override
    protected IObjectCollection _getInterviewInviteFileNames(Context ctx, String interviewPlanIds) throws BOSException {
        Object[] interviewPlanIdsAry = interviewPlanIds.split(",");
        StringBuilder fillParam = new StringBuilder();
        for (int i = 0; i < interviewPlanIdsAry.length; ++i) {
            if (i == 0) {
                fillParam.append("?");
                continue;
            }
            fillParam.append(",?");
        }
        String sql = "SELECT FID,FName,FInterviewInviteId,FInterviewPlanId FROM T_REC_InterviewInviteFile WHERE FInterviewPlanId IN (" + fillParam.toString() + ") AND FStatus = '_keep' ORDER BY FInterviewPlanId,FInterviewInviteId";
        InterviewInviteFileCollection coll = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])interviewPlanIdsAry);
            coll = this.fillInterviewInviteFileEntity(rs);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return coll;
    }

    @Override
    protected IObjectCollection _getInterviewInviteFileNamesByInviteId(Context ctx, IObjectPK inviteId) throws BOSException {
        String sql = "SELECT FID,FName,FInterviewInviteId,FInterviewPlanId FROM T_REC_InterviewInviteFile WHERE FInterviewInviteId = ?";
        Object[] params = new Object[]{inviteId.toString()};
        InterviewInviteFileCollection coll = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            coll = this.fillInterviewInviteFileEntity(rs);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return coll;
    }

    @Override
    protected IObjectPK _uploadFile(Context ctx, IObjectValue interviewInviteFile) throws BOSException {
        IObjectPK pk = null;
        try {
            pk = this._addnew(ctx, interviewInviteFile);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return pk;
    }

    @Override
    protected IObjectValue _getLoadFile(Context ctx, IObjectPK inviteId) throws BOSException {
        InterviewInviteFileInfo fileInfo = null;
        try {
            fileInfo = (InterviewInviteFileInfo)this._getValue(ctx, inviteId);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return fileInfo;
    }

    @Override
    protected void _deleteFileWithIpIds(Context ctx, IObjectCollection ipIds) throws BOSException {
        InterviewPlanCollection ipColl = (InterviewPlanCollection)ipIds;
        StringBuilder fillParam = new StringBuilder();
        Object[] params = new Object[ipColl.size()];
        Iterator ipIter = ipColl.iterator();
        int index = 0;
        while (ipIter.hasNext()) {
            InterviewPlanInfo ipInfo = (InterviewPlanInfo)ipIter.next();
            params[index] = ipInfo.getId().toString();
            if (index == 0) {
                fillParam.append("?");
            } else {
                fillParam.append(",?");
            }
            ++index;
        }
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FInterviewPlanId IN (" + fillParam.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _deleteFileWithInviteId(Context ctx, IObjectPK inviteId) throws BOSException {
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FInterviewInviteId = ?";
        Object[] params = new Object[]{inviteId.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _batchDeleteFileWithInviteIds(Context ctx, IObjectCollection interviewInvites) throws BOSException {
        InterviewInviteCollection inviteColl = (InterviewInviteCollection)interviewInvites;
        StringBuilder fillParam = new StringBuilder();
        Object[] params = new Object[inviteColl.size()];
        Iterator inviteIter = inviteColl.iterator();
        int index = 0;
        while (inviteIter.hasNext()) {
            InterviewInviteInfo info = (InterviewInviteInfo)inviteIter.next();
            if (index == 0) {
                fillParam.append("?");
            } else {
                fillParam.append(",?");
            }
            params[index] = info.getId().toString();
            ++index;
        }
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FInterviewInviteId IN (" + fillParam.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private String getFileStatus(Context ctx, String fileId) throws BOSException, SQLException {
        String sql = "SELECT FStatus FROM T_REC_InterviewInviteFile WHERE FID = ?";
        Object[] params = new Object[]{fileId};
        List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
        if (!datas.isEmpty()) {
            return (String)datas.get(0)[0];
        }
        return null;
    }

    @Override
    protected void _deleteFileWithId(Context ctx, IObjectPK fileId) throws BOSException {
        String fid = fileId.toString();
        String status = null;
        try {
            status = this.getFileStatus(ctx, fid);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sql = null;
        sql = "_keep".equals(status) ? "UPDATE T_REC_InterviewInviteFile SET FStatus='_keep_temp' WHERE FID = ?" : "DELETE FROM T_REC_InterviewInviteFile WHERE FID = ?";
        Object[] params = new Object[]{fid};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _deleteMoreFilesWithFId(Context ctx, IObjectCollection fileIds) throws BOSException {
        InterviewInviteFileCollection fileColl = (InterviewInviteFileCollection)fileIds;
        Object[] params = new Object[fileColl.size()];
        StringBuilder fillParam = new StringBuilder();
        Iterator fileIter = fileColl.iterator();
        int index = 0;
        while (fileIter.hasNext()) {
            InterviewInviteFileInfo info = (InterviewInviteFileInfo)fileIter.next();
            if (index == 0) {
                fillParam.append(info.getId().toString());
            } else {
                fillParam.append(",?");
            }
            params[index++] = info.getId().toString();
        }
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FID IN (" + fillParam.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private InterviewInviteFileCollection fillInterviewInviteFileEntity(IRowSet rs) throws SQLException {
        InterviewInviteFileCollection coll = new InterviewInviteFileCollection();
        try {
            InterviewInviteFileInfo info = null;
            while (rs.next()) {
                info = new InterviewInviteFileInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setName(rs.getString("FName"));
                info.setInterviewInviteId(rs.getString("FInterviewInviteId"));
                info.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return coll;
    }

    @Override
    protected void _cancelOperate(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        Object[] params = new Object[]{interviewPlanId.toString()};
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FStatus = '_temp' AND FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "UPDATE T_REC_InterviewInviteFile SET FStatus = '_keep' WHERE FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _resetOperate(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        Object[] params = new Object[]{interviewPlanId.toString()};
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FStatus = '_temp' AND FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "UPDATE T_REC_InterviewInviteFile SET FStatus = '_keep_temp' WHERE FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _saveOperate(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        Object[] params = new Object[]{interviewPlanId.toString()};
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FStatus = '_keep_temp' AND FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "UPDATE T_REC_InterviewInviteFile SET FStatus = '_keep' WHERE FInterviewPlanId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _rollBackFile(Context ctx) throws BOSException {
        String sql = "DELETE FROM T_REC_InterviewInviteFile WHERE FStatus = '_temp'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_REC_InterviewInviteFile SET FStatus = '_keep'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

