/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.IInterviewProcess;
import com.kingdee.shr.recuritment.InterviewLinkCollection;
import com.kingdee.shr.recuritment.InterviewLinkInfo;
import com.kingdee.shr.recuritment.InterviewLinkModifyLogCollection;
import com.kingdee.shr.recuritment.InterviewLinkModifyLogFactory;
import com.kingdee.shr.recuritment.InterviewProcessFactory;
import com.kingdee.shr.recuritment.InterviewResultStructureInfo;
import com.kingdee.shr.recuritment.InterviewStructureCollection;
import com.kingdee.shr.recuritment.InterviewStructureFactory;
import com.kingdee.shr.recuritment.InterviewStructureInfo;
import com.kingdee.shr.recuritment.InterviewStructureModifyLogFactory;
import com.kingdee.shr.recuritment.app.AbstractInterviewLinkControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterviewLinkControllerBean
extends AbstractInterviewLinkControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewLinkControllerBean");
    private static final String ALLFIELD = "FID,FOrder,FIsLastLink,FIsRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FIpId";

    @Override
    protected IObjectCollection _getInterviewSchemeLinks(Context ctx, IObjectPK ipId) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getInterviewSchemeLink acquire Ipid : " + ipId));
        }
        String sql = "SELECT FID,FOrder,FIsLastLink,FIsRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FIpId FROM T_REC_InterviewLink WHERE FIpId = ? ORDER BY FOrder";
        IRowSet rs = null;
        InterviewLinkCollection links = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{ipId.toString()});
            links = this.fillInterviewProcessEntity(rs, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return links;
    }

    private InterviewLinkCollection fillInterviewProcessEntity(IRowSet rs, Context ctx) throws SQLException, BOSException, EASBizException {
        InterviewLinkCollection coll = new InterviewLinkCollection();
        InterviewLinkInfo info = null;
        while (rs.next()) {
            info = new InterviewLinkInfo();
            info.setId(BOSUuid.read((String)rs.getString("FId")));
            info.setOrder(rs.getInt("FOrder"));
            info.setIsLastLink(rs.getBoolean("FIsLastLink"));
            info.setIsRequisiteLink(rs.getBoolean("FIsRequisiteLink"));
            info.setInterviewStageId(rs.getString("FInterviewStageId"));
            info.setInterviewStageName(rs.getString("FInterviewStageName"));
            info.setInterviewStageDescription(rs.getString("FInterviewStageDescription"));
            coll.add(info);
        }
        return coll;
    }

    @Override
    protected void _doSave(Context ctx, IObjectValue saveData) throws BOSException {
        InterviewLinkModifyLogCollection modifyLog;
        String power;
        String exchange;
        String deleteAllLink;
        String deleteLinks;
        InterviewLinkCollection modifyLinks;
        Map doSaveData = (Map)saveData.get("doSaveData");
        InterviewLinkCollection addLinks = (InterviewLinkCollection)((Object)doSaveData.get("addLinks"));
        if (!RecDBUtils.isEmpty((IObjectCollection)addLinks)) {
            if (addLinks.size() > 1) {
                this._addMoreInterviewLinks(ctx, (IObjectCollection)addLinks);
            } else {
                this._addInterviewLink(ctx, (IObjectValue)addLinks.get(0));
            }
        }
        if (!RecDBUtils.isEmpty((IObjectCollection)(modifyLinks = (InterviewLinkCollection)((Object)doSaveData.get("modifyLinks"))))) {
            if (modifyLinks.size() > 1) {
                this._modifyMoreInterviewLinks(ctx, (IObjectCollection)modifyLinks);
            } else {
                this._modifyInterviewLink(ctx, (IObjectValue)modifyLinks.get(0));
            }
        }
        if (!RecDBUtils.isEmpty(deleteLinks = (String)doSaveData.get("deleteLinks"))) {
            if (deleteLinks.split(",").length > 1) {
                this._deleteMoreInterviewLinks(ctx, deleteLinks);
            } else {
                this._deleteInterviewLink(ctx, (IObjectPK)new ObjectUuidPK(deleteLinks));
            }
        }
        if (!RecDBUtils.isEmpty(deleteAllLink = (String)doSaveData.get("deleteAllLink"))) {
            this._deleteAllInterviewLink(ctx, (IObjectPK)new ObjectUuidPK(deleteAllLink), false);
        }
        if (!RecDBUtils.isEmpty(exchange = (String)doSaveData.get("exchange"))) {
            this._modifyInterviewLinkSequence(ctx, exchange);
        }
        if (!RecDBUtils.isEmpty(power = (String)doSaveData.get("power"))) {
            IInterviewProcess ipImpl = InterviewProcessFactory.getLocalInstance(ctx);
            String ipId = (String)doSaveData.get("ipId");
            ipImpl.modifyInterviewSchemePower((IObjectPK)new ObjectUuidPK(ipId), power);
        }
        if (!RecDBUtils.isEmpty((IObjectCollection)(modifyLog = (InterviewLinkModifyLogCollection)((Object)doSaveData.get("modifylogs"))))) {
            InterviewLinkModifyLogFactory.getLocalInstance(ctx).addMoreModifyLogInfo(modifyLog);
        }
    }

    @Override
    protected void _addInterviewLink(Context ctx, IObjectValue newInterviewLink) throws BOSException {
        InterviewLinkInfo il = (InterviewLinkInfo)newInterviewLink;
        String sql = "INSERT INTO T_REC_InterviewLink(FID,FOrder,FIsLastLink,FIsRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FIpId) VALUES (" + RecDBUtils.getParamPlaceholder(ALLFIELD) + ")";
        String fid = null;
        fid = il.getId() == null ? BOSUuid.create((BOSObjectType)il.getBOSType()).toString() : il.getId().toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fid, il.getOrder(), il.isIsLastLink() ? 1 : 0, il.isIsRequisiteLink() ? 1 : 0, il.getInterviewStageId(), il.getInterviewStageName(), RecDBUtils.isEmpty(il.getInterviewStageDescription()) ? "  " : il.getInterviewStageDescription(), il.getIpId()});
        this.addInitInterviewStructure(ctx, fid);
    }

    private void addInitInterviewStructure(Context ctx, String interviewLinkId) throws BOSException {
        InterviewStructureCollection isColl = new InterviewStructureCollection();
        InterviewStructureInfo isInfo = new InterviewStructureInfo();
        isInfo.setId(BOSUuid.create((BOSObjectType)isInfo.getBOSType()));
        isInfo.setOrder(1);
        isInfo.setName("\u9762\u8bd5\u7ed3\u679c");
        isInfo.setIlId(interviewLinkId);
        InterviewResultStructureInfo structureInfo = new InterviewResultStructureInfo();
        structureInfo.setId(BOSUuid.read((String)"iQsAAAABa8hLEul5"));
        isInfo.setBasicData(structureInfo);
        isColl.add(isInfo);
        InterviewStructureFactory.getLocalInstance(ctx).addMoreStructures(isColl);
    }

    @Override
    protected void _addMoreInterviewLinks(Context ctx, IObjectCollection links) throws BOSException {
        InterviewLinkCollection ils = (InterviewLinkCollection)links;
        Iterator iter = ils.iterator();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        InterviewStructureCollection isColl = new InterviewStructureCollection();
        while (iter.hasNext()) {
            InterviewLinkInfo il = (InterviewLinkInfo)iter.next();
            String fid = null;
            fid = il.getId() == null ? BOSUuid.create((BOSObjectType)il.getBOSType()).toString() : il.getId().toString();
            paramsList.add(new Object[]{fid, il.getOrder(), il.isIsLastLink() ? 1 : 0, il.isIsRequisiteLink() ? 1 : 0, il.getInterviewStageId(), il.getInterviewStageName(), RecDBUtils.isEmpty(il.getInterviewStageDescription()) ? "  " : il.getInterviewStageDescription(), il.getIpId()});
            if ("copy".equals(il.get("operate"))) continue;
            InterviewStructureInfo isInfo = new InterviewStructureInfo();
            isInfo.setId(BOSUuid.create((BOSObjectType)isInfo.getBOSType()));
            isInfo.setOrder(1);
            isInfo.setName("\u9762\u8bd5\u7ed3\u679c");
            isInfo.setIlId(fid);
            InterviewResultStructureInfo structureInfo = new InterviewResultStructureInfo();
            structureInfo.setId(BOSUuid.read((String)"iQsAAAABa8hLEul5"));
            isInfo.setBasicData(structureInfo);
            isColl.add(isInfo);
        }
        if (!paramsList.isEmpty()) {
            String sql = "INSERT INTO T_REC_InterviewLink(FID,FOrder,FIsLastLink,FIsRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FIpId) VALUES(" + RecDBUtils.getParamPlaceholder(ALLFIELD) + ")";
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            if (!isColl.isEmpty()) {
                InterviewStructureFactory.getLocalInstance(ctx).addMoreStructures(isColl);
            }
        }
    }

    @Override
    protected void _deleteInterviewLink(Context ctx, IObjectPK ilId) throws BOSException {
        InterviewStructureModifyLogFactory.getLocalInstance(ctx).deleteMoreModifyLogInfo("FModifyILId", ilId.toString());
        Object[] params = new Object[]{ilId.toString()};
        String sql = "DELETE FROM T_REC_InterviewStructure WHERE FILID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "DELETE FROM T_REC_InterviewLink WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _deleteMoreInterviewLinks(Context ctx, String deleteLinks) throws BOSException {
        InterviewStructureModifyLogFactory.getLocalInstance(ctx).deleteMoreModifyLogInfo("FModifyILId", deleteLinks);
        String[] links = deleteLinks.split(",");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String link : links) {
            paramsList.add(new Object[]{link});
        }
        String sql = "DELETE FROM T_REC_InterviewStructure WHERE FILID = ?";
        if (!paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        sql = "DELETE FROM T_REC_InterviewLink WHERE FID = ?";
        if (!paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
    }

    @Override
    protected void _deleteAllInterviewLink(Context ctx, IObjectPK ipId, boolean removeLog) throws BOSException {
        InterviewStructureModifyLogFactory.getLocalInstance(ctx).deleteMoreModifyLogInfo("FIpId", ipId.toString());
        Object[] params = new Object[]{ipId.toString()};
        String sql = "DELETE FROM T_REC_InterviewStructure WHERE FILID IN (SELECT FID FROM T_REC_InterviewLink WHERE FIpId = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        if (removeLog) {
            sql = "DELETE FROM T_REC_InterviewLinkModifyLog WHERE FIpId = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        sql = "DELETE FROM T_REC_InterviewLink WHERE FIpId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _modifyInterviewLink(Context ctx, IObjectValue newInterviewLink) throws BOSException {
        InterviewLinkInfo il = (InterviewLinkInfo)newInterviewLink;
        String sql = "UPDATE T_REC_InterviewLink SET FOrder=?,FIsLastLink=?,FIsRequisiteLink=?,FInterviewStageId=?,FInterviewStageName=?,FInterviewStageDescription=? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{il.getOrder(), il.isIsLastLink() ? 1 : 0, il.isIsRequisiteLink() ? 1 : 0, il.getInterviewStageId(), il.getInterviewStageName(), il.getInterviewStageDescription(), il.getId().toString()});
    }

    @Override
    protected void _modifyMoreInterviewLinks(Context ctx, IObjectCollection newInterviewLinks) throws BOSException {
        String sql = "UPDATE T_REC_InterviewLink SET FOrder=?,FIsLastLink=?,FIsRequisiteLink=?,FInterviewStageId=?,FInterviewStageName=?,FInterviewStageDescription=? WHERE FID = ?";
        InterviewLinkCollection ils = (InterviewLinkCollection)newInterviewLinks;
        Iterator iter = ils.iterator();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (iter.hasNext()) {
            InterviewLinkInfo il = (InterviewLinkInfo)iter.next();
            paramsList.add(new Object[]{il.getOrder(), il.isIsLastLink() ? 1 : 0, il.isIsRequisiteLink() ? 1 : 0, il.getInterviewStageId(), il.getInterviewStageName(), il.getInterviewStageDescription(), il.getId().toString()});
        }
        if (!paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
    }

    @Override
    protected void _modifyInterviewLinkSequence(Context ctx, String ilSeqStr) throws BOSException {
        String sql = "UPDATE T_REC_InterviewLink SET FOrder = ? where FID = ?";
        String[] seqAry = ilSeqStr.split(",");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String seqStr : seqAry) {
            String[] seq = seqStr.split("::");
            paramsList.add(new Object[]{seq[1], seq[0]});
        }
        if (!paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
    }
}

