/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.recuritment.ApplyRecordFactory;
import com.kingdee.shr.recuritment.ApplyRecordInfo;
import com.kingdee.shr.recuritment.AutoRefreshFacadeFactory;
import com.kingdee.shr.recuritment.IAutoRefreshFacade;
import com.kingdee.shr.recuritment.IIPInterviewStructure;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailDiathesis;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailEvaluate;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailResult;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailWrite;
import com.kingdee.shr.recuritment.IInterviewInvite;
import com.kingdee.shr.recuritment.IInterviewLink;
import com.kingdee.shr.recuritment.IInterviewPlan;
import com.kingdee.shr.recuritment.IInterviewPlanResultFiles;
import com.kingdee.shr.recuritment.IInterviewProcess;
import com.kingdee.shr.recuritment.IInterviewStructure;
import com.kingdee.shr.recuritment.IInterviewerManagement;
import com.kingdee.shr.recuritment.IPInterviewStructureCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailFileInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureInfo;
import com.kingdee.shr.recuritment.IPInterviewersCollection;
import com.kingdee.shr.recuritment.IPInterviewersFactory;
import com.kingdee.shr.recuritment.IPInterviewersInfo;
import com.kingdee.shr.recuritment.IResumeBaseRec;
import com.kingdee.shr.recuritment.ISendPCInfo;
import com.kingdee.shr.recuritment.InterviewInviteCollection;
import com.kingdee.shr.recuritment.InterviewInviteFactory;
import com.kingdee.shr.recuritment.InterviewInviteInfo;
import com.kingdee.shr.recuritment.InterviewInviteStatusEnum;
import com.kingdee.shr.recuritment.InterviewLinkCollection;
import com.kingdee.shr.recuritment.InterviewLinkFactory;
import com.kingdee.shr.recuritment.InterviewLinkInfo;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.InterviewPlanResultCollection;
import com.kingdee.shr.recuritment.InterviewPlanResultFactory;
import com.kingdee.shr.recuritment.InterviewPlanResultFilesCollection;
import com.kingdee.shr.recuritment.InterviewPlanResultFilesFactory;
import com.kingdee.shr.recuritment.InterviewPlanResultFilesInfo;
import com.kingdee.shr.recuritment.InterviewPlanResultInfo;
import com.kingdee.shr.recuritment.InterviewProcessFactory;
import com.kingdee.shr.recuritment.InterviewProcessInfo;
import com.kingdee.shr.recuritment.InterviewResultFactory;
import com.kingdee.shr.recuritment.InterviewResultInfo;
import com.kingdee.shr.recuritment.InterviewResultStatusEnum;
import com.kingdee.shr.recuritment.InterviewResultStructureCollection;
import com.kingdee.shr.recuritment.InterviewResultStructureInfo;
import com.kingdee.shr.recuritment.InterviewStructureCollection;
import com.kingdee.shr.recuritment.InterviewStructureFactory;
import com.kingdee.shr.recuritment.InterviewStructureInfo;
import com.kingdee.shr.recuritment.InterviewerManagementCollection;
import com.kingdee.shr.recuritment.InterviewerManagementFactory;
import com.kingdee.shr.recuritment.InterviewerManagementInfo;
import com.kingdee.shr.recuritment.InterviewerStateEnum;
import com.kingdee.shr.recuritment.InterviewerTypeEnum;
import com.kingdee.shr.recuritment.NeedHRWriteResultEnum;
import com.kingdee.shr.recuritment.RecApprovalFactory;
import com.kingdee.shr.recuritment.RecApprovalInfo;
import com.kingdee.shr.recuritment.RecDemandWritebackTypeEnum;
import com.kingdee.shr.recuritment.RecWritebackDataFacadeFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.SendPCInfoFactory;
import com.kingdee.shr.recuritment.SendPCInfoInfo;
import com.kingdee.shr.recuritment.TransactionStateEnum;
import com.kingdee.shr.recuritment.VideoInterviewConfigFactory;
import com.kingdee.shr.recuritment.VideoInterviewConfigInfo;
import com.kingdee.shr.recuritment.VideoInterviewType;
import com.kingdee.shr.recuritment.app.AbstractInterviewPlanControllerBean;
import com.kingdee.shr.recuritment.app.InterviewStageCollection;
import com.kingdee.shr.recuritment.app.InterviewStageFactory;
import com.kingdee.shr.recuritment.app.InterviewStageInfo;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.service.interviewGo.SendInterviewMsgService;
import com.kingdee.shr.recuritment.app.util.AttachmentUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecMetaUtil;
import com.kingdee.ws.ca.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterviewPlanControllerBean
extends AbstractInterviewPlanControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewPlanControllerBean");
    private static final String FULLFIELD = "FID,FInterviewSchemeName,FOrder,FLastLink,FRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FInviteStatus,FInterviewTime,FInterviewAddress,FContacterId,FContacterName,FContacterCell,FContacterEmail,FInterviewID,FInterviewCompany,FInviteInfo";
    private static final String ALLFIELD = "FID,FInterviewSchemeName,FOrder,FLastLink,FRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FInterviewStagePower,FInviteStatus,FInterviewTime,FInterviewAddress,FContacterId,FContacterName,FContacterCell,FContacterEmail,FInterviewID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAddNewLink,FInterviewCompany,FInviteInfo";
    private static final String OPERATE_ADD = "ADD";
    private static final String OPERATE_SUBTRACT = "SUBTRACT";
    private static final String IPRESULT_DATATYPE_INIT = "init";
    private static final String IPRESULT_DATATYPE_ADD = "add";
    private static final String IPRESULT_DATATYPE_DELETE = "delete";
    private static final String IPRESULT_FILE_MODIFY = "modify";
    private static final String IPRESULT_FILE_DELETE = "delete";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+(.[0-9]+)?$");
    private static final String PLAN_RESULT_FILE_KEEP = "KEEP";
    private static final String PLAN_RESULT_FILE_DEL = "DELETE";
    private static final String PLAN_RESULT_FILE_TEMP = "TEMP";

    @Override
    protected IObjectValue _getRecuritmentDemandScheme(Context ctx, IObjectPK interviewId) throws BOSException {
        InterviewProcessInfo info = null;
        String sql = "SELECT FID,FName_l2 FROM T_REC_InterviewProcess WHERE FID = (SELECT FScheme FROM T_REC_RecuritmentDemand WHERE FID = (SELECT FRecuritmentDemandID FROM T_REC_ResumeBaseRec WHERE FID =(SELECT FResumeBaseRecID FROM T_REC_InterviewResult WHERE FID = ?)))";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewId.toString()});
            if (datas != null && !datas.isEmpty()) {
                Object[] data = datas.get(0);
                info = new InterviewProcessInfo();
                info.setId(BOSUuid.read((String)((String)data[0])));
                info.setName((String)data[1]);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    @Override
    protected IObjectValue _getInterviewPersonBaseData(Context ctx, String interviewId) throws BOSException {
        ResumeBaseRecInfo info = null;
        try {
            InterviewResultInfo resultInfo = InterviewResultFactory.getLocalInstance(ctx).getInterviewResultInfo("select resumeBaseRec.*,resumeBaseRec.department.name,resumeBaseRec.hrJob.name,resumeBaseRec.HDegree.name,resumeBaseRec.RecuritPosition.name,resumeBaseRec.recuritmentDemand.hrOrgUnit.name,resumeBaseRec.recuritmentDemand.PositionName where id = '" + interviewId + "'");
            info = resultInfo.getResumeBaseRec();
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    @Override
    protected IObjectCollection _getCustomInterviewLinkData(Context ctx, String interviewId) throws BOSException {
        InterviewInviteFactory.getLocalInstance(ctx).clearInitInterviewInviteAndFile((IObjectPK)new ObjectUuidPK(interviewId));
        this.autoUpdateInterviewPlanInviteStatus(ctx);
        InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection(" where interview ='" + interviewId + "'");
        if (coll.size() == 0) {
            return coll;
        }
        coll.sort("order");
        Object[] params = new Object[]{interviewId};
        Iterator iter = coll.iterator();
        HashMap<String, InterviewPlanInfo> map = new HashMap<String, InterviewPlanInfo>();
        params = new Object[coll.size()];
        StringBuilder fillParam = new StringBuilder();
        int index = 0;
        StringBuilder interviewPlanIdsBuf = new StringBuilder();
        StringBuilder planBuf = new StringBuilder();
        while (iter.hasNext()) {
            InterviewPlanInfo ipInfo = (InterviewPlanInfo)iter.next();
            String id = ipInfo.getId().toString();
            planBuf.append("'");
            planBuf.append(id);
            planBuf.append("'");
            planBuf.append(",");
            map.put(id, ipInfo);
            params[index] = id;
            if (index == 0) {
                fillParam.append("?");
                interviewPlanIdsBuf.append(id);
            } else {
                fillParam.append(",?");
                interviewPlanIdsBuf.append(",").append(id);
            }
            ++index;
        }
        String planIdAll = "";
        if (null != planBuf) {
            planIdAll = planBuf.toString();
            planIdAll = planIdAll.substring(0, planIdAll.length() - 1);
        }
        if (!fillParam.toString().isEmpty()) {
            IPInterviewersCollection interviewersColl = IPInterviewersFactory.getLocalInstance(ctx).getIPInterviewersCollection(" where interviewPlanId in(" + planIdAll + ") and (isInviteAdd is null or isInviteAdd='0') ORDER BY interviewPlanId");
            Iterator interviewersIter = interviewersColl.iterator();
            HashMap<String, ArrayList<IPInterviewersInfo>> interviewersMap = new HashMap<String, ArrayList<IPInterviewersInfo>>();
            IPInterviewersInfo interviewer = null;
            while (interviewersIter.hasNext()) {
                interviewer = (IPInterviewersInfo)interviewersIter.next();
                ArrayList<IPInterviewersInfo> interviewers = (ArrayList<IPInterviewersInfo>)interviewersMap.get(interviewer.getInterviewPlanId());
                if (interviewers == null) {
                    interviewers = new ArrayList<IPInterviewersInfo>();
                    interviewersMap.put(interviewer.getInterviewPlanId(), interviewers);
                    InterviewPlanInfo planInfo = (InterviewPlanInfo)map.get(interviewer.getInterviewPlanId());
                    planInfo.put("interviewers", interviewers);
                }
                interviewers.add(interviewer);
            }
            IInterviewInvite iInvite = InterviewInviteFactory.getLocalInstance(ctx);
            InterviewInviteCollection inviteColl = iInvite.getInterviewInviteCollection(" where interviewPlanId in(" + planIdAll + ")  AND (sendEmailState <> 0 OR sendSmsState <> 0) order by lastUpdateTime desc");
            Iterator inviteIter = inviteColl.iterator();
            HashMap<String, ArrayList<InterviewInviteInfo>> inviteListMap = new HashMap<String, ArrayList<InterviewInviteInfo>>();
            InterviewInviteInfo inviteInfo = null;
            while (inviteIter.hasNext()) {
                inviteInfo = (InterviewInviteInfo)inviteIter.next();
                ArrayList<InterviewInviteInfo> inviteList = (ArrayList<InterviewInviteInfo>)inviteListMap.get(inviteInfo.getInterviewPlanId());
                if (inviteList == null) {
                    inviteList = new ArrayList<InterviewInviteInfo>();
                    inviteListMap.put(inviteInfo.getInterviewPlanId(), inviteList);
                    InterviewPlanInfo planInfo = (InterviewPlanInfo)map.get(inviteInfo.getInterviewPlanId());
                    planInfo.put("invites", inviteList);
                }
                inviteList.add(inviteInfo);
            }
        }
        return coll;
    }

    @Override
    protected IObjectCollection _getIpInterviewersNamesByIpId(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewersCollection iters = new IPInterviewersCollection();
        String sql = "SELECT FInterviewerName FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ?";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId.toString()});
            IPInterviewersInfo iter = null;
            for (Object[] data : datas) {
                iter = new IPInterviewersInfo();
                iter.setInterviewerName((String)data[0]);
                iters.add(iter);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return iters;
    }

    private void autoUpdateInterviewPlanInviteStatus(Context ctx) throws BOSException {
        IAutoRefreshFacade autoRefresh = AutoRefreshFacadeFactory.getLocalInstance(ctx);
        autoRefresh.autoUpdateInterviewPlanInviteStatus();
    }

    @Override
    protected IObjectCollection _getSchemeInterviewLinkData(Context ctx, String interviewSchemeId, String interviewSchemeName, String interviewId) throws BOSException {
        IInterviewProcess iProcess = InterviewProcessFactory.getLocalInstance(ctx);
        IInterviewLink il = InterviewLinkFactory.getLocalInstance(ctx);
        IInterviewStructure is = InterviewStructureFactory.getLocalInstance(ctx);
        String schemePower = iProcess.getInterviewSchemePower((IObjectPK)new ObjectUuidPK(interviewSchemeId));
        InterviewLinkCollection ilColl = il.getInterviewSchemeLinks((IObjectPK)new ObjectUuidPK(interviewSchemeId));
        Iterator iter = ilColl.iterator();
        if (logger.isDebugEnabled()) {
            logger.debug("ilColl====" + ilColl.size());
        }
        InterviewPlanCollection ipColl = new InterviewPlanCollection();
        while (iter.hasNext()) {
            InterviewLinkInfo info = (InterviewLinkInfo)iter.next();
            InterviewStructureCollection isColl = is.getStructureAndFilesWithIlIds(info.getId().toString());
            InterviewPlanInfo ipInfo = new InterviewPlanInfo();
            BOSUuid fid = BOSUuid.create((BOSObjectType)ipInfo.getBOSType());
            ipInfo.setId(fid);
            ipInfo.setInterviewSchemeName(interviewSchemeName);
            ipInfo.setOrder(info.getOrder());
            ipInfo.setLastLink(info.isIsLastLink());
            ipInfo.setRequisiteLink(info.isIsRequisiteLink());
            ipInfo.setInterviewStageId(info.getInterviewStageId());
            ipInfo.setInterviewStageName(info.getInterviewStageName());
            ipInfo.setInterviewStageDescription(StringUtils.isEmpty((String)info.getInterviewStageDescription()) ? " " : info.getInterviewStageDescription());
            ipInfo.setInterviewStagePower(schemePower);
            ipInfo.setInviteStatus(InterviewInviteStatusEnum.START);
            ipInfo.setContacterId("");
            ipInfo.setContacterName("");
            ipInfo.setContacterCell("");
            ipInfo.setContacterEmail("");
            InterviewResultInfo resultInfo = new InterviewResultInfo();
            resultInfo.setId(BOSUuid.read((String)interviewId));
            ipInfo.setInterview(resultInfo);
            info.put("invites", new ArrayList());
            ipInfo.put("interviewers", new ArrayList());
            Iterator isIter = isColl.iterator();
            while (isIter.hasNext()) {
                InterviewStructureInfo isInfo = (InterviewStructureInfo)isIter.next();
                isInfo.put("interviewPlanId", fid.toString());
            }
            ipInfo.put("is", (Object)isColl);
            ipColl.add(ipInfo);
        }
        this._clearInterviewPlanLinksData(ctx, (IObjectPK)new ObjectUuidPK(interviewId));
        this._addInitSchemeInterviewPlanLinksData(ctx, (IObjectCollection)ipColl);
        return ipColl;
    }

    @Override
    protected IObjectCollection _getInterviewPlanIdsWithInterivewId(Context ctx, IObjectPK interviewId) throws BOSException {
        String sql = "SELECT FID FROM T_REC_InterviewPlan WHERE FInterviewID = ?";
        Object[] params = new Object[]{interviewId.toString()};
        InterviewPlanCollection coll = new InterviewPlanCollection();
        try {
            List<Object[]> ipIds = RecDBUtils.getQueryData(ctx, sql, params);
            for (Object[] ipIdAry : ipIds) {
                String ipId = (String)ipIdAry[0];
                InterviewPlanInfo info = new InterviewPlanInfo();
                info.setId(BOSUuid.read((String)ipId));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    @Override
    protected void _addInitSchemeInterviewPlanLinksData(Context ctx, IObjectCollection interviewPlans) throws BOSException {
        InterviewPlanCollection ipColl = (InterviewPlanCollection)interviewPlans;
        if (ipColl == null || ipColl.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("1***" + ipColl.toString());
        }
        InterviewPlanCollection planColl = new InterviewPlanCollection();
        Iterator iter = ipColl.iterator();
        IIPInterviewStructure iIpIs = IPInterviewStructureFactory.getLocalInstance(ctx);
        String interviewPlanId = null;
        CoreBaseCollection corColls = new CoreBaseCollection();
        while (iter.hasNext()) {
            String ipId;
            InterviewPlanInfo ip = (InterviewPlanInfo)iter.next();
            planColl.add(ip);
            corColls.add((CoreBaseInfo)ip);
            interviewPlanId = ipId = ip.getId().toString();
            iIpIs.addMoreInterviewStructure((InterviewStructureCollection)((Object)ip.get("is")));
            this._initInterviewPlanResultStructure(ctx, (IObjectPK)new ObjectUuidPK(ipId));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("2***" + interviewPlanId);
        }
        try {
            InterviewPlanFactory.getLocalInstance(ctx).addnew(corColls);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("3***" + interviewPlanId);
        }
        if (interviewPlanId != null) {
            InterviewResultInfo interviewResultInfo;
            if (logger.isDebugEnabled()) {
                logger.debug("4***" + interviewPlanId);
            }
            if ((interviewResultInfo = this.getInterviewResultByInterviewPlanId(ctx, interviewPlanId)) != null) {
                String currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewResultInfo.getId()));
                try {
                    String sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID = ? WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{currInterviewStageId, interviewResultInfo.getId().toString()});
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    protected void _addInterviewPlanLinkData(Context ctx, IObjectValue interviewPlan) throws BOSException {
        InterviewPlanInfo ipInfo = (InterviewPlanInfo)interviewPlan;
        this._updateInterviewPlanLinkOrder(ctx, (IObjectPK)new ObjectUuidPK(ipInfo.getInterview().getId().toString()), ipInfo.getOrder(), OPERATE_ADD);
        InterviewPlanCollection ipColl = new InterviewPlanCollection();
        ipColl.add(ipInfo);
        this._addInitSchemeInterviewPlanLinksData(ctx, (IObjectCollection)ipColl);
    }

    @Override
    protected void _updateInterviewPlanLinkOrder(Context ctx, IObjectPK interviewId, int newOrder, String operateType) throws BOSException {
        String sql = "SELECT FOrder,FID from T_REC_InterviewPlan where FInterviewID = ? AND FOrder >= ?";
        Object[] params = new Object[]{interviewId.toString(), newOrder};
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
            if (!datas.isEmpty()) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (Object[] data : datas) {
                    Object orderObj = data[0];
                    int order = -1;
                    order = orderObj instanceof BigDecimal ? ((BigDecimal)orderObj).intValue() : ((Integer)orderObj).intValue();
                    params = OPERATE_ADD.equals(operateType) ? new Object[]{order + 1, data[1]} : new Object[]{order - 1, data[1]};
                    paramsList.add(params);
                }
                sql = "UPDATE T_REC_InterviewPlan SET FOrder = ? where FID = ?";
                RecDBUtils.executeBatch(ctx, sql, paramsList);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getCanUseInterviewLinks(Context ctx, String linkIds, String hrOrgUnitId) throws BOSException {
        String sql = null;
        Object[] params = null;
        String existsSql = " and exists (select 1 from T_REC_InterviewStageRelation where FSTATE = 100 and FhrOrgUseId = '" + hrOrgUnitId + "' and FBASEINFOID  = stage.FID)";
        if (linkIds.trim().isEmpty()) {
            sql = "SELECT FID,FName_l1,FName_l2,FName_l3,FDescription_l1,FDescription_l2,FDescription_l3 FROM T_REC_InterviewStage as stage WHERE FState = '1' " + existsSql + "  ORDER BY FNumber;";
        } else {
            String[] linkIdAry = linkIds.split(",");
            int len = linkIdAry.length;
            params = new Object[len];
            StringBuilder fillParam = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    fillParam.append("?");
                } else {
                    fillParam.append(",?");
                }
                params[i] = linkIdAry[i];
            }
            sql = "SELECT FID,FName_l1,FName_l2,FName_l3,FDescription_l1,FDescription_l2,FDescription_l3 FROM T_REC_InterviewStage as stage WHERE FState = '1' AND FID NOT IN (" + fillParam.toString() + ") " + existsSql + " ORDER BY FNumber;";
        }
        IRowSet rs = null;
        InterviewLinkCollection coll = null;
        try {
            rs = params != null ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)ctx, (String)sql);
            coll = this.fillInterviewLinkEntity(rs, ctx);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return coll;
    }

    @Override
    protected IObjectCollection _getCanInterviewStruct(Context ctx, String linkIds, String billid) throws BOSException {
        String sql = null;
        Object[] params = null;
        String[] resultBill = billid.split(",");
        String reOrg = "(";
        for (int i = 0; i < resultBill.length; ++i) {
            reOrg = reOrg + "'";
            reOrg = reOrg + resultBill[i] + "'";
            if (i >= resultBill.length - 1) continue;
            reOrg = reOrg + ",";
        }
        reOrg = reOrg + ")";
        String hrOrg = "select FHRORGUNITID  from T_REC_RecuritmentDemand where fid =(select FRECURITMENTDEMANDID  from T_REC_ResumeBaseRec where fid =(select FRESUMEBASERECID  from T_REC_InterviewResult where fid in" + reOrg + "))";
        String existsSql = " and exists (select 1 from T_REC_InterviewStructRelation where FSTATE = 100 and FhrOrgUseId in (" + hrOrg + ") and FBASEINFOID  = stage.FID)";
        if (linkIds.trim().isEmpty()) {
            sql = "SELECT FID,FName_l1,FName_l2,FName_l3,FDescription_l1,FDescription_l2,FDescription_l3 FROM T_REC_InterviewResultStructure as stage WHERE FState = '1' " + existsSql + "  ORDER BY FNumber;";
        } else {
            String[] linkIdAry = linkIds.split(",");
            int len = linkIdAry.length;
            params = new Object[len];
            StringBuilder fillParam = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    fillParam.append("?");
                } else {
                    fillParam.append(",?");
                }
                params[i] = linkIdAry[i];
            }
            sql = "SELECT FID,FName_l1,FName_l2,FName_l3,FDescription_l1,FDescription_l2,FDescription_l3 FROM T_REC_InterviewResultStructure as stage WHERE FState = '1' AND FID NOT IN (" + fillParam.toString() + ") " + existsSql + " ORDER BY FNumber;";
        }
        IRowSet rs = null;
        InterviewResultStructureCollection coll = null;
        try {
            rs = params != null ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)ctx, (String)sql);
            coll = this.fillInterviewStructureEntity(rs, ctx);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return coll;
    }

    @Override
    protected int _getInterviewPlanLinkMaxOrder(Context ctx, IObjectPK interviewId) throws BOSException {
        String sql = "SELECT MAX(FOrder) FROM T_REC_InterviewPlan WHERE FInterviewID = ?";
        Object[] params = new Object[]{interviewId.toString()};
        int maxOrder = 0;
        try {
            List<Object[]> list = RecDBUtils.getQueryData(ctx, sql, params);
            if (!list.isEmpty() && list.get(0)[0] != null) {
                Object orderObj = list.get(0)[0];
                maxOrder = orderObj instanceof BigDecimal ? ((BigDecimal)orderObj).intValue() : ((Integer)orderObj).intValue();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return maxOrder;
    }

    @Override
    protected void _clearInterviewPlanLinksData(Context ctx, IObjectPK interviewId) throws BOSException {
        String sql = "SELECT FID FROM T_REC_InterviewPlan WHERE FInterviewID = ?";
        Object[] params = new Object[]{interviewId.toString()};
        try {
            List<Object[]> fidList = RecDBUtils.getQueryData(ctx, sql, params);
            if (!fidList.isEmpty()) {
                this.clearInterviewResultPlanDatas(ctx, fidList);
                this._clearIPlanRelevanceOtherData(ctx, fidList);
            }
            sql = "DELETE FROM T_REC_InterviewPlan WHERE FInterviewID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            String sqld = "update  T_REC_InterviewResult set FCURRINTERVIEWSTAGEID=null WHERE fid = ?";
            DbUtil.execute((Context)ctx, (String)sqld, (Object[])params);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _deleteInterviewPlanLinkData(Context ctx, IObjectPK interviewId, IObjectPK interviewPlanId, int order) throws BOSException {
        String ipId = interviewPlanId.toString();
        InterviewResultInfo interviewResultInfo = this.getInterviewResultByInterviewPlanId(ctx, ipId);
        Object[] params = new Object[]{ipId};
        ArrayList<Object[]> interviewPlanIds = new ArrayList<Object[]>();
        interviewPlanIds.add(params);
        this.clearInterviewResultPlanDatas(ctx, interviewPlanIds);
        this._updateInterviewPlanLinkOrder(ctx, interviewId, order + 1, OPERATE_SUBTRACT);
        this._clearIPlanRelevanceOtherData(ctx, interviewPlanIds);
        String sql = "DELETE FROM T_REC_InterviewPlan WHERE FId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        if (interviewResultInfo != null) {
            String currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewResultInfo.getId()));
            try {
                sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{currInterviewStageId, interviewResultInfo.getId().toString()});
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void clearInterviewResultPlanDatas(Context ctx, List<Object[]> interviewPlanIds) throws BOSException {
        ArrayList<String> params = new ArrayList<String>(interviewPlanIds.size());
        for (Object[] data : interviewPlanIds) {
            params.add((String)data[0]);
        }
        String sql = "SELECT FID FROM T_REC_InterviewPlanResult WHERE FInterviewPlanId IN (" + RecDBUtils.getParamPlaceholder(params.toArray(new String[0])) + ")";
        List<Object[]> ipReusltIds = null;
        try {
            ipReusltIds = RecDBUtils.getQueryData(ctx, sql, params.toArray(new String[0]));
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            if (ipReusltIds != null && !ipReusltIds.isEmpty()) {
                sql = "DELETE FROM T_REC_InterviewPlanResultFiles WHERE FInterviewPlanResultId = ?";
                RecDBUtils.executeBatch(ctx, sql, ipReusltIds);
            }
            if (interviewPlanIds != null && !interviewPlanIds.isEmpty()) {
                sql = "DELETE FROM T_REC_InterviewPlanResult WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
                sql = "DELETE FROM T_REC_IPISDetailResult WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
                sql = "DELETE FROM T_REC_IPISDetailEvaluate WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
                sql = "DELETE FROM T_REC_IPISDetailWrite WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
                sql = "DELETE FROM T_REC_IPISDetailDiathesis WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
                sql = "DELETE FROM T_REC_IPISDetailFile WHERE FInterviewPlanId = ?";
                RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected IObjectCollection _findInterviewer(Context ctx, String arg) throws BOSException {
        InterviewerManagementCollection coll = new InterviewerManagementCollection();
        try {
            String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
            String dataPattern = this.getFLEFFDTDatePattern(ctx);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            sql.append("\tPer.FID,Per.FNumber,Per.FPersonName,Per.FAdminName,Per.FPositionName,Per.FCell,Per.FOfficePhone,Per.FEMail,ET." + nameField + "  ");
            sql.append("FROM ( ");
            sql.append("\tSELECT ");
            sql.append("\t\tP.FID FID,P.FNumber FNumber,P." + nameField + " FPersonName,T.FAdminName FAdminName,T.FPositionName FPositionName,P.FCell FCell,P.FOfficePhone FOfficePhone,P.FEMail FEmail,P.FEmployeeTypeID FEmployeeTypeID ");
            sql.append("\tFROM ");
            sql.append("\t\t(SELECT * FROM T_BD_Person BDP WHERE EXISTS (SELECT 1 FROM T_HR_BDEmployeeType EMP WHERE BDP.FEmployeeTypeID = EMP.FID AND FinService <> 2 AND FinService <> 3)) P ");
            sql.append("\tJOIN ");
            sql.append("\t\t(SELECT E.FPersonID FPersonID,A." + nameField + " FAdminName,Pos." + nameField + " FPositionName FROM T_HR_EmpOrgRelation E JOIN T_ORG_Admin A ON (E.FAdminOrgID = A.FID AND E.FLEFFDT = " + dataPattern + " AND E.FAssignType = " + 1 + ") JOIN T_ORG_Position Pos ON (E.FPositionID = Pos.FID)) T ");
            sql.append("\tON (lower(P." + nameField + ") LIKE ? AND P.FID = T.FPersonID) ");
            sql.append("\tUNION ");
            sql.append("\tSELECT ");
            sql.append("\t\tP.FID FID,P.FNumber FNumber,P." + nameField + " FPersonName,T.FAdminName FAdminName,T.FPositionName FPositionName,P.FCell FCell,P.FOfficePhone FOfficePhone,P.FEMail FEmail,P.FEmployeeTypeID FEmployeeTypeID ");
            sql.append("\tFROM ");
            sql.append("\t\t(SELECT * FROM T_BD_Person BDP WHERE EXISTS (SELECT 1 FROM T_HR_BDEmployeeType EMP WHERE BDP.FEmployeeTypeID = EMP.FID AND FinService <> 2 AND FinService <> 3)) P ");
            sql.append("\tJOIN ");
            sql.append("\t\t(SELECT E.FPersonID FPersonID,A." + nameField + " FAdminName,Pos." + nameField + " FPositionName FROM T_HR_EmpOrgRelation E JOIN T_ORG_Admin A ON (E.FAdminOrgID = A.FID AND E.FLEFFDT = " + dataPattern + " AND E.FAssignType = " + 1 + ") JOIN T_ORG_Position Pos ON (E.FPositionID = Pos.FID)) T ");
            sql.append("\tON (lower(P.FNumber) LIKE ? AND P.FID = T.FPersonID ) ");
            sql.append(") Per JOIN T_HR_BDEmployeeType ET ON (Per.FEmployeeTypeID = ET.FID) and  et.FinService in('1','4')");
            arg = "%" + arg.toLowerCase() + "%";
            Object[] params = new Object[]{arg, arg};
            List<Object[]> persons = RecDBUtils.getQueryData(ctx, sql.toString(), params);
            if (persons == null || persons.isEmpty()) {
                return coll;
            }
            ArrayList<String> personIds = new ArrayList<String>(persons.size() > 2000 ? 2000 : persons.size());
            HashMap<String, InterviewerManagementInfo> interMap = new HashMap<String, InterviewerManagementInfo>();
            for (int i = 0; i < persons.size(); ++i) {
                InterviewerManagementInfo info = new InterviewerManagementInfo();
                Object[] person = persons.get(i);
                String personId = (String)person[0];
                info.put("personId", personId);
                info.put("personNumber", (String)person[1]);
                info.put("personName", (String)person[2]);
                info.put("adminName", (String)person[3]);
                info.put("positionName", (String)person[4]);
                info.put("cell", (String)person[5]);
                info.put("email", (String)person[7]);
                info.put("employeeType", (String)person[8]);
                coll.add(info);
                interMap.put(personId, info);
                personIds.add(personId);
                if ((i + 1) % 2000 != 0) continue;
                this.fillInterviewerContactInformation(ctx, interMap, personIds);
                personIds = new ArrayList(persons.size() - i > 2000 ? 2000 : persons.size() - i);
            }
            if (!personIds.isEmpty()) {
                this.fillInterviewerContactInformation(ctx, interMap, personIds);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return coll;
    }

    private void fillInterviewerContactInformation(Context ctx, Map<String, InterviewerManagementInfo> interMap, List<String> personIds) throws BOSException, SQLException {
        String sql = "SELECT FPersonId,FPhone,FEmail,FAblePosiNames FROM T_REC_InterviewerManagement WHERE FPersonId IN (" + RecDBUtils.getParamPlaceholder(personIds) + ")";
        List<Object[]> interMesgs = RecDBUtils.getQueryData(ctx, sql, personIds.toArray(new String[0]));
        for (Object[] data : interMesgs) {
            String pId = (String)data[0];
            InterviewerManagementInfo imInfo = interMap.get(pId);
            imInfo.put("cell", (String)data[1]);
            imInfo.put("email", (String)data[2]);
            if (data[3] instanceof SerialClob) {
                try {
                    imInfo.put("interviewPosition", RecDBUtils.serialClobToString((SerialClob)data[3]));
                    continue;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            imInfo.put("interviewPosition", (String)data[3]);
        }
    }

    @Override
    protected IObjectCollection _findContacter(Context ctx, String arg) throws BOSException {
        String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
        String dataPattern = this.getFLEFFDTDatePattern(ctx);
        String sql = "SELECT P.FID,P.FNumber,P." + nameField + " FPersonName,T.FAdminName,T.FPositionName,P.FCell,P.FOfficePhone,P.FEMail FROM T_BD_Person P JOIN (SELECT E.FPersonID FPersonID,A." + nameField + " FAdminName,Pos." + nameField + " FPositionName FROM T_HR_EmpOrgRelation E JOIN T_ORG_Admin A ON (E.FLEFFDT = " + dataPattern + " AND FAssignType=1 AND E.FAdminOrgID = A.FID) JOIN T_ORG_Position Pos ON (E.FPositionID = Pos.FID)) T ON (P." + nameField + " LIKE ? AND P.FID = T.FPersonID) join T_HR_BDEmployeeType h on p.FEMPLOYEETYPEID=h.fid and h.FinService in('1','4')  union SELECT P.FID,P.FNumber,P." + nameField + " FPersonName,T.FAdminName,T.FPositionName,P.FCell,P.FOfficePhone,P.FEMail FROM T_BD_Person P JOIN (SELECT E.FPersonID FPersonID,A." + nameField + " FAdminName,Pos." + nameField + " FPositionName FROM T_HR_EmpOrgRelation E JOIN T_ORG_Admin A ON (E.FLEFFDT = " + dataPattern + " AND FAssignType=1 AND E.FAdminOrgID = A.FID) JOIN T_ORG_Position Pos ON (E.FPositionID = Pos.FID)) T ON (P.FNumber LIKE ? AND P.FID = T.FPersonID)  join T_HR_BDEmployeeType h on p.FEMPLOYEETYPEID=h.fid and h.FinService in('1','4')";
        arg = "%" + arg + "%";
        Object[] params = new Object[]{arg, arg};
        PersonCollection personColl = null;
        try {
            List<Object[]> datasList = RecDBUtils.getQueryData(ctx, sql, params);
            personColl = new PersonCollection();
            if (datasList != null && !datasList.isEmpty()) {
                for (Object[] datas : datasList) {
                    PersonInfo person = new PersonInfo();
                    person.setId(BOSUuid.read((String)((String)datas[0])));
                    person.setNumber((String)datas[1]);
                    person.setName((String)datas[2]);
                    person.put("adminName", (Object)((String)datas[3]));
                    person.put("positionName", (Object)((String)datas[4]));
                    person.setCell((String)datas[5]);
                    person.setOfficePhone((String)datas[6]);
                    person.setEmail((String)datas[7]);
                    personColl.add(person);
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return personColl;
    }

    @Override
    protected IObjectValue _getCurrentUserMesg(Context ctx, IObjectPK personId) throws BOSException {
        String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
        String sql = "SELECT " + nameField + ",FEMail,FCell,FOfficePhone FROM T_BD_Person WHERE FID = ?";
        Object[] params = new Object[]{personId.toString()};
        PersonInfo person = null;
        try {
            person = new PersonInfo();
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, params);
            Object[] data = datas.get(0);
            person.setName((String)data[0]);
            person.setEmail((String)data[1]);
            person.setCell((String)data[2]);
            person.setOfficePhone((String)data[3]);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return person;
    }

    @Override
    protected IObjectCollection _getDepartmentInterviewers(Context ctx, IObjectPK adminOrgUnitId, IObjectPK hrOrgUnitId) throws BOSException {
        InterviewerManagementCollection imColl = new InterviewerManagementCollection();
        IInterviewerManagement iMan = InterviewerManagementFactory.getLocalInstance(ctx);
        InterviewerManagementCollection coll = iMan.getInterviewerByDeptIdAndState(adminOrgUnitId.toString(), hrOrgUnitId.toString(), InterviewerStateEnum.NORMAL);
        if (RecDBUtils.isEmpty((IObjectCollection)coll)) {
            return imColl;
        }
        InterviewerManagementInfo manInfo = null;
        String personId = "";
        String laborRelationStateName = "";
        String belongDeptName = "";
        String belongPosiName = "";
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        Iterator manIter = coll.iterator();
        while (manIter.hasNext()) {
            manInfo = (InterviewerManagementInfo)manIter.next();
            if (manInfo.getPerson() == null) continue;
            personId = manInfo.getPerson().getId().toString();
            boolean repeat = false;
            if (imColl.isEmpty() || imColl.size() == 0) {
                imColl.add(manInfo);
            } else {
                for (int i = 0; i < imColl.size(); ++i) {
                    if (!imColl.get(i).getPerson().getId().toString().equals(personId)) continue;
                    repeat = true;
                }
            }
            if (repeat) continue;
            imColl.add(manInfo);
            manInfo.put("personId", personId);
            manInfo.put("personNumber", manInfo.getPerson().getNumber());
            manInfo.put("personName", manInfo.getPerson().getName());
            manInfo.put("cell", manInfo.getPhone());
            manInfo.put("email", manInfo.getEmail());
            manInfo.put("interviewPosition", manInfo.getAblePosiNames());
            EmpPosOrgRelationCollection empPosOrgRelationCollection = iMan.getCurrntEmpOrgRelation(personId, AssignTypeEnum.MAIN);
            if (null != empPosOrgRelationCollection && empPosOrgRelationCollection.size() > 0) {
                empPosOrgRelationInfo = empPosOrgRelationCollection.get(0);
                laborRelationStateName = empPosOrgRelationInfo.getLaborRelation().getLaborRelationState().getName();
                belongDeptName = empPosOrgRelationInfo.getAdminOrg().getName();
                belongPosiName = empPosOrgRelationInfo.getPosition().getName();
            }
            manInfo.put("adminName", belongDeptName);
            manInfo.put("positionName", belongPosiName);
            manInfo.put("employeeType", laborRelationStateName);
        }
        return imColl;
    }

    @Override
    protected void _addInterviewPlanMesgData(Context ctx, IObjectValue interviewPlanMesg) throws BOSException {
        InterviewPlanInfo ipInfo = (InterviewPlanInfo)interviewPlanMesg;
        String interviewPlanId = ipInfo.getId().toString();
        try {
            InterviewPlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(interviewPlanId), ipInfo);
        }
        catch (EASBizException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        String deleteInterviewerIds = (String)ipInfo.get("deleteInterviewerIds");
        this._deleteInterviewPlanInterviewers(ctx, (IObjectPK)new ObjectUuidPK(interviewPlanId), deleteInterviewerIds);
        IPInterviewersCollection coll = (IPInterviewersCollection)((Object)ipInfo.get("interviewers"));
        this._addInterviewPlanInterviewers(ctx, (IObjectCollection)coll);
        this.addInterviewPlanSendPcInfo(ctx, coll);
        InterviewResultInfo interviewResultInfo = this.getInterviewResultByInterviewPlanId(ctx, interviewPlanId);
        if (interviewResultInfo != null) {
            String currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewResultInfo.getId()));
            String sql = "";
            try {
                sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{currInterviewStageId, interviewResultInfo.getId().toString()});
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void addInterviewPlanSendPcInfo(Context ctx, IPInterviewersCollection coll) throws BOSException {
        try {
            ISendPCInfo iSendPCInfo = SendPCInfoFactory.getLocalInstance(ctx);
            CoreBaseCollection baseColl = new CoreBaseCollection();
            if (coll != null && !coll.isEmpty()) {
                Iterator interIter = coll.iterator();
                IPInterviewersInfo interInfo = null;
                while (interIter.hasNext()) {
                    interInfo = (IPInterviewersInfo)interIter.next();
                    String interviewPlanId = interInfo.getInterviewPlanId();
                    String interviewerId = interInfo.getInterviewerId();
                    if (iSendPCInfo.exists("where interviewPlanId='" + interviewPlanId + "' and interviewer='" + interviewerId + "'")) continue;
                    SendPCInfoInfo sendPCInfoInfo = new SendPCInfoInfo();
                    sendPCInfoInfo.setInterviewplanId(interviewPlanId);
                    sendPCInfoInfo.setInterviewer(interviewerId);
                    baseColl.add((CoreBaseInfo)sendPCInfoInfo);
                }
            }
            if (!RecDBUtils.isEmpty((IObjectCollection)baseColl)) {
                iSendPCInfo.addnew(baseColl);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _addInterviewPlanInterviewers(Context ctx, IObjectCollection coll) throws BOSException {
        IPInterviewersCollection interviewers = (IPInterviewersCollection)coll;
        if (interviewers != null && !interviewers.isEmpty()) {
            IPInterviewStructureCollection struColl;
            IObjectValue result;
            Iterator iter = interviewers.iterator();
            String interviewPlanId = null;
            CoreBaseCollection baseColl = new CoreBaseCollection();
            while (iter.hasNext()) {
                IPInterviewersInfo interviewer = (IPInterviewersInfo)iter.next();
                baseColl.add((CoreBaseInfo)interviewer);
                interviewPlanId = interviewer.getInterviewPlanId();
            }
            try {
                if (baseColl.size() > 0) {
                    IPInterviewersFactory.getLocalInstance(ctx).addnew(baseColl);
                }
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            if (interviewPlanId != null && (result = this._getInterviewPlanResult(ctx, (IObjectPK)new ObjectUuidPK(interviewPlanId))) != null && !RecDBUtils.isEmpty((IObjectCollection)(struColl = IPInterviewStructureFactory.getLocalInstance(ctx).getIPInterviewStructureCollection("Select *,basicData.id,basicData.uipk,basicData.model  where interviewPlanId='" + interviewPlanId.toString() + "'")))) {
                Iterator struIter = struColl.iterator();
                IPInterviewStructureInfo struInfo = null;
                while (struIter.hasNext()) {
                    struInfo = (IPInterviewStructureInfo)struIter.next();
                    String model = struInfo.getBasicData().getModel();
                    logger.error("\u521d\u59cb\u5316\u9762\u8bd5\u7ed3\u679c\u5143\u7d20\uff1a" + struInfo.getBasicData().getUipk());
                    this.processInterviewElementResult(ctx, model, struInfo, interviewers);
                }
            }
        }
    }

    private void processInterviewElementResult(Context ctx, String model, IPInterviewStructureInfo struInfo, IPInterviewersCollection interviewers) throws BOSException {
        if ("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult".equals(model)) {
            this.addIPInterviewStructureDetailResult(ctx, struInfo, interviewers);
        } else if ("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate".equals(model)) {
            this.addIPInterviewStructureDetailEvaluate(ctx, struInfo, interviewers);
        } else if ("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite".equals(model)) {
            this.addIPInterviewStructureDetailWrite(ctx, struInfo);
        } else if ("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis".equals(model)) {
            this.addIPInterviewStructureDetailDiathesis(ctx, struInfo);
        } else {
            this.addOtherIPInterviewStructureDetail(ctx, struInfo, interviewers);
        }
    }

    @Override
    protected void _deleteInterviewPlanInterviewers(Context ctx, IObjectPK interivewPlanId, String deleteInterviewerIds) throws BOSException {
        Object[] deleteInterviewerIdAry = null;
        if (deleteInterviewerIds != null && !"".equals(deleteInterviewerIds)) {
            IObjectValue result;
            String ipId = interivewPlanId.toString();
            deleteInterviewerIds = ipId + "," + deleteInterviewerIds;
            deleteInterviewerIdAry = deleteInterviewerIds.split(",");
            StringBuilder fillParam = new StringBuilder();
            for (int i = 0; i < deleteInterviewerIdAry.length - 1; ++i) {
                if (i <= 0) {
                    fillParam.append("?");
                    continue;
                }
                fillParam.append(",?");
            }
            String sql = "DELETE FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ? AND FInterviewerId IN (" + fillParam.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])deleteInterviewerIdAry);
            String sql_03 = "DELETE FROM T_REC_SendPcInfo WHERE FInterviewPlanId = ? AND FInterviewer IN (" + fillParam.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sql_03, (Object[])deleteInterviewerIdAry);
            if (ipId != null && (result = this._getInterviewPlanResult(ctx, (IObjectPK)new ObjectUuidPK(ipId))) != null) {
                IIPInterviewStructure iStru = IPInterviewStructureFactory.getLocalInstance(ctx);
                IPInterviewStructureCollection struColl = iStru.getIPInterviewStructureCollection("where basicData.model = 'com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult' and interviewPlanId = '" + ipId + "'");
                if (struColl != null && !struColl.isEmpty()) {
                    this.deleteIPInterviewStructureDetailResultByInterviewerId(ctx, ipId, (String[])deleteInterviewerIdAry);
                    InterviewPlanResultInfo interviewPlanResult = (InterviewPlanResultInfo)result;
                    if (!interviewPlanResult.isHrWriteResult()) {
                        IIPInterviewStructureDetailResult iIPInterviewStructureDetailResult = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx);
                        IPInterviewStructureDetailResultCollection coll = iIPInterviewStructureDetailResult.getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + ipId + "'");
                        int size = coll.size();
                        if (size == 0) {
                            interviewPlanResult.setResult(InterviewResultStatusEnum.NULL);
                            interviewPlanResult.setInterviewScore("");
                        } else if (size == 1) {
                            interviewPlanResult.setResult(InterviewResultStatusEnum.getEnum(coll.get(0).getResult()));
                            interviewPlanResult.setInterviewScore(coll.get(0).getScore());
                        } else {
                            String interviewResult = coll.get(0).getResult();
                            Pattern pattern = NUMBER_PATTERN;
                            double totalScore = 0.0;
                            boolean IsNum = true;
                            for (int i = 0; i < size; ++i) {
                                IPInterviewStructureDetailResultInfo ipDetail = coll.get(i);
                                if (!interviewResult.equals(ipDetail.getResult())) {
                                    interviewResult = "2";
                                }
                                if (null != ipDetail.getScore()) {
                                    if (IsNum && pattern.matcher(ipDetail.getScore()).matches()) {
                                        totalScore += Double.parseDouble(ipDetail.getScore());
                                        continue;
                                    }
                                    IsNum = false;
                                    continue;
                                }
                                IsNum = false;
                            }
                            if (IsNum) {
                                interviewPlanResult.setInterviewScore(String.valueOf(totalScore / (double)size));
                            }
                            interviewPlanResult.setResult(InterviewResultStatusEnum.getEnum(interviewResult));
                        }
                        try {
                            InterviewPlanResultFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(interviewPlanResult.getId().toString()), interviewPlanResult);
                        }
                        catch (EASBizException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            throw new BOSException(e.getMessage(), (Throwable)e);
                        }
                        String inviteStatus = this.analyzeInterviewPlanResultStatus(interviewPlanResult.getResult().getValue());
                        this._changeInterviewInviteStatus(ctx, interivewPlanId, inviteStatus);
                    }
                }
                if ((struColl = iStru.getIPInterviewStructureCollection("where basicData.model = 'com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate' and interviewPlanId = '" + ipId + "'")) != null && !struColl.isEmpty()) {
                    this.deleteIPInterviewStructureDetailEvaluateByInterviewerId(ctx, ipId, (String[])deleteInterviewerIdAry);
                }
            }
        }
    }

    @Override
    protected void _changeInterviewInviteStatus(Context ctx, IObjectPK interviewPlanId, String newStatus) throws BOSException {
        Timestamp stp;
        UserInfo userinfo;
        InterviewPlanInfo planInfo;
        block38: {
            String sql = "SELECT IR.FResumeBaseRecID,IR.FID FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewResult IR ON (IP.FInterviewID = IR.FID) WHERE IP.FID = ?";
            List<Object[]> datas = null;
            String resumeId = null;
            try {
                datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId.toString()});
                if (datas == null || datas.isEmpty()) {
                    throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u9762\u8bd5\u73af\u8282\u5bf9\u5e94\u9762\u8bd5\u4fe1\u606f\uff01");
                }
                resumeId = (String)datas.get(0)[0];
                String resumeState = null;
                if ("0".equals(newStatus) || "2".equals(newStatus) || "3".equals(newStatus)) {
                    resumeState = "nBqJPlDqTtu5U+jhPfGoWAhd7oA=";
                    if ("0".equals(newStatus)) {
                        sql = "SELECT FInterviewerId FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ?";
                        datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId.toString()});
                        ArrayList<Object[]> deleteInterviewerIds = new ArrayList<Object[]>(datas.size());
                        for (Object[] data : datas) {
                            deleteInterviewerIds.add(new Object[]{data[0], interviewPlanId.toString()});
                        }
                        if (!deleteInterviewerIds.isEmpty()) {
                            this.deleteIPInterviewStructureDetailResultByInterviewerId(ctx, interviewPlanId.toString(), deleteInterviewerIds);
                            this.deleteIPInterviewStructureDetailEvaluateByInterviewerId(ctx, interviewPlanId.toString(), deleteInterviewerIds);
                            sql = "DELETE FROM T_REC_IPInterviewers WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
                            RecDBUtils.executeBatch(ctx, sql, deleteInterviewerIds);
                        }
                    }
                } else if (newStatus == null) {
                    // empty if block
                }
                if (resumeState == null) break block38;
                IResumeBaseRec iResumeBaseRec = null;
                try {
                    iResumeBaseRec = ResumeBaseRecFactory.getLocalInstance(ctx);
                }
                catch (BOSException e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                }
                ResumeBaseRecInfo resume = null;
                try {
                    resume = iResumeBaseRec.getResumeBaseRecInfo((IObjectPK)new ObjectUuidPK(resumeId));
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                String stateId = resume.getResumeState().getId().toString();
                if (!"/pIxPc8hTNGJcfL1aWx2jQhd7oA=".equals(stateId)) {
                    sql = "UPDATE T_REC_ResumeBaseRec SET FResumeStateID = ? WHERE FID = '" + resumeId + "'";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{resumeState});
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        Object params = null;
        if ("2".equals(newStatus) || "4".equals(newStatus) || "0".equals(newStatus)) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u53d6\u6d88\u9080\u7ea6\uff0c\u4fee\u6539\u9762\u8bd5\u9080\u7ea6\u7684\u72b6\u6001");
            }
            planInfo = new InterviewPlanInfo();
            if ("2".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.BEGIN);
            }
            if ("4".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.REFUSE);
            }
            if ("0".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.CANCEL);
            }
            userinfo = new UserInfo();
            userinfo.setId(BOSUuid.read((String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
            planInfo.setInviteUser(userinfo);
            stp = new Timestamp(System.currentTimeMillis());
            planInfo.setLastUpdateTime(stp);
            planInfo.setAddNewLink(false);
            planInfo.setId(BOSUuid.read((String)interviewPlanId.toString()));
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u53d6\u6d88\u9080\u7ea6\uff0c\u4fee\u6539\u9762\u8bd5\u9080\u7ea6\u7684\u72b6\u6001interviewPlanId.toString()=" + interviewPlanId.toString());
                    logger.debug("\u53d6\u6d88\u9080\u7ea6\uff0c\u4fee\u6539\u9762\u8bd5\u9080\u7ea6\u7684\u72b6\u6001planInfo.getInviteStatus().getValue()=" + planInfo.getInviteStatus().getValue());
                }
                InterviewPlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(interviewPlanId.toString()), planInfo);
                InterviewPlanInfo info = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanInfo((IObjectPK)new ObjectUuidPK(interviewPlanId.toString()));
                if (logger.isDebugEnabled()) {
                    logger.debug("info.getInviteStatus().getValue()=" + info.getInviteStatus().getValue());
                    logger.debug("info.getInterviewTime()=" + info.getInterviewTime());
                }
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (null != newStatus) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u53d6\u6d88\u9080\u7ea6222\uff0c\u4fee\u6539\u9762\u8bd5\u9080\u7ea6\u7684\u72b6\u6001interviewPlanId.toString()=" + interviewPlanId.toString());
                logger.debug("newStatus=" + newStatus);
            }
            planInfo = new InterviewPlanInfo();
            if ("2".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.BEGIN);
            }
            if ("4".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.REFUSE);
            }
            if ("0".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.CANCEL);
            }
            if ("6".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.PASS);
            }
            if ("1".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.START);
            }
            if ("3".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.RESULT);
            }
            if ("4".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.REFUSE);
            }
            if ("5".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.WAIT);
            }
            if ("7".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.QUIT);
            }
            if ("8".equals(newStatus)) {
                planInfo.setInviteStatus(InterviewInviteStatusEnum.END);
            }
            userinfo = new UserInfo();
            userinfo.setId(BOSUuid.read((String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
            planInfo.setInviteUser(userinfo);
            stp = new Timestamp(System.currentTimeMillis());
            planInfo.setLastUpdateTime(stp);
            planInfo.setAddNewLink(false);
            planInfo.setId(BOSUuid.read((String)interviewPlanId.toString()));
            try {
                InterviewPlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(interviewPlanId.toString()), planInfo);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void _clearIPlanRelevanceOtherData(Context ctx, List<Object[]> interviewPlanIds) throws BOSException {
        String sql = "DELETE FROM T_REC_IPInterviewStructure WHERE FInterviewPlanId = ?";
        RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
        sql = "DELETE FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ?";
        RecDBUtils.executeBatch(ctx, sql, interviewPlanIds);
        InterviewPlanCollection ipColl = new InterviewPlanCollection();
        for (Object[] ipId : interviewPlanIds) {
            InterviewPlanInfo info = new InterviewPlanInfo();
            info.setId(BOSUuid.read((String)((String)ipId[0])));
            ipColl.add(info);
        }
        InterviewInviteFactory.getLocalInstance(ctx).deleteAllInviteWithIpIds(ipColl);
    }

    private InterviewPlanCollection fillInterviewPlanEntity(Context ctx, IRowSet rs) throws SQLException, BOSException {
        InterviewPlanCollection coll = new InterviewPlanCollection();
        InterviewPlanInfo plInfo = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        while (rs.next()) {
            plInfo = new InterviewPlanInfo();
            plInfo.setId(BOSUuid.read((String)rs.getString("FID")));
            plInfo.setInterviewSchemeName(rs.getString("FInterviewSchemeName"));
            plInfo.setOrder(rs.getInt("FOrder"));
            plInfo.setRequisiteLink(rs.getBoolean("FRequisiteLink"));
            plInfo.setLastLink(rs.getBoolean("FLastLink"));
            plInfo.setInterviewStageId(rs.getString("FInterviewStageId"));
            plInfo.setInterviewStageName(rs.getString("FInterviewStageName"));
            plInfo.setInterviewStageDescription(rs.getString("FInterviewStageDescription"));
            plInfo.setInviteStatus(InterviewInviteStatusEnum.getEnum(rs.getString("FInviteStatus")));
            plInfo.setInterviewTime(rs.getTimestamp("FInterviewTime"));
            plInfo.setContacterId(rs.getString("FContacterId"));
            plInfo.setContacterName(rs.getString("FContacterName"));
            plInfo.setContacterCell(rs.getString("FContacterCell"));
            plInfo.setContacterEmail(rs.getString("FContacterEmail"));
            String adderss = rs.getString("FInterviewAddress");
            plInfo.setInterviewAddress(adderss);
            String company = rs.getString("FInterviewCompany");
            plInfo.setInterviewCompany(company);
            plInfo.setInviteInfo(rs.getString("FInviteInfo"));
            InterviewResultInfo resultInfo = new InterviewResultInfo();
            resultInfo.setId(BOSUuid.read((String)rs.getString("FInterviewID")));
            plInfo.setInterview(resultInfo);
            coll.add(plInfo);
        }
        return coll;
    }

    private IPInterviewersCollection fillIPInterviewerEntity(IRowSet rs) throws SQLException {
        IPInterviewersCollection coll = new IPInterviewersCollection();
        IPInterviewersInfo info = null;
        try {
            while (rs.next()) {
                info = new IPInterviewersInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setInterviewerId(rs.getString("FInterviewerId"));
                info.setInterviewerName(rs.getString("FInterviewerName"));
                info.setInterviewerCell(rs.getString("FInterviewerCell"));
                info.setInterviewerEmail(rs.getString("FInterviewerEmail"));
                info.setIsInviteAdd(rs.getBoolean("FIsInviteAdd"));
                info.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return coll;
    }

    private InterviewLinkCollection fillInterviewLinkEntity(IRowSet rs, Context context) throws SQLException {
        InterviewLinkCollection coll = new InterviewLinkCollection();
        String[] fieldParam = RecDBUtils.parseFieldByLanguage(context, "name", "description");
        String nameParam = fieldParam[0];
        String descParam = fieldParam[1];
        try {
            InterviewLinkInfo info = null;
            while (rs.next()) {
                info = new InterviewLinkInfo();
                info.setInterviewStageId(rs.getString("FID"));
                info.setInterviewStageName(rs.getString(nameParam));
                info.setInterviewStageDescription(StringUtils.isEmpty((String)rs.getString(descParam)) ? " " : rs.getString(descParam));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return coll;
    }

    private InterviewResultStructureCollection fillInterviewStructureEntity(IRowSet rs, Context context) throws SQLException {
        InterviewResultStructureCollection coll = new InterviewResultStructureCollection();
        String[] fieldParam = RecDBUtils.parseFieldByLanguage(context, "name", "description");
        String nameParam = fieldParam[0];
        String descParam = fieldParam[1];
        try {
            InterviewResultStructureInfo info = null;
            while (rs.next()) {
                info = new InterviewResultStructureInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setName(rs.getString(nameParam));
                info.setDescription(StringUtils.isEmpty((String)rs.getString(descParam)) ? " " : rs.getString(descParam));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return coll;
    }

    private String getFLEFFDTDatePattern(Context ctx) {
        String datePattern = "{ts'2199-12-31 00:00:00'}";
        return datePattern;
    }

    @Override
    protected void _cancelInterviewInvite(Context ctx, IObjectPK interviewPlanId, IObjectCollection invites) throws BOSException {
        InterviewInviteCollection inviteColl = (InterviewInviteCollection)invites;
        InterviewInviteFactory.getLocalInstance(ctx).cancelInvite(interviewPlanId.toString(), (IObjectCollection)inviteColl);
        this._changeInterviewInviteStatus(ctx, interviewPlanId, "0");
    }

    @Override
    protected String _getCurrentComponyName(Context ctx) throws BOSException {
        String componyName = null;
        AdminOrgUnitInfo adminInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        AdminOrgUnitInfo parent = adminInfo.getParent();
        if (parent != null) {
            String nameField = RecDBUtils.parseFieldByLanguage(ctx, "name")[0];
            String adminId = parent.getId().toString();
            try {
                while (adminId != null && !"".equals(adminId)) {
                    String sql = "SELECT " + nameField + ",FParentId FROM T_ORG_Admin WHERE FID = ?";
                    List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{adminId});
                    componyName = (String)datas.get(0)[0];
                    adminId = (String)datas.get(0)[1];
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            componyName = adminInfo.getName();
        }
        return componyName;
    }

    @Override
    protected IObjectValue _getAInterviewPlanByIpId(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        InterviewPlanCollection coll = null;
        try {
            String sql = "SELECT FID,FInterviewSchemeName,FOrder,FLastLink,FRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FInviteStatus,FInterviewTime,FInterviewAddress,FContacterId,FContacterName,FContacterCell,FContacterEmail,FInterviewID,FInterviewCompany,FInviteInfo FROM T_REC_InterviewPlan WHERE FID = ?";
            Object[] params = new Object[]{interviewPlanId.toString()};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            coll = this.fillInterviewPlanEntity(ctx, rs);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
            return coll.get(0);
        }
        return null;
    }

    @Override
    protected String _canSendInterviewInvite(Context ctx, String interviewPlanId) throws BOSException {
        String sql = "SELECT FInviteStatus FROM T_REC_InterviewPlan T1 WHERE EXISTS (SELECT 1 FROM T_REC_InterviewPlan T2 WHERE T2.FID = ? AND T1.FInterviewID = T2.FInterviewID AND T2.FOrder > T1.FOrder)";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!datas.isEmpty()) {
            boolean flag = true;
            for (Object[] data : datas) {
                String status = (String)data[0];
                if ("1".equals(status)) {
                    flag = false;
                } else if ("0".equals(status)) {
                    flag = false;
                }
                if (flag) continue;
                return "\u5b58\u5728\u5c1a\u672a\u9080\u7ea6\u901a\u8fc7\u7684\u73af\u8282\uff0c\u4e0d\u80fd\u53d1\u9001\u6b64\u73af\u8282\u9080\u7ea6\uff01";
            }
        }
        return "OK";
    }

    @Override
    protected IObjectCollection _getInterviewResultLinkData(Context ctx, IObjectPK interviewResultId) throws BOSException {
        InterviewProcessInfo processInfo;
        this.autoUpdateInterviewPlanInviteStatus(ctx);
        InterviewPlanCollection interPlanColl = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection(" where interview ='" + interviewResultId.toString() + "'");
        if (interPlanColl.size() == 0 && (processInfo = (InterviewProcessInfo)this._getRecuritmentDemandScheme(ctx, interviewResultId)) != null) {
            interPlanColl = (InterviewPlanCollection)this._getSchemeInterviewLinkData(ctx, processInfo.getId().toString(), processInfo.getName(), interviewResultId.toString());
        }
        interPlanColl.sort("order");
        return interPlanColl;
    }

    @Override
    protected IObjectCollection _getInterviewResultLinkData(Context ctx, IObjectPK interviewResultId, String type) throws BOSException {
        this.autoUpdateInterviewPlanInviteStatus(ctx);
        InterviewPlanCollection interPlanColl = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection(" where interview ='" + interviewResultId.toString() + "'");
        interPlanColl.sort("order");
        return interPlanColl;
    }

    @Override
    protected IObjectValue _getInterviewPlanResult(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        InterviewPlanResultInfo resultInfo = null;
        InterviewPlanResultCollection planResultColl = InterviewPlanResultFactory.getLocalInstance(ctx).getInterviewPlanResultCollection("where interviewPlanId = '" + interviewPlanId.toString() + "'");
        if (!RecDBUtils.isEmpty((IObjectCollection)planResultColl)) {
            resultInfo = planResultColl.get(0);
            this.clearUselessInterviewPlanResultData(ctx, resultInfo);
        }
        return resultInfo;
    }

    private void clearUselessInterviewPlanResultData(Context ctx, InterviewPlanResultInfo resultInfo) throws BOSException {
        try {
            this.clearInterviewPlanResultFiles(ctx, resultInfo.getId().toString());
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void clearInterviewPlanResultFiles(Context ctx, String interviewPlanResultId) throws BOSException {
        try {
            String sql = "DELETE FROM T_REC_InterviewPlanResultFiles WHERE FInterviewPlanResultId = ? AND FStatus = 'TEMP' AND FCreatorID = '" + ctx.getCaller().toString() + "' ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanResultId});
            sql = "UPDATE T_REC_InterviewPlanResultFiles SET FStatus = 'KEEP' WHERE FInterviewPlanResultId = ? AND FStatus = 'DELETE'";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanResultId});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void clearIPInterviewStructureDetail(Context ctx, String table, String interviewPlanId) throws BOSException {
        try {
            String sql = "UPDATE " + table + " SET FTempFileName=NULL,FTempFileCode=NULL WHERE FInterviewPlanId = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected IObjectCollection _getInterviewPlanResultFile(Context ctx, IObjectPK interviewPlanResultId) throws BOSException {
        String sql = "SELECT FID,FileName FROM T_REC_InterviewPlanResultFiles WHERE FInterviewPlanResultId = ? AND FStatus = 'KEEP'";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanResultId.toString()});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        InterviewPlanResultFilesCollection fileColl = new InterviewPlanResultFilesCollection();
        if (!RecDBUtils.isEmpty(datas)) {
            InterviewPlanResultFilesInfo fileInfo = null;
            for (Object[] data : datas) {
                fileInfo = new InterviewPlanResultFilesInfo();
                fileInfo.setId(BOSUuid.read((String)((String)data[0])));
                fileInfo.setFileName((String)data[1]);
                fileColl.add(fileInfo);
            }
        }
        return fileColl;
    }

    private boolean isInitedInterviewPlanResult(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IRowSet rowset = null;
        String sql = "SELECT FID FROM T_REC_InterviewPlanResult WHERE FInterviewPlanId ='" + interviewPlanId.toString() + "'";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowset.size() > 0;
    }

    @Override
    protected void _initInterviewPlanResultStructure(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        if (this.isInitedInterviewPlanResult(ctx, interviewPlanId)) {
            return;
        }
        InterviewPlanResultInfo planResultInfo = new InterviewPlanResultInfo();
        planResultInfo.setResult(InterviewResultStatusEnum.NULL);
        planResultInfo.setHrWriteResult(false);
        planResultInfo.setInterviewPlanId(interviewPlanId.toString());
        try {
            InterviewPlanResultFactory.getLocalInstance(ctx).addnew(planResultInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException("\u521d\u59cb\u5316\u521b\u5efaInterviewPlanResult\u5931\u8d25\uff01");
        }
        IPInterviewStructureCollection struColl = IPInterviewStructureFactory.getLocalInstance(ctx).getIPInterviewStructureCollection("Select *,basicData.id,basicData.uipk,basicData.model  where interviewPlanId='" + interviewPlanId.toString() + "'");
        if (!RecDBUtils.isEmpty((IObjectCollection)struColl)) {
            Iterator struIter = struColl.iterator();
            IPInterviewStructureInfo struInfo = null;
            while (struIter.hasNext()) {
                struInfo = (IPInterviewStructureInfo)struIter.next();
                String model = struInfo.getBasicData().getModel();
                logger.error("\u521d\u59cb\u5316\u9762\u8bd5\u7ed3\u679c\u5143\u7d20\uff1a" + struInfo.getBasicData().getUipk());
                IPInterviewersCollection interColl = this.getInterviewPlanInterviewers(ctx, struInfo.getInterviewPlanId());
                this.processInterviewElementResult(ctx, model, struInfo, interColl);
            }
        }
    }

    private void addIPInterviewStructureDetailResult(Context ctx, IPInterviewStructureInfo struInfo, IPInterviewersCollection interColl) throws BOSException {
        try {
            if (interColl.size() == 0) {
                logger.error("\u5f53\u524d\u65e0\u9762\u8bd5\u5b98\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u521d\u59cb\u5316\u9762\u8bd5\u7ed3\u679c");
                return;
            }
            this.doAddInitIPInterviewStructureDetailResult(ctx, interColl, struInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void doAddInitIPInterviewStructureDetailResult(Context ctx, IPInterviewersCollection interColl, IPInterviewStructureInfo struInfo) throws BOSException {
        Iterator interIter = interColl.iterator();
        IPInterviewersInfo interInfo = null;
        CoreBaseCollection bcoll = new CoreBaseCollection();
        while (interIter.hasNext()) {
            interInfo = (IPInterviewersInfo)interIter.next();
            IPInterviewStructureDetailResultInfo resultInfo = new IPInterviewStructureDetailResultInfo();
            resultInfo.setIpIsId(struInfo.getId().toString());
            resultInfo.setInterviewerId(interInfo.getInterviewerId());
            resultInfo.setInterviewerName(interInfo.getInterviewerName());
            resultInfo.setResult("-1");
            resultInfo.setInterviewPlanId(struInfo.getInterviewPlanId());
            try {
                if (IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).exists("where interviewplanId = '" + struInfo.getInterviewPlanId() + "' and interviewerId = '" + interInfo.getInterviewerId() + "'")) continue;
                bcoll.add((CoreBaseInfo)resultInfo);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (bcoll.size() > 0) {
            try {
                IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).addnew(bcoll);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void addIPInterviewStructureDetailEvaluate(Context ctx, IPInterviewStructureInfo struInfo, IPInterviewersCollection interColl) throws BOSException {
        try {
            if (interColl.size() == 0) {
                logger.error("\u5f53\u524d\u65e0\u9762\u8bd5\u5b98\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u521d\u59cb\u5316\u9762\u8bd5\u8bc4\u4ef7\u8868");
                return;
            }
            this.doAddInitIPInterviewStructureDetailEvaluate(ctx, interColl, struInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void doAddInitIPInterviewStructureDetailEvaluate(Context ctx, IPInterviewersCollection interColl, IPInterviewStructureInfo struInfo) throws BOSException {
        Iterator interIter = interColl.iterator();
        IPInterviewersInfo interInfo = null;
        IIPInterviewStructureDetailEvaluate iipInterviewStructureDetailEvaluate = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx);
        while (interIter.hasNext()) {
            interInfo = (IPInterviewersInfo)interIter.next();
            IPInterviewStructureDetailEvaluateInfo evalInfo = new IPInterviewStructureDetailEvaluateInfo();
            evalInfo.setIpIsId(struInfo.getId().toString());
            evalInfo.setInterviewerId(interInfo.getInterviewerId());
            evalInfo.setInterviewerName(interInfo.getInterviewerName());
            evalInfo.setFileName(struInfo.getFileName());
            evalInfo.setFileCode(struInfo.getFileCode());
            evalInfo.setInterviewPlanId(struInfo.getInterviewPlanId());
            logger.error("\u521d\u59cb\u5316\u6dfb\u52a0\u9762\u8bd5\u8bc4\u4ef7\u8868 : " + evalInfo);
            try {
                if (iipInterviewStructureDetailEvaluate.exists("where interviewplanId = '" + struInfo.getInterviewPlanId() + "' and interviewerId = '" + interInfo.getInterviewerId() + "'")) continue;
                iipInterviewStructureDetailEvaluate.addnew(evalInfo);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private IPInterviewersCollection getInterviewPlanInterviewers(Context ctx, String interviewPlanId) throws BOSException {
        IPInterviewersCollection interColl = null;
        try {
            interColl = IPInterviewersFactory.getLocalInstance(ctx).getIPInterviewersCollection("where interviewPlanId = '" + interviewPlanId + "'");
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return interColl;
    }

    private void addIPInterviewStructureDetailWrite(Context ctx, IPInterviewStructureInfo struInfo) throws BOSException {
        IPInterviewStructureDetailWriteInfo writeInfo = new IPInterviewStructureDetailWriteInfo();
        writeInfo.setInterviewPlanId(struInfo.getInterviewPlanId());
        writeInfo.setIpIsId(struInfo.getId().toString());
        try {
            IIPInterviewStructureDetailWrite iWrite = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx);
            if (!iWrite.exists("where interviewPlanId='" + struInfo.getInterviewPlanId() + "'")) {
                iWrite.addnew(writeInfo);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addIPInterviewStructureDetailDiathesis(Context ctx, IPInterviewStructureInfo struInfo) throws BOSException {
        IPInterviewStructureDetailDiathesisInfo diaInfo = new IPInterviewStructureDetailDiathesisInfo();
        diaInfo.setInterviewPlanId(struInfo.getInterviewPlanId());
        diaInfo.setIpIsId(struInfo.getId().toString());
        try {
            IIPInterviewStructureDetailDiathesis iDiath = IPInterviewStructureDetailDiathesisFactory.getLocalInstance(ctx);
            if (!iDiath.exists("where interviewPlanId='" + struInfo.getInterviewPlanId() + "'")) {
                iDiath.addnew(diaInfo);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addOtherIPInterviewStructureDetail(Context ctx, IPInterviewStructureInfo struInfo, IPInterviewersCollection interColl) throws BOSException {
        try {
            String uipk = struInfo.getBasicData().getUipk();
            if (StringUtils.isEmpty((String)uipk)) {
                return;
            }
            if (interColl == null || interColl.size() == 0) {
                logger.error("\u5f53\u524d\u65e0\u9762\u8bd5\u5b98\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u521d\u59cb\u5316\uff1a" + struInfo.getBasicData().getUipk());
                return;
            }
            Iterator interIter = interColl.iterator();
            IPInterviewersInfo interInfo = null;
            CoreBaseCollection bcoll = new CoreBaseCollection();
            String entityName = struInfo.getBasicData().getModel();
            MetaDataPK metaPk = MetaDataPK.create((String)entityName);
            ICoreBase corebase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)metaPk);
            while (interIter.hasNext()) {
                interInfo = (IPInterviewersInfo)interIter.next();
                CoreBaseInfo coreBaseInfo = RecMetaUtil.getDynValueClass(ctx, entityName);
                logger.error("\u521d\u59cb\u5316\u9762\u8bd5\u5b98\uff1a" + interInfo);
                coreBaseInfo.put("interviewerid", (Object)interInfo.getInterviewerId());
                coreBaseInfo.put("interviewername", (Object)interInfo.getInterviewerName());
                coreBaseInfo.put("interviewPlanId", (Object)struInfo.getInterviewPlanId());
                coreBaseInfo.put("ipIsId", (Object)struInfo.getId().toString());
                String existsSQL = "where interviewPlanId='" + struInfo.getInterviewPlanId() + "'";
                if (corebase.exists(existsSQL = existsSQL + " and interviewerid='" + interInfo.getInterviewerId() + "'")) continue;
                bcoll.add(coreBaseInfo);
            }
            Result addnew = corebase.addnew(bcoll);
            logger.error("\u521d\u59cb\u5316\u9762\u8bd5\u5143\u7d20\u7ed3\u679c" + addnew);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Class getObjectValueClass(Context ctx, String entityName) throws BOSException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        String clazz = entityInfo.getObjectValueClass();
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Deprecated
    private CoreBaseInfo getDynValueClass(Context ctx, String entityFullName) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eoInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entityFullName));
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(null);
            info = (CoreBaseInfo)cst.newInstance(null);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private IPInterviewStructureInfo getIPInterviewStructureInfo(Context ctx, String interviewPlanId, String dataType) throws BOSException {
        IPInterviewStructureInfo struInfo = null;
        List<Object[]> datas = null;
        try {
            String sql = "SELECT FID,FName,FOrder FROM T_REC_IPInterviewStructure WHERE FInterviewPlanId = ? AND FDataId = ?";
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId, dataType});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (datas != null && !datas.isEmpty()) {
            Object[] data = datas.get(0);
            struInfo = new IPInterviewStructureInfo();
            struInfo.setId(BOSUuid.read((String)((String)data[0])));
            struInfo.setName((String)data[1]);
            Object order = data[2];
            if (order instanceof BigDecimal) {
                struInfo.setOrder(((BigDecimal)order).intValue());
            } else {
                struInfo.setOrder((Integer)order);
            }
        }
        return struInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailResults(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewStructureInfo struInfo = this.getIPInterviewStructureInfo(ctx, interviewPlanId.toString(), "iQsAAAABa8hLEul5");
        if (struInfo != null) {
            String sql = "SELECT FID,FInterviewerId,FInterviewerName,FResult,FScore,FJobGradeId,FRemark,FileName,FInterviewPlanId,FIpIsId,FSaveState FROM T_REC_IPISDetailResult WHERE FInterviewPlanId = ? and FSaveState = 0";
            IPInterviewStructureDetailResultCollection resultColl = new IPInterviewStructureDetailResultCollection();
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
                IPInterviewStructureDetailResultInfo resultInfo = null;
                while (rs.next()) {
                    resultInfo = new IPInterviewStructureDetailResultInfo();
                    resultInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    resultInfo.setIpIsId(rs.getString("FIpIsId"));
                    resultInfo.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                    resultInfo.setInterviewerId(rs.getString("FInterviewerId"));
                    resultInfo.setInterviewerName(rs.getString("FInterviewerName"));
                    resultInfo.setResult(rs.getString("FResult"));
                    resultInfo.setScore(rs.getString("FScore"));
                    resultInfo.put("jobGrade", rs.getString("FJobGradeId"));
                    resultInfo.setRemark(rs.getString("FRemark"));
                    resultInfo.setFileName(rs.getString("FileName"));
                    resultInfo.setSaveState(Integer.parseInt(rs.getString("FSaveState")));
                    resultColl.add(resultInfo);
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            struInfo.put("resultColl", (Object)resultColl);
        }
        return struInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailEvaluates(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewStructureInfo struInfo = this.getIPInterviewStructureInfo(ctx, interviewPlanId.toString(), "iQsAAAABZ4VLEul5");
        if (struInfo != null) {
            IPInterviewStructureDetailEvaluateCollection evalColl = new IPInterviewStructureDetailEvaluateCollection();
            String sql = "SELECT FID,FIpIsId,FInterviewerId,FInterviewerName,FResult,FRemark,FileName,FInterviewPlanId FROM T_REC_IPISDetailEvaluate WHERE FInterviewPlanId = ? and FSaveState = 0";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            try {
                IPInterviewStructureDetailEvaluateInfo evalInfo = null;
                while (rs.next()) {
                    evalInfo = new IPInterviewStructureDetailEvaluateInfo();
                    evalInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    evalInfo.setIpIsId(rs.getString("FIpIsId"));
                    evalInfo.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                    evalInfo.setInterviewerId(rs.getString("FInterviewerId"));
                    evalInfo.setInterviewerName(rs.getString("FInterviewerName"));
                    evalInfo.setResult(rs.getString("FResult"));
                    evalInfo.setRemark(rs.getString("FRemark"));
                    evalInfo.setFileName(rs.getString("FileName"));
                    evalColl.add(evalInfo);
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            struInfo.put("evalColl", (Object)evalColl);
        }
        return struInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailWrite(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewStructureInfo struInfo = this.getIPInterviewStructureInfo(ctx, interviewPlanId.toString(), "iQsAAAABa9VLEul5");
        if (struInfo != null) {
            String sql = "SELECT FID,FIpIsId,FResult,FileName,FInterviewPlanId FROM T_REC_IPISDetailWrite WHERE FInterviewPlanId = ?  and FSaveState = 0";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            IPInterviewStructureDetailWriteInfo writeInfo = null;
            try {
                if (rs.next()) {
                    writeInfo = new IPInterviewStructureDetailWriteInfo();
                    writeInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    writeInfo.setResult(rs.getString("FResult"));
                    writeInfo.setFileName(rs.getString("FileName"));
                    writeInfo.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            struInfo.put("writeInfo", writeInfo);
        }
        return struInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailDiathesis(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        IPInterviewStructureInfo struInfo = this.getIPInterviewStructureInfo(ctx, interviewPlanId.toString(), "iQsAAAABhFZLEul5");
        if (struInfo != null) {
            IPInterviewStructureDetailDiathesisInfo diathesisInfo = null;
            String sql = "SELECT FID,FIpIsId,FResult,FileName,FInterviewPlanId FROM T_REC_IPISDetailDiathesis WHERE FInterviewPlanId = ?  and FSaveState = 0";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
            try {
                if (rs.next()) {
                    diathesisInfo = new IPInterviewStructureDetailDiathesisInfo();
                    diathesisInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    diathesisInfo.setResult(rs.getString("FResult"));
                    diathesisInfo.setFileName(rs.getString("FileName"));
                    diathesisInfo.setInterviewPlanId(rs.getString("FInterviewPlanId"));
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            struInfo.put("diathesisInfo", diathesisInfo);
        }
        return struInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailFile(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FID,FileName,FInterviewPlanId FROM T_REC_IPISDetailFile WHERE FInterviewPlanId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString()});
        IPInterviewStructureDetailFileInfo fileInfo = null;
        try {
            if (rs.next()) {
                fileInfo = new IPInterviewStructureDetailFileInfo();
                fileInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fileInfo.setFileName(rs.getString("FileName"));
                fileInfo.setInterviewPlanId(rs.getString("FInterviewPlanId"));
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return fileInfo;
    }

    private void deleteIPInterviewStructureDetailResultByInterviewerId(Context ctx, String interviewPlanId, String[] deleteInterviewerIdAry) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String delInterId : deleteInterviewerIdAry) {
            paramsList.add(new Object[]{delInterId, interviewPlanId});
        }
        try {
            this.deleteIPInterviewStructureDetailResultByInterviewerId(ctx, interviewPlanId, paramsList);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void deleteIPInterviewStructureDetailResultByInterviewerId(Context ctx, String interviewPlanId, List<Object[]> deleteInterviewerIds) throws BOSException {
        String sql = "DELETE FROM T_REC_IPISDetailResult WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
        try {
            RecDBUtils.executeBatch(ctx, sql, deleteInterviewerIds);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void deleteIPInterviewStructureDetailEvaluateByInterviewerId(Context ctx, String interviewPlanId, String[] deleteInterviewerIdAry) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String delInterId : deleteInterviewerIdAry) {
            paramsList.add(new Object[]{delInterId, interviewPlanId});
        }
        try {
            this.deleteIPInterviewStructureDetailEvaluateByInterviewerId(ctx, interviewPlanId, paramsList);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void deleteIPInterviewStructureDetailEvaluateByInterviewerId(Context ctx, String interviewPlanId, List<Object[]> deleteInterviewerIds) throws BOSException {
        String sql = "DELETE FROM T_REC_IPISDetailEvaluate WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
        try {
            RecDBUtils.executeBatch(ctx, sql, deleteInterviewerIds);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected IObjectValue _getInterviewPlanResultFileCode(Context ctx, IObjectPK interviewPlanResultFileId) throws BOSException {
        InterviewPlanResultFilesCollection coll = InterviewPlanResultFilesFactory.getLocalInstance(ctx).getInterviewPlanResultFilesCollection(" where ID= '" + interviewPlanResultFileId.toString() + "'");
        InterviewPlanResultFilesInfo fileInfo = new InterviewPlanResultFilesInfo();
        for (int i = 0; i < coll.size(); ++i) {
            InterviewPlanResultFilesInfo interPlanInfo = coll.get(i);
            fileInfo.setFileName(interPlanInfo.getFileName());
            fileInfo.setFileCode(interPlanInfo.getFileCode());
        }
        if (coll.size() == 0) {
            throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u9762\u8bd5\u5b89\u6392\u7ed3\u679c\u9644\u4ef6\uff0cinterviewPlanResultFileId\uff1a" + interviewPlanResultFileId.toString());
        }
        return fileInfo;
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailResultCode(Context ctx, IObjectPK resultFileId, String detailFileName) throws BOSException {
        IPInterviewStructureDetailResultInfo fileInfo = new IPInterviewStructureDetailResultInfo();
        IPInterviewStructureDetailResultCollection coll = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection(" where id='" + resultFileId.toString() + "'");
        for (int i = 0; i < coll.size(); ++i) {
            IPInterviewStructureDetailResultInfo cInfo = coll.get(i);
            fileInfo.setFileName(cInfo.getTempFileName());
            if (cInfo.getTempFileName() == null) {
                fileInfo.setFileName(cInfo.getFileName());
            }
            fileInfo.setFileCode(cInfo.getTempFileCode());
            if (cInfo.getTempFileCode() != null) continue;
            fileInfo.setFileCode(cInfo.getFileCode());
        }
        return fileInfo;
    }

    @Override
    protected IObjectPK _uploadIPInterviewStructureDetailResultFile(Context ctx, IObjectValue resultInfo) throws BOSException {
        IPInterviewStructureDetailResultInfo info = (IPInterviewStructureDetailResultInfo)resultInfo;
        BOSUuid id = info.getId();
        if (id == null) {
            try {
                return IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).addnew(info);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException("\u65b0\u589e\u4e0a\u4f20\u9644\u4ef6\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        this.doUploadDetailFile(ctx, "T_REC_IPISDetailResult", info.getFileName(), info.getFileCode(), id.toString());
        return new ObjectUuidPK(id.toString());
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailEvaluateCode(Context ctx, IObjectPK detailFileId, String detailFileName) throws BOSException {
        IPInterviewStructureDetailEvaluateInfo fileInfo = new IPInterviewStructureDetailEvaluateInfo();
        IPInterviewStructureDetailEvaluateCollection coll = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).getIPInterviewStructureDetailEvaluateCollection(" where id='" + detailFileId.toString() + "'");
        for (int i = 0; i < coll.size(); ++i) {
            fileInfo = coll.get(i);
        }
        return fileInfo;
    }

    @Override
    protected IObjectPK _uploadIPInterviewStructureDetailEvaluateFile(Context ctx, IObjectValue evaluateInfo) throws BOSException {
        IPInterviewStructureDetailEvaluateInfo info = (IPInterviewStructureDetailEvaluateInfo)evaluateInfo;
        BOSUuid id = info.getId();
        if (id == null) {
            try {
                return IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).addnew(info);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException("\u65b0\u589e\u4e0a\u4f20\u9644\u4ef6\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        this.doUploadDetailFile(ctx, "T_REC_IPISDetailEvaluate", info.getFileName(), info.getFileCode(), id.toString());
        return new ObjectUuidPK(id.toString());
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailWriteCode(Context ctx, IObjectPK detailFileId, String detailFileName) throws BOSException {
        IPInterviewStructureDetailWriteInfo fileInfo = new IPInterviewStructureDetailWriteInfo();
        IPInterviewStructureDetailWriteCollection coll = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx).getIPInterviewStructureDetailWriteCollection(" where id='" + detailFileId.toString() + "'");
        for (int i = 0; i < coll.size(); ++i) {
            fileInfo = coll.get(i);
        }
        return fileInfo;
    }

    @Override
    protected void _uploadIPInterviewStructureDetailWriteFile(Context ctx, IObjectValue writeInfo) throws BOSException {
        IPInterviewStructureDetailWriteInfo info = (IPInterviewStructureDetailWriteInfo)writeInfo;
        this.doUploadDetailFile(ctx, "T_REC_IPISDetailWrite", info.getFileName(), info.getFileCode(), info.getId().toString());
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailDiathesisCode(Context ctx, IObjectPK detailFileId, String detailFileName) throws BOSException {
        IPInterviewStructureDetailDiathesisInfo fileInfo = new IPInterviewStructureDetailDiathesisInfo();
        IPInterviewStructureDetailDiathesisCollection coll = IPInterviewStructureDetailDiathesisFactory.getLocalInstance(ctx).getIPInterviewStructureDetailDiathesisCollection(" where id='" + detailFileId.toString() + "'");
        for (int i = 0; i < coll.size(); ++i) {
            fileInfo = coll.get(i);
        }
        return fileInfo;
    }

    @Override
    protected void _uploadIPInterviewStructureDetailDiathesisFile(Context ctx, IObjectValue diathesisInfo) throws BOSException {
        IPInterviewStructureDetailDiathesisInfo info = (IPInterviewStructureDetailDiathesisInfo)diathesisInfo;
        this.doUploadDetailFile(ctx, "T_REC_IPISDetailDiathesis", info.getFileName(), info.getFileCode(), info.getId().toString());
    }

    @Override
    protected IObjectValue _getIPInterviewStructureDetailFileCode(Context ctx, IObjectPK detailFileId, String detailFileName) throws BOSException {
        IPInterviewStructureDetailFileInfo fileInfo = new IPInterviewStructureDetailFileInfo();
        IPInterviewStructureDetailFileCollection coll = IPInterviewStructureDetailFileFactory.getLocalInstance(ctx).getIPInterviewStructureDetailFileCollection(" where id='" + detailFileId.toString() + "'");
        for (int i = 0; i < coll.size(); ++i) {
            fileInfo = coll.get(i);
        }
        return fileInfo;
    }

    @Override
    protected void _uploadIPInterviewStructureDetailFileFile(Context ctx, IObjectValue fileInfo) throws BOSException {
        IPInterviewStructureDetailFileInfo info = (IPInterviewStructureDetailFileInfo)fileInfo;
        this.doUploadDetailFile(ctx, "T_REC_IPISDetailFile", info.getFileName(), info.getFileCode(), info.getId().toString());
    }

    @Override
    protected IObjectPK _uploadInterviewPlanResultFile(Context ctx, IObjectValue interviewPlanResultFile) throws BOSException {
        InterviewPlanResultFilesInfo fileInfo = (InterviewPlanResultFilesInfo)interviewPlanResultFile;
        fileInfo.setStatus(PLAN_RESULT_FILE_TEMP);
        IInterviewPlanResultFiles iFiles = InterviewPlanResultFilesFactory.getLocalInstance(ctx);
        IObjectPK pk = null;
        try {
            pk = iFiles.addnew(fileInfo);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return pk;
    }

    @Override
    protected void _deleteInterviewPlanResultFile(Context ctx, IObjectPK interviewPlanResultFileId) throws BOSException {
        String sql = "UPDATE T_REC_InterviewPlanResultFiles SET FStatus = 'DELETE' WHERE FID = ? AND FStatus = 'KEEP'";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanResultFileId.toString()});
    }

    private void doUploadDetailFile(Context ctx, String table, String fileName, byte[] fileCode, String fid) throws BOSException {
        String sql = "UPDATE " + table + " SET FTempFileName=?,FTempFileCode=? WHERE FID = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fileName, fileCode, fid});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void _saveInterviewResule(Context ctx, IObjectValue interviewResult) throws BOSException {
        InterviewResultInfo resultInfo = (InterviewResultInfo)interviewResult;
        try {
            ResumeBaseRecInfo resume = resultInfo.getResumeBaseRec();
            ResumeBaseRecFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String detailStructDatas = resultInfo.getString("detailStructDatas");
        this.updateIPInterviewStructureDetailResults(ctx, detailStructDatas);
        InterviewPlanResultCollection hrResultColl = (InterviewPlanResultCollection)((Object)resultInfo.get("planResults"));
        String isPass = (String)resultInfo.get("isPass");
        this.updateInterviewPlanResult(ctx, hrResultColl, isPass);
        this.updateIsNeedHRWriteResult(ctx, (IObjectPK)new ObjectUuidPK(resultInfo.getId()), isPass);
    }

    @Override
    protected void _saveMyInterviewResultData(Context ctx, IObjectValue interviewResult) throws BOSException {
        InterviewResultInfo resultInfo = (InterviewResultInfo)interviewResult;
        String detailStructDatas = resultInfo.getString("detailStructDatas");
        try {
            if (!StringUtils.isEmpty((String)detailStructDatas)) {
                JSONArray datas = JSONArray.fromObject((Object)detailStructDatas);
                int size = datas.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject interviewStruct = datas.getJSONObject(i);
                    String entityName = interviewStruct.getString("entityName");
                    MetaDataPK metaPk = MetaDataPK.create((String)entityName);
                    ICoreBase corebase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)metaPk);
                    Class clazz = this.getObjectValueClass(ctx, entityName);
                    JSONArray interviewDatas = interviewStruct.getJSONArray("datas");
                    if (interviewDatas == null || interviewDatas.size() <= 0) continue;
                    for (int j = 0; j < interviewDatas.size(); ++j) {
                        String personId;
                        CoreBaseInfo baseInfo = (CoreBaseInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)interviewDatas.getJSONObject(j).toString(), (Class)clazz);
                        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                        String string = personId = person != null && person.getId() != null ? person.getId().toString() : "";
                        if (entityName.equals("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult") || entityName.equals("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate")) {
                            if (personId.equals(baseInfo.get("interviewerId"))) {
                                baseInfo.put("saveState", (Object)1);
                            }
                        } else {
                            baseInfo.put("saveState", (Object)1);
                        }
                        corebase.save(baseInfo);
                        this.saveAttachment(ctx, baseInfo.getString("uipk"), baseInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void updateIsNeedHRWriteResult(Context ctx, IObjectPK interviewResulId, String isPass) throws BOSException {
        String sql = "SELECT IPR.FInterviewPlanId,IPR.FResult FROM T_REC_InterviewPlan IP JOIN T_REC_InterviewPlanResult IPR ON (IP.FID = IPR.FInterviewPlanId) WHERE IP.FInterviewID = ? ORDER BY IP.FOrder";
        List<Object[]> ipResultDatas = null;
        try {
            ipResultDatas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewResulId.toString()});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        NeedHRWriteResultEnum isNeed = NeedHRWriteResultEnum.NO;
        if (!RecDBUtils.isEmpty(ipResultDatas)) {
            Object[] lastInterviewPlan = ipResultDatas.get(ipResultDatas.size() - 1);
            String lastInterviewPlanId = (String)lastInterviewPlan[0];
            String lastIpResult = (String)lastInterviewPlan[1];
            block4: for (Object[] resultData : ipResultDatas) {
                String interviewPlanId = (String)resultData[0];
                String ipResult = (String)resultData[1];
                if ("-1".equals(ipResult) || "2".equals(ipResult)) {
                    if (lastInterviewPlanId.equals(interviewPlanId)) {
                        isNeed = NeedHRWriteResultEnum.YES;
                        break;
                    }
                    List<String> interviewerResults = this.getInterviewPlanInterviewersResult(ctx, interviewPlanId);
                    if (RecDBUtils.isEmpty(interviewerResults)) {
                        isNeed = NeedHRWriteResultEnum.YES;
                        break;
                    }
                    for (String ir : interviewerResults) {
                        if ("-1".equals(ir)) continue;
                        isNeed = NeedHRWriteResultEnum.YES;
                        break block4;
                    }
                    break;
                }
                if (!"4".equals(ipResult) && !"5".equals(ipResult) && !"6".equals(ipResult)) continue;
                break;
            }
            if ("3".equals(lastIpResult) && !"true".equals(isPass)) {
                isNeed = NeedHRWriteResultEnum.YES;
            }
        }
        String currInterviewStageId = this.getCurrInterviewStageId(ctx, interviewResulId);
        try {
            sql = "UPDATE T_REC_InterviewResult SET FIsNeedHRWriteResult = ?, FCurrInterviewStageID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isNeed.getValue(), currInterviewStageId, interviewResulId.toString()});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String getCurrInterviewStageId(Context ctx, IObjectPK interviewResulId) throws BOSException {
        String currInterviewStageId = null;
        try {
            Object[] params = new Object[]{interviewResulId.toString()};
            String sql01 = "SELECT P.FID,R.FResult FROM T_REC_InterviewPlanResult R JOIN (SELECT FID,FInterviewStageName,FInviteStatus,FInterviewTime,FInterviewID,FOrder FROM T_REC_InterviewPlan WHERE FInterviewID = ?) P ON (R.FInterviewPlanId = P.FID) ORDER BY FInterviewId ASC,FOrder ASC";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql01, (Object[])params);
            while (rs.next()) {
                currInterviewStageId = rs.getString(1);
                String result = rs.getString(2);
                if ("3".equals(result)) continue;
                break;
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return currInterviewStageId;
    }

    private List<String> getInterviewPlanInterviewersResult(Context ctx, String interviewPlanId) throws BOSException {
        String sql = "SELECT FResult FROM T_REC_IPISDetailResult WHERE FInterviewPlanId = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> results = new ArrayList<String>(datas.size());
        for (Object[] data : datas) {
            results.add((String)data[0]);
        }
        return results;
    }

    private void updateResumeHeader(Context ctx, String interviewResultId, ResumeBaseRecInfo recInfo) throws BOSException {
        try {
            StringBuilder sql_01 = new StringBuilder("UPDATE T_REC_ResumeBaseRec SET FPassportNo=?");
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(recInfo.getPassportNo());
            if (!StringUtils.isEmpty((String)recInfo.getIdentityCardNo())) {
                list.add(recInfo.getIdentityCardNo());
                sql_01.append(",FIdentityCardNo=?");
                if (recInfo.getBirthday() != null) {
                    list.add(new Date(recInfo.getBirthday().getTime()));
                    sql_01.append(",FBirthday=?");
                }
                if (recInfo.getGender() != null) {
                    list.add(recInfo.getGender().getValue());
                    sql_01.append(",FGender=?");
                }
                list.add(recInfo.getAge());
                sql_01.append(",FAge=?");
                list.add(recInfo.getCurrAge());
                sql_01.append(",FCurrAge=?");
            }
            sql_01.append(" WHERE FIfSimplePerson = (SELECT FIfSimplePerson FROM T_REC_ResumeBaseRec WHERE FID = ?)");
            list.add(recInfo.getId().toString());
            DbUtil.execute((Context)ctx, (String)sql_01.toString(), (Object[])list.toArray());
            StringBuilder sql_02 = new StringBuilder("UPDATE T_REC_EnterpriseArchives SET FPassportNo=? ");
            list = new ArrayList();
            list.add(recInfo.getPassportNo());
            if (!StringUtils.isEmpty((String)recInfo.getIdentityCardNo())) {
                list.add(recInfo.getIdentityCardNo());
                sql_02.append(",FIdentityCardNo=?");
                if (recInfo.getBirthday() != null) {
                    list.add(new Date(recInfo.getBirthday().getTime()));
                    sql_02.append(",FBirthday=?");
                }
                if (recInfo.getGender() != null) {
                    list.add(recInfo.getGender().getValue());
                    sql_02.append(",FGender=?");
                }
                list.add(recInfo.getAge());
                sql_02.append(",FAge=?");
                list.add(recInfo.getCurrAge());
                sql_02.append(",FCurrAge=?");
            }
            list.add(recInfo.getId().toString());
            sql_02.append(" WHERE FUniqId = (SELECT FIfSimplePerson FROM T_REC_ResumeBaseRec WHERE FID = ?) and FState = '1'");
            DbUtil.execute((Context)ctx, (String)sql_02.toString(), (Object[])list.toArray());
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void updateInterviewPlanResult(Context ctx, InterviewPlanResultCollection hrResultColl, String isPass) throws BOSException {
        String interviewPlanId = null;
        if (!RecDBUtils.isEmpty((IObjectCollection)hrResultColl)) {
            InterviewPlanResultInfo info = null;
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            Iterator iter = hrResultColl.iterator();
            while (iter.hasNext()) {
                InterviewPlanResultCollection coll;
                info = (InterviewPlanResultInfo)iter.next();
                InterviewResultStatusEnum resultStatusEnum = info.getResult();
                String result = resultStatusEnum == null ? "-1" : resultStatusEnum.getValue();
                interviewPlanId = info.getInterviewPlanId();
                String inviteStatus = this.analyzeInterviewPlanResultStatus(result);
                this._changeInterviewInviteStatus(ctx, (IObjectPK)new ObjectUuidPK(interviewPlanId), inviteStatus);
                this.saveAttachment(ctx, "com.kingdee.shr.recuritment.InterviewResult.hrconfirm.form", (CoreBaseInfo)info);
                if (!info.isHrWriteResult() && (coll = InterviewPlanResultFactory.getLocalInstance(ctx).getInterviewPlanResultCollection("where interviewPlanId = '" + interviewPlanId + "'")).size() > 0 && !coll.get(0).getResult().getValue().equals(result)) {
                    SendInterviewMsgService.getInstance().sendInterviewPlanResult(ctx, interviewPlanId.toString(), result);
                }
                coreBaseColl.add((CoreBaseInfo)info);
            }
            try {
                InterviewPlanResultFactory.getLocalInstance(ctx).save(coreBaseColl);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (interviewPlanId != null) {
            boolean isPassInterview = true;
            boolean isRefuseInterview = false;
            String sql = "SELECT FResult FROM T_REC_InterviewPlanResult WHERE FInterviewPlanId IN (SELECT FID FROM T_REC_InterviewPlan WHERE FInterviewID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?))";
            List<Object[]> datas = null;
            try {
                datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (datas == null || datas.isEmpty()) {
                throw new BOSException("\u6570\u636e\u5f02\u5e38\uff01");
            }
            for (Object[] data : datas) {
                String rs = (String)data[0];
                if (!"3".equals(rs)) {
                    isPassInterview = false;
                }
                if (!"4".equals(rs) && !"5".equals(rs) && !"6".equals(rs)) continue;
                isRefuseInterview = true;
            }
            if (isPassInterview && "true".equals(isPass)) {
                this.passInterview(ctx, interviewPlanId);
            } else if (isRefuseInterview) {
                this.nopassInterview(ctx, interviewPlanId);
            } else {
                this.updateResumeTransactionState(ctx, 1, interviewPlanId);
                this.changeInterviewResultStatus(ctx, interviewPlanId, 0);
            }
        }
    }

    public void nopassInterview(Context ctx, String interviewPlanId) throws BOSException {
        try {
            this.changeInterviewResultStatus(ctx, interviewPlanId, 2);
            ResumeBaseRecInfo resume = this.getResumeBaseRecByIpId(ctx, interviewPlanId);
            resume.setTransactionState(TransactionStateEnum.END);
            this.updateResumeTransactionState(ctx, 2, resume);
            InterviewResultInfo interviewResult = this.getInterviewResultByInterviewPlanId(ctx, interviewPlanId);
            if (logger.isDebugEnabled()) {
                logger.debug("*******************\u6dfb\u52a0\u5e94\u8058\u8bb0\u5f55*******************");
            }
            ApplyRecordInfo applyRecord = new ApplyRecordInfo();
            applyRecord.setResumeBaseRec(resume);
            applyRecord.setInterviewResult(interviewResult);
            applyRecord.setCurrResumeState(resume.getResumeState());
            try {
                ApplyRecordFactory.getLocalInstance(ctx).addnew(applyRecord);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passInterview(Context ctx, String interviewPlanId) throws BOSException {
        this.changeInterviewResultStatus(ctx, interviewPlanId, 1);
        ResumeBaseRecInfo resume = this.getResumeBaseRecByIpId(ctx, interviewPlanId);
        RecuritmentDemandInfo recDemandInfo = resume.getRecuritmentDemand();
        String resumeId = resume.getId().toString();
        if (recDemandInfo == null) {
            throw new BOSException("\u65e0\u6cd5\u67e5\u8be2resumeBaseRec\u5bf9\u5e94\u62db\u8058\u9700\u6c42\uff0cresumeId\uff1a" + resumeId + "");
        }
        IObjectPK recApprovalId = null;
        String string = resumeId.intern();
        synchronized (string) {
            try {
                boolean exist = RecApprovalFactory.getLocalInstance(ctx).exists("where resumeBaseRec.id = '" + resumeId + "'");
                if (exist) {
                    throw new BOSException("\u9762\u8bd5\u7ed3\u679c\u901a\u8fc7\uff0c\u5df2\u7ecf\u751f\u6210\u4e86\u62a5\u6279\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
                }
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            recApprovalId = RecApprovalFactory.getLocalInstance(ctx).addnew(resumeId);
            RecWritebackDataFacadeFactory.getLocalInstance(ctx).writeBackOnce(RecDemandWritebackTypeEnum.APPROVAL, (IObjectPK)new ObjectUuidPK(recDemandInfo.getId().toString()));
        }
        if (interviewPlanId != null && recApprovalId != null) {
            RecApprovalInfo recApproval = new RecApprovalInfo();
            recApproval.setId(BOSUuid.read((String)recApprovalId.toString()));
            InterviewResultInfo interviewResult = this.getInterviewResultByInterviewPlanId(ctx, interviewPlanId);
            ApplyRecordInfo applyRecord = new ApplyRecordInfo();
            applyRecord.setResumeBaseRec(resume);
            applyRecord.setRecApproval(recApproval);
            applyRecord.setInterviewResult(interviewResult);
            applyRecord.setCurrResumeState(resume.getResumeState());
            try {
                ApplyRecordFactory.getLocalInstance(ctx).addnew(applyRecord);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u9762\u8bd5\u901a\u8fc7", "", resume);
        }
    }

    private ResumeBaseRecInfo getResumeBaseRecByIpId(Context ctx, String interviewPlanId) throws BOSException {
        ResumeBaseRecInfo resume = null;
        String sql = "SELECT FResumeBaseRecID FROM T_REC_InterviewResult WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
        try {
            ResumeBaseRecCollection recColl;
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
            if (datas != null && !datas.isEmpty()) {
                String recId = (String)datas.get(0)[0];
                IResumeBaseRec iRec = ResumeBaseRecFactory.getLocalInstance(ctx);
                recColl = iRec.getResumeBaseRecCollection("where id = '" + recId + "'");
                if (recColl == null || recColl.isEmpty()) {
                    throw new BOSException("\u65e0\u6cd5\u67e5\u8be2resumeBaseRec\uff0cId\uff1a" + recId + "");
                }
            } else {
                throw new BOSException("\u65e0\u6cd5\u67e5\u8be2interviewPlanId\uff1a" + interviewPlanId + "\u5bf9\u5e94\u5019\u9009\u4eba");
            }
            resume = recColl.get(0);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resume;
    }

    private InterviewResultInfo getInterviewResultByInterviewPlanId(Context ctx, String interviewPlanId) throws BOSException {
        InterviewResultInfo interviewResult = null;
        try {
            Object[] params = new Object[]{interviewPlanId.toString()};
            String sql01 = "select FInterviewID id  from t_rec_interviewplan where fid = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql01, (Object[])params);
            while (rs.next()) {
                String interviewId = rs.getString("id");
                interviewResult = new InterviewResultInfo();
                interviewResult.setId(BOSUuid.read((String)interviewId));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return interviewResult;
    }

    private void updateResumeTransactionState(Context ctx, int transactionState, ResumeBaseRecInfo resume) throws BOSException {
        String sql = "UPDATE T_REC_ResumeBaseRec SET FTransactionState = " + transactionState + " WHERE FID = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{resume.getId().toString()});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void updateResumeTransactionState(Context ctx, int transactionState, String interviewPlanId) throws BOSException {
        String sql = "UPDATE T_REC_ResumeBaseRec SET FTransactionState = " + transactionState + " WHERE FID = (SELECT FResumeBaseRecID FROM T_REC_InterviewResult WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?))";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void changeInterviewResultStatus(Context ctx, String interviewPlanId, int newResultStatus) throws BOSException {
        String sql;
        String resumeState = null;
        if (newResultStatus == 2) {
            sql = "SELECT R.FResult,R.FRemark FROM T_REC_InterviewPlanResult R JOIN (SELECT P1.FID,P1.FOrder FROM T_REC_InterviewPlan P1 WHERE EXISTS (SELECT 1 FROM T_REC_InterviewPlan P2 WHERE P2.FID = ? AND P1.FInterviewID = P2.FInterviewID)) P ON (R.FInterviewPlanId = P.FID) ORDER BY P.FOrder DESC";
            Object[] param = null;
            try {
                List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId});
                for (Object[] data : datas) {
                    String result = (String)data[0];
                    if ("5".equals(result)) {
                        resumeState = "VU+5LvArSJyl0JxzMmXECghd7oA=";
                        sql = "UPDATE T_REC_InterviewResult SET FResult = ?,FAbandonReason=?,FAbadonDate=? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
                        param = new Object[]{newResultStatus, data[1] == null ? "" : (String)data[1], new Date(System.currentTimeMillis()), interviewPlanId};
                    } else if ("6".equals(result)) {
                        resumeState = "/pIxPc8hTNGJcfL1aWx2jQhd7oA=";
                        sql = "UPDATE T_REC_InterviewResult SET FResult = ?,FStopReason=?,FStopDate=? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
                        param = new Object[]{newResultStatus, data[1] == null ? "" : (String)data[1], new Date(System.currentTimeMillis()), interviewPlanId};
                    } else {
                        if (!"4".equals(result)) continue;
                        resumeState = "MO4K2yScT5CDrQEDdKCXUwhd7oA=";
                        sql = "UPDATE T_REC_InterviewResult SET FResult = ? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
                        param = new Object[]{newResultStatus, interviewPlanId};
                    }
                    break;
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (param == null) {
                resumeState = "MO4K2yScT5CDrQEDdKCXUwhd7oA=";
                sql = "UPDATE T_REC_InterviewResult SET FResult = ? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
                param = new Object[]{newResultStatus, interviewPlanId};
            }
            try {
                DbUtil.execute((Context)ctx, (String)sql, param);
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        resumeState = newResultStatus == 1 ? "ih1LnVZvQRe3ESkIQbAtoQhd7oA=" : "nBqJPlDqTtu5U+jhPfGoWAhd7oA=";
        sql = "UPDATE T_REC_InterviewResult SET FResult = ? WHERE FID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{newResultStatus, interviewPlanId});
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (!StringUtils.isEmpty((String)resumeState)) {
            String resumeId = "";
            String interviewStageName = "";
            String interviewPlanResult = "";
            String sql_01 = "SELECT IR.FResumeBaseRecID,IP.FInterviewStageName,IPR.FResult FROM T_REC_InterviewResult IR left join T_REC_InterviewPlan IP ON IR.FID = IP.FInterviewID left join T_REC_InterviewPlanResult IPR ON IPR.FInterviewPlanId = IP.FID WHERE  IP.FID = ?";
            List<Object[]> datas = null;
            try {
                datas = RecDBUtils.getQueryData(ctx, sql_01, new Object[]{interviewPlanId});
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (datas == null || datas.isEmpty()) {
                throw new BOSException("\u65e0\u6cd5\u67e5\u8be2interviewPlanId\uff1a" + interviewPlanId + "\u5bf9\u5e94\u7684\u7b80\u5386");
            }
            resumeId = (String)datas.get(0)[0];
            interviewStageName = "\u3010" + (String)datas.get(0)[1] + "\u3011";
            interviewPlanResult = (String)datas.get(0)[2];
            if (logger.isDebugEnabled()) {
                logger.debug("\u9762\u8bd5\u901a\u8fc7\uff0c\u66f4\u65b0\u7b80\u5386\u62db\u8058\u72b6\u6001\uff01FResumeStateID:" + resumeState + " resumeId:" + resumeId);
            }
            String sql2 = "UPDATE T_REC_ResumeBaseRec SET FResumeStateID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{resumeState, resumeId});
            ResumeBaseRecInfo resume = new ResumeBaseRecInfo();
            resume.setId(BOSUuid.read((String)resumeId));
            if (resumeState.equals("VU+5LvArSJyl0JxzMmXECghd7oA=")) {
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, interviewStageName + "\u653e\u5f03\u9762\u8bd5", "", resume);
            } else if (resumeState.equals("/pIxPc8hTNGJcfL1aWx2jQhd7oA=")) {
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, interviewStageName + "\u7ec8\u6b62\u9762\u8bd5", "", resume);
            } else if (resumeState.equals("MO4K2yScT5CDrQEDdKCXUwhd7oA=")) {
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, interviewStageName + "\u9762\u8bd5\u4e0d\u901a\u8fc7", "", resume);
            } else if ("3".equals(interviewPlanResult)) {
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, interviewStageName + "\u9762\u8bd5\u901a\u8fc7", "", resume);
            } else {
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, interviewStageName + "\u5f85\u5b9a", "", resume);
            }
        }
    }

    public String analyzeInterviewPlanResultStatus(String resultStatus) {
        if ("2".equals(resultStatus)) {
            return "5";
        }
        if ("3".equals(resultStatus)) {
            return "6";
        }
        if ("4".equals(resultStatus)) {
            return "4";
        }
        if ("5".equals(resultStatus)) {
            return "7";
        }
        if ("6".equals(resultStatus)) {
            return "8";
        }
        return null;
    }

    private void updateIPInterviewStructureDetailResults(Context ctx, String detailStructDatas) throws BOSException {
        if (!StringUtils.isEmpty((String)detailStructDatas)) {
            try {
                JSONArray datas = JSONArray.fromObject((Object)detailStructDatas);
                int size = datas.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        JSONObject interviewStruct = datas.getJSONObject(i);
                        String entityName = interviewStruct.getString("entityName");
                        String interviewPlanId = interviewStruct.getString("interviewPlanId");
                        MetaDataPK metaPk = MetaDataPK.create((String)entityName);
                        ICoreBase corebase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)metaPk);
                        Class clazz = this.getObjectValueClass(ctx, entityName);
                        JSONArray interviewDatas = interviewStruct.getJSONArray("datas");
                        CoreBaseCollection coll = new CoreBaseCollection();
                        if (interviewDatas == null || interviewDatas.size() <= 0) continue;
                        for (int j = 0; j < interviewDatas.size(); ++j) {
                            CoreBaseInfo baseInfo = (CoreBaseInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)interviewDatas.getJSONObject(j).toString(), (Class)clazz);
                            if (entityName.equals("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult")) {
                                Date now = new Date(System.currentTimeMillis());
                                baseInfo.put("entryResultTime", (Object)now);
                            }
                            corebase.save(baseInfo);
                            this.saveAttachment(ctx, baseInfo.getString("uipk"), baseInfo);
                            this.doSaveStateData(ctx, entityName, interviewPlanId, baseInfo);
                            coll.add(baseInfo);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void doSaveStateData(Context ctx, String entityName, String interviewPlanId, CoreBaseInfo baseInfo) throws BOSException, EASBizException {
        if (entityName.equals("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult")) {
            IPInterviewStructureDetailResultInfo info = (IPInterviewStructureDetailResultInfo)baseInfo;
            int saveState = info.getSaveState();
            int updateState = saveState == 1 ? 0 : 1;
            IPInterviewStructureDetailResultCollection detailResultCollection = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where InterviewPlanId='" + interviewPlanId + "' and interviewerId='" + info.getInterviewerId() + "' and saveState = " + updateState);
            if (detailResultCollection.size() > 0) {
                IPInterviewStructureDetailResultInfo resultInfo = (IPInterviewStructureDetailResultInfo)info.clone();
                resultInfo.setId(detailResultCollection.get(0).getId());
                resultInfo.setSaveState(updateState);
                IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).save((CoreBaseInfo)resultInfo);
                AttachmentUtil.syncAttachments(ctx, baseInfo.getId().toString(), resultInfo.getId().toString());
            }
        } else if (entityName.equals("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate")) {
            int saveState;
            String skillProBg = baseInfo.getString("skillProBg");
            IPInterviewStructureDetailEvaluateInfo info = (IPInterviewStructureDetailEvaluateInfo)baseInfo;
            if (!StringUtils.isEmpty((String)skillProBg)) {
                info.setSkillproBackground(Double.valueOf(skillProBg));
            }
            int updateState = (saveState = info.getSaveState()) == 1 ? 0 : 1;
            IPInterviewStructureDetailEvaluateCollection detailResultCollection = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).getIPInterviewStructureDetailEvaluateCollection("where InterviewPlanId='" + info.getInterviewPlanId() + "' and interviewerId='" + info.getInterviewerId() + "' and saveState = " + updateState);
            if (detailResultCollection.size() > 0) {
                IPInterviewStructureDetailEvaluateInfo evaluateInfo = (IPInterviewStructureDetailEvaluateInfo)info.clone();
                evaluateInfo.setId(detailResultCollection.get(0).getId());
                evaluateInfo.setSaveState(updateState);
                IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).save((CoreBaseInfo)evaluateInfo);
                AttachmentUtil.syncAttachments(ctx, baseInfo.getId().toString(), evaluateInfo.getId().toString());
            }
        }
    }

    private void saveAttachment(Context ctx, String uipk, CoreBaseInfo model) {
        String boID = model.getId().toString();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        if (StringUtils.isEmpty((String)uipk)) {
            return;
        }
        uipk = uipk.split("\\$")[0];
        try {
            SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#" + uipk);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean _isPassInterview(Context ctx, IObjectPK interviewResultId) throws BOSException {
        String sql = "SELECT FID FROM T_REC_RecApproval WHERE FInterviewResultID = ?";
        String existSql = "SELECT FID FROM T_REC_Offer WHERE FInterviewResultID = ?";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewResultId.toString()});
            List<Object[]> dataList = RecDBUtils.getQueryData(ctx, existSql, new Object[]{interviewResultId.toString()});
            if (!RecDBUtils.isEmpty(datas) || !RecDBUtils.isEmpty(dataList)) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _canAddNewInterviewLink(Context ctx, IObjectPK interviewPlanId) throws BOSException {
        String sql = "SELECT FID FROM T_REC_RecApproval WHERE FInterviewResultID = (SELECT FInterviewID FROM T_REC_InterviewPlan WHERE FID = ?)";
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewPlanId.toString()});
            if (!RecDBUtils.isEmpty(datas)) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected IObjectCollection _getCanUseInterviewData(Context ctx) throws BOSException {
        String sql = null;
        String existsSql = " and exists (select 1 from T_REC_InterviewStageRelation where FSTATE = 100  and FBASEINFOID  = stage.FID)";
        sql = "SELECT FID,FName_l1,FName_l2,FName_l3,FDescription_l1,FDescription_l2,FDescription_l3 FROM T_REC_InterviewStage as stage WHERE FState = '1' " + existsSql + "  ORDER BY FNumber;";
        IRowSet rs = null;
        InterviewLinkCollection coll = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            coll = this.fillInterviewLinkEntity(rs, ctx);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return coll;
    }

    @Override
    protected void _saveInterviewPlan(Context ctx, IObjectValue interviewPlanInfo, String interviewer) throws BOSException {
        InterviewPlanInfo ipInfo = (InterviewPlanInfo)interviewPlanInfo;
        IPInterviewersCollection iPInterviewersColl = (IPInterviewersCollection)((Object)ipInfo.get("iPInterviewers"));
        this._addInterviewPlanInterviewers(ctx, (IObjectCollection)iPInterviewersColl);
        IInterviewInvite iInterviewInvite = InterviewInviteFactory.getLocalInstance(ctx);
        String[] interviewerarr = interviewer.split(",");
        for (int i = 0; i < interviewerarr.length; ++i) {
            Object[] p;
            IPInterviewersInfo ipinterviewer;
            ArrayList<Object[]> paramsList;
            Iterator iter;
            String sql;
            String delsql;
            String interviewerid = interviewerarr[i];
            InterviewPlanCollection ipColl = new InterviewPlanCollection();
            BOSUuid fid = BOSUuid.create((BOSObjectType)ipInfo.getBOSType());
            ipInfo.setId(fid);
            ipColl.add(ipInfo);
            InterviewPlanInfo planInfo = this.getInterviewPlan(interviewerid, ipInfo.getInterviewStageId(), ctx);
            InterviewInviteCollection iviteInfoColl = new InterviewInviteCollection();
            if (null != planInfo) {
                iviteInfoColl = iInterviewInvite.getInterviewInviteCollection("where interviewPlanId= '" + planInfo.getId() + "'");
            }
            if (iviteInfoColl.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("planInfo=:" + planInfo);
                }
                if (null == planInfo) continue;
                fid = planInfo.getId();
                delsql = "DELETE FROM T_REC_IPInterviewers WHERE finterviewplanid='" + fid + "'";
                DbUtil.execute((Context)ctx, (String)delsql);
                if (iPInterviewersColl != null && !iPInterviewersColl.isEmpty()) {
                    sql = "INSERT INTO T_REC_IPInterviewers(FID,FInterviewerId,FInterviewerName,FInterviewerCell,FInterviewerEmail,FIsInviteAdd,FInterviewPlanId) VALUES (?,?,?,?,?,?,?)";
                    iter = iPInterviewersColl.iterator();
                    paramsList = new ArrayList();
                    while (iter.hasNext()) {
                        ipinterviewer = (IPInterviewersInfo)iter.next();
                        p = new Object[]{BOSUuid.create((BOSObjectType)ipinterviewer.getBOSType()).toString(), ipinterviewer.getInterviewerId(), ipinterviewer.getInterviewerName(), ipinterviewer.getInterviewerCell(), ipinterviewer.getInterviewerEmail(), false, fid.toString()};
                        paramsList.add(p);
                    }
                    RecDBUtils.executeBatch(ctx, sql, paramsList);
                }
                this.updateInterviewPlanLinksData(ctx, ipInfo, interviewerid, planInfo);
                continue;
            }
            if (null != planInfo) {
                fid = planInfo.getId();
                this.updateInterviewPlanLinksData(ctx, ipInfo, interviewerid, planInfo);
                delsql = "DELETE FROM T_REC_IPInterviewers WHERE finterviewplanid='" + fid + "'";
                DbUtil.execute((Context)ctx, (String)delsql);
                if (iPInterviewersColl == null || iPInterviewersColl.isEmpty()) continue;
                sql = "INSERT INTO T_REC_IPInterviewers(FID,FInterviewerId,FInterviewerName,FInterviewerCell,FInterviewerEmail,FIsInviteAdd,FInterviewPlanId) VALUES (?,?,?,?,?,?,?)";
                iter = iPInterviewersColl.iterator();
                paramsList = new ArrayList();
                while (iter.hasNext()) {
                    ipinterviewer = (IPInterviewersInfo)iter.next();
                    p = new Object[]{BOSUuid.create((BOSObjectType)ipinterviewer.getBOSType()).toString(), ipinterviewer.getInterviewerId(), ipinterviewer.getInterviewerName(), ipinterviewer.getInterviewerCell(), ipinterviewer.getInterviewerEmail(), false, fid.toString()};
                    paramsList.add(p);
                }
                RecDBUtils.executeBatch(ctx, sql, paramsList);
                continue;
            }
            this._addInitInterviewPlanLinksData(ctx, (IObjectCollection)ipColl, interviewerid);
            delsql = "DELETE FROM T_REC_IPInterviewers WHERE finterviewplanid='" + fid + "'";
            DbUtil.execute((Context)ctx, (String)delsql);
            if (iPInterviewersColl == null || iPInterviewersColl.isEmpty()) continue;
            sql = "INSERT INTO T_REC_IPInterviewers(FID,FInterviewerId,FInterviewerName,FInterviewerCell,FInterviewerEmail,FIsInviteAdd,FInterviewPlanId) VALUES (?,?,?,?,?,?,?)";
            iter = iPInterviewersColl.iterator();
            paramsList = new ArrayList<Object[]>();
            while (iter.hasNext()) {
                ipinterviewer = (IPInterviewersInfo)iter.next();
                p = new Object[]{BOSUuid.create((BOSObjectType)ipinterviewer.getBOSType()).toString(), ipinterviewer.getInterviewerId(), ipinterviewer.getInterviewerName(), ipinterviewer.getInterviewerCell(), ipinterviewer.getInterviewerEmail(), false, fid.toString()};
                paramsList.add(p);
            }
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
    }

    public InterviewPlanInfo getInterviewPlan(String interviewerid, String interviewStageId, Context ctx) {
        InterviewPlanInfo info = null;
        try {
            IInterviewPlan iInterviewPlan = InterviewPlanFactory.getLocalInstance(ctx);
            InterviewPlanCollection planInfoColl = iInterviewPlan.getInterviewPlanCollection(" where interview='" + interviewerid + "' and interviewStageId ='" + interviewStageId + "'");
            if (null != planInfoColl && planInfoColl.size() > 0) {
                info = planInfoColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    protected void updateInterviewPlanLinksData(Context ctx, InterviewPlanInfo ip, String interviewer, InterviewPlanInfo planInfo) throws BOSException {
        String currInterviewStageId = ip.getInterviewStageId();
        planInfo.setInterviewSchemeName(ip.getInterviewSchemeName());
        planInfo.setLastLink(ip.isLastLink());
        planInfo.setRequisiteLink(ip.isRequisiteLink());
        planInfo.setInterviewStageId(ip.getInterviewStageId());
        planInfo.setInterviewStageName(ip.getInterviewStageName());
        planInfo.setInterviewStageDescription(StringUtils.isEmpty((String)ip.getInterviewStageDescription()) ? " " : ip.getInterviewStageDescription());
        planInfo.setInterviewStagePower(ip.getInterviewStagePower());
        planInfo.setInviteStatus(ip.getInviteStatus());
        planInfo.setInterviewTime(ip.getInterviewTime());
        planInfo.setInterviewAddress(ip.getInterviewAddress());
        planInfo.setContacterId(ip.getContacterId());
        planInfo.setContacterName(ip.getContacterName());
        planInfo.setContacterCell(ip.getContacterCell());
        planInfo.setContacterEmail(ip.getContacterEmail());
        planInfo.setInterviewArrange(ip.getInterviewArrange());
        planInfo.setInterviewMode(ip.getInterviewMode());
        planInfo.setGroupInterview(ip.isGroupInterview());
        planInfo.setAddNewLink(ip.isAddNewLink());
        planInfo.setInterviewCompany(ip.getInterviewCompany());
        planInfo.setInviteInfo(ip.getInviteInfo());
        planInfo.setPhoneHiding(ip.getPhoneHiding() == null ? "0" : ip.getPhoneHiding());
        planInfo.setAttachmentHiding(ip.getAttachmentHiding() == null ? "0" : ip.getAttachmentHiding());
        planInfo.setInfoType(ip.getInfoType());
        IInterviewPlan iInterviewPlan = null;
        try {
            iInterviewPlan = InterviewPlanFactory.getLocalInstance(ctx);
            iInterviewPlan.update((IObjectPK)new ObjectUuidPK(planInfo.getId()), planInfo);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (planInfo.getInviteStatus().equals((Object)InterviewInviteStatusEnum.ARRANGE)) {
            String sql = "";
            currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewer));
            try {
                sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID ='" + currInterviewStageId + "' WHERE FID ='" + interviewer + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void _addInitInterviewPlanLinksData(Context ctx, IObjectCollection interviewPlans, String interviewer) throws BOSException {
        InterviewPlanCollection ipColl = (InterviewPlanCollection)interviewPlans;
        if (ipColl == null || ipColl.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO T_REC_InterviewPlan(FID,FInterviewSchemeName,FOrder,FLastLink,FRequisiteLink,FInterviewStageId,FInterviewStageName,FInterviewStageDescription,FInterviewStagePower,FInviteStatus,FInterviewTime,FInterviewAddress,FContacterId,FContacterName,FContacterCell,FContacterEmail,FInterviewID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAddNewLink,FInterviewCompany,FInviteInfo) VALUES (" + RecDBUtils.getParamPlaceholder(ALLFIELD) + ")";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String creatorId = BOSUuid.read((String)ctx.getCaller().toString()).toString();
        Date createTime = new Date(System.currentTimeMillis());
        String lastUpdateUserId = creatorId;
        Date lastUpdateTime = createTime;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        Iterator iter = ipColl.iterator();
        IIPInterviewStructure iIpIs = IPInterviewStructureFactory.getLocalInstance(ctx);
        String interviewPlanId = null;
        String currInterviewStageId = "";
        while (iter.hasNext()) {
            String ipId;
            InterviewPlanInfo ip = (InterviewPlanInfo)iter.next();
            interviewPlanId = ipId = ip.getId().toString();
            String interviewStatus = null;
            interviewStatus = ip.getInviteStatus() == null ? "1" : ip.getInviteStatus().getValue();
            currInterviewStageId = ip.getInterviewStageId();
            Object[] params = new Object[]{ipId, ip.getInterviewSchemeName(), ip.getOrder(), ip.isLastLink(), ip.isRequisiteLink(), ip.getInterviewStageId(), ip.getInterviewStageName(), StringUtils.isEmpty((String)ip.getInterviewStageDescription()) ? " " : ip.getInterviewStageDescription(), ip.getInterviewStagePower(), interviewStatus, ip.getInterviewTime(), ip.getInterviewAddress(), ip.getContacterId(), ip.getContacterName(), ip.getContacterCell(), ip.getContacterEmail(), interviewer, creatorId, createTime, lastUpdateUserId, lastUpdateTime, cuId, ip.isAddNewLink(), ip.getInterviewCompany(), ip.getInviteInfo()};
            paramsList.add(params);
            this._initInterviewPlanResultStructure(ctx, (IObjectPK)new ObjectUuidPK(ipId));
        }
        RecDBUtils.executeBatch(ctx, sql, paramsList);
        if (interviewPlanId != null) {
            currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewer));
            try {
                sql = "UPDATE T_REC_InterviewResult SET FCurrInterviewStageID ='" + currInterviewStageId + "' WHERE FID ='" + interviewer + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void _addInitInterviewPlanBatchLinksData(Context ctx, InterviewPlanInfo ip, String interviewer, String stepStage) throws BOSException {
        String ipId = ip.getId().toString();
        ip.setSendType(InterviewerTypeEnum.INVITE);
        InterviewResultInfo resultInfo = new InterviewResultInfo();
        resultInfo.setId(BOSUuid.read((String)interviewer));
        ip.setInterview(resultInfo);
        ip.setInterviewStageDescription(StringUtils.isEmpty((String)ip.getInterviewStageName()) ? " " : ip.getInterviewStageName());
        ip.setInterviewStagePower("1");
        ip.setInviteStatus(InterviewInviteStatusEnum.ARRANGE);
        InterviewStageCollection stageColl = InterviewStageFactory.getLocalInstance(ctx).getInterviewStageCollection(" where id='" + ip.getInterviewStageId() + "'");
        if (null != stageColl && stageColl.size() > 0) {
            InterviewStageInfo stageInfo = stageColl.get(0);
            int number = Integer.parseInt(stageInfo.getNumber());
            ip.setOrder(number);
        }
        JSONArray stepStageArr = null;
        CoreBaseCollection coreColl = new CoreBaseCollection();
        if (null != stepStage && !"".equals(stepStage)) {
            stepStageArr = JSONArray.fromObject((Object)stepStage);
            for (int h = 0; h < stepStageArr.size(); ++h) {
                JSONObject obj = stepStageArr.getJSONObject(h);
                JSONArray isarray = (JSONArray)obj.get("is");
                if (!interviewer.equals(obj.get("id"))) continue;
                for (int f = 0; f < isarray.size(); ++f) {
                    JSONObject isObj = isarray.getJSONObject(f);
                    IPInterviewStructureInfo struct = new IPInterviewStructureInfo();
                    struct.setOrder(isObj.getInt("order"));
                    struct.put("basicData", isObj.getString("dataId"));
                    struct.setName(isObj.getString("name"));
                    struct.setInterviewPlanId(ipId);
                    coreColl.add((CoreBaseInfo)struct);
                }
            }
        }
        try {
            InterviewPlanFactory.getLocalInstance(ctx).addnew((IObjectPK)new ObjectUuidPK(ipId), ip);
            if (coreColl.size() > 0) {
                IPInterviewStructureFactory.getLocalInstance(ctx).addnew(coreColl);
            }
        }
        catch (EASBizException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new BOSException("\u65b0\u589e\u9762\u8bd5\u5b89\u6392\u5931\u8d25!");
        }
        this._initInterviewPlanResultStructure(ctx, (IObjectPK)new ObjectUuidPK(ipId));
        String currInterviewStageId = this.getCurrInterviewStageId(ctx, (IObjectPK)new ObjectUuidPK(interviewer));
        if (StringUtils.isEmpty((String)currInterviewStageId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("currInterviewStageId:" + currInterviewStageId);
            }
            throw new BOSException("\u6570\u636e\u5f02\u5e38,\u65b0\u589e\u9762\u8bd5\u5b89\u6392\u5931\u8d25!");
        }
        String sql = "update T_REC_InterviewResult set FCurrInterviewStageID='" + currInterviewStageId + "' where fid='" + interviewer + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public void deleteInterviewer(Context ctx, String fid) throws BOSException {
        try {
            IPInterviewersFactory.getLocalInstance(ctx).delete("where interviewplanid='" + fid + "'");
            IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).delete("where interviewplanid='" + fid + "'");
            IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx).delete("where interviewplanId='" + fid + "'");
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addInterviewer(Context ctx, IPInterviewersCollection iPInterviewersColl, String fid) throws BOSException {
        Iterator iter = iPInterviewersColl.iterator();
        IPInterviewersInfo interviewInfo = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        while (iter.hasNext()) {
            IPInterviewersInfo ipinterviewer = (IPInterviewersInfo)iter.next();
            interviewInfo = new IPInterviewersInfo();
            interviewInfo.setId(BOSUuid.create((BOSObjectType)ipinterviewer.getBOSType()));
            interviewInfo.setInterviewerId(ipinterviewer.getInterviewerId());
            interviewInfo.setInterviewerName(ipinterviewer.getInterviewerName());
            interviewInfo.setInterviewerCell(ipinterviewer.getInterviewerCell());
            interviewInfo.setInterviewerEmail(ipinterviewer.getInterviewerEmail());
            interviewInfo.setIsInviteAdd(false);
            interviewInfo.setInterviewPlanId(fid);
            colls.add((CoreBaseInfo)interviewInfo);
        }
        try {
            IPInterviewersFactory.getLocalInstance(ctx).addnew(colls);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String _saveInterviewPlanBatch(Context ctx, IObjectValue interviewPlanInfo, IObjectCollection interviewer, String stepStage) throws BOSException {
        InterviewPlanInfo ipInfo = (InterviewPlanInfo)interviewPlanInfo;
        InterviewPlanCollection interviewColl = (InterviewPlanCollection)interviewer;
        String planid = "";
        String videoInterviewType = ipInfo.getString("videoInterviewType");
        int waitingRoomType = ipInfo.get("waitingRoomType") == null ? 0 : (Integer)ipInfo.get("waitingRoomType");
        for (int i = 0; i < interviewColl.size(); ++i) {
            InterviewPlanInfo interviewerInfo = interviewColl.get(i);
            BOSUuid fid = BOSUuid.create((BOSObjectType)ipInfo.getBOSType());
            IPInterviewersCollection iPInterviewersColl = (IPInterviewersCollection)((Object)interviewerInfo.get("iPInterviewers"));
            interviewerInfo.setContacterId(ipInfo.getContacterId());
            interviewerInfo.setContacterName(ipInfo.getContacterName());
            interviewerInfo.setContacterCell(ipInfo.getContacterCell());
            interviewerInfo.setContacterEmail(ipInfo.getContacterEmail());
            interviewerInfo.setInterviewCompany(ipInfo.getInterviewCompany());
            interviewerInfo.setInviteInfo(ipInfo.getInviteInfo());
            interviewerInfo.setGroupInterview(ipInfo.isGroupInterview());
            interviewerInfo.setInfoType(ipInfo.getInfoType());
            interviewerInfo.setSendType(ipInfo.getSendType());
            interviewerInfo.setInviteStatus(ipInfo.getInviteStatus());
            interviewerInfo.setInterviewMode(ipInfo.getInterviewMode());
            interviewerInfo.setPhoneHiding(ipInfo.getPhoneHiding());
            interviewerInfo.setAttachmentHiding(ipInfo.getAttachmentHiding());
            interviewerInfo.setId(fid);
            String interviewerid = interviewerInfo.getInterview().getId().toString();
            InterviewPlanInfo planInfo = this.getInterviewPlan(interviewerid, interviewerInfo.getInterviewStageId(), ctx);
            if (null != planInfo) {
                interviewerInfo.setInterviewSchemeName(planInfo.getInterviewSchemeName());
                interviewerInfo.setRequisiteLink(planInfo.isRequisiteLink());
                interviewerInfo.setLastLink(planInfo.isLastLink());
                interviewerInfo.setInterviewStagePower(planInfo.getInterviewStagePower());
            } else {
                interviewerInfo.setInterviewSchemeName("_custom");
                interviewerInfo.setRequisiteLink(false);
                interviewerInfo.setInterviewStagePower("3");
            }
            if (null != planInfo) {
                fid = planInfo.getId();
                this.deleteInterviewer(ctx, fid.toString());
                this.addInterviewer(ctx, iPInterviewersColl, fid.toString());
                this.updateInterviewPlanLinksData(ctx, interviewerInfo, interviewerid, planInfo);
                this.setInterviewStruct(fid.toString(), ctx, iPInterviewersColl);
            } else {
                this._addInitInterviewPlanBatchLinksData(ctx, interviewerInfo, interviewerid, stepStage);
                this._addInterviewPlanInterviewers(ctx, (IObjectCollection)iPInterviewersColl);
            }
            String sql = "update T_REC_ResumeBaseRec set fresumestateid='nBqJPlDqTtu5U+jhPfGoWAhd7oA='  where fresumestateid = '4g/wx+gNTQOkEcKX5GB4kwhd7oA=' and fid =(select FRESUMEBASERECID  from T_REC_InterviewResult where fid ='" + interviewerid + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            this.setVidoInterview(ctx, interviewerInfo, fid.toString(), videoInterviewType, waitingRoomType);
            planid = planid + fid.toString() + ";";
        }
        return planid;
    }

    private void setVidoInterview(Context ctx, InterviewPlanInfo interviewerInfo, String interviewplanId, String videoInterviewType, int waitRoom) {
        VideoInterviewType type = VideoInterviewType.getEnum(videoInterviewType);
        if (type == null) {
            return;
        }
        VideoInterviewConfigInfo coninfo = new VideoInterviewConfigInfo();
        if (interviewerInfo.getVideoInterConfig() != null && !StringUtils.isEmpty((String)interviewerInfo.getVideoInterConfig().getUserId())) {
            coninfo.setUserId(interviewerInfo.getVideoInterConfig().getUserId());
            coninfo.setUserName(interviewerInfo.getVideoInterConfig().getUserName());
        } else {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            coninfo.setUserId(userInfo.getNumber());
            coninfo.setUserName(userInfo.getName());
        }
        coninfo.setInterviewplanId(interviewplanId);
        if (waitRoom == 2) {
            coninfo.setWaitingRoom(true);
        } else {
            coninfo.setWaitingRoom(false);
        }
        coninfo.setVideoType(type);
        try {
            VideoInterviewConfigFactory.getLocalInstance(ctx).delete(" where interviewplanId='" + coninfo.getInterviewplanId() + "'");
            IObjectPK objpk = VideoInterviewConfigFactory.getLocalInstance(ctx).addnew(coninfo);
            String sql = "update t_rec_interviewplan set FVideoInterConfigID='" + objpk.toString() + "' where fid='" + coninfo.getInterviewplanId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setInterviewStruct(String interviewPlanId, Context ctx, IPInterviewersCollection interviewers) throws BOSException {
        IObjectValue result;
        if (interviewPlanId != null && (result = this._getInterviewPlanResult(ctx, (IObjectPK)new ObjectUuidPK(interviewPlanId))) != null) {
            IIPInterviewStructure iStru = IPInterviewStructureFactory.getLocalInstance(ctx);
            IPInterviewStructureCollection structureCollection = iStru.getIPInterviewStructureCollection("select *,basicData.uipk,basicData.model where interviewPlanId = '" + interviewPlanId + "' ");
            for (int i = 0; i < structureCollection.size(); ++i) {
                IPInterviewStructureInfo struInfo = structureCollection.get(i);
                String model = struInfo.getBasicData().getModel();
                this.processInterviewElementResult(ctx, model, struInfo, interviewers);
            }
        }
    }

    @Override
    protected IObjectPK _addInterviewer(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        IObjectPK IPSDetailResultId = null;
        try {
            boolean interviewerExist = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).exists("where interviewPlanId ='" + interviewPlanId + "' and interviewerId = '" + interviewerId + "'");
            if (interviewerExist) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" interviewPlanId ='" + interviewPlanId + "' and interviewerId = '" + interviewerId + "\u60a8\u5df2\u7ecf\u662f\u8be5\u5019\u9009\u4eba\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u52ff\u91cd\u590d\u63a5\u6536\uff01");
                }
                throw new BOSException("\u60a8\u5df2\u7ecf\u662f\u8be5\u5019\u9009\u4eba\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u52ff\u91cd\u590d\u63a5\u6536\uff01");
            }
            IPInterviewersInfo interviewer = new IPInterviewersInfo();
            IPInterviewersCollection interColl = new IPInterviewersCollection();
            interColl.add(interviewer);
            PersonInfo person = null;
            person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(interviewerId);
            if (person == null) {
                throw new BOSException("\u67e5\u627e\u4e0d\u5230ID\u4e3a" + interviewerId + "\u6dfb\u52a0\u7684\u9762\u8bd5\u5b98\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            interviewer.setInterviewerId(person.getId().toString());
            interviewer.setInterviewerName(person.getName());
            interviewer.setInterviewerEmail(person.getEmail());
            interviewer.setInterviewerCell(person.getCell());
            interviewer.setIsInviteAdd(false);
            interviewer.setInterviewPlanId(interviewPlanId.toString());
            IIPInterviewStructure iStru = IPInterviewStructureFactory.getLocalInstance(ctx);
            IPInterviewStructureCollection struColl = iStru.getIPInterviewStructureCollection("where basicData.model = 'com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult' and interviewPlanId = '" + interviewPlanId + "'");
            if (!RecDBUtils.isEmpty((IObjectCollection)struColl)) {
                IPInterviewStructureInfo struInfo = struColl.get(0);
                IPInterviewStructureDetailResultInfo resultInfo = new IPInterviewStructureDetailResultInfo();
                resultInfo.setIpIsId(struInfo.getId().toString());
                resultInfo.setInterviewerId(interviewer.getInterviewerId());
                resultInfo.setInterviewerName(interviewer.getInterviewerName());
                resultInfo.setResult("-1");
                resultInfo.setInterviewPlanId(struInfo.getInterviewPlanId());
                IPSDetailResultId = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).addnew(resultInfo);
            }
            if (!RecDBUtils.isEmpty((IObjectCollection)(struColl = iStru.getIPInterviewStructureCollection("where basicData.model = 'com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate' and interviewPlanId = '" + interviewPlanId + "' and basicData.elementOperator = 1")))) {
                this.doAddInitIPInterviewStructureDetailEvaluate(ctx, interColl, struColl.get(0));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return IPSDetailResultId;
    }

    @Override
    protected void _deleteInterviewer(Context ctx, IObjectPK interviewPlanId, IObjectPK interviewerId) throws BOSException {
        try {
            boolean interviewerExist = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).exists("where interviewPlanId ='" + interviewPlanId + "' and interviewerId = '" + interviewerId + "'");
            if (!interviewerExist) {
                throw new BOSException("\u60a8\u5df2\u7ecf\u53d6\u6d88\u8be5\u9762\u8bd5\u5b98\u7684\u9762\u8bd5\uff0c\u8bf7\u52ff\u91cd\u590d\u53d6\u6d88\uff01");
            }
            String sql = "DELETE FROM T_REC_IPInterviewers WHERE FInterviewPlanId = ? AND FInterviewerId = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interviewPlanId.toString(), interviewerId.toString()});
            String sql_01 = "DELETE FROM T_REC_IPISDetailResult WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
            DbUtil.execute((Context)ctx, (String)sql_01, (Object[])new Object[]{interviewerId.toString(), interviewPlanId.toString()});
            String sql_02 = "DELETE FROM T_REC_IPISDetailEvaluate WHERE FInterviewerId = ? AND FInterviewPlanId = ?";
            DbUtil.execute((Context)ctx, (String)sql_02, (Object[])new Object[]{interviewPlanId.toString(), interviewerId.toString()});
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

