/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailDiathesis;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailEvaluate;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailResult;
import com.kingdee.shr.recuritment.IIPInterviewStructureDetailWrite;
import com.kingdee.shr.recuritment.IInterviewPlanResultFiles;
import com.kingdee.shr.recuritment.IInterviewResult;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteInfo;
import com.kingdee.shr.recuritment.InterviewPlanResultFilesFactory;
import com.kingdee.shr.recuritment.InterviewPlanResultFilesInfo;
import com.kingdee.shr.recuritment.InterviewResultCollection;
import com.kingdee.shr.recuritment.InterviewResultEnum;
import com.kingdee.shr.recuritment.InterviewResultFactory;
import com.kingdee.shr.recuritment.InterviewResultInfo;
import com.kingdee.shr.recuritment.ResumePhotoInfo;
import com.kingdee.shr.recuritment.app.AbstractInterviewResultControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InterviewResultControllerBean
extends AbstractInterviewResultControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewResultControllerBean");

    @Override
    protected int _getCandidateType(Context ctx, IObjectPK interviewResultId) throws BOSException {
        String sql = "SELECT FCandidateType FROM T_REC_InterviewResult WHERE FID = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewResultId.toString()});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Integer candidateType = null;
        if (datas != null && !datas.isEmpty()) {
            Object candidateTypeObj = datas.get(0)[0];
            candidateType = candidateTypeObj instanceof BigDecimal ? Integer.valueOf(((BigDecimal)candidateTypeObj).intValue()) : (Integer)candidateTypeObj;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u9762\u8bd5\u7ed3\u679c\u6570\u636e\u96c6\u4e2d\u4e0d\u5b58\u5728id\u4e3a\uff1a'" + interviewResultId.toString() + "'\u7684\u6570\u636e"));
            }
            throw new BOSException("\u9762\u8bd5\u7ed3\u679c\u6570\u636e\u96c6\u4e2d\u4e0d\u5b58\u5728id\u4e3a\uff1a'" + interviewResultId.toString() + "'\u7684\u6570\u636e");
        }
        if (candidateType == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u9762\u8bd5\u7ed3\u679c\u6570\u636e\u96c6\u4e2did\u4e3a\uff1a'" + interviewResultId.toString() + "'\u7684\u6570\u636e\u5019\u9009\u4eba\u7c7b\u578b\u4e3anull"));
            }
            return -1;
        }
        return candidateType;
    }

    @Override
    protected IObjectValue _getResumePhoto(Context ctx, IObjectPK interviewResultId) throws BOSException {
        String sql = "SELECT FImageDate,FImageContentType FROM T_REC_ResumePhoto WHERE FResumeBaseRecID = (SELECT FResumeBaseRecID FROM T_REC_InterviewResult WHERE FID = ?)";
        ResumePhotoInfo photo = null;
        try {
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{interviewResultId.toString()});
            if (datas != null && !datas.isEmpty()) {
                Object[] data = datas.get(0);
                SerialBlob blob = (SerialBlob)data[0];
                if (blob == null) {
                    throw new BOSException("\u83b7\u53d6\u5934\u50cf\u6570\u636e\u5931\u8d25\uff0c\u5934\u50cf\u6570\u636e\u4e22\u5931\uff01");
                }
                byte[] imageData = RecDBUtils.serialBlobToByteAry(blob);
                String imageContentType = (String)data[1];
                photo = new ResumePhotoInfo();
                photo.setImageData(imageData);
                photo.setImageContentType(imageContentType);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return photo;
    }

    @Override
    protected boolean _checkCanForwardDept(Context ctx, IObjectPK interviewResultId) throws BOSException {
        IInterviewResult iResult = InterviewResultFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)interviewResultId.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("result"));
        boolean canForwardDept = false;
        InterviewResultCollection resultColl = iResult.getInterviewResultCollection(evi);
        if (resultColl != null && !resultColl.isEmpty()) {
            InterviewResultInfo info = resultColl.get(0);
            InterviewResultEnum rs = info.getResult();
            if (rs != null && InterviewResultEnum.NOTPASS.equals((Object)rs)) {
                canForwardDept = true;
            }
        } else {
            throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u5230\u9762\u8bd5\u7ed3\u679c\u4fe1\u606f\uff0cinterviewResultId\uff1a" + interviewResultId.toString());
        }
        return canForwardDept;
    }

    @Override
    protected void _updateOldInterviewData(Context ctx) {
        byte[] fileCode;
        String fileName;
        ObjectBaseInfo info;
        int i;
        int length;
        AbstractObjectCollection coll;
        try {
            IIPInterviewStructureDetailResult iIPInterviewStructureDetailResult = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx);
            coll = iIPInterviewStructureDetailResult.getIPInterviewStructureDetailResultCollection("select id,fileName,fileCode where fileName is not null");
            if (coll.size() > 0) {
                length = coll.size();
                for (i = 0; i < length; ++i) {
                    info = coll.get(i);
                    fileName = info.getFileName();
                    fileCode = info.getFileCode();
                    if (!StringUtils.isEmpty((CharSequence)fileName) && fileCode.length > 1) {
                        this.saveInterviewFile(ctx, info.getId().toString(), fileName, fileCode);
                    }
                    info.setFileName(null);
                    info.setFileCode(null);
                    iIPInterviewStructureDetailResult.update((IObjectPK)new ObjectUuidPK(info.getId()), (IPInterviewStructureDetailResultInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            IInterviewPlanResultFiles iInterviewPlanResultFiles = InterviewPlanResultFilesFactory.getLocalInstance(ctx);
            coll = iInterviewPlanResultFiles.getInterviewPlanResultFilesCollection("select interviewPlanResultId,fileName,fileCode where fileName is not null");
            if (coll.size() > 0) {
                length = coll.size();
                for (i = 0; i < length; ++i) {
                    info = coll.get(i);
                    fileName = info.getFileName();
                    fileCode = info.getFileCode();
                    if (!StringUtils.isEmpty((CharSequence)fileName) && fileCode.length > 1) {
                        this.saveInterviewFile(ctx, info.getInterviewPlanResultId(), fileName, fileCode);
                    }
                    info.setFileName(null);
                    info.setFileCode(null);
                    iInterviewPlanResultFiles.update((IObjectPK)new ObjectUuidPK(info.getId()), (InterviewPlanResultFilesInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            IIPInterviewStructureDetailEvaluate iIPInterviewStructureDetailEvaluate = IPInterviewStructureDetailEvaluateFactory.getLocalInstance(ctx);
            coll = iIPInterviewStructureDetailEvaluate.getIPInterviewStructureDetailEvaluateCollection("select id,fileName,fileCode where fileName is not null");
            if (coll.size() > 0) {
                length = coll.size();
                for (i = 0; i < length; ++i) {
                    info = coll.get(i);
                    fileName = info.getFileName();
                    fileCode = info.getFileCode();
                    if (!StringUtils.isEmpty((CharSequence)fileName) && fileCode.length > 1) {
                        this.saveInterviewFile(ctx, info.getId().toString(), fileName, fileCode);
                    }
                    info.setFileName(null);
                    info.setFileCode(null);
                    iIPInterviewStructureDetailEvaluate.update((IObjectPK)new ObjectUuidPK(info.getId()), (IPInterviewStructureDetailEvaluateInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            IIPInterviewStructureDetailWrite iIPInterviewStructureDetailWrite = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx);
            coll = iIPInterviewStructureDetailWrite.getIPInterviewStructureDetailWriteCollection("select id,fileName,fileCode where fileName is not null");
            if (coll.size() > 0) {
                length = coll.size();
                for (i = 0; i < length; ++i) {
                    info = coll.get(i);
                    fileName = info.getFileName();
                    fileCode = info.getFileCode();
                    if (!StringUtils.isEmpty((CharSequence)fileName) && fileCode.length > 1) {
                        this.saveInterviewFile(ctx, info.getId().toString(), fileName, fileCode);
                    }
                    info.setFileName(null);
                    info.setFileCode(null);
                    iIPInterviewStructureDetailWrite.update((IObjectPK)new ObjectUuidPK(info.getId()), (IPInterviewStructureDetailWriteInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            IIPInterviewStructureDetailDiathesis iIPInterviewStructureDetailDiathesis = IPInterviewStructureDetailDiathesisFactory.getLocalInstance(ctx);
            coll = iIPInterviewStructureDetailDiathesis.getIPInterviewStructureDetailDiathesisCollection("select id,fileName,fileCode where fileName is not null");
            if (coll.size() > 0) {
                length = coll.size();
                for (i = 0; i < length; ++i) {
                    info = coll.get(i);
                    fileName = info.getFileName();
                    fileCode = info.getFileCode();
                    if (!StringUtils.isEmpty((CharSequence)fileName) && fileCode.length > 1) {
                        this.saveInterviewFile(ctx, info.getId().toString(), fileName, fileCode);
                    }
                    info.setFileName(null);
                    info.setFileCode(null);
                    iIPInterviewStructureDetailDiathesis.update((IObjectPK)new ObjectUuidPK(info.getId()), (IPInterviewStructureDetailDiathesisInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveInterviewFile(Context ctx, String boID, String fileName, byte[] fileCode) {
        int fileSize = fileCode.length;
        if (fileSize <= 1) {
            return;
        }
        try {
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setFile(fileCode);
            attachmentInfo.setName(fileName.substring(0, fileName.lastIndexOf(".")));
            attachmentInfo.setSimpleName(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
            attachmentInfo.setSize(fileSize / 1024 + "KB");
            attachmentInfo.setSizeInByte(fileSize);
            attachmentInfo.setAttachID(String.valueOf(System.currentTimeMillis()));
            attachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
            IObjectPK attchId = AttachmentFactory.getLocalInstance((Context)ctx).addnew(attachmentInfo);
            attachmentInfo.setId(BOSUuid.read((String)attchId.toString()));
            SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
            attchExt.setAttachment(attachmentInfo);
            attchExt.setName(attachmentInfo.getName());
            attchExt.setPropertyName("null0");
            attchExt.setType(AttachmentTypeEnum.FORM);
            attchExt.setState(AttachmentState.SAVE);
            attchExt.setBoID(boID);
            SHRAttachmentExtFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)attchExt);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

