/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.shr.recuritment.InterviewStructureCollection;
import com.kingdee.shr.recuritment.InterviewStructureFactory;
import com.kingdee.shr.recuritment.InterviewStructureInfo;
import com.kingdee.shr.recuritment.InterviewStructureModifyLogCollection;
import com.kingdee.shr.recuritment.InterviewStructureModifyLogFactory;
import com.kingdee.shr.recuritment.app.AbstractInterviewStructureControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecMetaUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InterviewStructureControllerBean
extends AbstractInterviewStructureControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.InterviewStructureControllerBean");

    @Override
    protected IObjectCollection _getStructuresWithIlIds(Context ctx, String ilIds) throws BOSException {
        this._removeUploadTemp(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("basicData.name"));
        view.getSelector().add(new SelectorItemInfo("basicData.uipk"));
        filter.getFilterItems().add(new FilterItemInfo("ilId", new HashSet(Arrays.asList((Object[])ilIds.split(","))), CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sort1 = new SorterItemInfo("ilId");
        sort1.setSortType(SortType.ASCEND);
        SorterItemInfo sort2 = new SorterItemInfo("ORDER");
        sort1.setSortType(SortType.ASCEND);
        view.getSorter().add(sort1);
        view.getSorter().add(sort2);
        InterviewStructureCollection coll = InterviewStructureFactory.getLocalInstance(ctx).getInterviewStructureCollection(view);
        return coll;
    }

    @Override
    protected IObjectCollection _getStructureAndFilesWithIlIds(Context ctx, String ilIds) throws BOSException {
        this._removeUploadTemp(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ilId", new HashSet(Arrays.asList((Object[])ilIds.split(","))), CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sort1 = new SorterItemInfo("ilId");
        sort1.setSortType(SortType.ASCEND);
        SorterItemInfo sort2 = new SorterItemInfo("ORDER");
        sort1.setSortType(SortType.ASCEND);
        view.getSorter().add(sort1);
        view.getSorter().add(sort2);
        InterviewStructureCollection coll = InterviewStructureFactory.getLocalInstance(ctx).getInterviewStructureCollection(view);
        return coll;
    }

    @Override
    protected void _saveData(Context ctx, IObjectValue saveDataInfo) throws BOSException {
        InterviewStructureModifyLogCollection logData;
        String deleteStr;
        InterviewStructureCollection modifyData;
        InterviewStructureCollection addData = (InterviewStructureCollection)((Object)saveDataInfo.get("addData"));
        if (!RecDBUtils.isEmpty((IObjectCollection)addData)) {
            this._addMoreStructures(ctx, (IObjectCollection)addData);
        }
        if (!RecDBUtils.isEmpty((IObjectCollection)(modifyData = (InterviewStructureCollection)((Object)saveDataInfo.get("modifyData"))))) {
            this._modifyStructures(ctx, (IObjectCollection)modifyData);
        }
        if (!RecDBUtils.isEmpty(deleteStr = (String)saveDataInfo.get("deleteStr"))) {
            this._deleteStructures(ctx, deleteStr);
        }
        if (!RecDBUtils.isEmpty((IObjectCollection)(logData = (InterviewStructureModifyLogCollection)((Object)saveDataInfo.get("logData"))))) {
            InterviewStructureModifyLogFactory.getLocalInstance(ctx).addMoreModifyLogInfo(logData);
        }
        try {
            this.saveKeepFile(ctx);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this._removeUploadTemp(ctx);
    }

    private void saveKeepFile(Context ctx) throws BOSException, SQLException, IOException {
        String sql = "SELECT FileNameTemp,FileCodeTemp,FID from T_REC_InterviewStructure WHERE FileNameTemp IS NOT NULL";
        List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, null);
        ArrayList<Object[]> listParams = new ArrayList<Object[]>(datas.size());
        if (!RecDBUtils.isEmpty(datas)) {
            for (int i = 0; i < datas.size(); ++i) {
                Object[] data = datas.get(i);
                Object[] params = new Object[data.length];
                for (int j = 0; j < data.length; ++j) {
                    params[j] = j == 1 ? (Object)RecDBUtils.serialBlobToByteAry((SerialBlob)data[j]) : data[j];
                }
                listParams.add(params);
            }
            sql = "UPDATE T_REC_InterviewStructure SET FileName=?,FileCode=?,FileNameTemp=NULL,FileCodeTemp=NULL WHERE FID = ?";
            RecDBUtils.executeBatch(ctx, sql, listParams);
        }
    }

    @Override
    protected void _addStructureAndFile(Context ctx, IObjectValue structureInfo) throws BOSException {
        try {
            if (structureInfo != null) {
                InterviewStructureFactory.getLocalInstance(ctx).addnew((InterviewStructureInfo)structureInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _addMoreStructureAndFile(Context ctx, IObjectCollection interviewStructureDatas) throws BOSException {
        try {
            if (interviewStructureDatas != null && interviewStructureDatas.size() > 0) {
                InterviewStructureFactory.getLocalInstance(ctx).addnew(RecDBUtils.entityCollectionToCoreBaseCollection(interviewStructureDatas));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _addMoreStructures(Context ctx, IObjectCollection interviewStructures) throws BOSException {
        try {
            if (interviewStructures != null && interviewStructures.size() > 0) {
                CoreBaseCollection baseCollection = RecDBUtils.entityCollectionToCoreBaseCollection(interviewStructures);
                String res = RecMetaUtil.validateCollection(ctx, baseCollection);
                if (StringUtils.isNotEmpty((CharSequence)res)) {
                    logger.error((Object)("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + res));
                    throw new BOSException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + res);
                }
                InterviewStructureFactory.getLocalInstance(ctx).addnew(baseCollection);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _modifyStructures(Context ctx, IObjectCollection interviewStructures) throws BOSException {
        InterviewStructureCollection isColl = (InterviewStructureCollection)interviewStructures;
        ArrayList<Object[]> removeFileIsids = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        if (!RecDBUtils.isEmpty((IObjectCollection)isColl)) {
            Iterator iter = isColl.iterator();
            InterviewStructureInfo info = null;
            while (iter.hasNext()) {
                info = (InterviewStructureInfo)iter.next();
                if (RecDBUtils.isEmpty(info.getFileName())) {
                    removeFileIsids.add(new Object[]{info.getId().toString()});
                }
                paramsList.add(new Object[]{info.getOrder(), info.getBasicData().getId().toString(), info.getName(), info.getId().toString()});
            }
        }
        if (!removeFileIsids.isEmpty()) {
            this.deleteFile(ctx, removeFileIsids);
        }
        if (!paramsList.isEmpty()) {
            String sql = "UPDATE T_REC_InterviewStructure SET FORDER=?,FDataId=?,FName=? WHERE FID=?";
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
    }

    private void deleteFile(Context ctx, List<Object[]> interviewStructureId) throws BOSException {
        String sql = "UPDATE T_REC_InterviewStructure SET FileName=NULL,FileCode=NULL,FileNameTemp=NULL,FileCodeTemp=NULL WHERE FID=?";
        try {
            RecDBUtils.executeBatch(ctx, sql, interviewStructureId);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void _modifyStructureAndFile(Context ctx, IObjectValue structureInfo) throws BOSException {
        InterviewStructureInfo info = (InterviewStructureInfo)structureInfo;
        String sql = "UPDATE T_REC_InterviewStructure SET FORDER=?,FDataId=?,FName=?,FileNameTemp=?,FileCodeTemp=? WHERE FID=?";
        Object[] params = new Object[]{info.getOrder(), info.getBasicData().getId().toString(), info.getName(), info.getFileName(), info.getFileCode(), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _deleteStructures(Context ctx, String isIds) throws BOSException {
        String[] params = isIds.split(",");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String isId : params) {
            Object[] param = new Object[]{isId};
            paramsList.add(param);
        }
        if (!paramsList.isEmpty()) {
            String sql = "DELETE FROM T_REC_InterviewStructure WHERE FID = ?";
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
    }

    @Override
    protected void _removeUploadTemp(Context ctx) throws BOSException {
        String sql = "DELETE FROM T_REC_InterviewStructure WHERE FName = '#uploadFileTemp#'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_REC_InterviewStructure SET FileNameTemp = NULL,FileCodeTemp = NULL WHERE FileNameTemp IS NOT NULL";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected IObjectValue _getLoadFileData(Context ctx, IObjectPK isId) throws BOSException {
        String id = isId.toString();
        String sql = "SELECT FileNameTemp FROM T_REC_InterviewStructure WHERE FID = ?";
        InterviewStructureInfo info = null;
        List<Object[]> dataList = null;
        try {
            Object[] params;
            String fileNameTemp;
            IRowSet rs;
            dataList = RecDBUtils.getQueryData(ctx, sql, new Object[]{id});
            if (dataList != null && !dataList.isEmpty() && (dataList = RecDBUtils.getQueryData(rs = DbUtil.executeQuery((Context)ctx, (String)(sql = (fileNameTemp = (String)dataList.get(0)[0]) != null && !"".equals(fileNameTemp) ? "SELECT FileNameTemp,FileCodeTemp FROM T_REC_InterviewStructure WHERE FID = ?" : "SELECT FileName,FileCode FROM T_REC_InterviewStructure WHERE FID = ?"), (Object[])(params = new Object[]{id})))) != null && !dataList.isEmpty()) {
                Object[] datas = dataList.get(0);
                info = new InterviewStructureInfo();
                info.setFileName((String)datas[0]);
                if (datas[1] != null) {
                    SerialBlob fileCodeBlob = (SerialBlob)datas[1];
                    byte[] fileCode = RecDBUtils.serialBlobToByteAry(fileCodeBlob);
                    info.setFileCode(fileCode);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }
}

