/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.SalaryItemInfo;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.PositionExtendCollection;
import com.kingdee.eas.hr.org.PositionExtendFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.cmpdesign.CmpStdValueInfo;
import com.kingdee.shr.preentry.FileStateEnum;
import com.kingdee.shr.preentry.IPreEntryPerson;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.recuritment.BatchApprovalBillFactory;
import com.kingdee.shr.recuritment.BatchApprovalBillInfo;
import com.kingdee.shr.recuritment.BillVersionEnum;
import com.kingdee.shr.recuritment.IInterviewStageResultList;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteFactory;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteInfo;
import com.kingdee.shr.recuritment.IRecApproval;
import com.kingdee.shr.recuritment.IRecBenefit;
import com.kingdee.shr.recuritment.IRecBenefitGroup;
import com.kingdee.shr.recuritment.IRecSignFee;
import com.kingdee.shr.recuritment.IRecSignFeeDetail;
import com.kingdee.shr.recuritment.IResumeBaseRec;
import com.kingdee.shr.recuritment.InterviewResultCollection;
import com.kingdee.shr.recuritment.InterviewResultEnum;
import com.kingdee.shr.recuritment.InterviewResultFactory;
import com.kingdee.shr.recuritment.InterviewResultInfo;
import com.kingdee.shr.recuritment.InterviewResultStatusEnum;
import com.kingdee.shr.recuritment.InterviewStageResultListFactory;
import com.kingdee.shr.recuritment.InterviewStageResultListInfo;
import com.kingdee.shr.recuritment.InterviewersCollection;
import com.kingdee.shr.recuritment.OfferCollection;
import com.kingdee.shr.recuritment.OfferFactory;
import com.kingdee.shr.recuritment.OfferInfo;
import com.kingdee.shr.recuritment.RecApprovalCollection;
import com.kingdee.shr.recuritment.RecApprovalFactory;
import com.kingdee.shr.recuritment.RecApprovalInfo;
import com.kingdee.shr.recuritment.RecBenefitFactory;
import com.kingdee.shr.recuritment.RecBenefitGroupCollection;
import com.kingdee.shr.recuritment.RecBenefitGroupFactory;
import com.kingdee.shr.recuritment.RecBenefitGroupInfo;
import com.kingdee.shr.recuritment.RecBenefitInfo;
import com.kingdee.shr.recuritment.RecDataMappingDetailCollection;
import com.kingdee.shr.recuritment.RecDataMappingDetailFactory;
import com.kingdee.shr.recuritment.RecDataMappingDetailInfo;
import com.kingdee.shr.recuritment.RecRegisterCollection;
import com.kingdee.shr.recuritment.RecRegisterFactory;
import com.kingdee.shr.recuritment.RecRegisterInfo;
import com.kingdee.shr.recuritment.RecRegisterStateEnum;
import com.kingdee.shr.recuritment.RecSignFeeDetailFactory;
import com.kingdee.shr.recuritment.RecSignFeeDetailInfo;
import com.kingdee.shr.recuritment.RecSignFeeFactory;
import com.kingdee.shr.recuritment.RecSignFeeInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandExtendCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandExtendFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandExtendInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandStaffInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeStateFactory;
import com.kingdee.shr.recuritment.ResumeStateInfo;
import com.kingdee.shr.recuritment.TransactionStateEnum;
import com.kingdee.shr.recuritment.app.AbstractRecApprovalControllerBean;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.util.convert.ResumeConvertUtil;
import com.kingdee.shr.staffcontrol.StaffManageControlWayEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RecApprovalControllerBean
extends AbstractRecApprovalControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.recuritment.app.RecApprovalControllerBean");

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        Object assigmentId = model.get("assigmentId");
        if (logger.isDebugEnabled()) {
            logger.error("assignmentId : " + assigmentId);
        }
        if (assigmentId == null) {
            super._submit(ctx, pk, model);
        } else {
            RecApprovalInfo recApprovalInfo = (RecApprovalInfo)model;
            if (logger.isDebugEnabled()) {
                logger.error("submit------------------");
                logger.error("group info:" + (Object)((Object)recApprovalInfo.getGroup()));
                logger.error("group info:" + model.get("salaryItemGroup"));
            }
            if (recApprovalInfo.getId() != null && this._exists(ctx, pk)) {
                RecApprovalInfo oldInfo = this.getRecApprovalInfo(ctx, pk);
                super.update(ctx, pk, recApprovalInfo);
                this.detailWithForSalaryItems(ctx, model, oldInfo);
            }
            ServiceStateManager.getInstance().enableNextCallServices();
        }
    }

    private void detailWithForSalaryItems(Context ctx, IObjectValue model, RecApprovalInfo oldInfo) throws BOSException, EASBizException {
        RecApprovalInfo recApprovalInfo = (RecApprovalInfo)model;
        IRecApproval iRecApproval = RecApprovalFactory.getLocalInstance(ctx);
        String cmpStdValueId = (String)recApprovalInfo.get("cmpStdValueId");
        if (!StringUtils.isEmpty((CharSequence)cmpStdValueId)) {
            CmpStdValueInfo cmpStdValue = recApprovalInfo.getCmpStdValue();
            cmpStdValue.setId(BOSUuid.read((String)cmpStdValueId));
            recApprovalInfo.setCmpStdValue(cmpStdValue);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("CmpStdValue"));
            iRecApproval.updatePartial(recApprovalInfo, sic);
        } else if (oldInfo != null && oldInfo.getCmpStdValue() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("CmpStdValue"));
            iRecApproval.updatePartial(oldInfo, sic);
        }
        try {
            Object salaryItemGroupObj = model.get("salaryItemGroup");
            IRecBenefit iRecBenefit = RecBenefitFactory.getLocalInstance(ctx);
            IRecBenefitGroup iRecBenefitGroup = RecBenefitGroupFactory.getLocalInstance(ctx);
            if (salaryItemGroupObj != null && !"".equals(salaryItemGroupObj)) {
                JSONArray salaryItemGroupArr = JSONArray.fromObject((Object)salaryItemGroupObj);
                if (salaryItemGroupArr.size() > 0) {
                    String recApprovalId = recApprovalInfo.getId().toString();
                    RecBenefitGroupCollection recBenefitGroupColl = iRecBenefitGroup.getRecBenefitGroupCollection("select id where recApproval = '" + recApprovalId + "'");
                    if (recBenefitGroupColl != null && recBenefitGroupColl.size() > 0) {
                        for (int i = 0; i < recBenefitGroupColl.size(); ++i) {
                            String groupId = recBenefitGroupColl.get(i).getId().toString();
                            iRecBenefit.delete("where group = '" + groupId + "'");
                        }
                        iRecBenefitGroup.delete("where recApproval = '" + recApprovalId + "'");
                    }
                }
                for (int i = 0; i < salaryItemGroupArr.size(); ++i) {
                    JSONArray salaryItemsArr = salaryItemGroupArr.getJSONArray(i);
                    RecBenefitGroupInfo recBenefitGroupInfo = new RecBenefitGroupInfo();
                    recBenefitGroupInfo.put("recApproval", recApprovalInfo.getId().toString());
                    if (salaryItemsArr.size() > 0 && salaryItemsArr != null) {
                        JSONObject titleData = salaryItemsArr.getJSONObject(salaryItemsArr.size() - 1);
                        recBenefitGroupInfo.setNumber((String)titleData.get("number"));
                        recBenefitGroupInfo.setName((String)titleData.get("name"));
                        recBenefitGroupInfo.setIndex(i + 1);
                        salaryItemsArr.remove(salaryItemsArr.size() - 1);
                    }
                    iRecBenefitGroup.addnew(recBenefitGroupInfo);
                    CoreBaseCollection infos = new CoreBaseCollection();
                    for (int j = 0; j < salaryItemsArr.size(); ++j) {
                        String precision;
                        JSONObject currency;
                        JSONObject salaryItem = salaryItemsArr.getJSONObject(j);
                        String salaryItemId = (String)salaryItem.get("salaryItemId");
                        SalaryItemInfo salaryItemInfo = new SalaryItemInfo();
                        salaryItemInfo.setId(BOSUuid.read((String)salaryItemId));
                        RecBenefitInfo recBenefitInfo = new RecBenefitInfo();
                        recBenefitInfo.setSalaryItem(salaryItemInfo);
                        recBenefitInfo.setGroup(recBenefitGroupInfo);
                        recBenefitInfo.setLevelId((String)salaryItem.get("levelId"));
                        recBenefitInfo.setScopeId((String)salaryItem.get("scopeId"));
                        recBenefitInfo.setPointId((String)salaryItem.get("pointId"));
                        Object currencyStr = salaryItem.get("currency");
                        if (currencyStr != null && !"".equals(currencyStr) && (currency = (JSONObject)salaryItem.get("currency")) != null) {
                            CurrencyInfo currencyInfo = new CurrencyInfo();
                            currencyInfo.setId(BOSUuid.read((String)((String)currency.get("id"))));
                            recBenefitInfo.setCurrency(currencyInfo);
                        }
                        recBenefitInfo.setAmount((String)salaryItem.get("amount"));
                        recBenefitInfo.setDiff((String)salaryItem.get("diff"));
                        recBenefitInfo.setDescription((String)salaryItem.get("description"));
                        String lower = (String)salaryItem.get("lower");
                        String upper = (String)salaryItem.get("upper");
                        if (!StringUtils.isEmpty((CharSequence)lower)) {
                            recBenefitInfo.setLower(new BigDecimal(lower));
                        }
                        if (!StringUtils.isEmpty((CharSequence)upper)) {
                            recBenefitInfo.setUpper(new BigDecimal(upper));
                        }
                        recBenefitInfo.setCmpItemId((String)salaryItem.get("cmpItemId"));
                        recBenefitInfo.setFloatRate((String)salaryItem.get("floatationRatio"));
                        recBenefitInfo.setScope((String)salaryItem.get("cmpStdScope"));
                        recBenefitInfo.setLevel((String)salaryItem.get("cmpStdLevel"));
                        String source = salaryItem.getString("source");
                        if (!StringUtils.isEmpty((CharSequence)source)) {
                            recBenefitInfo.setSource(Integer.parseInt(source));
                        }
                        if (!StringUtils.isEmpty((CharSequence)(precision = salaryItem.getString("precision")))) {
                            recBenefitInfo.setPrecision(Integer.parseInt(precision));
                        }
                        recBenefitInfo.put("dataType", salaryItem.get("dataType"));
                        Object dataLength = salaryItem.get("dataLength");
                        if (dataLength == null) {
                            dataLength = 0;
                        }
                        recBenefitInfo.put("dataLength", dataLength);
                        Timestamp updateTime = new Timestamp(System.currentTimeMillis() + (long)j * 1000L);
                        recBenefitInfo.setLastUpdateTime(updateTime);
                        infos.add((CoreBaseInfo)recBenefitInfo);
                    }
                    iRecBenefit.saveBatchData(infos);
                }
            } else {
                String recApprovalId = recApprovalInfo.getId().toString();
                RecBenefitGroupCollection recBenefitGroupColl = iRecBenefitGroup.getRecBenefitGroupCollection("select id where recApproval = '" + recApprovalId + "'");
                if (recBenefitGroupColl != null && recBenefitGroupColl.size() > 0) {
                    for (int i = 0; i < recBenefitGroupColl.size(); ++i) {
                        String groupId = recBenefitGroupColl.get(i).getId().toString();
                        iRecBenefit.delete("where group = '" + groupId + "'");
                    }
                }
                iRecBenefitGroup.delete("where recApproval = '" + recApprovalId + "'");
                String sql = "update T_REC_RecApproval set FEmpSalaryItemTemplateID = null,FIsSalaryStandard = null,FCmpStandardID = null, FCmpStdValueID= null  where  fid='" + recApprovalId + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            Object signFeeDataObj = model.get("signFeeData");
            IRecSignFee iRecSignFee = RecSignFeeFactory.getLocalInstance(ctx);
            IRecSignFeeDetail iRecSignFeeDetail = RecSignFeeDetailFactory.getLocalInstance(ctx);
            if (signFeeDataObj != null) {
                RecSignFeeInfo signFee = recApprovalInfo.getSignFee();
                JSONArray signFeeDataArr = JSONArray.fromObject((Object)signFeeDataObj);
                if (signFeeDataArr.size() > 0) {
                    if (signFee.getId() == null) {
                        String uuid = BOSUuid.create((BOSObjectType)signFee.getBOSType()).toString();
                        signFee.setId(BOSUuid.read((String)uuid));
                        recApprovalInfo.setSignFee(signFee);
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("signFee"));
                        iRecApproval.updatePartial(recApprovalInfo, sic);
                        iRecSignFee.addnew(signFee);
                    }
                    signFee = recApprovalInfo.getSignFee();
                    iRecSignFeeDetail.delete("where signFee = '" + signFee.getId().toString() + "'");
                }
                CoreBaseCollection recSignFeeDetailCol = new CoreBaseCollection();
                for (int i = 0; i < signFeeDataArr.size(); ++i) {
                    String monthNumber;
                    String index;
                    JSONObject signFeeData = signFeeDataArr.getJSONObject(i);
                    RecSignFeeDetailInfo recSignFeeDetailInfo = new RecSignFeeDetailInfo();
                    recSignFeeDetailInfo.setSignFee(recApprovalInfo.getSignFee());
                    String amount = (String)signFeeData.get("amount");
                    if (!StringUtils.isEmpty((CharSequence)amount)) {
                        recSignFeeDetailInfo.setAmount(amount);
                    }
                    if (!StringUtils.isEmpty((CharSequence)(index = (String)signFeeData.get("index")))) {
                        recSignFeeDetailInfo.setIndex(Integer.valueOf(index));
                    }
                    if (!StringUtils.isEmpty((CharSequence)(monthNumber = (String)signFeeData.get("monthNumber")))) {
                        recSignFeeDetailInfo.setMonthNumber(Integer.valueOf(monthNumber));
                    }
                    recSignFeeDetailInfo.setDescription((String)signFeeData.get("note"));
                    recSignFeeDetailCol.add((CoreBaseInfo)recSignFeeDetailInfo);
                }
                iRecSignFeeDetail.saveBatchData(recSignFeeDetailCol);
                signFee.put("detail", recSignFeeDetailCol);
            } else {
                RecSignFeeInfo signFee = recApprovalInfo.getSignFee();
                if (signFee != null && signFee.getId() != null) {
                    String signFeeId = signFee.getId().toString();
                    if (!StringUtils.isEmpty((CharSequence)signFeeId)) {
                        iRecSignFeeDetail.delete("where signFee = '" + signFeeId + "'");
                        iRecSignFee.delete("where id = '" + signFeeId + "'");
                    }
                    recApprovalInfo.setSignFee(null);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("signFee"));
                    iRecApproval.updatePartial(recApprovalInfo, sic);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u4e0d\u901a\u8fc7---------------");
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1abillId---------------" + billId.toString());
        }
        this._setState(ctx, billId, HRBillStateEnum.AUDITEND);
        this._sendAssignedMsgToXT(ctx, billId);
        String sqlfill = " select * from  T_REC_RECAPPROVAL where Fid = '" + billId + "' ";
        IRowSet rowfill = null;
        rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
        if (rowfill.size() > 0) {
            RecApprovalInfo recApproval = this.getRecApprovalInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            ResumeBaseRecInfo resume = recApproval.getResumeBaseRec();
            ResumeStateInfo resumeState = ResumeStateFactory.getLocalInstance(ctx).getResumeStateInfo("where number = '0011'");
            resume.setResumeState(resumeState);
            resume.setTransactionState(TransactionStateEnum.END);
            ResumeBaseRecFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
            OfferFactory.getLocalInstance(ctx).entryOffer(resume.getId().toString(), "0");
        }
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u901a\u8fc7---------------");
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1abillId---------------" + billId.toString());
        }
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
        this._sendAssignedMsgToXT(ctx, billId);
        String sqlfill = " select * from  T_REC_RECAPPROVAL where Fid = '" + billId + "' ";
        IRowSet rowfill = null;
        rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
        if (rowfill.size() > 0) {
            RecApprovalInfo recApproval = this.getRecApprovalInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            ResumeBaseRecInfo resume = recApproval.getResumeBaseRec();
            OfferFactory.getLocalInstance(ctx).entryOffer(resume.getId().toString(), "1");
            ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u62a5\u6279\u901a\u8fc7", "", resume);
        }
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u5ba1\u6838\u4e2d---------------");
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1abillId---------------" + billId.toString());
        }
        this._setState(ctx, billId, HRBillStateEnum.AUDITING);
        String sqlfill = " select * from  T_REC_RECAPPROVAL where Fid = '" + billId + "' ";
        IRowSet rowfill = null;
        rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
        if (rowfill.size() > 0) {
            RecApprovalInfo recApproval = this.getRecApprovalInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            ResumeBaseRecInfo resume = recApproval.getResumeBaseRec();
            ResumeStateInfo resumeState = ResumeStateFactory.getLocalInstance(ctx).getResumeStateInfo("where number = '0010'");
            resume.setResumeState(resumeState);
            ResumeBaseRecFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
            OfferFactory.getLocalInstance(ctx).entryOffer(resume.getId().toString(), "0");
        }
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        String sqlfill = " update  T_REC_RECAPPROVAL set fbillstate = '" + state.getValue() + "' where Fid = '" + billId + "' ";
        DbUtil.execute((Context)ctx, (String)sqlfill);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u672a\u63d0\u4ea4---------------");
            logger.error("---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1abillId---------------" + billId.toString());
        }
        super._setEditState(ctx, billId);
        String sqlfill = " select * from  T_REC_RECAPPROVAL where Fid = '" + billId + "' ";
        IRowSet rowfill = null;
        rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
        if (rowfill.size() > 0) {
            RecApprovalInfo recApproval = this.getRecApprovalInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            ResumeBaseRecInfo resume = recApproval.getResumeBaseRec();
            ResumeStateInfo resumeState = ResumeStateFactory.getLocalInstance(ctx).getResumeStateInfo("where number = '0010'");
            resume.setResumeState(resumeState);
            ResumeBaseRecFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
        }
    }

    @Override
    protected void _againstApprove(Context ctx, String[] billIds) throws BOSException {
        int i;
        IMultiApprove iApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String allResumeId = "";
        try {
            IRecApproval iRecApproval = RecApprovalFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])billIds)), CompareType.INCLUDE));
            evi.setFilter(filter);
            RecApprovalCollection recApprovalColl = iRecApproval.getRecApprovalCollection(evi);
            int size = recApprovalColl.size();
            for (i = 0; i < size; ++i) {
                RecApprovalInfo recApprovalInfo = recApprovalColl.get(i);
                String billId = recApprovalInfo.getId().toString();
                paramsList.add(new Object[]{billId});
                BatchApprovalBillInfo billInfo = recApprovalInfo.getBill();
                ResumeBaseRecInfo resume = recApprovalInfo.getResumeBaseRec();
                allResumeId = allResumeId + "'" + resume.getId().toString() + "'";
                if (i < size - 1) {
                    allResumeId = allResumeId + ",";
                }
                if (billInfo != null) {
                    billId = billInfo.getId().toString();
                    RecApprovalCollection recColl = iRecApproval.getRecApprovalCollection("WHERE bill = '" + billInfo.getId().toString() + "'");
                    if (recColl.size() > 0) {
                        int length = recColl.size();
                        for (int j = 0; j < length; ++j) {
                            paramsList.add(new Object[]{recColl.get(j).getId().toString()});
                        }
                    }
                    String sql = "DELETE FROM T_REC_BatchApprovalBill  WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
                }
                ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u53cd\u5ba1\u6279\u62a5\u6279", "", resume);
                RecRegisterInfo recRegisterInfo = null;
                RecRegisterCollection coll = RecRegisterFactory.getLocalInstance(ctx).getRecRegisterCollection("where resumeBaseRec = '" + resume.getId() + "' and isLatest = 1 ");
                if (coll == null || coll.size() <= 0 || (recRegisterInfo = coll.get(0)).getRecRegisterState() != RecRegisterStateEnum.INVALID) continue;
                recRegisterInfo.setRecRegisterState(RecRegisterStateEnum.INREGISTRATION);
                RecRegisterFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(recRegisterInfo.getId()), recRegisterInfo);
                resume.setRecRegisterState(RecRegisterStateEnum.INREGISTRATION);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sql = "UPDATE T_REC_RecApproval SET FBillState = 0,FAuditorID = null,FBillId = null WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        String updateResumeStateSql = "UPDATE T_REC_ResumeBaseRec SET FResumeStateID = 'ih1LnVZvQRe3ESkIQbAtoQhd7oA=' , FTransactionState = 1 WHERE FID = (SELECT FResumeBaseRecID FROM T_REC_RecApproval WHERE FID = ?)";
        DbUtil.executeBatch((Context)ctx, (String)updateResumeStateSql, paramsList);
        for (int i2 = 0; i2 < billIds.length; ++i2) {
            OfferInfo offerInfo;
            PreEntryPersonInfo preEntryPersonInfo;
            OfferCollection offerColl = OfferFactory.getLocalInstance(ctx).getOfferCollection("where recAporoval ='" + billIds[i2] + "'");
            if (offerColl == null || offerColl.size() <= 0 || (preEntryPersonInfo = (offerInfo = offerColl.get(0)).getTalent()) == null) continue;
            String preEntryPersonId = preEntryPersonInfo.getId().toString();
            try {
                RecDataMappingDetailCollection recDataMappingDetailCollection = RecDataMappingDetailFactory.getLocalInstance(ctx).getRecDataMappingDetailCollection("select relateEntityName,entityInfoSet  where dataMappingSet = 'qqDN9tZqmkuvM7m4SughkMYHoco='");
                if (recDataMappingDetailCollection.size() <= 0 || recDataMappingDetailCollection == null) continue;
                for (int j = 0; j < recDataMappingDetailCollection.size(); ++j) {
                    RecDataMappingDetailInfo recDataMappingDetailInfo = recDataMappingDetailCollection.get(j);
                    String relateEntityName = recDataMappingDetailInfo.getRelateEntityName();
                    MetaDataPK toMetaPk = MetaDataPK.create((String)relateEntityName);
                    ICoreBase toCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)toMetaPk);
                    if ("com.kingdee.shr.preentry.app.PreEntryPerson".equals(relateEntityName)) {
                        toCoreBase.delete("where id = '" + preEntryPersonId + "'");
                    } else {
                        toCoreBase.delete("where talent.id ='" + preEntryPersonId + "'");
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.error("\u9884\u5165\u804c\u6863\u6848\u5b9e\u4f53\u540d\u8def\u5f84=" + relateEntityName);
                }
                continue;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage());
            }
        }
        String offersql = "DELETE T_REC_OFFER WHERE FRecAporovalID = ?";
        DbUtil.executeBatch((Context)ctx, (String)offersql, paramsList);
        String updateDemandSql = "UPDATE T_REC_RECURITMENTDEMAND AS\u3000T\u3000set FPre_entryNumber = (T.FPre_entryNumber-1) where T.FID = (select T2.FRECURITMENTDEMANDID  from T_REC_RecApproval as T1 join T_REC_ResumeBaseRec as T2  on T1.FRESUMEBASERECID = T2.FID where T1.FID = ?)";
        DbUtil.executeBatch((Context)ctx, (String)updateDemandSql, paramsList);
        this.deleteApplyRecord(ctx, paramsList);
        RecRegisterCollection recRegistercol = RecRegisterFactory.getLocalInstance(ctx).getRecRegisterCollection("select talent.id where resumeBaseRec.id in(" + allResumeId + ") and recRegisterState ='3' ");
        if (recRegistercol.size() > 0 && recRegistercol != null) {
            IPreEntryPerson preEntryPerson = PreEntryPersonFactory.getLocalInstance((Context)ctx);
            for (i = 0; i < recRegistercol.size(); ++i) {
                BOSUuid talentId = recRegistercol.get(i).getTalent().getId();
                SelectorItemCollection selectors = new SelectorItemCollection();
                try {
                    boolean exists = preEntryPerson.exists("where id ='" + talentId.toString() + "' and fileState= '3'");
                    if (!exists) continue;
                    PreEntryPersonInfo preEntryPersonInfo = preEntryPerson.getPreEntryPersonInfo((IObjectPK)new ObjectUuidPK(talentId));
                    preEntryPersonInfo.setFileState(FileStateEnum.TempStorage);
                    selectors.add(new SelectorItemInfo("fileState"));
                    preEntryPerson.updatePartial(preEntryPersonInfo, selectors);
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    private void deleteProcess(IMultiApprove iApprove, IEnactmentService service, String billId) throws BOSException, EASBizException, WfException {
        iApprove.deleteByBillId(billId);
        ProcessInstInfo[] procInsts = service.getAllProcessInstancesByBizobjId(billId);
        if (procInsts != null && procInsts.length > 0) {
            int len = procInsts.length;
            String[] procInstIds = new String[len];
            for (int k = 0; k < len; ++k) {
                procInstIds[k] = procInsts[k].getProcInstId();
            }
            service.batchPhysicsDelete(procInstIds);
        }
    }

    @Override
    protected void _reApprove(Context ctx, String[] billIds) throws BOSException {
        IMultiApprove iApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        IRecApproval iRecApproval = RecApprovalFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])billIds)), CompareType.INCLUDE));
        evi.setFilter(filter);
        RecApprovalCollection recApprovalColl = iRecApproval.getRecApprovalCollection(evi);
        int size = recApprovalColl.size();
        for (int i = 0; i < size; ++i) {
            RecApprovalInfo recApprovalInfo = recApprovalColl.get(i);
            String billId = recApprovalInfo.getId().toString();
            paramsList.add(new Object[]{billId});
            BatchApprovalBillInfo billInfo = recApprovalInfo.getBill();
            if (billInfo != null) {
                billId = billInfo.getId().toString();
                RecApprovalCollection recColl = iRecApproval.getRecApprovalCollection("WHERE bill = '" + billInfo.getId().toString() + "'");
                if (recColl.size() > 0) {
                    int length = recColl.size();
                    for (int j = 0; j < length; ++j) {
                        paramsList.add(new Object[]{recColl.get(j).getId().toString()});
                    }
                }
                String sql = "DELETE FROM T_REC_BatchApprovalBill  WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
            }
            ResumeBaseRecInfo resume = recApprovalInfo.getResumeBaseRec();
            ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u91cd\u65b0\u62a5\u6279", "", resume);
        }
        String updateResumeStateSql = "UPDATE T_REC_ResumeBaseRec SET FResumeStateID = 'ih1LnVZvQRe3ESkIQbAtoQhd7oA=' , FTransactionState = 1 WHERE FID = (SELECT FResumeBaseRecID FROM T_REC_RecApproval WHERE FID = ?)";
        DbUtil.executeBatch((Context)ctx, (String)updateResumeStateSql, paramsList);
        String updateApprovalSql = "UPDATE T_REC_RecApproval SET FBillState = 0,FAuditorID = null,FBillId = null WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateApprovalSql, paramsList);
        this.deleteApplyRecord(ctx, paramsList);
    }

    private void deleteApplyRecord(Context ctx, List<Object[]> paramsList) throws BOSException {
        String deleteApplyRecordSql = "DELETE T_REC_ApplyRecord where frecApprovalID= ? and (fcurrResumeStateID='n7Nzad8DTuiFdFQPTTqCkghd7oA=' or fcurrResumeStateID='MbwdLy26TMqiLPCwbofjVwhd7oA=' or fcurrResumeStateID='XbTN0V31SL67kqskenQKLAhd7oA=' or fcurrResumeStateID='7MWy+YNvQ0aUaW14HT2+Rghd7oA=') ";
        DbUtil.executeBatch((Context)ctx, (String)deleteApplyRecordSql, paramsList);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, String resumeId) throws BOSException {
        IObjectPK idPk = null;
        ResumeBaseRecInfo resume = this.getResumeBaseRecById(ctx, resumeId);
        ResumeStateInfo resumeState = new ResumeStateInfo();
        resumeState.setId(BOSUuid.read((String)"ih1LnVZvQRe3ESkIQbAtoQhd7oA="));
        resume.setResumeState(resumeState);
        resume.setTransactionState(TransactionStateEnum.PROCESSED);
        RecuritmentDemandInfo recDemandInfo = resume.getRecuritmentDemand();
        if (recDemandInfo == null) {
            throw new BOSException("\u65e0\u6cd5\u67e5\u8be2resumeBaseRec\u5bf9\u5e94\u62db\u8058\u9700\u6c42\uff0cresumeId\uff1a" + resume.getId().toString() + "");
        }
        try {
            recDemandInfo = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandInfo((IObjectPK)new ObjectUuidPK(recDemandInfo.getId().toString()));
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException("\u83b7\u53d6RecuritmentDemandInfo\u5b9e\u4f8b\u5931\u8d25\uff0cid\uff1a" + recDemandInfo.getId().toString());
        }
        InterviewResultInfo interviewResult = this.getInterviewResultByResumeId(ctx, resumeId);
        String sql = "SELECT r.FJobGradeId,p.Forder FROM T_REC_InterviewPlanResult r left join T_REC_InterviewPlan p on r.FInterviewPlanId = p.Fid  left join T_REC_InterviewResult IR on IR.FID = p.FInterviewID  WHERE IR.FResumeBaseRecID = ?  order by p.Forder desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{resumeId});
        String jobGradeId = null;
        try {
            if (rs != null && rs.next()) {
                jobGradeId = rs.getString("FJobGradeId");
            }
        }
        catch (SQLException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        HRJobInfo hrjob = null;
        JobLevelInfo jobLevelInfo = null;
        if (recDemandInfo.getRecuritPosition() != null && recDemandInfo.getRecuritPosition().getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)recDemandInfo.getRecuritPosition().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("jobLevel.name"));
            PositionCollection coll = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
            if (coll != null && coll.size() > 0) {
                jobLevelInfo = coll.get(0).getJobLevel();
            }
            EntityViewInfo extendView = new EntityViewInfo();
            FilterInfo extendFilter = new FilterInfo();
            extendFilter.getFilterItems().add(new FilterItemInfo("position", (Object)recDemandInfo.getRecuritPosition().getId().toString(), CompareType.EQUALS));
            extendView.setFilter(extendFilter);
            SelectorItemCollection extendSic = extendView.getSelector();
            extendSic.add(new SelectorItemInfo("hrJob.name"));
            PositionExtendCollection extendColl = PositionExtendFactory.getLocalInstance((Context)ctx).getPositionExtendCollection(extendView);
            if (extendColl != null && extendColl.size() > 0) {
                hrjob = extendColl.get(0).getHrJob();
            }
        }
        RecApprovalInfo recApproval = new RecApprovalInfo();
        recApproval.put("applyDate", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        recApproval.setId(BOSUuid.read((String)BOSUuid.create((BOSObjectType)recApproval.getBOSType()).toString()));
        recApproval.setRecuritmentHead(interviewResult == null ? resume.getRecuritmentHead() : interviewResult.getRecuritmentHead());
        resume.setNowRecHead(recApproval.getRecuritmentHead());
        recApproval.setResumeBaseRec(resume);
        recApproval.setInterviewResult(interviewResult);
        recApproval.setAdminOrg(ContextUtil.getCurrentAdminUnit((Context)ctx));
        recApproval.setPosition(resume.getRecuritPosition());
        recApproval.setWorkPlace(recDemandInfo.getAddress());
        recApproval.setInsuredArea(recDemandInfo.getAddress());
        recApproval.setBillState(HRBillStateEnum.SAVED);
        recApproval.setToEmpDepartment(recDemandInfo.getDepartment());
        recApproval.setToEmpPosition(recDemandInfo.getRecuritPosition());
        recApproval.setHrOrgUnit(recDemandInfo.getHrOrgUnit());
        recApproval.setDepartmentNumber(recDemandInfo.getDepartmentNumber());
        recApproval.setStaffingOrg(recDemandInfo.getStaffingOrg());
        recApproval.setStaffingUsable(recDemandInfo.getStaffingUsable());
        recApproval.setIsKeyTalents(recDemandInfo.getIsKeyTalents());
        recApproval.setSocialType("1,2,3,4,5,6,");
        RecuritmentDemandExtendCollection extendColl = RecuritmentDemandExtendFactory.getLocalInstance(ctx).getRecuritmentDemandExtendCollection("where recuritmentDemand.id = '" + recDemandInfo.getId().toString() + "'");
        if (extendColl.size() > 0) {
            RecuritmentDemandExtendInfo extend = extendColl.get(0);
            recApproval.setPositionNum(extend.getPositionNum());
            recApproval.setStaffingPos(extend.getStaffingPos());
            recApproval.setStaffingPosRest(extend.getStaffingPosRest());
        }
        if (recDemandInfo.getHrJob() != null) {
            recApproval.setHrJob(recDemandInfo.getHrJob());
        } else {
            recApproval.setHrJob(hrjob);
        }
        recApproval.setJobLevel(jobLevelInfo);
        recApproval.put("jobGrade", jobGradeId);
        recApproval.setBillVersion(BillVersionEnum.third);
        recApproval.setNumber(System.currentTimeMillis() + "");
        if (!StringUtils.isEmpty((CharSequence)recDemandInfo.getRefreshModel())) {
            this.recalcStaff(ctx, recApproval, recDemandInfo);
        }
        try {
            idPk = RecApprovalFactory.getLocalInstance(ctx).addnew(recApproval);
            ResumeBaseRecFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            this.addInterviewStateResult(ctx, resume.getId().toString(), idPk.toString());
        }
        catch (SQLException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (interviewResult != null && interviewResult.getId() != null) {
            this.syncInterviewAttachment(ctx, interviewResult.getId().toString(), idPk.toString());
        }
        return idPk;
    }

    private void recalcStaff(Context ctx, RecApprovalInfo recApproval, RecuritmentDemandInfo recDemandInfo) throws BOSException {
        RecuritmentDemandStaffInfo staff = recDemandInfo.getStaff();
        if (null == staff || null == recDemandInfo.getPickedDate() || null == recDemandInfo.getStaffDimension()) {
            return;
        }
        String demandModel = recDemandInfo.getRefreshModel();
        Date pickedDate = recDemandInfo.getPickedDate();
        List rows = Lists.newArrayList();
        boolean isPosition = false;
        boolean isJobGrade = false;
        Gson gson = new Gson();
        HashMap modelValueMap = (HashMap)gson.fromJson(demandModel, HashMap.class);
        String dimensions = MapUtils.getString((Map)modelValueMap, (Object)"dimensions");
        isPosition = dimensions.contains("FpositionID");
        isJobGrade = dimensions.contains("FjobGradeID");
        Map staffMap = MapUtils.getMap((Map)modelValueMap, (Object)"staff");
        String oldStaffId = MapUtils.getString((Map)staffMap, (Object)"staffId");
        if (StringUtils.isEmpty((CharSequence)oldStaffId)) {
            return;
        }
        if (isJobGrade) {
            demandModel = this.setGrade(ctx, modelValueMap);
        }
        HashMap firstRow = Maps.newHashMap();
        HashMap<String, String> param = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String selectedDate = sdf.format(pickedDate);
        param.put("model", demandModel);
        param.put("dimensions", dimensions);
        param.put("date", selectedDate);
        param.put("entityName", "com.kingdee.shr.recuritment.app.RecuritmentDemand");
        try {
            rows = (List)OSFAppUtil.callService((Context)ctx, (String)"GetStaffManageDimensionCountService", param);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException("\u83b7\u53d6\u7f16\u5236\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            for (HashMap row : rows) {
                String staffId = MapUtils.getString((Map)row, (Object)"staffId");
                if (!StringUtils.equals((CharSequence)oldStaffId, (CharSequence)staffId)) continue;
                firstRow = row;
                break;
            }
        }
        if (!CollectionUtils.isEmpty((Map)firstRow)) {
            if (isPosition) {
                recApproval.setPositionNum(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"actualCount")));
                recApproval.setStaffingPos(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"staffCount")));
                recApproval.setStaffingPosRest(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"availableCount")));
                recApproval.setControlWay(StaffManageControlWayEnum.getEnum((int)Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"controlWay"))));
            } else {
                recApproval.setDepartmentNumber(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"actualCount")));
                recApproval.setStaffingOrg(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"staffCount")));
                recApproval.setStaffingUsable(Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"availableCount")));
                recApproval.setControlWay(StaffManageControlWayEnum.getEnum((int)Integer.parseInt(MapUtils.getString((Map)firstRow, (Object)"controlWay"))));
            }
        }
    }

    private String setGrade(Context ctx, HashMap modelValueMap) throws BOSException {
        IRowSet iRowSet;
        String model = "";
        String lowJobGrade = MapUtils.getString((Map)modelValueMap, (Object)"lowJobGrade");
        String highJobGrade = MapUtils.getString((Map)modelValueMap, (Object)"highJobGrade");
        StringBuffer querySql = new StringBuffer("SELECT fid FROM T_HR_JobGrade where FJOBGRADEMODULEID =(SELECT FJOBGRADEMODULEID FROM T_HR_JobGrade where fid='");
        querySql.append(lowJobGrade).append("') and FGRADE between (SELECT FGRADE  FROM T_HR_JobGrade where fid='").append(lowJobGrade).append("'").append(") and (SELECT FGRADE  FROM T_HR_JobGrade where fid='").append(highJobGrade).append("')");
        try {
            iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (null != iRowSet) {
                String lowJobG = Joiner.on((String)",").join((Iterable)iRowSet.toCollection());
                modelValueMap.put("lowJobG", lowJobG.replaceAll("\\[", "").replaceAll("]", ""));
                Gson gson = new Gson();
                model = gson.toJson((Object)modelValueMap);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException("\u804c\u7b49\u533a\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (null == iRowSet) {
            throw new BOSException("\u804c\u7b49\u533a\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return model;
    }

    private void syncInterviewAttachment(Context ctx, String interviewId, String recApprovalId) {
        HashSet<String> attachIds = new HashSet<String>();
        try {
            StringBuilder sqlString = new StringBuilder();
            sqlString.append("SELECT FATTACHMENT FID FROM T_HR_SHRATTACHMENTEXT where FBOID in ( ").append("Select FID from T_REC_InterviewPlanResult where FInterviewPlanId in (SELECT FID FROM T_REC_INTERVIEWPLAN WHERE FINTERVIEWID = '").append(interviewId).append("') union all ").append("Select FID from T_REC_IPISDetailResult where FInterviewPlanId in (SELECT FID FROM T_REC_INTERVIEWPLAN WHERE FINTERVIEWID = '").append(interviewId).append("') union all ").append("Select FID from T_REC_IPISDetailEvaluate where FInterviewPlanId in (SELECT FID FROM T_REC_INTERVIEWPLAN WHERE FINTERVIEWID = '").append(interviewId).append("') union all ").append("Select FID from T_REC_IPISDetailDiathesis where FInterviewPlanId in (SELECT FID FROM T_REC_INTERVIEWPLAN WHERE FINTERVIEWID = '").append(interviewId).append("') union all ").append("Select FID from T_REC_IPISDetailWrite where FInterviewPlanId in (SELECT FID FROM T_REC_INTERVIEWPLAN WHERE FINTERVIEWID = '").append(interviewId).append("')) ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString());
            while (rs.next()) {
                attachIds.add(rs.getString("FID"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (attachIds.isEmpty()) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", attachIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            view.setSelector(selector);
            AttachmentCollection coll = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection(view);
            if (coll.size() > 0) {
                IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
                ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
                String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
                BOSUuid bosuuid = BOSUuid.read((String)recApprovalId);
                BOSObjectType bosType = bosuuid.getType();
                for (int i = 0; i < coll.size(); ++i) {
                    AttachmentInfo ai = coll.get(i);
                    ai.setId(null);
                    ai.setAttachID("" + System.currentTimeMillis());
                    CoreBaseCollection boAttachCol = new CoreBaseCollection();
                    String bosTypeStr = bosType.toString();
                    BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
                    boAttchAssoInfo.setId(BOSUuid.create((BOSObjectType)new BoAttchAssoInfo().getBOSType()));
                    boAttchAssoInfo.setBoID(recApprovalId);
                    boAttchAssoInfo.setAssoBusObjType(bosTypeStr);
                    boAttchAssoInfo.setAssoType("Added Accessories");
                    boAttachCol.add((CoreBaseInfo)boAttchAssoInfo);
                    ai.getBoAttchAsso().clear();
                    ai.put("boAttchAsso", (Object)boAttachCol);
                    ai.setBeizhu("com.kingdee.shr.recuritment.app.RecApprovalNew.form");
                    attachment.addnew(ai);
                    SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
                    attchExt.setAttachment(ai);
                    attchExt.setName(ai.getName() + "." + ai.getSimpleName());
                    attchExt.setPropertyName("interview");
                    attchExt.setType(AttachmentTypeEnum.PROPERTY);
                    attchExt.setState(AttachmentState.SAVE);
                    attchExt.setBunding(userId + "#com.kingdee.shr.recuritment.app.RecApprovalNew.form");
                    attchExt.setBoID(recApprovalId);
                    shrAttchExt.addnew((CoreBaseInfo)attchExt);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _initInterviewStageResult(Context ctx) throws BOSException {
    }

    private void addInterviewStageInfoForOld(Context ctx, String resumeID, String recApprovalId) throws EASBizException, BOSException {
        IInterviewStageResultList iInterview = InterviewStageResultListFactory.getLocalInstance(ctx);
        String comment = "";
        EntityViewInfo defineView = new EntityViewInfo();
        FilterInfo defineFilter = new FilterInfo();
        defineFilter.getFilterItems().add(new FilterItemInfo("resumeBaseRec", (Object)resumeID));
        defineView.setFilter(defineFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("interviewers"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("result"));
        defineView.setSelector(sic);
        InterviewResultCollection coll = InterviewResultFactory.getLocalInstance(ctx).getInterviewResultCollection(defineView);
        if (coll != null && coll.size() > 0) {
            InterviewStageResultListInfo info = new InterviewStageResultListInfo();
            info.put("interviewStageName", "\u7ec8\u8bd5");
            info.put("interviewStageResultName", coll.get(0).getResult() != null ? coll.get(0).getResult().getAlias() : "");
            info.put("jobGradeName", coll.get(0).getJobGrade() != null ? coll.get(0).getJobGrade().getName() : "");
            InterviewersCollection interviewers = coll.get(0).getInterviewers();
            comment = "";
            int index = 0;
            if (interviewers != null && interviewers.size() > 0) {
                for (int i = 0; i < interviewers.size(); ++i) {
                    String s;
                    String person = interviewers.get(0).getPerson() != null ? interviewers.get(0).getPerson().getName() : "";
                    String remark = interviewers.get(0).getSuggestion() != null ? interviewers.get(0).getSuggestion() : "";
                    InterviewResultEnum resultEnum = interviewers.get(0).getInterResult();
                    String detailResult = null;
                    if (resultEnum != null) {
                        detailResult = resultEnum.getAlias();
                    }
                    if (StringUtils.isEmpty((CharSequence)(s = this.getSuggest(person, detailResult, remark)))) continue;
                    comment = index == 0 ? comment + s : comment + "\n" + s;
                    ++index;
                }
            }
            info.put("comment", comment);
            info.put("RecApproval", recApprovalId);
            info.put("order", 1);
            iInterview.addnew(info);
        }
    }

    private void addInterviewStageInfo(Context ctx, Map<String, Object> map, String recApprovalId) throws BOSException {
        IInterviewStageResultList iInterview = InterviewStageResultListFactory.getLocalInstance(ctx);
        String comment = "";
        InterviewStageResultListInfo info = new InterviewStageResultListInfo();
        if (map.get("interviewPlanId") != null) {
            String interviewPlanId = (String)map.get("interviewPlanId");
            IPInterviewStructureDetailWriteCollection coll = IPInterviewStructureDetailWriteFactory.getLocalInstance(ctx).getIPInterviewStructureDetailWriteCollection("where interviewPlanId = '" + interviewPlanId + "'");
            if (coll != null && !coll.isEmpty()) {
                IPInterviewStructureDetailWriteInfo writeInfo = coll.get(0);
                info.put("writtenTestResult", writeInfo.getResult());
                info.put("writtenTestScore", writeInfo.getScore());
            }
        }
        if (map.get("interviewPlanResultId") != null) {
            info.put("interviewPlanResult", map.get("interviewPlanResultId"));
        }
        info.put("interviewStageName", map.get("interviewStageName"));
        info.put("interviewStageResultName", map.get("interviewStageResult"));
        info.put("jobGradeName", map.get("interviewStageGrade"));
        info.put("interviewScore", map.get("interviewScore"));
        info.put("order", map.get("order"));
        List commentList = new ArrayList();
        if (map.get("interviewStageSuggest") != null) {
            commentList = (List)map.get("interviewStageSuggest");
        }
        comment = "";
        for (int i = 0; i < commentList.size(); ++i) {
            comment = i == 0 ? comment + (String)commentList.get(i) : comment + "\n" + (String)commentList.get(i);
        }
        info.put("jobGradeName", map.get("interviewStageGrade"));
        info.put("comment", comment);
        info.put("RecApproval", recApprovalId);
        try {
            iInterview.addnew(info);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private ResumeBaseRecInfo getResumeBaseRecById(Context ctx, String resumeId) throws BOSException {
        ResumeBaseRecInfo resume = null;
        try {
            IResumeBaseRec iRec = ResumeBaseRecFactory.getLocalInstance(ctx);
            ResumeBaseRecCollection recColl = iRec.getResumeBaseRecCollection("select *,resumeApprover.*,resumeCirculator.* where id = '" + resumeId + "'");
            if (recColl == null || recColl.isEmpty()) {
                throw new BOSException("\u65e0\u6cd5\u67e5\u8be2resumeBaseRec\uff0cId\uff1a" + resumeId + "");
            }
            resume = recColl.get(0);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return resume;
    }

    private InterviewResultInfo getInterviewResultByResumeId(Context ctx, String resumeId) throws BOSException {
        InterviewResultInfo interviewResult = null;
        InterviewResultCollection resultColl = InterviewResultFactory.getLocalInstance(ctx).getInterviewResultCollection("where resumeBaseRec = '" + resumeId + "'");
        if (resultColl != null && !resultColl.isEmpty()) {
            interviewResult = resultColl.get(0);
        }
        return interviewResult;
    }

    public void addInterviewStateResult(Context ctx, String resumeID, String recApprovalId) throws BOSException, SQLException {
        List<Map<String, Object>> resultList = this.getInterviewResult(ctx, resumeID);
        for (Map<String, Object> map : resultList) {
            this.addInterviewStageInfo(ctx, map, recApprovalId);
        }
    }

    private List<Map<String, Object>> getInterviewResult(Context ctx, String resumeID) throws BOSException, SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.shr.recuritment.app", (String)"InterviewPlanResultQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setParameter(1, (Object)resumeID);
        exec.setObjectView("where (InterviewStructureDetailResult.saveState = 0 or InterviewStructureDetailResult.saveState is null) ");
        IRowSet rowSet = exec.executeQuery();
        String stageId = "";
        List<String> suggestList = new ArrayList();
        while (rowSet.next()) {
            String interviewerName = rowSet.getString("PLANINTERVIEWERNAME");
            String remark = rowSet.getString("PLANDETAILREMARK");
            String planGradeName = rowSet.getString("PLANJOBGRADENAME");
            String detailResult = null;
            InterviewResultStatusEnum detailResultEnum = InterviewResultStatusEnum.getEnum(rowSet.getString("PLANDETAILRESULT"));
            if (detailResultEnum != null) {
                detailResult = detailResultEnum.getAlias();
            }
            if (stageId.equals(rowSet.getString("INTERVIEWSTAGEID"))) {
                resultMap = (HashMap<String, Object>)resultList.get(resultList.size() - 1);
                suggestList = (List)resultMap.get("interviewStageSuggest");
                String tmpSuggest = this.getSuggest(interviewerName, detailResult, remark);
                if (!StringUtils.isEmpty((CharSequence)tmpSuggest)) {
                    suggestList.add(tmpSuggest);
                }
                resultMap.put("interviewStageSuggest", suggestList);
                continue;
            }
            stageId = rowSet.getString("INTERVIEWSTAGEID");
            resultMap = new HashMap<String, Object>();
            resultList.add(resultMap);
            InterviewResultStatusEnum interviewResultStatusEnum = InterviewResultStatusEnum.getEnum(rowSet.getString("PLANRESULT"));
            resultMap.put("interviewPlanId", rowSet.getString("INTERVIEWPLANID"));
            resultMap.put("interviewStageId", rowSet.getString("INTERVIEWSTAGEID"));
            resultMap.put("interviewPlanResultId", rowSet.getString("INTERVIEWPLANRESULTID"));
            resultMap.put("interviewStageName", rowSet.getString("INTERVIEWSTAGENAME"));
            resultMap.put("interviewScore", rowSet.getString("INTERVIEWSCORE"));
            if (interviewResultStatusEnum != null) {
                resultMap.put("interviewStageResult", interviewResultStatusEnum.getAlias());
            }
            resultMap.put("interviewStageGrade", planGradeName == null ? "" : planGradeName);
            resultMap.put("order", rowSet.getString("ORDER"));
            suggestList = new ArrayList();
            String tmpSuggest = this.getSuggest(interviewerName, detailResult, remark);
            if (!StringUtils.isEmpty((CharSequence)tmpSuggest)) {
                suggestList.add(tmpSuggest);
            }
            resultMap.put("interviewStageSuggest", suggestList);
        }
        return resultList;
    }

    private String getSuggest(String interviewerName, String result, String remark) {
        String tmpSuggest = "";
        if (!StringUtils.isEmpty((CharSequence)interviewerName)) {
            tmpSuggest = interviewerName;
        }
        if (result != null) {
            if (result.equals("\u7a7a")) {
                result = "\u672a\u5f55\u5165";
            }
            tmpSuggest = tmpSuggest + "\uff08" + result + "\uff09";
        }
        if (!StringUtils.isEmpty((CharSequence)remark)) {
            tmpSuggest = !StringUtils.isEmpty((CharSequence)tmpSuggest) ? tmpSuggest + "\uff1a" + remark : remark;
        }
        return tmpSuggest;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        model.remove("resumeBaseRec");
        model.remove("interviewResult");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("interviewStageResult"));
        sic.add(new SelectorItemInfo("resumeBaseRec.*"));
        RecApprovalCollection recApprovalColl = RecApprovalFactory.getLocalInstance(ctx).getRecApprovalCollection(evi);
        if (recApprovalColl != null && recApprovalColl.size() > 0) {
            model.put("interviewStageResult", (Object)recApprovalColl.get(0).getInterviewStageResult());
            ResumeBaseRecInfo resume = recApprovalColl.get(0).getResumeBaseRec();
            String candidateType = (String)model.get("candidateType");
            if (!StringUtils.isEmpty((CharSequence)candidateType)) {
                String sql = "update T_REC_ResumeBaseRec set FCandidateType = " + candidateType + " WHERE FID = '" + resume.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "update T_REC_EnterpriseArchives set FCandidateType = " + candidateType + " WHERE FUniqId = '" + resume.getIfSimplePerson() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        super._update(ctx, pk, model);
    }

    private void updateResumeHeader(Context ctx, ResumeBaseRecInfo recInfo, String identityCardNo, String passportNo) throws BOSException {
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)recInfo.getIdentityCardNo(), (CharSequence)identityCardNo) && StringUtils.equalsIgnoreCase((CharSequence)recInfo.getPassportNo(), (CharSequence)passportNo)) {
                return;
            }
            StringBuilder sql_01 = new StringBuilder("UPDATE T_REC_ResumeBaseRec SET FPassportNo=?,FIdentityCardNo=?");
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(passportNo);
            list.add(identityCardNo);
            if (!StringUtils.isEmpty((CharSequence)identityCardNo)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                IDCardCommonUtil iDCardUtil = new IDCardCommonUtil(identityCardNo, true);
                recInfo.setBirthday(sdf.parse(iDCardUtil.getBirthday()));
                if (iDCardUtil.getGenders().getValue() == 1) {
                    recInfo.setGender(Genders.Male);
                } else {
                    recInfo.setGender(Genders.Female);
                }
                Date birthday = recInfo.getBirthday();
                if (birthday != null) {
                    int age = ResumeConvertUtil.getAgeByBirthday(birthday);
                    recInfo.setAge(age);
                    recInfo.setCurrAge(age);
                }
                if (recInfo.getBirthday() != null) {
                    list.add(new java.sql.Date(recInfo.getBirthday().getTime()));
                    sql_01.append(",FBirthday=?");
                }
                if (recInfo.getGender() != null) {
                    list.add(recInfo.getGender().getValue());
                    sql_01.append(",FGender=?");
                }
                list.add(recInfo.getAge());
                sql_01.append(",FAge=?");
                list.add(recInfo.getCurrAge());
                sql_01.append(",FCurrAge=?");
            }
            sql_01.append(" WHERE FIfSimplePerson = (SELECT FIfSimplePerson FROM T_REC_ResumeBaseRec WHERE FID = ?)");
            list.add(recInfo.getId().toString());
            DbUtil.execute((Context)ctx, (String)sql_01.toString(), (Object[])list.toArray());
            StringBuilder sql_02 = new StringBuilder("UPDATE T_REC_EnterpriseArchives SET FPassportNo=?,FIdentityCardNo=? ");
            list = new ArrayList();
            list.add(passportNo);
            list.add(identityCardNo);
            if (!StringUtils.isEmpty((CharSequence)identityCardNo)) {
                if (recInfo.getBirthday() != null) {
                    list.add(new java.sql.Date(recInfo.getBirthday().getTime()));
                    sql_02.append(",FBirthday=?");
                }
                if (recInfo.getGender() != null) {
                    list.add(recInfo.getGender().getValue());
                    sql_02.append(",FGender=?");
                }
                list.add(recInfo.getAge());
                sql_02.append(",FAge=?");
                list.add(recInfo.getCurrAge());
                sql_02.append(",FCurrAge=?");
            }
            list.add(recInfo.getId().toString());
            sql_02.append(" WHERE FUniqId = (SELECT FIfSimplePerson FROM T_REC_ResumeBaseRec WHERE FID = ?) and FState = 1");
            DbUtil.execute((Context)ctx, (String)sql_02.toString(), (Object[])list.toArray());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        IRecApproval approval = RecApprovalFactory.getLocalInstance(ctx);
        RecApprovalInfo recApproval = approval.getRecApprovalInfo((IObjectPK)new ObjectUuidPK(billId));
        IResumeBaseRec iResumeBaseRec = ResumeBaseRecFactory.getLocalInstance(ctx);
        BatchApprovalBillInfo billInfo = recApproval.getBill();
        ResumeBaseRecInfo resume = recApproval.getResumeBaseRec();
        if (billInfo == null) {
            super._abortBizBill(ctx, billId);
            ResumeStateInfo resumeState = ResumeStateFactory.getLocalInstance(ctx).getResumeStateInfo("where number = '0009'");
            resume.setResumeState(resumeState);
            iResumeBaseRec.update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
        } else {
            IRecApproval iRecApproval = RecApprovalFactory.getLocalInstance(ctx);
            BatchApprovalBillFactory.getLocalInstance(ctx).abortBizBill(billInfo.getId().toString());
            RecApprovalCollection recColl = iRecApproval.getRecApprovalCollection("WHERE bill = '" + billInfo.getId().toString() + "'");
            if (recColl.size() > 0) {
                ResumeStateInfo resumeState = ResumeStateFactory.getLocalInstance(ctx).getResumeStateInfo("where number = '0009'");
                int size = recColl.size();
                for (int i = 0; i < size; ++i) {
                    RecApprovalInfo RecInfo = recColl.get(i);
                    super._abortBizBill(ctx, RecInfo.getId().toString());
                    ResumeBaseRecInfo resumeInfo = RecInfo.getResumeBaseRec();
                    resumeInfo.setResumeState(resumeState);
                    iResumeBaseRec.update((IObjectPK)new ObjectUuidPK(resumeInfo.getId()), resumeInfo);
                }
            }
        }
        ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u64a4\u56de\u62a5\u6279", "", resume);
    }
}

