/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.integraterec.IntegrateAccountFactory;
import com.kingdee.shr.recuritment.FlowStateEnum;
import com.kingdee.shr.recuritment.RecDemandBillCollection;
import com.kingdee.shr.recuritment.RecDemandBillFactory;
import com.kingdee.shr.recuritment.RecDemandBillInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.ReleaseStateEnum;
import com.kingdee.shr.recuritment.app.AbstractRecDemandBillControllerBean;
import com.kingdee.shr.recuritment.app.service.RecuritmentDemandMokaService;
import com.kingdee.shr.recuritment.app.service.RecuritmentDemandTuPuService;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RecDemandBillControllerBean
extends AbstractRecDemandBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.RecDemandBillControllerBean");
    private RecuritmentDemandMokaService mokaService = RecuritmentDemandMokaService.getInstance();
    private RecuritmentDemandTuPuService tuPuService = RecuritmentDemandTuPuService.getInstance();

    @Override
    protected void _againstApprove(Context ctx, String[] billIds) throws BOSException {
        IMultiApprove iApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        RecuritmentDemandCollection recuritmentDemandCol = new RecuritmentDemandCollection();
        try {
            for (String billId : billIds) {
                RecuritmentDemandCollection demandColl;
                paramsList.add(new Object[]{billId});
                iApprove.deleteByBillId(billId);
                ProcessInstInfo[] procInsts = service.getAllProcessInstancesByBizobjId(billId);
                if (procInsts != null && procInsts.length > 0) {
                    int len = procInsts.length;
                    String[] procInstIds = new String[len];
                    for (int i = 0; i < len; ++i) {
                        procInstIds[i] = procInsts[i].getProcInstId();
                    }
                    service.batchPhysicsDelete(procInstIds);
                }
                if ((demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select *,demandTpRelated.* where bill = '" + billId + "'")).size() <= 0) continue;
                for (int i = 0; i < demandColl.size(); ++i) {
                    recuritmentDemandCol.add(demandColl.get(i));
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sql_01 = "UPDATE T_REC_RecDemandBill SET FBillState = 0 WHERE FId = ?";
        String sql_02 = "UPDATE T_REC_RecuritmentDemand SET FBillState = 0,FlowState = 3,FReleaseState=100 WHERE FBillId = ?";
        RecDBUtils.executeBatch(ctx, sql_01, paramsList);
        RecDBUtils.executeBatch(ctx, sql_02, paramsList);
        if (recuritmentDemandCol.size() > 0) {
            this.tuPuService.updateStatusTuPuJob(ctx, recuritmentDemandCol, "againstApprove");
        }
    }

    @Override
    protected void _withdrawDemand(Context ctx, String[] billIds) throws BOSException {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])billIds)), CompareType.INCLUDE));
            evi.setFilter(filter);
            RecDemandBillCollection demandCollection = RecDemandBillFactory.getLocalInstance(ctx).getRecDemandBillCollection(evi);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
            int size = demandCollection.size();
            for (int i = 0; i < size; ++i) {
                RecDemandBillInfo demandInfo = demandCollection.get(i);
                this._abortBizBill(ctx, demandInfo.getId().toString());
                paramsList.add(new Object[]{demandInfo.getId().toString()});
            }
            if (!paramsList.isEmpty()) {
                String sql = "UPDATE T_REC_RecuritmentDemand SET FBillState = 0,FlowState = 3, FDescription = null,FReleaseState=100 WHERE FBillId = ?";
                RecDBUtils.executeBatch(ctx, sql, paramsList);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        logger.debug((Object)"---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u4e0d\u901a\u8fc7---------------");
        super._setNoPassState(ctx, billId);
        this.setDemandApproveState(ctx, billId, HRBillStateEnum.AUDITEND);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        logger.debug((Object)"---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u901a\u8fc7---------------");
        super._setPassState(ctx, billId);
        this.setDemandApproveState(ctx, billId, HRBillStateEnum.AUDITED);
        boolean exists = IntegrateAccountFactory.getLocalInstance((Context)ctx).exists("where integrateType = 1 and  integrateStatus = 1 ");
        if (exists) {
            this.mokaAddJobForRecuritment(ctx, billId.toString());
        }
        RecuritmentDemandCollection demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select *,demandTpRelated.* where bill = '" + billId.toString() + "'");
        this.tuPuService.submitEffectAddTuPuJob(ctx, demandColl, "AutoPush");
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setApproveState(ctx, billId);
        logger.debug((Object)"---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u5ba1\u6838\u4e2d---------------");
        super._setApproveState(ctx, billId);
        this.setDemandApproveState(ctx, billId, HRBillStateEnum.AUDITING);
    }

    private void setDemandApproveState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws EASBizException, BOSException {
        RecuritmentDemandCollection demandCollection = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("WHERE bill = '" + billId.toString() + "'");
        if (demandCollection.size() > 0) {
            CoreBaseCollection coll = new CoreBaseCollection();
            int size = demandCollection.size();
            for (int i = 0; i < size; ++i) {
                RecuritmentDemandInfo info = demandCollection.get(i);
                info.setBillState(state);
                info.put("approveDate", new Timestamp(System.currentTimeMillis()));
                info.put("autoFilter", true);
                if (HRBillStateEnum.SAVED == state) {
                    info.put("flowState", (Object)FlowStateEnum.UNSUBMIT);
                } else if (HRBillStateEnum.AUDITEND == state) {
                    info.put("flowState", (Object)FlowStateEnum.STOP);
                    info.put("releaseState", (Object)ReleaseStateEnum.EMPTY);
                } else {
                    info.put("flowState", (Object)FlowStateEnum.BEING);
                }
                coll.add((CoreBaseInfo)info);
            }
            RecuritmentDemandFactory.getLocalInstance(ctx).update(coll);
        }
    }

    private void mokaAddJobForRecuritment(Context ctx, String billId) throws BOSException, EASBizException {
        RecuritmentDemandCollection demandCollection = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select id where bill = '" + billId + "'");
        if (demandCollection != null && demandCollection.size() > 0) {
            StringBuffer socialRecDemandIds = new StringBuffer();
            StringBuffer schoolRecDemandIds = new StringBuffer();
            int size = demandCollection.size();
            for (int i = 0; i < size; ++i) {
                RecuritmentDemandInfo demandInfo = demandCollection.get(i);
                this.mokaService.findRecDemandId(ctx, demandInfo.getId().toString(), socialRecDemandIds, schoolRecDemandIds);
            }
            this.mokaService._doAddMokaJob(ctx, socialRecDemandIds, schoolRecDemandIds);
        }
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        logger.debug((Object)"---------------\u8bbe\u7f6e\u62a5\u6279\u5355\u636e\u72b6\u6001\uff1a\u672a\u63d0\u4ea4---------------");
        super._setEditState(ctx, billId);
        this.setDemandApproveState(ctx, billId, HRBillStateEnum.SAVED);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._submit(ctx, model);
        RecDemandBillInfo billInfo = RecDemandBillFactory.getLocalInstance(ctx).getRecDemandBillInfo("select entrys,entrys.staff where id = '" + model.getString("id") + "'");
        RecuritmentDemandCollection demandCollection = billInfo.getEntrys();
        CoreBaseCollection updateDemandColl = new CoreBaseCollection();
        for (int j = 0; j < demandCollection.size(); ++j) {
            RecuritmentDemandInfo demandInfo = demandCollection.get(j);
            demandInfo.setFlowState(FlowStateEnum.BEING);
            demandInfo.setBillState(HRBillStateEnum.SUBMITED);
            demandInfo.setApplyDate(new Timestamp(System.currentTimeMillis()));
            updateDemandColl.add((CoreBaseInfo)demandInfo);
        }
        RecuritmentDemandFactory.getLocalInstance(ctx).update(updateDemandColl);
        return objectPK;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateAdminOrgUnit(model);
        super._update(ctx, pk, model);
    }

    private void updateAdminOrgUnit(IObjectValue model) throws BOSException, EASBizException {
        RecDemandBillInfo info = (RecDemandBillInfo)model;
        if (info.getEntrys().size() > 0) {
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                AdminOrgUnitInfo department = info.getEntrys().get(i).getDepartment();
                if (department == null) continue;
                info.setAdminOrg(department);
                if (!logger.isDebugEnabled()) break;
                logger.error((Object)"\u6279\u91cf\u9700\u6c42\u5355\u636e\u5df2\u7ecf\u8bbe\u7f6e\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7");
                break;
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateAdminOrgUnit(model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }
}

