/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.BlackListOpType;
import com.kingdee.eas.hr.base.BlackListReasonFactory;
import com.kingdee.eas.hr.base.BlackListReasonInfo;
import com.kingdee.eas.hr.base.IPersonBlackList;
import com.kingdee.eas.hr.base.IPersonBlackListHis;
import com.kingdee.eas.hr.base.PersonBlackListCollection;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListHisCollection;
import com.kingdee.eas.hr.base.PersonBlackListHisFactory;
import com.kingdee.eas.hr.base.PersonBlackListHisInfo;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.hr.base.SourceEnum;
import com.kingdee.eas.hr.base.StateEnum;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.recuritment.EnterpriseArchivesCollection;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.IEnterpriseArchives;
import com.kingdee.shr.recuritment.IResumeBaseRec;
import com.kingdee.shr.recuritment.IsOrNotEnum;
import com.kingdee.shr.recuritment.RecPersonBlackHisFactory;
import com.kingdee.shr.recuritment.RecPersonBlackHisInfo;
import com.kingdee.shr.recuritment.RecuritmentBillBaseInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeClipRelationFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationInfo;
import com.kingdee.shr.recuritment.SaveResumeFacadeFactory;
import com.kingdee.shr.recuritment.SexEnum;
import com.kingdee.shr.recuritment.app.AbstractRecPersonBlackListFacadeControllerBean;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.util.convert.ResumeConvertUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecPersonBlackListFacadeControllerBean
extends AbstractRecPersonBlackListFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.RecPersonBlackListFacadeControllerBean");

    @Override
    protected void _batchRemoveBlackList(Context ctx, IObjectCollection personBlackListColl, String removeRema) throws BOSException {
        PersonBlackListCollection coll = (PersonBlackListCollection)personBlackListColl;
        Iterator iter = coll.iterator();
        ArrayList<String> idCards = new ArrayList<String>();
        ArrayList<String> passportNos = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        PersonBlackListInfo info = null;
        while (iter.hasNext()) {
            info = (PersonBlackListInfo)iter.next();
            if (!RecDBUtils.isEmpty(info.getIdCardNO())) {
                idCards.add(info.getIdCardNO());
            } else if (!RecDBUtils.isEmpty(info.getPassportNO())) {
                passportNos.add(info.getPassportNO());
            }
            if (RecDBUtils.isEmpty(info.getMobile()) || RecDBUtils.isEmpty(info.getPersonName())) continue;
            builder.append("or ( FName='").append(info.getPersonName()).append("' and FMobilePhone='").append(info.getMobile()).append("')");
        }
        this.doRemoveBlackList(ctx, removeRema, idCards, passportNos, builder);
    }

    private void doRemoveBlackList(Context ctx, String removeRema, List<String> idCards, List<String> passportNos, StringBuilder builder) throws BOSException {
        if (RecDBUtils.isEmpty(idCards) && RecDBUtils.isEmpty(passportNos) && StringUtils.isEmpty((CharSequence)builder)) {
            return;
        }
        if (removeRema == null) {
            removeRema = "";
        }
        String[] updateTables = new String[]{"T_REC_EnterpriseArchives", "T_REC_ResumeBaseRec"};
        ArrayList<Object> params = null;
        StringBuilder sql = null;
        for (String table : updateTables) {
            params = new ArrayList<Object>();
            params.add(2);
            params.add(removeRema);
            sql = new StringBuilder();
            sql.append("UPDATE ").append(table).append(" SET FIsBlackList=?,");
            if ("T_REC_EnterpriseArchives".equals(table)) {
                sql.append("FRemvoeBlackReason = ? ");
            } else {
                sql.append("FOutBlackComment = ? ");
            }
            sql.append(" WHERE 1 != 1 ");
            if (!RecDBUtils.isEmpty(idCards)) {
                sql.append(" OR FIdentityCardNo IN (").append(RecDBUtils.getParamPlaceholder(idCards)).append(") ");
                params.addAll(idCards);
            }
            if (!RecDBUtils.isEmpty(passportNos)) {
                sql.append(" OR FPassportNo IN (").append(RecDBUtils.getParamPlaceholder(passportNos)).append(") ");
                params.addAll(passportNos);
            }
            if (!StringUtils.isEmpty((CharSequence)builder)) {
                sql.append(builder.toString());
            }
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray(new Object[0]));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    protected void _removeBlackList(Context ctx, IObjectValue personBlackListInfo, String removeRema, String personId, String personName) throws BOSException {
        PersonBlackListInfo info = (PersonBlackListInfo)personBlackListInfo;
        IPersonBlackListHis ipBlackHis = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        IPersonBlackList ipBlack = PersonBlackListFactory.getLocalInstance((Context)ctx);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String idCardNo = info.getIdCardNO();
        String passPortNo = info.getPassportNO();
        String mobile = info.getMobile();
        try {
            PersonBlackListHisInfo perBlackHisInfo = new PersonBlackListHisInfo();
            perBlackHisInfo.setBlackName(info.getPersonName());
            perBlackHisInfo.setIdCardNo(idCardNo);
            perBlackHisInfo.setPassPortNo(passPortNo);
            perBlackHisInfo.setMobile(mobile);
            perBlackHisInfo.setSource(SourceEnum.RECURITMENT_MOVE);
            perBlackHisInfo.setOpType(BlackListOpType.REMOVE);
            perBlackHisInfo.setPersonId(personId);
            perBlackHisInfo.setPersonName(personName);
            try {
                perBlackHisInfo.setOpDate(sdf.parse(sdf.format(new Date())));
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            perBlackHisInfo.setLeftDate(info.getLeftDate());
            perBlackHisInfo.setLeftReson(info.getAffairActionReason());
            perBlackHisInfo.setRema(removeRema);
            perBlackHisInfo.setResumeNumber(info.getResumeNumber());
            ipBlackHis.addnew(perBlackHisInfo);
            RecPersonBlackHisInfo recPersonBlackHis = new RecPersonBlackHisInfo();
            recPersonBlackHis.setHrOrgUnit(info.getHrOrgUnit());
            recPersonBlackHis.setPersonBlackListHis(perBlackHisInfo);
            RecPersonBlackHisFactory.getLocalInstance(ctx).addnew(recPersonBlackHis);
            if (info.getSource() == SourceEnum.RECURITMENT_ADD) {
                info.setSource(SourceEnum.RECURITMENT_MOVE);
                ipBlack.save((CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        PersonBlackListCollection coll = new PersonBlackListCollection();
        coll.add(info);
        this._batchRemoveBlackList(ctx, (IObjectCollection)coll, removeRema);
    }

    @Override
    protected void _putBlackList(Context ctx, Map param) throws BOSException {
        String from = (String)param.get("from");
        try {
            if ("enterpriseArchives".equals(from)) {
                this.putEnterpriseArchivesToBlack(ctx, param);
            } else {
                this.putResumeToBlack(ctx, param);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void putResumeToBlack(Context ctx, Map param) throws EASBizException, BOSException {
        ResumeBaseRecCollection _resumeColl;
        BlackListReasonInfo blackListInfo;
        String billId = (String)param.get("billId");
        String toBlackListReasonBillId = (String)param.get("toBlackListReason");
        String identityCardNo = (String)param.get("identityCardNo");
        String hrOrgUnitId = (String)param.get("hrOrgUnitId");
        String joinBlackComment = (String)param.get("joinBlackComment");
        String passportNo = (String)param.get("passportNo");
        String mobilePhone = (String)param.get("mobilePhone");
        String personId = (String)param.get("personId");
        String personName = (String)param.get("personName");
        try {
            blackListInfo = BlackListReasonFactory.getLocalInstance((Context)ctx).getBlackListReasonInfo((IObjectPK)new ObjectUuidPK(toBlackListReasonBillId));
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException("\u83b7\u53d6\u9ed1\u540d\u5355\u539f\u56e0\u51fa\u9519\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        IResumeBaseRec iResumeBaseRec = ResumeBaseRecFactory.getLocalInstance(ctx);
        ResumeBaseRecInfo resume = iResumeBaseRec.getResumeBaseRecInfo((IObjectPK)new ObjectUuidPK(billId));
        if (!StringUtil.isEmpty((String)identityCardNo)) {
            _resumeColl = iResumeBaseRec.getResumeBaseRecCollection("where identityCardNo = '" + identityCardNo + "' and isBlackList = '1'");
            if (_resumeColl != null && _resumeColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u8eab\u4efd\u8bc1\u53f7\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            resume.setIdentityCardNo(identityCardNo);
        } else if (!StringUtil.isEmpty((String)passportNo)) {
            _resumeColl = iResumeBaseRec.getResumeBaseRecCollection("where passportNo = '" + passportNo + "' and isBlackList = '1'");
            if (_resumeColl != null && _resumeColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u62a4\u7167\u53f7\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            resume.setPassportNo(passportNo);
        } else {
            _resumeColl = iResumeBaseRec.getResumeBaseRecCollection("where mobilePhone = '" + mobilePhone + "' and isBlackList = '1' and name='" + resume.getName() + "'");
            if (_resumeColl != null && _resumeColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u624b\u673a\u53f7\u3001\u59d3\u540d\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            resume.setMobilePhone(mobilePhone);
        }
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personinfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
        String ifSimplePerson = resume.getIfSimplePerson();
        if (StringUtils.isEmpty((CharSequence)ifSimplePerson)) {
            SaveResumeFacadeFactory.getLocalInstance(ctx).repeatScreen(resume);
            ifSimplePerson = resume.getIfSimplePerson();
        }
        if (!StringUtil.isEmpty((String)ifSimplePerson)) {
            ResumeBaseRecCollection resumeColl = iResumeBaseRec.getResumeBaseRecCollection("where ifSimplePerson = '" + ifSimplePerson + "'");
            int size = resumeColl.size();
            if (null != resumeColl && size > 0) {
                ResumeBaseRecInfo resumeInfo = null;
                for (int i = 0; i < size; ++i) {
                    resumeInfo = resumeColl.get(i);
                    if (!StringUtils.isEmpty((CharSequence)identityCardNo)) {
                        this.setPeronInfoByID(resume, identityCardNo);
                    }
                    resumeInfo.setIsBlackList(IsOrNotEnum.YES);
                    resumeInfo.setIdentityCardNo(identityCardNo);
                    resumeInfo.setPassportNo(passportNo);
                    resumeInfo.setJoinBlackComment(joinBlackComment);
                    resumeInfo.setJoinBlackDate(new Date());
                    if (StringUtils.equals((CharSequence)resumeInfo.getId().toString(), (CharSequence)billId)) {
                        resumeInfo.setMobilePhone(mobilePhone);
                    }
                    resumeInfo.setToBlackListReason(blackListInfo);
                    resumeInfo.setAddPersonName(personinfo.getName());
                    iResumeBaseRec.update((IObjectPK)new ObjectUuidPK(resumeInfo.getId()), resumeInfo);
                }
            }
        }
        if (null != resume.getIfSimplePerson()) {
            this.joinBlackList(ctx, resume.getIfSimplePerson(), blackListInfo.getId().toString(), identityCardNo, joinBlackComment, personName, personId, passportNo, hrOrgUnitId, resume, mobilePhone);
        }
        ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u6253\u9ed1\u540d\u5355\u6807\u8bb0", "\u8be5\u5019\u9009\u4eba\u6240\u6709\u7b80\u5386\u5171\u4eab", resume);
    }

    private void putEnterpriseArchivesToBlack(Context ctx, Map param) throws EASBizException, BOSException {
        IResumeBaseRec iResumeBaseRec;
        ResumeBaseRecCollection resumeColl;
        EnterpriseArchivesCollection enterpriseArchivesColl;
        BlackListReasonInfo blackListInfo;
        String billId = (String)param.get("billId");
        String toBlackListReasonBillId = (String)param.get("toBlackListReason");
        String identityCardNo = (String)param.get("identityCardNo");
        String hrOrgUnitId = (String)param.get("hrOrgUnitId");
        String joinBlackComment = (String)param.get("joinBlackComment");
        String passportNo = (String)param.get("passportNo");
        String mobilePhone = (String)param.get("mobilePhone");
        String personId = (String)param.get("personId");
        String personName = (String)param.get("personName");
        try {
            blackListInfo = BlackListReasonFactory.getLocalInstance((Context)ctx).getBlackListReasonInfo((IObjectPK)new ObjectUuidPK(toBlackListReasonBillId));
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException("\u83b7\u53d6\u9ed1\u540d\u5355\u539f\u56e0\u51fa\u9519\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        IEnterpriseArchives iEnterpriseArchives = EnterpriseArchivesFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("enterpriseArchives.*");
        ResumeClipRelationInfo relaInfo = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        if (relaInfo == null) {
            throw new BOSException("\u83b7\u53d6\u7b80\u5386\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        EnterpriseArchivesInfo enterpriseArchives = relaInfo.getEnterpriseArchives();
        if (!StringUtil.isEmpty((String)identityCardNo)) {
            enterpriseArchivesColl = iEnterpriseArchives.getEnterpriseArchivesCollection("where identityCardNo = '" + identityCardNo + "' and isBlackList = '1' and state = '" + "1" + "'");
            if (enterpriseArchivesColl != null && enterpriseArchivesColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u8eab\u4efd\u8bc1\u53f7\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            enterpriseArchives.setIdentityCardNo(identityCardNo);
            if (!StringUtils.isEmpty((CharSequence)identityCardNo)) {
                this.setPeronInfoByID(enterpriseArchives, identityCardNo);
            }
        } else if (!StringUtil.isEmpty((String)passportNo)) {
            enterpriseArchivesColl = iEnterpriseArchives.getEnterpriseArchivesCollection("where passportNo = '" + passportNo + "' and isBlackList = '1' and state = '" + "1" + "'");
            if (enterpriseArchivesColl != null && enterpriseArchivesColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u62a4\u7167\u53f7\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            enterpriseArchives.setPassportNo(passportNo);
        } else {
            enterpriseArchivesColl = iEnterpriseArchives.getEnterpriseArchivesCollection("where mobilePhone = '" + mobilePhone + "' and isBlackList = '1' and name='" + enterpriseArchives.getName() + "' and state = '" + "1" + "'");
            if (enterpriseArchivesColl != null && enterpriseArchivesColl.size() > 0) {
                throw new BOSException("\u5df2\u7ecf\u6709\u91cd\u590d\u59d3\u540d\u3001\u624b\u673a\u53f7\u7684\u7b80\u5386\u5728\u9ed1\u540d\u5355\u5f53\u4e2d");
            }
            enterpriseArchives.setMobilePhone(mobilePhone);
        }
        String ifSimplePerson = enterpriseArchives.getUniqId();
        if (null != ifSimplePerson && (resumeColl = (iResumeBaseRec = ResumeBaseRecFactory.getLocalInstance(ctx)).getResumeBaseRecCollection("where ifSimplePerson = '" + ifSimplePerson + "' ")) != null && resumeColl.size() > 0) {
            for (int i = 0; i < resumeColl.size(); ++i) {
                ResumeBaseRecInfo resume = resumeColl.get(i);
                resume.setIsBlackList(IsOrNotEnum.YES);
                resume.setIdentityCardNo(identityCardNo);
                resume.setPassportNo(passportNo);
                if (!StringUtils.isEmpty((CharSequence)identityCardNo)) {
                    this.setPeronInfoByID(resume, identityCardNo);
                }
                resume.setJoinBlackComment(joinBlackComment);
                resume.setJoinBlackDate(new Date());
                resume.setToBlackListReason(blackListInfo);
                resume.setAddPersonName(personName);
                iResumeBaseRec.update((IObjectPK)new ObjectUuidPK(resume.getId().toString()), resume);
            }
        }
        this.joinBlackList(ctx, ifSimplePerson, blackListInfo.getId().toString(), identityCardNo, joinBlackComment, personName, personId, passportNo, hrOrgUnitId, enterpriseArchives, mobilePhone);
        ResumeOperRecordService.getInstance().addEnterpriseArchivesOperRecord(ctx, "\u6253\u9ed1\u540d\u5355\u6807\u8bb0", "\u8be5\u5019\u9009\u4eba\u6240\u6709\u7b80\u5386\u5171\u4eab", relaInfo);
    }

    private void setPeronInfoByID(RecuritmentBillBaseInfo resume, String identityCardNo) throws BOSException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            IDCardCommonUtil iDCardUtil = new IDCardCommonUtil(identityCardNo, true);
            if (resume instanceof ResumeBaseRecInfo) {
                ResumeBaseRecInfo resumeInfo = (ResumeBaseRecInfo)resume;
                resumeInfo.setBirthday(sdf.parse(iDCardUtil.getBirthday()));
                if (iDCardUtil.getGenders().getValue() == 1) {
                    resumeInfo.setSex(SexEnum.MAN);
                } else {
                    resumeInfo.setSex(SexEnum.WOMAN);
                }
            } else {
                EnterpriseArchivesInfo enterpriseArchives = (EnterpriseArchivesInfo)resume;
                enterpriseArchives.setBirthday(sdf.parse(iDCardUtil.getBirthday()));
                if (iDCardUtil.getGenders().getValue() == 1) {
                    enterpriseArchives.setSex(SexEnum.MAN);
                } else {
                    enterpriseArchives.setSex(SexEnum.WOMAN);
                }
            }
        }
        catch (BaseException e) {
            throw new BOSException(e.getMessage().toString(), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u8eab\u4efd\u8bc1\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
        }
    }

    public String joinBlackList(Context ctx, String uuid, String joinReason, String idcardNo, String joinRema, String personName, String personId, String passPortNo, String hrOrgUnitId, RecuritmentBillBaseInfo resume, String mobilePhone) throws BOSException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        EnterpriseArchivesInfo enArchivesInfo = null;
        IEnterpriseArchives ienArchives = EnterpriseArchivesFactory.getLocalInstance(ctx);
        BlackListReasonInfo blackInfo = null;
        String result = "";
        String resumeId = "";
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            enArchivesInfo = (EnterpriseArchivesInfo)resume;
            enArchivesInfo.setUniqId(ResumeConvertUtil.getSimplePersonFlag());
        } else {
            EnterpriseArchivesCollection enArchivesColl = ienArchives.getEnterpriseArchivesCollection("where uniqId='" + uuid + "' AND state = '" + "1" + "' order by lastUpdateTime desc ");
            if (enArchivesColl == null || enArchivesColl.size() != 1) {
                throw new BOSException("\u7b80\u5386\u5e93uniqId\uff1a" + uuid + "\u5bf9\u5e94\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01");
            }
            enArchivesInfo = enArchivesColl.get(0);
        }
        if (null != enArchivesInfo) {
            int isBlack;
            blackInfo = BlackListReasonFactory.getLocalInstance((Context)ctx).getBlackListReasonInfo((IObjectPK)new ObjectUuidPK(joinReason));
            enArchivesInfo.setToBlackListReason(blackInfo);
            enArchivesInfo.setIdentityCardNo(idcardNo);
            enArchivesInfo.setPassportNo(passPortNo);
            enArchivesInfo.setMobilePhone(mobilePhone);
            enArchivesInfo.setJoinBlackListRema(joinRema);
            enArchivesInfo.setAddPersonName(personName);
            enArchivesInfo.put("joinBlackDate", sdf.format(new Date()));
            if (resume != null) {
                resumeId = resume.getId().toString();
            }
            if ((isBlack = enArchivesInfo.getIsBlackList().getValue()) == 1) {
                result = "hasexist";
            } else {
                enArchivesInfo.setIsBlackList(IsOrNotEnum.YES);
                ienArchives.save((CoreBaseInfo)enArchivesInfo);
                result = "success";
            }
            this.addRecordToBlackListHis(ctx, enArchivesInfo, blackInfo, personId, personName, joinRema, hrOrgUnitId, resumeId);
            this.addRecordToBlackList(ctx, enArchivesInfo, blackInfo, personId, personName, joinRema, hrOrgUnitId, resumeId);
        }
        return result;
    }

    public void addRecordToBlackListHis(Context ctx, EnterpriseArchivesInfo enArchivesInfo, BlackListReasonInfo blackReasonInfo, String personId, String personName, String joinBlackListRema, String hrOrgUnitId, String resumeId) throws BOSException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        IPersonBlackListHis ipBlackHis = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        PersonBlackListHisInfo perBlackHisInfo = new PersonBlackListHisInfo();
        perBlackHisInfo.setBlackName(enArchivesInfo.getName());
        perBlackHisInfo.setIdCardNo(enArchivesInfo.getIdentityCardNo());
        perBlackHisInfo.setPassPortNo(enArchivesInfo.getPassportNo());
        perBlackHisInfo.setMobile(enArchivesInfo.getMobilePhone());
        perBlackHisInfo.setSource(SourceEnum.RECURITMENT_ADD);
        perBlackHisInfo.setOpType(BlackListOpType.JOIN);
        perBlackHisInfo.setPersonId(personId);
        perBlackHisInfo.setPersonName(personName);
        try {
            perBlackHisInfo.setOpDate(sdf.parse(sdf.format(new Date())));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        perBlackHisInfo.setLeftDate(null);
        perBlackHisInfo.setJoinReason(blackReasonInfo);
        perBlackHisInfo.setLeftReson(null);
        perBlackHisInfo.setRema(joinBlackListRema);
        perBlackHisInfo.setResumeNumber(resumeId);
        ipBlackHis.addnew(perBlackHisInfo);
        RecPersonBlackHisInfo recPersonBlackHis = new RecPersonBlackHisInfo();
        recPersonBlackHis.setHrOrgUnit(HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitId)));
        recPersonBlackHis.setPersonBlackListHis(perBlackHisInfo);
        RecPersonBlackHisFactory.getLocalInstance(ctx).addnew(recPersonBlackHis);
        PersonBlackListHisCollection blackListHisCollection = ResumeConvertUtil.findBlackListHisByUniqueId(ctx, enArchivesInfo.getUniqId());
        CoreBaseCollection hisCoreBaseCollection = new CoreBaseCollection();
        if (!RecDBUtils.isEmpty((IObjectCollection)blackListHisCollection)) {
            for (int i = 0; i < blackListHisCollection.size(); ++i) {
                PersonBlackListHisInfo personBlackListHisInfo = blackListHisCollection.get(i);
                if (StringUtils.isEmpty((CharSequence)personBlackListHisInfo.getResumeNumber())) {
                    personBlackListHisInfo.setResumeNumber(resumeId);
                }
                personBlackListHisInfo.setIdCardNo(StringUtils.isEmpty((CharSequence)enArchivesInfo.getIdentityCardNo()) ? personBlackListHisInfo.getIdCardNo() : enArchivesInfo.getIdentityCardNo());
                personBlackListHisInfo.setPassPortNo(StringUtils.isEmpty((CharSequence)enArchivesInfo.getPassportNo()) ? personBlackListHisInfo.getPassPortNo() : enArchivesInfo.getPassportNo());
                personBlackListHisInfo.setMobile(StringUtils.isEmpty((CharSequence)enArchivesInfo.getMobilePhone()) ? personBlackListHisInfo.getMobile() : enArchivesInfo.getMobilePhone());
                personBlackListHisInfo.setBlackName(StringUtils.isEmpty((CharSequence)enArchivesInfo.getName()) ? personBlackListHisInfo.getBlackName() : enArchivesInfo.getName());
                hisCoreBaseCollection.add((CoreBaseInfo)personBlackListHisInfo);
            }
            PersonBlackListHisFactory.getLocalInstance((Context)ctx).update(hisCoreBaseCollection);
        }
    }

    public void addRecordToBlackList(Context ctx, EnterpriseArchivesInfo enArchivesInfo, BlackListReasonInfo blackReasonInfo, String personId, String personName, String joinBlackListRema, String hrOrgUnitId, String resumeId) throws BOSException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        PersonBlackListInfo personBlackInfo = new PersonBlackListInfo();
        IPersonBlackList ipBlack = PersonBlackListFactory.getLocalInstance((Context)ctx);
        PersonBlackListCollection blackListCollection = ResumeConvertUtil.findBlackListByUniqueId(ctx, enArchivesInfo.getUniqId());
        if (!RecDBUtils.isEmpty((IObjectCollection)blackListCollection)) {
            personBlackInfo = blackListCollection.get(0);
        }
        personBlackInfo.setHrOrgUnit(HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitId)));
        personBlackInfo.setIdCardNO(enArchivesInfo.getIdentityCardNo());
        personBlackInfo.setPassportNO(enArchivesInfo.getPassportNo());
        personBlackInfo.setMobile(enArchivesInfo.getMobilePhone());
        personBlackInfo.setState(StateEnum.ENABLE);
        personBlackInfo.setSource(SourceEnum.RECURITMENT_ADD);
        personBlackInfo.setPersonName(enArchivesInfo.getName());
        personBlackInfo.setJoinReason(blackReasonInfo);
        personBlackInfo.setAddPersonId(personId);
        personBlackInfo.setAddPersonName(personName);
        try {
            personBlackInfo.setJoinDate(sdf.parse(sdf.format(new Date())));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        personBlackInfo.setRema(joinBlackListRema);
        personBlackInfo.setDescription(joinBlackListRema);
        personBlackInfo.setResumeNumber(resumeId);
        if (!RecDBUtils.isEmpty((IObjectCollection)blackListCollection)) {
            ipBlack.update((IObjectPK)new ObjectUuidPK(personBlackInfo.getId().toString()), (CoreBaseInfo)personBlackInfo);
        } else {
            ipBlack.addnew((CoreBaseInfo)personBlackInfo);
        }
    }

    @Override
    protected void _removeResumeBlackList(Context ctx, Map param) throws BOSException {
        String uniqId = (String)param.get("uniqId");
        String remvoeBlackReason = (String)param.get("removeReason");
        String personId = (String)param.get("personId");
        String personName = (String)param.get("personName");
        if (!StringUtils.isEmpty((CharSequence)uniqId)) {
            try {
                this.removeBlackList(ctx, uniqId, remvoeBlackReason, personId, personName);
                this.removeBlack(ctx, uniqId, remvoeBlackReason);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new BOSException("\u7b80\u5386\u5e93uniqId\uff1a" + uniqId + "\u5bf9\u5e94\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01");
        }
    }

    public void removeBlackList(Context ctx, String uuid, String removeReason, String operId, String operName) throws BOSException, EASBizException {
        IEnterpriseArchives ienArchives = EnterpriseArchivesFactory.getLocalInstance(ctx);
        boolean flag = true;
        EnterpriseArchivesCollection enterpriseArchivesCollection = ienArchives.getEnterpriseArchivesCollection("where uniqId='" + uuid + "' and state = '" + "1" + "'");
        if (RecDBUtils.isEmpty((IObjectCollection)enterpriseArchivesCollection)) {
            throw new BOSException("\u83b7\u53d6\u7b80\u5386\u6570\u636e\u5931\u8d25");
        }
        int isBlack = enterpriseArchivesCollection.get(0).getIsBlackList().getValue();
        for (int i = 0; i < enterpriseArchivesCollection.size(); ++i) {
            EnterpriseArchivesInfo enArchivesInfo = enterpriseArchivesCollection.get(i);
            enArchivesInfo.setRemvoeBlackReason(removeReason);
            if (isBlack != 1) continue;
            enArchivesInfo.setIsBlackList(IsOrNotEnum.REMOVE);
            ienArchives.save((CoreBaseInfo)enArchivesInfo);
            if (!flag) continue;
            this.removeBlackListAndJoinHis(ctx, enArchivesInfo, removeReason, operId, operName);
            flag = false;
        }
    }

    public void removeBlackListAndJoinHis(Context ctx, EnterpriseArchivesInfo enArchivesInfo, String removeReason, String operId, String operName) throws BOSException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        IPersonBlackList ipBlack = PersonBlackListFactory.getLocalInstance((Context)ctx);
        IPersonBlackListHis ipBlackHis = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        PersonBlackListInfo personBlackInfo = null;
        PersonBlackListCollection blackListCollection = null;
        if (null != enArchivesInfo) {
            blackListCollection = ResumeConvertUtil.findBlackListByUniqueId(ctx, enArchivesInfo.getUniqId());
        }
        if (blackListCollection != null && blackListCollection.size() > 0) {
            personBlackInfo = blackListCollection.get(0);
            if (personBlackInfo.getSource().getValue() != 5) {
                throw new BOSException("\u5f53\u524d\u7b80\u5386\u662f\u4eba\u4e8b\u52a0\u5165\u7684\u9ed1\u540d\u5355\uff0c\u4ec5\u652f\u6301\u79fb\u9664\u62db\u8058\u52a0\u5165\u7684\u9ed1\u540d\u5355\uff0c\u5176\u4ed6\u8bf7\u5230\u4eba\u4e8b\u6a21\u5757-\u79bb\u804c\u83dc\u5355\u4e2d\u64cd\u4f5c\u79fb\u9664\uff01");
            }
            PersonBlackListHisInfo perBlackHisInfo = new PersonBlackListHisInfo();
            perBlackHisInfo.setBlackName(enArchivesInfo.getName());
            perBlackHisInfo.setIdCardNo(enArchivesInfo.getIdentityCardNo());
            perBlackHisInfo.setPassPortNo(enArchivesInfo.getPassportNo());
            perBlackHisInfo.setMobile(enArchivesInfo.getMobilePhone());
            perBlackHisInfo.setSource(SourceEnum.RECURITMENT_MOVE);
            perBlackHisInfo.setOpType(BlackListOpType.REMOVE);
            perBlackHisInfo.setPersonId(operId);
            perBlackHisInfo.setPersonName(operName);
            try {
                perBlackHisInfo.setOpDate(sdf.parse(sdf.format(new Date())));
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("\u8eab\u4efd\u8bc1\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
            }
            perBlackHisInfo.setLeftDate(personBlackInfo.getLeftDate());
            perBlackHisInfo.setLeftReson(personBlackInfo.getAffairActionReason());
            perBlackHisInfo.setRema(removeReason);
            perBlackHisInfo.setResumeNumber(enArchivesInfo.getId().toString());
            ipBlackHis.addnew(perBlackHisInfo);
            personBlackInfo.setSource(SourceEnum.RECURITMENT_MOVE);
            personBlackInfo.setState(StateEnum.DISABLE);
            ipBlack.save((CoreBaseInfo)personBlackInfo);
            RecPersonBlackHisInfo recPersonBlackHis = new RecPersonBlackHisInfo();
            recPersonBlackHis.setHrOrgUnit(personBlackInfo.getHrOrgUnit());
            recPersonBlackHis.setPersonBlackListHis(perBlackHisInfo);
            RecPersonBlackHisFactory.getLocalInstance(ctx).addnew(recPersonBlackHis);
        } else {
            logger.error((Object)("\u6570\u636e\u5f02\u5e38\uff0c\u5728\u9ed1\u540d\u5355\u5217\u8868\u4e2d\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u7b80\u5386\u4fe1\u606f\uff01uniqId:" + enArchivesInfo.getUniqId() + ";name:" + enArchivesInfo.getName()));
        }
    }

    public void removeBlack(Context ctx, String uniqueId, String comment) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((CharSequence)uniqueId)) {
            IResumeBaseRec iResumeBaseRec;
            ResumeBaseRecCollection resumeColl;
            if (comment == null) {
                comment = "";
            }
            if ((resumeColl = (iResumeBaseRec = ResumeBaseRecFactory.getLocalInstance(ctx)).getResumeBaseRecCollection("where ifSimplePerson = '" + uniqueId + "' ")) != null && resumeColl.size() > 0) {
                for (int i = 0; i < resumeColl.size(); ++i) {
                    ResumeBaseRecInfo resume = resumeColl.get(i);
                    resume.setIsBlackList(IsOrNotEnum.REMOVE);
                    resume.setOutBlackComment(comment);
                    iResumeBaseRec.update((IObjectPK)new ObjectUuidPK(resume.getId()), resume);
                }
            }
        }
    }
}

