/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.integraterec.IntegrateAccountFactory;
import com.kingdee.shr.recuritment.FlowStateEnum;
import com.kingdee.shr.recuritment.RecuritmentBillBaseInfo;
import com.kingdee.shr.recuritment.ReleaseStateEnum;
import com.kingdee.shr.recuritment.app.AbstractRecuritmentBillBaseControllerBean;
import com.kingdee.shr.recuritment.app.service.RecuritmentDemandMokaService;
import com.kingdee.shr.recuritment.app.service.RecuritmentDemandTuPuService;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecuritmentBillBaseControllerBean
extends AbstractRecuritmentBillBaseControllerBean {
    private static final long serialVersionUID = 1542787663271626529L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.RecuritmentBillBaseControllerBean");
    private IHRBillBizBean bizBean = null;
    private RecuritmentDemandMokaService mokaService = RecuritmentDemandMokaService.getInstance();
    private RecuritmentDemandTuPuService tuPuService = RecuritmentDemandTuPuService.getInstance();

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
        this._sendAssignedMsgToXT(ctx, billId);
        this.setBillFlowStateToBegin(ctx, billId);
        boolean exists = IntegrateAccountFactory.getLocalInstance((Context)ctx).exists("where integrateType = 1 and  integrateStatus = 1 ");
        if (exists) {
            this.mokaAddJobForRecuritment(ctx, billId.toString());
        }
        this.tuPuService.submitEffectAddTuPuJob(ctx, billId.toString(), "AutoPush");
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITEND);
        this._sendAssignedMsgToXT(ctx, billId);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(HRBillStateEnum.AUDITEND);
        info.put("flowState", (Object)FlowStateEnum.STOP);
        info.put("releaseState", (Object)ReleaseStateEnum.EMPTY);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("flowState"));
        selectors.add(new SelectorItemInfo("releaseState"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(HRBillStateEnum.SAVED);
        info.put("approveDate", sdf.format(new Date()));
        info.put("autoFilter", true);
        info.put("flowState", (Object)FlowStateEnum.UNSUBMIT);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("approveDate"));
        selectors.add(new SelectorItemInfo("autoFilter"));
        selectors.add(new SelectorItemInfo("flowState"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(state);
        info.put("approveDate", sdf.format(new Date()));
        info.put("autoFilter", true);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("approveDate"));
        selectors.add(new SelectorItemInfo("autoFilter"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected void _batchPassAudit(Context ctx, String[] billIds) throws BOSException, EASBizException {
    }

    @Override
    protected void _setEffectDate(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
    }

    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        RecuritmentBillBaseInfo bill = (RecuritmentBillBaseInfo)model;
        bill.setApproveType(ApproveTypeEnum.DIRECT);
        bill.setBillState(HRBillStateEnum.AUDITED);
        IObjectPK objectPK = super.save(ctx, model);
        this.setAudited(ctx, BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
        this.setBillFlowStateToBegin(ctx, billID);
    }

    private void mokaAddJobForRecuritment(Context ctx, String billId) throws BOSException, EASBizException {
        StringBuffer socialRecDemandIds = new StringBuffer();
        StringBuffer schoolRecDemandIds = new StringBuffer();
        this.mokaService.findRecDemandId(ctx, billId, socialRecDemandIds, schoolRecDemandIds);
        this.mokaService._doAddMokaJob(ctx, socialRecDemandIds, schoolRecDemandIds);
    }

    private void setBillFlowStateToBegin(Context ctx, BOSUuid billID) throws BOSException {
        String sql = "SELECT FlowState,FBillState FROM T_REC_RecuritmentDemand WHERE FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billID.toString()});
        int flowState = -1;
        int billState = -1;
        try {
            if (rs.next()) {
                flowState = rs.getInt("FlowState");
                billState = rs.getInt("FBillState");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (3 == billState) {
            sql = "UPDATE T_REC_RecuritmentDemand SET FlowState = ?,FReleaseState = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{0, 0, billID.toString()});
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean != null) {
            BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
            PlugInBeanProxy plugIn = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(this.getBOSType());
            if (entity != null) {
                String fullName = entity.getFullName();
                try {
                    plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                }
                catch (Exception e) {
                    throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                }
            }
            IReflectMethod[] decorators = null;
            if (plugIn != null && billExtend != null) {
                decorators = new IReflectMethod[]{plugIn, billExtend};
            } else if (billExtend != null) {
                decorators = new IReflectMethod[]{billExtend};
            } else if (plugIn != null) {
                decorators = new IReflectMethod[]{plugIn};
            }
            if (decorators != null) {
                try {
                    this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                }
                catch (Throwable e) {
                    throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                }
            }
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void abortWorkFlow(Context ctx, String billId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0) {
            return;
        }
        ProcessInstInfo processInstInfo = null;
        int length = procInsts.length;
        for (int i = 0; i < length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo != null) {
            service.abortProcessInst(processInstInfo.getProcInstId().toString());
        }
    }

    @Override
    protected void _setNoPassStateStop(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HROrgUnitCollection collection;
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getHrOrgUnit() == null && (collection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("where isSealUp = 0 and parent is null")).size() > 0) {
            info.setHrOrgUnit(collection.get(0));
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HROrgUnitCollection collection;
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getHrOrgUnit() == null && (collection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("where isSealUp = 0 and parent is null")).size() > 0) {
            info.setHrOrgUnit(collection.get(0));
        }
        super._update(ctx, pk, model);
    }
}

