/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.DemandCompeteExtendInfo;
import com.kingdee.shr.recuritment.DemandWorkAreaCollection;
import com.kingdee.shr.recuritment.DemandWorkAreaFactory;
import com.kingdee.shr.recuritment.DemandWorkAreaInfo;
import com.kingdee.shr.recuritment.ExperienceEnum;
import com.kingdee.shr.recuritment.FilterCriteriaFactory;
import com.kingdee.shr.recuritment.FilterCriteriaInfo;
import com.kingdee.shr.recuritment.FlowStateEnum;
import com.kingdee.shr.recuritment.IRecuritmentDemandStaff;
import com.kingdee.shr.recuritment.IsOrNotEnum;
import com.kingdee.shr.recuritment.MaleOrFemaleEnum;
import com.kingdee.shr.recuritment.RecDemandLinkBenefitsInfo;
import com.kingdee.shr.recuritment.RecDemandLinkRecTypeInfo;
import com.kingdee.shr.recuritment.RecuritTypeEnum;
import com.kingdee.shr.recuritment.RecuritmentBillBaseInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandExtendInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandStaffFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandStaffInfo;
import com.kingdee.shr.recuritment.RecuritmentTypeCollection;
import com.kingdee.shr.recuritment.RecuritmentTypeInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.WorkAgeEnum;
import com.kingdee.shr.recuritment.WorkYearEnum;
import com.kingdee.shr.recuritment.app.AbstractRecuritmentDemandControllerBean;
import com.kingdee.shr.recuritment.app.bo.ObjectBase;
import com.kingdee.shr.recuritment.app.bo.interviewGo.TargetPosition;
import com.kingdee.shr.recuritment.app.service.RecuritmentDemandTuPuService;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecuritmentDemandControllerBean
extends AbstractRecuritmentDemandControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.RecuritmentDemandControllerBean");
    private RecuritmentDemandTuPuService tuPuService = RecuritmentDemandTuPuService.getInstance();

    @Override
    protected void _againstApprove(Context ctx, String[] billIds) throws BOSException {
        IMultiApprove iApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        try {
            for (String billId : billIds) {
                paramsList.add(new Object[]{billId});
                iApprove.deleteByBillId(billId);
                ProcessInstInfo[] procInsts = service.getAllProcessInstancesByBizobjId(billId);
                if (procInsts == null || procInsts.length <= 0) continue;
                int len = procInsts.length;
                String[] procInstIds = new String[len];
                for (int i = 0; i < len; ++i) {
                    procInstIds[i] = procInsts[i].getProcInstId();
                }
                service.batchPhysicsDelete(procInstIds);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sql = "UPDATE T_REC_RecuritmentDemand SET FBillState = 0,FlowState = 3,FReleaseState=100 WHERE FID = ?";
        try {
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.tuPuService.updateStatusTuPuJob(ctx, billIds, "againstApprove");
    }

    @Override
    protected String[] _filterReleasedOrHasResumesDemandIds(Context ctx, String[] billIds) throws BOSException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < billIds.length; ++i) {
            if (i == 0) {
                sb.append("'").append(billIds[i]).append("'");
                continue;
            }
            sb.append(",").append("'").append(billIds[i]).append("'");
        }
        String sql = "SELECT t.FID id,t.FNumber number,t.FResumeAllNum num,t.FReleaseState posState,p.FReleaseState dayState, tp.FTupuReleaseStatus tpState FROM T_REC_RecuritmentDemand t  left join T_REC_DemandCompeteExtend p on t.FID = p.FRecuritmentDemandID  left join T_REC_DemandTpRelated tp on t.FID = tp.FRecuritmentDemandId WHERE t.FID IN (" + sb.toString() + ") or t.FBillID IN (select FBillID from T_REC_RecuritmentDemand where FID in (" + sb.toString() + ")) ";
        IRowSet rs = null;
        ArrayList<String> list = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            list = new ArrayList<String>();
            while (rs.next()) {
                String demandId = rs.getString("id");
                String number = rs.getString("number");
                long resumes = rs.getLong("num");
                int releaseState = rs.getInt("posState");
                int dayState = rs.getInt("dayState");
                int tpState = rs.getInt("tpState");
                if (resumes <= 0L && releaseState != 1 && dayState != 1 && tpState != 2 && tpState != 3 && tpState != 4) continue;
                list.add(number);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        String[] ary = list.toArray(new String[0]);
        return ary;
    }

    @Override
    protected void _saveRecTypes(Context ctx, String[] recTypes, IObjectPK recDemandId) throws BOSException {
        String sql = "DELETE FROM T_REC_RecDemandLinkRecType WHERE FDemandID = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recDemandId.toString()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        ObjectBase ob = new ObjectBase(ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(recTypes.length);
        for (String recType : recTypes) {
            paramsList.add(new Object[]{BOSUuid.create((BOSObjectType)new RecDemandLinkRecTypeInfo().getBOSType()).toString(), recDemandId.toString(), recType, ob.getCreatorId(), ob.getCreateTime(), ob.getLastUpdateUserId(), ob.getLastUpdateTime(), ob.getCUId()});
        }
        String fields = "FID,FDemandID,FTypeID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID";
        sql = "INSERT INTO T_REC_RecDemandLinkRecType (" + fields + ") VALUES (" + RecDBUtils.getParamPlaceholder(fields) + ")";
        try {
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.updateDemandRecuritmentType(ctx, recDemandId);
    }

    private void updateDemandRecuritmentType(Context ctx, IObjectPK recDemandId) throws BOSException {
        RecuritmentTypeCollection typeColl = (RecuritmentTypeCollection)this._getDemandRecTypes(ctx, recDemandId);
        Iterator typeIter = typeColl.iterator();
        StringBuilder sb = new StringBuilder();
        RecuritmentTypeInfo typeInfo = null;
        int index = 0;
        while (typeIter.hasNext()) {
            typeInfo = (RecuritmentTypeInfo)typeIter.next();
            if (index > 0) {
                sb.append(",");
            }
            sb.append(typeInfo.getName());
            ++index;
        }
        String sql = "UPDATE T_REC_RecuritmentDemand SET FRecuritmentType = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sb.toString(), recDemandId.toString()});
    }

    @Override
    protected void _saveBenefits(Context ctx, List saveBenefitsIds, IObjectPK recDemandId) throws BOSException {
        String sql = "DELETE FROM T_REC_RecDemandLinkBenefits WHERE FDemandID = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recDemandId.toString()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (RecDBUtils.isEmpty(saveBenefitsIds)) {
            return;
        }
        ObjectBase ob = new ObjectBase(ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(saveBenefitsIds.size());
        for (Object bid : saveBenefitsIds) {
            paramsList.add(new Object[]{BOSUuid.create((BOSObjectType)new RecDemandLinkBenefitsInfo().getBOSType()).toString(), recDemandId.toString(), bid, ob.getCreatorId(), ob.getCreateTime(), ob.getLastUpdateUserId(), ob.getLastUpdateTime(), ob.getCUId()});
        }
        String fields = "FID,FDemandID,FBenefitsID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID";
        sql = "INSERT INTO T_REC_RecDemandLinkBenefits (" + fields + ") VALUES (" + RecDBUtils.getParamPlaceholder(fields) + ")";
        try {
            RecDBUtils.executeBatch(ctx, sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void _savePassApproveDemandDate(Context ctx, IObjectValue demandInfo) throws BOSException {
        RecuritmentDemandInfo info = (RecuritmentDemandInfo)demandInfo;
        List benefitIds = (List)demandInfo.get("benefitIds");
        this._saveBenefits(ctx, benefitIds, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        DemandCompeteExtendInfo competeExtend = info.getCompeteExtendBack();
        RecuritmentDemandExtendInfo extend = info.getExtendBack();
        String updateFields = "FHROrgUnitID,FRECURITPOSITIONID,FHRJOBID,FPositionName,FOutReleasePositionID,FJobNature,FRecuritNumber,FSalary,FSex,FUseCustomSalary,FLowSalary,FHighSalary,FLowJobGrade,FHighJobGrade,FAddress,FRecPersonType,FResponsibilities,FQualification,FRecRema,FArrivalDate,FHDegreeID,FUseCustomLink,FScheme,FLastUpdateUserID,FlastUpdateTime,FReleaseOrgName,flowState,FExtendBackID,FCompeteExtendBackID,FIsKeyTalents,FResumeClipBaseID ";
        String sql = "UPDATE T_REC_RecuritmentDemand SET " + RecDBUtils.translateUpdateFields(updateFields) + " WHERE FID = ?";
        ObjectBase ob = new ObjectBase(ctx);
        Object[] params = new Object[]{info.getHrOrgUnit() == null ? null : info.getHrOrgUnit().getId().toString(), info.getRecuritPosition() == null ? null : info.getRecuritPosition().getId().toString(), info.getHrJob() == null ? null : info.getHrJob().getId().toString(), info.getPositionName(), info.getOutReleasePosition() == null ? null : info.getOutReleasePosition().getId().toString(), info.getJobNature() == null ? null : Integer.valueOf(info.getJobNature().getValue()), info.getRecuritNumber(), info.isUseCustomSalary() ? null : (info.getSalary() == null ? null : Integer.valueOf(info.getSalary().getValue())), info.getSex() == null ? null : Integer.valueOf(info.getSex().getValue()), info.isUseCustomSalary() ? 1 : 0, info.getLowSalary(), info.getHighSalary(), info.getLowJobGrade() == null ? null : info.getLowJobGrade().getId().toString(), info.getHighJobGrade() == null ? null : info.getHighJobGrade().getId().toString(), info.getAddress(), info.getRecPersonType() == null ? null : info.getRecPersonType().getValue(), info.getResponsibilities(), info.getQualification(), info.getRecRema(), info.getArrivalDate(), info.getHDegree() == null ? null : info.getHDegree().getId().toString(), info.isUseCustomLink() ? 1 : 0, info.isUseCustomLink() ? null : info.getScheme().getId().toString(), ob.getLastUpdateUser().getId().toString(), ob.getLastUpdateTime(), info.getReleaseOrgName(), info.getFlowState().getValue(), extend == null ? null : extend.getId().toString(), competeExtend == null ? null : competeExtend.getId().toString(), info.getIsKeyTalents() == null ? 0 : info.getIsKeyTalents().getValue(), info.getResumeClipBase() == null ? null : info.getResumeClipBase().getId().toString(), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        updateFields = "FLowWorkYears,FHighWorkYears,FSex,FDegreeAbove,FDegreeNoLimit,FLowAge,FHighAge";
        sql = "UPDATE T_REC_FilterCriteria SET " + RecDBUtils.translateUpdateFields(updateFields) + " WHERE fid in (select FFilterCriteriaID from T_REC_Recuritmentdemand where fid = ?)";
        FilterCriteriaInfo fcInfo = info.getFilterCriteria();
        if (fcInfo != null) {
            params = new Object[]{fcInfo.getLowWorkYears() == null ? null : Integer.valueOf(fcInfo.getLowWorkYears().getValue()), fcInfo.getHighWorkYears() == null ? null : Integer.valueOf(fcInfo.getHighWorkYears().getValue()), fcInfo.getSex() == null ? null : Integer.valueOf(fcInfo.getSex().getValue()), fcInfo.isDegreeAbove() ? 1 : 0, fcInfo.isDegreeNoLimit() ? 1 : 0, fcInfo.getLowAge() == null ? null : Integer.valueOf(fcInfo.getLowAge().getValue()), fcInfo.getHighAge() == null ? null : Integer.valueOf(fcInfo.getHighAge().getValue()), info.getId().toString()};
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "update T_REC_DemandCompeteExtend set FJoinGroupYears=? where FRecuritmentDemandID = ?";
        if (competeExtend != null) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Float.valueOf(competeExtend.getJoinGroupYears()), info.getId().toString()});
        }
        sql = "delete from T_REC_DemandWorkArea where FRecuritmentDemandID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
        DemandWorkAreaCollection workArea = info.getWorkArea();
        if (workArea.size() > 0) {
            CoreBaseCollection collection = new CoreBaseCollection();
            for (int i = 0; i < workArea.size(); ++i) {
                DemandWorkAreaInfo areaInfo = new DemandWorkAreaInfo();
                areaInfo.setCityName(workArea.get(i).getCityName());
                areaInfo.setCityVID(workArea.get(i).getCityVID());
                areaInfo.setProvinceName(workArea.get(i).getProvinceName());
                areaInfo.setProvinceVID(workArea.get(i).getProvinceVID());
                areaInfo.setCountyVID(workArea.get(i).getCountyVID());
                areaInfo.setCountryName(workArea.get(i).getCountryName());
                areaInfo.setDetailArea(workArea.get(i).getDetailArea());
                areaInfo.setRecuritmentDemand(info);
                collection.add((CoreBaseInfo)areaInfo);
            }
            try {
                DemandWorkAreaFactory.getLocalInstance(ctx).saveBatchData(collection);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6279\u91cf\u5904\u7406\u62db\u8058\u9700\u6c42\u5730\u70b9\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @Override
    protected IObjectCollection _getDemandRecTypes(Context ctx, IObjectPK billId) throws BOSException {
        String sql = "SELECT TYPE.FNumber,TYPE.FName,TYPE.FState FROM T_REC_RecuritmentType TYPE JOIN T_REC_RecDemandLinkRecType LINK01 ON (TYPE.FID = LINK01.FTypeID) WHERE LINK01.FDemandID = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{billId.toString()});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        RecuritmentTypeCollection coll = new RecuritmentTypeCollection();
        RecuritmentTypeInfo info = null;
        for (Object[] data : datas) {
            info = new RecuritmentTypeInfo();
            info.setNumber((String)data[0]);
            info.setName((String)data[1]);
            boolean state = false;
            Object stateObj = data[2];
            state = stateObj instanceof BigDecimal ? ((BigDecimal)stateObj).intValue() != 0 : (Integer)stateObj != 0;
            info.setState(state);
            coll.add(info);
        }
        return coll;
    }

    @Override
    protected void _recuritmentDemandOldBillUpdate(Context ctx) throws BOSException {
        RecuritmentDemandCollection coll = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("where billVersion is null or billVersion = ''");
        if (RecDBUtils.isEmpty((IObjectCollection)coll)) {
            return;
        }
        Iterator iter = coll.iterator();
        RecuritmentDemandInfo info = null;
        while (iter.hasNext()) {
            info = (RecuritmentDemandInfo)iter.next();
            try {
                RecuritmentDemandFactory.getLocalInstance(ctx).doBillUpdate(info);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)("************************\u5355\u636e\uff1a" + info.getNumber() + " \u5347\u7ea7\u5931\u8d25\uff01**************************"));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("************************" + ctx.getAIS() + "\u5e10\u5957  \u62db\u8058\u9700\u6c42\u5355\u636e\u5347\u7ea7\u5b8c\u6210************************"));
        }
    }

    @Override
    protected void _doBillUpdate(Context ctx, IObjectValue demandInfo) throws BOSException {
        RecuritmentDemandInfo info = (RecuritmentDemandInfo)demandInfo;
        this.doUpdateRecTypes(info, ctx);
        this.doUpdateJobNature(info, ctx);
        this.doUpdateCustomSalary(info, ctx);
        this.doUpdateJobGrade(info, ctx);
        this.doUpdateFilterCriteria(info, ctx);
        this.doUpdateProposer(info, ctx);
        String sql = "UPDATE T_REC_RecuritmentDemand SET FBillVersion = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", info.getId().toString()});
    }

    private void doUpdateProposer(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        PersonInfo proposer = info.getProposer();
        if (proposer != null) {
            String personId = proposer.getId().toString();
            PersonInfo personInfo = null;
            try {
                PersonCollection personColl;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("*********\u62db\u8058\u9700\u6c42 \uff1a" + info.getId() + "\uff1a\u8054\u7cfb\u4eba\u4fe1\u606fId\uff1a" + personId + "**********"));
                }
                if (RecDBUtils.isEmpty((IObjectCollection)(personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id = '" + personId + "'")))) {
                    throw new BOSException("\u901a\u8fc7id\u67e5\u8be2Person\u5931\u8d25\u3002id\uff1a" + personId);
                }
                personInfo = personColl.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            String sql = "UPDATE T_REC_RecuritmentDemand SET FProposerEmail = ?,FProposerOfficePhone = ?,FProposerCell= ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{personInfo.getEmail(), personInfo.getOfficePhone(), personInfo.getCell(), info.getId().toString()});
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("*********\u62db\u8058\u9700\u6c42 \uff1a" + info.getId() + "\uff1a\u4e0d\u5b58\u5728\u8054\u7cfb\u4eba\u4fe1\u606f**********"));
        }
    }

    private void doUpdateCustomSalary(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        String sql = "UPDATE T_REC_RecuritmentDemand SET FUseCustomSalary = 1 WHERE FID = ? AND (FSalary = 0 or FSalary is null)";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void doUpdateJobGrade(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        JobGradeInfo jobGrade = info.getJobGrade();
        JobGradeInfo lowJobGrade = info.getLowJobGrade();
        JobGradeInfo highJobGrade = info.getHighJobGrade();
        if (lowJobGrade == null && highJobGrade == null && jobGrade != null) {
            String sql = "UPDATE T_REC_RecuritmentDemand SET FHighJobGrade = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{jobGrade.getId().toString(), info.getId().toString()});
        }
    }

    private void doUpdateFilterCriteria(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        MaleOrFemaleEnum sex;
        ExperienceEnum exp;
        FilterCriteriaInfo fc;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>>>>>>>>>>>>>>>\u5f00\u59cb\u5347\u7ea7\u667a\u80fd\u7b5b\u9009\uff1a" + info.getId().toString()));
        }
        if ((fc = info.getFilterCriteria()) == null) {
            return;
        }
        try {
            fc = FilterCriteriaFactory.getLocalInstance(ctx).getFilterCriteriaInfo((IObjectPK)new ObjectUuidPK(fc.getId().toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>>>>>>>>>>>>>>>\u5f00\u59cb\u5347\u7ea7\u667a\u80fd\u7b5b\u9009\u5de5\u4f5c\u7ecf\u9a8c\uff1a" + info.getId().toString()));
        }
        if ((exp = info.getExperience()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4f7f\u7528\u62db\u8058\u8981\u6c42\u4e2d\u7684\u5de5\u4f5c\u7ecf\u9a8c\u8fdb\u884c\u5347\u7ea7\uff1a" + exp.getValue() + ":" + exp.getAlias()));
            }
            WorkYearEnum lowWorkYear = null;
            WorkYearEnum highWorkYear = null;
            if (ExperienceEnum.LOW_1.equals((Object)exp)) {
                lowWorkYear = WorkYearEnum.ZERO;
                highWorkYear = WorkYearEnum.ONE;
            } else if (ExperienceEnum.FROM_1_TO_2.equals((Object)exp)) {
                lowWorkYear = WorkYearEnum.ONE;
                highWorkYear = WorkYearEnum.TWO;
            } else if (ExperienceEnum.FROM_3_TO_5.equals((Object)exp)) {
                lowWorkYear = WorkYearEnum.THREE;
                highWorkYear = WorkYearEnum.FIVE;
            } else if (ExperienceEnum.FROM_6_TO_10.equals((Object)exp)) {
                lowWorkYear = WorkYearEnum.SIX;
                highWorkYear = WorkYearEnum.TEN;
            } else if (ExperienceEnum.OVER_10.equals((Object)exp)) {
                lowWorkYear = WorkYearEnum.TEN;
                highWorkYear = WorkYearEnum.FIFTY;
            } else {
                lowWorkYear = WorkYearEnum.NOLIMIT;
                highWorkYear = WorkYearEnum.NOLIMIT;
            }
            fc.setLowWorkYears(lowWorkYear);
            fc.setHighWorkYears(highWorkYear);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4f7f\u7528\u667a\u80fd\u7b5b\u9009\u4e2d\u7684\u5de5\u4f5c\u7ecf\u9a8c\u8fdb\u884c\u5347\u7ea7\uff1a" + (Object)((Object)lowWorkYear) + "," + (Object)((Object)highWorkYear)));
            }
        }
        if ((sex = info.getSex()) != null) {
            fc.setSex(sex);
        }
        String sql = "SELECT FilterType,FLowAge,FHighAge,FilterCondition,FSex,FLowWorkYears,FHighWorkYears FROM T_REC_FilterCriteria WHERE FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fc.getId().toString()});
        int cDegree = 0;
        try {
            if (rs.next()) {
                int age = rs.getInt("FilterType");
                if (age > 0) {
                    if (1 == age) {
                        fc.setLowAge(WorkAgeEnum.SIXTEEN);
                        fc.setHighAge(WorkAgeEnum.TWENTYFIVE);
                    } else if (2 == age) {
                        fc.setLowAge(WorkAgeEnum.TWENTYFIVE);
                        fc.setHighAge(WorkAgeEnum.THIRTY);
                    } else if (3 == age) {
                        fc.setLowAge(WorkAgeEnum.THIRTY);
                        fc.setHighAge(WorkAgeEnum.THIRTYFIVE);
                    } else if (4 == age) {
                        fc.setLowAge(WorkAgeEnum.THIRTYFIVE);
                        fc.setHighAge(WorkAgeEnum.FORTY);
                    } else if (5 == age) {
                        fc.setLowAge(WorkAgeEnum.FORTY);
                        fc.setHighAge(WorkAgeEnum.EIGHTY);
                    } else {
                        fc.setLowAge(WorkAgeEnum.NOLIMIT);
                        fc.setHighAge(WorkAgeEnum.NOLIMIT);
                    }
                } else {
                    int lowAge = rs.getInt("FLowAge");
                    if (lowAge < 16) {
                        fc.setLowAge(WorkAgeEnum.NOLIMIT);
                    } else {
                        if (lowAge > 80) {
                            lowAge = 80;
                        }
                        fc.setLowAge(WorkAgeEnum.getEnum(lowAge));
                    }
                    int highAge = rs.getInt("FHighAge");
                    if (highAge < 16) {
                        fc.setHighAge(WorkAgeEnum.NOLIMIT);
                    } else {
                        if (highAge > 80) {
                            highAge = 80;
                        }
                        fc.setHighAge(WorkAgeEnum.getEnum(highAge));
                    }
                }
                if (exp == null) {
                    int lowWorkYears = rs.getInt("FLowWorkYears");
                    if (lowWorkYears <= 0) {
                        fc.setLowWorkYears(WorkYearEnum.NOLIMIT);
                    } else {
                        if (lowWorkYears > 50) {
                            lowWorkYears = 50;
                        }
                        fc.setLowWorkYears(WorkYearEnum.getEnum(lowWorkYears));
                    }
                    int highWorkYears = rs.getInt("FHighWorkYears");
                    if (highWorkYears <= 0) {
                        fc.setHighWorkYears(WorkYearEnum.NOLIMIT);
                    } else {
                        if (highWorkYears > 50) {
                            highWorkYears = 50;
                        }
                        fc.setHighWorkYears(WorkYearEnum.getEnum(highWorkYears));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u4f7f\u7528\u667a\u80fd\u7b5b\u9009\u4e2d\u7684\u5de5\u4f5c\u7ecf\u9a8c\u8fdb\u884c\u5347\u7ea7\uff1a" + lowWorkYears + "," + highWorkYears));
                    }
                }
                if (sex == null) {
                    int sexVal = rs.getInt("FSex");
                    fc.setSex(MaleOrFemaleEnum.getEnum(sexVal));
                }
                fc.setDegreeAbove(true);
                cDegree = rs.getInt("FilterCondition");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            FilterCriteriaFactory.getLocalInstance(ctx).save((CoreBaseInfo)fc);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        int education = 0;
        education = info.getEducation() != null ? info.getEducation().getValue() : cDegree;
        DiplomaInfo diplomaInfo = this.getDiploma(education, ctx);
        if (diplomaInfo != null) {
            sql = "UPDATE T_REC_RecuritmentDemand SET FHDegreeID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{diplomaInfo.getId().toString(), info.getId().toString()});
        } else {
            sql = "UPDATE T_REC_RecuritmentDemand SET FHDegreeID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{null, info.getId().toString()});
            sql = "UPDATE T_REC_FilterCriteria SET FDegreeNoLimit = ?,FDegreeAbove = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, 0, fc.getId().toString()});
        }
    }

    private DiplomaInfo getDiploma(int education, Context ctx) throws BOSException {
        if (education <= 0) {
            return null;
        }
        String fid = null;
        switch (education) {
            case 1: {
                fid = "5a35e819-0101-1000-e000-0366c0a83c7f9B3E5DD3";
                break;
            }
            case 2: {
                fid = "5a35e819-0101-1000-e000-0380c0a83c7f9B3E5DD3";
                break;
            }
            case 3: {
                fid = "5a35e819-0101-1000-e000-03b5c0a83c7f9B3E5DD3";
                break;
            }
            case 4: {
                fid = "5a35e819-0101-1000-e000-1a1fc0a83c7f9B3E5DD3";
                break;
            }
            case 5: {
                fid = "5a35e819-0101-1000-e000-1a44c0a83c7f9B3E5DD3";
                break;
            }
            case 6: {
                fid = "5a35e819-0101-1000-e000-1a52c0a83c7f9B3E5DD3";
                break;
            }
            case 7: {
                fid = "5a35e819-0101-1000-e000-1a7cc0a83c7f9B3E5DD3";
                break;
            }
            case 8: {
                fid = "5a35e819-0101-1000-e000-1ac1c0a83c7f9B3E5DD3";
                break;
            }
            default: {
                fid = "5a35e819-0101-1000-e000-0366c0a83c7f9B3E5DD3";
            }
        }
        IDiploma iDiploma = DiplomaFactory.getLocalInstance((Context)ctx);
        DiplomaCollection coll = iDiploma.getDiplomaCollection("where id = '" + fid + "'");
        DiplomaInfo info = null;
        if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
            info = coll.get(0);
        }
        return info;
    }

    private void doUpdateJobNature(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        int jobNature = this.getRecuritmentDemandJobNature(ctx, info.getId().toString());
        if (3 == jobNature || 4 == jobNature) {
            String sql = "UPDATE T_REC_RecuritmentDemand SET FJobNature = 1 WHERE FID = ?";
            try {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void doUpdateRecTypes(RecuritmentDemandInfo info, Context ctx) throws BOSException {
        RecuritTypeEnum recType;
        HashSet<String> recTypes = new HashSet<String>();
        if (IsOrNotEnum.YES.equals((Object)info.getIsHunting())) {
            recTypes.add("ryK5iml+QD6SuPtybIzjApQw2uw=");
        }
        if (RecuritTypeEnum.CAMPUS.equals((Object)(recType = info.getRecuritType()))) {
            recTypes.add("BYNZ4L8iTGqANod1qi4oPJQw2uw=");
        } else if (RecuritTypeEnum.SOCIETY.equals((Object)recType)) {
            recTypes.add("LWA6A2hsSNySUooCY2ZKNJQw2uw=");
        } else if (RecuritTypeEnum.INTERN.equals((Object)recType)) {
            recTypes.add("qmhQ4LcSQVmhtlKo4r7sKpQw2uw=");
        } else if (RecuritTypeEnum.ALL.equals((Object)recType)) {
            recTypes.add("BYNZ4L8iTGqANod1qi4oPJQw2uw=");
            recTypes.add("qmhQ4LcSQVmhtlKo4r7sKpQw2uw=");
            recTypes.add("LWA6A2hsSNySUooCY2ZKNJQw2uw=");
        }
        int jobNature = this.getRecuritmentDemandJobNature(ctx, info.getId().toString());
        if (3 == jobNature) {
            recTypes.add("t3hIM4NvRpCgztd2Z/+eM5Qw2uw=");
        } else if (4 == jobNature) {
            recTypes.add("qmhQ4LcSQVmhtlKo4r7sKpQw2uw=");
        }
        if (!recTypes.isEmpty()) {
            this._saveRecTypes(ctx, recTypes.toArray(new String[0]), (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    private int getRecuritmentDemandJobNature(Context ctx, String demandId) throws BOSException {
        String sql = "SELECT FJobNature FROM T_REC_RecuritmentDemand WHERE FID = ?";
        int jobNature = -1;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{demandId});
            if (rs.next()) {
                jobNature = rs.getInt("FJobNature");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return jobNature;
    }

    @Override
    protected void _abortRecuritmentDemand(Context ctx, String[] recDemandId) throws BOSException {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])recDemandId)), CompareType.INCLUDE));
            evi.setFilter(filter);
            RecuritmentDemandCollection demandCollection = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
            CoreBaseCollection colls = new CoreBaseCollection();
            int size = demandCollection.size();
            for (int i = 0; i < size; ++i) {
                RecuritmentDemandInfo demandInfo = demandCollection.get(i);
                if (demandInfo.getBillState().getValue() != 1 && demandInfo.getBillState().getValue() != 2) continue;
                this._abortBizBill(ctx, demandInfo.getId().toString());
                demandInfo.setFlowState(FlowStateEnum.UNSUBMIT);
                demandInfo.setBillState(HRBillStateEnum.SAVED);
                demandInfo.setDescription(null);
                colls.add((CoreBaseInfo)demandInfo);
            }
            if (colls.size() > 0) {
                RecuritmentDemandFactory.getLocalInstance(ctx).update(colls);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "DELETE FROM T_REC_RecDemandLinkBenefits WHERE FDemandID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "DELETE FROM T_REC_ReleaseDetail WHERE FRECURITMENTDEMANDID  = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "DELETE FROM T_REC_RecDemandLinkRecType WHERE FDemandID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "DELETE FROM T_REC_RecPlaceLinkRecDemand WHERE FRecDemandID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "DELETE FROM T_REC_DemandCompType WHERE FRecuritmentDemandID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "DELETE FROM T_REC_RecuritmentDemandStaff WHERE FRecuritmentDemandID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_WFR_ASSIGN WHERE fbizobjid= ?", (Object[])new Object[]{pk.toString()});
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        this.updateExtendBack(ctx, pk);
        this.bindBillId(ctx, pk, false, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        this.updateExtendBack(ctx, pk);
        this.bindBillId(ctx, pk, true, model);
        return pk;
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    private void updateExtendBack(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("competeExtendBack.id");
        selector.add("extendBack.id");
        RecuritmentDemandInfo info = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandInfo(pk, selector);
        if (info != null) {
            String updateSql;
            if (info.getCompeteExtendBack() != null) {
                updateSql = "update T_REC_DemandCompeteExtend set FRecuritmentDemandId = ? where FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk.toString(), info.getCompeteExtendBack().getId().toString()});
            }
            if (info.getExtendBack() != null) {
                updateSql = "update T_REC_RecuritmentDemandExtend set FRecuritmentDemandId = ? where FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk.toString(), info.getExtendBack().getId().toString()});
            }
        }
    }

    private void bindBillId(Context ctx, IObjectPK pk, Boolean isNew, IObjectValue model) throws BOSException, EASBizException {
        RecuritmentDemandInfo info = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandInfo(pk);
        if (info != null) {
            String billId = info.getId().toString();
            RecuritmentDemandStaffInfo staff = info.getStaff();
            if (null != staff) {
                String staffID = staff.getId().toString();
                RecuritmentDemandInfo recDemandInfo = (RecuritmentDemandInfo)model;
                IRecuritmentDemandStaff recuritmentDemandStaff = RecuritmentDemandStaffFactory.getLocalInstance(ctx);
                RecuritmentDemandStaffInfo newStaff = recDemandInfo.getStaff();
                if (null != newStaff && !isNew.booleanValue() && !StringUtils.equals((CharSequence)staffID, (CharSequence)recDemandInfo.getStaff().getId().toString())) {
                    recuritmentDemandStaff.delete("where recuritmentDemand= '" + billId + "'");
                }
                if (null != newStaff) {
                    String updateSql = "update T_REC_RecuritmentDemandStaff set FRecuritmentDemandID = ? where FID = ?";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk.toString(), newStaff.getId().toString()});
                } else {
                    String updateSql = "update T_REC_RecuritmentDemand set FDemandStaffID = ?,FControlWay = ? where FID = ?";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{null, null, pk.toString()});
                }
            }
        }
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        RecuritmentBillBaseInfo info = (RecuritmentBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(state);
        info.put("approveDate", new Timestamp(System.currentTimeMillis()));
        info.put("autoFilter", true);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("approveDate"));
        selectors.add(new SelectorItemInfo("autoFilter"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected TargetPosition _getPositionDetail(Context ctx, String resumeId) throws BOSException {
        TargetPosition position = new TargetPosition();
        ResumeBaseRecCollection resumeBaseRecCollection = null;
        try {
            resumeBaseRecCollection = ResumeBaseRecFactory.getLocalInstance(ctx).getResumeBaseRecCollection("select age,gender,hDegree.LevelCode,workSeniority,recuritmentDemand.*,recuritmentDemand.recuritPosition.name,recuritmentDemand.filterCriteria.* where id = '" + resumeId + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (RecDBUtils.isEmpty((IObjectCollection)resumeBaseRecCollection)) {
            throw new BOSException("\u83b7\u53d6\u5019\u9009\u4eba\u6240\u5c5e\u62db\u8058\u9700\u6c42\u4fe1\u606f\u5931\u8d25!");
        }
        RecuritmentDemandInfo demandInfo = resumeBaseRecCollection.get(0).getRecuritmentDemand();
        position.setId(demandInfo.getId().toString());
        PositionInfo positionInfo = demandInfo.getRecuritPosition();
        HRJobInfo hrJob = demandInfo.getHrJob();
        if (positionInfo != null && positionInfo.getId() != null) {
            position.setName(positionInfo.getName());
            position.setPositionId(positionInfo.getId().toString());
            position.setPositionName(positionInfo.getName());
        } else if (hrJob != null && hrJob.getId() != null) {
            position.setName(hrJob.getName());
            position.setPositionId(hrJob.toString());
            position.setPositionName(hrJob.getName());
        }
        AdminOrgUnitCollection departmentColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id = '" + demandInfo.getDepartment().getId() + "'");
        if (RecDBUtils.isEmpty((IObjectCollection)departmentColl)) {
            throw new BOSException("\u83b7\u53d6\u5019\u9009\u4eba\u6240\u5c5e\u62db\u8058\u9700\u6c42\u4fe1\u606f\u5bf9\u5e94\u90e8\u95e8\u5931\u8d25!");
        }
        AdminOrgUnitInfo departmentInfo = departmentColl.get(0);
        OrgUnitLayerTypeInfo layerInfo = departmentInfo.getUnitLayerType();
        if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000162824988".equals(layerInfo.getId().toString())) {
            position.setGroup(departmentInfo.getDisplayName());
            position.setDepartment(departmentInfo.getName());
        } else if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000262824988".equals(layerInfo.getId().toString())) {
            String displayName = departmentInfo.getDisplayName();
            position.setGroup(displayName.substring(0, displayName.indexOf("_")));
            position.setCompany(displayName.substring(displayName.indexOf("_") + 1));
            position.setDepartment(departmentInfo.getName());
        } else if (layerInfo != null && layerInfo.getId() != null && "00000000-0000-0000-0000-00000000000362824988".equals(layerInfo.getId().toString())) {
            String displayName = departmentInfo.getDisplayName();
            position.setGroup(displayName.substring(0, displayName.indexOf("_")));
            if (displayName.indexOf("_") < displayName.lastIndexOf("_")) {
                position.setCompany(displayName.substring(displayName.indexOf("_") + 1, displayName.lastIndexOf("_")));
            }
            position.setDepartment(departmentInfo.getName());
        }
        position.setAddress(demandInfo.getAddress());
        position.setReleaseOrgName(demandInfo.getReleaseOrgName());
        position.setQualification(demandInfo.getQualification());
        position.setResponsibilities(demandInfo.getResponsibilities());
        this.setPositionFilterCriteria(ctx, position, demandInfo, resumeBaseRecCollection.get(0));
        return position;
    }

    private void setPositionFilterCriteria(Context ctx, TargetPosition position, RecuritmentDemandInfo demandInfo, ResumeBaseRecInfo resume) throws BOSException {
        WorkAgeEnum highAge;
        WorkYearEnum highWorkYear;
        FilterCriteriaInfo fcInfo = demandInfo.getFilterCriteria();
        DiplomaInfo resumeDipInfo = resume.getHDegree();
        if (fcInfo != null && fcInfo.isDegreeNoLimit()) {
            position.setDegree("\u5b66\u5386\u4e0d\u9650");
            position.setDegreeOk("true");
        } else {
            DiplomaInfo dipInfo = demandInfo.getHDegree();
            if (dipInfo == null) {
                position.setDegree("\u5b66\u5386\u4e0d\u9650");
                position.setDegreeOk("true");
            } else {
                try {
                    dipInfo = DiplomaFactory.getLocalInstance((Context)ctx).getDiplomaInfo((IObjectPK)new ObjectUuidPK(dipInfo.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                position.setDegree(dipInfo.getName());
                if (resumeDipInfo != null) {
                    if (resumeDipInfo.getLevelCode() >= dipInfo.getLevelCode()) {
                        position.setDegreeOk("true");
                    } else {
                        position.setDegreeOk("false");
                    }
                } else {
                    position.setDegreeOk("");
                }
            }
        }
        Genders gender = resume.getGender();
        if (fcInfo != null && fcInfo.getSex() != null) {
            position.setSex("\u6027\u522b" + fcInfo.getSex().getAlias());
            if (fcInfo.getSex().getValue() == 0) {
                position.setSexOk("true");
            } else if (gender != null && gender.getValue() == fcInfo.getSex().getValue()) {
                position.setSexOk("true");
            } else {
                position.setSexOk("false");
            }
        } else {
            position.setSex("\u6027\u522b\u4e0d\u9650");
            position.setSexOk("true");
        }
        if (gender == null) {
            position.setSexOk("");
        }
        String workSeniority = resume.getWorkSeniority();
        double workExp = -2.0;
        if (!StringUtils.isEmpty((CharSequence)workSeniority)) {
            workExp = Double.parseDouble(workSeniority);
        }
        WorkYearEnum lowWorkYear = fcInfo != null ? fcInfo.getLowWorkYears() : null;
        WorkYearEnum workYearEnum = highWorkYear = fcInfo != null ? fcInfo.getHighWorkYears() : null;
        if (lowWorkYear == null || highWorkYear == null || WorkYearEnum.NOLIMIT.equals((Object)lowWorkYear) && WorkYearEnum.NOLIMIT.equals((Object)highWorkYear)) {
            position.setWorkExp("\u7ecf\u9a8c\u4e0d\u9650");
            position.setWorkExpOk("true");
        } else if (WorkYearEnum.NOLIMIT.equals((Object)lowWorkYear)) {
            position.setWorkExp(highWorkYear.getAlias() + "\u5e74\u4ee5\u4e0b");
            if (workExp > (double)highWorkYear.getValue()) {
                position.setWorkExpOk("false");
            } else {
                position.setWorkExpOk("true");
            }
        } else if (WorkYearEnum.NOLIMIT.equals((Object)highWorkYear)) {
            position.setWorkExp(lowWorkYear.getAlias() + "\u5e74\u4ee5\u4e0a");
            if (workExp < (double)lowWorkYear.getValue()) {
                position.setWorkExpOk("false");
            } else {
                position.setWorkExpOk("true");
            }
        } else {
            position.setWorkExp(lowWorkYear.getAlias() + "-" + highWorkYear.getAlias() + "\u5e74");
            if (workExp >= (double)lowWorkYear.getValue() && workExp <= (double)highWorkYear.getValue()) {
                position.setWorkExpOk("true");
            } else {
                position.setWorkExpOk("false");
            }
        }
        if (StringUtils.isEmpty((CharSequence)workSeniority)) {
            position.setWorkExpOk("");
        }
        int age = resume.getAge();
        WorkAgeEnum lowAge = fcInfo != null ? fcInfo.getLowAge() : null;
        WorkAgeEnum workAgeEnum = highAge = fcInfo != null ? fcInfo.getHighAge() : null;
        if (lowAge == null || highAge == null || WorkAgeEnum.NOLIMIT.equals((Object)highAge) && WorkAgeEnum.NOLIMIT.equals((Object)lowAge)) {
            position.setAge("\u5e74\u9f84\u4e0d\u9650");
            position.setAgeOk("true");
        } else if (WorkAgeEnum.NOLIMIT.equals((Object)lowAge)) {
            position.setAge(highAge.getAlias() + "\u5c81\u4ee5\u4e0b");
            if (age > highAge.getValue()) {
                position.setAgeOk("false");
            } else {
                position.setAgeOk("true");
            }
        } else if (WorkAgeEnum.NOLIMIT.equals((Object)highAge)) {
            position.setAge(lowAge.getAlias() + "\u5c81\u4ee5\u4e0a");
            if (age < lowAge.getValue()) {
                position.setAgeOk("false");
            } else {
                position.setAgeOk("true");
            }
        } else {
            position.setAge(lowAge.getAlias() + "-" + highAge.getAlias() + "\u5c81");
            if (age >= lowAge.getValue() && age <= highAge.getValue()) {
                position.setAgeOk("true");
            } else {
                position.setAgeOk("false");
            }
        }
        if (age == 0) {
            position.setAgeOk("");
        }
    }
}

