/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.shr.recuritment.EnterpriseArchivesCollection;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.RecPersonBlackListFacadeFactory;
import com.kingdee.shr.recuritment.RemoveBlackListBillCollection;
import com.kingdee.shr.recuritment.RemoveBlackListBillFactory;
import com.kingdee.shr.recuritment.RemoveBlackListBillInfo;
import com.kingdee.shr.recuritment.app.AbstractRemoveBlackListBillControllerBean;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RemoveBlackListBillControllerBean
extends AbstractRemoveBlackListBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.RemoveBlackListBillControllerBean");

    @Override
    protected void _withdrawDemand(Context ctx, String[] billIds) throws BOSException {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])billIds)), CompareType.INCLUDE));
            evi.setFilter(filter);
            RemoveBlackListBillCollection removeBlackListBillCollection = RemoveBlackListBillFactory.getLocalInstance(ctx).getRemoveBlackListBillCollection(evi);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.length);
            int size = removeBlackListBillCollection.size();
            for (int i = 0; i < size; ++i) {
                RemoveBlackListBillInfo billInfo = removeBlackListBillCollection.get(i);
                if (billInfo.getBillState().getValue() != 1 && billInfo.getBillState().getValue() != 2) continue;
                this._abortBizBill(ctx, billInfo.getId().toString());
                paramsList.add(new Object[]{billInfo.getId().toString()});
            }
            if (!paramsList.isEmpty()) {
                String sql = "UPDATE T_REC_RemoveBalckListBill SET FBillState = 0,FDescription = null WHERE FBillId = ?";
                RecDBUtils.executeBatch(ctx, sql, paramsList);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super._submitEffect(ctx, model);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        HashMap<String, String> param = new HashMap<String, String>();
        RemoveBlackListBillCollection billCollection = RemoveBlackListBillFactory.getLocalInstance(ctx).getRemoveBlackListBillCollection("where id ='" + billId + "'");
        if (!RecDBUtils.isEmpty((IObjectCollection)billCollection)) {
            RemoveBlackListBillInfo billInfo = billCollection.get(0);
            String uniqueId = billInfo.getUniqueId();
            param.put("removeReason", billInfo.getRemoveReason());
            param.put("personId", billInfo.getProposer().getId().toString());
            param.put("personName", billInfo.getProposer().getName());
            param.put("uniqId", uniqueId);
            EnterpriseArchivesCollection enterpriseArchivesCollection = EnterpriseArchivesFactory.getLocalInstance(ctx).getEnterpriseArchivesCollection("where isBlackList=1 and uniqId='" + uniqueId + "'");
            if (RecDBUtils.isEmpty((IObjectCollection)enterpriseArchivesCollection)) {
                logger.error((Object)("\u79fb\u9664\u9ed1\u540d\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9ed1\u540d\u5355\u7b80\u5386\uff0c\u5355\u636ebillId" + billId + "uniqId\uff1a" + uniqueId));
            } else {
                RecPersonBlackListFacadeFactory.getLocalInstance(ctx).removeResumeBlackList(param);
                ResumeOperRecordService.getInstance().addBlackOperRecord(ctx, "\u79fb\u9664\u9ed1\u540d\u5355", "\u8be5\u5019\u9009\u4eba\u6240\u6709\u7b80\u5386\u5747\u79fb\u9664", uniqueId);
            }
        }
        super._setPassState(ctx, billId);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setNoPassState(ctx, billId);
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        String opinion = ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        RemoveBlackListBillCollection coll = RemoveBlackListBillFactory.getLocalInstance(ctx).getRemoveBlackListBillCollection("where id ='" + billID + "'");
        if (RecDBUtils.isEmpty((IObjectCollection)coll) && StringUtils.isNotEmpty((CharSequence)opinion)) {
            RemoveBlackListBillInfo info = coll.get(0);
            info.setApprovalComment(opinion);
            RemoveBlackListBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        super._setAudited(ctx, billID);
    }
}

