/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.ResumeClipBaseInfo;
import com.kingdee.shr.recuritment.ResumeClipRelationCollection;
import com.kingdee.shr.recuritment.ResumeClipRelationFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationInfo;
import com.kingdee.shr.recuritment.app.AbstractResumeClipRelationControllerBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResumeClipRelationControllerBean
extends AbstractResumeClipRelationControllerBean {
    private static final long serialVersionUID = 8388385013171929886L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.ResumeClipRelationControllerBean");

    private boolean checkResumeClipRelationExists(Context ctx, String resumeClipId, String enterpriseArchivesId) throws BOSException {
        boolean isExists = false;
        try {
            isExists = ResumeClipRelationFactory.getLocalInstance(ctx).exists("where resumeClip = '" + resumeClipId + "' and enterpriseArchives='" + enterpriseArchivesId + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isExists;
    }

    private IObjectPK getResumeClipRelationID(Context ctx, String resumeClipId, String enterpriseArchivesId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("resumeClip", (Object)resumeClipId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enterpriseArchives", (Object)enterpriseArchivesId, CompareType.EQUALS));
        view.setFilter(filter);
        String resumeClipRelationId = null;
        ResumeClipRelationCollection coll = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationCollection(view);
        if (coll != null && !coll.isEmpty() && coll.get(0) != null && coll.get(0).getId() != null) {
            resumeClipRelationId = coll.get(0).getId().toString();
        }
        if (resumeClipRelationId != null) {
            return new ObjectUuidPK(resumeClipRelationId);
        }
        return null;
    }

    @Override
    protected IObjectPK _addNewRelation(Context ctx, String resumeClipID, String enterpriseArchivesID) throws BOSException {
        ResumeClipRelationInfo relationInfo = new ResumeClipRelationInfo();
        ResumeClipBaseInfo clipInfo = new ResumeClipBaseInfo();
        clipInfo.setId(new ObjectUuidPK(resumeClipID).getKeyValue());
        relationInfo.setResumeClip(clipInfo);
        EnterpriseArchivesInfo eaInfo = new EnterpriseArchivesInfo();
        eaInfo.setId(new ObjectUuidPK(enterpriseArchivesID).getKeyValue());
        relationInfo.setEnterpriseArchives(eaInfo);
        IObjectPK pk = null;
        try {
            if (StringUtils.isNotEmpty((String)resumeClipID) && StringUtils.isNotEmpty((String)enterpriseArchivesID)) {
                boolean isExists = this.checkResumeClipRelationExists(ctx, resumeClipID, enterpriseArchivesID);
                if (!isExists) {
                    pk = super._addnew(ctx, (IObjectValue)relationInfo);
                    this.updateRepeated(ctx, enterpriseArchivesID);
                } else {
                    pk = this.getResumeClipRelationID(ctx, resumeClipID, enterpriseArchivesID);
                }
            } else {
                pk = super._addnew(ctx, (IObjectValue)relationInfo);
                this.updateRepeated(ctx, enterpriseArchivesID);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return pk;
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String archivesId = null;
        ResumeClipRelationInfo relationInfo = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationInfo(pk);
        if (relationInfo != null && relationInfo.getEnterpriseArchives() != null && relationInfo.getEnterpriseArchives().getId() != null) {
            archivesId = relationInfo.getEnterpriseArchives().getId().toString();
        }
        String sql = "DELETE FROM T_REC_ResumeClipRelation WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
        this.updateRepeated(ctx, archivesId);
    }

    private void updateRepeated(Context ctx, String archivesId) throws BOSException, EASBizException {
        boolean isRepeated = this.isRepeated(ctx, archivesId);
        String sql = "update T_REC_EnterpriseArchives set FRepeated = ? where FID = ?";
        Object[] params = new Object[]{isRepeated ? 1 : 0, archivesId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private boolean isRepeated(Context ctx, String archivesId) throws BOSException, EASBizException {
        IObjectPK[] pkList = ResumeClipRelationFactory.getLocalInstance(ctx).getPKList("where enterpriseArchives = '" + archivesId + "'");
        return pkList != null && pkList.length > 1;
    }
}

