/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.recuritment.ISmartImportTaskDetail;
import com.kingdee.shr.recuritment.SmartImportTaskCollection;
import com.kingdee.shr.recuritment.SmartImportTaskDetailCollection;
import com.kingdee.shr.recuritment.SmartImportTaskDetailFactory;
import com.kingdee.shr.recuritment.SmartImportTaskDetailInfo;
import com.kingdee.shr.recuritment.SmartImportTaskInfo;
import com.kingdee.shr.recuritment.TaskStateEnum;
import com.kingdee.shr.recuritment.TaskTypeEnum;
import com.kingdee.shr.recuritment.app.AbstractSmartImportTaskControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SmartImportTaskControllerBean
extends AbstractSmartImportTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.SmartImportTaskControllerBean");
    private static final long serialVersionUID = 1L;

    @Override
    protected IObjectValue _getUserProgressTask(Context ctx, IObjectPK userId, TaskTypeEnum taskType) throws BOSException {
        SmartImportTaskInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator", (Object)userId.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taskType", (Object)taskType.getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taskState", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSorter(sorter);
        SmartImportTaskCollection coll = this.getSmartImportTaskCollection(ctx, view);
        if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
            info = coll.get(0);
        }
        return info;
    }

    @Override
    protected IObjectValue _addUserProgressTask(Context ctx, IObjectValue userInfo, TaskTypeEnum taskType) throws BOSException {
        SmartImportTaskInfo taskInfo = new SmartImportTaskInfo();
        taskInfo.setTaskState(TaskStateEnum.SAVED);
        taskInfo.setTaskStartDate(new Timestamp(System.currentTimeMillis()));
        taskInfo.setTaskType(taskType);
        taskInfo.setAffirm(false);
        taskInfo.setLock(0);
        taskInfo.setCreator((UserInfo)userInfo);
        try {
            IObjectPK pk = this.addnew(ctx, taskInfo);
            taskInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return taskInfo;
    }

    @Override
    protected void _taskTimeout(Context ctx, IObjectValue smartImportTaskInfo) throws BOSException {
        this.setTaskErrorState(ctx, smartImportTaskInfo, TaskStateEnum.TIMEOUT, "\u5bfc\u5165\u4efb\u52a1\u5df2\u8d85\u65f6", "\u5bfc\u5165\u4efb\u52a1\u5df2\u8d85\u65f6");
    }

    @Override
    protected void _taskError(Context ctx, IObjectValue smartImportTaskInfo, String info, String errorDetail) throws BOSException {
        this.setTaskErrorState(ctx, smartImportTaskInfo, TaskStateEnum.ERROR, info, errorDetail);
    }

    private void setTaskErrorState(Context ctx, IObjectValue smartImportTaskInfo, TaskStateEnum errorState, String errorInfo, String errorDetail) throws BOSException {
        SmartImportTaskInfo taskInfo = (SmartImportTaskInfo)smartImportTaskInfo;
        ISmartImportTaskDetail iDetail = SmartImportTaskDetailFactory.getLocalInstance(ctx);
        SmartImportTaskDetailCollection detailColl = iDetail.getSmartImportTaskDetailCollection("where task = '" + taskInfo.getId() + "' and taskState NOT IN (" + 7 + "," + 6 + ")  order by createTime desc");
        if (!RecDBUtils.isEmpty((IObjectCollection)detailColl)) {
            Iterator iter = detailColl.iterator();
            SmartImportTaskDetailInfo detailInfo = null;
            while (iter.hasNext()) {
                detailInfo = (SmartImportTaskDetailInfo)iter.next();
                detailInfo.setTaskState(errorState);
                detailInfo.setInfo(errorInfo);
                detailInfo.setErrorDetail(errorDetail);
            }
            try {
                iDetail.saveBatchData(RecDBUtils.entityCollectionToCoreBaseCollection((IObjectCollection)detailColl));
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            this.setTaskState(ctx, (IObjectValue)taskInfo, errorState, errorInfo, errorDetail);
        } else {
            this._taskFinish(ctx, (IObjectValue)taskInfo);
        }
    }

    @Override
    protected void _taskFinish(Context ctx, IObjectValue smartImportTaskInfo) throws BOSException {
        this.setTaskState(ctx, smartImportTaskInfo, TaskStateEnum.FINISHED, "\u667a\u80fd\u5bfc\u5165\u5df2\u5b8c\u6210", "");
    }

    @Override
    protected void _taskSubmit(Context ctx, IObjectValue smartImportTaskInfo) throws BOSException {
        this.setTaskState(ctx, smartImportTaskInfo, TaskStateEnum.SUBMITED, "\u5bfc\u5165\u4efb\u52a1\u5df2\u63d0\u4ea4", "");
    }

    @Override
    protected boolean _taskRunning(Context ctx, IObjectValue smartImportTaskInfo) throws BOSException {
        SmartImportTaskInfo taskInfo = (SmartImportTaskInfo)smartImportTaskInfo;
        String sql = "UPDATE T_REC_SmartImportTask SET FLock = FLock + 1 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{taskInfo.getId().toString()});
        TaskStateEnum state = this._getTaskState(ctx, (IObjectPK)new ObjectUuidPK(taskInfo.getId()));
        if (TaskStateEnum.SUBMITED.equals((Object)state)) {
            this.setTaskState(ctx, smartImportTaskInfo, TaskStateEnum.RUNNING, "\u5bfc\u5165\u4efb\u52a1\u8fdb\u884c\u4e2d", "");
            return true;
        }
        return false;
    }

    private void setTaskState(Context ctx, IObjectValue smartImportTaskInfo, TaskStateEnum taskState, String info, String errorDetail) throws BOSException {
        SmartImportTaskInfo taskInfo = (SmartImportTaskInfo)smartImportTaskInfo;
        taskInfo.setTaskState(taskState);
        taskInfo.setTaskStartDate(new Timestamp(System.currentTimeMillis()));
        taskInfo.setInfo(info);
        taskInfo.setErrorDetail(errorDetail);
        if (TaskStateEnum.SUBMITED == taskState) {
            taskInfo.setTaskStartDate(new Timestamp(System.currentTimeMillis()));
        }
        try {
            this.save(ctx, (CoreBaseInfo)taskInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getTaskWatingDetails(Context ctx, IObjectValue smartImportTaskInfo) throws BOSException {
        SmartImportTaskInfo taskInfo = (SmartImportTaskInfo)smartImportTaskInfo;
        return SmartImportTaskDetailFactory.getLocalInstance(ctx).getSmartImportTaskDetailCollection("where task = '" + taskInfo.getId() + "' and taskState = " + 1 + " order by createTime desc");
    }

    @Override
    protected IObjectValue _getSmartImportTaskSchedule(Context ctx, IObjectPK userId, TaskTypeEnum taskType, String taskId) throws BOSException {
        FilterInfo filter;
        SmartImportTaskInfo taskInfo = null;
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("recDemand.*");
                selector.add("resumeClip.id");
                selector.add("resumeClip.name");
                selector.add("resumeSource.id");
                selector.add("resumeSource.name");
                selector.add("interRecommendation.*");
                taskInfo = this.getSmartImportTaskInfo(ctx, (IObjectPK)new ObjectUuidPK(taskId), selector);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("creator", (Object)userId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("taskType", (Object)taskType.getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            SorterItemCollection sorterColl = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorterColl.add(sorterItemInfo);
            view.setSorter(sorterColl);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("recDemand.*");
            selector.add("resumeClip.id");
            selector.add("resumeClip.name");
            selector.add("resumeSource.id");
            selector.add("resumeSource.name");
            selector.add("interRecommendation.*");
            view.setSelector(selector);
            SmartImportTaskCollection taskColl = this.getSmartImportTaskCollection(ctx, view);
            if (!RecDBUtils.isEmpty((IObjectCollection)taskColl)) {
                taskInfo = taskColl.get(0);
            }
        }
        if (taskInfo != null) {
            EntityViewInfo evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("task", (Object)taskInfo.getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
            SelectorItemCollection selectorColl = evi.getSelector();
            selectorColl.add(new SelectorItemInfo("id"));
            selectorColl.add(new SelectorItemInfo("resumeFileName"));
            selectorColl.add(new SelectorItemInfo("resumeFileType"));
            selectorColl.add(new SelectorItemInfo("resumeFileData"));
            selectorColl.add(new SelectorItemInfo("taskState"));
            selectorColl.add(new SelectorItemInfo("info"));
            selectorColl.add(new SelectorItemInfo("task"));
            selectorColl.add(new SelectorItemInfo("isDelete"));
            SmartImportTaskDetailCollection detailColl = SmartImportTaskDetailFactory.getLocalInstance(ctx).getSmartImportTaskDetailCollection(evi);
            taskInfo.put("detailColl", (Object)detailColl);
        }
        return taskInfo;
    }

    @Override
    protected TaskStateEnum _getTaskState(Context ctx, IObjectPK smartImportTaskId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)smartImportTaskId.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection selectorColl = evi.getSelector();
        selectorColl.add(new SelectorItemInfo("taskState"));
        SmartImportTaskCollection taskColl = this.getSmartImportTaskCollection(ctx, evi);
        SmartImportTaskInfo taskInfo = null;
        if (RecDBUtils.isEmpty((IObjectCollection)taskColl)) {
            throw new BOSException("\u901a\u8fc7id\uff1a" + smartImportTaskId + "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        taskInfo = taskColl.get(0);
        return taskInfo.getTaskState();
    }

    @Override
    protected void _affirmTask(Context ctx, IObjectPK smartImportTaskId) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FAffirm = 1 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{smartImportTaskId.toString()});
    }

    @Override
    protected void _setSmartImportChooseDemand(Context ctx, IObjectPK taskId, IObjectPK recDemandId) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FRecDemandID = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recDemandId == null ? null : recDemandId.toString(), taskId.toString()});
    }

    @Override
    protected void _setSmartImportChooseResumeClip(Context ctx, IObjectPK taskId, IObjectPK resumeClipId) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FResumeClipID = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{resumeClipId == null ? null : resumeClipId.toString(), taskId.toString()});
    }

    @Override
    protected void _setSmartImportChooseRecommendation(Context ctx, IObjectPK taskId, IObjectPK interRecommendationId) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FInterRecommendationID = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interRecommendationId == null ? null : interRecommendationId.toString(), taskId.toString()});
    }

    @Override
    protected void _setSmartImportChooseResumeSource(Context ctx, IObjectPK taskId, IObjectPK resumeSourceId) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FResumeSourceID = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{resumeSourceId == null ? null : resumeSourceId.toString(), taskId.toString()});
    }

    @Override
    protected void _setSmartImportChooseSourceType(Context ctx, IObjectPK taskId, String sourceType) throws BOSException {
        String sql = "UPDATE T_REC_SmartImportTask SET FSourceType = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{StringUtils.isEmpty((CharSequence)sourceType) ? Integer.valueOf(0) : sourceType, taskId.toString()});
    }

    @Override
    protected void _deleteTask(Context ctx, String taskId) throws BOSException {
        String deleteTaskDetails = "delete from T_REC_SmartImportTaskDetail where FTaskID = ? ";
        String deleteTasks = "delete from T_REC_SmartImportTask where FID = ? ";
        DbUtil.execute((Context)ctx, (String)deleteTaskDetails, (Object[])new Object[]{taskId});
        DbUtil.execute((Context)ctx, (String)deleteTasks, (Object[])new Object[]{taskId});
    }
}

