/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.SmartImportTaskDetailInfo;
import com.kingdee.shr.recuritment.SmartImportTaskInfo;
import com.kingdee.shr.recuritment.TaskStateEnum;
import com.kingdee.shr.recuritment.app.AbstractSmartImportTaskDetailControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SmartImportTaskDetailControllerBean
extends AbstractSmartImportTaskDetailControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.SmartImportTaskDetailControllerBean");

    @Override
    protected IObjectValue _addUploadResumeFile(Context ctx, String resumeFileName, byte[] resumeFileData, IObjectValue smartImportTaskInfo) throws BOSException {
        String fileName = resumeFileName.substring(0, resumeFileName.lastIndexOf("."));
        String fileType = resumeFileName.substring(resumeFileName.lastIndexOf("."), resumeFileName.length());
        SmartImportTaskDetailInfo detailInfo = new SmartImportTaskDetailInfo();
        detailInfo.setResumeFileName(fileName);
        detailInfo.setResumeFileType(fileType);
        detailInfo.setResumeFileData(resumeFileData);
        detailInfo.setTaskState(TaskStateEnum.SAVED);
        detailInfo.setInfo("\u5f85\u89e3\u6790");
        detailInfo.setTask((SmartImportTaskInfo)smartImportTaskInfo);
        try {
            IObjectPK pk = this.addnew(ctx, detailInfo);
            detailInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return detailInfo;
    }

    @Override
    protected void _deleteResumes(Context ctx, String[] detailIds) throws BOSException {
        String querySql;
        IRowSet rs;
        String detailId0 = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(detailIds.length);
        for (String detailId : detailIds) {
            if (detailId0 == null) {
                detailId0 = detailId;
            }
            paramsList.add(new Object[]{detailId});
        }
        boolean isFlagDelete = false;
        if (detailId0 != null && (rs = DbUtil.executeQuery((Context)ctx, (String)(querySql = "select T.FTaskState from T_REC_SmartImportTask as T inner join T_REC_SmartImportTaskDetail as T0 on T0.FTaskId = T.FID where T0.FID = ?"), (Object[])new Object[]{detailId0})) != null) {
            try {
                while (rs.next()) {
                    int taskState = rs.getInt(1);
                    if (taskState != 7 && taskState != 8) continue;
                    isFlagDelete = true;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (isFlagDelete) {
            RecDBUtils.executeBatch(ctx, "update T_REC_SmartImportTaskDetail set FIsDelete = 1 WHERE FID = ?", paramsList);
        } else {
            RecDBUtils.executeBatch(ctx, "DELETE FROM T_REC_SmartImportTaskDetail WHERE FID = ?", paramsList);
        }
    }

    @Override
    protected void _taskFinish(Context ctx, IObjectValue smartImportTaskDetailInfo) throws BOSException {
        SmartImportTaskDetailInfo detailInfo = (SmartImportTaskDetailInfo)smartImportTaskDetailInfo;
        detailInfo.setTaskState(TaskStateEnum.FINISHED);
        detailInfo.setInfo("\u89e3\u6790\u6210\u529f");
        detailInfo.setErrorDetail("");
        try {
            this.save(ctx, (CoreBaseInfo)detailInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _taskError(Context ctx, IObjectValue smartImportTaskDetailInfo, String errorInfo, String errorDetail) throws BOSException {
        SmartImportTaskDetailInfo detailInfo = (SmartImportTaskDetailInfo)smartImportTaskDetailInfo;
        detailInfo.setTaskState(TaskStateEnum.ERROR);
        detailInfo.setInfo(errorInfo);
        detailInfo.setErrorDetail(errorDetail);
        try {
            this.save(ctx, (CoreBaseInfo)detailInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _clearImportFinishedFile(Context ctx) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"****************\u6267\u884c\u6e05\u9664\u5df2\u5b8c\u6210\u667a\u80fd\u5bfc\u5165\u7b80\u5386\u9644\u4ef6\u5f00\u59cb****************");
        }
        String sql = "UPDATE T_REC_SmartImportTaskDetail SET FResumeFileData = NULL WHERE FTaskState = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{7});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"****************\u6267\u884c\u6e05\u9664\u5df2\u5b8c\u6210\u667a\u80fd\u5bfc\u5165\u7b80\u5386\u9644\u4ef6\u5b8c\u6210****************");
        }
    }
}

