/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.shr.recuritment.IUserRecPermUpdate;
import com.kingdee.shr.recuritment.UserRecPermUpdateFactory;
import com.kingdee.shr.recuritment.app.AbstractUserRecPermUpdateControllerBean;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UserRecPermUpdateControllerBean
extends AbstractUserRecPermUpdateControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.recuritment.app.UserRecPermUpdateControllerBean");
    private static BlockingQueue<String> permQueue = new LinkedBlockingQueue<String>();

    private void initPermQueue() {
        if (permQueue.isEmpty()) {
            String[] perms;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u521d\u59cb\u5316\u5f85\u5347\u7ea7\u6743\u9650\u961f\u5217\uff01");
            }
            for (String perm : perms = new String[]{"1348c619-7d5b-4d71-932a-3857b1ef39c6PERMITEM", "1a88632d-38aa-4c95-8b8e-5231e523c7a9PERMITEM", "3f3b6cdf-decd-43a5-9452-0bf31565ebcfPERMITEM", "47045a2c-7f62-4d5b-93c8-bcebdf913292PERMITEM", "82ff0e83-b311-4fe8-9d02-d7787aa6ae59PERMITEM", "acef6e62-4732-447b-8301-b302b25e826ePERMITEM", "b15ca607-37f5-424e-b7a2-7bfb431c57e5PERMITEM", "c211b5f0-137e-430c-92e7-9006d6214bddPERMITEM", "cf780d27-455f-4d35-83c7-6a7ac3e00011PERMITEM", "e723f5d3-2a8f-45e1-911d-6456e7cc03f3PERMITEM", "e82300eb-29f1-470c-a396-d849fc06e25fPERMITEM"}) {
                permQueue.offer(perm);
            }
        }
    }

    @Override
    protected void _updateUserRecPerm(Context ctx) throws BOSException {
        this.initPermQueue();
        int threadCount = 4;
        CountDownLatch cdl = new CountDownLatch(threadCount);
        UpdateUserPermTask task = new UpdateUserPermTask(ctx, permQueue, cdl);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(task).start();
        }
        try {
            cdl.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.error((Object)"-----------------\u6743\u9650\u5347\u7ea7\u4e2d\u65ad\uff01------------------");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _doPermUpdate(Context ctx, String perm) throws BOSException {
        List<String> subItems;
        IUserOrgPerm iUserPerm;
        UserOrgPermCollection userPermColl;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u5347\u7ea7\u6743\u9650\u9879:" + perm));
        }
        if (RecDBUtils.isEmpty((IObjectCollection)(userPermColl = (iUserPerm = UserOrgPermFactory.getLocalInstance((Context)ctx)).getUserOrgPermCollection(" where permItem = '" + perm + "'")))) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u9700\u8981\u5347\u7ea7 " + perm + " \u6743\u9650\u7684\u7528\u6237\u6709 " + userPermColl.size() + "\u4eba\uff01"));
        }
        if (RecDBUtils.isEmpty(subItems = this.getPermSubItem(ctx, perm))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6743\u9650 " + perm + " \u4e0d\u5b58\u5728\u5b50\u6743\u9650"));
            }
            return;
        }
        Iterator userPermIter = userPermColl.iterator();
        UserOrgPermInfo info = null;
        while (userPermIter.hasNext()) {
            info = (UserOrgPermInfo)userPermIter.next();
            if (!this.checkUserIsNeedToUpdatePerms(ctx, info, subItems)) continue;
            this.addMissingSubItems(ctx, info, subItems);
        }
    }

    private List<String> getPermSubItem(Context ctx, String perm) throws BOSException {
        if (RecDBUtils.isEmpty(perm)) {
            return null;
        }
        String sql = "SELECT FID FROM T_PM_PermItem WHERE FParentID = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{perm});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> subItems = null;
        if (!RecDBUtils.isEmpty(datas)) {
            subItems = new ArrayList<String>();
            for (Object[] data : datas) {
                subItems.add((String)data[0]);
            }
        }
        return subItems;
    }

    private boolean checkUserIsNeedToUpdatePerms(Context ctx, UserOrgPermInfo userPermInfo, List<String> subItems) throws BOSException {
        if (RecDBUtils.isEmpty(subItems)) {
            return false;
        }
        IUserOrgPerm iUserPerm = UserOrgPermFactory.getLocalInstance((Context)ctx);
        UserOrgPermCollection userPermColl = iUserPerm.getUserOrgPermCollection(" where owner = '" + userPermInfo.getOwner().getId().toString() + "'");
        HashSet<String> allPerms = new HashSet<String>((int)Math.ceil((double)userPermColl.size() / 0.75));
        Iterator userPermIter = userPermColl.iterator();
        UserOrgPermInfo info = null;
        while (userPermIter.hasNext()) {
            info = (UserOrgPermInfo)userPermIter.next();
            allPerms.add(info.getPermItem().getId().toString());
        }
        for (String item : subItems) {
            if (!allPerms.contains(item)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"**************\u5b58\u5728\u53f6\u5b50\u8282\u70b9\u6743\u9650\uff0c\u4e0d\u9700\u8981\u5347\u7ea7\uff01**************");
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"**************\u4e0d\u5b58\u5728\u53f6\u5b50\u8282\u70b9\u6743\u9650\uff0c\u9700\u8981\u5347\u7ea7\uff01**************");
        }
        return true;
    }

    private void addMissingSubItems(Context ctx, UserOrgPermInfo info, List<String> subItems) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"++++++++++++++++++++++++++++++++\u5f00\u59cb\u6dfb\u52a0\u4e22\u5931\u6743\u9650++++++++++++++++++++++++++++++++");
        }
        String fields = "FID,FOwner,FOrgID,FPermItemID,FPermType,FRuleStructure,FRuleExpr,FCtrlUnitID";
        String sql = "INSERT INTO T_PM_UserOrgPerm (" + fields + ") VALUES (" + RecDBUtils.getParamPlaceholder(fields) + ")";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(subItems.size());
        for (String item : subItems) {
            paramsList.add(new Object[]{BOSUuid.create((BOSObjectType)new UserOrgPermInfo().getBOSType()).toString(), info.getOwner().getId().toString(), info.getOrg().getId().toString(), item, info.getPermType().getValue(), info.getRuleStructure(), info.getRuleExpr(), info.getCtrlUnit().getId().toString()});
        }
        RecDBUtils.executeBatch(ctx, sql, paramsList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"++++++++++++++++++++++++++++++++\u6dfb\u52a0\u4e22\u5931\u6743\u9650\u5b8c\u6210++++++++++++++++++++++++++++++++");
        }
    }

    private class UpdateUserPermTask
    implements Runnable {
        private BlockingQueue<String> permQueue = null;
        private CountDownLatch cdl = null;
        private IUserRecPermUpdate iUpdate = null;

        public UpdateUserPermTask(Context ctx, BlockingQueue<String> permQueue, CountDownLatch cdl) throws BOSException {
            this.permQueue = permQueue;
            this.cdl = cdl;
            try {
                this.iUpdate = UserRecPermUpdateFactory.getLocalInstance(ctx);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6UserRecPermUpdate \u5931\u8d25\uff01");
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u542f\u52a8\u4e00\u4e2a\u5347\u7ea7\u7ebf\u7a0b,ThreadName:" + Thread.currentThread().getName() + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>"));
            }
            String perm = (String)this.permQueue.poll();
            while (this.iUpdate != null && !RecDBUtils.isEmptyWithTrim(perm)) {
                try {
                    this.iUpdate.doPermUpdate(perm);
                }
                catch (Exception e) {
                    logger.error((Object)("*******************\u5347\u7ea7\u5931\u8d25\uff1a" + perm + " ********************"));
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                perm = (String)this.permQueue.poll();
            }
            this.cdl.countDown();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\u4e00\u4e2a\u5347\u7ea7\u7ebf\u7a0b\u7ed3\u675f,ThreadName:" + Thread.currentThread().getName() + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"));
            }
        }
    }
}

