/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.integraterec.IntegrateAccountFactory;
import com.kingdee.shr.recuritment.DemandCompTypeCollection;
import com.kingdee.shr.recuritment.DemandCompTypeFactory;
import com.kingdee.shr.recuritment.DemandTpRelatedFactory;
import com.kingdee.shr.recuritment.DemandTpRelatedInfo;
import com.kingdee.shr.recuritment.DemandWorkAreaCollection;
import com.kingdee.shr.recuritment.DemandWorkAreaFactory;
import com.kingdee.shr.recuritment.DemandWorkAreaInfo;
import com.kingdee.shr.recuritment.FilterCriteriaInfo;
import com.kingdee.shr.recuritment.FlowStateEnum;
import com.kingdee.shr.recuritment.RecDemandTypeIntegrateCollection;
import com.kingdee.shr.recuritment.RecDemandTypeIntegrateFactory;
import com.kingdee.shr.recuritment.RecIntegrateThirdPartyManagementCollection;
import com.kingdee.shr.recuritment.RecIntegrateThirdPartyManagementFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.RecuritmentHeadInfo;
import com.kingdee.shr.recuritment.TupuReleaseDetailCollection;
import com.kingdee.shr.recuritment.TupuReleaseDetailFactory;
import com.kingdee.shr.recuritment.TupuReleaseDetailInfo;
import com.kingdee.shr.recuritment.TupuReleaseStatusEnum;
import com.kingdee.shr.recuritment.app.TpPushStateEnum;
import com.kingdee.shr.recuritment.app.util.DateUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecBaseUtils;
import com.kingdee.util.DateTimeUtils;
import dm.jdbc.util.StringUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuritmentDemandTuPuService {
    private static Logger logger = LoggerFactory.getLogger(RecuritmentDemandTuPuService.class);
    private static RecuritmentDemandTuPuService recuritmentDemandTuPuService;

    public static synchronized RecuritmentDemandTuPuService getInstance() {
        if (recuritmentDemandTuPuService == null) {
            recuritmentDemandTuPuService = new RecuritmentDemandTuPuService();
        }
        return recuritmentDemandTuPuService;
    }

    public String batchAddTuPuJob(Context ctx, RecuritmentDemandCollection demandCol, String pushType) throws BOSException {
        if (demandCol != null && demandCol.size() > 0) {
            for (int i = 0; i < demandCol.size(); ++i) {
                String tupuRecTypeValue;
                DemandTpRelatedInfo demandTpRelated;
                StringBuffer errorStr = new StringBuffer("");
                RecuritmentDemandInfo recuritmentDemandInfo = demandCol.get(i);
                String demandId = recuritmentDemandInfo.getId().toString();
                logger.info("\u540c\u6b65\u9700\u6c42\u5230\u56fe\u8c31\u7684\u9700\u6c42id=" + demandId);
                String recuritmentType = recuritmentDemandInfo.getRecuritmentType();
                if (!HRBillStateEnum.AUDITED.equals((Object)recuritmentDemandInfo.getBillState())) {
                    errorStr.append("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u9700\u6c42\u624d\u5141\u8bb8\u63a8\u9001\uff01");
                    this.saveTupuFailResult(ctx, recuritmentDemandInfo, errorStr.toString());
                    if ("manualPush".equals(pushType)) {
                        return errorStr.toString();
                    }
                }
                if ((demandTpRelated = recuritmentDemandInfo.getDemandTpRelated()) != null && demandTpRelated.getTupuPushState().getValue() == 1) {
                    errorStr.append("\u201c\u5df2\u63a8\u9001\u201d\u8fc7\u7684\u9700\u6c42\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
                    if ("manualPush".equals(pushType)) {
                        return errorStr.toString();
                    }
                }
                if ("moka".equals(recuritmentDemandInfo.getDemandSource())) {
                    errorStr.append("\u9700\u6c42\u6765\u6e90\u662fmoka\u7684\u9700\u6c42\u4e0d\u80fd\u63a8\u9001!");
                    this.saveTupuFailResult(ctx, recuritmentDemandInfo, errorStr.toString());
                    if ("manualPush".equals(pushType)) {
                        return errorStr.toString();
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(tupuRecTypeValue = this.mateTpRecuritmentType(ctx, recuritmentType)))) {
                    logger.info("\u67e5\u8be2\u9700\u6c42\u5230\u56fe\u8c31\u7684\u62db\u8058\u7c7b\u578b\u503ctpRecType=" + tupuRecTypeValue);
                    try {
                        String resultStr = this.executeAddTuPuJobOsf(ctx, recuritmentDemandInfo);
                        errorStr.append(resultStr);
                        if (StringUtils.isNotEmpty((CharSequence)errorStr.toString())) {
                            this.saveTupuFailResult(ctx, recuritmentDemandInfo, errorStr.toString());
                        }
                        if (!"manualPush".equals(pushType)) continue;
                        return errorStr.toString();
                    }
                    catch (EASBizException e) {
                        logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage());
                        errorStr.append("\u65b0\u589e\u56fe\u8c31\u804c\u4f4d\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
                        this.saveTupuFailResult(ctx, recuritmentDemandInfo, errorStr.toString());
                        if (!"manualPush".equals(pushType)) continue;
                        return errorStr.toString();
                    }
                }
                errorStr.append("\u672a\u5728\u96c6\u6210\u4e1a\u52a1\u914d\u7f6e\u4e2d\u5339\u914d\u5230shr\u4e0e\u56fe\u8c31\u62db\u8058\u7c7b\u578b\u7684\u89c4\u5219\u8bbe\u7f6e!");
                this.saveTupuFailResult(ctx, recuritmentDemandInfo, errorStr.toString());
                if (!"manualPush".equals(pushType)) continue;
                return errorStr.toString();
            }
        }
        return "";
    }

    public String executeAddTuPuJobOsf(Context ctx, RecuritmentDemandInfo recuritmentDemandInfo) throws EASBizException, BOSException {
        String demandId = recuritmentDemandInfo.getId().toString();
        String[] billId = new String[]{demandId};
        DemandTpRelatedInfo demandTpRelatedInfo = recuritmentDemandInfo.getDemandTpRelated();
        if (demandTpRelatedInfo != null && StringUtil.isNotEmpty((String)demandTpRelatedInfo.getTupuJobId())) {
            demandTpRelatedInfo.setTupuPushState(TpPushStateEnum.PUSH_SUCCESS);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("tupuPushState"));
            DemandTpRelatedFactory.getLocalInstance(ctx).updatePartial(demandTpRelatedInfo, sic);
            String result = this.updateTuPuJob(ctx, demandId);
            if (StringUtil.isEmpty((String)result)) {
                this.updateStatusTuPuJob(ctx, billId, "");
            }
            return result;
        }
        String errorStr = "";
        HashMap<String, String> osfparam = new HashMap<String, String>();
        osfparam.put("billIds", demandId);
        osfparam.put("from", "rec");
        osfparam.put("triggerKey", "addTuPuJobIntegrate");
        osfparam.put("integrateType", "2");
        Object recPushService = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", osfparam);
        logger.error("AddTuPuJobService\u63a5\u53e3\u7684\u8fd4\u56de\u503c=" + recPushService);
        String str = JSONObject.toJSONString((Object)recPushService);
        JSONObject pushIntegrateRecJson = JSONObject.parseObject((String)str);
        int success = (Integer)pushIntegrateRecJson.get((Object)"state");
        if (success == 1) {
            String integrateRes = pushIntegrateRecJson.get((Object)"integrateRes").toString();
            JSONObject dataObj = (JSONObject)JSON.parseObject((String)integrateRes, JSONObject.class);
            Set fieldItems = dataObj.entrySet();
            for (Map.Entry entry : fieldItems) {
                List tupuInterfaceDataList = (List)entry.getValue();
                JSONObject dataObject = tupuInterfaceDataList.size() > 0 ? (JSONObject)tupuInterfaceDataList.get(0) : null;
                if (dataObject == null) continue;
                if ((Integer)dataObject.get((Object)"state") == 1) {
                    String data = dataObject.get((Object)"data").toString();
                    logger.error("\u65b0\u589e\u56fe\u8c31\u804c\u4f4d\u63a5\u53e3\u8fd4\u56de\u503c\u6570\u636e\u6253\u5370" + data);
                    if (StringUtils.isNotEmpty((CharSequence)data)) {
                        String message;
                        JSONObject tupuDataObject = JSONObject.parseObject((String)(data = JSONObject.parse((String)data).toString()));
                        if ("100".equals(tupuDataObject.get((Object)"code").toString())) {
                            String tpPositionId = tupuDataObject.get((Object)"positionId").toString();
                            boolean demandTpRelatedIsnull = false;
                            if (demandTpRelatedInfo == null) {
                                demandTpRelatedIsnull = true;
                                demandTpRelatedInfo = new DemandTpRelatedInfo();
                                demandTpRelatedInfo.setId(BOSUuid.create((BOSObjectType)demandTpRelatedInfo.getBOSType()));
                            }
                            demandTpRelatedInfo.put("recuritmentDemand", demandId);
                            demandTpRelatedInfo.setTupuJobId(tpPositionId);
                            demandTpRelatedInfo.setTupuPushState(TpPushStateEnum.PUSH_SUCCESS);
                            demandTpRelatedInfo.setTupuPushMsg(null);
                            DemandTpRelatedFactory.getLocalInstance(ctx).save((CoreBaseInfo)demandTpRelatedInfo);
                            if (demandTpRelatedIsnull) {
                                SelectorItemCollection selector = new SelectorItemCollection();
                                selector.add("id");
                                selector.add("demandTpRelated");
                                recuritmentDemandInfo.setDemandTpRelated(demandTpRelatedInfo);
                                RecuritmentDemandFactory.getLocalInstance(ctx).updatePartial(recuritmentDemandInfo, selector);
                            }
                            if (!FlowStateEnum.COMPLETE.equals((Object)recuritmentDemandInfo.getFlowState()) && !FlowStateEnum.STOP.equals((Object)recuritmentDemandInfo.getFlowState())) continue;
                            this.updateStatusTuPuJob(ctx, billId, "");
                            continue;
                        }
                        errorStr = message = tupuDataObject.get((Object)"message") != null ? tupuDataObject.get((Object)"message").toString() : "";
                        return errorStr;
                    }
                    errorStr = "\u8c03\u7528\u56fe\u8c31\u804c\u4f4d\u65b0\u589e\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a!";
                    logger.error(errorStr);
                    return errorStr;
                }
                errorStr = "\u8c03\u7528\u56fe\u8c31\u804c\u4f4d\u65b0\u589e\u5931\u8d25!";
                logger.error(errorStr);
                return errorStr;
            }
        } else {
            errorStr = "\u8fd8\u6ca1\u8c03\u7528\u56fe\u8c31\u63a5\u53e3\uff0c\u9700\u6c42\u5ba1\u6279\u901a\u8fc7\u65b0\u589e\u56fe\u8c31\u804c\u4f4d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + pushIntegrateRecJson.get((Object)"message").toString();
            logger.error(errorStr);
        }
        return errorStr;
    }

    public void saveTupuFailResult(Context ctx, RecuritmentDemandInfo recuritmentDemandInfo, String errorMsg) {
        try {
            DemandTpRelatedInfo demandTpRelatedInfo = recuritmentDemandInfo.getDemandTpRelated();
            String demandId = recuritmentDemandInfo.getId().toString();
            boolean demandTpRelatedIsnull = false;
            if (demandTpRelatedInfo == null) {
                demandTpRelatedIsnull = true;
                demandTpRelatedInfo = new DemandTpRelatedInfo();
                demandTpRelatedInfo.setId(BOSUuid.create((BOSObjectType)demandTpRelatedInfo.getBOSType()));
            }
            demandTpRelatedInfo.put("recuritmentDemand", demandId);
            demandTpRelatedInfo.setTupuPushState(TpPushStateEnum.PUSH_FAILED);
            demandTpRelatedInfo.setTupuPushMsg(errorMsg);
            DemandTpRelatedFactory.getLocalInstance(ctx).save((CoreBaseInfo)demandTpRelatedInfo);
            if (demandTpRelatedIsnull) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("demandTpRelated");
                recuritmentDemandInfo.setDemandTpRelated(demandTpRelatedInfo);
                RecuritmentDemandFactory.getLocalInstance(ctx).updatePartial(recuritmentDemandInfo, selector);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    public String executeUpdateTuPuJobOsf(Context ctx, RecuritmentDemandCollection recuritmentDemandCol, String triggerKey, String type) {
        StringBuffer errorStr = new StringBuffer("");
        if (recuritmentDemandCol.size() > 0) {
            for (int i = 0; i < recuritmentDemandCol.size(); ++i) {
                RecuritmentDemandInfo recuritmentDemandInfo = recuritmentDemandCol.get(i);
                DemandTpRelatedInfo demandTpRelated = recuritmentDemandInfo.getDemandTpRelated();
                if (demandTpRelated == null || demandTpRelated.getTupuPushState().getValue() != 1) continue;
                try {
                    HashMap<String, String> osfparam = new HashMap<String, String>();
                    osfparam.put("billIds", recuritmentDemandInfo.getId().toString());
                    osfparam.put("from", "rec");
                    osfparam.put("triggerKey", triggerKey);
                    osfparam.put("integrateType", "2");
                    Object recPushService = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", osfparam);
                    logger.error(triggerKey + "\u63a5\u53e3\u7684\u8fd4\u56de\u503c=" + recPushService);
                    String str = JSONObject.toJSONString((Object)recPushService);
                    JSONObject pushIntegrateRecJson = JSONObject.parseObject((String)str);
                    int success = (Integer)pushIntegrateRecJson.get((Object)"state");
                    if (success == 1) {
                        String integrateRes = pushIntegrateRecJson.get((Object)"integrateRes").toString();
                        JSONObject dataObj = (JSONObject)JSON.parseObject((String)integrateRes, JSONObject.class);
                        Set fieldItems = dataObj.entrySet();
                        for (Map.Entry entry : fieldItems) {
                            List tupuInterfaceDataList = (List)entry.getValue();
                            JSONObject dataObject = tupuInterfaceDataList.size() > 0 ? (JSONObject)tupuInterfaceDataList.get(0) : null;
                            if (dataObject == null || (Integer)dataObject.get((Object)"state") != 1) continue;
                            String data = dataObject.get((Object)"data").toString();
                            logger.error("\u66f4\u65b0\u56fe\u8c31\u804c\u4f4d\u63a5\u53e3\u8fd4\u56de\u503c\u6570\u636e\u6253\u5370" + data);
                            if (StringUtils.isNotEmpty((CharSequence)data)) {
                                JSONObject tupuDataObject = JSONObject.parseObject((String)(data = JSONObject.parse((String)data).toString()));
                                if ("100".equals(tupuDataObject.get((Object)"code").toString()) && "againstApprove".equals(type)) {
                                    demandTpRelated.setTupuPushState(TpPushStateEnum.ISNULL);
                                    demandTpRelated.setTupuPushMsg(null);
                                    SelectorItemCollection sic = new SelectorItemCollection();
                                    sic.add(new SelectorItemInfo("tupuPushState"));
                                    sic.add(new SelectorItemInfo("tupuPushMsg"));
                                    DemandTpRelatedFactory.getLocalInstance(ctx).updatePartial(demandTpRelated, sic);
                                    continue;
                                }
                                if ("100".equals(tupuDataObject.get((Object)"code").toString())) continue;
                                errorStr.append(tupuDataObject.get((Object)"message").toString());
                                continue;
                            }
                            errorStr.append("\u8c03\u7528\u56fe\u8c31\u804c\u4f4d\u66f4\u65b0\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a!");
                        }
                        continue;
                    }
                    errorStr.append("\u8fd8\u6ca1\u8c03\u7528\u56fe\u8c31\u63a5\u53e3\uff0c\u66f4\u65b0\u56fe\u8c31\u804c\u4f4d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + pushIntegrateRecJson.get((Object)"message").toString());
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    errorStr.append("\u66f4\u65b0\u56fe\u8c31\u804c\u4f4d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38!");
                }
            }
        }
        return errorStr.toString();
    }

    public String executeUpdateTuPuJobReleasedOsf(Context ctx, RecuritmentDemandInfo recuritmentDemandInfo) throws EASBizException, BOSException {
        String errorStr = "";
        JSONObject pathParam = new JSONObject();
        pathParam.put("positionId", (Object)recuritmentDemandInfo.getDemandTpRelated().getTupuJobId());
        HashMap<String, String> osfparam = new HashMap<String, String>();
        osfparam.put("billIds", recuritmentDemandInfo.getId().toString());
        osfparam.put("from", "rec");
        osfparam.put("triggerKey", "getTuPuJobReleasedIntegrate");
        osfparam.put("integrateType", "2");
        osfparam.put("pathParam", pathParam.toString());
        Object recPushService = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", osfparam);
        logger.error("GetTuPuJobReleasedService\u63a5\u53e3\u7684\u8fd4\u56de\u503c=" + recPushService);
        String str = JSONObject.toJSONString((Object)recPushService);
        JSONObject pushIntegrateRecJson = JSONObject.parseObject((String)str);
        int success = (Integer)pushIntegrateRecJson.get((Object)"state");
        if (success == 1) {
            String integrateRes = pushIntegrateRecJson.get((Object)"integrateRes").toString();
            JSONObject dataObj = (JSONObject)JSON.parseObject((String)integrateRes, JSONObject.class);
            Set fieldItems = dataObj.entrySet();
            for (Map.Entry entry : fieldItems) {
                List tupuInterfaceDataList = (List)entry.getValue();
                JSONObject dataObject = tupuInterfaceDataList.size() > 0 ? (JSONObject)tupuInterfaceDataList.get(0) : null;
                if (dataObject == null || (Integer)dataObject.get((Object)"state") != 1) continue;
                String data = dataObject.get((Object)"data").toString();
                logger.error("\u56fe\u8c31\u53d1\u5e03\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c\u6570\u636e\u6253\u5370" + data);
                if (StringUtils.isNotEmpty((CharSequence)data)) {
                    JSONObject tupuDataObject = JSONObject.parseObject((String)(data = JSONObject.parse((String)data).toString()));
                    if (!"100".equals(tupuDataObject.get((Object)"code").toString())) continue;
                    Object resultData = tupuDataObject.get((Object)"data");
                    if (resultData == null) {
                        logger.error("===\u6ca1\u6709\u56fe\u8c31\u804c\u4f4d\u53d1\u5e03\u4fe1\u606f\u6570\u636e\u8fd4\u56de===");
                        continue;
                    }
                    String releasedStr = resultData.toString();
                    logger.error("\u56fe\u8c31\u804c\u4f4d\u53d1\u5e03\u4fe1\u606f\u67e5\u8be2\u6570\u636e\u6253\u5370" + releasedStr);
                    releasedStr = JSONObject.parse((String)releasedStr).toString();
                    JSONArray releasedArr = JSONArray.parseArray((String)releasedStr);
                    if (releasedArr.size() == 0) {
                        logger.error("===\u6ca1\u6709\u56fe\u8c31\u804c\u4f4d\u53d1\u5e03\u4fe1\u606f\u6570\u636e\u8fd4\u56de===");
                        continue;
                    }
                    TupuReleaseDetailCollection tupuReleaseDetailList = recuritmentDemandInfo.getDemandTpRelated().getTupuReleaseDetailList();
                    if (tupuReleaseDetailList.size() > 0) {
                        for (int j = 0; j < tupuReleaseDetailList.size(); ++j) {
                            TupuReleaseDetailFactory.getLocalInstance(ctx).delete("where id='" + tupuReleaseDetailList.get(j).getId().toString() + "'");
                        }
                    }
                    TupuReleaseDetailCollection col = new TupuReleaseDetailCollection();
                    boolean isPublished = false;
                    boolean isTobeReleased = false;
                    int tobeReleasedCount = 0;
                    boolean isPublishEnded = false;
                    int publishEndedCount = 0;
                    boolean isPublishFailed = false;
                    int publishFailedCount = 0;
                    int tupuPublishSize = releasedArr.size();
                    StringBuffer tupuReleaseDetailStr = new StringBuffer();
                    for (int i = 0; i < tupuPublishSize; ++i) {
                        JSONObject jobData = (JSONObject)releasedArr.get(i);
                        TupuReleaseDetailInfo tupuReleaseDetailInfo = new TupuReleaseDetailInfo();
                        tupuReleaseDetailInfo.setDemandTpRelatedId(recuritmentDemandInfo.getDemandTpRelated());
                        String hrSiteType = jobData.get((Object)"hrSiteType").toString();
                        tupuReleaseDetailInfo.setTpHrSiteType(hrSiteType);
                        String status = jobData.get((Object)"status").toString();
                        if (!isPublished && ("\u5df2\u53d1\u5e03".equals(status) || "\u5df2\u6682\u505c".equals(status) || "\u672a\u901a\u8fc7".equals(status) || "\u5ba1\u6838\u4e2d".equals(status))) {
                            isPublished = true;
                        }
                        if ("\u5f85\u53d1\u5e03".equals(status)) {
                            isTobeReleased = true;
                            ++tobeReleasedCount;
                        } else if ("\u5df2\u7ed3\u675f".equals(status)) {
                            isPublishEnded = true;
                            ++publishEndedCount;
                            isPublished = true;
                        } else if ("\u53d1\u5e03\u5931\u8d25".equals(status)) {
                            isPublishFailed = true;
                            ++publishFailedCount;
                            isPublished = true;
                        }
                        tupuReleaseDetailStr.append(hrSiteType + "(" + status + ") ");
                        tupuReleaseDetailInfo.setTpReleaseStatus(status);
                        Timestamp dateRefresh = DateUtil.strToTimeStamp(jobData.get((Object)"dateRefresh").toString());
                        Timestamp dateStart = DateUtil.strToTimeStamp(jobData.get((Object)"dateStart").toString());
                        Timestamp lastUpdated = DateUtil.strToTimeStamp(jobData.get((Object)"lastUpdated").toString());
                        tupuReleaseDetailInfo.setTpDateRefresh(dateRefresh);
                        tupuReleaseDetailInfo.setTpDateStart(dateStart);
                        tupuReleaseDetailInfo.setTpLastUpdated(lastUpdated);
                        tupuReleaseDetailInfo.setTpPositionId(jobData.get((Object)"positionId").toString());
                        col.add(tupuReleaseDetailInfo);
                    }
                    if (col.size() <= 0) continue;
                    TupuReleaseDetailFactory.getLocalInstance(ctx).addnewBatchData(RecDBUtils.entityCollectionToCoreBaseCollection((IObjectCollection)col));
                    DemandTpRelatedInfo demandTpRelated = recuritmentDemandInfo.getDemandTpRelated();
                    if (tupuPublishSize == tobeReleasedCount && isTobeReleased) {
                        demandTpRelated.setTupuReleaseStatus(TupuReleaseStatusEnum.TO_BE_RELEASED);
                    } else if (tupuPublishSize == publishEndedCount && isPublishEnded) {
                        demandTpRelated.setTupuReleaseStatus(TupuReleaseStatusEnum.PUBLISH_ENDED);
                    } else if (tupuPublishSize == publishFailedCount && isPublishFailed) {
                        demandTpRelated.setTupuReleaseStatus(TupuReleaseStatusEnum.PUBLISHING_FAILED);
                    } else if (isPublished) {
                        demandTpRelated.setTupuReleaseStatus(TupuReleaseStatusEnum.PUBLISHED);
                    }
                    demandTpRelated.setTupuReleaseDetail(tupuReleaseDetailStr.toString());
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("tupuReleaseStatus"));
                    sic.add(new SelectorItemInfo("tupuReleaseDetail"));
                    DemandTpRelatedFactory.getLocalInstance(ctx).updatePartial(demandTpRelated, sic);
                    continue;
                }
                errorStr = "\u8c03\u7528\u56fe\u8c31\u804c\u4f4d\u53d1\u5e03\u8be6\u60c5\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a!";
                logger.error(errorStr);
                return errorStr;
            }
        } else {
            errorStr = "\u8fd8\u6ca1\u8c03\u7528\u56fe\u8c31\u63a5\u53e3\uff0c\u56fe\u8c31\u804c\u4f4d\u53d1\u5e03\u8be6\u60c5\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + pushIntegrateRecJson.get((Object)"message").toString();
            logger.error(errorStr);
        }
        return errorStr;
    }

    public String mateTpRecuritmentType(Context ctx, String recuritmentType) throws BOSException {
        String tupuRecTypeValue = "";
        RecIntegrateThirdPartyManagementCollection recIntegrateTPManagementColl = RecIntegrateThirdPartyManagementFactory.getLocalInstance(ctx).getRecIntegrateThirdPartyManagementCollection("where id='lRwl1BJP0EuWgnCNDRm+mQB0juc=' and state = '1' ");
        if (recIntegrateTPManagementColl.size() > 0) {
            String recIntegrateTPId = recIntegrateTPManagementColl.get(0).getId().toString();
            RecDemandTypeIntegrateCollection recDemandTypeIntegrateColl = RecDemandTypeIntegrateFactory.getLocalInstance(ctx).getRecDemandTypeIntegrateCollection("select id,tpRecType where recDemandIntegrate = '" + recIntegrateTPId + "' order by typeSort ");
            boolean matchRecTypeExist = false;
            block0: for (int j = 0; j < recDemandTypeIntegrateColl.size() && !matchRecTypeExist; ++j) {
                String recDemandTypeIntegrateId = recDemandTypeIntegrateColl.get(j).getId().toString();
                String tpRecType = recDemandTypeIntegrateColl.get(j).getTpRecType().getValue();
                DemandCompTypeCollection demandCompTypeColl = DemandCompTypeFactory.getLocalInstance(ctx).getDemandCompTypeCollection("select recTypeName where shrRecuritmentType ='" + recDemandTypeIntegrateId + "'");
                for (int k = 0; k < demandCompTypeColl.size(); ++k) {
                    String recTypeName = demandCompTypeColl.get(k).getRecTypeName();
                    if (!recuritmentType.contains(recTypeName)) continue;
                    matchRecTypeExist = true;
                    if (tpRecType.equals("SOCIALRECRUITMENT")) {
                        tupuRecTypeValue = tpRecType;
                    }
                    if (!tpRecType.equals("CAMPUSRECRUITMENT")) continue block0;
                    tupuRecTypeValue = tpRecType;
                    continue block0;
                }
            }
        }
        return tupuRecTypeValue;
    }

    public String updateTuPuJob(Context ctx, String recuritmentDemandId) {
        String errorStr = "";
        try {
            this.checkIntergrateRecuritmentSet(ctx);
            RecuritmentDemandCollection recuritmentDemandCol = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select *,demandTpRelated.* where id='" + recuritmentDemandId + "'");
            if (recuritmentDemandCol.size() > 0) {
                RecuritmentDemandInfo recuritmentDemandInfo = recuritmentDemandCol.get(0);
                String demandId = recuritmentDemandInfo.getId().toString();
                logger.info("\u540c\u6b65\u9700\u6c42\u5230\u56fe\u8c31\u7684\u9700\u6c42id=" + demandId);
                String recuritmentType = recuritmentDemandInfo.getRecuritmentType();
                DemandTpRelatedInfo demandTpRelated = recuritmentDemandInfo.getDemandTpRelated();
                if (!HRBillStateEnum.AUDITED.equals((Object)recuritmentDemandInfo.getBillState()) || demandTpRelated == null || demandTpRelated.getTupuPushState().getValue() != 1) {
                    return "\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u4e14\u63a8\u9001\u6210\u529f\u7684\u6570\u636e\u624d\u80fd\u66f4\u65b0\u5230\u56fe\u8c31\u7cfb\u7edf\uff01";
                }
                if ("moka".equals(recuritmentDemandInfo.getDemandSource())) {
                    return "\u9700\u6c42\u6765\u6e90\u662fmoka\u7684\u9700\u6c42\u4e0d\u80fd\u66f4\u65b0\u5230\u56fe\u8c31!";
                }
                String tupuRecTypeValue = this.mateTpRecuritmentType(ctx, recuritmentType);
                if (StringUtils.isNotEmpty((CharSequence)tupuRecTypeValue)) {
                    logger.info("\u67e5\u8be2\u9700\u6c42\u5230\u56fe\u8c31\u7684\u62db\u8058\u7c7b\u578b\u503ctpRecType=" + tupuRecTypeValue);
                    errorStr = this.executeUpdateTuPuJobOsf(ctx, recuritmentDemandCol, "updateTuPuJobIntegrate", "");
                } else {
                    errorStr = "\u672a\u5728\u96c6\u6210\u4e1a\u52a1\u914d\u7f6e\u4e2d\u5339\u914d\u5230shr\u4e0e\u56fe\u8c31\u62db\u8058\u7c7b\u578b\u7684\u89c4\u5219\u8bbe\u7f6e!";
                }
            }
        }
        catch (BOSException e) {
            logger.error("\u66f4\u65b0\u56fe\u8c31\u804c\u4f4d\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            errorStr = "\u66f4\u65b0\u56fe\u8c31\u804c\u4f4d\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
        }
        return errorStr;
    }

    public void checkIntergrateRecuritmentSet(Context ctx) throws BOSException {
        RecIntegrateThirdPartyManagementCollection coll = RecIntegrateThirdPartyManagementFactory.getLocalInstance(ctx).getRecIntegrateThirdPartyManagementCollection("select  demandIntegrateWay where id='VsNeCWlDh0aplkUqw0hHogB0juc=' and  state = '1'");
        if (coll.size() == 0) {
            throw new BOSException("\u8bf7\u5230\u3010\u7b2c\u4e09\u65b9\u62db\u8058\u7cfb\u7edf\u96c6\u6210\u914d\u7f6e-\u96c6\u6210\u4e1a\u52a1\u914d\u7f6e\u3011\u542f\u7528\u56fe\u8c31\u96c6\u6210\u4e1a\u52a1\u89c4\u5219\u8bbe\u7f6e");
        }
        boolean exists = false;
        try {
            exists = IntegrateAccountFactory.getLocalInstance((Context)ctx).exists("where integrateType = 2 and  integrateStatus = 1 ");
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
            throw new BOSException("\u624b\u52a8\u63a8\u9001\u9700\u6c42\u5230\u56fe\u8c31\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (!exists) {
            throw new BOSException("\u5c1a\u672a\u5b8c\u6210\u56fe\u8c31\u96c6\u6210\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0-\u96c6\u6210\u914d\u7f6e-\u7b2c\u4e09\u65b9\u62db\u8058\u7cfb\u7edf\u96c6\u6210\u914d\u7f6e\u201d\u4e2d\u914d\u7f6e\uff01");
        }
        RecIntegrateThirdPartyManagementCollection recIntegrateTPManagementColl = RecIntegrateThirdPartyManagementFactory.getLocalInstance(ctx).getRecIntegrateThirdPartyManagementCollection("where id='lRwl1BJP0EuWgnCNDRm+mQB0juc=' and state = '1' ");
        if (recIntegrateTPManagementColl.size() == 0) {
            throw new BOSException("\u8bf7\u5230\u3010\u7b2c\u4e09\u65b9\u62db\u8058\u7cfb\u7edf\u96c6\u6210\u914d\u7f6e-\u96c6\u6210\u4e1a\u52a1\u914d\u7f6e\u3011\u542f\u7528\u9009\u62e9\u4e0d\u540c\u62db\u8058\u7c7b\u578b\u7684\u9700\u6c42\u8fdb\u5165\u56fe\u8c31");
        }
    }

    public String autoPullTuPuReleased(Context ctx) throws BOSException {
        try {
            boolean exists = IntegrateAccountFactory.getLocalInstance((Context)ctx).exists("where integrateType = 2 and  integrateStatus = 1 ");
            if (!exists) {
                return "\u5c1a\u672a\u5b8c\u6210\u56fe\u8c31\u96c6\u6210\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0-\u96c6\u6210\u914d\u7f6e-\u7b2c\u4e09\u65b9\u62db\u8058\u7cfb\u7edf\u96c6\u6210\u914d\u7f6e\u201d\u4e2d\u914d\u7f6e\uff01";
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
            return "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flowState", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("demandTpRelated.tupuPushState", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("demandTpRelated.*"));
        evi.getSelector().add(new SelectorItemInfo("demandTpRelated.tupuReleaseDetailList.*"));
        RecuritmentDemandCollection recuritmentDemandCol = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
        FilterInfo endfilter = new FilterInfo();
        HashSet<Integer> flowState = new HashSet<Integer>();
        flowState.add(1);
        flowState.add(2);
        endfilter.getFilterItems().add(new FilterItemInfo("flowState", flowState, CompareType.INCLUDE));
        endfilter.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
        endfilter.getFilterItems().add(new FilterItemInfo("demandTpRelated.tupuPushState", (Object)1, CompareType.EQUALS));
        String nowDate = DateTimeUtils.format((Date)new Date());
        endfilter.getFilterItems().add(new FilterItemInfo("recuritEndTime", (Object)DateUtil.getSqlDate(nowDate, "yyyy-MM-dd"), CompareType.GREATER_EQUALS));
        endfilter.getFilterItems().add(new FilterItemInfo("recuritEndTime", (Object)DateUtil.getEndDate("Date", nowDate), CompareType.LESS_EQUALS));
        evi.setFilter(endfilter);
        RecuritmentDemandCollection competeDemandCol = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
        if (recuritmentDemandCol.size() > 0 && competeDemandCol.size() > 0) {
            recuritmentDemandCol.addCollection(competeDemandCol);
        } else if (recuritmentDemandCol.size() < 0) {
            recuritmentDemandCol = competeDemandCol;
        }
        if (recuritmentDemandCol.size() > 0) {
            for (int i = 0; i < recuritmentDemandCol.size(); ++i) {
                RecuritmentDemandInfo recuritmentDemandInfo = recuritmentDemandCol.get(i);
                DemandTpRelatedInfo demandTpRelated = recuritmentDemandInfo.getDemandTpRelated();
                if (demandTpRelated == null) continue;
                try {
                    this.executeUpdateTuPuJobReleasedOsf(ctx, recuritmentDemandInfo);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage());
                }
            }
        } else {
            return "\u6682\u672a\u53d1\u73b0\u6709\u540c\u6b65\u56fe\u8c31\u804c\u4f4d\u6210\u529f\u7684\u62db\u8058\u9700\u6c42\uff01";
        }
        return "";
    }

    public void submitEffectAddTuPuJob(Context ctx, String billIds, String pushType) {
        try {
            RecIntegrateThirdPartyManagementCollection tpRuleSetCol = RecIntegrateThirdPartyManagementFactory.getLocalInstance(ctx).getRecIntegrateThirdPartyManagementCollection("select  demandIntegrateWay where id='VsNeCWlDh0aplkUqw0hHogB0juc=' and  state = '1'");
            if (tpRuleSetCol.size() > 0) {
                this.checkIntergrateRecuritmentSet(ctx);
                EntityViewInfo evi = new EntityViewInfo();
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("demandTpRelated.*"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", RecuritmentDemandTuPuService.getStringSet(billIds.split(",")), CompareType.INCLUDE));
                evi.setFilter(filter);
                RecuritmentDemandCollection demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
                String demandIntegrateWay = tpRuleSetCol.get(0).getDemandIntegrateWay();
                if ("1".equals(demandIntegrateWay)) {
                    String tpPushResult = this.batchAddTuPuJob(ctx, demandColl, pushType);
                    logger.info("\u63d0\u4ea4\u751f\u6548\u63a8\u9001\u9700\u6c42\u5230\u56fe\u8c31\u7ed3\u679c=====" + tpPushResult + "========");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u751f\u6548\u63a8\u9001\u9700\u6c42\u5230\u56fe\u8c31\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public void submitEffectAddTuPuJob(Context ctx, RecuritmentDemandCollection demandColl, String pushType) {
        try {
            RecIntegrateThirdPartyManagementCollection tpRuleSetCol = RecIntegrateThirdPartyManagementFactory.getLocalInstance(ctx).getRecIntegrateThirdPartyManagementCollection("select  demandIntegrateWay where id='VsNeCWlDh0aplkUqw0hHogB0juc=' and  state = '1'");
            if (tpRuleSetCol.size() > 0) {
                this.checkIntergrateRecuritmentSet(ctx);
                String demandIntegrateWay = tpRuleSetCol.get(0).getDemandIntegrateWay();
                if ("1".equals(demandIntegrateWay)) {
                    String tpPushResult = this.batchAddTuPuJob(ctx, demandColl, pushType);
                    logger.info("\u63d0\u4ea4\u751f\u6548\u63a8\u9001\u9700\u6c42\u5230\u56fe\u8c31\u7ed3\u679c=====" + tpPushResult + "========");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u751f\u6548\u63a8\u9001\u9700\u6c42\u5230\u56fe\u8c31\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public void updateStatusTuPuJob(Context ctx, String[] billIds, String type) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("demandTpRelated.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", RecuritmentDemandTuPuService.getStringSet(billIds), CompareType.INCLUDE));
        evi.setFilter(filter);
        RecuritmentDemandCollection demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
        if (demandColl.size() > 0) {
            String result = this.executeUpdateTuPuJobOsf(ctx, demandColl, "updateStatusTuPuJobIntegrate", type);
            logger.info("\u56fe\u8c31\u53d8\u66f4\u804c\u4f4d\u72b6\u6001\u7ed3\u679c=" + result);
        }
    }

    public void updateStatusTuPuJob(Context ctx, RecuritmentDemandCollection demandColl, String type) {
        if (demandColl.size() > 0) {
            String result = this.executeUpdateTuPuJobOsf(ctx, demandColl, "updateStatusTuPuJobIntegrate", type);
            logger.info("\u56fe\u8c31\u53d8\u66f4\u804c\u4f4d\u72b6\u6001\u7ed3\u679c=" + result);
        }
    }

    public JSONObject assemableTuPuJobData(Context ctx, String billId, String executeType) throws BOSException, EASBizException {
        JSONObject jobDataJson = new JSONObject();
        RecuritmentDemandCollection recuritmentDemandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection("select *,recuritPosition.*,recuritmentHead.email,filterCriteria.*,hDegree.*,demandTpRelated.* where id ='" + billId + "'");
        if (recuritmentDemandColl != null && recuritmentDemandColl.size() > 0) {
            Date arrivalDate;
            RecuritmentDemandInfo demandInfo = recuritmentDemandColl.get(0);
            String recuritmentType = demandInfo.getRecuritmentType();
            String tupuRecTypeValue = this.mateTpRecuritmentType(ctx, recuritmentType);
            if (StringUtils.isEmpty((CharSequence)tupuRecTypeValue)) {
                return null;
            }
            RecuritmentHeadInfo recuritmentHead = demandInfo.getRecuritmentHead();
            if (recuritmentHead != null) {
                jobDataJson.put("recruiterEmails", (Object)recuritmentHead.getEmail());
            }
            if ("executeAdd".equals(executeType)) {
                jobDataJson.put("exID", (Object)demandInfo.getNumber());
            } else if ("executeUpdate".equals(executeType)) {
                DemandTpRelatedInfo demandTpRelated = demandInfo.getDemandTpRelated();
                jobDataJson.put("positionId", (Object)(demandTpRelated != null ? demandTpRelated.getTupuJobId() : ""));
            }
            jobDataJson.put("positionCategory", (Object)tupuRecTypeValue);
            jobDataJson.put("amount", (Object)demandInfo.getRecuritNumber());
            jobDataJson.put("positionName", (Object)demandInfo.getPositionName());
            jobDataJson.put("desc", (Object)("\u804c\u4f4d\u804c\u8d23:<br>" + demandInfo.getResponsibilities() + "<br>\u4efb\u804c\u8981\u6c42:<br>" + demandInfo.getQualification()));
            DemandWorkAreaCollection demandWorkAreaCol = DemandWorkAreaFactory.getLocalInstance(ctx).getDemandWorkAreaCollection("where recuritmentDemand = '" + billId + "'");
            String address = "";
            String provinceName = "";
            String cityName = "";
            if (demandWorkAreaCol.size() > 0) {
                DemandWorkAreaInfo demandWorkAreaInfo = demandWorkAreaCol.get(0);
                provinceName = demandWorkAreaInfo.getProvinceName();
                cityName = demandWorkAreaInfo.getCityName();
                address = provinceName + cityName + demandWorkAreaInfo.getCountryName() + demandWorkAreaInfo.getDetailArea();
            }
            jobDataJson.put("address", (Object)address);
            jobDataJson.put("province", (Object)provinceName);
            jobDataJson.put("city", (Object)cityName);
            String workYearInitPar = "workYearList";
            String workYearValue = this.geTuPuInitPar(ctx, workYearInitPar, demandInfo);
            jobDataJson.put("workYear", (Object)workYearValue);
            String degreeInitPar = "degreeList";
            String degreeValue = this.geTuPuInitPar(ctx, degreeInitPar, demandInfo);
            jobDataJson.put("degree", (Object)degreeValue);
            String jobTypeInitPar = "jobTypeList";
            String jobTypeValue = this.geTuPuInitPar(ctx, jobTypeInitPar, demandInfo);
            jobDataJson.put("jobType", (Object)jobTypeValue);
            String salaryInitPar = "salaryList";
            String salaryValue = this.geTuPuInitPar(ctx, salaryInitPar, demandInfo);
            jobDataJson.put("salaryId", (Object)salaryValue);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if ("executeAdd".equals(executeType)) {
                Timestamp approveDate = demandInfo.getApproveDate();
                String startDate = "";
                if (approveDate != null) {
                    try {
                        Date date = dateFormat.parse(approveDate.toString());
                        startDate = dateFormat.format(date);
                    }
                    catch (ParseException e) {
                        logger.error("\u9700\u6c42\u5ba1\u6279\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
                        Date nowDate = RecBaseUtils.getNowDate();
                        startDate = dateFormat.format(nowDate);
                    }
                } else {
                    Date nowDate = RecBaseUtils.getNowDate();
                    startDate = dateFormat.format(nowDate);
                }
                jobDataJson.put("startDate", (Object)startDate);
            }
            if ((arrivalDate = demandInfo.getArrivalDate()) != null) {
                jobDataJson.put("endDate", (Object)dateFormat.format(arrivalDate));
            }
            jobDataJson.put("customizedField1", (Object)"");
            jobDataJson.put("customizedField2", (Object)"");
            jobDataJson.put("customizedField3", (Object)"");
            jobDataJson.put("customizedField4", (Object)"");
            jobDataJson.put("customizedField5", (Object)"");
        }
        return jobDataJson;
    }

    public String geTuPuInitPar(Context ctx, String initPar, RecuritmentDemandInfo demandInfo) throws EASBizException, BOSException {
        HashMap<String, String> osfparam = new HashMap<String, String>();
        osfparam.put("billIds", initPar);
        osfparam.put("from", "rec");
        osfparam.put("triggerKey", "geTuPuInitPar");
        osfparam.put("integrateType", "2");
        Object recPushService = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", osfparam);
        String initValue = "";
        String str = JSONObject.toJSONString((Object)recPushService);
        JSONObject pushIntegrateRecJson = JSONObject.parseObject((String)str);
        int success = (Integer)pushIntegrateRecJson.get((Object)"state");
        if (success == 1) {
            String integrateRes = pushIntegrateRecJson.get((Object)"integrateRes").toString();
            JSONObject dataObj = (JSONObject)JSON.parseObject((String)integrateRes, JSONObject.class);
            Set fieldItems = dataObj.entrySet();
            for (Map.Entry entry : fieldItems) {
                List mokaInterfaceDataList = (List)entry.getValue();
                JSONObject dataObject = mokaInterfaceDataList.size() > 0 ? (JSONObject)mokaInterfaceDataList.get(0) : null;
                if (dataObject == null || (Integer)dataObject.get((Object)"state") != 1) continue;
                String data = dataObject.get((Object)"data").toString();
                logger.error(initPar + "\u83b7\u53d6\u56fe\u8c31\u521b\u5efa\u804c\u4f4d\u6240\u9700\u8981\u7684\u5b57\u6bb5f7\u5bf9\u5e94id\u63a5\u53e3\u8fd4\u56de\u503c\u6570\u636e\u6253\u5370" + data);
                if (StringUtils.isNotEmpty((CharSequence)data)) {
                    Map.Entry initParInfo;
                    Iterator iterator;
                    JSONObject initParList;
                    String initParStr;
                    JSONObject tupuDataObject = JSONObject.parseObject((String)(data = JSONObject.parse((String)data).toString()));
                    if (!"100".equals(tupuDataObject.get((Object)"code").toString())) continue;
                    if ("degreeList".equals(initPar)) {
                        initParStr = tupuDataObject.get((Object)initPar).toString();
                        initParList = JSONObject.parseObject((String)initParStr);
                        iterator = initParList.entrySet().iterator();
                        while (iterator.hasNext() && !StringUtils.isNotEmpty((CharSequence)(initValue = this.getDegreeNameForTuPu(initParInfo = (Map.Entry)iterator.next(), demandInfo)))) {
                        }
                        continue;
                    }
                    if ("workYearList".equals(initPar)) {
                        Map.Entry initParInfo2;
                        FilterCriteriaInfo filterCriteria = demandInfo.getFilterCriteria();
                        int lowWorkYear = -1;
                        int highWorkYear = -1;
                        if (filterCriteria != null) {
                            if (filterCriteria.getLowWorkYears() != null) {
                                lowWorkYear = filterCriteria.getLowWorkYears().getValue();
                            }
                            if (filterCriteria.getHighWorkYears() != null) {
                                highWorkYear = filterCriteria.getHighWorkYears().getValue();
                            }
                        }
                        String initParStr2 = tupuDataObject.get((Object)initPar).toString();
                        JSONObject initParList2 = JSONObject.parseObject((String)initParStr2);
                        Iterator iterator2 = initParList2.entrySet().iterator();
                        while (iterator2.hasNext() && !StringUtils.isNotEmpty((CharSequence)(initValue = this.getWorkYearForTuPu(lowWorkYear, highWorkYear, initParInfo2 = (Map.Entry)iterator2.next())))) {
                        }
                        continue;
                    }
                    if ("salaryList".equals(initPar)) {
                        initParStr = tupuDataObject.get((Object)initPar).toString();
                        initParList = JSONObject.parseObject((String)initParStr);
                        iterator = initParList.entrySet().iterator();
                        while (iterator.hasNext() && !StringUtils.isNotEmpty((CharSequence)(initValue = this.getSalaryrForTuPu(initParInfo = (Map.Entry)iterator.next(), demandInfo)))) {
                        }
                        continue;
                    }
                    if (!"jobTypeList".equals(initPar)) continue;
                    initParStr = tupuDataObject.get((Object)initPar).toString();
                    initParList = JSONObject.parseObject((String)initParStr);
                    iterator = initParList.entrySet().iterator();
                    while (iterator.hasNext() && !StringUtils.isNotEmpty((CharSequence)(initValue = this.getJobNatureForTuPu(initParInfo = (Map.Entry)iterator.next(), demandInfo)))) {
                    }
                    continue;
                }
                logger.error("\u8c03\u7528\u56fe\u8c31\u804c\u4f4d\u65b0\u589e\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            }
        }
        return initValue;
    }

    private String getJobNatureForTuPu(Map.Entry<String, Object> initParInfo, RecuritmentDemandInfo demandInfo) {
        String jobName;
        String initValue = "";
        String value = initParInfo.getValue().toString();
        switch (jobName = demandInfo.getJobNature().getAlias()) {
            case "\u5b9e\u4e60": {
                jobName = "\u5b9e\u4e60\u751f";
                break;
            }
        }
        if (jobName.equals(value)) {
            initValue = initParInfo.getKey();
        }
        return initValue;
    }

    public String getSalaryrForTuPu(Map.Entry<String, Object> initParInfo, RecuritmentDemandInfo demandInfo) {
        String initValue = "";
        String value = initParInfo.getValue().toString();
        boolean useCustomSalary = demandInfo.isUseCustomSalary();
        if (useCustomSalary && "\u9762\u8bae".equals(value)) {
            return initParInfo.getKey();
        }
        String salaryRange = "";
        int highSalary = demandInfo.getHighSalary();
        salaryRange = highSalary < 2000 ? "2000\u4ee5\u4e0b" : (highSalary <= 3000 ? "2000-2999" : (highSalary <= 4000 ? "3000-3999" : (highSalary <= 6000 ? "4000-5999" : (highSalary <= 8000 ? "6000-7999" : (highSalary <= 10000 ? "8000-9999" : (highSalary <= 15000 ? "10000-14999" : (highSalary <= 20000 ? "15000-19999" : (highSalary <= 25000 ? "20000-24999" : (highSalary <= 30000 ? "25000-29999" : (highSalary <= 50000 ? "30000-49999" : "50000\u53ca\u4ee5\u4e0a"))))))))));
        if (salaryRange.equals(value)) {
            initValue = initParInfo.getKey();
        }
        return initValue;
    }

    public String getDegreeNameForTuPu(Map.Entry<String, Object> initParInfo, RecuritmentDemandInfo demandInfo) {
        DiplomaInfo hDegree;
        String initValue = "";
        String value = initParInfo.getValue().toString();
        FilterCriteriaInfo filterCriteria = demandInfo.getFilterCriteria();
        boolean degreeNoLimit = false;
        if (filterCriteria != null && (degreeNoLimit = filterCriteria.isDegreeNoLimit()) && "\u5176\u4ed6".equals(value)) {
            return initParInfo.getKey();
        }
        if (!degreeNoLimit && (hDegree = demandInfo.getHDegree()) != null) {
            String degreeName;
            switch (degreeName = hDegree.getName()) {
                case "\u521d\u4e2d\u53ca\u4ee5\u4e0b": {
                    degreeName = "\u521d\u4e2d";
                    break;
                }
                case "\u5927\u5b66\u4e13\u79d1": {
                    degreeName = "\u5927\u4e13";
                    break;
                }
                case "\u5927\u5b66\u672c\u79d1": {
                    degreeName = "\u672c\u79d1";
                    break;
                }
                case "\u7855\u58eb\u7814\u7a76\u751f": {
                    degreeName = "\u7855\u58eb";
                    break;
                }
                case "\u535a\u58eb\u7814\u7a76\u751f": {
                    degreeName = "\u535a\u58eb";
                    break;
                }
            }
            if (degreeName.equals(value)) {
                initValue = initParInfo.getKey();
            }
        }
        return initValue;
    }

    public String getWorkYearForTuPu(int lowWorkYear, int highWorkYear, Map.Entry<String, Object> initParInfo) {
        String initValue = "";
        String workYear = "\u4e0d\u9650";
        String value = initParInfo.getValue().toString();
        if (lowWorkYear == -1 && highWorkYear == -1 && workYear.equals(value)) {
            return initParInfo.getKey();
        }
        workYear = highWorkYear <= 1 ? "1\u5e74\u4ee5\u4e0b" : (highWorkYear <= 3 ? "1-3\u5e74" : (highWorkYear <= 5 ? "3-5\u5e74" : (highWorkYear <= 10 ? "5-10\u5e74" : "10\u5e74\u4ee5\u4e0a")));
        if (workYear.equals(value)) {
            initValue = initParInfo.getKey();
        }
        return initValue;
    }

    public static Set<String> getStringSet(String[] ids) {
        if (null != ids && ids.length > 0) {
            HashSet<String> result = new HashSet<String>();
            int total = ids.length;
            for (int i = 0; i < total; ++i) {
                result.add(ids[i]);
            }
            return result;
        }
        return null;
    }
}

