/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.FocusOnSource;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeClipRelationCollection;
import com.kingdee.shr.recuritment.ResumeClipRelationFactory;
import com.kingdee.shr.recuritment.ResumeClipRelationInfo;
import com.kingdee.shr.recuritment.ResumeOperRecordFactory;
import com.kingdee.shr.recuritment.ResumeOperRecordInfo;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ResumeOperRecordService {
    private static final Logger logger = Logger.getLogger(ResumeOperRecordService.class);

    public static ResumeOperRecordService getInstance() {
        return ResumeOperRecordServiceHolder.service;
    }

    public void addResumeOperRecord(Context ctx, String item, String description, ResumeBaseRecInfo resume) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Date currentDate = new Date(System.currentTimeMillis());
        ResumeOperRecordInfo record = new ResumeOperRecordInfo();
        record.setOperator(person);
        record.setOperationDate(currentDate);
        record.setOperationSource(FocusOnSource.resume);
        record.setOperationItem(item);
        record.setResumeBaseRec(resume);
        record.setDescription(description);
        try {
            ResumeOperRecordFactory.getLocalInstance(ctx).addnew(record);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addEnterpriseArchivesOperRecord(Context ctx, String item, String description, ResumeClipRelationInfo resumeClipRelation) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Date currentDate = new Date(System.currentTimeMillis());
        ResumeOperRecordInfo record = new ResumeOperRecordInfo();
        record.setOperator(person);
        record.setOperationDate(currentDate);
        record.setOperationSource(FocusOnSource.enterpriseArchives);
        record.setOperationItem(item);
        record.setResumeClipRelation(resumeClipRelation);
        record.setEnterpriseArchives(resumeClipRelation.getEnterpriseArchives());
        record.setDescription(description);
        try {
            ResumeOperRecordFactory.getLocalInstance(ctx).addnew(record);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addEnterpriseArchivesOperRecord(Context ctx, String item, String description, EnterpriseArchivesInfo enterpriseArchives, ResumeClipRelationInfo resumeClipRelation) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Date currentDate = new Date(System.currentTimeMillis());
        ResumeOperRecordInfo record = new ResumeOperRecordInfo();
        record.setOperator(person);
        record.setOperationDate(currentDate);
        record.setOperationSource(FocusOnSource.enterpriseArchives);
        record.setOperationItem(item);
        record.setEnterpriseArchives(enterpriseArchives);
        record.setResumeClipRelation(resumeClipRelation);
        record.setDescription(description);
        try {
            ResumeOperRecordFactory.getLocalInstance(ctx).addnew(record);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addEnterpriseArchivesOperRecord(Context ctx, String item, String description, EnterpriseArchivesInfo enterpriseArchives) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Date currentDate = new Date(System.currentTimeMillis());
        ResumeOperRecordInfo record = new ResumeOperRecordInfo();
        record.setOperator(person);
        record.setOperationDate(currentDate);
        record.setOperationSource(FocusOnSource.enterpriseArchives);
        record.setOperationItem(item);
        record.setEnterpriseArchives(enterpriseArchives);
        record.setDescription(description);
        try {
            ResumeOperRecordFactory.getLocalInstance(ctx).addnew(record);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addEnterpriseArchivesOperRecord(Context ctx, String item, String description, String relationPk) {
        if (relationPk != null) {
            ResumeClipRelationInfo resumeClipRelation = new ResumeClipRelationInfo();
            resumeClipRelation.setId(BOSUuid.read((String)relationPk.toString()));
            this.addEnterpriseArchivesOperRecord(ctx, item, description, resumeClipRelation);
        }
    }

    public void addBlackOperRecord(Context ctx, String item, String description, String uniqId) {
        if (!StringUtils.isEmpty((CharSequence)uniqId)) {
            try {
                ResumeClipRelationCollection enArchivesColl;
                ResumeBaseRecCollection resumeColl = ResumeBaseRecFactory.getLocalInstance(ctx).getResumeBaseRecCollection("where ifSimplePerson = '" + uniqId + "' ");
                if (resumeColl != null && resumeColl.size() > 0) {
                    for (int i = 0; i < resumeColl.size(); ++i) {
                        ResumeBaseRecInfo resume = resumeColl.get(i);
                        this.addResumeOperRecord(ctx, item, description, resume);
                    }
                }
                if ((enArchivesColl = ResumeClipRelationFactory.getLocalInstance(ctx).getResumeClipRelationCollection("where enterpriseArchives.uniqId='" + uniqId + "' AND enterpriseArchives.state = '" + "1" + "'")) != null && enArchivesColl.size() > 0) {
                    for (int i = 0; i < enArchivesColl.size(); ++i) {
                        this.addEnterpriseArchivesOperRecord(ctx, item, description, enArchivesColl.get(i));
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addResumeOperRecord(Context ctx, String item, String description, String[] resumeIds) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Date currentDate = new Date(System.currentTimeMillis());
        CoreBaseCollection coll = new CoreBaseCollection();
        for (String resumeId : resumeIds) {
            ResumeOperRecordInfo record = new ResumeOperRecordInfo();
            record.setOperator(person);
            record.setOperationDate(currentDate);
            record.setOperationSource(FocusOnSource.resume);
            record.setOperationItem(item);
            record.put("resumeBaseRec", resumeId);
            record.setDescription(description);
            coll.add((CoreBaseInfo)record);
        }
        try {
            ResumeOperRecordFactory.getLocalInstance(ctx).addnew(coll);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class ResumeOperRecordServiceHolder {
        private static final ResumeOperRecordService service = new ResumeOperRecordService();

        private ResumeOperRecordServiceHolder() {
        }
    }
}

