/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.IPersonLanguage;
import com.kingdee.eas.hr.emp.IPersonWorkExp;
import com.kingdee.eas.hr.emp.IProjectExperience;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonLanguageFactory;
import com.kingdee.eas.hr.emp.PersonLanguageInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.hr.emp.ProjectExperienceFactory;
import com.kingdee.eas.hr.emp.ProjectExperienceInfo;
import com.kingdee.shr.base.syssetting.util.VerifierUtil;
import com.kingdee.shr.recuritment.EducationExpRECCollection;
import com.kingdee.shr.recuritment.EducationExpRECFactory;
import com.kingdee.shr.recuritment.EnterpriseNatureFactory;
import com.kingdee.shr.recuritment.EnterpriseNatureInfo;
import com.kingdee.shr.recuritment.IEducationExpREC;
import com.kingdee.shr.recuritment.ILanguageAbility;
import com.kingdee.shr.recuritment.IProfessionalSkills;
import com.kingdee.shr.recuritment.IProjectExp;
import com.kingdee.shr.recuritment.IWorkingExp;
import com.kingdee.shr.recuritment.LanguageAbilityCollection;
import com.kingdee.shr.recuritment.LanguageAbilityFactory;
import com.kingdee.shr.recuritment.ProfessionalSkillsCollection;
import com.kingdee.shr.recuritment.ProfessionalSkillsFactory;
import com.kingdee.shr.recuritment.ProjectExpCollection;
import com.kingdee.shr.recuritment.ProjectExpFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.WorkingExpCollection;
import com.kingdee.shr.recuritment.WorkingExpFactory;
import com.kingdee.shr.recuritment.WorkingExpInfo;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResumeSyncToPersonService {
    private Logger logger = Logger.getLogger(ResumeSyncToPersonService.class);

    public PersonInfo syncPersonBaseInfo(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) {
        if (null != resume.getNational()) {
            person.setNationality(resume.getNational());
        }
        if (!RecDBUtils.isEmpty(resume.getNativePlace())) {
            person.setNativePlace(resume.getNativePlace());
        }
        if (null != resume.getFolk()) {
            person.setFolk(resume.getFolk());
        }
        if (!RecDBUtils.isEmpty(resume.getDomicilePlace())) {
            person.setHjAddress(resume.getDomicilePlace());
        }
        if (null != resume.getWed()) {
            person.setWed(resume.getWed());
        }
        if (null != resume.getPoliticalFace()) {
            person.setPoliticalFace(resume.getPoliticalFace());
        }
        if (null != resume.getBloodType()) {
            person.setBloodType(resume.getBloodType());
        }
        if (null != resume.getStature()) {
            person.setHeight(RecDBUtils.convertStrToInt(resume.getStature()));
        }
        return person;
    }

    public void syncPersonContactMethod(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) {
        try {
            IPersonContactMethod iPersonContactMethod = PersonContactMethodFactory.getLocalInstance((Context)ctx);
            PersonContactMethodInfo personContactMethod = null;
            PersonContactMethodCollection pcmColl = iPersonContactMethod.getPersonContactMethodCollection("where person = '" + person.getId().toString() + "' ");
            if (!RecDBUtils.isEmpty((IObjectCollection)pcmColl)) {
                personContactMethod = pcmColl.get(0);
            } else {
                personContactMethod = new PersonContactMethodInfo();
                personContactMethod.setPerson(person);
            }
            if (!RecDBUtils.isEmpty(resume.getMobilePhone()) && RecDBUtils.isEmpty(personContactMethod.getMobile())) {
                personContactMethod.setMobile(resume.getMobilePhone());
            }
            if (!RecDBUtils.isEmpty(resume.getEmail()) && RecDBUtils.isEmpty(personContactMethod.getEmail())) {
                boolean emailCheck = VerifierUtil.verifierEmail((Context)ctx, (String)resume.getEmail());
                if (!emailCheck) {
                    this.logger.error((Object)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65");
                } else {
                    personContactMethod.setEmail(resume.getEmail());
                }
            }
            if (!RecDBUtils.isEmpty(resume.getFixedPhone())) {
                personContactMethod.setHomePhone(resume.getFixedPhone());
            }
            if (!RecDBUtils.isEmpty(resume.getNowResidence())) {
                personContactMethod.setWorkplace(resume.getNowResidence());
            }
            if (!RecDBUtils.isEmpty(resume.getEmergencyContact())) {
                personContactMethod.setLinkName(resume.getEmergencyContact());
            }
            if (!RecDBUtils.isEmpty(resume.getEmergencyContactPhone())) {
                personContactMethod.setLinkTelNum(resume.getEmergencyContactPhone());
            }
            if (!RecDBUtils.isEmpty(resume.getWeChat())) {
                personContactMethod.setWeixin(resume.getWeChat());
            }
            if (!RecDBUtils.isEmpty(resume.getTwitter())) {
                personContactMethod.setSina(resume.getTwitter());
            }
            iPersonContactMethod.save((CoreBaseInfo)personContactMethod);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void syncPersonWorkExp(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IWorkingExp iWorkingExp = WorkingExpFactory.getLocalInstance(ctx);
        WorkingExpCollection coll = iWorkingExp.getWorkingExpCollection("where resumeBase = '" + resume.getId().toString() + "' ");
        if (!RecDBUtils.isEmpty((IObjectCollection)coll)) {
            Map<String, Integer> tableMap = this.getField(new PersonWorkExpInfo().getBOSType());
            IPersonWorkExp iPersonWorkExp = PersonWorkExpFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            WorkingExpInfo workingExpInfo = null;
            PersonWorkExpInfo personWorkExp = null;
            for (int i = 0; i < coll.size(); ++i) {
                EnterpriseNatureInfo enColl;
                workingExpInfo = coll.get(i);
                personWorkExp = new PersonWorkExpInfo();
                personWorkExp.setPerson(person);
                personWorkExp.setBeginDate(workingExpInfo.getDateStart());
                personWorkExp.setEndDate(workingExpInfo.getDateEnd());
                if (!RecDBUtils.isEmpty(workingExpInfo.getCompany())) {
                    if (workingExpInfo.getCompany().length() >= tableMap.get("FUnitName")) {
                        personWorkExp.setUnitName(workingExpInfo.getCompany().substring(0, tableMap.get("FUnitName") - 1));
                    } else {
                        personWorkExp.setUnitName(workingExpInfo.getCompany());
                    }
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getIndustry())) {
                    if (workingExpInfo.getIndustry().length() >= tableMap.get("FIndustryType")) {
                        personWorkExp.setIndustryType(workingExpInfo.getIndustry().substring(0, tableMap.get("FIndustryType") - 1));
                    } else {
                        personWorkExp.setIndustryType(workingExpInfo.getIndustry());
                    }
                }
                if (null != workingExpInfo.getEnterpriseNature() && !RecDBUtils.isEmpty((enColl = EnterpriseNatureFactory.getLocalInstance(ctx).getEnterpriseNatureInfo((IObjectPK)new ObjectUuidPK(coll.get(i).getEnterpriseNature().getId()), sic)).getName())) {
                    if (enColl.getName().length() >= tableMap.get("FUnitType")) {
                        personWorkExp.setUnitType(enColl.getName().substring(0, tableMap.get("FUnitType") - 1));
                    } else {
                        personWorkExp.setUnitType(enColl.getName());
                    }
                }
                personWorkExp.setPersonQuantity(workingExpInfo.getTotalStaff());
                if (!RecDBUtils.isEmpty(workingExpInfo.getPosition())) {
                    if (workingExpInfo.getPosition().length() >= tableMap.get("FPosition")) {
                        personWorkExp.setPosition(workingExpInfo.getPosition().substring(0, tableMap.get("FPosition") - 1));
                    } else {
                        personWorkExp.setPosition(workingExpInfo.getPosition());
                    }
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getDepartment())) {
                    if (workingExpInfo.getDepartment().length() >= tableMap.get("FWorkDept")) {
                        personWorkExp.setWorkDept(workingExpInfo.getDepartment().substring(0, tableMap.get("FWorkDept") - 1));
                    } else {
                        personWorkExp.setWorkDept(workingExpInfo.getDepartment());
                    }
                }
                personWorkExp.setSubordinateQuantity(workingExpInfo.getUnderlingNumber());
                personWorkExp.setSalary(new BigDecimal(workingExpInfo.getMonthPay()));
                if (!RecDBUtils.isEmpty(workingExpInfo.getLeavingReason())) {
                    if (workingExpInfo.getLeavingReason().length() >= tableMap.get("FDimission")) {
                        personWorkExp.setDimission(workingExpInfo.getLeavingReason().substring(0, tableMap.get("FDimission") - 1));
                    } else {
                        personWorkExp.setDimission(workingExpInfo.getLeavingReason());
                    }
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getCertifier())) {
                    personWorkExp.setLinkman(workingExpInfo.getCertifier());
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getCertifierPhone())) {
                    personWorkExp.setLinkmanPhone(workingExpInfo.getCertifierPhone());
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getTotalStaffStr())) {
                    personWorkExp.setPersonQuantity(RecDBUtils.convertStrToInt(workingExpInfo.getTotalStaffStr()));
                }
                if (!RecDBUtils.isEmpty(workingExpInfo.getUnderlingNumberStr())) {
                    personWorkExp.setSubordinateQuantity(RecDBUtils.convertStrToInt(workingExpInfo.getUnderlingNumberStr()));
                }
                try {
                    personWorkExp.setJobDesc(workingExpInfo.getJobDescription());
                    iPersonWorkExp.addnew((EmpInfoMultiPageInfo)personWorkExp);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u5de5\u4f5c\u7ecf\u5386\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + workingExpInfo.getJobDescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonDegree(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IEducationExpREC iEducationExpREC = EducationExpRECFactory.getLocalInstance(ctx);
        EducationExpRECCollection eduColl = iEducationExpREC.getEducationExpRECCollection("where resumeBase = '" + resume.getId().toString() + "' order by dateEnd desc");
        if (eduColl != null && eduColl.size() > 0) {
            IPersonDegree iPersonDegree = PersonDegreeFactory.getLocalInstance((Context)ctx);
            PersonDegreeInfo personDegree = null;
            for (int i = 0; i < eduColl.size(); ++i) {
                personDegree = new PersonDegreeInfo();
                personDegree.setPerson(person);
                if (i == 0) {
                    personDegree.setIsHighest(true);
                } else {
                    personDegree.setIsHighest(false);
                }
                personDegree.setEnrollDate(eduColl.get(i).getDateStart());
                personDegree.setGraduateDate(eduColl.get(i).getDateEnd());
                personDegree.setGraduateSchool(eduColl.get(i).getSchool());
                personDegree.setSpecialty(eduColl.get(i).getMajor());
                if (null != eduColl.get(i).getGraduateType()) {
                    personDegree.setGraduateType(eduColl.get(i).getGraduateType());
                }
                personDegree.setDiploma(eduColl.get(i).getDegreeF7());
                if (null != eduColl.get(i).getAcademicDiplomasF7()) {
                    personDegree.setDegree(eduColl.get(i).getAcademicDiplomasF7());
                }
                iPersonDegree.addnew((EmpInfoMultiPageInfo)personDegree);
            }
        }
    }

    public void syncProjectExperience(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IProjectExp iProjectExp = ProjectExpFactory.getLocalInstance(ctx);
        ProjectExpCollection proColl = iProjectExp.getProjectExpCollection("where resumeBase = '" + resume.getId().toString() + "' ");
        if (proColl != null && proColl.size() > 0) {
            IProjectExperience iProjectExperience = ProjectExperienceFactory.getLocalInstance((Context)ctx);
            ProjectExperienceInfo projectExperience = null;
            for (int i = 0; i < proColl.size(); ++i) {
                projectExperience = new ProjectExperienceInfo();
                projectExperience.setPerson(person);
                projectExperience.setStartDate(proColl.get(i).getDateStart());
                projectExperience.setEndDate(proColl.get(i).getDateEnd());
                projectExperience.setName(proColl.get(i).getCustomer());
                try {
                    projectExperience.setPdescription(proColl.get(i).getPdescription());
                    projectExperience.setProfession(proColl.get(i).getIndustry());
                    projectExperience.setAssumeRole(proColl.get(i).getRole());
                    projectExperience.setMainResposibility(proColl.get(i).getMainDuty());
                    iProjectExperience.addnew(projectExperience);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u9879\u76ee\u7ecf\u5386\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + proColl.get(i).getPdescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonLanguage(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        ILanguageAbility iLanguageAbility = LanguageAbilityFactory.getLocalInstance(ctx);
        LanguageAbilityCollection lanColl = iLanguageAbility.getLanguageAbilityCollection("where resumeBase = '" + resume.getId().toString() + "' ");
        if (lanColl != null && lanColl.size() > 0) {
            IPersonLanguage iPersonLanguage = PersonLanguageFactory.getLocalInstance((Context)ctx);
            PersonLanguageInfo personLanguage = null;
            for (int i = 0; i < lanColl.size(); ++i) {
                personLanguage = new PersonLanguageInfo();
                if (RecDBUtils.isEmpty(lanColl.get(i).getLanguage())) continue;
                personLanguage.setPerson(person);
                personLanguage.setLanguage(lanColl.get(i).getLanguage());
                personLanguage.setLevel(lanColl.get(i).getLv());
                iPersonLanguage.addnew((EmpInfoMultiPageInfo)personLanguage);
            }
        }
    }

    public void syncPersonCertification(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IProfessionalSkills iProfessionalSkills = ProfessionalSkillsFactory.getLocalInstance(ctx);
        ProfessionalSkillsCollection skillColl = iProfessionalSkills.getProfessionalSkillsCollection("where resumeBase = '" + resume.getId().toString() + "' ");
        if (skillColl != null && skillColl.size() > 0) {
            IPersonCertification iPersonCertification = PersonCertificationFactory.getLocalInstance((Context)ctx);
            PersonCertificationInfo personCertification = null;
            for (int i = 0; i < skillColl.size(); ++i) {
                personCertification = new PersonCertificationInfo();
                personCertification.setPerson(person);
                try {
                    if (RecDBUtils.isEmpty(skillColl.get(i).getSkillName())) continue;
                    personCertification.setCertificateName(skillColl.get(i).getSkillName());
                    if (!RecDBUtils.isEmpty(skillColl.get(i).getSkillDescription())) {
                        personCertification.setRemark(skillColl.get(i).getSkillDescription());
                    }
                    iPersonCertification.addnew((EmpInfoMultiPageInfo)personCertification);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u6280\u80fd\u4fe1\u606f\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + skillColl.get(i).getSkillDescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Map<String, Integer> getField(BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ColumnCollection columnCollection = RecDBUtils.getBOSObjectColumns(bosType);
        ColumnInfo columnInfo = null;
        for (int j = 0; j < columnCollection.size(); ++j) {
            columnInfo = columnCollection.get(j);
            result.put(columnInfo.getName(), columnInfo.getLength());
        }
        return result;
    }
}

