/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.IPersonCertifyCompetency;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.IPersonFamily;
import com.kingdee.eas.hr.emp.IPersonLanguage;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.IPersonTechnicalPost;
import com.kingdee.eas.hr.emp.IPersonWorkExp;
import com.kingdee.eas.hr.emp.IProjectExperience;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyFactory;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonFamilyFactory;
import com.kingdee.eas.hr.emp.PersonFamilyInfo;
import com.kingdee.eas.hr.emp.PersonLanguageFactory;
import com.kingdee.eas.hr.emp.PersonLanguageInfo;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.hr.emp.ProjectExperienceFactory;
import com.kingdee.eas.hr.emp.ProjectExperienceInfo;
import com.kingdee.shr.base.syssetting.util.VerifierUtil;
import com.kingdee.shr.recuritment.EducationExpRECCollection;
import com.kingdee.shr.recuritment.EducationExpRECFactory;
import com.kingdee.shr.recuritment.EducationExpRECInfo;
import com.kingdee.shr.recuritment.EnterpriseNatureFactory;
import com.kingdee.shr.recuritment.EnterpriseNatureInfo;
import com.kingdee.shr.recuritment.IEducationExpREC;
import com.kingdee.shr.recuritment.ILanguageAbility;
import com.kingdee.shr.recuritment.IProfessionalSkills;
import com.kingdee.shr.recuritment.IProjectExp;
import com.kingdee.shr.recuritment.IResumeCertifyCompetency;
import com.kingdee.shr.recuritment.IResumeFamily;
import com.kingdee.shr.recuritment.IResumeTechnicalPost;
import com.kingdee.shr.recuritment.IWorkingExp;
import com.kingdee.shr.recuritment.LanguageAbilityCollection;
import com.kingdee.shr.recuritment.LanguageAbilityFactory;
import com.kingdee.shr.recuritment.ProfessionalSkillsCollection;
import com.kingdee.shr.recuritment.ProfessionalSkillsFactory;
import com.kingdee.shr.recuritment.ProjectExpCollection;
import com.kingdee.shr.recuritment.ProjectExpFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeCertifyCompetencyCollection;
import com.kingdee.shr.recuritment.ResumeCertifyCompetencyFactory;
import com.kingdee.shr.recuritment.ResumeCertifyCompetencyInfo;
import com.kingdee.shr.recuritment.ResumeFamilyCollection;
import com.kingdee.shr.recuritment.ResumeFamilyFactory;
import com.kingdee.shr.recuritment.ResumeFamilyInfo;
import com.kingdee.shr.recuritment.ResumePhotoFactory;
import com.kingdee.shr.recuritment.ResumePhotoInfo;
import com.kingdee.shr.recuritment.ResumeTechnicalPostCollection;
import com.kingdee.shr.recuritment.ResumeTechnicalPostFactory;
import com.kingdee.shr.recuritment.ResumeTechnicalPostInfo;
import com.kingdee.shr.recuritment.WorkingExpCollection;
import com.kingdee.shr.recuritment.WorkingExpFactory;
import com.kingdee.shr.recuritment.WorkingExpInfo;
import com.kingdee.shr.recuritment.app.util.convert.ResumeConvertUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ResumeToPersonService {
    private Logger logger = Logger.getLogger(ResumeToPersonService.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$");

    public PersonInfo syncPersonBaseInfo(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) {
        if (null != resume.getNational()) {
            person.setNationality(resume.getNational());
        }
        if (!StringUtils.isEmpty((CharSequence)resume.getNativePlace())) {
            person.setNativePlace(resume.getNativePlace());
        }
        if (null != resume.getFolk()) {
            person.setFolk(resume.getFolk());
        }
        if (!StringUtils.isEmpty((CharSequence)resume.getDomicilePlace())) {
            person.setHjAddress(resume.getDomicilePlace());
        }
        if (null != resume.getWed()) {
            person.setWed(resume.getWed());
        }
        if (null != resume.getPoliticalFace()) {
            person.setPoliticalFace(resume.getPoliticalFace());
        }
        if (null != resume.getBloodType()) {
            person.setBloodType(resume.getBloodType());
        }
        if (null != resume.getStature()) {
            person.setHeight(ResumeConvertUtil.getTall(resume.getStature()));
        }
        return person;
    }

    public void syncPersonPhoto(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException {
        IPersonPhoto iPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
        PersonPhotoCollection photoColl = iPhoto.getPersonPhotoCollection("where person = '" + person.getId().toString() + "'");
        if (photoColl.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(">>>>>>>>>>>>>>>>>>>>\u5458\u5de5person\uff1a" + person.getId().toString() + " \u5df2\u5b58\u5728\u5934\u50cf\uff0c\u540c\u6b65\u7ed3\u675f\u3002<<<<<<<<<<<<<<<<<<<"));
            }
            return;
        }
        ResumePhotoInfo resumePhoto = null;
        try {
            resumePhoto = ResumePhotoFactory.getLocalInstance(ctx).getResumePhotoInfo(" where resumeBaseRec = '" + resume.getId().toString() + "'");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u83b7\u53d6\u7b80\u5386\u5934\u50cf\u5931\u8d25\uff01");
        }
        if (resumePhoto != null && resumePhoto.getImageData() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(">>>>>>>>>>>>>>>>>>>>\u83b7\u53d6\u5230\u5934\u50cf\u4fe1\u606f,\u5bf9person\uff1a" + person.getId().toString() + "\u6dfb\u52a0\u7b80\u5386\u5934\u50cf<<<<<<<<<<<<<<<<<<<"));
            }
            PersonPhotoInfo personPhoto = new PersonPhotoInfo();
            personPhoto.setPerson(person);
            personPhoto.setImageData(resumePhoto.getImageData());
            personPhoto.setImageDataSource(resumePhoto.getImageDataSource());
            personPhoto.setImageContentType(resumePhoto.getImageContentType());
            personPhoto.setSourceImageWidth(resumePhoto.getSourceImageWidth());
            personPhoto.setSourceImageHeight(resumePhoto.getSourceImageHeight());
            try {
                iPhoto.addnew((CoreBaseInfo)personPhoto);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("\u540c\u6b65\u521b\u5efaPerson\u5934\u50cf\u5931\u8d25\uff01");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)">>>>>>>>>>>>>>>>>>>>\u5934\u50cf\u4fe1\u606f\u6dfb\u52a0\u6210\u529f<<<<<<<<<<<<<<<<<");
            }
        }
    }

    public void syncPersonContactMethod(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) {
        try {
            List<Object[]> datas;
            IPersonContactMethod iPersonContactMethod = PersonContactMethodFactory.getLocalInstance((Context)ctx);
            PersonContactMethodInfo personContactMethod = null;
            PersonContactMethodCollection pcmColl = iPersonContactMethod.getPersonContactMethodCollection("where person = '" + person.getId().toString() + "' ");
            if (pcmColl.size() > 0) {
                personContactMethod = pcmColl.get(0);
            } else {
                personContactMethod = new PersonContactMethodInfo();
                personContactMethod.setPerson(person);
            }
            ArrayList<String> params = new ArrayList<String>();
            StringBuilder sql = new StringBuilder("SELECT FID FROM T_HR_PersonContactMethod WHERE FPersonID != '" + person.getId().toString() + "' AND ( 1 != 1 ");
            if (!StringUtils.isEmpty((CharSequence)resume.getMobilePhone())) {
                sql.append(" OR FMobile = ? ");
                params.add(resume.getMobilePhone());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getEmail())) {
                sql.append(" OR FEmail = ? ");
                params.add(resume.getEmail());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getFixedPhone())) {
                sql.append(" OR FHomePhone = ? ");
                params.add(resume.getFixedPhone());
            }
            sql.append(")");
            boolean canUpdatePersonContactMethod = false;
            if (!RecDBUtils.isEmpty(params) && RecDBUtils.isEmpty(datas = RecDBUtils.getQueryData(ctx, sql.toString(), params.toArray(new String[0])))) {
                canUpdatePersonContactMethod = true;
            }
            if (canUpdatePersonContactMethod) {
                if (!StringUtils.isEmpty((CharSequence)resume.getMobilePhone()) && StringUtils.isEmpty((CharSequence)personContactMethod.getMobile())) {
                    personContactMethod.setMobile("+86-" + resume.getMobilePhone());
                    personContactMethod.setNCell(resume.getMobilePhone());
                    personContactMethod.setGlobalRoaming("+86");
                }
                if (!StringUtils.isEmpty((CharSequence)resume.getEmail()) && StringUtils.isEmpty((CharSequence)personContactMethod.getEmail())) {
                    boolean emailCheck = VerifierUtil.verifierEmail((Context)ctx, (String)resume.getEmail());
                    if (!emailCheck) {
                        this.logger.error((Object)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65");
                    } else {
                        personContactMethod.setEmail(resume.getEmail());
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)resume.getFixedPhone())) {
                    personContactMethod.setHomePhone(resume.getFixedPhone());
                }
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getNowResidence())) {
                personContactMethod.setWorkplace(resume.getNowResidence());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getEmergencyContact())) {
                personContactMethod.setLinkName(resume.getEmergencyContact());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getEmergencyContactPhone())) {
                personContactMethod.setLinkTelNum(resume.getEmergencyContactPhone());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getWeChat())) {
                personContactMethod.setWeixin(resume.getWeChat());
            }
            if (!StringUtils.isEmpty((CharSequence)resume.getTwitter())) {
                personContactMethod.setSina(resume.getTwitter());
            }
            iPersonContactMethod.save((CoreBaseInfo)personContactMethod);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void syncPersonWorkExp(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IWorkingExp iWorkingExp = WorkingExpFactory.getLocalInstance(ctx);
        WorkingExpCollection coll = iWorkingExp.getWorkingExpCollection("where resumeBase = '" + resume.getId().toString() + "'  order by dateStart desc ");
        if (coll.size() > 0) {
            Map<String, Integer> tableMap = this.getField(new PersonWorkExpInfo().getBOSType());
            IPersonWorkExp iPersonWorkExp = PersonWorkExpFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            WorkingExpInfo workingExpInfo = null;
            PersonWorkExpInfo personWorkExp = null;
            for (int i = 0; i < coll.size(); ++i) {
                EnterpriseNatureInfo enColl;
                workingExpInfo = coll.get(i);
                personWorkExp = new PersonWorkExpInfo();
                personWorkExp.setPerson(person);
                personWorkExp.setBeginDate(workingExpInfo.getDateStart());
                personWorkExp.setEndDate(workingExpInfo.getDateEnd());
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getCompany())) {
                    if (workingExpInfo.getCompany().length() >= tableMap.get("FUnitName")) {
                        personWorkExp.setUnitName(workingExpInfo.getCompany().substring(0, tableMap.get("FUnitName") - 1));
                    } else {
                        personWorkExp.setUnitName(workingExpInfo.getCompany());
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getIndustry())) {
                    if (workingExpInfo.getIndustry().length() >= tableMap.get("FIndustryType")) {
                        personWorkExp.setIndustryType(workingExpInfo.getIndustry().substring(0, tableMap.get("FIndustryType") - 1));
                    } else {
                        personWorkExp.setIndustryType(workingExpInfo.getIndustry());
                    }
                }
                if (null != workingExpInfo.getEnterpriseNature() && !StringUtils.isEmpty((CharSequence)(enColl = EnterpriseNatureFactory.getLocalInstance(ctx).getEnterpriseNatureInfo((IObjectPK)new ObjectUuidPK(coll.get(i).getEnterpriseNature().getId()), sic)).getName())) {
                    if (enColl.getName().length() >= tableMap.get("FUnitType")) {
                        personWorkExp.setUnitType(enColl.getName().substring(0, tableMap.get("FUnitType") - 1));
                    } else {
                        personWorkExp.setUnitType(enColl.getName());
                    }
                }
                personWorkExp.setPersonQuantity(workingExpInfo.getTotalStaff());
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getPosition())) {
                    if (workingExpInfo.getPosition().length() >= tableMap.get("FPosition")) {
                        personWorkExp.setPosition(workingExpInfo.getPosition().substring(0, tableMap.get("FPosition") - 1));
                    } else {
                        personWorkExp.setPosition(workingExpInfo.getPosition());
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getDepartment())) {
                    if (workingExpInfo.getDepartment().length() >= tableMap.get("FWorkDept")) {
                        personWorkExp.setWorkDept(workingExpInfo.getDepartment().substring(0, tableMap.get("FWorkDept") - 1));
                    } else {
                        personWorkExp.setWorkDept(workingExpInfo.getDepartment());
                    }
                }
                personWorkExp.setSubordinateQuantity(workingExpInfo.getUnderlingNumber());
                Pattern pattern = NUMBER_PATTERN;
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getMonthPayStr()) && pattern.matcher(workingExpInfo.getMonthPayStr()).matches()) {
                    personWorkExp.setSalary(new BigDecimal(workingExpInfo.getMonthPayStr()));
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getLeavingReason())) {
                    if (workingExpInfo.getLeavingReason().length() >= tableMap.get("FDimission")) {
                        personWorkExp.setDimission(workingExpInfo.getLeavingReason().substring(0, tableMap.get("FDimission") - 1));
                    } else {
                        personWorkExp.setDimission(workingExpInfo.getLeavingReason());
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getCertifier())) {
                    personWorkExp.setLinkman(workingExpInfo.getCertifier());
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getCertifierPhone())) {
                    personWorkExp.setLinkmanPhone(workingExpInfo.getCertifierPhone());
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getTotalStaffStr())) {
                    personWorkExp.setPersonQuantity(ResumeConvertUtil.getTall(workingExpInfo.getTotalStaffStr()));
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getUnderlingNumberStr())) {
                    personWorkExp.setSubordinateQuantity(ResumeConvertUtil.getTall(workingExpInfo.getUnderlingNumberStr()));
                }
                if (!StringUtils.isEmpty((CharSequence)workingExpInfo.getMonthPayStr())) {
                    try {
                        personWorkExp.setSalary(new BigDecimal(workingExpInfo.getMonthPayStr()));
                    }
                    catch (Exception e1) {
                        this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u5de5\u4f5c\u7ecf\u5386\u6708\u85aa\u83b7\u53d6\u5931\u8d25\uff0c\u6708\u85aa\uff1a" + workingExpInfo.getMonthPayStr()), (Throwable)e1);
                    }
                }
                if (i == 0) {
                    personWorkExp.put("isSingle", (Object)true);
                }
                try {
                    personWorkExp.setJobDesc(workingExpInfo.getJobDescription());
                    iPersonWorkExp.addnew((EmpInfoMultiPageInfo)personWorkExp);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u5de5\u4f5c\u7ecf\u5386\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + workingExpInfo.getJobDescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonDegree(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IEducationExpREC iEducationExpREC = EducationExpRECFactory.getLocalInstance(ctx);
        EducationExpRECCollection eduColl = iEducationExpREC.getEducationExpRECCollection("where resumeBase = '" + resume.getId().toString() + "' order by dateEnd desc");
        if (eduColl != null && eduColl.size() > 0) {
            IPersonDegree iPersonDegree = PersonDegreeFactory.getLocalInstance((Context)ctx);
            Map<String, Integer> tableMap = this.getField(new PersonDegreeInfo().getBOSType());
            PersonDegreeInfo personDegree = null;
            EducationExpRECInfo educationExp = null;
            boolean flag = false;
            for (int i = 0; i < eduColl.size(); ++i) {
                educationExp = eduColl.get(i);
                personDegree = new PersonDegreeInfo();
                personDegree.setPerson(person);
                personDegree.setEnrollDate(educationExp.getDateStart());
                personDegree.setGraduateDate(educationExp.getDateEnd());
                personDegree.setGraduateSchool(educationExp.getSchool());
                personDegree.setSpecialty(educationExp.getMajor());
                if (null != educationExp.getGraduateType()) {
                    personDegree.setGraduateType(educationExp.getGraduateType());
                }
                personDegree.setDiploma(educationExp.getDegreeF7());
                if (null != educationExp.getAcademicDiplomasF7()) {
                    personDegree.setDegree(educationExp.getAcademicDiplomasF7());
                }
                if (!StringUtils.isEmpty((CharSequence)educationExp.getMajorDescription())) {
                    if (educationExp.getMajorDescription().length() >= tableMap.get("FRemark")) {
                        personDegree.setRemark(educationExp.getMajorDescription().substring(0, tableMap.get("FRemark") - 1));
                    } else {
                        personDegree.setRemark(educationExp.getMajorDescription());
                    }
                }
                if (!flag) {
                    if (personDegree.getDiploma() != null) {
                        flag = true;
                        personDegree.setIsHighest(true);
                    }
                } else {
                    personDegree.setIsHighest(false);
                }
                if (personDegree.isIsHighest()) {
                    personDegree.put("isSingle", (Object)true);
                }
                if (!flag) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"\u6559\u80b2\u7ecf\u5386\u662f\u6700\u9ad8\u5b66\u5386\uff0c\u4f46\u662f\u5b66\u5386\u4e3a\u7a7a\uff0c\u5c31\u4e0d\u8fdb\u884c\u540c\u6b65");
                    continue;
                }
                iPersonDegree.addnew((EmpInfoMultiPageInfo)personDegree);
            }
        }
    }

    public void syncProjectExperience(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IProjectExp iProjectExp = ProjectExpFactory.getLocalInstance(ctx);
        ProjectExpCollection proColl = iProjectExp.getProjectExpCollection("where resumeBase = '" + resume.getId().toString() + "'   order by dateStart desc");
        if (proColl != null && proColl.size() > 0) {
            IProjectExperience iProjectExperience = ProjectExperienceFactory.getLocalInstance((Context)ctx);
            ProjectExperienceInfo projectExperience = null;
            for (int i = 0; i < proColl.size(); ++i) {
                projectExperience = new ProjectExperienceInfo();
                projectExperience.setPerson(person);
                projectExperience.setStartDate(proColl.get(i).getDateStart());
                projectExperience.setEndDate(proColl.get(i).getDateEnd());
                projectExperience.setName(proColl.get(i).getCustomer());
                try {
                    projectExperience.setPdescription(proColl.get(i).getPdescription());
                    projectExperience.setProfession(proColl.get(i).getIndustry());
                    projectExperience.setAssumeRole(proColl.get(i).getRole());
                    projectExperience.setMainResposibility(proColl.get(i).getMainDuty());
                    if (i == 0) {
                        projectExperience.put("isSingle", (Object)true);
                    }
                    iProjectExperience.addnew(projectExperience);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u9879\u76ee\u7ecf\u5386\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + proColl.get(i).getPdescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonLanguage(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        ILanguageAbility iLanguageAbility = LanguageAbilityFactory.getLocalInstance(ctx);
        LanguageAbilityCollection lanColl = iLanguageAbility.getLanguageAbilityCollection("where resumeBase = '" + resume.getId().toString() + "' order by createTime desc");
        if (lanColl != null && lanColl.size() > 0) {
            IPersonLanguage iPersonLanguage = PersonLanguageFactory.getLocalInstance((Context)ctx);
            PersonLanguageInfo personLanguage = null;
            for (int i = 0; i < lanColl.size(); ++i) {
                personLanguage = new PersonLanguageInfo();
                if (StringUtils.isEmpty((CharSequence)lanColl.get(i).getLanguage())) continue;
                personLanguage.setPerson(person);
                personLanguage.setLanguage(lanColl.get(i).getLanguage());
                personLanguage.setLevel(lanColl.get(i).getLv());
                if (i == 0) {
                    personLanguage.put("isSingle", (Object)true);
                }
                iPersonLanguage.addnew((EmpInfoMultiPageInfo)personLanguage);
            }
        }
    }

    public void syncPersonCertification(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IProfessionalSkills iProfessionalSkills = ProfessionalSkillsFactory.getLocalInstance(ctx);
        ProfessionalSkillsCollection skillColl = iProfessionalSkills.getProfessionalSkillsCollection("where resumeBase = '" + resume.getId().toString() + "' order by createTime desc");
        if (skillColl != null && skillColl.size() > 0) {
            IPersonCertification iPersonCertification = PersonCertificationFactory.getLocalInstance((Context)ctx);
            PersonCertificationInfo personCertification = null;
            for (int i = 0; i < skillColl.size(); ++i) {
                personCertification = new PersonCertificationInfo();
                personCertification.setPerson(person);
                try {
                    if (StringUtils.isEmpty((CharSequence)skillColl.get(i).getSkillName())) continue;
                    personCertification.setCertificateName(skillColl.get(i).getSkillName());
                    if (!StringUtils.isEmpty((CharSequence)skillColl.get(i).getSkillDescription())) {
                        personCertification.setRemark(skillColl.get(i).getSkillDescription());
                    }
                    if (i == 0) {
                        personCertification.put("isSingle", (Object)true);
                    }
                    iPersonCertification.addnew((EmpInfoMultiPageInfo)personCertification);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u6280\u80fd\u4fe1\u606f\uff0c\u63cf\u8ff0\u8fc7\u957f\uff1a" + skillColl.get(i).getSkillDescription()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonFamily(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IResumeFamily iResumeFamily = ResumeFamilyFactory.getLocalInstance(ctx);
        ResumeFamilyCollection resumeFamilyCol = iResumeFamily.getResumeFamilyCollection("where resumeBase = '" + resume.getId().toString() + "' order by createTime desc");
        if (resumeFamilyCol != null && resumeFamilyCol.size() > 0) {
            IPersonFamily iPersonFamily = PersonFamilyFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < resumeFamilyCol.size(); ++i) {
                try {
                    ResumeFamilyInfo resumeFamilyInfo = resumeFamilyCol.get(i);
                    PersonFamilyInfo personFamilyInfo = new PersonFamilyInfo();
                    personFamilyInfo.setPerson(person);
                    personFamilyInfo.setName(resumeFamilyInfo.getName());
                    personFamilyInfo.setBirthday(resumeFamilyInfo.getBirthday());
                    personFamilyInfo.setRelation(resumeFamilyInfo.getRelation());
                    personFamilyInfo.setWorkUnit(resumeFamilyInfo.getWorkUnit());
                    personFamilyInfo.setOfficePhone(resumeFamilyInfo.getOfficePhone());
                    personFamilyInfo.setRemark(resumeFamilyInfo.getDescription());
                    if (i == 0) {
                        personFamilyInfo.setIsSingle(true);
                    }
                    iPersonFamily.addnew((EmpInfoMultiPageInfo)personFamilyInfo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u793e\u4f1a\u5173\u7cfb\u5931\u8d25" + e.getMessage()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonCertifyCompetency(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IResumeCertifyCompetency iResumeCertifyCompetency = ResumeCertifyCompetencyFactory.getLocalInstance(ctx);
        ResumeCertifyCompetencyCollection resumeCertifyCompetencyCol = iResumeCertifyCompetency.getResumeCertifyCompetencyCollection("where resumeBase = '" + resume.getId().toString() + "' order by createTime desc");
        if (resumeCertifyCompetencyCol != null && resumeCertifyCompetencyCol.size() > 0) {
            IPersonCertifyCompetency iPersonCertifyCompetency = PersonCertifyCompetencyFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < resumeCertifyCompetencyCol.size(); ++i) {
                try {
                    ResumeCertifyCompetencyInfo resumeCertifyCompetencyInfo = resumeCertifyCompetencyCol.get(i);
                    PersonCertifyCompetencyInfo pcertifyCompetencyInfo = new PersonCertifyCompetencyInfo();
                    pcertifyCompetencyInfo.setPerson(person);
                    pcertifyCompetencyInfo.setCertifiedCompetency(resumeCertifyCompetencyInfo.getCertifiedCompetency());
                    pcertifyCompetencyInfo.setObtainDate(resumeCertifyCompetencyInfo.getObtainDate());
                    pcertifyCompetencyInfo.setFromUnit(resumeCertifyCompetencyInfo.getFromUnit());
                    pcertifyCompetencyInfo.setCertificateNumber(resumeCertifyCompetencyInfo.getCertificateNumber());
                    pcertifyCompetencyInfo.setAppointUnit(resumeCertifyCompetencyInfo.getAppointUnit());
                    pcertifyCompetencyInfo.setAppointDate(resumeCertifyCompetencyInfo.getAppointDate());
                    pcertifyCompetencyInfo.setIsHighest(resumeCertifyCompetencyInfo.isIsHighest());
                    pcertifyCompetencyInfo.setIsHighestCompetency(resumeCertifyCompetencyInfo.isIsHighestCompetency());
                    pcertifyCompetencyInfo.setDescription(resumeCertifyCompetencyInfo.getDescription());
                    if (i == 0) {
                        pcertifyCompetencyInfo.setIsSingle(true);
                    }
                    iPersonCertifyCompetency.addnew((EmpInfoMultiPageInfo)pcertifyCompetencyInfo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u804c\uff08\u6267\uff09\u4e1a\u8d44\u683c\u5931\u8d25" + e.getMessage()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void syncPersonTechnicalPost(PersonInfo person, ResumeBaseRecInfo resume, Context ctx) throws BOSException, EASBizException {
        IResumeTechnicalPost iResumeTechnicalPost = ResumeTechnicalPostFactory.getLocalInstance(ctx);
        ResumeTechnicalPostCollection resumeTechnicalPostCol = iResumeTechnicalPost.getResumeTechnicalPostCollection("where resumeBase = '" + resume.getId().toString() + "' order by createTime desc");
        if (resumeTechnicalPostCol != null && resumeTechnicalPostCol.size() > 0) {
            IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < resumeTechnicalPostCol.size(); ++i) {
                try {
                    ResumeTechnicalPostInfo resumeTechnicalPostInfo = resumeTechnicalPostCol.get(i);
                    PersonTechnicalPostInfo personTechnicalPostInfo = new PersonTechnicalPostInfo();
                    personTechnicalPostInfo.setPerson(person);
                    personTechnicalPostInfo.setTechnicalPost(resumeTechnicalPostInfo.getTechnicalPost());
                    personTechnicalPostInfo.setConferDate(resumeTechnicalPostInfo.getConferDate());
                    personTechnicalPostInfo.setCertificateNo(resumeTechnicalPostInfo.getCertificateNo());
                    personTechnicalPostInfo.setTechnicalCont(resumeTechnicalPostInfo.getTechnicalCont());
                    personTechnicalPostInfo.setIsHighTechnical(resumeTechnicalPostInfo.isIsHighTechnical());
                    personTechnicalPostInfo.setGradeUnit(resumeTechnicalPostInfo.getGradeUnit());
                    personTechnicalPostInfo.setIsEmploy(resumeTechnicalPostInfo.isIsEmploy());
                    personTechnicalPostInfo.setDescription(resumeTechnicalPostInfo.getDescription());
                    if (i == 0) {
                        personTechnicalPostInfo.setIsSingle(true);
                    }
                    iPersonTechnicalPost.addnew((EmpInfoMultiPageInfo)personTechnicalPostInfo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("**********\u5165\u804c\u540c\u6b65\u5230\u5458\u5de5\u4fe1\u606f\uff0c\u804c\u79f0\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Map<String, Integer> getField(BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        DataTableInfo dataTableInfo = objectInfo.getTable();
        ColumnCollection columnCollection = dataTableInfo.getColumns();
        ColumnInfo columnInfo = null;
        for (int j = 0; j < columnCollection.size(); ++j) {
            columnInfo = columnCollection.get(j);
            result.put(columnInfo.getName(), columnInfo.getLength());
        }
        return result;
    }

    private PersonInfo getPersonInfo(Context ctx, String IdentityCardNo, String PassportNo) {
        IPerson iPerson = null;
        PersonInfo person = null;
        try {
            iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection personColl = null;
            String id = IdentityCardNo;
            if (RecDBUtils.isEmpty(id)) {
                id = PassportNo;
                if (!RecDBUtils.isEmpty(id)) {
                    personColl = iPerson.getPersonCollection("where passportNO = '" + id + "' ");
                }
            } else {
                personColl = iPerson.getPersonCollection("where idCardNO = '" + id + "' ");
            }
            if (personColl == null || personColl.size() <= 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"\u3010************\u6ca1\u6709\u67e5\u5230\u5458\u5de5\u4fe1\u606f**************\u3011");
                }
                return null;
            }
            person = personColl.get(0);
        }
        catch (BOSException e) {
            this.logger.error((Object)"\u3010*****************\u628a\u7b80\u5386\u4fe1\u606f\u540c\u6b65\u81f3\u5458\u5de5\u4fe1\u606f\u5931\u8d25**************\u3011");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return person;
    }
}

