/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.integraterec.IInvokeColumnValue;
import com.kingdee.shr.integraterec.InvokeColumnValueCollection;
import com.kingdee.shr.integraterec.InvokeColumnValueFactory;
import com.kingdee.shr.integraterec.InvokeColumnValueInfo;
import com.kingdee.shr.recuritment.AbstractEducationExpRECInfo;
import com.kingdee.shr.recuritment.AbstractWorkingExpInfo;
import com.kingdee.shr.recuritment.CredentialCollection;
import com.kingdee.shr.recuritment.CredentialInfo;
import com.kingdee.shr.recuritment.EducationExpRECCollection;
import com.kingdee.shr.recuritment.EducationExpRECInfo;
import com.kingdee.shr.recuritment.IRecSetting;
import com.kingdee.shr.recuritment.IRecuritmentDemand;
import com.kingdee.shr.recuritment.ITupuDictionary;
import com.kingdee.shr.recuritment.ITupuResumeLog;
import com.kingdee.shr.recuritment.ITupuResumeTask;
import com.kingdee.shr.recuritment.IntegrateSystem;
import com.kingdee.shr.recuritment.IsOrNotEnum;
import com.kingdee.shr.recuritment.LanguageAbilityCollection;
import com.kingdee.shr.recuritment.LanguageAbilityInfo;
import com.kingdee.shr.recuritment.ProfessionalSkillsCollection;
import com.kingdee.shr.recuritment.ProfessionalSkillsInfo;
import com.kingdee.shr.recuritment.ProjectExpCollection;
import com.kingdee.shr.recuritment.ProjectExpInfo;
import com.kingdee.shr.recuritment.RecSettingCollection;
import com.kingdee.shr.recuritment.RecSettingFactory;
import com.kingdee.shr.recuritment.RecSettingInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.ResultStateEnum;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeOtherDescInfo;
import com.kingdee.shr.recuritment.ResumeSourceMethod;
import com.kingdee.shr.recuritment.ResumeSourceType;
import com.kingdee.shr.recuritment.ResumeTaskState;
import com.kingdee.shr.recuritment.ResumeTaskType;
import com.kingdee.shr.recuritment.SaveResumeFacadeFactory;
import com.kingdee.shr.recuritment.SelfEvaluationRecInfo;
import com.kingdee.shr.recuritment.SexEnum;
import com.kingdee.shr.recuritment.TrainingExpCollection;
import com.kingdee.shr.recuritment.TrainingExpInfo;
import com.kingdee.shr.recuritment.TupuDictionaryCollection;
import com.kingdee.shr.recuritment.TupuDictionaryFactory;
import com.kingdee.shr.recuritment.TupuDictionaryInfo;
import com.kingdee.shr.recuritment.TupuResumeLogFactory;
import com.kingdee.shr.recuritment.TupuResumeLogInfo;
import com.kingdee.shr.recuritment.TupuResumeTaskFactory;
import com.kingdee.shr.recuritment.TupuResumeTaskInfo;
import com.kingdee.shr.recuritment.WorkingExpCollection;
import com.kingdee.shr.recuritment.WorkingExpInfo;
import com.kingdee.shr.recuritment.WorksDemonstrationCollection;
import com.kingdee.shr.recuritment.WorksDemonstrationInfo;
import com.kingdee.shr.recuritment.YesOrNoEnum;
import com.kingdee.shr.recuritment.app.bo.ExcellentWorks;
import com.kingdee.shr.recuritment.app.bo.TrainExperience;
import com.kingdee.shr.recuritment.app.bo.tupu.Candidate;
import com.kingdee.shr.recuritment.app.bo.tupu.EduExps;
import com.kingdee.shr.recuritment.app.bo.tupu.JobObjective;
import com.kingdee.shr.recuritment.app.bo.tupu.ProjectExps;
import com.kingdee.shr.recuritment.app.bo.tupu.Resume;
import com.kingdee.shr.recuritment.app.bo.tupu.WorkExps;
import com.kingdee.shr.recuritment.app.service.ResumeOperRecordService;
import com.kingdee.shr.recuritment.app.util.FileUtil;
import com.kingdee.shr.recuritment.app.util.IDCardUtil;
import com.kingdee.shr.recuritment.app.util.convert.DateConvertUtil;
import com.kingdee.shr.recuritment.app.util.convert.EnumConvertUtil;
import com.kingdee.shr.recuritment.app.util.convert.F7ConvertUtil;
import com.kingdee.shr.recuritment.app.util.convert.ResumeConvertUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecCheckUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TupuResumePuller {
    private static Logger logger = LoggerFactory.getLogger(TupuResumePuller.class);
    private static final String RS_PERMITEM = "3268dec9-f7f8-4719-ba40-da2ff228fe48PERMITEM";
    private static final String CURRENT_WORKING_STATUS_POINT = "HBYD+1RNQcqTEEmD/gie7lONlss=";
    private static final String ADMINISTRATOR_USEID = "00000000-0000-0000-0000-00000000000013B7DE7F";

    private TupuResumePuller() {
    }

    public static TupuResumePuller getInstance() {
        return TupuResumePullerHolder.tupuResumePuller;
    }

    public void execute(Context ctx) throws BOSException {
        this.execute(ctx, null, null);
    }

    public void execute(Context ctx, String beginDate, String endDate) throws BOSException {
        boolean isUpdate = true;
        boolean invokeFlag = true;
        RecSettingInfo startDateInfo = null;
        HashMap param = Maps.newHashMap();
        String billIds = String.valueOf(System.currentTimeMillis());
        param.put("billIds", billIds);
        param.put("triggerKey", "getApplicationIds");
        param.put("integrateType", 2);
        JSONObject pathParam = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)beginDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
            isUpdate = false;
            pathParam.put("beginDate", (Object)beginDate);
            pathParam.put("endDate", (Object)endDate);
        } else {
            startDateInfo = this.setRequest(ctx, pathParam);
        }
        ITupuResumeTask iTupuResumeTask = TupuResumeTaskFactory.getLocalInstance(ctx);
        TupuResumeTaskInfo tupuResumeTaskInfo = new TupuResumeTaskInfo();
        this.initTask(ctx, isUpdate, tupuResumeTaskInfo);
        Integer myCounter = 0;
        param.put("pathParam", pathParam.toString());
        try {
            Object response = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", (Map)param);
            if (null != response) {
                JSONObject resultJson = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)response), JSONObject.class);
                logger.info("tupu\u65b0\u589e\u5019\u9009\u4eba\u63a5\u53e3\u8fd4\u56de\uff1a" + resultJson);
                int osfState = resultJson.getIntValue("state");
                if (osfState == 1) {
                    JSONObject integrateRec = resultJson.getJSONObject("integrateRes");
                    JSONArray jsonArray = integrateRec.getJSONArray(billIds);
                    JSONObject integrateResponse = jsonArray.getJSONObject(0);
                    int state = integrateResponse.getInteger("state");
                    if (state == 1) {
                        String data = integrateResponse.getString("data");
                        JSONObject tupuResponse = JSON.parseObject((String)JSONObject.parse((String)data).toString());
                        String code = tupuResponse.getString("code");
                        if (StringUtils.equals((CharSequence)code, (CharSequence)"100")) {
                            String tupuData = tupuResponse.getString("data");
                            List dataList = JSON.parseArray((String)tupuData, String.class);
                            tupuResumeTaskInfo.setTotalNum(dataList.size());
                            iTupuResumeTask.addnew(tupuResumeTaskInfo);
                            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                                for (String dataId : dataList) {
                                    this.getCandidateInfo(ctx, dataId, tupuResumeTaskInfo, myCounter);
                                }
                            }
                            if (isUpdate) {
                                IRecSetting iRecSetting = RecSettingFactory.getLocalInstance(ctx);
                                iRecSetting.save((CoreBaseInfo)startDateInfo);
                            }
                            tupuResumeTaskInfo.setState(ResumeTaskState.FINISHED);
                            tupuResumeTaskInfo.setMyNum(myCounter);
                            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                            selectorItemCollection.add("state");
                            selectorItemCollection.add("myNum");
                            iTupuResumeTask.updatePartial(tupuResumeTaskInfo, selectorItemCollection);
                        }
                    } else {
                        invokeFlag = false;
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        if (!invokeFlag) {
            throw new BOSException("\u56fe\u8c31\u63a5\u53e3\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff01");
        }
    }

    private void initTask(Context ctx, boolean isUpdate, TupuResumeTaskInfo tupuResumeTaskInfo) {
        tupuResumeTaskInfo.setState(ResumeTaskState.RUNNING);
        tupuResumeTaskInfo.setIntegrateSystem(IntegrateSystem.TUPU);
        tupuResumeTaskInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        tupuResumeTaskInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (isUpdate) {
            tupuResumeTaskInfo.setType(ResumeTaskType.AUTOMATIC);
        } else {
            tupuResumeTaskInfo.setType(ResumeTaskType.MANUALLY);
        }
    }

    private RecSettingInfo setRequest(Context ctx, JSONObject pathParam) throws BOSException {
        IRecSetting iRecSetting = RecSettingFactory.getLocalInstance(ctx);
        RecSettingCollection recSettingCollection = iRecSetting.getRecSettingCollection("where type ='tupu'");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = null;
        String endDate = null;
        RecSettingInfo startDateInfo = new RecSettingInfo();
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, -5);
        Date fiveDaysAgo = calendar.getTime();
        if (null != recSettingCollection && recSettingCollection.size() > 0) {
            Iterator iterator = recSettingCollection.iterator();
            while (iterator.hasNext()) {
                RecSettingInfo next = (RecSettingInfo)iterator.next();
                if (StringUtils.equals((CharSequence)next.getKey(), (CharSequence)"beginDate")) {
                    startDateInfo = next;
                    beginDate = next.getValue();
                }
                if (!StringUtils.equals((CharSequence)next.getKey(), (CharSequence)"endDate")) continue;
                endDate = next.getValue();
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)endDate) && sdf.parse(beginDate).after(sdf.parse(endDate))) {
                    endDate = null;
                }
                if (StringUtils.isEmpty((CharSequence)endDate)) {
                    endDate = sdf.format(currentDate);
                }
                Date tempDate = sdf.parse(endDate);
                calendar.setTime(sdf.parse(beginDate));
                calendar.add(5, 5);
                Date fiveDaysAfter = calendar.getTime();
                if (fiveDaysAfter.before(tempDate)) {
                    logger.info("\u65e5\u671f\u8de8\u5ea6\u8d85\u8fc75\u5929");
                    endDate = sdf.format(fiveDaysAfter);
                }
                startDateInfo.setValue(sdf.format(currentDate));
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            endDate = sdf.format(currentDate);
            beginDate = sdf.format(fiveDaysAgo);
            startDateInfo.setType("tupu");
            startDateInfo.setKey("beginDate");
            startDateInfo.setValue(endDate);
        }
        pathParam.put("beginDate", (Object)beginDate);
        pathParam.put("endDate", (Object)endDate);
        return startDateInfo;
    }

    private void getCandidateInfo(Context ctx, String dataId, TupuResumeTaskInfo taskInfo, Integer myCounter) {
        try {
            String data;
            JSONObject tupuResponse;
            String code;
            JSONObject integrateRec;
            JSONArray jsonArray;
            JSONObject integrateResponse;
            int state;
            JSONObject resultJson;
            int osfState;
            ITupuResumeLog iTupuResumeLog = TupuResumeLogFactory.getLocalInstance(ctx);
            if (iTupuResumeLog.exists("where applicationId ='" + dataId + "' and state = 0")) {
                logger.info("\u5019\u9009\u4eba\u7533\u8bf7\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u7533\u8bf7ID\uff1a" + dataId + ",\u4e0d\u518d\u91cd\u590d\u62c9\u53d6\uff01");
                return;
            }
            HashMap param = Maps.newHashMap();
            String billIds = String.valueOf(System.currentTimeMillis());
            param.put("billIds", billIds);
            param.put("triggerKey", "getApplicationById");
            param.put("integrateType", 2);
            JSONObject pathParam = new JSONObject();
            pathParam.put("applicationId", (Object)dataId);
            param.put("pathParam", pathParam.toString());
            Object response = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", (Map)param);
            if (null != response && (osfState = (resultJson = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)response), JSONObject.class)).getIntValue("state")) == 1 && (state = (integrateResponse = (jsonArray = (integrateRec = resultJson.getJSONObject("integrateRes")).getJSONArray(billIds)).getJSONObject(0)).getInteger("state").intValue()) == 1 && StringUtils.equals((CharSequence)(code = (tupuResponse = JSON.parseObject((String)JSONObject.parse((String)(data = integrateResponse.getString("data"))).toString())).getString("code")), (CharSequence)"100")) {
                String tupuData = tupuResponse.getString("data");
                JSONObject jsonData = JSON.parseObject((String)tupuData);
                String positionId = jsonData.getString("positionId");
                String candidateExternalId = jsonData.getString("candidateExternalId");
                IRecuritmentDemand iRecuritmentDemand = RecuritmentDemandFactory.getLocalInstance(ctx);
                RecuritmentDemandCollection recuritmentDemandCollection = iRecuritmentDemand.getRecuritmentDemandCollection("where demandTpRelated.tupuJobId ='" + positionId + "' and billState =3");
                TupuResumeLogInfo tupuResumeLogInfo = new TupuResumeLogInfo();
                tupuResumeLogInfo.setApplicationId(dataId);
                tupuResumeLogInfo.setCandidateId(candidateExternalId);
                tupuResumeLogInfo.setState(ResultStateEnum.success);
                tupuResumeLogInfo.setTask(taskInfo);
                if (null != recuritmentDemandCollection && recuritmentDemandCollection.size() > 0 && taskInfo.getType() == ResumeTaskType.MANUALLY) {
                    if (this.checkPermission(ctx, recuritmentDemandCollection.get(0).getDepartment().getId().toString(), recuritmentDemandCollection.get(0).getHrOrgUnit().getId().toString())) {
                        tupuResumeLogInfo.setHasPerm(YesOrNoEnum.YES);
                        Integer n = myCounter;
                        Integer n2 = myCounter = Integer.valueOf(myCounter + 1);
                    } else {
                        tupuResumeLogInfo.setHasPerm(YesOrNoEnum.NO);
                    }
                }
                if (null != recuritmentDemandCollection && recuritmentDemandCollection.size() > 0) {
                    try {
                        this.getCandidateDetail(ctx, candidateExternalId, recuritmentDemandCollection.get(0), tupuResumeLogInfo);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        tupuResumeLogInfo.setErrorMsg("\u8bf7\u5728\u201c\u7b80\u5386\u7b5b\u9009\u201d\u83dc\u5355\u7b80\u5386\u7b5b\u9009\u201d\u83dc\u5355\u4e2d\u641c\u7d22\u8be5\u5019\u9009\u4eba\u662f\u5426\u5df2\u8fdb\u5165HR\u7cfb\u7edf\u3002\u5982\u679c\u5df2\u8fdb\u5165\uff0c\u8bf7\u5ffd\u7565\u5931\u8d25\u4fe1\u606f\uff1b\u5982\u679c\u672a\u8fdb\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
                        tupuResumeLogInfo.setState(ResultStateEnum.fail);
                    }
                } else {
                    tupuResumeLogInfo.setErrorMsg("\u5019\u9009\u4eba\u6295\u9012\u7684\u804c\u4f4d\u5df2\u88ab\u53cd\u5ba1\u6279\uff0c\u804c\u4f4dID\uff1a" + positionId);
                    tupuResumeLogInfo.setState(ResultStateEnum.fail);
                    logger.info("positionId\uff1a" + positionId + "\u7684\u9700\u6c42\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u6ee1\u8db3\u751f\u6210\u540e\u53f0\u7b80\u5386\u7684\u6761\u4ef6\uff01");
                }
                iTupuResumeLog.addnew(tupuResumeLogInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5019\u9009\u4eba\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c\u5019\u9009\u4eba\u7533\u8bf7ID\uff1a" + dataId);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void getCandidateDetail(Context ctx, String candidateExternalId, RecuritmentDemandInfo demandInfo, TupuResumeLogInfo tupuResumeLogInfo) throws EASBizException, BOSException {
        String data;
        JSONObject tupuResponse;
        String code;
        JSONObject integrateRec;
        JSONArray jsonArray;
        JSONObject integrateResponse;
        int state;
        JSONObject resultJson;
        int osfState;
        HashMap param = Maps.newHashMap();
        String billIds = String.valueOf(System.currentTimeMillis());
        param.put("billIds", billIds);
        param.put("triggerKey", "getCandidateByExid");
        param.put("integrateType", 2);
        JSONObject pathParam = new JSONObject();
        pathParam.put("candidateExternalId", (Object)candidateExternalId);
        param.put("pathParam", pathParam.toString());
        Object response = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", (Map)param);
        if (null != response && (osfState = (resultJson = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)response), JSONObject.class)).getIntValue("state")) == 1 && (state = (integrateResponse = (jsonArray = (integrateRec = resultJson.getJSONObject("integrateRes")).getJSONArray(billIds)).getJSONObject(0)).getInteger("state").intValue()) == 1 && StringUtils.equals((CharSequence)(code = (tupuResponse = JSON.parseObject((String)JSONObject.parse((String)(data = integrateResponse.getString("data"))).toString())).getString("code")), (CharSequence)"100")) {
            String tupuData = tupuResponse.getString("data");
            Candidate candidate = (Candidate)JSON.parseObject((String)tupuData, Candidate.class);
            ResumeBaseRecInfo resumeInfo = new ResumeBaseRecInfo();
            resumeInfo.setOuterId(candidate.getCandidateExternalId());
            resumeInfo.setPrivateResume(YesOrNoEnum.NO);
            resumeInfo.setSourceMethod(ResumeSourceMethod.INTEGRATESYSTEM);
            resumeInfo.setSourceType(ResumeSourceType.UNSOLICITEDDELIVERY);
            this.setSource(ctx, candidate.getSource(), resumeInfo);
            this.bindDemand(resumeInfo, demandInfo);
            this.convertCandidateToResume(ctx, candidate.getResume(), resumeInfo);
            SaveResumeFacadeFactory.getLocalInstance(ctx).saveResume(resumeInfo);
            tupuResumeLogInfo.setJsonData(data);
            tupuResumeLogInfo.setResumeBaseRec(resumeInfo);
            ResumeOperRecordService.getInstance().addResumeOperRecord(ctx, "\u56fe\u8c31\u63a8\u9001", "\u65b0\u589e\u7b80\u5386", resumeInfo);
            try {
                this.getMultiAttachment(ctx, candidate, resumeInfo);
            }
            catch (Exception e) {
                logger.error("\u5019\u9009\u4eba\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
        }
    }

    private void getMultiAttachment(Context ctx, Candidate candidate, ResumeBaseRecInfo resumeInfo) {
        List<com.kingdee.shr.recuritment.app.bo.tupu.AttachmentInfo> multiResumeFiles = candidate.getMultiResumeFileInfos();
        if (CollectionUtils.isEmpty(multiResumeFiles)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u7b80\u5386\u9644\u4ef6\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        HashMap param = Maps.newHashMap();
        param.put("triggerKey", "getAttach");
        param.put("integrateType", 2);
        for (com.kingdee.shr.recuritment.app.bo.tupu.AttachmentInfo resumeFile : multiResumeFiles) {
            String data;
            JSONObject tupuResponse;
            String code;
            JSONObject integrateRec;
            JSONArray jsonArray;
            JSONObject integrateResponse;
            int state;
            JSONObject resultJson;
            int osfState;
            String billIds = String.valueOf(System.currentTimeMillis());
            param.put("billIds", billIds);
            JSONObject requestBodyParam = new JSONObject();
            requestBodyParam.put("candidateExternalId", (Object)candidate.getCandidateExternalId());
            requestBodyParam.put("attachmentId", (Object)resumeFile.getAttachmentId());
            param.put("requestBodyParam", requestBodyParam.toString());
            Object response = null;
            try {
                response = OSFAppUtil.callService((Context)ctx, (String)"PushIntegrateRecService", (Map)param);
            }
            catch (Exception e) {
                logger.error("\u5019\u9009\u4eba\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5019\u9009\u4eba\u7533\u8bf7ID\uff1a" + candidate.getCandidateId());
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (null == response || (osfState = (resultJson = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)response), JSONObject.class)).getIntValue("state")) != 1 || (state = (integrateResponse = (jsonArray = (integrateRec = resultJson.getJSONObject("integrateRes")).getJSONArray(billIds)).getJSONObject(0)).getInteger("state").intValue()) != 1 || !StringUtils.equals((CharSequence)(code = (tupuResponse = JSON.parseObject((String)JSONObject.parse((String)(data = integrateResponse.getString("data"))).toString())).getString("code")), (CharSequence)"100")) continue;
            String base64Content = tupuResponse.getString("binaryContent");
            resumeFile.setBase64Content(base64Content);
        }
        this.saveAttachment(ctx, resumeInfo.getId().toString(), multiResumeFiles);
    }

    private void saveAttachment(Context ctx, String resumeId, List<com.kingdee.shr.recuritment.app.bo.tupu.AttachmentInfo> multiFiles) {
        try {
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection attachCollection = new CoreBaseCollection();
            for (com.kingdee.shr.recuritment.app.bo.tupu.AttachmentInfo attachFile : multiFiles) {
                AttachmentInfo attachmentInfo = new AttachmentInfo();
                attachmentInfo.setFile(FileUtil.getFileFromBase64(attachFile.getBase64Content()));
                String fileName = attachFile.getFilename();
                if (fileName.lastIndexOf(".") != -1) {
                    attachmentInfo.setName(fileName.substring(0, fileName.lastIndexOf(".")));
                } else {
                    attachmentInfo.setName(fileName);
                }
                attachmentInfo.setSimpleName(attachFile.getMimeType());
                attachmentInfo.setType(attachFile.getMimeType());
                attachmentInfo.setSize(String.valueOf(attachFile.getLength()));
                attachmentInfo.setSizeInByte(attachFile.getLength());
                attachmentInfo.setAttachID("" + System.currentTimeMillis());
                attachCollection.add((CoreBaseInfo)attachmentInfo);
            }
            iAttachment.save(attachCollection);
            if (attachCollection.size() > 0) {
                CoreBaseCollection attachExtCollection = new CoreBaseCollection();
                for (int i = 0; i < attachCollection.size(); ++i) {
                    SHRAttachmentExtInfo attchExtInfo = new SHRAttachmentExtInfo();
                    AttachmentInfo attachmentInfo = (AttachmentInfo)attachCollection.get(i);
                    attchExtInfo.setAttachment(attachmentInfo);
                    attchExtInfo.setName(attachmentInfo.getName());
                    attchExtInfo.setPropertyName("null0");
                    attchExtInfo.setType(AttachmentTypeEnum.FORM);
                    attchExtInfo.setState(AttachmentState.SAVE);
                    attchExtInfo.setBoID(resumeId);
                    attachExtCollection.add((CoreBaseInfo)attchExtInfo);
                }
                ISHRAttachmentExt ishrAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
                ishrAttachmentExt.save(attachExtCollection);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void bindDemand(ResumeBaseRecInfo resumeInfo, RecuritmentDemandInfo demandInfo) {
        resumeInfo.setRecuritmentDemand(demandInfo);
        resumeInfo.setDepartment(demandInfo.getDepartment());
        resumeInfo.setRecuritPosition(demandInfo.getRecuritPosition());
        resumeInfo.setJob(demandInfo.getJob());
        resumeInfo.setHrJob(demandInfo.getHrJob());
    }

    private void setSource(Context ctx, String source, ResumeBaseRecInfo resumeInfo) throws BOSException {
        if (!StringUtils.isEmpty((CharSequence)source)) {
            ITupuDictionary iTupuDictionary = TupuDictionaryFactory.getLocalInstance(ctx);
            TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'source' and tpName ='" + source + "'");
            if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                source = tupuDictionaryInfo.getName();
            } else if (StringUtils.equals((CharSequence)source, (CharSequence)"zhaopin.com") || StringUtils.equals((CharSequence)source, (CharSequence)"\u667a\u8054")) {
                source = "ZhiLian";
            } else if (StringUtils.equals((CharSequence)source, (CharSequence)"51Job")) {
                source = "Job51";
            } else if (StringUtils.equals((CharSequence)source, (CharSequence)"\u730e\u8058\u7f51")) {
                source = "LiePin";
            } else if (StringUtils.equals((CharSequence)source, (CharSequence)"Boss\u76f4\u8058")) {
                source = "Boss";
            }
            resumeInfo.setResSource(ResumeConvertUtil.getResumeFrom(ctx, source));
        }
    }

    private void convertCandidateToResume(Context ctx, Resume tpResume, ResumeBaseRecInfo resumeInfo) throws BOSException {
        this.convertResumeBaseInformation(ctx, tpResume, resumeInfo);
        this.convertResumeCareerInformation(ctx, tpResume.getJobObjective(), resumeInfo);
        this.convertResumeWorkingExpInformation(ctx, tpResume.getWorkExps(), resumeInfo);
        this.convertResumeEduExp(ctx, tpResume.getEduExps(), resumeInfo);
        this.convertResumeLanguage(ctx, tpResume.getLangAbility(), resumeInfo);
        this.convertResumeProjectExp(ctx, tpResume.getProjectExps(), resumeInfo);
        this.convertResumeCredential(ctx, tpResume.getCertificate(), resumeInfo);
        this.convertResumeProfessionalSkills(ctx, tpResume.getProSkill(), resumeInfo);
        this.convertResumeOtherDesc(ctx, tpResume.getAwards(), resumeInfo);
    }

    private void convertResumeBaseInformation(Context ctx, Resume tpResume, ResumeBaseRecInfo resume) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)tpResume.getName())) {
            throw new BOSException("*********************************\u7b80\u5386\u59d3\u540d\u4e3a\u7a7a*******************************");
        }
        ITupuDictionary iTupuDictionary = TupuDictionaryFactory.getLocalInstance(ctx);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        resume.setName(tpResume.getName());
        if (!StringUtils.isEmpty((CharSequence)tpResume.getPersonalId())) {
            resume.setIdentityCardNo(tpResume.getPersonalId());
            try {
                resume.setBirthday(sdf.parse(new IDCardUtil(tpResume.getPersonalId()).getBirthday()));
                Genders gender = new IDCardUtil(tpResume.getPersonalId()).getGenders();
                resume.setGender(gender);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (resume.getBirthday() == null && !StringUtils.isEmpty((CharSequence)tpResume.getBirthday())) {
            try {
                Date birthDay = DateConvertUtil.convertStrToDate(tpResume.getBirthday());
                resume.setBirthday(birthDay);
            }
            catch (Exception e) {
                logger.error("****************\u751f\u65e5\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage() + "********************", (Throwable)e);
            }
        }
        if (resume.getBirthday() != null) {
            try {
                int age = ResumeConvertUtil.getAgeByBirthday(resume.getBirthday());
                resume.setAge(age);
                resume.setCurrAge(age);
            }
            catch (Exception e) {
                logger.error("****************\u901a\u8fc7\u751f\u65e5\u83b7\u53d6\u5e74\u9f84\u9519\u8bef\uff1a" + e.getMessage() + "********************", (Throwable)e);
            }
        }
        if (resume.getAge() > 0 && resume.getAge() < 16 && RecCheckUtil.check16YearOld(ctx) == 1) {
            throw new BOSException("\u672a\u6ee116\u5468\u5c81\uff0c\u7981\u6b62\u6295\u9012\u7b80\u5386");
        }
        if (resume.getGender() == null && !StringUtils.isEmpty((CharSequence)tpResume.getGender())) {
            if (Genders.Female.getAlias().equals(tpResume.getGender())) {
                resume.setGender(Genders.Female);
            } else if (Genders.Male.getAlias().equals(tpResume.getGender())) {
                resume.setGender(Genders.Male);
            }
        }
        if (resume.getGender() != null && resume.getGender().getValue() >= 1) {
            resume.setSex(SexEnum.getEnum(resume.getGender().getValue() - 1));
        }
        String degree = tpResume.getDegree();
        if (!StringUtils.isEmpty((CharSequence)tpResume.getDegree())) {
            TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'degree' and tpName ='" + degree + "'");
            if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                degree = tupuDictionaryInfo.getName();
            }
            DiplomaInfo dip = F7ConvertUtil.getDiplomaInfo(ctx, degree);
            resume.setHDegree(dip);
        }
        resume.setWarehouseEntry(new Date());
        int workYears = tpResume.getWorkYears();
        resume.setWorkSeniority(workYears + "");
        String nation = tpResume.getNation();
        if (!StringUtils.isEmpty((CharSequence)nation)) {
            TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'nation' and tpName ='" + nation + "'");
            if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                nation = tupuDictionaryInfo.getName();
            }
            resume.setNational(F7ConvertUtil.getNationalityInfo(ctx, nation));
        }
        resume.setMobilePhone(tpResume.getMobile());
        resume.setEmail(tpResume.getEmail());
        resume.setNowResidence(tpResume.getCurrentCity());
        resume.setDomicilePlace(tpResume.getAddress());
        resume.setIsBlackList(IsOrNotEnum.NO);
        resume.setSchool(tpResume.getGraduateSchool());
        resume.setLastCompany(tpResume.getCurrentCompany());
        resume.setLastJob(tpResume.getCurrentPosition());
        resume.setLastIndustry(tpResume.getCurrentIndustry());
        this.convertResumeSelfIntroduceInformation(ctx, tpResume.getSelfComm(), resume);
    }

    private void convertResumeSelfIntroduceInformation(Context ctx, String introduce, ResumeBaseRecInfo resume) {
        if (StringUtils.isEmpty((CharSequence)introduce)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u81ea\u6211\u63cf\u8ff0\u4fe1\u606f\u4e3a\u7a7a***************");
            }
            return;
        }
        SelfEvaluationRecInfo selfEva = new SelfEvaluationRecInfo();
        selfEva.setResumeBaseRec(resume);
        selfEva.setSelfDescription(introduce);
        resume.put("selfIntroduce", selfEva);
    }

    private void convertResumeCareerInformation(Context ctx, JobObjective jobObjective, ResumeBaseRecInfo resume) throws BOSException {
        if (jobObjective == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u6c42\u804c\u610f\u5411\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        ITupuDictionary iTupuDictionary = TupuDictionaryFactory.getLocalInstance(ctx);
        IInvokeColumnValue iInvokeColumnValue = InvokeColumnValueFactory.getLocalInstance((Context)ctx);
        String contractTerm = jobObjective.getContractTerm();
        if (!StringUtils.isEmpty((CharSequence)jobObjective.getContractTerm())) {
            TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'contractTerm' and tpName ='" + contractTerm + "'");
            if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                contractTerm = tupuDictionaryInfo.getName();
            }
            resume.setJobNature(EnumConvertUtil.getJobNature(contractTerm));
        } else if (logger.isDebugEnabled()) {
            logger.debug("**********************************\u6ca1\u6709\u89e3\u6790\u5230\u6c42\u804c\u6027\u8d28****************************");
        }
        String state = jobObjective.getState();
        if (!StringUtils.isEmpty((CharSequence)state)) {
            TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'state' and tpName ='" + state + "'");
            if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                state = tupuDictionaryInfo.getName();
            } else {
                InvokeColumnValueInfo invokeColumnValueInfo;
                String sourceValue;
                InvokeColumnValueCollection invokeColumnValueCollection = iInvokeColumnValue.getInvokeColumnValueCollection("where invokeColumn ='HBYD+1RNQcqTEEmD/gie7lONlss=' and targetValue='" + state + "'");
                state = null != invokeColumnValueCollection && invokeColumnValueCollection.size() > 0 ? ((sourceValue = (invokeColumnValueInfo = invokeColumnValueCollection.get(0)).getSourceValue()).contains("\u5728\u804c") || sourceValue.contains("\u5728\u5c97") ? "\u5728\u804c" : "\u79bb\u804c") : (state.contains("\u5728\u804c") || state.contains("\u5728\u5c97") ? "\u5728\u804c" : "\u79bb\u804c");
            }
            resume.setCurrentWorkingStatus(EnumConvertUtil.getCurrentWorkingStatus(state));
        } else if (logger.isDebugEnabled()) {
            logger.debug("*************************\u6ca1\u6709\u63a5\u6536\u5230\u76ee\u524d\u5de5\u4f5c\u72b6\u6001");
        }
        resume.setTargetPlace(jobObjective.getCity());
        resume.setExpectantPayStr(jobObjective.getSalary());
        resume.setExpectantPosition(jobObjective.getPosition());
        resume.setExpectantIndustry(jobObjective.getIndustry());
    }

    private void convertResumeWorkingExpInformation(Context ctx, List<WorkExps> workExps, ResumeBaseRecInfo resume) throws BOSException {
        if (RecDBUtils.isEmpty(workExps)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u5de5\u4f5c\u7ecf\u9a8c\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        WorkingExpCollection workColl = new WorkingExpCollection();
        WorkingExpInfo workExp = null;
        AbstractWorkingExpInfo lastWork = null;
        for (WorkExps work : workExps) {
            workExp = new WorkingExpInfo();
            workExp.setResumeBase(resume);
            workExp.setCompany(work.getCompany());
            workExp.setIndustry(work.getIndustry());
            workExp.setDepartment(work.getDepartment());
            workExp.setPosition(work.getPosition());
            workExp.setJobDescription(work.getDetail());
            workExp.setUnitAddress(work.getCity());
            if (!StringUtils.isEmpty((CharSequence)work.getStartDate())) {
                workExp.setDateStart(DateConvertUtil.convertStrToDate(work.getStartDate()));
            }
            if (!StringUtils.isEmpty((CharSequence)work.getEndDate())) {
                workExp.setDateEnd(DateConvertUtil.convertStrToDate(work.getEndDate()));
            }
            workColl.add(workExp);
            if (lastWork != null && (lastWork.getDateStart() == null || workExp.getDateStart() == null || lastWork.getDateStart().getTime() - workExp.getDateStart().getTime() >= 0L) && (lastWork.getDateEnd() == null || workExp.getDateEnd() == null || lastWork.getDateEnd().getTime() - workExp.getDateEnd().getTime() >= 0L)) continue;
            lastWork = workExp;
        }
        resume.put("workExps", (Object)workColl);
        if (lastWork != null) {
            String industry;
            String company;
            String job = lastWork.getPosition();
            if (!StringUtils.isEmpty((CharSequence)job)) {
                resume.setLastJob(job);
            }
            if (!StringUtils.isEmpty((CharSequence)(company = lastWork.getCompany()))) {
                resume.setLastCompany(company);
            }
            if (!StringUtils.isEmpty((CharSequence)(industry = lastWork.getIndustry()))) {
                resume.setLastIndustry(industry);
            }
        }
    }

    private void convertResumeEduExp(Context ctx, List<EduExps> eduExps, ResumeBaseRecInfo resume) throws BOSException {
        if (RecDBUtils.isEmpty(eduExps)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u6559\u80b2\u7ecf\u9a8c\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        ITupuDictionary iTupuDictionary = TupuDictionaryFactory.getLocalInstance(ctx);
        EducationExpRECCollection eduExpColl = new EducationExpRECCollection();
        EducationExpRECInfo eduExpInfo = null;
        AbstractEducationExpRECInfo lastEduExpInfo = null;
        for (EduExps edu : eduExps) {
            String degree;
            String detail;
            eduExpInfo = new EducationExpRECInfo();
            eduExpInfo.setResumeBase(resume);
            eduExpInfo.setSchool(edu.getSchool());
            eduExpInfo.setMajor(edu.getMajor());
            if (!StringUtils.isEmpty((CharSequence)edu.getStartDate())) {
                eduExpInfo.setDateStart(DateConvertUtil.convertStrToDate(edu.getStartDate()));
            }
            if (!StringUtils.isEmpty((CharSequence)edu.getEndDate())) {
                eduExpInfo.setDateEnd(DateConvertUtil.convertStrToDate(edu.getEndDate()));
            }
            if (!StringUtils.isEmpty((CharSequence)(detail = edu.getDetail()))) {
                eduExpInfo.setMajorDescription(detail.length() > 500 ? detail.substring(0, 500) : detail);
            }
            if (!StringUtils.isEmpty((CharSequence)(degree = edu.getDegree()))) {
                TupuDictionaryCollection tupuDictionaryCollection = iTupuDictionary.getTupuDictionaryCollection("where type = 'degree' and tpName ='" + degree + "'");
                if (null != tupuDictionaryCollection && tupuDictionaryCollection.size() > 0) {
                    TupuDictionaryInfo tupuDictionaryInfo = tupuDictionaryCollection.get(0);
                    degree = tupuDictionaryInfo.getName();
                }
                DiplomaInfo dip = null;
                try {
                    dip = F7ConvertUtil.getDiplomaInfo(ctx, degree);
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (dip != null) {
                    eduExpInfo.setDegreeF7(dip);
                }
            }
            eduExpColl.add(eduExpInfo);
            if (lastEduExpInfo != null && (lastEduExpInfo.getDateStart() == null || eduExpInfo.getDateStart() == null || lastEduExpInfo.getDateStart().getTime() - eduExpInfo.getDateStart().getTime() >= 0L) && (lastEduExpInfo.getDateEnd() == null || eduExpInfo.getDateEnd() == null || lastEduExpInfo.getDateEnd().getTime() - eduExpInfo.getDateEnd().getTime() >= 0L)) continue;
            lastEduExpInfo = eduExpInfo;
        }
        resume.put("eduExps", (Object)eduExpColl);
        if (lastEduExpInfo != null) {
            if (resume.getHDegree() == null) {
                resume.setHDegree(lastEduExpInfo.getDegreeF7());
            }
            if (StringUtils.isEmpty((CharSequence)resume.getSchool())) {
                resume.setSchool(lastEduExpInfo.getSchool());
            }
            if (StringUtils.isEmpty((CharSequence)resume.getMajor())) {
                resume.setMajor(lastEduExpInfo.getMajor());
            }
        }
    }

    private void convertResumeProjectExp(Context ctx, List<ProjectExps> projectExps, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(projectExps)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u9879\u76ee\u7ecf\u5386\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        ProjectExpCollection projectExpColl = new ProjectExpCollection();
        ProjectExpInfo proExp = null;
        for (ProjectExps pro : projectExps) {
            proExp = new ProjectExpInfo();
            proExp.setResumeBase(resume);
            if (!StringUtils.isEmpty((CharSequence)pro.getStartDate())) {
                proExp.setDateStart(DateConvertUtil.convertStrToDate(pro.getStartDate()));
            }
            if (!StringUtils.isEmpty((CharSequence)pro.getEndDate()) && !pro.getEndDate().equals("\u81f3\u4eca")) {
                proExp.setDateEnd(DateConvertUtil.convertStrToDate(pro.getEndDate()));
            }
            proExp.setCustomer(pro.getName());
            proExp.setMainDuty(pro.getResponsibility());
            proExp.setPdescription(pro.getDetail());
            projectExpColl.add(proExp);
        }
        resume.put("projectExps", (Object)projectExpColl);
    }

    private void convertResumeTrainExp(Context ctx, List<TrainExperience> trainExps, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(trainExps)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u57f9\u8bad\u7ecf\u5386\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        TrainingExpCollection trainingExpColl = new TrainingExpCollection();
        TrainingExpInfo trainExp = null;
        for (TrainExperience train : trainExps) {
            trainExp = new TrainingExpInfo();
            trainExp.setResumeBaseInfo(resume);
            if (!StringUtils.isEmpty((CharSequence)train.start_time)) {
                trainExp.setDateStart(DateConvertUtil.convertStrToDate(train.start_time));
            }
            if (!StringUtils.isEmpty((CharSequence)train.stop_time)) {
                trainExp.setDateEnd(DateConvertUtil.convertStrToDate(train.stop_time));
            }
            trainExp.setTrainingInstitution(train.agent);
            trainExp.setCourseDescription(train.description);
            trainingExpColl.add(trainExp);
        }
        resume.put("trainExps", (Object)trainingExpColl);
    }

    private void convertResumeCredential(Context ctx, String certificate, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(certificate)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u83b7\u5956\u8bc1\u4e66\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        CredentialCollection creColl = new CredentialCollection();
        CredentialInfo credential = new CredentialInfo();
        credential.setResumeBase(resume);
        credential.setCredentialName(certificate.length() > 20 ? certificate.substring(0, 20) : certificate);
        creColl.add(credential);
        resume.put("credentials", (Object)creColl);
    }

    private void convertResumeLanguage(Context ctx, String langAbility, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(langAbility)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u8bed\u8a00\u80fd\u529b\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        LanguageAbilityCollection languageColl = new LanguageAbilityCollection();
        LanguageAbilityInfo languageAbility = new LanguageAbilityInfo();
        languageAbility.setResumeBase(resume);
        languageAbility.setLanguage(langAbility.length() > 50 ? langAbility.substring(0, 50) : langAbility);
        languageColl.add(languageAbility);
        resume.put("languages", (Object)languageColl);
    }

    private void convertResumeProfessionalSkills(Context ctx, String proSkill, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(proSkill)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u4e13\u4e1a\u6280\u80fd\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        ProfessionalSkillsCollection psColl = new ProfessionalSkillsCollection();
        ProfessionalSkillsInfo professionalSkills = new ProfessionalSkillsInfo();
        professionalSkills.setResumeBase(resume);
        professionalSkills.setSkillDescription(proSkill.length() > 200 ? proSkill.substring(0, 200) : proSkill);
        psColl.add(professionalSkills);
        resume.put("professionalSkills", (Object)psColl);
    }

    private void convertResumeWorksDemonstration(Context ctx, List<ExcellentWorks> excellentWorks, ResumeBaseRecInfo resume) {
        if (RecDBUtils.isEmpty(excellentWorks)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u4f5c\u54c1\u5c55\u793a\u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        WorksDemonstrationCollection wdColl = new WorksDemonstrationCollection();
        WorksDemonstrationInfo worksDemonstration = null;
        for (ExcellentWorks demo : excellentWorks) {
            worksDemonstration = new WorksDemonstrationInfo();
            worksDemonstration.setResumeBase(resume);
            worksDemonstration.setName(demo.name);
            if (!StringUtils.isEmpty((CharSequence)demo.time)) {
                worksDemonstration.setDate(DateConvertUtil.convertStrToDate(demo.time));
            }
            wdColl.add(worksDemonstration);
        }
        resume.put("workDemos", (Object)wdColl);
    }

    private void convertResumeOtherDesc(Context ctx, String otherDesc, ResumeBaseRecInfo resume) {
        if (StringUtils.isEmpty((CharSequence)otherDesc)) {
            if (logger.isDebugEnabled()) {
                logger.debug("***************\u5176\u4ed6 \u6570\u636e\u4e3a\u7a7a***************");
            }
            return;
        }
        ResumeOtherDescInfo resumeOtherDescInfo = new ResumeOtherDescInfo();
        resumeOtherDescInfo.setResumeBaseRec(resume);
        resumeOtherDescInfo.setOtherDesc(otherDesc);
        resume.put("other", resumeOtherDescInfo);
    }

    public boolean checkPermission(Context ctx, String departmentId, String hrOrgUnitId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Set userAdminRangeIdSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)userId, (String)RS_PERMITEM);
        Set userHROrgRangeIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)RS_PERMITEM);
        return userAdminRangeIdSet.contains(departmentId) && userHROrgRangeIdSet.contains(hrOrgUnitId);
    }

    private static class TupuResumePullerHolder {
        private static TupuResumePuller tupuResumePuller = new TupuResumePuller();

        private TupuResumePullerHolder() {
        }
    }
}

