/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.interviewGo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultCollection;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultFactory;
import com.kingdee.shr.recuritment.IPInterviewersCollection;
import com.kingdee.shr.recuritment.IPInterviewersFactory;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.app.util.job.RecSyncTaskThreadPool;
import com.kingdee.shr.recuritment.app.util.job.SendInterviewMsgRunnable;
import com.kingdee.shr.recuritment.utils.RecCloudHubUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendInterviewMsgService {
    private static Logger logger = LoggerFactory.getLogger(SendInterviewMsgService.class);
    private static SendInterviewMsgService sendInterviewMsgService;
    public final SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm\u5206");
    public static final String interviewGo = "interGo";
    public static final String title = "\u62db\u8058GO";

    private SendInterviewMsgService() {
    }

    public static synchronized SendInterviewMsgService getInstance() {
        if (sendInterviewMsgService == null) {
            sendInterviewMsgService = new SendInterviewMsgService();
        }
        return sendInterviewMsgService;
    }

    public Object sendInterviewMsg(Context ctx, String interviewPlanId, String[] interviewermanagementId, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5b89\u6392\u9762\u8bd5\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (interviewermanagementId != null && interviewermanagementId.length > 0) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id in (" + this.converUserIds(interviewermanagementId) + ")");
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object sendInterviewPlanByHR(Context ctx, String interviewPlanId, String[] interviewermanagementId) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5b89\u6392\u9762\u8bd5\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (interviewermanagementId != null && interviewermanagementId.length > 0) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id in (" + this.converUserIds(interviewermanagementId) + ")");
                return this.doSendInterviewPlanByHR(ctx, interviewPlanId, users);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object doSendInterviewPlanByHR(Context ctx, String interviewPlanId, String userIds) {
        try {
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                return this.doSendInterviewPlanByHR(ctx, interviewPlanId, users);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object sendInterviewInvitationByHR(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5b89\u6392\u9762\u8bd5\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u9080\u7ea6\u63d0\u9192.....");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("userIds===" + userIds);
                logger.debug("StringUtils.isEmpty(userIds)===" + StringUtils.isEmpty((CharSequence)userIds));
            }
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                String message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab{0}\u5b89\u6392\u4e3a\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u524d\u5f80\u62db\u8058go\u67e5\u770b\uff01";
                String url = this.getInterviewPageUrl(ctx, interviewPlanId);
                if (StringUtils.isEmpty((CharSequence)url)) {
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("============" + this.converUserIds(userIds));
                }
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                if (logger.isDebugEnabled()) {
                    logger.debug("============" + users.size());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("interviewPlanId=" + interviewPlanId);
                    logger.debug("title=\u62db\u8058GO");
                    logger.debug("message=" + message);
                    logger.debug("url=" + url);
                    logger.debug("users" + users);
                }
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object sendInterviewEvaluateByHR(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5b89\u6392\u9762\u8bd5\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u8bc4\u4ef7\u63d0\u9192.....");
        }
        try {
            String url = this.getEvaluatePageUrl(ctx, interviewPlanId);
            if (StringUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                String message = "\u3010\u62db\u8058go\u3011 \u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object doSendInterviewPlanByHR(Context ctx, String interviewPlanId, UserCollection users) throws BOSException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5b89\u6392\u9762\u8bd5\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        String message = "";
        String url = "";
        java.util.Date now = new java.util.Date();
        Date interviewTime = null;
        String querySql = "select IP.FInterviewTime as interviewTime from T_REC_InterviewPlan IP where IP.FID = ? ";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{interviewPlanId});
        if (rs1 != null) {
            while (rs1.next()) {
                interviewTime = rs1.getDate("interviewTime");
            }
        }
        if (interviewTime == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("\u9762\u8bd5\u73af\u8282Id:{0}\u9762\u8bd5\u4fe1\u606f\u672a\u521d\u59cb\u5316\uff0c\u6570\u636e\u5f02\u5e38\uff01", interviewPlanId));
            }
            return "";
        }
        if (now.before(interviewTime)) {
            message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab{0}\u5b89\u6392\u4e3a\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u524d\u5f80\u62db\u8058go\u67e5\u770b\uff01";
            url = this.getInterviewPageUrl(ctx, interviewPlanId);
        } else {
            message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab{0}\u5b89\u6392\u4e3a\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u524d\u5f80\u62db\u8058go\u67e5\u770b\uff01";
            url = this.getInterviewPageUrl(ctx, interviewPlanId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
            message = "\u3010\u62db\u8058go\u3011 \u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09";
            url = this.getEvaluatePageUrl(ctx, interviewPlanId);
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
        }
        return null;
    }

    public Object doCancelInterviewPlanByHR(Context ctx, String interviewPlanId, String[] userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u9080\u8bf7\u9762\u8bd5\u5b98\u8bc4\u4ef7\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (userIds != null && userIds.length > 0) {
                String url = this.getEvaluatePageUrl(ctx, interviewPlanId);
                if (StringUtils.isEmpty((CharSequence)url)) {
                    return null;
                }
                String message = "\u3010\u62db\u8058go\u3011\u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09";
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object deleteInterviewerByHR(Context ctx, String interviewPlanId, String[] userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5220\u9664\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (userIds != null && userIds.length > 0) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                String message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab\u53d6\u6d88\u53c2\u52a0\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\uff0c\u8bf7\u77e5\u6089\uff01";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users, "DeleteMessage"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object deleteInterviewerByHR(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("HR\u5220\u9664\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                String message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab\u53d6\u6d88\u53c2\u52a0\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\uff0c\u8bf7\u77e5\u6089\uff01";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users, "DeleteMessage"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object cancleInterviewInviteByHR(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug(" HR\u53d6\u6d88\u9080\u7ea6\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                String message = "\u3010\u62db\u8058go\u3011\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5df2\u53d6\u6d88\uff0c\u8bf7\u77e5\u6089\uff01";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object sendInterviewResult(Context ctx, String interviewPlanId, String interviewerId) {
        if (logger.isDebugEnabled()) {
            logger.debug("  \u9762\u8bd5\u5b98\u586b\u5199\u7ed3\u679c\u4e4b\u540e\u7ed9\u9762\u8bd5\u8ddf\u8e2a\u4eba\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            UserInfo interviewer;
            UserCollection users = new UserCollection();
            InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select *,lastUpdateUser.* where id = '" + interviewPlanId + "'");
            String contacterId = "";
            if (coll != null && coll.size() > 0) {
                contacterId = coll.get(0).getContacterId();
                if (!StringUtils.isEmpty((CharSequence)contacterId)) {
                    users.add(SendInterviewMsgService.getUserInfoByPersonId(ctx, contacterId));
                } else {
                    users.add(coll.get(0).getLastUpdateUser());
                }
            }
            if ((interviewer = SendInterviewMsgService.getUserInfoByPersonId(ctx, interviewerId)) != null) {
                String message = "\u3010\u62db\u8058go\u3011 \u9762\u8bd5\u5b98" + interviewer.getName() + "\u5df2\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff01";
                if (interviewerId.equals(contacterId)) {
                    message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff01";
                }
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static UserInfo getUserInfoByPersonId(Context ctx, String personId) throws BOSException {
        UserInfo userInfo;
        if (StringUtils.isEmpty((CharSequence)personId)) {
            return null;
        }
        UserCollection userColl = null;
        try {
            userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person = '" + personId + "'");
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (userColl != null && userColl.size() > 0 && (userInfo = userColl.get(0)) != null) {
            return userInfo;
        }
        return null;
    }

    public Object sendInterviewPlanResult(Context ctx, String interviewPlanId, String interviewResult) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed9\u67d0\u4e00\u4e2a\u9762\u8bd5\u73af\u8282\u7ed3\u679c\u544a\u77e5\u9762\u8bd5\u8ddf\u8e2a\u4eba\u548c\u9762\u8bd5\u5b89\u6392\u4eba\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            UserCollection users = new UserCollection();
            InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select *,lastUpdateUser.* where id = '" + interviewPlanId + "'");
            if (coll != null && coll.size() > 0) {
                InterviewPlanInfo interviewPlan = coll.get(0);
                String contacterId = interviewPlan.getContacterId();
                if (!StringUtils.isEmpty((CharSequence)contacterId)) {
                    users.add(SendInterviewMsgService.getUserInfoByPersonId(ctx, contacterId));
                } else {
                    users.add(interviewPlan.getLastUpdateUser());
                }
                String message = "";
                if ("3".equals(interviewResult) || "4".equals(interviewResult) || "5".equals(interviewResult)) {
                    if ("3".equals(interviewResult)) {
                        interviewResult = "\u901a\u8fc7";
                    } else if ("4".equals(interviewResult)) {
                        interviewResult = "\u4e0d\u901a\u8fc7";
                    } else if ("5".equals(interviewResult)) {
                        interviewResult = "\u653e\u5f03\u9762\u8bd5";
                    }
                    message = "\u3010\u62db\u8058go\u3011  \u5019\u9009\u4eba{1}\uff08{2}\uff09" + interviewPlan.getInterviewStageName() + "\u7ed3\u679c\u7cfb\u7edf\u5224\u5b9a" + interviewResult + "\uff0c\u8bf7\u60a8\u786e\u8ba4\uff01";
                } else if ("2".equals(interviewResult)) {
                    message = "\u3010\u62db\u8058go\u3011 \u9762\u8bd5\u5b98\u5df2\u63d0\u4ea4\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684" + interviewPlan.getInterviewStageName() + "\u7ed3\u679c\uff0c\u8bf7\u60a8\u786e\u8ba4\u7ed3\u679c\uff01";
                    IPInterviewStructureDetailResultCollection resultcoll = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId + "' and saveState = 0");
                    if (resultcoll.size() > 1) {
                        int size = resultcoll.size();
                        for (int i = 0; i < size; ++i) {
                            if (!"-1".equals(resultcoll.get(i).getResult())) continue;
                            message = "";
                        }
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object sendFinalInterviewPlanResult(Context ctx, String interviewPlanId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed9\u67d0\u4e00\u4e2a\u9762\u8bd5\u73af\u8282\u7ed3\u679c\u544a\u77e5\u9762\u8bd5\u8ddf\u8e2a\u4eba\u548c\u9762\u8bd5\u5b89\u6392\u4eba\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            UserCollection users = new UserCollection();
            InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection("select *,lastUpdateUser.* where id = '" + interviewPlanId + "'");
            if (coll != null && coll.size() > 0) {
                InterviewPlanInfo interviewPlan = coll.get(0);
                String contacterId = interviewPlan.getContacterId();
                if (!StringUtils.isEmpty((CharSequence)contacterId)) {
                    users.add(SendInterviewMsgService.getUserInfoByPersonId(ctx, contacterId));
                } else {
                    users.add(interviewPlan.getLastUpdateUser());
                }
                String message = "\u3010\u62db\u8058go\u3011 \u9762\u8bd5\u5b98\u5df2\u63d0\u4ea4\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684" + interviewPlan.getInterviewStageName() + "\u7ed3\u679c\uff0c\u8bf7\u60a8\u786e\u8ba4\u6700\u7ec8\u7ed3\u679c\uff01";
                IPInterviewStructureDetailResultCollection resultcoll = IPInterviewStructureDetailResultFactory.getLocalInstance(ctx).getIPInterviewStructureDetailResultCollection("where interviewPlanId = '" + interviewPlanId + "' and saveState = 0");
                if (resultcoll.size() > 1) {
                    int size = resultcoll.size();
                    for (int i = 0; i < size; ++i) {
                        if (!"-1".equals(resultcoll.get(i).getResult())) continue;
                        message = "";
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, users));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object AutoSendInterviewPlan(Context ctx, String interviewPlanId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b9a\u65f6\u4efb\u52a1\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            String url = this.getInterviewPageUrl(ctx, interviewPlanId);
            if (StringUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            StringBuilder interviewerIds = new StringBuilder();
            IPInterviewersCollection interviewers = IPInterviewersFactory.getLocalInstance(ctx).getIPInterviewersCollection("where interviewPlanId = '" + interviewPlanId + "'");
            if (interviewers != null && interviewers.size() > 0) {
                int size = interviewers.size();
                for (int i = 0; i < size; ++i) {
                    interviewerIds.append("'").append(interviewers.get(i).getInterviewerId()).append("'");
                    if (i >= size - 1) continue;
                    interviewerIds.append(",");
                }
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id in (" + interviewerIds.toString() + ")");
                String message = "\u4e00\u4e2a\u5c0f\u65f6\uff08{3}\uff09\u540e\u60a8\u6709\u4e00\u4e2a\u9762\u8bd5\uff1a\u5019\u9009\u4eba{1}\uff08{2}\uff09\uff0c\u8bf7\u5b89\u6392\u597d\u65f6\u95f4\uff01";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object AutoSendInterviewPlanToContacter(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b9a\u65f6\u4efb\u52a1\u7ed9\u9762\u8bd5\u8054\u7cfb\u4eba\u53d1\u9001\u9762\u8bd5\u63d0\u9192.....");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                String url = this.getInterviewPageUrl(ctx, interviewPlanId);
                if (StringUtils.isEmpty((CharSequence)url)) {
                    return null;
                }
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                String message = "\u4e00\u4e2a\u5c0f\u65f6\uff08{3}\uff09\u540e\u60a8\u8ddf\u8e2a\u7684\u9762\u8bd5\u5c06\u5f00\u59cb\uff1a\u5019\u9009\u4eba{1}\uff08{2}\uff09\uff0c\u8bf7\u5b89\u6392\u597d\u65f6\u95f4\uff01";
                RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Object AutoSendInterviewEvaluate(Context ctx, String interviewPlanId, String userIds) {
        if (logger.isDebugEnabled()) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u8bc4\u4ef7\u63d0\u9192.....");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                String message = "\u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09";
                String url = this.getEvaluatePageUrl(ctx, interviewPlanId);
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where id in (" + this.converUserIds(userIds) + ")");
                    if (logger.isDebugEnabled()) {
                        logger.error("\u5b9a\u65f6\u4efb\u52a1\u7ed9\u9762\u8bd5\u5b98\u53d1\u9001\u8bc4\u4ef7\u63d0\u9192.....");
                    }
                    RecSyncTaskThreadPool.getInstance().submitAsyncTask(new SendInterviewMsgRunnable(ctx, interviewPlanId, title, message, url, users, "InterviewResult"));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getInterviewPageUrl(Context ctx, String billId) {
        StringBuilder url = new StringBuilder(RecCloudHubUtil.getCloudHubServerUrl(ctx));
        try {
            billId = URLEncoder.encode(URLEncoder.encode(billId, "utf-8"), "utf-8");
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            if (StringUtils.isEmpty((CharSequence)eid)) {
                return null;
            }
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String storeEid = RecCloudHubUtil.getStoreEid(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)storeEid)) {
                url.append("storeEid=").append(storeEid).append("&");
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            url.append("appid=").append(appId).append("&eid=").append(eid).append("&path=interGo" + RecCloudHubUtil.getCloudHubAppVersion(ctx) + "&name=00.custom#/resume_detail?recordId=").append(billId);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return url.toString();
    }

    private String getEvaluatePageUrl(Context ctx, String billId) {
        StringBuilder url = new StringBuilder(RecCloudHubUtil.getCloudHubServerUrl(ctx));
        try {
            billId = URLEncoder.encode(URLEncoder.encode(billId, "utf-8"), "utf-8");
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            if (StringUtils.isEmpty((CharSequence)eid)) {
                return null;
            }
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String storeEid = RecCloudHubUtil.getStoreEid(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)storeEid)) {
                url.append("storeEid=").append(storeEid).append("&");
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            url.append("appid=").append(appId).append("&eid=").append(eid).append("&eid=" + eid + "&path=interGo" + RecCloudHubUtil.getCloudHubAppVersion(ctx) + "&name=00.custom#/judge_page?recordId=").append(billId);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return url.toString();
    }

    private String converUserIds(String userIds) {
        String[] ids = userIds.split(";");
        StringBuilder user_ids = new StringBuilder();
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            user_ids.append("'").append(ids[i]).append("'");
            if (i >= size - 1) continue;
            user_ids.append(",");
        }
        return user_ids.toString();
    }

    private String converUserIds(String[] ids) {
        StringBuilder user_ids = new StringBuilder();
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            user_ids.append("'").append(ids[i]).append("'");
            if (i >= size - 1) continue;
            user_ids.append(",");
        }
        return user_ids.toString();
    }
}

