/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.interviewGo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.recuritment.IWaitHandlerMsg;
import com.kingdee.shr.recuritment.WaitHandlerMsgCollection;
import com.kingdee.shr.recuritment.WaitHandlerMsgFactory;
import com.kingdee.shr.recuritment.WaitHandlerMsgInfo;
import com.kingdee.shr.recuritment.app.util.RecOsfUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecCloudHubUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WaitHandlerMsgService {
    private static Logger logger = Logger.getLogger(WaitHandlerMsgService.class);
    public final SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm\u5206");
    public static final String interviewGo = "interGo";
    public static final String TIME_HELPER_SEC = "TIME_HELPER_SEC";
    public static String SERVERURL = "https://www.yunzhijia.com";
    public static String GETTOKENAPIURL = "/gateway/oauth2/token/getAccessToken";
    public static String SENDMESSAGE = "/gateway/newtodo/open/generatetodo.json";
    public static String DELETEMSG = "/gateway/newtodo/open/action.json";
    public static String HEADIMGURL = "https://www.yunzhijia.com/space/c/photo/load?id=5a2f7ad750f8dd7810e79981";
    public static final String DEFAULT_CHARSET = "utf-8";
    public static String CREATESCHEDULE = "/gateway/cloudwork/newwork/create";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SO_TIMEOUT = 30000;

    public static WaitHandlerMsgService getInstance() {
        return WaitHandlerMsgHolder.service;
    }

    public String getAccessToken(Context ctx, String appId, String secret) {
        try {
            JSONObject tokenJson;
            int errcode;
            JSONObject param = new JSONObject();
            if (StringUtils.isEmpty((CharSequence)secret)) {
                return null;
            }
            param.put("appId", (Object)appId);
            param.put("secret", (Object)secret);
            param.put("timestamp", System.currentTimeMillis());
            param.put("scope", (Object)"app");
            String tokenResult = RecDBUtils.jsonPost(RecCloudHubUtil.getServerUrl() + GETTOKENAPIURL, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\u8fd4\u56de\u503c\uff1a" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                JSONObject data = tokenJson.getJSONObject("data");
                String access_token = data.getString("accessToken");
                return access_token;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private String getAccessToken(Context ctx) {
        try {
            JSONObject tokenJson;
            int errcode;
            JSONObject param = new JSONObject();
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String secret = RecCloudHubUtil.getTimeHelperSecret(eid, interviewGo);
            if (StringUtils.isEmpty((CharSequence)secret)) {
                logger.error((Object)" \u672a\u914d\u7f6e\u65f6\u95f4\u52a9\u624b\u79d8\u94a5\uff01");
                return null;
            }
            param.put("eid", (Object)eid);
            param.put("secret", (Object)secret);
            param.put("timestamp", System.currentTimeMillis());
            param.put("scope", (Object)"resGroupSecret");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken");
            }
            String tokenResult = RecDBUtils.jsonPost(RecCloudHubUtil.getServerUrl() + GETTOKENAPIURL, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken\u8fd4\u56de\u503c\uff1a" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                JSONObject data = tokenJson.getJSONObject("data");
                String access_token = data.getString("accessToken");
                return access_token;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public boolean sendMsg(Context ctx, String contacterId, UserCollection users, String content, String url, String relationId) {
        try {
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String timeSecret = RecCloudHubUtil.getTimeHelperSecret(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)timeSecret)) {
                logger.error((Object)"\u521b\u5efa\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a\u672a\u914d\u7f6e\u65f6\u95f4\u52a9\u624b\u79d8\u94a5\uff01");
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)contacterId) && StringUtils.isEmpty((CharSequence)(contacterId = HRFilterUtils.getCurrentPersonId((Context)ctx)))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\u521b\u5efa\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5173\u8054\u5458\u5de5\u4fe1\u606f\uff01");
                }
                return false;
            }
            String senderId = RecOsfUtil.getOpenIDByPersonID(ctx, contacterId);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String secret = RecCloudHubUtil.getAppSecret(eid, interviewGo);
            String accessToken = this.getAccessToken(ctx, appId, secret);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\uff1a" + accessToken));
            }
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return false;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + SENDMESSAGE + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            param.put("title", (Object)"\u62db\u8058GO");
            param.put("itemtitle", (Object)"\u62db\u8058GO");
            param.put("content", (Object)content);
            param.put("appId", (Object)appId);
            param.put("senderId", (Object)senderId);
            param.put("headImg", (Object)HEADIMGURL);
            param.put("url", (Object)url);
            String sourceId = String.valueOf(System.currentTimeMillis());
            param.put("sourceId", (Object)sourceId);
            JSONArray sendpersons = new JSONArray();
            JSONObject status = new JSONObject();
            status.put("DO", 0);
            status.put("READ", 0);
            ArrayList<String> openIDs = this.getOpenIDByPersonID(ctx, users);
            for (String openID : openIDs) {
                JSONObject sendperson = new JSONObject();
                sendperson.put("openId", (Object)openID);
                sendperson.put("status", (Object)status);
                sendpersons.put((Object)sendperson);
            }
            param.put("params", (Object)sendpersons);
            if (logger.isDebugEnabled()) {
                logger.error((Object)("\u4ee3\u529e\u6d88\u606f url:" + apiUrl + " \u8bf7\u6c42\u53c2\u6570\uff1a" + param.toString()));
            }
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4ee3\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            }
            logger.error((Object)("\u4ee3\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            JSONObject tokenJson = new JSONObject(tokenResult);
            int errcode = tokenJson.getInt("errorCode");
            if (errcode == 0) {
                this.addMsg(ctx, content, senderId, appId, sourceId, openIDs, relationId);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u521b\u5efa\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean sendMsg(Context ctx, UserCollection users, String content, String createId, String resumeApproverId, String url, boolean sendSchedule) {
        try {
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            if (sendSchedule) {
                this.createSchedule(ctx, users, content, createId);
            }
            String senderId = RecOsfUtil.getOpenIDByPersonID(ctx, createId);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String secret = RecCloudHubUtil.getAppSecret(eid, interviewGo);
            String accessToken = this.getAccessToken(ctx, appId, secret);
            logger.error((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\uff1a" + accessToken));
            logger.error((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684secret\uff1a" + secret));
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return false;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + SENDMESSAGE + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            param.put("title", (Object)"\u62db\u8058GO");
            param.put("itemtitle", (Object)"\u62db\u8058GO");
            param.put("content", (Object)content);
            param.put("appId", (Object)appId);
            param.put("senderId", (Object)senderId);
            param.put("headImg", (Object)HEADIMGURL);
            param.put("url", (Object)url);
            String sourceId = String.valueOf(System.currentTimeMillis());
            param.put("sourceId", (Object)sourceId);
            JSONArray sendpersons = new JSONArray();
            JSONObject status = new JSONObject();
            status.put("DO", 0);
            status.put("READ", 0);
            ArrayList<String> openIDs = this.getOpenIDByPersonID(ctx, users);
            for (String openID : openIDs) {
                JSONObject sendperson = new JSONObject();
                sendperson.put("openId", (Object)openID);
                sendperson.put("status", (Object)status);
                sendpersons.put((Object)sendperson);
            }
            param.put("params", (Object)sendpersons);
            logger.error((Object)("\u4ee3\u529e\u6d88\u606f url:" + apiUrl + " \u8bf7\u6c42\u53c2\u6570\uff1a" + param.toString()));
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            logger.error((Object)("\u4ee3\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            JSONObject tokenJson = new JSONObject(tokenResult);
            int errcode = tokenJson.getInt("errorCode");
            if (errcode == 0) {
                this.addMsg(ctx, content, senderId, appId, sourceId, openIDs, resumeApproverId);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u521b\u5efa\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public String createSchedule(Context ctx, UserCollection userCol, String content, String createId) {
        try {
            if (userCol == null || userCol.size() == 0) {
                logger.info((Object)"\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u83b7\u53d6\u7528\u6237\u4e3a\u7a7a!");
                return null;
            }
            StringBuilder personIds = new StringBuilder();
            for (int i = 0; i < userCol.size(); ++i) {
                personIds.append(userCol.get(i).getPerson().getId().toString()).append(";");
            }
            if (!StringUtils.isEmpty((CharSequence)personIds.toString())) {
                personIds = new StringBuilder(personIds.substring(0, personIds.length() - 1));
            }
            String accessToken = this.getAccessToken(ctx);
            logger.info((Object)"\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken");
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return null;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + CREATESCHEDULE + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            JSONArray array = new JSONArray();
            ArrayList<String> openIDs = RecOsfUtil.getOpenIDsByPersonID(ctx, personIds.toString());
            for (String openID : openIDs) {
                array.put((Object)openID);
            }
            param.put("actors", (Object)array);
            param.put("content", (Object)content);
            param.put("openid", (Object)RecOsfUtil.getOpenIDByPersonID(ctx, createId));
            param.put("startDate", new Date().getTime());
            param.put("topState", 1);
            param.put("noticeTime", 0);
            param.put("submitExperience", false);
            logger.info((Object)"\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b");
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            logger.info((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u8fd4\u56de\u503c" + tokenResult));
            JSONObject tokenJson = new JSONObject(tokenResult);
            int errcode = tokenJson.getInt("errorCode");
            if (errcode == 0) {
                JSONObject data = tokenJson.getJSONObject("data");
                String workId = data.getString("workId");
                return workId;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return null;
    }

    private void addMsg(Context ctx, String content, String senderId, String appId, String sourceId, ArrayList<String> openIDs, String relationId) throws BOSException, EASBizException {
        WaitHandlerMsgInfo msg = new WaitHandlerMsgInfo();
        msg.setSourceId(sourceId);
        msg.setAppId(appId);
        msg.setSenderId(senderId);
        msg.setContent(content);
        msg.setOpenIds(StringUtils.join((Object[])openIDs.toArray(), (String)","));
        msg.setRelationId(relationId);
        WaitHandlerMsgFactory.getLocalInstance(ctx).addnew(msg);
    }

    public boolean deleteMsg(Context ctx, String relationId, UserCollection users) {
        try {
            IWaitHandlerMsg iWaitHandlerMsg = WaitHandlerMsgFactory.getLocalInstance(ctx);
            WaitHandlerMsgCollection coll = iWaitHandlerMsg.getWaitHandlerMsgCollection("where relationId = '" + relationId + "'");
            if (coll.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5220\u9664\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a\u5f53\u524d\u5173\u8054relationId " + relationId + " \u4e0d\u5b58\u5728\u4ee3\u529e\u6d88\u606f"));
                }
                return false;
            }
            WaitHandlerMsgInfo msg = coll.get(0);
            String sendOpenids = msg.getOpenIds();
            ArrayList<String> openIDs = this.getOpenIDByPersonID(ctx, users);
            for (int i = 0; i < openIDs.size(); ++i) {
                if (sendOpenids.contains(openIDs.get(i))) continue;
                openIDs.remove(openIDs.get(i));
            }
            if (openIDs.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5220\u9664\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a\u5f53\u524d\u5173\u8054relationId " + relationId + " \u6ca1\u6709\u53ef\u4ee5\u5220\u9664\u7684openId"));
                }
                return false;
            }
            boolean result = this.deleteMsg(ctx, msg.getSourceId(), StringUtils.join((Object[])openIDs.toArray(), (String)","));
            ArrayList<String> extOpenIDs = new ArrayList<String>(Arrays.asList(sendOpenids.split(",")));
            for (String openId : openIDs) {
                if (!extOpenIDs.contains(openId)) continue;
                extOpenIDs.remove(openId);
            }
            if (extOpenIDs.isEmpty()) {
                iWaitHandlerMsg.delete((IObjectPK)new ObjectUuidPK(msg.getId().toString()));
            } else {
                msg.setOpenIds(StringUtils.join((Object[])extOpenIDs.toArray(), (String)","));
                iWaitHandlerMsg.update((IObjectPK)new ObjectUuidPK(msg.getId().toString()), msg);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u5220\u9664\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage()));
            return false;
        }
    }

    public boolean deleteMsg(Context ctx, String sourceitemid, String openids) {
        try {
            JSONObject tokenJson;
            int errcode;
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String secret = RecCloudHubUtil.getAppSecret(eid, interviewGo);
            String accessToken = this.getAccessToken(ctx, appId, secret);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\uff1a" + accessToken));
            }
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return false;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + DELETEMSG + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            param.put("sourceitemid", (Object)sourceitemid);
            param.put("sourcetype", (Object)appId);
            JSONObject actiontype = new JSONObject();
            actiontype.put("delete", 1);
            param.put("actiontype", (Object)actiontype);
            JSONArray openidArr = new JSONArray(Arrays.asList(openids.split(",")));
            param.put("openids", (Object)openidArr);
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5220\u9664\u4ee3\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u5220\u9664\u4ee3\u529e\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return false;
    }

    public boolean dealMsg(Context ctx, String relationId, UserCollection users) {
        try {
            IWaitHandlerMsg iWaitHandlerMsg = WaitHandlerMsgFactory.getLocalInstance(ctx);
            WaitHandlerMsgCollection coll = iWaitHandlerMsg.getWaitHandlerMsgCollection("where relationId = '" + relationId + "'");
            if (coll.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4ee3\u529e\u6d88\u606f\u53d8\u5df2\u529e\u5931\u8d25\uff1a\u5f53\u524d\u5173\u8054relationId " + relationId + " \u4e0d\u5b58\u5728\u4ee3\u529e\u6d88\u606f"));
                }
                return false;
            }
            WaitHandlerMsgInfo msg = coll.get(0);
            String sendOpenids = msg.getOpenIds();
            ArrayList<String> openIDs = this.getOpenIDByPersonID(ctx, users);
            for (int i = 0; i < openIDs.size(); ++i) {
                if (sendOpenids.contains(openIDs.get(i))) continue;
                openIDs.remove(openIDs.get(i));
            }
            if (openIDs.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4ee3\u529e\u6d88\u606f\u53d8\u5df2\u529e\u5931\u8d25\uff1a\u5f53\u524d\u5173\u8054relationId " + relationId + " \u6ca1\u6709\u53ef\u4ee5\u5220\u9664\u7684openId"));
                }
                return false;
            }
            boolean result = this.dealMsg(ctx, msg.getSourceId(), StringUtils.join((Object[])openIDs.toArray(), (String)","));
            ArrayList<String> extOpenIDs = new ArrayList<String>(Arrays.asList(sendOpenids.split(",")));
            for (String openId : openIDs) {
                if (!extOpenIDs.contains(openId)) continue;
                extOpenIDs.remove(openId);
            }
            if (extOpenIDs.isEmpty()) {
                iWaitHandlerMsg.delete((IObjectPK)new ObjectUuidPK(msg.getId().toString()));
            } else {
                msg.setOpenIds(StringUtils.join((Object[])extOpenIDs.toArray(), (String)","));
                iWaitHandlerMsg.update((IObjectPK)new ObjectUuidPK(msg.getId().toString()), msg);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u4ee3\u529e\u6d88\u606f\u53d8\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage()));
            return false;
        }
    }

    public boolean dealMsg(Context ctx, String sourceitemid, String openids) {
        try {
            JSONObject tokenJson;
            int errcode;
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String secret = RecCloudHubUtil.getAppSecret(eid, interviewGo);
            String accessToken = this.getAccessToken(ctx, appId, secret);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u4ee3\u529e\u6d88\u606f\u7684AccessToken\uff1a" + accessToken));
            }
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return false;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + DELETEMSG + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            param.put("sourceitemid", (Object)sourceitemid);
            param.put("sourcetype", (Object)appId);
            JSONObject actiontype = new JSONObject();
            actiontype.put("read", 1);
            actiontype.put("deal", 1);
            param.put("actiontype", (Object)actiontype);
            JSONArray openidArr = new JSONArray(Arrays.asList(openids.split(",")));
            param.put("openids", (Object)openidArr);
            param.put("sync", true);
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            logger.error((Object)("\u5df2\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5df2\u529e\u6d88\u606f\u8fd4\u56de\u503c" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 200) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u4ee3\u529e\u6d88\u606f\u53d8\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getOpenIDByPersonID(Context ctx, UserCollection users) {
        ArrayList<String> openIDs = new ArrayList<String>();
        if (users == null || users.size() == 0) {
            return openIDs;
        }
        StringBuilder ids = new StringBuilder();
        String personIds = "";
        int size = users.size();
        for (int i = 0; i < size; ++i) {
            ids.append("'").append(users.get(i).getId().toString()).append("'").append(",");
        }
        if (!StringUtils.isEmpty((CharSequence)ids.toString())) {
            personIds = ids.substring(0, ids.length() - 1).toString();
        }
        String querySql = "SELECT FXtId FROM t_pm_easxtusermap WHERE FUserId in (" + personIds + ")";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[0]);
            while (rs != null && rs.next()) {
                String fXtId = rs.getString("FXtId");
                if (StringUtils.isEmpty((CharSequence)fXtId)) continue;
                openIDs.add(fXtId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return openIDs;
    }

    private static class WaitHandlerMsgHolder {
        private static WaitHandlerMsgService service = new WaitHandlerMsgService();

        private WaitHandlerMsgHolder() {
        }
    }
}

