/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.sms;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.recuritment.RecSmsInvokeCollection;
import com.kingdee.shr.recuritment.RecSmsInvokeFactory;
import com.kingdee.shr.recuritment.SmsSendRecordFactory;
import com.kingdee.shr.recuritment.SmsSendRecordInfo;
import com.kingdee.shr.recuritment.YesOrNoEnum;
import com.kingdee.shr.recuritment.app.service.sms.vo.CheckInfo;
import com.kingdee.shr.recuritment.app.service.sms.vo.Sms;
import com.kingdee.shr.recuritment.app.service.sms.vo.SmsResponse;
import com.kingdee.shr.recuritment.app.util.HttpUtil;
import com.kingdee.shr.recuritment.app.util.SensitiveDataUtil;
import com.kingdee.shr.recuritment.utils.CloudServiceUtil;
import com.kingdee.shr.recuritment.utils.RecBaseUtils;
import com.kingdee.shr.recuritment.utils.RecCommonSmsStrategy;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import com.kingdee.shr.smsplatform.service.SMSSendEntry;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SmsService {
    private static Logger logger = LoggerFactory.getLogger(SmsService.class);
    public static final String SEND_SUCCESS_CODE = "0";

    public static SmsResponse sendSms(Context ctx, Sms sms) {
        if (logger.isDebugEnabled()) {
            logger.error("SmsService.sendSms:" + sms);
        }
        logger.info("\u53d1\u9001\u77ed\u4fe1:" + sms.getService() + "\uff0c\u624b\u673a\u53f7\u7801\uff1a" + SensitiveDataUtil.coverMobile(sms.getPhone()));
        String checkRes = SmsService.checkSms(sms);
        SmsResponse response = new SmsResponse();
        if (StringUtils.isNotEmpty((CharSequence)checkRes)) {
            response.setIs_success("false");
            response.setCode("-1");
            response.setUuid(checkRes);
            return response;
        }
        String smsCode = SmsService.getSmsCode(ctx, sms.getService());
        logger.error("SmsService.sendSms:" + smsCode);
        if (StringUtils.isEmpty((CharSequence)smsCode)) {
            SmsResponse smsResp = null;
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("checkinfo", CheckInfo.getInstance().toString());
                params.put("sms", sms.toString());
                if (logger.isDebugEnabled()) {
                    logger.error("\u4f7f\u7528\u65e7\u65b9\u5f0f\u53d1\u9001\u77ed\u4fe1\uff0c\u53c2\u6570\uff1a" + params);
                }
                String SEND_SMS_URL = CloudServiceUtil.getServiceUrl(ctx, "100");
                String resp = HttpUtil.post(ctx, SEND_SMS_URL, params);
                logger.error("\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c\uff1a" + resp);
                if (!RecBaseUtils.isEmpty(resp)) {
                    JSONObject jsonObj = JSONObject.fromObject((Object)resp);
                    smsResp = (SmsResponse)JSONObject.toBean((JSONObject)jsonObj, SmsResponse.class);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return smsResp;
        }
        Map<String, Object> sendRes = SmsService.doSendSms(ctx, sms, smsCode);
        logger.error("\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c\uff1a" + sendRes);
        SmsService.saveSendRecord(ctx, sms, sendRes);
        SmsResponse smsResponse = new SmsResponse();
        Object state = sendRes.get("state");
        smsResponse.setIs_success(state != null && state.toString().equals(SEND_SUCCESS_CODE) ? "true" : "false");
        smsResponse.setCode(state != null ? state.toString() : "-1");
        Object responseMsg = sendRes.get("responseMsg");
        smsResponse.setUuid(responseMsg != null ? responseMsg.toString() : "");
        return smsResponse;
    }

    private static void saveSendRecord(Context ctx, Sms sms, Map<String, Object> sendRes) {
        try {
            SmsSendRecordInfo record = new SmsSendRecordInfo();
            record.setRecCode(sms.getService());
            record.setReceiver(sms.getPhone());
            record.setContent(sms.getContent());
            Object responseMsg = sendRes.get("responseMsg");
            record.setRes(responseMsg != null ? responseMsg.toString() : "");
            Object state = sendRes.get("state");
            record.setState(state != null && state.toString().equals(SEND_SUCCESS_CODE) ? YesOrNoEnum.YES : YesOrNoEnum.NO);
            record.setSender(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            SmsSendRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)record);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String checkSms(Sms sms) {
        String recCode;
        StringBuilder errorMsg = new StringBuilder("");
        String phone = sms.getPhone();
        if (StringUtils.isEmpty((CharSequence)phone)) {
            errorMsg.append("phone can't empty");
        }
        if (StringUtils.isEmpty((CharSequence)(recCode = sms.getService()))) {
            errorMsg.append("recCode can't empty");
        }
        if (errorMsg.length() > 0) {
            return errorMsg.toString();
        }
        return "";
    }

    private static Map<String, Object> doSendSms(Context ctx, Sms sms, String smsCode) {
        HashMap<String, String> queryParamsCondition = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)sms.getBillId())) {
            if (sms.getService().equals("Recruit0019") || sms.getService().equals("Recruit0017") || sms.getService().equals("Recruit0008")) {
                queryParamsCondition.put("resumeId", sms.getBillId());
            } else {
                queryParamsCondition.put("id", sms.getBillId());
            }
        }
        Map<Object, Object> presetParValMap = new HashMap();
        if (!CollectionUtils.isEmpty(sms.getDefaultParam())) {
            presetParValMap = sms.getDefaultParam();
        }
        Map<Object, Object> cloudParams = new HashMap();
        if (!CollectionUtils.isEmpty(sms.getCloudParam())) {
            cloudParams = sms.getCloudParam();
        }
        HashMap customParams = new HashMap();
        Object[] mapObjs = new Object[]{presetParValMap, queryParamsCondition, cloudParams, customParams};
        Map sendSMS = SMSSendEntry.sendSMS((ISMSStrategy)new RecCommonSmsStrategy(smsCode, sms.getPhone(), sms.getHrOrgUnitId(), mapObjs), (Context)ctx);
        if (logger.isDebugEnabled()) {
            logger.error("\u77ed\u4fe1\u670d\u52a1\u7ed3\u679c:" + sendSMS);
        }
        sendSMS.put("state", sendSMS.get("code"));
        sendSMS.put("responseMsg", sendSMS.get("errMsg"));
        return sendSMS;
    }

    protected static String getSmsCode(Context ctx, String recCode) {
        String res;
        block4: {
            res = "";
            if (StringUtils.isEmpty((CharSequence)recCode)) {
                return res;
            }
            try {
                RecSmsInvokeCollection collection = RecSmsInvokeFactory.getLocalInstance(ctx).getRecSmsInvokeCollection("select smsCode where recCode='" + recCode + "'");
                if (collection.size() > 0) {
                    res = collection.get(0).getSmsCode();
                }
            }
            catch (BOSException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.error("[recSms] it is failed to get sms config!", (Throwable)e);
            }
        }
        return res;
    }
}

